/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.offlinemode.storage;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.stripe.offlinemode.storage.DateTimeConverter;
import com.stripe.offlinemode.storage.OfflinePaymentIntentRequestDao;
import com.stripe.offlinemode.storage.OfflinePaymentIntentRequestEntity;
import com.stripe.proto.model.offline_mode.OfflinePaymentIntentRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class OfflinePaymentIntentRequestDao_Impl
implements OfflinePaymentIntentRequestDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<OfflinePaymentIntentRequestEntity> __insertionAdapterOfOfflinePaymentIntentRequestEntity;
    private final DateTimeConverter __dateTimeConverter = new DateTimeConverter();
    private final EntityDeletionOrUpdateAdapter<OfflinePaymentIntentRequestEntity> __deletionAdapterOfOfflinePaymentIntentRequestEntity;
    private final SharedSQLiteStatement __preparedStmtOfUpdatePaymentIntentId;
    private final SharedSQLiteStatement __preparedStmtOfDeleteByOfflineOrPaymentIntentId;
    private final SharedSQLiteStatement __preparedStmtOfRestoreSoftDeletedPayments;
    private final SharedSQLiteStatement __preparedStmtOfDeleteOrphanedPayments;
    private final SharedSQLiteStatement __preparedStmtOfDeleteByRowId;

    public OfflinePaymentIntentRequestDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfOfflinePaymentIntentRequestEntity = new EntityInsertionAdapter<OfflinePaymentIntentRequestEntity>(__db){

            public String createQuery() {
                return "INSERT OR ABORT INTO `offline_payment_intent` (`offline_id`,`connection_id`,`payment_intent_id`,`account_id`,`type`,`deleted`,`data_blob`,`iv_blob`,`created_timestamp`,`id`) VALUES (?,?,?,?,?,?,?,?,?,nullif(?, 0))";
            }

            public void bind(SupportSQLiteStatement stmt, OfflinePaymentIntentRequestEntity value) {
                if (value.getOfflineId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getOfflineId());
                }
                stmt.bindLong(2, value.getConnectionId());
                if (value.getPaymentIntentId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getPaymentIntentId());
                }
                if (value.getAccountId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getAccountId());
                }
                if (value.getType() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, OfflinePaymentIntentRequestDao_Impl.this.__PaymentIntentRequestType_enumToString(value.getType()));
                }
                int _tmp = value.getDeleted() ? 1 : 0;
                stmt.bindLong(6, (long)_tmp);
                if (value.getEncryptedData() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindBlob(7, value.getEncryptedData());
                }
                if (value.getEncryptionIv() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindBlob(8, value.getEncryptionIv());
                }
                long _tmp_1 = OfflinePaymentIntentRequestDao_Impl.this.__dateTimeConverter.toTimeMs(value.getCreated());
                stmt.bindLong(9, _tmp_1);
                stmt.bindLong(10, value.getId());
            }
        };
        this.__deletionAdapterOfOfflinePaymentIntentRequestEntity = new EntityDeletionOrUpdateAdapter<OfflinePaymentIntentRequestEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `offline_payment_intent` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, OfflinePaymentIntentRequestEntity value) {
                stmt.bindLong(1, value.getId());
            }
        };
        this.__preparedStmtOfUpdatePaymentIntentId = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "\n            UPDATE offline_payment_intent\n                SET payment_intent_id = ?, data_blob = ?, iv_blob = ?\n                    WHERE id = ? \n                        AND account_id = ? \n                        AND connection_id = ?\n                        AND type = ?\n                        AND (offline_id = ? OR (offline_id IS NULL AND ? IS NULL))\n        ";
                return "\n            UPDATE offline_payment_intent\n                SET payment_intent_id = ?, data_blob = ?, iv_blob = ?\n                    WHERE id = ? \n                        AND account_id = ? \n                        AND connection_id = ?\n                        AND type = ?\n                        AND (offline_id = ? OR (offline_id IS NULL AND ? IS NULL))\n        ";
            }
        };
        this.__preparedStmtOfDeleteByOfflineOrPaymentIntentId = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM offline_payment_intent WHERE offline_id = ? OR payment_intent_id = ?";
                return "DELETE FROM offline_payment_intent WHERE offline_id = ? OR payment_intent_id = ?";
            }
        };
        this.__preparedStmtOfRestoreSoftDeletedPayments = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE offline_payment_intent SET deleted = 0 WHERE account_id = ?";
                return "UPDATE offline_payment_intent SET deleted = 0 WHERE account_id = ?";
            }
        };
        this.__preparedStmtOfDeleteOrphanedPayments = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "\n        WITH UnProcessedOfflineIds AS (\n            SELECT offline_id \n                FROM offline_payment_intent \n                    WHERE account_id = ? \n                        AND type = 'PROCESS_PAYMENT_INTENT' \n                        AND offline_id IS NOT NULL\n        ), ForwardedCreateRows AS (\n            SELECT id \n                FROM offline_payment_intent \n                    WHERE account_id = ? \n                        AND type = 'CREATE_PAYMENT_INTENT' \n                        AND NOT (payment_intent_id IS NULL OR payment_intent_id = '')\n        )\n        DELETE \n            FROM offline_payment_intent \n                WHERE id IN ForwardedCreateRows \n                    AND created_timestamp < ? \n                    AND offline_id NOT IN UnProcessedOfflineIds\n        ";
                return "\n        WITH UnProcessedOfflineIds AS (\n            SELECT offline_id \n                FROM offline_payment_intent \n                    WHERE account_id = ? \n                        AND type = 'PROCESS_PAYMENT_INTENT' \n                        AND offline_id IS NOT NULL\n        ), ForwardedCreateRows AS (\n            SELECT id \n                FROM offline_payment_intent \n                    WHERE account_id = ? \n                        AND type = 'CREATE_PAYMENT_INTENT' \n                        AND NOT (payment_intent_id IS NULL OR payment_intent_id = '')\n        )\n        DELETE \n            FROM offline_payment_intent \n                WHERE id IN ForwardedCreateRows \n                    AND created_timestamp < ? \n                    AND offline_id NOT IN UnProcessedOfflineIds\n        ";
            }
        };
        this.__preparedStmtOfDeleteByRowId = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM offline_payment_intent WHERE id = ?";
                return "DELETE FROM offline_payment_intent WHERE id = ?";
            }
        };
    }

    @Override
    public Object insert(final OfflinePaymentIntentRequestEntity entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long call() throws Exception {
                OfflinePaymentIntentRequestDao_Impl.this.__db.beginTransaction();
                try {
                    long _result = OfflinePaymentIntentRequestDao_Impl.this.__insertionAdapterOfOfflinePaymentIntentRequestEntity.insertAndReturnId((Object)entity);
                    OfflinePaymentIntentRequestDao_Impl.this.__db.setTransactionSuccessful();
                    Long l2 = _result;
                    return l2;
                }
                finally {
                    OfflinePaymentIntentRequestDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object insertAll(final OfflinePaymentIntentRequestEntity[] entity, Continuation<? super List<Long>> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<List<Long>>(){

            @Override
            public List<Long> call() throws Exception {
                OfflinePaymentIntentRequestDao_Impl.this.__db.beginTransaction();
                try {
                    List _result = OfflinePaymentIntentRequestDao_Impl.this.__insertionAdapterOfOfflinePaymentIntentRequestEntity.insertAndReturnIdsList((Object[])entity);
                    OfflinePaymentIntentRequestDao_Impl.this.__db.setTransactionSuccessful();
                    List list = _result;
                    return list;
                }
                finally {
                    OfflinePaymentIntentRequestDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object delete(final OfflinePaymentIntentRequestEntity entity, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                OfflinePaymentIntentRequestDao_Impl.this.__db.beginTransaction();
                try {
                    OfflinePaymentIntentRequestDao_Impl.this.__deletionAdapterOfOfflinePaymentIntentRequestEntity.handle((Object)entity);
                    OfflinePaymentIntentRequestDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    OfflinePaymentIntentRequestDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object updatePaymentIntentId(final long rowId, final String accountId, final String offlineId, final long connectionId, final OfflinePaymentIntentRequest.PaymentIntentRequestType type, final String paymentIntentId, final byte[] data, final byte[] iv, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = OfflinePaymentIntentRequestDao_Impl.this.__preparedStmtOfUpdatePaymentIntentId.acquire();
                int _argIndex = 1;
                if (paymentIntentId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, paymentIntentId);
                }
                _argIndex = 2;
                if (data == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindBlob(_argIndex, data);
                }
                _argIndex = 3;
                if (iv == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindBlob(_argIndex, iv);
                }
                _argIndex = 4;
                _stmt.bindLong(_argIndex, rowId);
                _argIndex = 5;
                if (accountId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, accountId);
                }
                _argIndex = 6;
                _stmt.bindLong(_argIndex, connectionId);
                _argIndex = 7;
                if (type == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, OfflinePaymentIntentRequestDao_Impl.this.__PaymentIntentRequestType_enumToString(type));
                }
                _argIndex = 8;
                if (offlineId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, offlineId);
                }
                _argIndex = 9;
                if (offlineId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, offlineId);
                }
                OfflinePaymentIntentRequestDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    OfflinePaymentIntentRequestDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    OfflinePaymentIntentRequestDao_Impl.this.__db.endTransaction();
                    OfflinePaymentIntentRequestDao_Impl.this.__preparedStmtOfUpdatePaymentIntentId.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object deleteByOfflineOrPaymentIntentId(final String id, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = OfflinePaymentIntentRequestDao_Impl.this.__preparedStmtOfDeleteByOfflineOrPaymentIntentId.acquire();
                int _argIndex = 1;
                if (id == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, id);
                }
                _argIndex = 2;
                if (id == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, id);
                }
                OfflinePaymentIntentRequestDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    OfflinePaymentIntentRequestDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    OfflinePaymentIntentRequestDao_Impl.this.__db.endTransaction();
                    OfflinePaymentIntentRequestDao_Impl.this.__preparedStmtOfDeleteByOfflineOrPaymentIntentId.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object restoreSoftDeletedPayments(final String accountId, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = OfflinePaymentIntentRequestDao_Impl.this.__preparedStmtOfRestoreSoftDeletedPayments.acquire();
                int _argIndex = 1;
                if (accountId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, accountId);
                }
                OfflinePaymentIntentRequestDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    OfflinePaymentIntentRequestDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    OfflinePaymentIntentRequestDao_Impl.this.__db.endTransaction();
                    OfflinePaymentIntentRequestDao_Impl.this.__preparedStmtOfRestoreSoftDeletedPayments.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object deleteOrphanedPayments(final String accountId, final Date createdBefore, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = OfflinePaymentIntentRequestDao_Impl.this.__preparedStmtOfDeleteOrphanedPayments.acquire();
                int _argIndex = 1;
                if (accountId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, accountId);
                }
                _argIndex = 2;
                if (accountId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, accountId);
                }
                _argIndex = 3;
                long _tmp = OfflinePaymentIntentRequestDao_Impl.this.__dateTimeConverter.toTimeMs(createdBefore);
                _stmt.bindLong(_argIndex, _tmp);
                OfflinePaymentIntentRequestDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    OfflinePaymentIntentRequestDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    OfflinePaymentIntentRequestDao_Impl.this.__db.endTransaction();
                    OfflinePaymentIntentRequestDao_Impl.this.__preparedStmtOfDeleteOrphanedPayments.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object deleteByRowId(final long id, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = OfflinePaymentIntentRequestDao_Impl.this.__preparedStmtOfDeleteByRowId.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, id);
                OfflinePaymentIntentRequestDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    OfflinePaymentIntentRequestDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    OfflinePaymentIntentRequestDao_Impl.this.__db.endTransaction();
                    OfflinePaymentIntentRequestDao_Impl.this.__preparedStmtOfDeleteByRowId.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Flow<List<OfflinePaymentIntentRequestEntity>> getByAccountId(String accountId) {
        String _sql = "SELECT * FROM offline_payment_intent WHERE account_id = ? ORDER BY id";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM offline_payment_intent WHERE account_id = ? ORDER BY id", (int)1);
        int _argIndex = 1;
        if (accountId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, accountId);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"offline_payment_intent"}, (Callable)new Callable<List<OfflinePaymentIntentRequestEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<OfflinePaymentIntentRequestEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)OfflinePaymentIntentRequestDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfOfflineId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"offline_id");
                    int _cursorIndexOfConnectionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"connection_id");
                    int _cursorIndexOfPaymentIntentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"payment_intent_id");
                    int _cursorIndexOfAccountId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"account_id");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deleted");
                    int _cursorIndexOfEncryptedData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data_blob");
                    int _cursorIndexOfEncryptionIv = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iv_blob");
                    int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"created_timestamp");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    ArrayList<OfflinePaymentIntentRequestEntity> _result = new ArrayList<OfflinePaymentIntentRequestEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpOfflineId = _cursor.isNull(_cursorIndexOfOfflineId) ? null : _cursor.getString(_cursorIndexOfOfflineId);
                        long _tmpConnectionId = _cursor.getLong(_cursorIndexOfConnectionId);
                        String _tmpPaymentIntentId = _cursor.isNull(_cursorIndexOfPaymentIntentId) ? null : _cursor.getString(_cursorIndexOfPaymentIntentId);
                        String _tmpAccountId = _cursor.isNull(_cursorIndexOfAccountId) ? null : _cursor.getString(_cursorIndexOfAccountId);
                        OfflinePaymentIntentRequest.PaymentIntentRequestType _tmpType = OfflinePaymentIntentRequestDao_Impl.this.__PaymentIntentRequestType_stringToEnum(_cursor.getString(_cursorIndexOfType));
                        int _tmp = _cursor.getInt(_cursorIndexOfDeleted);
                        boolean _tmpDeleted = _tmp != 0;
                        byte[] _tmpEncryptedData = _cursor.isNull(_cursorIndexOfEncryptedData) ? null : _cursor.getBlob(_cursorIndexOfEncryptedData);
                        byte[] _tmpEncryptionIv = _cursor.isNull(_cursorIndexOfEncryptionIv) ? null : _cursor.getBlob(_cursorIndexOfEncryptionIv);
                        long _tmp_1 = _cursor.getLong(_cursorIndexOfCreated);
                        Date _tmpCreated = OfflinePaymentIntentRequestDao_Impl.this.__dateTimeConverter.toDate(_tmp_1);
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        OfflinePaymentIntentRequestEntity _item = new OfflinePaymentIntentRequestEntity(_tmpOfflineId, _tmpConnectionId, _tmpPaymentIntentId, _tmpAccountId, _tmpType, _tmpDeleted, _tmpEncryptedData, _tmpEncryptionIv, _tmpCreated, _tmpId);
                        _result.add(_item);
                    }
                    ArrayList<OfflinePaymentIntentRequestEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object getAll(int limit, int offset, String accountId, Continuation<? super List<OfflinePaymentIntentRequestEntity>> $completion) {
        String _sql = "SELECT * FROM offline_payment_intent WHERE account_id = ? ORDER BY id LIMIT ? OFFSET ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM offline_payment_intent WHERE account_id = ? ORDER BY id LIMIT ? OFFSET ?", (int)3);
        int _argIndex = 1;
        if (accountId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, accountId);
        }
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)limit);
        _argIndex = 3;
        _statement.bindLong(_argIndex, (long)offset);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<OfflinePaymentIntentRequestEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<OfflinePaymentIntentRequestEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)OfflinePaymentIntentRequestDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfOfflineId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"offline_id");
                    int _cursorIndexOfConnectionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"connection_id");
                    int _cursorIndexOfPaymentIntentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"payment_intent_id");
                    int _cursorIndexOfAccountId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"account_id");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deleted");
                    int _cursorIndexOfEncryptedData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data_blob");
                    int _cursorIndexOfEncryptionIv = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iv_blob");
                    int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"created_timestamp");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    ArrayList<OfflinePaymentIntentRequestEntity> _result = new ArrayList<OfflinePaymentIntentRequestEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpOfflineId = _cursor.isNull(_cursorIndexOfOfflineId) ? null : _cursor.getString(_cursorIndexOfOfflineId);
                        long _tmpConnectionId = _cursor.getLong(_cursorIndexOfConnectionId);
                        String _tmpPaymentIntentId = _cursor.isNull(_cursorIndexOfPaymentIntentId) ? null : _cursor.getString(_cursorIndexOfPaymentIntentId);
                        String _tmpAccountId = _cursor.isNull(_cursorIndexOfAccountId) ? null : _cursor.getString(_cursorIndexOfAccountId);
                        OfflinePaymentIntentRequest.PaymentIntentRequestType _tmpType = OfflinePaymentIntentRequestDao_Impl.this.__PaymentIntentRequestType_stringToEnum(_cursor.getString(_cursorIndexOfType));
                        int _tmp = _cursor.getInt(_cursorIndexOfDeleted);
                        boolean _tmpDeleted = _tmp != 0;
                        byte[] _tmpEncryptedData = _cursor.isNull(_cursorIndexOfEncryptedData) ? null : _cursor.getBlob(_cursorIndexOfEncryptedData);
                        byte[] _tmpEncryptionIv = _cursor.isNull(_cursorIndexOfEncryptionIv) ? null : _cursor.getBlob(_cursorIndexOfEncryptionIv);
                        long _tmp_1 = _cursor.getLong(_cursorIndexOfCreated);
                        Date _tmpCreated = OfflinePaymentIntentRequestDao_Impl.this.__dateTimeConverter.toDate(_tmp_1);
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        OfflinePaymentIntentRequestEntity _item = new OfflinePaymentIntentRequestEntity(_tmpOfflineId, _tmpConnectionId, _tmpPaymentIntentId, _tmpAccountId, _tmpType, _tmpDeleted, _tmpEncryptedData, _tmpEncryptionIv, _tmpCreated, _tmpId);
                        _result.add(_item);
                    }
                    ArrayList<OfflinePaymentIntentRequestEntity> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<OfflinePaymentIntentRequestEntity> fetchNextPaymentToForward(String accountId) {
        String _sql = "\n            SELECT *\n                FROM offline_payment_intent\n                    WHERE account_id = ?\n                        AND deleted = 0\n                        AND ( type != 'CREATE_PAYMENT_INTENT'\n                            OR payment_intent_id IS NULL OR payment_intent_id = ''\n                            OR offline_id IS NULL OR offline_id = ''\n                        ) \n                    ORDER BY id\n                    LIMIT 1\n        ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n            SELECT *\n                FROM offline_payment_intent\n                    WHERE account_id = ?\n                        AND deleted = 0\n                        AND ( type != 'CREATE_PAYMENT_INTENT'\n                            OR payment_intent_id IS NULL OR payment_intent_id = ''\n                            OR offline_id IS NULL OR offline_id = ''\n                        ) \n                    ORDER BY id\n                    LIMIT 1\n        ", (int)1);
        int _argIndex = 1;
        if (accountId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, accountId);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"offline_payment_intent"}, (Callable)new Callable<OfflinePaymentIntentRequestEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OfflinePaymentIntentRequestEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)OfflinePaymentIntentRequestDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    OfflinePaymentIntentRequestEntity _result;
                    int _cursorIndexOfOfflineId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"offline_id");
                    int _cursorIndexOfConnectionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"connection_id");
                    int _cursorIndexOfPaymentIntentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"payment_intent_id");
                    int _cursorIndexOfAccountId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"account_id");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deleted");
                    int _cursorIndexOfEncryptedData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data_blob");
                    int _cursorIndexOfEncryptionIv = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iv_blob");
                    int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"created_timestamp");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    if (_cursor.moveToFirst()) {
                        String _tmpOfflineId = _cursor.isNull(_cursorIndexOfOfflineId) ? null : _cursor.getString(_cursorIndexOfOfflineId);
                        long _tmpConnectionId = _cursor.getLong(_cursorIndexOfConnectionId);
                        String _tmpPaymentIntentId = _cursor.isNull(_cursorIndexOfPaymentIntentId) ? null : _cursor.getString(_cursorIndexOfPaymentIntentId);
                        String _tmpAccountId = _cursor.isNull(_cursorIndexOfAccountId) ? null : _cursor.getString(_cursorIndexOfAccountId);
                        OfflinePaymentIntentRequest.PaymentIntentRequestType _tmpType = OfflinePaymentIntentRequestDao_Impl.this.__PaymentIntentRequestType_stringToEnum(_cursor.getString(_cursorIndexOfType));
                        int _tmp = _cursor.getInt(_cursorIndexOfDeleted);
                        boolean _tmpDeleted = _tmp != 0;
                        byte[] _tmpEncryptedData = _cursor.isNull(_cursorIndexOfEncryptedData) ? null : _cursor.getBlob(_cursorIndexOfEncryptedData);
                        byte[] _tmpEncryptionIv = _cursor.isNull(_cursorIndexOfEncryptionIv) ? null : _cursor.getBlob(_cursorIndexOfEncryptionIv);
                        long _tmp_1 = _cursor.getLong(_cursorIndexOfCreated);
                        Date _tmpCreated = OfflinePaymentIntentRequestDao_Impl.this.__dateTimeConverter.toDate(_tmp_1);
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        _result = new OfflinePaymentIntentRequestEntity(_tmpOfflineId, _tmpConnectionId, _tmpPaymentIntentId, _tmpAccountId, _tmpType, _tmpDeleted, _tmpEncryptedData, _tmpEncryptionIv, _tmpCreated, _tmpId);
                    } else {
                        _result = null;
                    }
                    OfflinePaymentIntentRequestEntity offlinePaymentIntentRequestEntity = _result;
                    return offlinePaymentIntentRequestEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flow<List<OfflinePaymentIntentRequestEntity>> fetchUnProcessedOfflinePayments(String accountId) {
        String _sql = "\n            SELECT *\n                FROM offline_payment_intent\n                    WHERE account_id = ?\n                        AND deleted = 0\n                        AND type = 'PROCESS_PAYMENT_INTENT'\n        ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n            SELECT *\n                FROM offline_payment_intent\n                    WHERE account_id = ?\n                        AND deleted = 0\n                        AND type = 'PROCESS_PAYMENT_INTENT'\n        ", (int)1);
        int _argIndex = 1;
        if (accountId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, accountId);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"offline_payment_intent"}, (Callable)new Callable<List<OfflinePaymentIntentRequestEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<OfflinePaymentIntentRequestEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)OfflinePaymentIntentRequestDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfOfflineId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"offline_id");
                    int _cursorIndexOfConnectionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"connection_id");
                    int _cursorIndexOfPaymentIntentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"payment_intent_id");
                    int _cursorIndexOfAccountId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"account_id");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deleted");
                    int _cursorIndexOfEncryptedData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data_blob");
                    int _cursorIndexOfEncryptionIv = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iv_blob");
                    int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"created_timestamp");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    ArrayList<OfflinePaymentIntentRequestEntity> _result = new ArrayList<OfflinePaymentIntentRequestEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpOfflineId = _cursor.isNull(_cursorIndexOfOfflineId) ? null : _cursor.getString(_cursorIndexOfOfflineId);
                        long _tmpConnectionId = _cursor.getLong(_cursorIndexOfConnectionId);
                        String _tmpPaymentIntentId = _cursor.isNull(_cursorIndexOfPaymentIntentId) ? null : _cursor.getString(_cursorIndexOfPaymentIntentId);
                        String _tmpAccountId = _cursor.isNull(_cursorIndexOfAccountId) ? null : _cursor.getString(_cursorIndexOfAccountId);
                        OfflinePaymentIntentRequest.PaymentIntentRequestType _tmpType = OfflinePaymentIntentRequestDao_Impl.this.__PaymentIntentRequestType_stringToEnum(_cursor.getString(_cursorIndexOfType));
                        int _tmp = _cursor.getInt(_cursorIndexOfDeleted);
                        boolean _tmpDeleted = _tmp != 0;
                        byte[] _tmpEncryptedData = _cursor.isNull(_cursorIndexOfEncryptedData) ? null : _cursor.getBlob(_cursorIndexOfEncryptedData);
                        byte[] _tmpEncryptionIv = _cursor.isNull(_cursorIndexOfEncryptionIv) ? null : _cursor.getBlob(_cursorIndexOfEncryptionIv);
                        long _tmp_1 = _cursor.getLong(_cursorIndexOfCreated);
                        Date _tmpCreated = OfflinePaymentIntentRequestDao_Impl.this.__dateTimeConverter.toDate(_tmp_1);
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        OfflinePaymentIntentRequestEntity _item = new OfflinePaymentIntentRequestEntity(_tmpOfflineId, _tmpConnectionId, _tmpPaymentIntentId, _tmpAccountId, _tmpType, _tmpDeleted, _tmpEncryptedData, _tmpEncryptionIv, _tmpCreated, _tmpId);
                        _result.add(_item);
                    }
                    ArrayList<OfflinePaymentIntentRequestEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object hasMorePaymentsAfter(String paymentId, long rowId, String accountId, Continuation<? super Boolean> $completion) {
        String _sql = " \n            SELECT EXISTS (\n                SELECT * \n                    FROM offline_payment_intent \n                        WHERE id >? \n                            AND account_id =? \n                            AND (offline_id =? OR payment_intent_id =?)\n                )\n        ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)" \n            SELECT EXISTS (\n                SELECT * \n                    FROM offline_payment_intent \n                        WHERE id >? \n                            AND account_id =? \n                            AND (offline_id =? OR payment_intent_id =?)\n                )\n        ", (int)4);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, rowId);
        _argIndex = 2;
        if (accountId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, accountId);
        }
        _argIndex = 3;
        if (paymentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, paymentId);
        }
        _argIndex = 4;
        if (paymentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, paymentId);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)OfflinePaymentIntentRequestDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Integer _tmp;
                    Boolean _result = _cursor.moveToFirst() ? ((_tmp = _cursor.isNull(0) ? null : Integer.valueOf(_cursor.getInt(0))) == null ? null : Boolean.valueOf(_tmp != 0)) : null;
                    Boolean bl = _result;
                    return bl;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getPaymentIntentIdForOfflineId(String offlineId, Continuation<? super String> $completion) {
        String _sql = "SELECT payment_intent_id FROM offline_payment_intent WHERE offline_id = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT payment_intent_id FROM offline_payment_intent WHERE offline_id = ?", (int)1);
        int _argIndex = 1;
        if (offlineId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, offlineId);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)OfflinePaymentIntentRequestDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    String _result = _cursor.moveToFirst() ? (_cursor.isNull(0) ? null : _cursor.getString(0)) : null;
                    String string = _result;
                    return string;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getConnectionIds(String accountId, Continuation<? super List<Long>> $completion) {
        String _sql = "SELECT DISTINCT connection_id FROM offline_payment_intent WHERE account_id = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT DISTINCT connection_id FROM offline_payment_intent WHERE account_id = ?", (int)1);
        int _argIndex = 1;
        if (accountId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, accountId);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<Long>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Long> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)OfflinePaymentIntentRequestDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ArrayList<Long> _result = new ArrayList<Long>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Long _item = _cursor.isNull(0) ? null : Long.valueOf(_cursor.getLong(0));
                        _result.add(_item);
                    }
                    ArrayList<Long> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getByOfflineIdAndType(String offlineId, OfflinePaymentIntentRequest.PaymentIntentRequestType type, Continuation<? super OfflinePaymentIntentRequestEntity> $completion) {
        String _sql = "SELECT * FROM offline_payment_intent WHERE offline_id = ? AND type = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM offline_payment_intent WHERE offline_id = ? AND type = ?", (int)2);
        int _argIndex = 1;
        if (offlineId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, offlineId);
        }
        _argIndex = 2;
        if (type == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, this.__PaymentIntentRequestType_enumToString(type));
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<OfflinePaymentIntentRequestEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OfflinePaymentIntentRequestEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)OfflinePaymentIntentRequestDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    OfflinePaymentIntentRequestEntity _result;
                    int _cursorIndexOfOfflineId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"offline_id");
                    int _cursorIndexOfConnectionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"connection_id");
                    int _cursorIndexOfPaymentIntentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"payment_intent_id");
                    int _cursorIndexOfAccountId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"account_id");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deleted");
                    int _cursorIndexOfEncryptedData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data_blob");
                    int _cursorIndexOfEncryptionIv = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iv_blob");
                    int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"created_timestamp");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    if (_cursor.moveToFirst()) {
                        String _tmpOfflineId = _cursor.isNull(_cursorIndexOfOfflineId) ? null : _cursor.getString(_cursorIndexOfOfflineId);
                        long _tmpConnectionId = _cursor.getLong(_cursorIndexOfConnectionId);
                        String _tmpPaymentIntentId = _cursor.isNull(_cursorIndexOfPaymentIntentId) ? null : _cursor.getString(_cursorIndexOfPaymentIntentId);
                        String _tmpAccountId = _cursor.isNull(_cursorIndexOfAccountId) ? null : _cursor.getString(_cursorIndexOfAccountId);
                        OfflinePaymentIntentRequest.PaymentIntentRequestType _tmpType = OfflinePaymentIntentRequestDao_Impl.this.__PaymentIntentRequestType_stringToEnum(_cursor.getString(_cursorIndexOfType));
                        int _tmp = _cursor.getInt(_cursorIndexOfDeleted);
                        boolean _tmpDeleted = _tmp != 0;
                        byte[] _tmpEncryptedData = _cursor.isNull(_cursorIndexOfEncryptedData) ? null : _cursor.getBlob(_cursorIndexOfEncryptedData);
                        byte[] _tmpEncryptionIv = _cursor.isNull(_cursorIndexOfEncryptionIv) ? null : _cursor.getBlob(_cursorIndexOfEncryptionIv);
                        long _tmp_1 = _cursor.getLong(_cursorIndexOfCreated);
                        Date _tmpCreated = OfflinePaymentIntentRequestDao_Impl.this.__dateTimeConverter.toDate(_tmp_1);
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        _result = new OfflinePaymentIntentRequestEntity(_tmpOfflineId, _tmpConnectionId, _tmpPaymentIntentId, _tmpAccountId, _tmpType, _tmpDeleted, _tmpEncryptedData, _tmpEncryptionIv, _tmpCreated, _tmpId);
                    } else {
                        _result = null;
                    }
                    OfflinePaymentIntentRequestEntity offlinePaymentIntentRequestEntity = _result;
                    return offlinePaymentIntentRequestEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<Long> getMostRecentRowId(String accountId) {
        String _sql = "SELECT MAX(id) FROM offline_payment_intent WHERE deleted = 0 AND account_id = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT MAX(id) FROM offline_payment_intent WHERE deleted = 0 AND account_id = ?", (int)1);
        int _argIndex = 1;
        if (accountId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, accountId);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"offline_payment_intent"}, (Callable)new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)OfflinePaymentIntentRequestDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    Long _result;
                    if (_cursor.moveToFirst()) {
                        Long _tmp = _cursor.isNull(0) ? null : Long.valueOf(_cursor.getLong(0));
                        _result = _tmp;
                    } else {
                        _result = null;
                    }
                    Long l2 = _result;
                    return l2;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object softDeleteByPaymentId(final String[] paymentIds, Continuation<? super Integer> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer call() throws Exception {
                StringBuilder _stringBuilder = StringUtil.newStringBuilder();
                _stringBuilder.append("UPDATE offline_payment_intent SET deleted = 1 WHERE offline_id in (");
                int _inputSize = paymentIds.length;
                StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
                _stringBuilder.append(") OR payment_intent_id in (");
                int _inputSize_1 = paymentIds.length;
                StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_1);
                _stringBuilder.append(")");
                String _sql = _stringBuilder.toString();
                SupportSQLiteStatement _stmt = OfflinePaymentIntentRequestDao_Impl.this.__db.compileStatement(_sql);
                int _argIndex = 1;
                for (String _item : paymentIds) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindString(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                _argIndex = 1 + _inputSize;
                for (String _item_1 : paymentIds) {
                    if (_item_1 == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindString(_argIndex, _item_1);
                    }
                    ++_argIndex;
                }
                OfflinePaymentIntentRequestDao_Impl.this.__db.beginTransaction();
                try {
                    Integer _result = _stmt.executeUpdateDelete();
                    OfflinePaymentIntentRequestDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n2 = _result;
                    return n2;
                }
                finally {
                    OfflinePaymentIntentRequestDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    private String __PaymentIntentRequestType_enumToString(OfflinePaymentIntentRequest.PaymentIntentRequestType _value) {
        if (_value == null) {
            return null;
        }
        switch (_value) {
            case CREATE_PAYMENT_INTENT: {
                return "CREATE_PAYMENT_INTENT";
            }
            case PROCESS_PAYMENT_INTENT: {
                return "PROCESS_PAYMENT_INTENT";
            }
        }
        throw new IllegalArgumentException("Can't convert enum to string, unknown enum value: " + (Object)((Object)_value));
    }

    private OfflinePaymentIntentRequest.PaymentIntentRequestType __PaymentIntentRequestType_stringToEnum(String _value) {
        if (_value == null) {
            return null;
        }
        switch (_value) {
            case "CREATE_PAYMENT_INTENT": {
                return OfflinePaymentIntentRequest.PaymentIntentRequestType.CREATE_PAYMENT_INTENT;
            }
            case "PROCESS_PAYMENT_INTENT": {
                return OfflinePaymentIntentRequest.PaymentIntentRequestType.PROCESS_PAYMENT_INTENT;
            }
        }
        throw new IllegalArgumentException("Can't convert value to enum, unknown value: " + _value);
    }
}

