/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.offlinemode.storage;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.stripe.offlinemode.storage.DateTimeConverter;
import com.stripe.offlinemode.storage.OfflineReaderDao;
import com.stripe.offlinemode.storage.OfflineReaderEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class OfflineReaderDao_Impl
implements OfflineReaderDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<OfflineReaderEntity> __insertionAdapterOfOfflineReaderEntity;
    private final DateTimeConverter __dateTimeConverter = new DateTimeConverter();
    private final EntityDeletionOrUpdateAdapter<OfflineReaderEntity> __deletionAdapterOfOfflineReaderEntity;
    private final EntityDeletionOrUpdateAdapter<OfflineReaderEntity> __updateAdapterOfOfflineReaderEntity;

    public OfflineReaderDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfOfflineReaderEntity = new EntityInsertionAdapter<OfflineReaderEntity>(__db){

            public String createQuery() {
                return "INSERT OR ABORT INTO `reader` (`serial_number`,`last_activated_timestamp`,`created_timestamp`,`account_id`,`data_blob`,`iv_blob`,`id`) VALUES (?,?,?,?,?,?,nullif(?, 0))";
            }

            public void bind(SupportSQLiteStatement stmt, OfflineReaderEntity value) {
                if (value.getSerialNumber() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getSerialNumber());
                }
                long _tmp = OfflineReaderDao_Impl.this.__dateTimeConverter.toTimeMs(value.getLastActivatedAt());
                stmt.bindLong(2, _tmp);
                long _tmp_1 = OfflineReaderDao_Impl.this.__dateTimeConverter.toTimeMs(value.getCreated());
                stmt.bindLong(3, _tmp_1);
                if (value.getAccountId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getAccountId());
                }
                if (value.getEncryptedData() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindBlob(5, value.getEncryptedData());
                }
                if (value.getEncryptionIv() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindBlob(6, value.getEncryptionIv());
                }
                stmt.bindLong(7, value.getId());
            }
        };
        this.__deletionAdapterOfOfflineReaderEntity = new EntityDeletionOrUpdateAdapter<OfflineReaderEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `reader` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, OfflineReaderEntity value) {
                stmt.bindLong(1, value.getId());
            }
        };
        this.__updateAdapterOfOfflineReaderEntity = new EntityDeletionOrUpdateAdapter<OfflineReaderEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `reader` SET `serial_number` = ?,`last_activated_timestamp` = ?,`created_timestamp` = ?,`account_id` = ?,`data_blob` = ?,`iv_blob` = ?,`id` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, OfflineReaderEntity value) {
                if (value.getSerialNumber() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getSerialNumber());
                }
                long _tmp = OfflineReaderDao_Impl.this.__dateTimeConverter.toTimeMs(value.getLastActivatedAt());
                stmt.bindLong(2, _tmp);
                long _tmp_1 = OfflineReaderDao_Impl.this.__dateTimeConverter.toTimeMs(value.getCreated());
                stmt.bindLong(3, _tmp_1);
                if (value.getAccountId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getAccountId());
                }
                if (value.getEncryptedData() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindBlob(5, value.getEncryptedData());
                }
                if (value.getEncryptionIv() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindBlob(6, value.getEncryptionIv());
                }
                stmt.bindLong(7, value.getId());
                stmt.bindLong(8, value.getId());
            }
        };
    }

    @Override
    public Object insertAll(final OfflineReaderEntity[] reader, Continuation<? super List<Long>> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<List<Long>>(){

            @Override
            public List<Long> call() throws Exception {
                OfflineReaderDao_Impl.this.__db.beginTransaction();
                try {
                    List _result = OfflineReaderDao_Impl.this.__insertionAdapterOfOfflineReaderEntity.insertAndReturnIdsList((Object[])reader);
                    OfflineReaderDao_Impl.this.__db.setTransactionSuccessful();
                    List list = _result;
                    return list;
                }
                finally {
                    OfflineReaderDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object insert(final OfflineReaderEntity reader, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long call() throws Exception {
                OfflineReaderDao_Impl.this.__db.beginTransaction();
                try {
                    long _result = OfflineReaderDao_Impl.this.__insertionAdapterOfOfflineReaderEntity.insertAndReturnId((Object)reader);
                    OfflineReaderDao_Impl.this.__db.setTransactionSuccessful();
                    Long l2 = _result;
                    return l2;
                }
                finally {
                    OfflineReaderDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object delete(final OfflineReaderEntity reader, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                OfflineReaderDao_Impl.this.__db.beginTransaction();
                try {
                    OfflineReaderDao_Impl.this.__deletionAdapterOfOfflineReaderEntity.handle((Object)reader);
                    OfflineReaderDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    OfflineReaderDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object update(final OfflineReaderEntity reader, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                OfflineReaderDao_Impl.this.__db.beginTransaction();
                try {
                    OfflineReaderDao_Impl.this.__updateAdapterOfOfflineReaderEntity.handle((Object)reader);
                    OfflineReaderDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    OfflineReaderDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<List<OfflineReaderEntity>> getByAccountId(String accountId) {
        String _sql = "SELECT * FROM reader WHERE account_id = ? ORDER BY id";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM reader WHERE account_id = ? ORDER BY id", (int)1);
        int _argIndex = 1;
        if (accountId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, accountId);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"reader"}, (Callable)new Callable<List<OfflineReaderEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<OfflineReaderEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)OfflineReaderDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfSerialNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"serial_number");
                    int _cursorIndexOfLastActivatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_activated_timestamp");
                    int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"created_timestamp");
                    int _cursorIndexOfAccountId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"account_id");
                    int _cursorIndexOfEncryptedData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data_blob");
                    int _cursorIndexOfEncryptionIv = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iv_blob");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    ArrayList<OfflineReaderEntity> _result = new ArrayList<OfflineReaderEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpSerialNumber = _cursor.isNull(_cursorIndexOfSerialNumber) ? null : _cursor.getString(_cursorIndexOfSerialNumber);
                        long _tmp = _cursor.getLong(_cursorIndexOfLastActivatedAt);
                        Date _tmpLastActivatedAt = OfflineReaderDao_Impl.this.__dateTimeConverter.toDate(_tmp);
                        long _tmp_1 = _cursor.getLong(_cursorIndexOfCreated);
                        Date _tmpCreated = OfflineReaderDao_Impl.this.__dateTimeConverter.toDate(_tmp_1);
                        String _tmpAccountId = _cursor.isNull(_cursorIndexOfAccountId) ? null : _cursor.getString(_cursorIndexOfAccountId);
                        byte[] _tmpEncryptedData = _cursor.isNull(_cursorIndexOfEncryptedData) ? null : _cursor.getBlob(_cursorIndexOfEncryptedData);
                        byte[] _tmpEncryptionIv = _cursor.isNull(_cursorIndexOfEncryptionIv) ? null : _cursor.getBlob(_cursorIndexOfEncryptionIv);
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        OfflineReaderEntity _item = new OfflineReaderEntity(_tmpSerialNumber, _tmpLastActivatedAt, _tmpCreated, _tmpAccountId, _tmpEncryptedData, _tmpEncryptionIv, _tmpId);
                        _result.add(_item);
                    }
                    ArrayList<OfflineReaderEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object getAll(int offset, int limit, Continuation<? super List<OfflineReaderEntity>> $completion) {
        String _sql = "SELECT * FROM reader ORDER BY id LIMIT ? OFFSET ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM reader ORDER BY id LIMIT ? OFFSET ?", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)limit);
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)offset);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<OfflineReaderEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<OfflineReaderEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)OfflineReaderDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfSerialNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"serial_number");
                    int _cursorIndexOfLastActivatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_activated_timestamp");
                    int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"created_timestamp");
                    int _cursorIndexOfAccountId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"account_id");
                    int _cursorIndexOfEncryptedData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data_blob");
                    int _cursorIndexOfEncryptionIv = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iv_blob");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    ArrayList<OfflineReaderEntity> _result = new ArrayList<OfflineReaderEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpSerialNumber = _cursor.isNull(_cursorIndexOfSerialNumber) ? null : _cursor.getString(_cursorIndexOfSerialNumber);
                        long _tmp = _cursor.getLong(_cursorIndexOfLastActivatedAt);
                        Date _tmpLastActivatedAt = OfflineReaderDao_Impl.this.__dateTimeConverter.toDate(_tmp);
                        long _tmp_1 = _cursor.getLong(_cursorIndexOfCreated);
                        Date _tmpCreated = OfflineReaderDao_Impl.this.__dateTimeConverter.toDate(_tmp_1);
                        String _tmpAccountId = _cursor.isNull(_cursorIndexOfAccountId) ? null : _cursor.getString(_cursorIndexOfAccountId);
                        byte[] _tmpEncryptedData = _cursor.isNull(_cursorIndexOfEncryptedData) ? null : _cursor.getBlob(_cursorIndexOfEncryptedData);
                        byte[] _tmpEncryptionIv = _cursor.isNull(_cursorIndexOfEncryptionIv) ? null : _cursor.getBlob(_cursorIndexOfEncryptionIv);
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        OfflineReaderEntity _item = new OfflineReaderEntity(_tmpSerialNumber, _tmpLastActivatedAt, _tmpCreated, _tmpAccountId, _tmpEncryptedData, _tmpEncryptionIv, _tmpId);
                        _result.add(_item);
                    }
                    ArrayList<OfflineReaderEntity> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getByReaderId(long id, Continuation<? super OfflineReaderEntity> $completion) {
        String _sql = "SELECT * FROM reader WHERE id = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM reader WHERE id = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, id);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<OfflineReaderEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OfflineReaderEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)OfflineReaderDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    OfflineReaderEntity _result;
                    int _cursorIndexOfSerialNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"serial_number");
                    int _cursorIndexOfLastActivatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_activated_timestamp");
                    int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"created_timestamp");
                    int _cursorIndexOfAccountId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"account_id");
                    int _cursorIndexOfEncryptedData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data_blob");
                    int _cursorIndexOfEncryptionIv = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iv_blob");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    if (_cursor.moveToFirst()) {
                        String _tmpSerialNumber = _cursor.isNull(_cursorIndexOfSerialNumber) ? null : _cursor.getString(_cursorIndexOfSerialNumber);
                        long _tmp = _cursor.getLong(_cursorIndexOfLastActivatedAt);
                        Date _tmpLastActivatedAt = OfflineReaderDao_Impl.this.__dateTimeConverter.toDate(_tmp);
                        long _tmp_1 = _cursor.getLong(_cursorIndexOfCreated);
                        Date _tmpCreated = OfflineReaderDao_Impl.this.__dateTimeConverter.toDate(_tmp_1);
                        String _tmpAccountId = _cursor.isNull(_cursorIndexOfAccountId) ? null : _cursor.getString(_cursorIndexOfAccountId);
                        byte[] _tmpEncryptedData = _cursor.isNull(_cursorIndexOfEncryptedData) ? null : _cursor.getBlob(_cursorIndexOfEncryptedData);
                        byte[] _tmpEncryptionIv = _cursor.isNull(_cursorIndexOfEncryptionIv) ? null : _cursor.getBlob(_cursorIndexOfEncryptionIv);
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        _result = new OfflineReaderEntity(_tmpSerialNumber, _tmpLastActivatedAt, _tmpCreated, _tmpAccountId, _tmpEncryptedData, _tmpEncryptionIv, _tmpId);
                    } else {
                        _result = null;
                    }
                    OfflineReaderEntity offlineReaderEntity = _result;
                    return offlineReaderEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<OfflineReaderEntity> getByIdFlow(long id) {
        String _sql = "SELECT * FROM reader WHERE id = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM reader WHERE id = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, id);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"reader"}, (Callable)new Callable<OfflineReaderEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OfflineReaderEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)OfflineReaderDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    OfflineReaderEntity _result;
                    int _cursorIndexOfSerialNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"serial_number");
                    int _cursorIndexOfLastActivatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_activated_timestamp");
                    int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"created_timestamp");
                    int _cursorIndexOfAccountId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"account_id");
                    int _cursorIndexOfEncryptedData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data_blob");
                    int _cursorIndexOfEncryptionIv = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iv_blob");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    if (_cursor.moveToFirst()) {
                        String _tmpSerialNumber = _cursor.isNull(_cursorIndexOfSerialNumber) ? null : _cursor.getString(_cursorIndexOfSerialNumber);
                        long _tmp = _cursor.getLong(_cursorIndexOfLastActivatedAt);
                        Date _tmpLastActivatedAt = OfflineReaderDao_Impl.this.__dateTimeConverter.toDate(_tmp);
                        long _tmp_1 = _cursor.getLong(_cursorIndexOfCreated);
                        Date _tmpCreated = OfflineReaderDao_Impl.this.__dateTimeConverter.toDate(_tmp_1);
                        String _tmpAccountId = _cursor.isNull(_cursorIndexOfAccountId) ? null : _cursor.getString(_cursorIndexOfAccountId);
                        byte[] _tmpEncryptedData = _cursor.isNull(_cursorIndexOfEncryptedData) ? null : _cursor.getBlob(_cursorIndexOfEncryptedData);
                        byte[] _tmpEncryptionIv = _cursor.isNull(_cursorIndexOfEncryptionIv) ? null : _cursor.getBlob(_cursorIndexOfEncryptionIv);
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        _result = new OfflineReaderEntity(_tmpSerialNumber, _tmpLastActivatedAt, _tmpCreated, _tmpAccountId, _tmpEncryptedData, _tmpEncryptionIv, _tmpId);
                    } else {
                        _result = null;
                    }
                    OfflineReaderEntity offlineReaderEntity = _result;
                    return offlineReaderEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object getBySerialsForAccount(String accountId, List<String> serialNumbers, Continuation<? super List<OfflineReaderEntity>> $completion) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM reader WHERE account_id =");
        _stringBuilder.append("?");
        _stringBuilder.append(" AND serial_number in (");
        int _inputSize = serialNumbers.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 1 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        if (accountId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, accountId);
        }
        _argIndex = 2;
        for (String _item : serialNumbers) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<OfflineReaderEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<OfflineReaderEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)OfflineReaderDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfSerialNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"serial_number");
                    int _cursorIndexOfLastActivatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_activated_timestamp");
                    int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"created_timestamp");
                    int _cursorIndexOfAccountId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"account_id");
                    int _cursorIndexOfEncryptedData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data_blob");
                    int _cursorIndexOfEncryptionIv = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iv_blob");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    ArrayList<OfflineReaderEntity> _result = new ArrayList<OfflineReaderEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpSerialNumber = _cursor.isNull(_cursorIndexOfSerialNumber) ? null : _cursor.getString(_cursorIndexOfSerialNumber);
                        long _tmp = _cursor.getLong(_cursorIndexOfLastActivatedAt);
                        Date _tmpLastActivatedAt = OfflineReaderDao_Impl.this.__dateTimeConverter.toDate(_tmp);
                        long _tmp_1 = _cursor.getLong(_cursorIndexOfCreated);
                        Date _tmpCreated = OfflineReaderDao_Impl.this.__dateTimeConverter.toDate(_tmp_1);
                        String _tmpAccountId = _cursor.isNull(_cursorIndexOfAccountId) ? null : _cursor.getString(_cursorIndexOfAccountId);
                        byte[] _tmpEncryptedData = _cursor.isNull(_cursorIndexOfEncryptedData) ? null : _cursor.getBlob(_cursorIndexOfEncryptedData);
                        byte[] _tmpEncryptionIv = _cursor.isNull(_cursorIndexOfEncryptionIv) ? null : _cursor.getBlob(_cursorIndexOfEncryptionIv);
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        OfflineReaderEntity _item_1 = new OfflineReaderEntity(_tmpSerialNumber, _tmpLastActivatedAt, _tmpCreated, _tmpAccountId, _tmpEncryptedData, _tmpEncryptionIv, _tmpId);
                        _result.add(_item_1);
                    }
                    ArrayList<OfflineReaderEntity> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getBySerialAndAccount(String serialNumber, String accountId, Continuation<? super OfflineReaderEntity> $completion) {
        String _sql = "SELECT * FROM reader WHERE serial_number = ? AND account_id = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM reader WHERE serial_number = ? AND account_id = ?", (int)2);
        int _argIndex = 1;
        if (serialNumber == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, serialNumber);
        }
        _argIndex = 2;
        if (accountId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, accountId);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<OfflineReaderEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OfflineReaderEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)OfflineReaderDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    OfflineReaderEntity _result;
                    int _cursorIndexOfSerialNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"serial_number");
                    int _cursorIndexOfLastActivatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_activated_timestamp");
                    int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"created_timestamp");
                    int _cursorIndexOfAccountId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"account_id");
                    int _cursorIndexOfEncryptedData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data_blob");
                    int _cursorIndexOfEncryptionIv = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iv_blob");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    if (_cursor.moveToFirst()) {
                        String _tmpSerialNumber = _cursor.isNull(_cursorIndexOfSerialNumber) ? null : _cursor.getString(_cursorIndexOfSerialNumber);
                        long _tmp = _cursor.getLong(_cursorIndexOfLastActivatedAt);
                        Date _tmpLastActivatedAt = OfflineReaderDao_Impl.this.__dateTimeConverter.toDate(_tmp);
                        long _tmp_1 = _cursor.getLong(_cursorIndexOfCreated);
                        Date _tmpCreated = OfflineReaderDao_Impl.this.__dateTimeConverter.toDate(_tmp_1);
                        String _tmpAccountId = _cursor.isNull(_cursorIndexOfAccountId) ? null : _cursor.getString(_cursorIndexOfAccountId);
                        byte[] _tmpEncryptedData = _cursor.isNull(_cursorIndexOfEncryptedData) ? null : _cursor.getBlob(_cursorIndexOfEncryptedData);
                        byte[] _tmpEncryptionIv = _cursor.isNull(_cursorIndexOfEncryptionIv) ? null : _cursor.getBlob(_cursorIndexOfEncryptionIv);
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        _result = new OfflineReaderEntity(_tmpSerialNumber, _tmpLastActivatedAt, _tmpCreated, _tmpAccountId, _tmpEncryptedData, _tmpEncryptionIv, _tmpId);
                    } else {
                        _result = null;
                    }
                    OfflineReaderEntity offlineReaderEntity = _result;
                    return offlineReaderEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

