/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.offlinemode.storage;

import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.Index;
import androidx.room.PrimaryKey;
import androidx.room.TypeConverters;
import com.stripe.offlinemode.storage.DateTimeConverter;
import com.stripe.offlinemode.storage.OfflineEntity;
import java.util.Arrays;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\tH\u00c6\u0003J\t\u0010 \u001a\u00020\tH\u00c6\u0003J\t\u0010!\u001a\u00020\fH\u00c6\u0003JO\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0096\u0002J\b\u0010'\u001a\u00020(H\u0016J\t\u0010)\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0007\u001a\u00020\u00038\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0006\u001a\u00020\u00058\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\b\u001a\u00020\t8\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\n\u001a\u00020\t8\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u001e\u0010\u000b\u001a\u00020\f8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000f\u00a8\u0006*"}, d2={"Lcom/stripe/offlinemode/storage/OfflineReaderEntity;", "Lcom/stripe/offlinemode/storage/OfflineEntity;", "serialNumber", "", "lastActivatedAt", "Ljava/util/Date;", "created", "accountId", "encryptedData", "", "encryptionIv", "id", "", "(Ljava/lang/String;Ljava/util/Date;Ljava/util/Date;Ljava/lang/String;[B[BJ)V", "getAccountId", "()Ljava/lang/String;", "getCreated", "()Ljava/util/Date;", "getEncryptedData", "()[B", "getEncryptionIv", "getId", "()J", "setId", "(J)V", "getLastActivatedAt", "getSerialNumber", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "", "hashCode", "", "toString", "offlinemode_release"})
@TypeConverters(value={DateTimeConverter.class})
@Entity(tableName="reader", indices={@Index(value={"serial_number", "account_id"}, unique=true)})
public final class OfflineReaderEntity
implements OfflineEntity {
    @ColumnInfo(name="serial_number", index=true)
    @NotNull
    private final String serialNumber;
    @ColumnInfo(name="last_activated_timestamp")
    @NotNull
    private final Date lastActivatedAt;
    @ColumnInfo(name="created_timestamp")
    @NotNull
    private final Date created;
    @ColumnInfo(name="account_id")
    @NotNull
    private final String accountId;
    @ColumnInfo(name="data_blob")
    @NotNull
    private final byte[] encryptedData;
    @ColumnInfo(name="iv_blob")
    @NotNull
    private final byte[] encryptionIv;
    @PrimaryKey(autoGenerate=true)
    @ColumnInfo(name="id")
    private long id;

    public OfflineReaderEntity(@NotNull String serialNumber, @NotNull Date lastActivatedAt, @NotNull Date created, @NotNull String accountId, @NotNull byte[] encryptedData, @NotNull byte[] encryptionIv, long id) {
        Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
        Intrinsics.checkNotNullParameter((Object)lastActivatedAt, (String)"lastActivatedAt");
        Intrinsics.checkNotNullParameter((Object)created, (String)"created");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter((Object)encryptedData, (String)"encryptedData");
        Intrinsics.checkNotNullParameter((Object)encryptionIv, (String)"encryptionIv");
        this.serialNumber = serialNumber;
        this.lastActivatedAt = lastActivatedAt;
        this.created = created;
        this.accountId = accountId;
        this.encryptedData = encryptedData;
        this.encryptionIv = encryptionIv;
        this.id = id;
    }

    public /* synthetic */ OfflineReaderEntity(String string, Date date, Date date2, String string2, byte[] byArray, byte[] byArray2, long l2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x40) != 0) {
            l2 = 0L;
        }
        this(string, date, date2, string2, byArray, byArray2, l2);
    }

    @NotNull
    public final String getSerialNumber() {
        return this.serialNumber;
    }

    @NotNull
    public final Date getLastActivatedAt() {
        return this.lastActivatedAt;
    }

    @Override
    @NotNull
    public Date getCreated() {
        return this.created;
    }

    @Override
    @NotNull
    public String getAccountId() {
        return this.accountId;
    }

    @Override
    @NotNull
    public byte[] getEncryptedData() {
        return this.encryptedData;
    }

    @Override
    @NotNull
    public byte[] getEncryptionIv() {
        return this.encryptionIv;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long l2) {
        this.id = l2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OfflineReaderEntity)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.serialNumber, (Object)((OfflineReaderEntity)other).serialNumber)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lastActivatedAt, (Object)((OfflineReaderEntity)other).lastActivatedAt)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getCreated(), (Object)((OfflineReaderEntity)other).getCreated())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getAccountId(), (Object)((OfflineReaderEntity)other).getAccountId())) {
            return false;
        }
        if (!Arrays.equals(this.getEncryptedData(), ((OfflineReaderEntity)other).getEncryptedData())) {
            return false;
        }
        if (!Arrays.equals(this.getEncryptionIv(), ((OfflineReaderEntity)other).getEncryptionIv())) {
            return false;
        }
        return this.getId() == ((OfflineReaderEntity)other).getId();
    }

    public int hashCode() {
        int result2 = this.serialNumber.hashCode();
        result2 = 31 * result2 + this.lastActivatedAt.hashCode();
        result2 = 31 * result2 + this.getCreated().hashCode();
        result2 = 31 * result2 + this.getAccountId().hashCode();
        result2 = 31 * result2 + Arrays.hashCode(this.getEncryptedData());
        result2 = 31 * result2 + Arrays.hashCode(this.getEncryptionIv());
        result2 = 31 * result2 + Long.hashCode(this.getId());
        return result2;
    }

    @NotNull
    public final String component1() {
        return this.serialNumber;
    }

    @NotNull
    public final Date component2() {
        return this.lastActivatedAt;
    }

    @NotNull
    public final Date component3() {
        return this.created;
    }

    @NotNull
    public final String component4() {
        return this.accountId;
    }

    @NotNull
    public final byte[] component5() {
        return this.encryptedData;
    }

    @NotNull
    public final byte[] component6() {
        return this.encryptionIv;
    }

    public final long component7() {
        return this.id;
    }

    @NotNull
    public final OfflineReaderEntity copy(@NotNull String serialNumber, @NotNull Date lastActivatedAt, @NotNull Date created, @NotNull String accountId, @NotNull byte[] encryptedData, @NotNull byte[] encryptionIv, long id) {
        Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
        Intrinsics.checkNotNullParameter((Object)lastActivatedAt, (String)"lastActivatedAt");
        Intrinsics.checkNotNullParameter((Object)created, (String)"created");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter((Object)encryptedData, (String)"encryptedData");
        Intrinsics.checkNotNullParameter((Object)encryptionIv, (String)"encryptionIv");
        return new OfflineReaderEntity(serialNumber, lastActivatedAt, created, accountId, encryptedData, encryptionIv, id);
    }

    public static /* synthetic */ OfflineReaderEntity copy$default(OfflineReaderEntity offlineReaderEntity, String string, Date date, Date date2, String string2, byte[] byArray, byte[] byArray2, long l2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = offlineReaderEntity.serialNumber;
        }
        if ((n2 & 2) != 0) {
            date = offlineReaderEntity.lastActivatedAt;
        }
        if ((n2 & 4) != 0) {
            date2 = offlineReaderEntity.created;
        }
        if ((n2 & 8) != 0) {
            string2 = offlineReaderEntity.accountId;
        }
        if ((n2 & 0x10) != 0) {
            byArray = offlineReaderEntity.encryptedData;
        }
        if ((n2 & 0x20) != 0) {
            byArray2 = offlineReaderEntity.encryptionIv;
        }
        if ((n2 & 0x40) != 0) {
            l2 = offlineReaderEntity.id;
        }
        return offlineReaderEntity.copy(string, date, date2, string2, byArray, byArray2, l2);
    }

    @NotNull
    public String toString() {
        return "OfflineReaderEntity(serialNumber=" + this.serialNumber + ", lastActivatedAt=" + this.lastActivatedAt + ", created=" + this.created + ", accountId=" + this.accountId + ", encryptedData=" + Arrays.toString(this.encryptedData) + ", encryptionIv=" + Arrays.toString(this.encryptionIv) + ", id=" + this.id + ')';
    }
}

