/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.offlinemode.storage;

import com.stripe.jvmcore.logging.terminal.contracts.Logger;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.offlinemode.dagger.DefaultOfflineRepositoryFactory;
import com.stripe.offlinemode.helpers.OfflineApiLevelChecker;
import com.stripe.offlinemode.models.ForwardOfflinePaymentRequest;
import com.stripe.offlinemode.models.OfflineRequestsToSync;
import com.stripe.offlinemode.storage.OfflineRepository;
import com.stripe.offlinemode.storage.UnsupportedOfflineRepository;
import com.stripe.proto.model.merchant.ApiLocationPb;
import com.stripe.proto.model.offline_mode.OfflineConnection;
import com.stripe.proto.model.offline_mode.OfflinePaymentIntentRequest;
import com.stripe.proto.model.offline_mode.OfflineReader;
import com.stripe.proto.model.rest.PaymentIntent;
import com.stripe.proto.terminal.terminal.pub.message.config.OfflineConfigPb;
import com.stripe.stripeterminal.external.models.Reader;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 Y2\u00020\u0001:\u0001YB/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t\u00a2\u0006\u0002\u0010\nB\u000f\b\u0002\u0012\u0006\u0010\u000b\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\fJ\u000f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0096\u0001J\t\u0010'\u001a\u00020(H\u0096\u0001J\u0019\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020+H\u0096A\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J\u001b\u0010-\u001a\u00020(2\b\b\u0002\u0010.\u001a\u00020\u000eH\u0096A\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010/J\u001f\u00100\u001a\b\u0012\u0004\u0012\u000202012\u0006\u0010.\u001a\u00020\u000eH\u0096A\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010/J\u0011\u00103\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0%H\u0096\u0001J\u0011\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u0014H\u0096\u0001J\u001d\u00107\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020508012\u0006\u0010.\u001a\u00020\u000eH\u0096\u0001J\u0017\u00109\u001a\b\u0012\u0004\u0012\u00020:012\u0006\u0010.\u001a\u00020\u000eH\u0096\u0001J\u001b\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010=\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u000eH\u0096\u0001J)\u0010>\u001a\u0010\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u000205\u0018\u00010?2\u0006\u0010@\u001a\u00020A2\b\b\u0002\u0010.\u001a\u00020\u000eH\u0096\u0001J\u001d\u0010B\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<08012\u0006\u0010.\u001a\u00020\u000eH\u0096\u0001J-\u0010C\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020D0\u001d2\b\b\u0002\u0010.\u001a\u00020\u000e2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u000e08H\u0096\u0001J\u001b\u0010F\u001a\u00020\u001a2\u0006\u0010G\u001a\u00020\u000e2\b\b\u0002\u0010.\u001a\u00020\u000eH\u0096\u0001J\t\u0010H\u001a\u00020\u001aH\u0096\u0001J\u0013\u0010I\u001a\u00020(2\b\b\u0002\u0010.\u001a\u00020\u000eH\u0096\u0001J\u0011\u0010J\u001a\u00020(2\u0006\u0010K\u001a\u00020+H\u0096\u0001J\u0019\u0010L\u001a\u00020\u00142\u0006\u0010M\u001a\u00020<2\u0006\u0010N\u001a\u000205H\u0096\u0001J\u0019\u0010O\u001a\u00020!2\u0006\u0010P\u001a\u00020+H\u0096A\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J)\u0010Q\u001a\u00020(2\u0006\u0010G\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u000e2\u0006\u0010R\u001a\u00020&H\u0096A\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010SJ!\u0010T\u001a\u00020(2\u0006\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020+H\u0096A\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010XR\u0018\u0010\r\u001a\u00020\u000eX\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\u00020\u0014X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0019\u001a\u00020\u001aX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR\u001e\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00140\u001dX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0012\u0010 \u001a\u00020!X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006Z"}, d2={"Lcom/stripe/offlinemode/storage/ProxyOfflineRepository;", "Lcom/stripe/offlinemode/storage/OfflineRepository;", "offlineApiLevelChecker", "Lcom/stripe/offlinemode/helpers/OfflineApiLevelChecker;", "unsupportedOfflineRepository", "Lcom/stripe/offlinemode/storage/UnsupportedOfflineRepository;", "defaultOfflineRepositoryFactory", "Lcom/stripe/offlinemode/dagger/DefaultOfflineRepositoryFactory;", "logger", "Lcom/stripe/jvmcore/logging/terminal/contracts/Logger;", "(Lcom/stripe/offlinemode/helpers/OfflineApiLevelChecker;Lcom/stripe/offlinemode/storage/UnsupportedOfflineRepository;Lcom/stripe/offlinemode/dagger/DefaultOfflineRepositoryFactory;Lcom/stripe/jvmcore/logging/terminal/contracts/Logger;)V", "proxy", "(Lcom/stripe/offlinemode/storage/OfflineRepository;)V", "activeAccountId", "", "getActiveAccountId", "()Ljava/lang/String;", "setActiveAccountId", "(Ljava/lang/String;)V", "currentConnectionId", "", "getCurrentConnectionId", "()J", "setCurrentConnectionId", "(J)V", "isSupported", "", "()Z", "offlinePaymentAmountsByCurrency", "", "getOfflinePaymentAmountsByCurrency", "()Ljava/util/Map;", "offlinePaymentsCount", "", "getOfflinePaymentsCount", "()I", "activeReaderOfflineConfigFlow", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/stripe/proto/terminal/terminal/pub/message/config/OfflineConfigPb$ReaderOfflineConfigPb;", "clearCache", "", "delete", "toDelete", "Lcom/stripe/proto/model/offline_mode/OfflinePaymentIntentRequest;", "(Lcom/stripe/proto/model/offline_mode/OfflinePaymentIntentRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteExpiredEntities", "accountId", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetchNextToForward", "Lkotlinx/coroutines/flow/Flow;", "Lcom/stripe/offlinemode/models/ForwardOfflinePaymentRequest;", "getActiveAccountFlow", "getOfflineConnection", "Lcom/stripe/proto/model/offline_mode/OfflineConnection;", "connectionId", "getOfflineConnections", "", "getOfflinePaymentRequestsToSync", "Lcom/stripe/offlinemode/models/OfflineRequestsToSync;", "getOfflineReader", "Lcom/stripe/proto/model/offline_mode/OfflineReader;", "serialNumber", "getOfflineReaderAndConnectionIfSaved", "Lkotlin/Pair;", "reader", "Lcom/stripe/stripeterminal/external/models/Reader;", "getOfflineReaders", "getSavedLocationsMap", "Lcom/stripe/proto/model/merchant/ApiLocationPb;", "serials", "isOfflineEnabledForReader", "readerSerial", "isOfflineModeEnabledOnActiveReader", "restoreSoftDeletedPayments", "saveOfflinePaymentIntentRequest", "offlinePaymentIntentRequest", "saveOfflineReaderAndConnection", "offlineReader", "offlineConnection", "softDelete", "toSoftDelete", "updateOfflineReaderWithConfig", "config", "(Ljava/lang/String;Ljava/lang/String;Lcom/stripe/proto/terminal/terminal/pub/message/config/OfflineConfigPb$ReaderOfflineConfigPb;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateWithOnlinePaymentIntent", "paymentIntent", "Lcom/stripe/proto/model/rest/PaymentIntent;", "createRequest", "(Lcom/stripe/proto/model/rest/PaymentIntent;Lcom/stripe/proto/model/offline_mode/OfflinePaymentIntentRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "offlinemode_release"})
public final class ProxyOfflineRepository
implements OfflineRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OfflineRepository proxy;
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(ProxyOfflineRepository.class);

    private ProxyOfflineRepository(OfflineRepository proxy) {
        this.proxy = proxy;
    }

    @Override
    @NotNull
    public String getActiveAccountId() {
        return this.proxy.getActiveAccountId();
    }

    @Override
    public void setActiveAccountId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.proxy.setActiveAccountId(string);
    }

    @Override
    public long getCurrentConnectionId() {
        return this.proxy.getCurrentConnectionId();
    }

    @Override
    public void setCurrentConnectionId(long l2) {
        this.proxy.setCurrentConnectionId(l2);
    }

    @Override
    public boolean isSupported() {
        return this.proxy.isSupported();
    }

    @Override
    @NotNull
    public Map<String, Long> getOfflinePaymentAmountsByCurrency() {
        return this.proxy.getOfflinePaymentAmountsByCurrency();
    }

    @Override
    public int getOfflinePaymentsCount() {
        return this.proxy.getOfflinePaymentsCount();
    }

    @Override
    @NotNull
    public StateFlow<OfflineConfigPb.ReaderOfflineConfigPb> activeReaderOfflineConfigFlow() {
        return this.proxy.activeReaderOfflineConfigFlow();
    }

    @Override
    public void clearCache() {
        this.proxy.clearCache();
    }

    @Override
    @Nullable
    public Object delete(@NotNull OfflinePaymentIntentRequest toDelete, @NotNull Continuation<? super Unit> $completion) {
        return this.proxy.delete(toDelete, $completion);
    }

    @Override
    @Nullable
    public Object deleteExpiredEntities(@NotNull String accountId, @NotNull Continuation<? super Unit> $completion) {
        return this.proxy.deleteExpiredEntities(accountId, $completion);
    }

    @Override
    @Nullable
    public Object fetchNextToForward(@NotNull String accountId, @NotNull Continuation<? super Flow<ForwardOfflinePaymentRequest>> $completion) {
        return this.proxy.fetchNextToForward(accountId, $completion);
    }

    @Override
    @NotNull
    public StateFlow<String> getActiveAccountFlow() {
        return this.proxy.getActiveAccountFlow();
    }

    @Override
    @NotNull
    public OfflineConnection getOfflineConnection(long connectionId) {
        return this.proxy.getOfflineConnection(connectionId);
    }

    @Override
    @NotNull
    public Flow<List<OfflineConnection>> getOfflineConnections(@NotNull String accountId) {
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        return this.proxy.getOfflineConnections(accountId);
    }

    @Override
    @NotNull
    public Flow<OfflineRequestsToSync> getOfflinePaymentRequestsToSync(@NotNull String accountId) {
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        return this.proxy.getOfflinePaymentRequestsToSync(accountId);
    }

    @Override
    @Nullable
    public OfflineReader getOfflineReader(@NotNull String serialNumber, @NotNull String accountId) {
        Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        return this.proxy.getOfflineReader(serialNumber, accountId);
    }

    @Override
    @Nullable
    public Pair<OfflineReader, OfflineConnection> getOfflineReaderAndConnectionIfSaved(@NotNull Reader reader, @NotNull String accountId) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        return this.proxy.getOfflineReaderAndConnectionIfSaved(reader, accountId);
    }

    @Override
    @NotNull
    public Flow<List<OfflineReader>> getOfflineReaders(@NotNull String accountId) {
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        return this.proxy.getOfflineReaders(accountId);
    }

    @Override
    @NotNull
    public Map<String, ApiLocationPb> getSavedLocationsMap(@NotNull String accountId, @NotNull List<String> serials) {
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter(serials, (String)"serials");
        return this.proxy.getSavedLocationsMap(accountId, serials);
    }

    @Override
    public boolean isOfflineEnabledForReader(@NotNull String readerSerial, @NotNull String accountId) {
        Intrinsics.checkNotNullParameter((Object)readerSerial, (String)"readerSerial");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        return this.proxy.isOfflineEnabledForReader(readerSerial, accountId);
    }

    @Override
    public boolean isOfflineModeEnabledOnActiveReader() {
        return this.proxy.isOfflineModeEnabledOnActiveReader();
    }

    @Override
    public void restoreSoftDeletedPayments(@NotNull String accountId) {
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        this.proxy.restoreSoftDeletedPayments(accountId);
    }

    @Override
    public void saveOfflinePaymentIntentRequest(@NotNull OfflinePaymentIntentRequest offlinePaymentIntentRequest) {
        Intrinsics.checkNotNullParameter((Object)((Object)offlinePaymentIntentRequest), (String)"offlinePaymentIntentRequest");
        this.proxy.saveOfflinePaymentIntentRequest(offlinePaymentIntentRequest);
    }

    @Override
    public long saveOfflineReaderAndConnection(@NotNull OfflineReader offlineReader, @NotNull OfflineConnection offlineConnection) {
        Intrinsics.checkNotNullParameter((Object)((Object)offlineReader), (String)"offlineReader");
        Intrinsics.checkNotNullParameter((Object)((Object)offlineConnection), (String)"offlineConnection");
        return this.proxy.saveOfflineReaderAndConnection(offlineReader, offlineConnection);
    }

    @Override
    @Nullable
    public Object softDelete(@NotNull OfflinePaymentIntentRequest toSoftDelete, @NotNull Continuation<? super Integer> $completion) {
        return this.proxy.softDelete(toSoftDelete, $completion);
    }

    @Override
    @Nullable
    public Object updateOfflineReaderWithConfig(@NotNull String readerSerial, @NotNull String accountId, @NotNull OfflineConfigPb.ReaderOfflineConfigPb config, @NotNull Continuation<? super Unit> $completion) {
        return this.proxy.updateOfflineReaderWithConfig(readerSerial, accountId, config, $completion);
    }

    @Override
    @Nullable
    public Object updateWithOnlinePaymentIntent(@NotNull PaymentIntent paymentIntent2, @NotNull OfflinePaymentIntentRequest createRequest, @NotNull Continuation<? super Unit> $completion) {
        return this.proxy.updateWithOnlinePaymentIntent(paymentIntent2, createRequest, $completion);
    }

    /*
     * WARNING - void declaration
     */
    public ProxyOfflineRepository(@NotNull OfflineApiLevelChecker offlineApiLevelChecker, @NotNull UnsupportedOfflineRepository unsupportedOfflineRepository, @NotNull DefaultOfflineRepositoryFactory defaultOfflineRepositoryFactory, @NotNull Logger<?, ?> logger2) {
        OfflineRepository offlineRepository;
        Intrinsics.checkNotNullParameter((Object)offlineApiLevelChecker, (String)"offlineApiLevelChecker");
        Intrinsics.checkNotNullParameter((Object)unsupportedOfflineRepository, (String)"unsupportedOfflineRepository");
        Intrinsics.checkNotNullParameter((Object)defaultOfflineRepositoryFactory, (String)"defaultOfflineRepositoryFactory");
        Intrinsics.checkNotNullParameter(logger2, (String)"logger");
        ProxyOfflineRepository proxyOfflineRepository = this;
        if (offlineApiLevelChecker.doesApiLevelSupportOffline()) {
            OfflineRepository offlineRepository2;
            ProxyOfflineRepository proxyOfflineRepository2 = proxyOfflineRepository;
            try {
                proxyOfflineRepository = proxyOfflineRepository2;
                offlineRepository2 = defaultOfflineRepositoryFactory.create(logger2);
            }
            catch (Throwable throwable) {
                void e2;
                proxyOfflineRepository = proxyOfflineRepository2;
                LOGGER.w((Throwable)e2, "Failed to initialize offline repository, falling back to unsupported version.", new Pair[0]);
                offlineRepository2 = unsupportedOfflineRepository;
            }
            offlineRepository = offlineRepository2;
        } else {
            offlineRepository = unsupportedOfflineRepository;
        }
        proxyOfflineRepository(offlineRepository);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/offlinemode/storage/ProxyOfflineRepository$Companion;", "", "()V", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "offlinemode_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

