/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.sentry.http;

import com.stripe.sentry.http.SentryConfig;
import com.stripe.sentry.http.models.Contexts;
import com.stripe.sentry.http.models.Dsn;
import com.stripe.sentry.http.models.EnvironmentConfig;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\u0015\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\nH\u00c6\u0003JG\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u00c6\u0001J\u0015\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\t\u0010&\u001a\u00020\nH\u00d6\u0001J\f\u0010'\u001a\u00020\n*\u00020\u001fH\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006("}, d2={"Lcom/stripe/sentry/http/SentryConfig;", "", "dsn", "Lcom/stripe/sentry/http/models/Dsn;", "environment", "Lcom/stripe/sentry/http/models/EnvironmentConfig;", "contexts", "Lcom/stripe/sentry/http/models/Contexts;", "customTags", "", "", "userAgent", "(Lcom/stripe/sentry/http/models/Dsn;Lcom/stripe/sentry/http/models/EnvironmentConfig;Lcom/stripe/sentry/http/models/Contexts;Ljava/util/Map;Ljava/lang/String;)V", "getContexts", "()Lcom/stripe/sentry/http/models/Contexts;", "getCustomTags", "()Ljava/util/Map;", "getDsn", "()Lcom/stripe/sentry/http/models/Dsn;", "getEnvironment", "()Lcom/stripe/sentry/http/models/EnvironmentConfig;", "getUserAgent", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "copy", "createAuthHeader", "timestamp", "Lkotlinx/datetime/Instant;", "createAuthHeader$sentry_http", "equals", "", "other", "hashCode", "", "toString", "formatEpochDecimalSeconds", "sentry-http"})
@SourceDebugExtension(value={"SMAP\nSentryConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SentryConfig.kt\ncom/stripe/sentry/http/SentryConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
public final class SentryConfig {
    @NotNull
    private final Dsn dsn;
    @NotNull
    private final EnvironmentConfig environment;
    @NotNull
    private final Contexts contexts;
    @NotNull
    private final Map<String, String> customTags;
    @NotNull
    private final String userAgent;

    public SentryConfig(@NotNull Dsn dsn, @NotNull EnvironmentConfig environment, @NotNull Contexts contexts, @NotNull Map<String, String> customTags, @NotNull String userAgent) {
        Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)contexts, (String)"contexts");
        Intrinsics.checkNotNullParameter(customTags, (String)"customTags");
        Intrinsics.checkNotNullParameter((Object)userAgent, (String)"userAgent");
        this.dsn = dsn;
        this.environment = environment;
        this.contexts = contexts;
        this.customTags = customTags;
        this.userAgent = userAgent;
    }

    public /* synthetic */ SentryConfig(Dsn dsn, EnvironmentConfig environmentConfig, Contexts contexts, Map map2, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n2 & 0x10) != 0) {
            string = "Stripe-Sentry (jvm)";
        }
        this(dsn, environmentConfig, contexts, map2, string);
    }

    @NotNull
    public final Dsn getDsn() {
        return this.dsn;
    }

    @NotNull
    public final EnvironmentConfig getEnvironment() {
        return this.environment;
    }

    @NotNull
    public final Contexts getContexts() {
        return this.contexts;
    }

    @NotNull
    public final Map<String, String> getCustomTags() {
        return this.customTags;
    }

    @NotNull
    public final String getUserAgent() {
        return this.userAgent;
    }

    @NotNull
    public final String createAuthHeader$sentry_http(@NotNull Instant timestamp) {
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"sentry_key", (Object)this.dsn.getKey()), TuplesKt.to((Object)"sentry_version", (Object)"7"), TuplesKt.to((Object)"sentry_timestamp", (Object)this.formatEpochDecimalSeconds(timestamp)), TuplesKt.to((Object)"sentry_client", (Object)this.userAgent)};
        String it = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), null, null, null, (int)0, null, (Function1)createAuthHeader.1.INSTANCE, (int)31, null);
        boolean bl = false;
        return "Sentry " + it;
    }

    private final String formatEpochDecimalSeconds(Instant $this$formatEpochDecimalSeconds) {
        long fraction = $this$formatEpochDecimalSeconds.toEpochMilliseconds() - Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((long)$this$formatEpochDecimalSeconds.getEpochSeconds(), (DurationUnit)DurationUnit.SECONDS));
        return "" + $this$formatEpochDecimalSeconds.getEpochSeconds() + '.' + fraction;
    }

    @NotNull
    public final Dsn component1() {
        return this.dsn;
    }

    @NotNull
    public final EnvironmentConfig component2() {
        return this.environment;
    }

    @NotNull
    public final Contexts component3() {
        return this.contexts;
    }

    @NotNull
    public final Map<String, String> component4() {
        return this.customTags;
    }

    @NotNull
    public final String component5() {
        return this.userAgent;
    }

    @NotNull
    public final SentryConfig copy(@NotNull Dsn dsn, @NotNull EnvironmentConfig environment, @NotNull Contexts contexts, @NotNull Map<String, String> customTags, @NotNull String userAgent) {
        Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)contexts, (String)"contexts");
        Intrinsics.checkNotNullParameter(customTags, (String)"customTags");
        Intrinsics.checkNotNullParameter((Object)userAgent, (String)"userAgent");
        return new SentryConfig(dsn, environment, contexts, customTags, userAgent);
    }

    public static /* synthetic */ SentryConfig copy$default(SentryConfig sentryConfig, Dsn dsn, EnvironmentConfig environmentConfig, Contexts contexts, Map map2, String string, int n2, Object object) {
        if ((n2 & 1) != 0) {
            dsn = sentryConfig.dsn;
        }
        if ((n2 & 2) != 0) {
            environmentConfig = sentryConfig.environment;
        }
        if ((n2 & 4) != 0) {
            contexts = sentryConfig.contexts;
        }
        if ((n2 & 8) != 0) {
            map2 = sentryConfig.customTags;
        }
        if ((n2 & 0x10) != 0) {
            string = sentryConfig.userAgent;
        }
        return sentryConfig.copy(dsn, environmentConfig, contexts, map2, string);
    }

    @NotNull
    public String toString() {
        return "SentryConfig(dsn=" + this.dsn + ", environment=" + this.environment + ", contexts=" + this.contexts + ", customTags=" + this.customTags + ", userAgent=" + this.userAgent + ')';
    }

    public int hashCode() {
        int result2 = this.dsn.hashCode();
        result2 = result2 * 31 + this.environment.hashCode();
        result2 = result2 * 31 + this.contexts.hashCode();
        result2 = result2 * 31 + ((Object)this.customTags).hashCode();
        result2 = result2 * 31 + this.userAgent.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SentryConfig)) {
            return false;
        }
        SentryConfig sentryConfig = (SentryConfig)other;
        if (!Intrinsics.areEqual((Object)this.dsn, (Object)sentryConfig.dsn)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.environment, (Object)sentryConfig.environment)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.contexts, (Object)sentryConfig.contexts)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.customTags, sentryConfig.customTags)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.userAgent, (Object)sentryConfig.userAgent);
    }
}

