/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.sentry.http.models;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/stripe/sentry/http/models/Dsn;", "", "projectId", "", "key", "host", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getHost", "()Ljava/lang/String;", "getKey", "getProjectId", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "sentry-http"})
public final class Dsn {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String projectId;
    @NotNull
    private final String key;
    @NotNull
    private final String host;
    @NotNull
    private static final Regex DSN_PATTERN = new Regex("https://([a-zA-Z\\d]+)@([a-zA-Z\\d.-]+)/(\\d+)");

    public Dsn(@NotNull String projectId, @NotNull String key, @NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.projectId = projectId;
        this.key = key;
        this.host = host;
    }

    @NotNull
    public final String getProjectId() {
        return this.projectId;
    }

    @NotNull
    public final String getKey() {
        return this.key;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    @NotNull
    public final String component1() {
        return this.projectId;
    }

    @NotNull
    public final String component2() {
        return this.key;
    }

    @NotNull
    public final String component3() {
        return this.host;
    }

    @NotNull
    public final Dsn copy(@NotNull String projectId, @NotNull String key, @NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return new Dsn(projectId, key, host);
    }

    public static /* synthetic */ Dsn copy$default(Dsn dsn, String string, String string2, String string3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = dsn.projectId;
        }
        if ((n2 & 2) != 0) {
            string2 = dsn.key;
        }
        if ((n2 & 4) != 0) {
            string3 = dsn.host;
        }
        return dsn.copy(string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "Dsn(projectId=" + this.projectId + ", key=" + this.key + ", host=" + this.host + ')';
    }

    public int hashCode() {
        int result2 = this.projectId.hashCode();
        result2 = result2 * 31 + this.key.hashCode();
        result2 = result2 * 31 + this.host.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Dsn)) {
            return false;
        }
        Dsn dsn = (Dsn)other;
        if (!Intrinsics.areEqual((Object)this.projectId, (Object)dsn.projectId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.key, (Object)dsn.key)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.host, (Object)dsn.host);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/stripe/sentry/http/models/Dsn$Companion;", "", "()V", "DSN_PATTERN", "Lkotlin/text/Regex;", "fromString", "Lcom/stripe/sentry/http/models/Dsn;", "dsn", "", "sentry-http"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Dsn fromString(@NotNull String dsn) {
            Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
            MatchResult matchResult = DSN_PATTERN.matchEntire((CharSequence)dsn);
            if (matchResult == null) {
                throw new IllegalArgumentException("Invalid DSN format");
            }
            MatchResult match = matchResult;
            Object object = match.getGroups().get(1);
            if (object == null || (object = object.getValue()) == null) {
                throw new IllegalArgumentException("DSN missing key");
            }
            Object key = object;
            Object object2 = match.getGroups().get(2);
            if (object2 == null || (object2 = object2.getValue()) == null) {
                throw new IllegalArgumentException("DSN missing host");
            }
            Object host = object2;
            Object object3 = match.getGroups().get(3);
            if (object3 == null || (object3 = object3.getValue()) == null) {
                throw new IllegalArgumentException("DSN missing project ID");
            }
            Object projectId = object3;
            return new Dsn((String)projectId, (String)key, (String)host);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

