/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common;

import android.annotation.SuppressLint;
import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Looper;
import android.os.Process;
import androidx.annotation.VisibleForTesting;
import com.stripe.jvmcore.dagger.ForApplication;
import com.stripe.jvmcore.logging.terminal.log.Log;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0011\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0003J\u0006\u0010\u001d\u001a\u00020\u001bJ\u0006\u0010\u001e\u001a\u00020\u001bR\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/stripe/stripeterminal/internal/common/LocationHandler;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "appContext", "cachedLocation", "Landroid/location/Location;", "listeningToLocations", "", "getListeningToLocations$annotations", "()V", "getListeningToLocations", "()Z", "setListeningToLocations", "(Z)V", "location", "getLocation", "()Landroid/location/Location;", "locationListener", "Landroid/location/LocationListener;", "locationManager", "Landroid/location/LocationManager;", "isPermissionGranted", "permission", "", "requestUpdates", "", "provider", "startListening", "stopListening", "Companion", "common_publish"})
public class LocationHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context appContext;
    @NotNull
    private final LocationManager locationManager;
    @NotNull
    private final LocationListener locationListener;
    private boolean listeningToLocations;
    @Nullable
    private Location cachedLocation;
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(LocationHandler.class);
    private static final long MIN_TIME_DIFF_MS = 600000L;

    @Inject
    public LocationHandler(@ForApplication @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        this.appContext = context2;
        Object object = context.getSystemService("location");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.location.LocationManager");
        this.locationManager = (LocationManager)object;
        this.locationListener = new LocationListener(){

            public void onLocationChanged(@NotNull Location location) {
                Intrinsics.checkNotNullParameter((Object)location, (String)"location");
                cachedLocation = location;
            }

            public void onProviderDisabled(@NotNull String s2) {
                Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
            }

            public void onStatusChanged(@NotNull String s2, int i2, @NotNull Bundle bundle) {
                Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            }

            public void onProviderEnabled(@NotNull String s2) {
                Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
            }
        };
        this.startListening();
    }

    public final boolean getListeningToLocations() {
        return this.listeningToLocations;
    }

    public final void setListeningToLocations(boolean bl) {
        this.listeningToLocations = bl;
    }

    @VisibleForTesting
    public static /* synthetic */ void getListeningToLocations$annotations() {
    }

    @Nullable
    public Location getLocation() {
        return this.cachedLocation;
    }

    public final void startListening() {
        if (this.listeningToLocations) {
            return;
        }
        LOGGER.d("startListening", new Pair[0]);
        if (this.isPermissionGranted("android.permission.ACCESS_COARSE_LOCATION") && this.locationManager.isProviderEnabled("network")) {
            this.requestUpdates("network");
        }
        if (this.isPermissionGranted("android.permission.ACCESS_FINE_LOCATION")) {
            if (this.locationManager.isProviderEnabled("gps")) {
                this.requestUpdates("gps");
            }
            if (this.locationManager.isProviderEnabled("passive")) {
                this.requestUpdates("passive");
            }
        }
        this.listeningToLocations = true;
    }

    public final void stopListening() {
        LOGGER.d("stopListening", new Pair[0]);
        this.locationManager.removeUpdates(this.locationListener);
        this.listeningToLocations = false;
    }

    @SuppressLint(value={"MissingPermission"})
    private final void requestUpdates(String provider) {
        Location location = this.locationManager.getLastKnownLocation(provider);
        if (location != null) {
            this.cachedLocation = location;
        }
        this.locationManager.requestLocationUpdates(provider, 600000L, 0.0f, this.locationListener, Looper.getMainLooper());
    }

    private final boolean isPermissionGranted(String permission) {
        return this.appContext.checkPermission(permission, Process.myPid(), Process.myUid()) == 0;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/stripeterminal/internal/common/LocationHandler$Companion;", "", "()V", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "MIN_TIME_DIFF_MS", "", "common_publish"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

