/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common;

import com.stripe.core.transaction.TransactionRepository;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.stripeterminal.external.callable.Cancelable;
import com.stripe.stripeterminal.external.callable.ReaderReconnectionListener;
import com.stripe.stripeterminal.external.callable.TerminalListener;
import com.stripe.stripeterminal.external.models.ConnectionStatus;
import com.stripe.stripeterminal.external.models.PaymentStatus;
import com.stripe.stripeterminal.external.models.Reader;
import com.stripe.stripeterminal.external.models.ReaderBatteryInfo;
import com.stripe.stripeterminal.external.models.ReaderDisplayMessage;
import com.stripe.stripeterminal.external.models.ReaderEvent;
import com.stripe.stripeterminal.external.models.ReaderInputOptions;
import com.stripe.stripeterminal.external.models.ReaderSoftwareUpdate;
import com.stripe.stripeterminal.external.models.TerminalException;
import com.stripe.stripeterminal.internal.common.callable.ProxyReaderListener;
import java.util.EnumSet;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 J2\u00020\u0001:\u0001JB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\bJ\u000e\u0010#\u001a\u00020!2\u0006\u0010\"\u001a\u00020\bJ\u0006\u0010$\u001a\u00020!J\u001c\u0010%\u001a\u00020!2\b\u0010&\u001a\u0004\u0018\u00010'2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)J\u0006\u0010*\u001a\u00020!J\u0006\u0010+\u001a\u00020!J\u0006\u0010,\u001a\u00020!J\u000e\u0010-\u001a\u00020!2\u0006\u0010\"\u001a\u00020\bJ\u000e\u0010.\u001a\u00020!2\u0006\u0010\"\u001a\u00020\bJ\u0006\u0010/\u001a\u00020!J\u0010\u00100\u001a\u00020!2\b\u00101\u001a\u0004\u0018\u000102J\u000e\u00103\u001a\u00020!2\u0006\u00104\u001a\u000205J\u000e\u00106\u001a\u00020!2\u0006\u00107\u001a\u000208J\u000e\u00109\u001a\u00020!2\u0006\u0010&\u001a\u00020'J\u000e\u0010:\u001a\u00020!2\u0006\u0010;\u001a\u00020<J\u000e\u0010=\u001a\u00020!2\u0006\u0010>\u001a\u00020?J\u0016\u0010@\u001a\u00020!2\u0006\u0010&\u001a\u00020'2\u0006\u0010A\u001a\u00020BJ\u0016\u0010C\u001a\u00020!2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010D\u001a\u00020BJ\u0006\u0010E\u001a\u00020!J\u0010\u0010F\u001a\u00020!2\u0006\u0010G\u001a\u00020\fH\u0002J\u0010\u0010H\u001a\u00020!2\u0006\u0010G\u001a\u00020\u0010H\u0002J\u0006\u0010I\u001a\u00020!R\"\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/stripe/stripeterminal/internal/common/TerminalStatusManager;", "", "listener", "Lcom/stripe/stripeterminal/external/callable/TerminalListener;", "transactionRepository", "Lcom/stripe/core/transaction/TransactionRepository;", "(Lcom/stripe/stripeterminal/external/callable/TerminalListener;Lcom/stripe/core/transaction/TransactionRepository;)V", "<set-?>", "Lcom/stripe/stripeterminal/external/models/Reader;", "connectedReader", "getConnectedReader", "()Lcom/stripe/stripeterminal/external/models/Reader;", "Lcom/stripe/stripeterminal/external/models/ConnectionStatus;", "connectionStatus", "getConnectionStatus", "()Lcom/stripe/stripeterminal/external/models/ConnectionStatus;", "Lcom/stripe/stripeterminal/external/models/PaymentStatus;", "paymentStatus", "getPaymentStatus", "()Lcom/stripe/stripeterminal/external/models/PaymentStatus;", "readerListener", "Lcom/stripe/stripeterminal/internal/common/callable/ProxyReaderListener;", "getReaderListener", "()Lcom/stripe/stripeterminal/internal/common/callable/ProxyReaderListener;", "setReaderListener", "(Lcom/stripe/stripeterminal/internal/common/callable/ProxyReaderListener;)V", "readerReconnectionListener", "Lcom/stripe/stripeterminal/external/callable/ReaderReconnectionListener;", "getReaderReconnectionListener", "()Lcom/stripe/stripeterminal/external/callable/ReaderReconnectionListener;", "setReaderReconnectionListener", "(Lcom/stripe/stripeterminal/external/callable/ReaderReconnectionListener;)V", "connected", "", "reader", "connecting", "endPaymentFlow", "finishInstallingUpdate", "update", "Lcom/stripe/stripeterminal/external/models/ReaderSoftwareUpdate;", "e", "Lcom/stripe/stripeterminal/external/models/TerminalException;", "notConnected", "processing", "readyForPayment", "reconnectFailed", "reconnected", "reportLowBatteryWarning", "reportReaderBatteryInfo", "readerBatteryInfo", "Lcom/stripe/stripeterminal/external/models/ReaderBatteryInfo;", "reportReaderEvent", "event", "Lcom/stripe/stripeterminal/external/models/ReaderEvent;", "reportReaderSoftwareUpdateProgress", "progress", "", "reportUpdateAvailable", "requestReaderDisplayMessage", "message", "Lcom/stripe/stripeterminal/external/models/ReaderDisplayMessage;", "requestReaderInput", "options", "Lcom/stripe/stripeterminal/external/models/ReaderInputOptions;", "startInstallingUpdate", "cancelable", "Lcom/stripe/stripeterminal/external/callable/Cancelable;", "startReconnecting", "cancelReconnect", "unexpectedDisconnect", "updateConnectionStatus", "status", "updatePaymentStatus", "waitForInput", "Companion", "common_publish"})
public final class TerminalStatusManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalListener listener;
    @NotNull
    private final TransactionRepository transactionRepository;
    @Nullable
    private Reader connectedReader;
    @Nullable
    private ProxyReaderListener readerListener;
    @Nullable
    private ReaderReconnectionListener readerReconnectionListener;
    @NotNull
    private ConnectionStatus connectionStatus;
    @NotNull
    private PaymentStatus paymentStatus;
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(TerminalStatusManager.class);

    @Inject
    public TerminalStatusManager(@NotNull TerminalListener listener2, @NotNull TransactionRepository transactionRepository) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)transactionRepository, (String)"transactionRepository");
        this.listener = listener2;
        this.transactionRepository = transactionRepository;
        this.connectionStatus = ConnectionStatus.NOT_CONNECTED;
        this.paymentStatus = PaymentStatus.NOT_READY;
    }

    @Nullable
    public final Reader getConnectedReader() {
        return this.connectedReader;
    }

    @Nullable
    public final ProxyReaderListener getReaderListener() {
        return this.readerListener;
    }

    public final void setReaderListener(@Nullable ProxyReaderListener proxyReaderListener) {
        this.readerListener = proxyReaderListener;
    }

    @Nullable
    public final ReaderReconnectionListener getReaderReconnectionListener() {
        return this.readerReconnectionListener;
    }

    public final void setReaderReconnectionListener(@Nullable ReaderReconnectionListener readerReconnectionListener) {
        this.readerReconnectionListener = readerReconnectionListener;
    }

    @NotNull
    public final ConnectionStatus getConnectionStatus() {
        return this.connectionStatus;
    }

    @NotNull
    public final PaymentStatus getPaymentStatus() {
        return this.paymentStatus;
    }

    public final void connected(@NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        LOGGER.i("connected.", new Pair[0]);
        this.connectedReader = reader;
        this.updateConnectionStatus(ConnectionStatus.CONNECTED);
    }

    public final void connecting(@NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        LOGGER.i("connecting.", new Pair[0]);
        this.connectedReader = reader;
        this.updateConnectionStatus(ConnectionStatus.CONNECTING);
    }

    public final void endPaymentFlow() {
        LOGGER.i("endPaymentFlow.", new Pair[0]);
        if (this.connectionStatus == ConnectionStatus.CONNECTED) {
            this.updatePaymentStatus(PaymentStatus.READY);
        } else {
            this.updatePaymentStatus(PaymentStatus.NOT_READY);
        }
    }

    public final void notConnected() {
        LOGGER.i("notConnected.", new Pair[0]);
        this.connectedReader = null;
        this.updateConnectionStatus(ConnectionStatus.NOT_CONNECTED);
        this.updatePaymentStatus(PaymentStatus.NOT_READY);
    }

    public final void processing() {
        LOGGER.i("processing.", new Pair[0]);
        this.updatePaymentStatus(PaymentStatus.PROCESSING);
    }

    public final void readyForPayment() {
        LOGGER.i("readyForPayment.", new Pair[0]);
        this.updatePaymentStatus(PaymentStatus.READY);
    }

    public final void requestReaderDisplayMessage(@NotNull ReaderDisplayMessage message) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            LOGGER.i("requestReaderDisplayMessage " + message + '.', new Pair[0]);
            Reader reader = this.connectedReader;
            if (reader == null) break block1;
            Reader it = reader;
            boolean bl = false;
            ProxyReaderListener proxyReaderListener = this.readerListener;
            if (proxyReaderListener != null) {
                proxyReaderListener.onRequestReaderDisplayMessage(message);
            }
        }
    }

    public final void requestReaderInput(@NotNull ReaderInputOptions options) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            LOGGER.i("requestReaderInput " + options + '.', new Pair[0]);
            Reader reader = this.connectedReader;
            if (reader == null) break block1;
            Reader it = reader;
            boolean bl = false;
            ProxyReaderListener proxyReaderListener = this.readerListener;
            if (proxyReaderListener != null) {
                proxyReaderListener.onRequestReaderInput(options);
            }
        }
    }

    public final void reportReaderSoftwareUpdateProgress(float progress) {
        block1: {
            LOGGER.i("reportReaderSoftwareUpdateProgress " + progress + '.', new Pair[0]);
            Reader reader = this.connectedReader;
            if (reader == null) break block1;
            Reader it = reader;
            boolean bl = false;
            ProxyReaderListener proxyReaderListener = this.readerListener;
            if (proxyReaderListener != null) {
                proxyReaderListener.onReportReaderSoftwareUpdateProgress(progress);
            }
        }
    }

    public final void finishInstallingUpdate(@Nullable ReaderSoftwareUpdate update2, @Nullable TerminalException e2) {
        block0: {
            LOGGER.i("finishInstallingUpdate.", new Pair[0]);
            ProxyReaderListener proxyReaderListener = this.readerListener;
            if (proxyReaderListener == null) break block0;
            proxyReaderListener.onFinishInstallingUpdate(update2, e2);
        }
    }

    public static /* synthetic */ void finishInstallingUpdate$default(TerminalStatusManager terminalStatusManager, ReaderSoftwareUpdate readerSoftwareUpdate, TerminalException terminalException, int n2, Object object) {
        if ((n2 & 2) != 0) {
            terminalException = null;
        }
        terminalStatusManager.finishInstallingUpdate(readerSoftwareUpdate, terminalException);
    }

    public final void startInstallingUpdate(@NotNull ReaderSoftwareUpdate update2, @NotNull Cancelable cancelable) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
            Intrinsics.checkNotNullParameter((Object)cancelable, (String)"cancelable");
            LOGGER.i("startInstallingUpdate.", new Pair[0]);
            Reader reader = this.connectedReader;
            if (reader == null) break block1;
            Reader it = reader;
            boolean bl = false;
            boolean onlyIncrementalUpdates = Intrinsics.areEqual((Object)update2.getComponents(), EnumSet.of((Enum)ReaderSoftwareUpdate.UpdateComponent.INCREMENTAL));
            ProxyReaderListener proxyReaderListener = this.readerListener;
            if (proxyReaderListener != null) {
                proxyReaderListener.onStartInstallingUpdate(update2, onlyIncrementalUpdates ? null : cancelable);
            }
        }
    }

    public final void reportLowBatteryWarning() {
        block1: {
            LOGGER.i("reportLowBatteryWarning.", new Pair[0]);
            Reader reader = this.connectedReader;
            if (reader == null) break block1;
            Reader it = reader;
            boolean bl = false;
            ProxyReaderListener proxyReaderListener = this.readerListener;
            if (proxyReaderListener != null) {
                proxyReaderListener.onReportLowBatteryWarning();
            }
        }
    }

    public final void reportReaderBatteryInfo(@Nullable ReaderBatteryInfo readerBatteryInfo2) {
        block1: {
            LOGGER.i("reportReaderBatteryInfo " + readerBatteryInfo2 + '.', new Pair[0]);
            Reader reader = this.connectedReader;
            if (reader == null) break block1;
            Reader it = reader;
            boolean bl = false;
            ProxyReaderListener proxyReaderListener = this.readerListener;
            if (proxyReaderListener != null) {
                proxyReaderListener.onReportReaderBatteryInfo(readerBatteryInfo2);
            }
        }
    }

    public final void reportReaderEvent(@NotNull ReaderEvent event) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            LOGGER.i("reportCardStatusChange " + event + '.', new Pair[0]);
            Reader reader = this.connectedReader;
            if (reader == null) break block1;
            Reader it = reader;
            boolean bl = false;
            ProxyReaderListener proxyReaderListener = this.readerListener;
            if (proxyReaderListener != null) {
                proxyReaderListener.onReportReaderEvent(event);
            }
        }
    }

    public final void reportUpdateAvailable(@NotNull ReaderSoftwareUpdate update2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
            LOGGER.i("reportUpdateAvailable.", new Pair[0]);
            Reader reader = this.connectedReader;
            if (reader == null) break block1;
            Reader it = reader;
            boolean bl = false;
            ProxyReaderListener proxyReaderListener = this.readerListener;
            if (proxyReaderListener != null) {
                proxyReaderListener.onReportAvailableUpdate(update2);
            }
        }
    }

    public final void unexpectedDisconnect() {
        LOGGER.i("unexpectedDisconnect.", new Pair[0]);
        Reader disconnectedReader = this.connectedReader;
        this.connectedReader = null;
        if (disconnectedReader != null) {
            this.updateConnectionStatus(ConnectionStatus.NOT_CONNECTED);
            this.updatePaymentStatus(PaymentStatus.NOT_READY);
            this.listener.onUnexpectedReaderDisconnect(disconnectedReader);
        }
    }

    public final void startReconnecting(@NotNull Reader reader, @NotNull Cancelable cancelReconnect) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)cancelReconnect, (String)"cancelReconnect");
            this.updateConnectionStatus(ConnectionStatus.CONNECTING);
            this.updatePaymentStatus(PaymentStatus.NOT_READY);
            ReaderReconnectionListener readerReconnectionListener = this.readerReconnectionListener;
            if (readerReconnectionListener == null) break block0;
            readerReconnectionListener.onReaderReconnectStarted(reader, cancelReconnect);
        }
    }

    public final void reconnected(@NotNull Reader reader) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            this.connectedReader = reader;
            this.updateConnectionStatus(ConnectionStatus.CONNECTED);
            this.updatePaymentStatus(PaymentStatus.READY);
            ReaderReconnectionListener readerReconnectionListener = this.readerReconnectionListener;
            if (readerReconnectionListener == null) break block0;
            readerReconnectionListener.onReaderReconnectSucceeded(reader);
        }
    }

    public final void reconnectFailed(@NotNull Reader reader) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Reader disconnectedReader = this.connectedReader;
            this.connectedReader = null;
            if (disconnectedReader == null) break block1;
            this.updateConnectionStatus(ConnectionStatus.NOT_CONNECTED);
            ReaderReconnectionListener readerReconnectionListener = this.readerReconnectionListener;
            if (readerReconnectionListener != null) {
                readerReconnectionListener.onReaderReconnectFailed(reader);
            }
        }
    }

    public final void waitForInput() {
        LOGGER.i("waitForInput.", new Pair[0]);
        this.updatePaymentStatus(PaymentStatus.WAITING_FOR_INPUT);
    }

    private final void updatePaymentStatus(PaymentStatus status) {
        if (status != this.paymentStatus) {
            this.paymentStatus = status;
            this.listener.onPaymentStatusChange(this.paymentStatus);
        }
    }

    private final void updateConnectionStatus(ConnectionStatus status) {
        if (status != this.connectionStatus) {
            this.connectionStatus = status;
            if (status == ConnectionStatus.NOT_CONNECTED) {
                this.transactionRepository.setDomesticDebitAids(CollectionsKt.emptyList());
            }
            this.listener.onConnectionStatusChange(this.connectionStatus);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/stripeterminal/internal/common/TerminalStatusManager$Companion;", "", "()V", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "common_publish"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

