/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.adapter;

import com.stripe.core.transaction.TransactionRepository;
import com.stripe.jvmcore.hardware.emv.InterfaceType;
import com.stripe.jvmcore.hardware.emv.SourceType;
import com.stripe.jvmcore.hardware.emv.TransactionResult;
import com.stripe.jvmcore.hardware.emv.TransactionType;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.terminal.makers.InteracEmvBlobMaker;
import com.stripe.jvmcore.time.Clock;
import com.stripe.jvmcore.transaction.CollectiblePayment;
import com.stripe.jvmcore.transaction.PaymentMethodCollectionType;
import com.stripe.jvmcore.transaction.payment.EmvPayment;
import com.stripe.proto.model.rest.PaymentMethodOptions;
import com.stripe.stripeterminal.external.callable.DiscoveryListener;
import com.stripe.stripeterminal.external.models.ConnectionConfiguration;
import com.stripe.stripeterminal.external.models.DeviceType;
import com.stripe.stripeterminal.external.models.DiscoveryConfiguration;
import com.stripe.stripeterminal.external.models.DiscoveryMethod;
import com.stripe.stripeterminal.external.models.Reader;
import com.stripe.stripeterminal.external.models.RoutingPriority;
import com.stripe.stripeterminal.external.models.SimulatedCard;
import com.stripe.stripeterminal.external.models.SimulatedCardType;
import com.stripe.stripeterminal.external.models.SimulatorConfiguration;
import com.stripe.stripeterminal.external.models.TerminalException;
import com.stripe.stripeterminal.internal.common.TerminalStatusManager;
import com.stripe.stripeterminal.internal.common.adapter.BaseSimulatedAdapterKt;
import com.stripe.stripeterminal.internal.common.adapter.MposAdapter;
import com.stripe.stripeterminal.internal.common.adapter.SimulatorConfigurationRepository;
import com.stripe.stripeterminal.internal.common.api.ApiClient;
import com.stripe.stripeterminal.internal.common.proto.ProtoConverter;
import com.stripe.stripeterminal.internal.models.PaymentMethodData;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\b&\u0018\u0000 C2\u00020\u0001:\u0002BCB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u0011\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010\u0012\u001a\u00020\u001eH\u0016J\b\u0010!\u001a\u00020\u001eH\u0002J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\"\u001a\u00020\u001eH\u0016J\u0018\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H&J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020\u001eH\u0016J(\u00102\u001a\u00020)2\u0006\u00103\u001a\u00020)2\u0006\u00104\u001a\u0002052\u000e\u00106\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u000107H\u0014J\b\u00108\u001a\u00020\u001eH\u0016J\u001c\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020 2\n\b\u0002\u0010<\u001a\u0004\u0018\u00010=H\u0014J\b\u0010>\u001a\u00020:H\u0016J\u0010\u0010?\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020AH\u0004R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/BaseSimulatedAdapter;", "Lcom/stripe/stripeterminal/internal/common/adapter/MposAdapter;", "clock", "Lcom/stripe/jvmcore/time/Clock;", "transactionRepository", "Lcom/stripe/core/transaction/TransactionRepository;", "simulatorConfigurationRepository", "Lcom/stripe/stripeterminal/internal/common/adapter/SimulatorConfigurationRepository;", "statusManager", "Lcom/stripe/stripeterminal/internal/common/TerminalStatusManager;", "apiClient", "Lcom/stripe/stripeterminal/internal/common/api/ApiClient;", "logger", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "(Lcom/stripe/jvmcore/time/Clock;Lcom/stripe/core/transaction/TransactionRepository;Lcom/stripe/stripeterminal/internal/common/adapter/SimulatorConfigurationRepository;Lcom/stripe/stripeterminal/internal/common/TerminalStatusManager;Lcom/stripe/stripeterminal/internal/common/api/ApiClient;Lcom/stripe/jvmcore/logging/terminal/log/Log;)V", "cancelCollectPayment", "Lcom/stripe/stripeterminal/internal/common/adapter/BaseSimulatedAdapter$CancellationState;", "cancelDiscoverReaders", "cancelInstallUpdate", "getCancelInstallUpdate", "()Lcom/stripe/stripeterminal/internal/common/adapter/BaseSimulatedAdapter$CancellationState;", "setCancelInstallUpdate", "(Lcom/stripe/stripeterminal/internal/common/adapter/BaseSimulatedAdapter$CancellationState;)V", "collectiblePayment", "Lcom/stripe/jvmcore/transaction/CollectiblePayment;", "getSimulatorConfigurationRepository", "()Lcom/stripe/stripeterminal/internal/common/adapter/SimulatorConfigurationRepository;", "getStatusManager", "()Lcom/stripe/stripeterminal/internal/common/TerminalStatusManager;", "cancelCollectPaymentMethod", "", "cancelSilently", "", "clearCancellationStates", "disconnectReader", "discoverReaders", "config", "Lcom/stripe/stripeterminal/external/models/DiscoveryConfiguration;", "listener", "Lcom/stripe/stripeterminal/external/callable/DiscoveryListener;", "getSimulatedReader", "Lcom/stripe/stripeterminal/external/models/Reader;", "deviceType", "Lcom/stripe/stripeterminal/external/models/DeviceType;", "handleAuthResponse", "Lkotlinx/coroutines/Deferred;", "Lcom/stripe/jvmcore/hardware/emv/TransactionResult;", "tlvBlob", "", "onConnect", "onConnectReader", "reader", "connectionConfiguration", "Lcom/stripe/stripeterminal/external/models/ConnectionConfiguration;", "requestReconnection", "Lkotlin/Function0;", "onDisconnect", "readCard", "Lcom/stripe/stripeterminal/internal/models/PaymentMethodData;", "reusable", "collectionType", "Lcom/stripe/jvmcore/transaction/PaymentMethodCollectionType;", "readReusableCard", "sleep", "millis", "", "CancellationState", "Companion", "adapter_release"})
public abstract class BaseSimulatedAdapter
extends MposAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Clock clock;
    @NotNull
    private final TransactionRepository transactionRepository;
    @NotNull
    private final SimulatorConfigurationRepository simulatorConfigurationRepository;
    @NotNull
    private final TerminalStatusManager statusManager;
    @NotNull
    private CancellationState cancelDiscoverReaders;
    @NotNull
    private CancellationState cancelCollectPayment;
    @Nullable
    private CollectiblePayment collectiblePayment;
    @NotNull
    private CancellationState cancelInstallUpdate;
    protected static final int SLEEP_QUANTUM_MS = 2000;
    @NotNull
    public static final String SERIAL_NUMBER_SUFFIX = "SIMULATOR";

    public BaseSimulatedAdapter(@NotNull Clock clock, @NotNull TransactionRepository transactionRepository, @NotNull SimulatorConfigurationRepository simulatorConfigurationRepository, @NotNull TerminalStatusManager statusManager, @NotNull ApiClient apiClient, @NotNull Log logger2) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)transactionRepository, (String)"transactionRepository");
        Intrinsics.checkNotNullParameter((Object)simulatorConfigurationRepository, (String)"simulatorConfigurationRepository");
        Intrinsics.checkNotNullParameter((Object)statusManager, (String)"statusManager");
        Intrinsics.checkNotNullParameter((Object)apiClient, (String)"apiClient");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        super(apiClient, logger2);
        this.clock = clock;
        this.transactionRepository = transactionRepository;
        this.simulatorConfigurationRepository = simulatorConfigurationRepository;
        this.statusManager = statusManager;
        this.cancelDiscoverReaders = CancellationState.NOT_CANCELED;
        this.cancelCollectPayment = CancellationState.NOT_CANCELED;
        this.cancelInstallUpdate = CancellationState.NOT_CANCELED;
    }

    @NotNull
    protected final SimulatorConfigurationRepository getSimulatorConfigurationRepository() {
        return this.simulatorConfigurationRepository;
    }

    @NotNull
    protected final TerminalStatusManager getStatusManager() {
        return this.statusManager;
    }

    @NotNull
    protected final CancellationState getCancelInstallUpdate() {
        return this.cancelInstallUpdate;
    }

    protected final void setCancelInstallUpdate(@NotNull CancellationState cancellationState) {
        Intrinsics.checkNotNullParameter((Object)((Object)cancellationState), (String)"<set-?>");
        this.cancelInstallUpdate = cancellationState;
    }

    @NotNull
    public abstract Reader getSimulatedReader(@NotNull DeviceType var1);

    public void onConnect() {
    }

    public void onDisconnect() {
    }

    @Override
    @Nullable
    public CollectiblePayment collectiblePayment() {
        return this.collectiblePayment;
    }

    @Override
    public void cancelCollectPaymentMethod() {
        this.cancelCollectPayment = CancellationState.CANCELED_WITH_ERROR;
    }

    @Override
    public void cancelDiscoverReaders(boolean cancelSilently) {
        this.cancelDiscoverReaders = cancelSilently ? CancellationState.CANCELED_SILENTLY : CancellationState.CANCELED_WITH_ERROR;
    }

    @Override
    public void cancelInstallUpdate() {
        this.cancelInstallUpdate = CancellationState.CANCELED_WITH_ERROR;
    }

    @Override
    @NotNull
    protected Reader onConnectReader(@NotNull Reader reader, @NotNull ConnectionConfiguration connectionConfiguration, @Nullable Function0<Unit> requestReconnection) throws TerminalException {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)connectionConfiguration, (String)"connectionConfiguration");
        this.sleep(2000L);
        Reader connectedReader2 = this.getSimulatedReader(reader.getDeviceType());
        this.onConnect();
        return connectedReader2;
    }

    @Override
    public void disconnectReader() throws TerminalException {
        this.onDisconnect();
    }

    @Override
    public void discoverReaders(@NotNull DiscoveryConfiguration config, @NotNull DiscoveryListener listener2) throws TerminalException {
        List list;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.clearCancellationStates();
        if (WhenMappings.$EnumSwitchMapping$0[config.getDiscoveryMethod().ordinal()] == 1) {
            objectArray = new Reader[]{this.getSimulatedReader(DeviceType.VERIFONE_P400), this.getSimulatedReader(DeviceType.WISEPOS_E)};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            objectArray = new Reader[]{this.getSimulatedReader(DeviceType.CHIPPER_2X), this.getSimulatedReader(DeviceType.STRIPE_M2), this.getSimulatedReader(DeviceType.WISEPAD_3)};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        List list2 = list;
        long timeoutStartTime = this.clock.currentTimeMillis();
        long currentTime = this.clock.currentTimeMillis();
        while (this.cancelDiscoverReaders == CancellationState.NOT_CANCELED) {
            if (this.clock.currentTimeMillis() - currentTime >= 2000L) {
                listener2.onUpdateDiscoveredReaders(list2);
                currentTime = this.clock.currentTimeMillis();
            }
            if (config.getTimeout() == 0 || this.clock.currentTimeMillis() - timeoutStartTime < (long)(config.getTimeout() * 1000)) continue;
            throw new TerminalException(TerminalException.TerminalErrorCode.BLUETOOTH_SCAN_TIMED_OUT, "Bluetooth scan timed out.", null, null, 12, null);
        }
        if (this.cancelDiscoverReaders == CancellationState.CANCELED_WITH_ERROR) {
            throw new TerminalException(TerminalException.TerminalErrorCode.CANCELED, "DiscoverReaders was canceled by the user.", null, null, 12, null);
        }
    }

    @Override
    @NotNull
    public Deferred<TransactionResult> handleAuthResponse(@NotNull String tlvBlob) {
        CompletableDeferred completableDeferred;
        Intrinsics.checkNotNullParameter((Object)tlvBlob, (String)"tlvBlob");
        CompletableDeferred $this$handleAuthResponse_u24lambda_u240 = completableDeferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        boolean bl = false;
        $this$handleAuthResponse_u24lambda_u240.complete((Object)new TransactionResult(TransactionResult.Result.APPROVED, tlvBlob));
        return (Deferred)completableDeferred;
    }

    @Override
    @NotNull
    public PaymentMethodData readReusableCard() throws TerminalException {
        return BaseSimulatedAdapter.readCard$default(this, true, null, 2, null);
    }

    @NotNull
    protected PaymentMethodData readCard(boolean reusable, @Nullable PaymentMethodCollectionType collectionType) throws TerminalException {
        List<PaymentMethodOptions.RoutingPriority> list;
        this.clearCancellationStates();
        this.sleep(2000L);
        if (this.cancelCollectPayment != CancellationState.NOT_CANCELED) {
            throw new TerminalException(TerminalException.TerminalErrorCode.CANCELED, "The operation was canceled by the user.", null, null, 12, null);
        }
        this.sleep(2000L);
        if (this.cancelCollectPayment != CancellationState.NOT_CANCELED) {
            throw new TerminalException(TerminalException.TerminalErrorCode.CANCELED, "The operation was canceled by the user.", null, null, 12, null);
        }
        SimulatorConfiguration simulatorConfig = this.simulatorConfigurationRepository.getSimulatorConfiguration();
        PaymentMethodCollectionType.Sale sale = collectionType instanceof PaymentMethodCollectionType.Sale ? (PaymentMethodCollectionType.Sale)collectionType : null;
        List<RoutingPriority> list2 = sale != null && (list = sale.getComputedPriorities()) != null ? ProtoConverter.INSTANCE.toSdkPriorities(list) : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List<RoutingPriority> computedPriority = list2;
        this.transactionRepository.setAmountTip(BaseSimulatedAdapterKt.getAmountTip(this.transactionRepository.getAmountTip(), collectionType, simulatorConfig, this.statusManager.getConnectedReader()));
        String generatedEmvBlob = null;
        TransactionType transactionType = null;
        boolean isScaRecollection = collectionType instanceof PaymentMethodCollectionType.StrongCustomerAuthentication;
        SimulatedCard simulatedCard = simulatorConfig.getSimulatedCard();
        if (collectionType instanceof PaymentMethodCollectionType.Refund) {
            generatedEmvBlob = InteracEmvBlobMaker.Companion.create(((PaymentMethodCollectionType.Refund)collectionType).getAmount().getValue(), new SimulatedCard(SimulatedCardType.INTERAC).getEmvBlob().getBlob());
            transactionType = TransactionType.TRADITIONAL;
        } else {
            generatedEmvBlob = simulatedCard.emvForSimulatedCard(computedPriority, isScaRecollection).getBlob();
            transactionType = TransactionType.QUICK;
        }
        PaymentMethodData paymentMethod = new PaymentMethodData(generatedEmvBlob, null, null, null, null, null, null, 126, null);
        boolean isScaTestCase = Intrinsics.areEqual((Object)simulatedCard, (Object)new SimulatedCard(SimulatedCardType.OFFLINE_PIN_SCA_RETRY)) || Intrinsics.areEqual((Object)simulatedCard, (Object)new SimulatedCard(SimulatedCardType.ONLINE_PIN_SCA_RETRY));
        InterfaceType interfaceType = isScaTestCase && isScaRecollection || paymentMethod.isInterac() ? InterfaceType.CONTACT : InterfaceType.CONTACTLESS;
        SourceType sourceType = paymentMethod.isInterac() ? SourceType.INTERAC_PRESENT : SourceType.CARD_PRESENT;
        EmvPayment emvPayment = new EmvPayment(generatedEmvBlob, interfaceType, transactionType, sourceType, false);
        this.collectiblePayment = new CollectiblePayment(emvPayment, interfaceType, isScaTestCase);
        return paymentMethod;
    }

    public static /* synthetic */ PaymentMethodData readCard$default(BaseSimulatedAdapter baseSimulatedAdapter, boolean bl, PaymentMethodCollectionType paymentMethodCollectionType, int n2, Object object) throws TerminalException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readCard");
        }
        if ((n2 & 2) != 0) {
            paymentMethodCollectionType = null;
        }
        return baseSimulatedAdapter.readCard(bl, paymentMethodCollectionType);
    }

    protected final void sleep(long millis) throws TerminalException {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e2) {
            throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Sleep failed", (Throwable)e2, null, 8, null);
        }
    }

    private final void clearCancellationStates() {
        this.cancelCollectPayment = CancellationState.NOT_CANCELED;
        this.cancelDiscoverReaders = CancellationState.NOT_CANCELED;
        this.cancelInstallUpdate = CancellationState.NOT_CANCELED;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0084\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/BaseSimulatedAdapter$CancellationState;", "", "(Ljava/lang/String;I)V", "NOT_CANCELED", "CANCELED_SILENTLY", "CANCELED_WITH_ERROR", "adapter_release"})
    protected static final class CancellationState
    extends Enum<CancellationState> {
        public static final /* enum */ CancellationState NOT_CANCELED = new CancellationState();
        public static final /* enum */ CancellationState CANCELED_SILENTLY = new CancellationState();
        public static final /* enum */ CancellationState CANCELED_WITH_ERROR = new CancellationState();
        private static final /* synthetic */ CancellationState[] $VALUES;

        public static CancellationState[] values() {
            return (CancellationState[])$VALUES.clone();
        }

        public static CancellationState valueOf(String value) {
            return Enum.valueOf(CancellationState.class, value);
        }

        static {
            $VALUES = cancellationStateArray = new CancellationState[]{CancellationState.NOT_CANCELED, CancellationState.CANCELED_SILENTLY, CancellationState.CANCELED_WITH_ERROR};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0084T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/BaseSimulatedAdapter$Companion;", "", "()V", "SERIAL_NUMBER_SUFFIX", "", "SLEEP_QUANTUM_MS", "", "adapter_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DiscoveryMethod.values().length];
            try {
                nArray[DiscoveryMethod.INTERNET.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

