/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.adapter;

import androidx.annotation.VisibleForTesting;
import com.stripe.jvmcore.currency.Amount;
import com.stripe.jvmcore.transaction.PaymentMethodCollectionType;
import com.stripe.stripeterminal.external.models.DeviceType;
import com.stripe.stripeterminal.external.models.Reader;
import com.stripe.stripeterminal.external.models.SimulatorConfiguration;
import com.stripe.stripeterminal.internal.common.extensions.DeviceTypeExtensions;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a0\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007\u00a8\u0006\t"}, d2={"getAmountTip", "Lcom/stripe/jvmcore/currency/Amount;", "existingAmountTip", "collectionType", "Lcom/stripe/jvmcore/transaction/PaymentMethodCollectionType;", "simulatorConfig", "Lcom/stripe/stripeterminal/external/models/SimulatorConfiguration;", "connectedReader", "Lcom/stripe/stripeterminal/external/models/Reader;", "adapter_release"})
public final class BaseSimulatedAdapterKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    @Nullable
    public static final Amount getAmountTip(@Nullable Amount existingAmountTip, @Nullable PaymentMethodCollectionType collectionType, @NotNull SimulatorConfiguration simulatorConfig, @Nullable Reader connectedReader2) {
        Amount amount;
        Intrinsics.checkNotNullParameter((Object)simulatorConfig, (String)"simulatorConfig");
        PaymentMethodCollectionType paymentMethodCollectionType = collectionType;
        if (paymentMethodCollectionType instanceof PaymentMethodCollectionType.Sale) {
            Long l2 = simulatorConfig.getSimulatedTipAmount();
            if (l2 == null) return null;
            long it = ((Number)l2).longValue();
            boolean bl = false;
            if (((PaymentMethodCollectionType.Sale)collectionType).getSkipTipping()) return null;
            Reader reader = connectedReader2;
            Reader reader2 = reader;
            if (reader == null) return null;
            DeviceType deviceType = reader2.getDeviceType();
            reader2 = deviceType;
            if (deviceType == null) return null;
            if (!DeviceTypeExtensions.INSTANCE.supportsOnReaderTipping((DeviceType)reader2)) return null;
            boolean bl2 = true;
            if (!bl2) return null;
            amount = new Amount(it, ((PaymentMethodCollectionType.Sale)collectionType).getAmount().getCurrencyCode());
            return amount;
        } else if (paymentMethodCollectionType instanceof PaymentMethodCollectionType.StrongCustomerAuthentication) {
            amount = existingAmountTip;
            return amount;
        } else {
            if (paymentMethodCollectionType instanceof PaymentMethodCollectionType.Refund) {
                return null;
            }
            if (paymentMethodCollectionType instanceof PaymentMethodCollectionType.SetupIntent) {
                return null;
            }
            if (paymentMethodCollectionType != null) throw new NoWhenBranchMatchedException();
            return null;
        }
    }
}

