/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.adapter;

import com.stripe.core.bbpos.hardware.BbposPaymentCollectionListener;
import com.stripe.core.bbpos.hardware.DeviceListenerRegistry;
import com.stripe.core.hardware.Optional;
import com.stripe.core.hardware.Reader;
import com.stripe.core.hardware.ReaderInfoController;
import com.stripe.core.hardware.paymentcollection.ContactCardSlotState;
import com.stripe.core.hardware.reactive.emv.MerchantNameData;
import com.stripe.core.hardware.reactive.emv.ReactiveConfigurationListener;
import com.stripe.core.hardware.reactive.status.ReactiveReaderStatusListener;
import com.stripe.core.hardware.reactive.updates.ReactiveReaderUpdateListener;
import com.stripe.core.hardware.updates.ReaderUpdateController;
import com.stripe.core.hardware.updates.ReaderUpdateException;
import com.stripe.core.hardware.updates.ReaderVersion;
import com.stripe.core.readerconnection.ConnectionManager;
import com.stripe.core.readerupdate.UpdateClient;
import com.stripe.core.readerupdate.UpdateInstaller;
import com.stripe.core.readerupdate.UpdateManager;
import com.stripe.core.transaction.Settings;
import com.stripe.core.transaction.SettingsRepository;
import com.stripe.core.transaction.TransactionRepository;
import com.stripe.jvmcore.currency.Amount;
import com.stripe.jvmcore.featureflag.FeatureFlagsRepository;
import com.stripe.jvmcore.hardware.ReaderConfiguration;
import com.stripe.jvmcore.hardware.emv.DomesticDebitAidsParser;
import com.stripe.jvmcore.hardware.emv.ReaderSettings;
import com.stripe.jvmcore.hardware.emv.TransactionResult;
import com.stripe.jvmcore.hardware.emv.TransactionType;
import com.stripe.jvmcore.hardware.status.DisconnectCause;
import com.stripe.jvmcore.hardware.status.ReaderException;
import com.stripe.jvmcore.hardware.status.ReaderInfo;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.paymentcollection.OnlineAuthState;
import com.stripe.jvmcore.terminal.tokenrepositories.SessionTokenRepository;
import com.stripe.jvmcore.transaction.ChargeAttempt;
import com.stripe.jvmcore.transaction.CollectiblePayment;
import com.stripe.jvmcore.transaction.PaymentMethodCollectionType;
import com.stripe.proto.model.common.ClientVersionSpecPb;
import com.stripe.proto.model.config.MobileClientConfig;
import com.stripe.proto.terminal.terminal.pub.message.config.TippingConfigPb;
import com.stripe.stripeterminal.external.callable.Cancelable;
import com.stripe.stripeterminal.external.callable.DiscoveryListener;
import com.stripe.stripeterminal.external.models.ConnectionConfiguration;
import com.stripe.stripeterminal.external.models.DeviceType;
import com.stripe.stripeterminal.external.models.DiscoveryConfiguration;
import com.stripe.stripeterminal.external.models.Location;
import com.stripe.stripeterminal.external.models.ReaderBatteryInfo;
import com.stripe.stripeterminal.external.models.ReaderInputOptions;
import com.stripe.stripeterminal.external.models.ReaderSoftwareUpdate;
import com.stripe.stripeterminal.external.models.TerminalException;
import com.stripe.stripeterminal.internal.common.Adapter;
import com.stripe.stripeterminal.internal.common.TerminalStatusManager;
import com.stripe.stripeterminal.internal.common.adapter.BbposAdapter;
import com.stripe.stripeterminal.internal.common.adapter.BbposAdapterPaymentCollectionListener;
import com.stripe.stripeterminal.internal.common.adapter.BbposUsbAdapter;
import com.stripe.stripeterminal.internal.common.adapter.BuildConfig;
import com.stripe.stripeterminal.internal.common.adapter.PaymentCollectionCoordinatorWrapper;
import com.stripe.stripeterminal.internal.common.adapter.ProxiedAdapter;
import com.stripe.stripeterminal.internal.common.connectandupdate.ConnectAndUpdateStateMachine;
import com.stripe.stripeterminal.internal.common.extensions.DeviceTypeExtensions;
import com.stripe.stripeterminal.internal.common.makers.ReaderSoftwareUpdateMaker;
import com.stripe.stripeterminal.internal.common.makers.TerminalExceptionMaker;
import com.stripe.stripeterminal.internal.common.resourcerepository.ResourceRepository;
import com.stripe.stripeterminal.internal.models.PaymentMethodData;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.ExceptionsKt;
import kotlinx.coroutines.ExperimentalCoroutinesApi;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.ChannelsKt;
import kotlinx.coroutines.channels.ProduceKt;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009a\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b'\u0018\u0000 \u00a5\u00012\u00020\u0001:\u0014\u00a4\u0001\u00a5\u0001\u00a6\u0001\u00a7\u0001\u00a8\u0001\u00a9\u0001\u00aa\u0001\u00ab\u0001\u00ac\u0001\u00ad\u0001B\u00bd\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u0012\u0006\u0010 \u001a\u00020!\u0012\u0006\u0010\"\u001a\u00020#\u0012\u0006\u0010$\u001a\u00020%\u0012\u0006\u0010&\u001a\u00020'\u0012\u0006\u0010(\u001a\u00020)\u0012\u0006\u0010*\u001a\u00020+\u0012\u0006\u0010,\u001a\u00020-\u0012\u0006\u0010.\u001a\u00020/\u00a2\u0006\u0002\u00100J\b\u0010K\u001a\u00020>H\u0016J\u0010\u0010L\u001a\u00020>2\u0006\u0010M\u001a\u00020NH\u0016J\b\u0010O\u001a\u00020>H\u0016J\b\u0010P\u001a\u00020>H\u0016J\u0012\u0010Q\u001a\u0004\u0018\u00010R2\u0006\u0010S\u001a\u00020NH\u0016J\u0010\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020WH\u0016J\b\u00103\u001a\u000202H\u0016J\b\u0010X\u001a\u00020>H\u0016J\u0018\u0010Y\u001a\u00020>2\u0006\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020]H\u0016J\b\u0010^\u001a\u00020>H\u0016J\u0010\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020bH\u0004J\"\u0010c\u001a\u000e\u0012\u0004\u0012\u00020e\u0012\u0004\u0012\u00020f0d2\f\u0010g\u001a\b\u0012\u0004\u0012\u00020e0hH\u0014J\u0016\u0010i\u001a\b\u0012\u0004\u0012\u00020k0j2\u0006\u0010l\u001a\u00020eH\u0016J\b\u0010m\u001a\u00020>H\u0016J\u0010\u0010n\u001a\u00020>2\u0006\u0010o\u001a\u00020RH\u0016J\u0014\u0010p\u001a\u00060qR\u00020\u00002\u0006\u0010r\u001a\u00020sH$J\u001c\u0010t\u001a\u00060uR\u00020\u00002\u0006\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020]H$J\u0012\u0010v\u001a\u0004\u0018\u00010w2\u0006\u0010r\u001a\u00020sH$J\u0014\u0010x\u001a\u00060yR\u00020\u00002\u0006\u0010r\u001a\u00020sH$J\u0012\u0010z\u001a\u00020>2\b\u0010{\u001a\u0004\u0018\u00010|H\u0016J(\u0010}\u001a\u00020s2\u0006\u0010r\u001a\u00020s2\u0006\u0010~\u001a\u00020\u007f2\u000e\u0010@\u001a\n\u0012\u0004\u0012\u00020>\u0018\u00010=H\u0014J\u0013\u0010\u0080\u0001\u001a\u00020>2\b\u0010\u0081\u0001\u001a\u00030\u0082\u0001H\u0014J\u0013\u0010\u0083\u0001\u001a\u00020>2\b\u0010\u0084\u0001\u001a\u00030\u0085\u0001H\u0014J\u0013\u0010\u0086\u0001\u001a\u00020>2\b\u0010\u0087\u0001\u001a\u00030\u0088\u0001H\u0016J\u0013\u0010\u0089\u0001\u001a\u00020>2\b\u0010\u008a\u0001\u001a\u00030\u008b\u0001H\u0004J\t\u0010\u008c\u0001\u001a\u00020UH\u0016J\u001b\u0010\u008d\u0001\u001a\u00020s2\u0006\u0010r\u001a\u00020s2\b\u0010\u008e\u0001\u001a\u00030\u008f\u0001H\u0016J\u0011\u0010\u0090\u0001\u001a\u00020>2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0090\u0001\u001a\u00020>2\u0007\u0010\u0091\u0001\u001a\u00020\u0011H\u0002J\u0011\u0010\u0090\u0001\u001a\u00020>2\u0006\u0010\\\u001a\u00020\u0013H\u0002J\u0011\u0010\u0090\u0001\u001a\u00020>2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\t\u0010\u0092\u0001\u001a\u00020>H\u0004J\t\u0010\u0093\u0001\u001a\u00020>H\u0004J\u001b\u0010\u0094\u0001\u001a\u0005\u0018\u00010\u0095\u00012\r\u0010\u0096\u0001\u001a\b\u0012\u0004\u0012\u00020>0=H\u0016J\u0012\u0010\u0097\u0001\u001a\u00020>2\u0007\u0010Z\u001a\u00030\u0098\u0001H$J*\u0010\u0099\u0001\u001a\u00020N2\n\u0010\u009a\u0001\u001a\u0005\u0018\u00010\u009b\u00012\b\u0010\u009c\u0001\u001a\u00030\u009d\u00012\t\b\u0002\u0010\u009e\u0001\u001a\u00020NH\u0002J\u0011\u0010\u009f\u0001\u001a\u00020>2\u0006\u0010r\u001a\u00020sH\u0016J\u0014\u0010\u00a0\u0001\u001a\u00030\u00a1\u00012\b\u0010\u00a2\u0001\u001a\u00030\u00a3\u0001H\u0002J\b\u0010o\u001a\u00020>H\u0004R(\u00103\u001a\u0004\u0018\u0001022\b\u00101\u001a\u0004\u0018\u0001028B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u000e\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010:\u001a\u0004\u0018\u00010;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010?\u001a\u0004\u0018\u00010;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010@\u001a\n\u0012\u0004\u0012\u00020>\u0018\u00010=X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010F\u001a\u00020E2\u0006\u00101\u001a\u00020E8D@DX\u0084\u000e\u00a2\u0006\f\u001a\u0004\bG\u0010H\"\u0004\bI\u0010JR\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00ae\u0001"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter;", "Lcom/stripe/stripeterminal/internal/common/adapter/ProxiedAdapter;", "updateClient", "Lcom/stripe/core/readerupdate/UpdateClient;", "sessionTokenRepository", "Lcom/stripe/jvmcore/terminal/tokenrepositories/SessionTokenRepository;", "scheduler", "Lio/reactivex/rxjava3/core/Scheduler;", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "connectionManager", "Lcom/stripe/core/readerconnection/ConnectionManager;", "updateManager", "Lcom/stripe/core/readerupdate/UpdateManager;", "configListener", "Lcom/stripe/core/hardware/reactive/emv/ReactiveConfigurationListener;", "readerStatusListener", "Lcom/stripe/core/hardware/reactive/status/ReactiveReaderStatusListener;", "updateListener", "Lcom/stripe/core/hardware/reactive/updates/ReactiveReaderUpdateListener;", "updateInstaller", "Lcom/stripe/core/readerupdate/UpdateInstaller;", "statusManager", "Lcom/stripe/stripeterminal/internal/common/TerminalStatusManager;", "settingsRepository", "Lcom/stripe/core/transaction/SettingsRepository;", "featureFlagsRepository", "Lcom/stripe/jvmcore/featureflag/FeatureFlagsRepository;", "readerUpdateController", "Lcom/stripe/core/hardware/updates/ReaderUpdateController;", "paymentCollectionWrapper", "Lcom/stripe/stripeterminal/internal/common/adapter/PaymentCollectionCoordinatorWrapper;", "transactionRepository", "Lcom/stripe/core/transaction/TransactionRepository;", "connectAndUpdateStateMachine", "Lcom/stripe/stripeterminal/internal/common/connectandupdate/ConnectAndUpdateStateMachine;", "readerInfoController", "Lcom/stripe/core/hardware/ReaderInfoController;", "resourceRepository", "Lcom/stripe/stripeterminal/internal/common/resourcerepository/ResourceRepository;", "deviceListener", "Lcom/stripe/core/bbpos/hardware/BbposPaymentCollectionListener;", "deviceListenerRegistry", "Lcom/stripe/core/bbpos/hardware/DeviceListenerRegistry;", "domesticDebitAidsParser", "Lcom/stripe/jvmcore/hardware/emv/DomesticDebitAidsParser;", "logger", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "(Lcom/stripe/core/readerupdate/UpdateClient;Lcom/stripe/jvmcore/terminal/tokenrepositories/SessionTokenRepository;Lio/reactivex/rxjava3/core/Scheduler;Lkotlinx/coroutines/CoroutineDispatcher;Lcom/stripe/core/readerconnection/ConnectionManager;Lcom/stripe/core/readerupdate/UpdateManager;Lcom/stripe/core/hardware/reactive/emv/ReactiveConfigurationListener;Lcom/stripe/core/hardware/reactive/status/ReactiveReaderStatusListener;Lcom/stripe/core/hardware/reactive/updates/ReactiveReaderUpdateListener;Lcom/stripe/core/readerupdate/UpdateInstaller;Lcom/stripe/stripeterminal/internal/common/TerminalStatusManager;Lcom/stripe/core/transaction/SettingsRepository;Lcom/stripe/jvmcore/featureflag/FeatureFlagsRepository;Lcom/stripe/core/hardware/updates/ReaderUpdateController;Lcom/stripe/stripeterminal/internal/common/adapter/PaymentCollectionCoordinatorWrapper;Lcom/stripe/core/transaction/TransactionRepository;Lcom/stripe/stripeterminal/internal/common/connectandupdate/ConnectAndUpdateStateMachine;Lcom/stripe/core/hardware/ReaderInfoController;Lcom/stripe/stripeterminal/internal/common/resourcerepository/ResourceRepository;Lcom/stripe/core/bbpos/hardware/BbposPaymentCollectionListener;Lcom/stripe/core/bbpos/hardware/DeviceListenerRegistry;Lcom/stripe/jvmcore/hardware/emv/DomesticDebitAidsParser;Lcom/stripe/jvmcore/logging/terminal/log/Log;)V", "value", "Lcom/stripe/jvmcore/transaction/CollectiblePayment;", "collectiblePayment", "getCollectiblePayment", "()Lcom/stripe/jvmcore/transaction/CollectiblePayment;", "setCollectiblePayment", "(Lcom/stripe/jvmcore/transaction/CollectiblePayment;)V", "compositeDisposable", "Lio/reactivex/rxjava3/disposables/CompositeDisposable;", "deviceBusyDisposable", "Lio/reactivex/rxjava3/disposables/Disposable;", "endBatteryInfoPolling", "Lkotlin/Function0;", "", "readerDisconnectSubscription", "requestReconnection", "getRequestReconnection", "()Lkotlin/jvm/functions/Function0;", "setRequestReconnection", "(Lkotlin/jvm/functions/Function0;)V", "Lcom/stripe/core/transaction/Settings;", "settings", "getSettings", "()Lcom/stripe/core/transaction/Settings;", "setSettings", "(Lcom/stripe/core/transaction/Settings;)V", "cancelCollectPaymentMethod", "cancelDiscoverReaders", "cancelSilently", "", "cancelInstallUpdate", "cancelReconnectReader", "checkForUpdate", "Lcom/stripe/stripeterminal/external/models/ReaderSoftwareUpdate;", "failSilently", "collectPaymentMethod", "Lcom/stripe/stripeterminal/internal/models/PaymentMethodData;", "paymentMethodCollectionType", "Lcom/stripe/jvmcore/transaction/PaymentMethodCollectionType;", "disconnectReader", "discoverReaders", "config", "Lcom/stripe/stripeterminal/external/models/DiscoveryConfiguration;", "listener", "Lcom/stripe/stripeterminal/external/callable/DiscoveryListener;", "dispose", "emvTransactionTypeForDeviceType", "Lcom/stripe/jvmcore/hardware/emv/TransactionType;", "deviceType", "Lcom/stripe/stripeterminal/external/models/DeviceType;", "getLocationsForDiscovery", "", "", "Lcom/stripe/stripeterminal/external/models/Location;", "deviceSerials", "", "handleAuthResponse", "Lkotlinx/coroutines/Deferred;", "Lcom/stripe/jvmcore/hardware/emv/TransactionResult;", "tlvBlob", "init", "installUpdate", "update", "makeConnectReaderOperation", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter$ConnectReaderOperation;", "reader", "Lcom/stripe/stripeterminal/external/models/Reader;", "makeDiscoverReadersOperation", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter$DiscoverReadersOperation;", "makeHardwareReader", "Lcom/stripe/core/hardware/Reader;", "makeReconnectReaderOperation", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter$ReconnectReaderOperation;", "onChargeAttemptChanged", "chargeAttempt", "Lcom/stripe/jvmcore/transaction/ChargeAttempt;", "onConnectReader", "connectionConfiguration", "Lcom/stripe/stripeterminal/external/models/ConnectionConfiguration;", "onDisconnect", "disconnectCause", "Lcom/stripe/jvmcore/hardware/status/DisconnectCause;", "onFailure", "e", "Lcom/stripe/stripeterminal/external/models/TerminalException;", "onOnlineAuthStateChanged", "state", "Lcom/stripe/jvmcore/paymentcollection/OnlineAuthState;", "onUnexpectedFailure", "t", "", "readReusableCard", "reconnectReader", "cancelReconnect", "Lcom/stripe/stripeterminal/external/callable/Cancelable;", "register", "readerListener", "registerReaderDisconnectHandler", "removeReaderDisconnectHandler", "requestReaderBatteryInfo", "Lcom/stripe/stripeterminal/external/models/ReaderBatteryInfo;", "endPolling", "saveReconnectParams", "Lcom/stripe/proto/model/config/MobileClientConfig;", "shouldStartTipping", "tippingConfig", "Lcom/stripe/proto/terminal/terminal/pub/message/config/TippingConfigPb;", "amount", "Lcom/stripe/jvmcore/currency/Amount;", "skipTipping", "startSession", "translateReaderType", "Lcom/stripe/stripeterminal/external/models/ReaderInputOptions$ReaderInputOption;", "readerType", "Lcom/stripe/jvmcore/hardware/ReaderConfiguration$ReaderType;", "CheckForUpdateOperation", "Companion", "ConnectReaderOperation", "DisconnectReaderOperation", "DiscoverReadersOperation", "InstallUpdateOperation", "ReconnectReaderOperation", "RequestReaderBatteryInfoOperation", "StartSessionOperation", "UpdateOperation", "adapter_release"})
@ExperimentalCoroutinesApi
@SourceDebugExtension(value={"SMAP\nBbposAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BbposAdapter.kt\ncom/stripe/stripeterminal/internal/common/adapter/BbposAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,884:1\n1#2:885\n*E\n"})
public abstract class BbposAdapter
extends ProxiedAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UpdateClient updateClient;
    @NotNull
    private final SessionTokenRepository sessionTokenRepository;
    @NotNull
    private final Scheduler scheduler;
    @NotNull
    private final CoroutineDispatcher dispatcher;
    @NotNull
    private final ConnectionManager connectionManager;
    @NotNull
    private final UpdateManager updateManager;
    @NotNull
    private final ReactiveConfigurationListener configListener;
    @NotNull
    private final ReactiveReaderStatusListener readerStatusListener;
    @NotNull
    private final ReactiveReaderUpdateListener updateListener;
    @NotNull
    private final UpdateInstaller updateInstaller;
    @NotNull
    private final TerminalStatusManager statusManager;
    @NotNull
    private final SettingsRepository settingsRepository;
    @NotNull
    private final FeatureFlagsRepository featureFlagsRepository;
    @NotNull
    private final ReaderUpdateController readerUpdateController;
    @NotNull
    private final PaymentCollectionCoordinatorWrapper paymentCollectionWrapper;
    @NotNull
    private final TransactionRepository transactionRepository;
    @NotNull
    private final ConnectAndUpdateStateMachine connectAndUpdateStateMachine;
    @NotNull
    private final ReaderInfoController readerInfoController;
    @NotNull
    private final ResourceRepository resourceRepository;
    @NotNull
    private final BbposPaymentCollectionListener deviceListener;
    @NotNull
    private final DeviceListenerRegistry deviceListenerRegistry;
    @NotNull
    private final DomesticDebitAidsParser domesticDebitAidsParser;
    @NotNull
    private final CompositeDisposable compositeDisposable;
    @Nullable
    private Disposable deviceBusyDisposable;
    @Nullable
    private Disposable readerDisconnectSubscription;
    @NotNull
    private Function0<Unit> endBatteryInfoPolling;
    @Nullable
    private Function0<Unit> requestReconnection;
    public static final long DEFAULT_RECONNECTION_TIMEOUT = 30000L;
    public static final int DEFAULT_RECONNECTION_MAX_ATTEMPTS = 4;
    public static final long DEFAULT_ATTEMPT_DELAY_MILLIS = 1000L;
    @NotNull
    public static final String RECONNECTION_OUTCOME_TAG_KEY = "reconnection_outcome";
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(BbposAdapter.class);

    public BbposAdapter(@NotNull UpdateClient updateClient, @NotNull SessionTokenRepository sessionTokenRepository, @NotNull Scheduler scheduler, @NotNull CoroutineDispatcher dispatcher, @NotNull ConnectionManager connectionManager, @NotNull UpdateManager updateManager, @NotNull ReactiveConfigurationListener configListener, @NotNull ReactiveReaderStatusListener readerStatusListener, @NotNull ReactiveReaderUpdateListener updateListener, @NotNull UpdateInstaller updateInstaller, @NotNull TerminalStatusManager statusManager, @NotNull SettingsRepository settingsRepository, @NotNull FeatureFlagsRepository featureFlagsRepository, @NotNull ReaderUpdateController readerUpdateController, @NotNull PaymentCollectionCoordinatorWrapper paymentCollectionWrapper, @NotNull TransactionRepository transactionRepository, @NotNull ConnectAndUpdateStateMachine connectAndUpdateStateMachine, @NotNull ReaderInfoController readerInfoController, @NotNull ResourceRepository resourceRepository, @NotNull BbposPaymentCollectionListener deviceListener, @NotNull DeviceListenerRegistry deviceListenerRegistry, @NotNull DomesticDebitAidsParser domesticDebitAidsParser, @NotNull Log logger2) {
        Intrinsics.checkNotNullParameter((Object)updateClient, (String)"updateClient");
        Intrinsics.checkNotNullParameter((Object)sessionTokenRepository, (String)"sessionTokenRepository");
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)connectionManager, (String)"connectionManager");
        Intrinsics.checkNotNullParameter((Object)updateManager, (String)"updateManager");
        Intrinsics.checkNotNullParameter((Object)configListener, (String)"configListener");
        Intrinsics.checkNotNullParameter((Object)readerStatusListener, (String)"readerStatusListener");
        Intrinsics.checkNotNullParameter((Object)updateListener, (String)"updateListener");
        Intrinsics.checkNotNullParameter((Object)updateInstaller, (String)"updateInstaller");
        Intrinsics.checkNotNullParameter((Object)statusManager, (String)"statusManager");
        Intrinsics.checkNotNullParameter((Object)settingsRepository, (String)"settingsRepository");
        Intrinsics.checkNotNullParameter((Object)featureFlagsRepository, (String)"featureFlagsRepository");
        Intrinsics.checkNotNullParameter((Object)readerUpdateController, (String)"readerUpdateController");
        Intrinsics.checkNotNullParameter((Object)paymentCollectionWrapper, (String)"paymentCollectionWrapper");
        Intrinsics.checkNotNullParameter((Object)transactionRepository, (String)"transactionRepository");
        Intrinsics.checkNotNullParameter((Object)connectAndUpdateStateMachine, (String)"connectAndUpdateStateMachine");
        Intrinsics.checkNotNullParameter((Object)readerInfoController, (String)"readerInfoController");
        Intrinsics.checkNotNullParameter((Object)resourceRepository, (String)"resourceRepository");
        Intrinsics.checkNotNullParameter((Object)deviceListener, (String)"deviceListener");
        Intrinsics.checkNotNullParameter((Object)deviceListenerRegistry, (String)"deviceListenerRegistry");
        Intrinsics.checkNotNullParameter((Object)domesticDebitAidsParser, (String)"domesticDebitAidsParser");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        super(logger2);
        this.updateClient = updateClient;
        this.sessionTokenRepository = sessionTokenRepository;
        this.scheduler = scheduler;
        this.dispatcher = dispatcher;
        this.connectionManager = connectionManager;
        this.updateManager = updateManager;
        this.configListener = configListener;
        this.readerStatusListener = readerStatusListener;
        this.updateListener = updateListener;
        this.updateInstaller = updateInstaller;
        this.statusManager = statusManager;
        this.settingsRepository = settingsRepository;
        this.featureFlagsRepository = featureFlagsRepository;
        this.readerUpdateController = readerUpdateController;
        this.paymentCollectionWrapper = paymentCollectionWrapper;
        this.transactionRepository = transactionRepository;
        this.connectAndUpdateStateMachine = connectAndUpdateStateMachine;
        this.readerInfoController = readerInfoController;
        this.resourceRepository = resourceRepository;
        this.deviceListener = deviceListener;
        this.deviceListenerRegistry = deviceListenerRegistry;
        this.domesticDebitAidsParser = domesticDebitAidsParser;
        this.compositeDisposable = new CompositeDisposable();
        this.endBatteryInfoPolling = endBatteryInfoPolling.1.INSTANCE;
    }

    @NotNull
    protected final Settings getSettings() {
        return this.settingsRepository.getSettings();
    }

    protected final void setSettings(@NotNull Settings value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.settingsRepository.setSettings(value);
    }

    @Nullable
    protected final Function0<Unit> getRequestReconnection() {
        return this.requestReconnection;
    }

    protected final void setRequestReconnection(@Nullable Function0<Unit> function0) {
        this.requestReconnection = function0;
    }

    private final CollectiblePayment getCollectiblePayment() {
        return this.transactionRepository.getCollectiblePayment();
    }

    private final void setCollectiblePayment(CollectiblePayment value) {
        this.transactionRepository.setCollectiblePayment(value);
    }

    @Override
    public void init() {
        this.dispose();
        this.deviceListenerRegistry.registerListener(this.deviceListener);
        this.paymentCollectionWrapper.setPaymentCollectionListener(new BbposAdapterPaymentCollectionListener(this.statusManager, this.transactionRepository));
        this.register(this.configListener);
        this.register(this.readerStatusListener);
        this.registerReaderDisconnectHandler();
        this.register(this.updateListener);
        this.register(this.updateInstaller);
    }

    @Override
    public void dispose() {
        this.deviceListenerRegistry.unregisterListener(this.deviceListener);
        this.compositeDisposable.clear();
    }

    @Override
    public void onChargeAttemptChanged(@Nullable ChargeAttempt chargeAttempt) {
        this.paymentCollectionWrapper.onChargeAttemptChanged(chargeAttempt);
    }

    @Override
    public void cancelCollectPaymentMethod() {
        this.paymentCollectionWrapper.cancelCollectPaymentMethod();
    }

    @Override
    public void cancelReconnectReader() {
        Adapter.ReaderOperation<?> readerOperation = this.getOperationInProgress();
        if (readerOperation instanceof ReconnectReaderOperation) {
            Adapter.ReaderOperation<?> readerOperation2 = this.getOperationInProgress();
            Intrinsics.checkNotNull(readerOperation2, (String)"null cannot be cast to non-null type com.stripe.stripeterminal.internal.common.adapter.BbposAdapter.ReconnectReaderOperation");
            ((ReconnectReaderOperation)readerOperation2).cancel();
        } else if (readerOperation instanceof Adapter.NullOperation) {
            this.setOperationToCancel(ReconnectReaderOperation.class);
        } else {
            this.logUnexpectedOperationInProgressWarning(ReconnectReaderOperation.class);
        }
    }

    @Override
    public void cancelDiscoverReaders(boolean cancelSilently) {
        Adapter.ReaderOperation<?> readerOperation = this.getOperationInProgress();
        if (readerOperation instanceof DiscoverReadersOperation) {
            Adapter.ReaderOperation<?> readerOperation2 = this.getOperationInProgress();
            Intrinsics.checkNotNull(readerOperation2, (String)"null cannot be cast to non-null type com.stripe.stripeterminal.internal.common.adapter.BbposAdapter.DiscoverReadersOperation");
            ((DiscoverReadersOperation)readerOperation2).cancel(cancelSilently);
        } else if (readerOperation instanceof Adapter.NullOperation) {
            this.setOperationToCancel(DiscoverReadersOperation.class);
        } else {
            this.logUnexpectedOperationInProgressWarning(DiscoverReadersOperation.class);
        }
    }

    @Override
    public void cancelInstallUpdate() {
        Adapter.ReaderOperation<?> readerOperation = this.getOperationInProgress();
        if (readerOperation instanceof InstallUpdateOperation) {
            Adapter.ReaderOperation<?> readerOperation2 = this.getOperationInProgress();
            Intrinsics.checkNotNull(readerOperation2, (String)"null cannot be cast to non-null type com.stripe.stripeterminal.internal.common.adapter.BbposAdapter.InstallUpdateOperation");
            ((InstallUpdateOperation)readerOperation2).startCancel();
        } else if (readerOperation instanceof Adapter.NullOperation) {
            this.setOperationToCancel(InstallUpdateOperation.class);
        } else {
            this.logUnexpectedOperationInProgressWarning(InstallUpdateOperation.class);
        }
    }

    @Override
    @Nullable
    public ReaderSoftwareUpdate checkForUpdate(boolean failSilently) {
        this.getLogger().d("checkForUpdate", new Pair[0]);
        this.setOperationInProgress(new CheckForUpdateOperation(failSilently));
        Adapter.ReaderOperation<?> readerOperation = this.getOperationInProgress();
        Intrinsics.checkNotNull(readerOperation, (String)"null cannot be cast to non-null type com.stripe.stripeterminal.internal.common.adapter.BbposAdapter.CheckForUpdateOperation");
        return ((CheckForUpdateOperation)readerOperation).execute();
    }

    @Override
    @NotNull
    public PaymentMethodData collectPaymentMethod(@NotNull PaymentMethodCollectionType paymentMethodCollectionType) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)paymentMethodCollectionType, (String)"paymentMethodCollectionType");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"amount", (Object)paymentMethodCollectionType.getAmount().toString()), TuplesKt.to((Object)"type", (Object)paymentMethodCollectionType.toString())};
            this.getLogger().d("collectPaymentMethod", pairArray);
            com.stripe.stripeterminal.external.models.Reader reader = this.statusManager.getConnectedReader();
            if (reader == null) break block0;
            com.stripe.stripeterminal.external.models.Reader it = reader;
            boolean bl = false;
            this.paymentCollectionWrapper.updateDevicePaymentCapability(it);
        }
        return this.paymentCollectionWrapper.collectPaymentMethod(paymentMethodCollectionType);
    }

    @Override
    @NotNull
    public CollectiblePayment collectiblePayment() {
        CollectiblePayment collectiblePayment = this.getCollectiblePayment();
        if (collectiblePayment == null) {
            throw new TerminalException(TerminalException.TerminalErrorCode.CARD_REMOVED, "Failed to retrieve payment method data", null, null, 12, null);
        }
        return collectiblePayment;
    }

    @Override
    @NotNull
    protected com.stripe.stripeterminal.external.models.Reader onConnectReader(@NotNull com.stripe.stripeterminal.external.models.Reader reader, @NotNull ConnectionConfiguration connectionConfiguration, @Nullable Function0<Unit> requestReconnection) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)connectionConfiguration, (String)"connectionConfiguration");
        this.requestReconnection = requestReconnection;
        this.setOperationInProgress(this.makeConnectReaderOperation(reader));
        this.paymentCollectionWrapper.updateDevicePaymentCapability(reader);
        Adapter.ReaderOperation<?> readerOperation = this.getOperationInProgress();
        Intrinsics.checkNotNull(readerOperation, (String)"null cannot be cast to non-null type com.stripe.stripeterminal.internal.common.adapter.BbposAdapter.ConnectReaderOperation");
        return (com.stripe.stripeterminal.external.models.Reader)((ConnectReaderOperation)readerOperation).execute();
    }

    @Override
    @NotNull
    public com.stripe.stripeterminal.external.models.Reader reconnectReader(@NotNull com.stripe.stripeterminal.external.models.Reader reader, @NotNull Cancelable cancelReconnect) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)cancelReconnect, (String)"cancelReconnect");
        this.getLogger().d("reconnectReader", new Pair[0]);
        this.statusManager.startReconnecting(reader, cancelReconnect);
        this.setOperationInProgress(this.makeReconnectReaderOperation(reader));
        Adapter.ReaderOperation<?> readerOperation = this.getOperationInProgress();
        Intrinsics.checkNotNull(readerOperation, (String)"null cannot be cast to non-null type com.stripe.stripeterminal.internal.common.adapter.BbposAdapter.ReconnectReaderOperation");
        return (com.stripe.stripeterminal.external.models.Reader)((ReconnectReaderOperation)readerOperation).execute();
    }

    @Override
    public void disconnectReader() {
        block3: {
            Object object;
            block2: {
                object = this.statusManager.getConnectedReader();
                if (object == null) break block2;
                com.stripe.stripeterminal.external.models.Reader it = object;
                boolean bl = false;
                Reader reader = this.makeHardwareReader(it);
                object = reader;
                if (reader == null) break block2;
                Object it2 = object;
                boolean bl2 = false;
                this.getLogger().d("disconnectReader", new Pair[0]);
                this.setOperationInProgress(new DisconnectReaderOperation((Reader)it2));
                Object obj = this.getOperationInProgress().execute();
                object = obj;
                if (obj != null) break block3;
            }
            BbposAdapter $this$disconnectReader_u24lambda_u243 = this;
            boolean bl = false;
            $this$disconnectReader_u24lambda_u243.getLogger().w("skipping disconnectReader", new Pair[0]);
            object = Unit.INSTANCE;
        }
    }

    @Override
    public void discoverReaders(@NotNull DiscoveryConfiguration config, @NotNull DiscoveryListener listener2) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.getLogger().d("discoverReaders", new Pair[0]);
        this.setOperationInProgress(this.makeDiscoverReadersOperation(config, listener2));
        this.getOperationInProgress().execute();
    }

    @Override
    @NotNull
    public Deferred<TransactionResult> handleAuthResponse(@NotNull String tlvBlob) {
        Intrinsics.checkNotNullParameter((Object)tlvBlob, (String)"tlvBlob");
        return this.paymentCollectionWrapper.handleAuthResponse(tlvBlob);
    }

    @Override
    public void installUpdate(@NotNull ReaderSoftwareUpdate update2) {
        Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
        this.getLogger().d("installUpdate", new Pair[0]);
        this.setOperationInProgress(new InstallUpdateOperation(update2));
        this.getOperationInProgress().execute();
    }

    @Override
    @NotNull
    public PaymentMethodData readReusableCard() {
        this.getLogger().d("readReusableCard", new Pair[0]);
        return this.paymentCollectionWrapper.readReusableCard();
    }

    @Override
    public void startSession(@NotNull com.stripe.stripeterminal.external.models.Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.getLogger().d("startSession", new Pair[0]);
        this.setOperationInProgress(new StartSessionOperation(reader));
        this.getOperationInProgress().execute();
    }

    @Override
    @Nullable
    public ReaderBatteryInfo requestReaderBatteryInfo(@NotNull Function0<Unit> endPolling) {
        Intrinsics.checkNotNullParameter(endPolling, (String)"endPolling");
        this.getLogger().d("requestReaderBatteryInfo", new Pair[0]);
        this.endBatteryInfoPolling = endPolling;
        this.setOperationInProgress(new RequestReaderBatteryInfoOperation());
        Adapter.ReaderOperation<?> readerOperation = this.getOperationInProgress();
        Intrinsics.checkNotNull(readerOperation, (String)"null cannot be cast to non-null type com.stripe.stripeterminal.internal.common.adapter.BbposAdapter.RequestReaderBatteryInfoOperation");
        return ((RequestReaderBatteryInfoOperation)readerOperation).execute();
    }

    private final void register(ReactiveConfigurationListener configListener) {
        Disposable[] disposableArray = new Disposable[]{configListener.getReaderSettingsObservable().observeOn(this.scheduler).subscribe(new Consumer(this){
            final /* synthetic */ BbposAdapter this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(@NotNull ReaderSettings it) {
                block3: {
                    BbposAdapter bbposAdapter;
                    String string;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    String string2 = it.getMerchantNameAndLocation();
                    if (string2 != null) {
                        string = string2;
                        bbposAdapter = this.this$0;
                        String version = string;
                        boolean bl = false;
                        if (BbposAdapter.access$getOperationInProgress(bbposAdapter) instanceof CheckForUpdateOperation) {
                            MerchantNameData merchantNameData = MerchantNameData.Companion.parseMerchantName(version);
                            Adapter.ReaderOperation readerOperation = BbposAdapter.access$getOperationInProgress(bbposAdapter);
                            Intrinsics.checkNotNull((Object)readerOperation, (String)"null cannot be cast to non-null type com.stripe.stripeterminal.internal.common.adapter.BbposAdapter.CheckForUpdateOperation");
                            ((CheckForUpdateOperation)readerOperation).onReturnCurrentVersion(merchantNameData);
                        }
                    }
                    String string3 = it.getDomesticDebitAidList();
                    if (string3 == null) break block3;
                    string = string3;
                    bbposAdapter = this.this$0;
                    String domesticDebitAidString = string;
                    boolean bl = false;
                    if (BbposAdapter.access$getOperationInProgress(bbposAdapter) instanceof CheckForUpdateOperation) {
                        List<String> domesticDebitAids = BbposAdapter.access$getDomesticDebitAidsParser$p(bbposAdapter).parse(domesticDebitAidString);
                        BbposAdapter.access$getTransactionRepository$p(bbposAdapter).setDomesticDebitAids(domesticDebitAids);
                    }
                }
            }
        }, new Consumer(this){
            final /* synthetic */ BbposAdapter $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void accept(@NotNull Throwable p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                this.$tmp0.onUnexpectedFailure(p0);
            }
        })};
        this.compositeDisposable.addAll(disposableArray);
    }

    protected final void registerReaderDisconnectHandler() {
        block0: {
            Disposable disposable = this.readerDisconnectSubscription = this.readerStatusListener.getReaderDisconnectObservable().observeOn(this.scheduler).subscribe(new Consumer(this){
                final /* synthetic */ BbposAdapter this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void accept(@NotNull DisconnectCause it) {
                    Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                    Adapter.ReaderOperation operation = BbposAdapter.access$getOperationInProgress(this.this$0);
                    if (operation instanceof DisconnectReaderOperation) {
                        ((DisconnectReaderOperation)operation).onDisconnect();
                    } else if (!(operation instanceof InstallUpdateOperation)) {
                        this.this$0.onDisconnect(it);
                    }
                }
            }, new Consumer(this){
                final /* synthetic */ BbposAdapter $tmp0;
                {
                    this.$tmp0 = $tmp0;
                }

                public final void accept(@NotNull Throwable p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    this.$tmp0.onUnexpectedFailure(p0);
                }
            });
            if (disposable == null) break block0;
            Disposable it = disposable;
            boolean bl = false;
            this.compositeDisposable.add(it);
        }
    }

    protected final void removeReaderDisconnectHandler() {
        block0: {
            Disposable disposable = this.readerDisconnectSubscription;
            if (disposable == null) break block0;
            Disposable it = disposable;
            boolean bl = false;
            this.compositeDisposable.remove(it);
        }
    }

    private final void register(ReactiveReaderStatusListener readerListener) {
        Disposable[] disposableArray = new Disposable[]{readerListener.getReaderConnectObservable().observeOn(this.scheduler).subscribe(new Consumer(this){
            final /* synthetic */ BbposAdapter this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(@NotNull Reader it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (BbposAdapter.access$getOperationInProgress(this.this$0) instanceof ConnectReaderOperation) {
                    Adapter.ReaderOperation readerOperation = BbposAdapter.access$getOperationInProgress(this.this$0);
                    Intrinsics.checkNotNull((Object)readerOperation, (String)"null cannot be cast to non-null type com.stripe.stripeterminal.internal.common.adapter.BbposAdapter.ConnectReaderOperation");
                    ((ConnectReaderOperation)readerOperation).onConnectDevice(it);
                }
            }
        }, new Consumer(this){
            final /* synthetic */ BbposAdapter $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void accept(@NotNull Throwable p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                this.$tmp0.onUnexpectedFailure(p0);
            }
        }), readerListener.getReaderInfoObservable().observeOn(this.scheduler).subscribe(new Consumer(this){
            final /* synthetic */ BbposAdapter this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(@NotNull ReaderInfo it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (!(this.this$0 instanceof BbposUsbAdapter) || !(BbposAdapter.access$getOperationInProgress(this.this$0) instanceof DiscoverReadersOperation)) {
                    if (BbposAdapter.access$getOperationInProgress(this.this$0) instanceof ConnectReaderOperation) {
                        Adapter.ReaderOperation readerOperation = BbposAdapter.access$getOperationInProgress(this.this$0);
                        Intrinsics.checkNotNull((Object)readerOperation, (String)"null cannot be cast to non-null type com.stripe.stripeterminal.internal.common.adapter.BbposAdapter.ConnectReaderOperation");
                        ((ConnectReaderOperation)readerOperation).onReportReaderInfo(it);
                    } else {
                        BbposAdapter.access$logUnexpectedOperationInProgressWarning(this.this$0, ConnectReaderOperation.class);
                    }
                }
            }
        }, new Consumer(this){
            final /* synthetic */ BbposAdapter $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void accept(@NotNull Throwable p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                this.$tmp0.onUnexpectedFailure(p0);
            }
        }), readerListener.getReaderDiscoveryObservable().observeOn(this.scheduler).subscribe(new Consumer(this){
            final /* synthetic */ BbposAdapter this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(@NotNull Set<? extends Reader> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                if (BbposAdapter.access$getOperationInProgress(this.this$0) instanceof DiscoverReadersOperation) {
                    Adapter.ReaderOperation readerOperation = BbposAdapter.access$getOperationInProgress(this.this$0);
                    Intrinsics.checkNotNull((Object)readerOperation, (String)"null cannot be cast to non-null type com.stripe.stripeterminal.internal.common.adapter.BbposAdapter.DiscoverReadersOperation");
                    ((DiscoverReadersOperation)readerOperation).onUpdateDiscoveredReaders(it);
                } else {
                    BbposAdapter.access$logUnexpectedOperationInProgressWarning(this.this$0, DiscoverReadersOperation.class);
                }
            }
        }, new Consumer(this){
            final /* synthetic */ BbposAdapter $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void accept(@NotNull Throwable p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                this.$tmp0.onUnexpectedFailure(p0);
            }
        }), readerListener.getReaderLowBatteryObservable().observeOn(this.scheduler).subscribe(new Consumer(this){
            final /* synthetic */ BbposAdapter this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                BbposAdapter.access$getStatusManager$p(this.this$0).reportLowBatteryWarning();
            }
        }, new Consumer(this){
            final /* synthetic */ BbposAdapter $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void accept(@NotNull Throwable p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                this.$tmp0.onUnexpectedFailure(p0);
            }
        }), readerListener.getReaderDeviceBusyObservable().observeOn(this.scheduler).subscribe(new Consumer(this){
            final /* synthetic */ BbposAdapter this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(@NotNull Unit it) {
                Boolean isDisposedOrNull;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Disposable disposable = BbposAdapter.access$getDeviceBusyDisposable$p(this.this$0);
                Boolean bl = isDisposedOrNull = disposable != null ? Boolean.valueOf(disposable.isDisposed()) : null;
                if (isDisposedOrNull == null || isDisposedOrNull.booleanValue()) {
                    BbposAdapter.access$setDeviceBusyDisposable$p(this.this$0, BbposAdapter.access$getScheduler$p(this.this$0).scheduleDirect(() -> register.11.accept$lambda$0(this.this$0), 1L, TimeUnit.SECONDS));
                }
            }

            private static final void accept$lambda$0(BbposAdapter this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                try {
                    this$0.update();
                }
                catch (Exception e2) {
                    this$0.onUnexpectedFailure(e2);
                    return;
                }
            }
        }, new Consumer(this){
            final /* synthetic */ BbposAdapter $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void accept(@NotNull Throwable p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                this.$tmp0.onUnexpectedFailure(p0);
            }
        }), readerListener.getReaderExceptionObservable().observeOn(this.scheduler).subscribe(new Consumer(this){
            final /* synthetic */ BbposAdapter $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void accept(@NotNull Throwable p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                this.$tmp0.onUnexpectedFailure(p0);
            }
        }, new Consumer(this){
            final /* synthetic */ BbposAdapter $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void accept(@NotNull Throwable p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                this.$tmp0.onUnexpectedFailure(p0);
            }
        })};
        this.compositeDisposable.addAll(disposableArray);
    }

    protected void onDisconnect(@NotNull DisconnectCause disconnectCause) {
        Intrinsics.checkNotNullParameter((Object)((Object)disconnectCause), (String)"disconnectCause");
        this.endBatteryInfoPolling.invoke();
    }

    private final void register(ReactiveReaderUpdateListener listener2) {
        Disposable[] disposableArray = new Disposable[]{listener2.getReaderUpdateExceptionObservable().observeOn(this.scheduler).subscribe(new Consumer(this){
            final /* synthetic */ BbposAdapter this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(@NotNull ReaderUpdateException it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (BbposAdapter.access$getOperationInProgress(this.this$0) instanceof UpdateOperation) {
                    Adapter.ReaderOperation readerOperation = BbposAdapter.access$getOperationInProgress(this.this$0);
                    InstallUpdateOperation installUpdateOperation = readerOperation instanceof InstallUpdateOperation ? (InstallUpdateOperation)readerOperation : null;
                    if (!(installUpdateOperation != null ? installUpdateOperation.getCancelled() : false)) {
                        Adapter.ReaderOperation readerOperation2 = BbposAdapter.access$getOperationInProgress(this.this$0);
                        Intrinsics.checkNotNull((Object)readerOperation2, (String)"null cannot be cast to non-null type com.stripe.stripeterminal.internal.common.adapter.BbposAdapter.UpdateOperation<*>");
                        ((UpdateOperation)readerOperation2).onUpdateException(it);
                    }
                }
            }
        }, new Consumer(this){
            final /* synthetic */ BbposAdapter $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void accept(@NotNull Throwable p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                this.$tmp0.onUnexpectedFailure(p0);
            }
        })};
        this.compositeDisposable.addAll(disposableArray);
    }

    private final void register(UpdateInstaller updateInstaller) {
        Disposable[] disposableArray = new Disposable[]{updateInstaller.getReaderUpdateExceptionObservable().observeOn(this.scheduler).subscribe(new Consumer(this){
            final /* synthetic */ BbposAdapter this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(@NotNull ReaderUpdateException it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.onFailure(TerminalExceptionMaker.Companion.fromReaderUpdateException(it));
            }
        }, new Consumer(this){
            final /* synthetic */ BbposAdapter $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void accept(@NotNull Throwable p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                this.$tmp0.onUnexpectedFailure(p0);
            }
        }), updateInstaller.getReaderUpdateCompleteObservable().observeOn(this.scheduler).subscribe(new Consumer(this){
            final /* synthetic */ BbposAdapter this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (BbposAdapter.access$getOperationInProgress(this.this$0) instanceof InstallUpdateOperation) {
                    Adapter.ReaderOperation readerOperation = BbposAdapter.access$getOperationInProgress(this.this$0);
                    Intrinsics.checkNotNull((Object)readerOperation, (String)"null cannot be cast to non-null type com.stripe.stripeterminal.internal.common.adapter.BbposAdapter.InstallUpdateOperation");
                    ((InstallUpdateOperation)readerOperation).completeUpdates();
                }
            }
        }, new Consumer(this){
            final /* synthetic */ BbposAdapter $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void accept(@NotNull Throwable p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                this.$tmp0.onUnexpectedFailure(p0);
            }
        }), updateInstaller.getReaderUpdateProgressObservable().observeOn(this.scheduler).subscribe(new Consumer(this){
            final /* synthetic */ BbposAdapter this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(float it) {
                if (BbposAdapter.access$getOperationInProgress(this.this$0) instanceof InstallUpdateOperation) {
                    Adapter.ReaderOperation readerOperation = BbposAdapter.access$getOperationInProgress(this.this$0);
                    Intrinsics.checkNotNull((Object)readerOperation, (String)"null cannot be cast to non-null type com.stripe.stripeterminal.internal.common.adapter.BbposAdapter.InstallUpdateOperation");
                    ((InstallUpdateOperation)readerOperation).onReportUpdateProgress(it);
                }
            }
        }, new Consumer(this){
            final /* synthetic */ BbposAdapter $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void accept(@NotNull Throwable p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                this.$tmp0.onUnexpectedFailure(p0);
            }
        }), updateInstaller.getReaderUpdateCancelledObservable().observeOn(this.scheduler).subscribe(new Consumer(this){
            final /* synthetic */ BbposAdapter this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (BbposAdapter.access$getOperationInProgress(this.this$0) instanceof InstallUpdateOperation) {
                    Adapter.ReaderOperation readerOperation = BbposAdapter.access$getOperationInProgress(this.this$0);
                    Intrinsics.checkNotNull((Object)readerOperation, (String)"null cannot be cast to non-null type com.stripe.stripeterminal.internal.common.adapter.BbposAdapter.InstallUpdateOperation");
                    ((InstallUpdateOperation)readerOperation).completeCancel();
                }
            }
        }, new Consumer(this){
            final /* synthetic */ BbposAdapter $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void accept(@NotNull Throwable p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                this.$tmp0.onUnexpectedFailure(p0);
            }
        })};
        this.compositeDisposable.addAll(disposableArray);
    }

    protected final synchronized void update() {
        this.connectAndUpdateStateMachine.update(this.updateManager.getSummary(), this.connectionManager.getSummary());
    }

    protected final void onUnexpectedFailure(@NotNull Throwable t2) {
        Intrinsics.checkNotNullParameter((Object)t2, (String)"t");
        this.getLogger().e(t2);
        this.onFailure(new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Unexpected failure", t2, null, 8, null));
    }

    protected void onFailure(@NotNull TerminalException e2) {
        Intrinsics.checkNotNullParameter((Object)((Object)e2), (String)"e");
        this.paymentCollectionWrapper.cancelCollectPaymentMethod();
        this.connectionManager.endOperation();
        this.updateManager.endOperation();
        this.update();
        this.getOperationInProgress().setException(e2);
    }

    @NotNull
    protected Map<String, Location> getLocationsForDiscovery(@NotNull List<String> deviceSerials) throws TerminalException {
        Intrinsics.checkNotNullParameter(deviceSerials, (String)"deviceSerials");
        return this.resourceRepository.getReaderLocations(deviceSerials);
    }

    @NotNull
    protected final TransactionType emvTransactionTypeForDeviceType(@NotNull DeviceType deviceType) throws TerminalException {
        TransactionType transactionType;
        Intrinsics.checkNotNullParameter((Object)deviceType, (String)"deviceType");
        switch (WhenMappings.$EnumSwitchMapping$0[deviceType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                transactionType = TransactionType.QUICK;
                break;
            }
            case 5: 
            case 6: {
                transactionType = TransactionType.TRADITIONAL;
                break;
            }
            default: {
                throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Unexpected device type: " + deviceType, null, null, 12, null);
            }
        }
        return transactionType;
    }

    private final boolean shouldStartTipping(TippingConfigPb tippingConfig, Amount amount, boolean skipTipping) {
        com.stripe.stripeterminal.external.models.Reader reader = this.statusManager.getConnectedReader();
        boolean bl = reader != null && (reader = reader.getDeviceType()) != null ? !DeviceTypeExtensions.INSTANCE.supportsOnReaderTipping((DeviceType)reader) : false;
        if (bl) {
            this.getLogger().i("Not starting the tipping flow because device doesn't support on reader tipping", new Pair[0]);
            return false;
        }
        if (this.featureFlagsRepository.getFeatureFlags().wp3_tipping_android_sdk_circuit_breaker) {
            this.getLogger().i("Not starting the tipping flow because the circuit breaker is enabled", new Pair[0]);
            return false;
        }
        if (skipTipping) {
            this.getLogger().i("Not starting the tipping flow because the skip tipping flag is set to true", new Pair[0]);
            return false;
        }
        TippingConfigPb tippingConfigPb = tippingConfig;
        Map<String, TippingConfigPb.LocalizedTippingConfig> localizedTippingConfigs = tippingConfigPb != null ? tippingConfigPb.localized_tipping_config : null;
        Map<String, TippingConfigPb.LocalizedTippingConfig> map2 = localizedTippingConfigs;
        if (map2 == null || map2.isEmpty()) {
            this.getLogger().i("Not starting the tipping flow because there is no tipping config", new Pair[0]);
            return false;
        }
        TippingConfigPb.LocalizedTippingConfig localizedTippingConfig = localizedTippingConfigs.get(amount.getCurrencyCode());
        if (localizedTippingConfig == null) {
            String tippingCurrencies = CollectionsKt.joinToString$default((Iterable)localizedTippingConfigs.keySet(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            this.getLogger().i("Tipping flow will not start because there are no tipping configs match. the transaction used for the currency. Tipping currencies: " + tippingCurrencies + ". Transaction currency: " + amount.getCurrencyCode(), new Pair[0]);
            return false;
        }
        this.getLogger().i("Starting tipping flow with currency: " + amount.getCurrencyCode(), new Pair[0]);
        return true;
    }

    static /* synthetic */ boolean shouldStartTipping$default(BbposAdapter bbposAdapter, TippingConfigPb tippingConfigPb, Amount amount, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: shouldStartTipping");
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return bbposAdapter.shouldStartTipping(tippingConfigPb, amount, bl);
    }

    private final ReaderInputOptions.ReaderInputOption translateReaderType(ReaderConfiguration.ReaderType readerType) {
        ReaderInputOptions.ReaderInputOption readerInputOption;
        switch (WhenMappings.$EnumSwitchMapping$1[readerType.ordinal()]) {
            case 1: {
                readerInputOption = ReaderInputOptions.ReaderInputOption.SWIPE;
                break;
            }
            case 2: {
                readerInputOption = ReaderInputOptions.ReaderInputOption.INSERT;
                break;
            }
            case 3: {
                readerInputOption = ReaderInputOptions.ReaderInputOption.TAP;
                break;
            }
            case 4: {
                readerInputOption = ReaderInputOptions.ReaderInputOption.MANUAL_ENTRY;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return readerInputOption;
    }

    @NotNull
    protected abstract ConnectReaderOperation makeConnectReaderOperation(@NotNull com.stripe.stripeterminal.external.models.Reader var1);

    @NotNull
    protected abstract ReconnectReaderOperation makeReconnectReaderOperation(@NotNull com.stripe.stripeterminal.external.models.Reader var1);

    @NotNull
    protected abstract DiscoverReadersOperation makeDiscoverReadersOperation(@NotNull DiscoveryConfiguration var1, @NotNull DiscoveryListener var2);

    @Nullable
    protected abstract Reader makeHardwareReader(@NotNull com.stripe.stripeterminal.external.models.Reader var1);

    protected abstract void saveReconnectParams(@NotNull MobileClientConfig var1);

    @Override
    public void onOnlineAuthStateChanged(@NotNull OnlineAuthState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.paymentCollectionWrapper.onOnlineAuthStateChanged(state);
    }

    public static final /* synthetic */ Adapter.ReaderOperation access$getOperationInProgress(BbposAdapter $this) {
        return $this.getOperationInProgress();
    }

    public static final /* synthetic */ DomesticDebitAidsParser access$getDomesticDebitAidsParser$p(BbposAdapter $this) {
        return $this.domesticDebitAidsParser;
    }

    public static final /* synthetic */ TransactionRepository access$getTransactionRepository$p(BbposAdapter $this) {
        return $this.transactionRepository;
    }

    public static final /* synthetic */ void access$logUnexpectedOperationInProgressWarning(BbposAdapter $this, Class clazz) {
        $this.logUnexpectedOperationInProgressWarning(clazz);
    }

    public static final /* synthetic */ Disposable access$getDeviceBusyDisposable$p(BbposAdapter $this) {
        return $this.deviceBusyDisposable;
    }

    public static final /* synthetic */ void access$setDeviceBusyDisposable$p(BbposAdapter $this, Disposable disposable) {
        $this.deviceBusyDisposable = disposable;
    }

    public static final /* synthetic */ ReactiveReaderUpdateListener access$getUpdateListener$p(BbposAdapter $this) {
        return $this.updateListener;
    }

    public static final /* synthetic */ ReactiveReaderStatusListener access$getReaderStatusListener$p(BbposAdapter $this) {
        return $this.readerStatusListener;
    }

    public static final /* synthetic */ ReaderUpdateController access$getReaderUpdateController$p(BbposAdapter $this) {
        return $this.readerUpdateController;
    }

    public static final /* synthetic */ UpdateClient access$getUpdateClient$p(BbposAdapter $this) {
        return $this.updateClient;
    }

    public static final /* synthetic */ FeatureFlagsRepository access$getFeatureFlagsRepository$p(BbposAdapter $this) {
        return $this.featureFlagsRepository;
    }

    public static final /* synthetic */ ReaderInfoController access$getReaderInfoController$p(BbposAdapter $this) {
        return $this.readerInfoController;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J!\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\n\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0016J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter$CheckForUpdateOperation;", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter$UpdateOperation;", "Lcom/stripe/stripeterminal/external/models/ReaderSoftwareUpdate;", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter;", "failSilently", "", "(Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter;Z)V", "checkTmsTargetVersion", "Lkotlinx/coroutines/flow/Flow;", "reader", "Lcom/stripe/stripeterminal/external/models/Reader;", "(Lcom/stripe/stripeterminal/external/models/Reader;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "execute", "onReturnCurrentVersion", "", "data", "Lcom/stripe/core/hardware/reactive/emv/MerchantNameData;", "adapter_release"})
    private final class CheckForUpdateOperation
    extends UpdateOperation<ReaderSoftwareUpdate> {
        private final boolean failSilently;

        public CheckForUpdateOperation(boolean failSilently) {
            this.failSilently = failSilently;
        }

        @Override
        @Nullable
        public ReaderSoftwareUpdate execute() throws TerminalException {
            BbposAdapter.this.updateManager.startCheckForUpdates();
            BbposAdapter.this.update();
            return (ReaderSoftwareUpdate)this.get();
        }

        public final void onReturnCurrentVersion(@NotNull MerchantNameData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            BbposAdapter.this.scheduler.scheduleDirect(() -> CheckForUpdateOperation.onReturnCurrentVersion$lambda$1(BbposAdapter.this, this, data));
        }

        private final Object checkTmsTargetVersion(com.stripe.stripeterminal.external.models.Reader reader, Continuation<? super Flow<ReaderSoftwareUpdate>> $completion) {
            return FlowKt.callbackFlow((Function2)((Function2)new Function2<ProducerScope<? super ReaderSoftwareUpdate>, Continuation<? super Unit>, Object>(BbposAdapter.this, reader, this, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ BbposAdapter this$0;
                final /* synthetic */ com.stripe.stripeterminal.external.models.Reader $reader;
                final /* synthetic */ CheckForUpdateOperation this$1;
                {
                    this.this$0 = $receiver;
                    this.$reader = $reader;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            ProducerScope $this$callbackFlow = (ProducerScope)this.L$0;
                            Disposable disposable = BbposAdapter.access$getUpdateListener$p(this.this$0).getReaderTargetVersionObservable().subscribe(new Consumer(this.this$0, this.$reader, (ProducerScope<? super ReaderSoftwareUpdate>)$this$callbackFlow, this.this$1){
                                final /* synthetic */ BbposAdapter this$0;
                                final /* synthetic */ com.stripe.stripeterminal.external.models.Reader $reader;
                                final /* synthetic */ ProducerScope<ReaderSoftwareUpdate> $$this$callbackFlow;
                                final /* synthetic */ CheckForUpdateOperation this$1;
                                {
                                    this.this$0 = $receiver;
                                    this.$reader = $reader;
                                    this.$$this$callbackFlow = $$this$callbackFlow;
                                    this.this$1 = $receiver2;
                                }

                                public final void accept(@NotNull Optional<ReaderVersion> it) {
                                    Intrinsics.checkNotNullParameter(it, (String)"it");
                                    if (BbposAdapter.access$getOperationInProgress(this.this$0) instanceof CheckForUpdateOperation) {
                                        Optional<ReaderVersion> optional = it;
                                        if (optional instanceof Optional.Present) {
                                            ReaderSoftwareUpdate update2 = ReaderSoftwareUpdateMaker.Companion.create(this.$reader, (ReaderVersion)((Optional.Present)it).getValue());
                                            ChannelsKt.trySendBlocking((SendChannel)((SendChannel)this.$$this$callbackFlow), (Object)update2);
                                        } else if (optional instanceof Optional.Absent) {
                                            this.this$1.setException(new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "No target version returned", null, null, 12, null));
                                        }
                                    }
                                    SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.$$this$callbackFlow), null, (int)1, null);
                                }
                            });
                            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"@ExperimentalCoroutinesA\u2026pter::class.java)\n    }\n}");
                            Disposable updateSubscription2 = disposable;
                            Disposable disposable2 = BbposAdapter.access$getReaderStatusListener$p(this.this$0).getReaderExceptionObservable().subscribe(new Consumer((ProducerScope<? super ReaderSoftwareUpdate>)$this$callbackFlow){
                                final /* synthetic */ ProducerScope<ReaderSoftwareUpdate> $$this$callbackFlow;
                                {
                                    this.$$this$callbackFlow = $$this$callbackFlow;
                                }

                                public final void accept(@NotNull ReaderException it) {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    ChannelsKt.trySendBlocking((SendChannel)((SendChannel)this.$$this$callbackFlow), null);
                                }
                            });
                            Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"readerStatusListener.rea\u2026g(null)\n                }");
                            Disposable exceptionSubscription2 = disposable2;
                            BbposAdapter.access$getReaderUpdateController$p(this.this$0).checkForUpdates();
                            this.label = 1;
                            Object object3 = ProduceKt.awaitClose((ProducerScope)$this$callbackFlow, (Function0)((Function0)new Function0<Unit>(updateSubscription2, exceptionSubscription2){
                                final /* synthetic */ Disposable $updateSubscription;
                                final /* synthetic */ Disposable $exceptionSubscription;
                                {
                                    this.$updateSubscription = $updateSubscription;
                                    this.$exceptionSubscription = $exceptionSubscription;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.$updateSubscription.dispose();
                                    this.$exceptionSubscription.dispose();
                                }
                            }), (Continuation)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<ProducerScope<? super ReaderSoftwareUpdate>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(@NotNull ProducerScope<? super ReaderSoftwareUpdate> p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        /*
         * Unable to fully structure code
         */
        private static final void onReturnCurrentVersion$lambda$1(BbposAdapter this$0, CheckForUpdateOperation this$1, MerchantNameData $data) {
            block9: {
                block8: {
                    block7: {
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
                        Intrinsics.checkNotNullParameter((Object)$data, (String)"$data");
                        v0 = BbposAdapter.access$getStatusManager$p(this$0).getConnectedReader();
                        if (v0 == null) break block7;
                        reader = v0;
                        $i$a$-let-BbposAdapter$CheckForUpdateOperation$onReturnCurrentVersion$1$1 = false;
                        reader.setSettingsVersion($data.getConfigHash());
                        try {
                            config = BbposAdapter.access$getUpdateClient$p(this$0).downloadMobilePosConfig($data);
                            this$0.saveReconnectParams(config);
                            if (BbposAdapter.access$getFeatureFlagsRepository$p((BbposAdapter)this$0).getFeatureFlags().enableBbposVersioning) ** GOTO lbl-1000
                            v1 = BuildConfig.BBPOS_VERSIONING;
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"BBPOS_VERSIONING");
                            if (v1.booleanValue()) lbl-1000:
                            // 2 sources

                            {
                                v2 = (ReaderSoftwareUpdate)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ReaderSoftwareUpdate>, Object>(this$1, reader, null){
                                    int label;
                                    final /* synthetic */ CheckForUpdateOperation this$0;
                                    final /* synthetic */ com.stripe.stripeterminal.external.models.Reader $reader;
                                    {
                                        this.this$0 = $receiver;
                                        this.$reader = $reader;
                                        super(2, $completion);
                                    }

                                    /*
                                     * Unable to fully structure code
                                     */
                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object var1_1) {
                                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)var1_1);
                                                this.label = 1;
                                                v0 = CheckForUpdateOperation.access$checkTmsTargetVersion(this.this$0, this.$reader, (Continuation)this);
                                                if (v0 == var2_2) {
                                                    return var2_2;
                                                }
                                                ** GOTO lbl13
                                            }
                                            case 1: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = $result;
lbl13:
                                                // 2 sources

                                                this.label = 2;
                                                v1 = FlowKt.firstOrNull((Flow)((Flow)v0), (Continuation)((Continuation)this));
                                                if (v1 == var2_2) {
                                                    return var2_2;
                                                }
                                                ** GOTO lbl21
                                            }
                                            case 2: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                v1 = $result;
lbl21:
                                                // 2 sources

                                                return v1;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ReaderSoftwareUpdate> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)1, null);
                            } else {
                                v2 = ReaderSoftwareUpdateMaker.Companion.create(reader, $data, config, BbposAdapter.access$getFeatureFlagsRepository$p(this$0));
                            }
                            var5_5 = v2;
                        }
                        catch (ReaderUpdateException e) {
                            if (!this$1.failSilently) {
                                this$0.onFailure(TerminalExceptionMaker.Companion.fromReaderUpdateException(e));
                                return;
                            }
                            var5_5 = null;
                        }
                        catch (Exception e) {
                            if (!this$1.failSilently) {
                                this$0.onUnexpectedFailure(e);
                                return;
                            }
                            var5_5 = null;
                        }
                        update = var5_5;
                        BbposAdapter.access$getUpdateManager$p(this$0).endOperation();
                        this$0.update();
                        this$1.set(update);
                        v3 = Unit.INSTANCE;
                        break block8;
                    }
                    v3 = null;
                }
                if (v3 != null) break block9;
                this$1.setException(new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "No connected reader", null, null, 12, null));
            }
        }

        public static final /* synthetic */ Object access$checkTmsTargetVersion(CheckForUpdateOperation $this, com.stripe.stripeterminal.external.models.Reader reader, Continuation $completion) {
            return $this.checkTmsTargetVersion(reader, (Continuation<? super Flow<ReaderSoftwareUpdate>>)$completion);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter$Companion;", "", "()V", "DEFAULT_ATTEMPT_DELAY_MILLIS", "", "DEFAULT_RECONNECTION_MAX_ATTEMPTS", "", "DEFAULT_RECONNECTION_TIMEOUT", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "RECONNECTION_OUTCOME_TAG_KEY", "", "adapter_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00a4\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\f"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter$ConnectReaderOperation;", "Lcom/stripe/stripeterminal/internal/common/Adapter$ReaderOperation;", "Lcom/stripe/stripeterminal/external/models/Reader;", "Lcom/stripe/stripeterminal/internal/common/Adapter;", "(Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter;)V", "onConnectDevice", "", "reader", "Lcom/stripe/core/hardware/Reader;", "onReportReaderInfo", "info", "Lcom/stripe/jvmcore/hardware/status/ReaderInfo;", "adapter_release"})
    protected abstract class ConnectReaderOperation
    extends Adapter.ReaderOperation<com.stripe.stripeterminal.external.models.Reader> {
        public abstract void onConnectDevice(@NotNull Reader var1);

        public abstract void onReportReaderInfo(@NotNull ReaderInfo var1);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter$DisconnectReaderOperation;", "Lcom/stripe/stripeterminal/internal/common/Adapter$ReaderOperation;", "Ljava/lang/Void;", "Lcom/stripe/stripeterminal/internal/common/Adapter;", "reader", "Lcom/stripe/core/hardware/Reader;", "(Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter;Lcom/stripe/core/hardware/Reader;)V", "execute", "onDisconnect", "", "adapter_release"})
    protected final class DisconnectReaderOperation
    extends Adapter.ReaderOperation<Void> {
        @NotNull
        private final Reader reader;

        public DisconnectReaderOperation(Reader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            this.reader = reader;
        }

        @Override
        @Nullable
        public Void execute() throws TerminalException {
            BbposAdapter.this.endBatteryInfoPolling.invoke();
            BbposAdapter.this.paymentCollectionWrapper.cancelCollectPaymentMethod();
            BbposAdapter.this.updateManager.endOperation();
            BbposAdapter.this.connectionManager.startDisconnect(this.reader);
            BbposAdapter.this.update();
            BbposAdapter.this.sessionTokenRepository.setSessionTokenListener(null);
            return (Void)this.get();
        }

        public final void onDisconnect() {
            BbposAdapter.this.connectionManager.endOperation();
            BbposAdapter.this.update();
            this.set(null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u00a4\u0004\u0018\u00002\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001R\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&J\u0016\u0010\t\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH&\u00a8\u0006\r"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter$DiscoverReadersOperation;", "Lcom/stripe/stripeterminal/internal/common/Adapter$ReaderOperation;", "Ljava/lang/Void;", "Lcom/stripe/stripeterminal/internal/common/Adapter;", "(Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter;)V", "cancel", "", "cancelSilently", "", "onUpdateDiscoveredReaders", "readers", "", "Lcom/stripe/core/hardware/Reader;", "adapter_release"})
    protected abstract class DiscoverReadersOperation
    extends Adapter.ReaderOperation<Void> {
        public abstract void onUpdateDiscoveredReaders(@NotNull Set<? extends Reader> var1);

        public abstract void cancel(boolean var1);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0016J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u000eR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter$InstallUpdateOperation;", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter$UpdateOperation;", "Ljava/lang/Void;", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter;", "update", "Lcom/stripe/stripeterminal/external/models/ReaderSoftwareUpdate;", "(Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter;Lcom/stripe/stripeterminal/external/models/ReaderSoftwareUpdate;)V", "cancelled", "", "getCancelled", "()Z", "setCancelled", "(Z)V", "completeCancel", "", "completeUpdates", "execute", "onReportUpdateProgress", "progress", "", "startCancel", "adapter_release"})
    private final class InstallUpdateOperation
    extends UpdateOperation<Void> {
        @NotNull
        private final ReaderSoftwareUpdate update;
        private boolean cancelled;

        public InstallUpdateOperation(ReaderSoftwareUpdate update2) {
            Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
            this.update = update2;
        }

        public final boolean getCancelled() {
            return this.cancelled;
        }

        public final void setCancelled(boolean bl) {
            this.cancelled = bl;
        }

        @Override
        @Nullable
        public Void execute() {
            boolean shouldInstallBase = this.update.getRequiredAt().before(new Date()) || !this.update.getOnlyInstallRequiredUpdates();
            ClientVersionSpecPb firmware = shouldInstallBase ? this.update.getFirmwareSpec() : null;
            ClientVersionSpecPb config = shouldInstallBase ? this.update.getConfigSpec() : null;
            String keys = shouldInstallBase ? this.update.getKeyProfileName() : null;
            BbposAdapter.this.updateManager.startInstallUpdate(this.update.getConfig(), config, firmware, keys, this.update.getSettingsVersion(), this.update.getImageRef());
            BbposAdapter.this.update();
            return (Void)this.get();
        }

        public final void startCancel() {
            this.cancelled = true;
            BbposAdapter.this.updateManager.endOperation();
            BbposAdapter.this.update();
        }

        public final void completeCancel() {
            this.setException(new TerminalException(TerminalException.TerminalErrorCode.CANCELED, "Install update was cancelled", null, null, 12, null));
        }

        public final void completeUpdates() {
            BbposAdapter.this.updateManager.endOperation();
            BbposAdapter.this.update();
            this.set(null);
        }

        public final void onReportUpdateProgress(float progress) {
            BbposAdapter.this.statusManager.reportReaderSoftwareUpdateProgress(progress);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00a4\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter$ReconnectReaderOperation;", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter$ConnectReaderOperation;", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter;", "(Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter;)V", "cancel", "", "adapter_release"})
    protected abstract class ReconnectReaderOperation
    extends ConnectReaderOperation {
        public abstract void cancel();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001R\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter$RequestReaderBatteryInfoOperation;", "Lcom/stripe/stripeterminal/internal/common/Adapter$ReaderOperation;", "Lcom/stripe/stripeterminal/external/models/ReaderBatteryInfo;", "Lcom/stripe/stripeterminal/internal/common/Adapter;", "(Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter;)V", "execute", "adapter_release"})
    private final class RequestReaderBatteryInfoOperation
    extends Adapter.ReaderOperation<ReaderBatteryInfo> {
        @Override
        @Nullable
        public ReaderBatteryInfo execute() {
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)BbposAdapter.this.dispatcher)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, BbposAdapter.this, null){
                int label;
                final /* synthetic */ RequestReaderBatteryInfoOperation this$0;
                final /* synthetic */ BbposAdapter this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = FlowKt.first((Flow)FlowKt.callbackFlow((Function2)((Function2)new Function2<ProducerScope<? super ReaderBatteryInfo>, Continuation<? super Unit>, Object>(this.this$1, null){
                                int label;
                                private /* synthetic */ Object L$0;
                                final /* synthetic */ BbposAdapter this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object var1_1) {
                                    var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)var1_1);
                                            $this$callbackFlow = (ProducerScope)this.L$0;
                                            this.L$0 = $this$callbackFlow;
                                            this.label = 1;
                                            v0 = FlowKt.first((Flow)((Flow)BbposAdapter.access$getTransactionRepository$p(this.this$0).getCardStatusFlow()), (Function2)((Function2)new Function2<ContactCardSlotState, Continuation<? super Boolean>, Object>(null){
                                                int label;
                                                /* synthetic */ Object L$0;

                                                @Nullable
                                                public final Object invokeSuspend(@NotNull Object object) {
                                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)object);
                                                            ContactCardSlotState it = (ContactCardSlotState)((Object)this.L$0);
                                                            return Boxing.boxBoolean((it == ContactCardSlotState.EMPTY ? 1 : 0) != 0);
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                @NotNull
                                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                    Function2<ContactCardSlotState, Continuation<? super Boolean>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                                    function2.L$0 = value;
                                                    return (Continuation)function2;
                                                }

                                                @Nullable
                                                public final Object invoke(@NotNull ContactCardSlotState p1, @Nullable Continuation<? super Boolean> p2) {
                                                    return (this.create((Object)((Object)p1), p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (Continuation)((Continuation)this));
                                            if (v0 == var6_2) {
                                                return var6_2;
                                            }
                                            ** GOTO lbl16
                                        }
                                        case 1: {
                                            $this$callbackFlow = (ProducerScope)this.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl16:
                                            // 2 sources

                                            v1 = BbposAdapter.access$getReaderStatusListener$p(this.this$0).getReaderBatteryInfoObservable().subscribe(new Consumer((ProducerScope<? super ReaderBatteryInfo>)$this$callbackFlow){
                                                final /* synthetic */ ProducerScope<ReaderBatteryInfo> $$this$callbackFlow;
                                                {
                                                    this.$$this$callbackFlow = $$this$callbackFlow;
                                                }

                                                public final void accept(@NotNull ReaderInfo it) {
                                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                                    ChannelsKt.trySendBlocking((SendChannel)((SendChannel)this.$$this$callbackFlow), (Object)ReaderBatteryInfo.Companion.fromReaderInfo(it));
                                                    SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.$$this$callbackFlow), null, (int)1, null);
                                                }
                                            });
                                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"readerStatusListener.rea\u2026e()\n                    }");
                                            subscription = v1;
                                            v2 = BbposAdapter.access$getReaderStatusListener$p(this.this$0).getReaderExceptionObservable().subscribe(new Consumer((ProducerScope<? super ReaderBatteryInfo>)$this$callbackFlow){
                                                final /* synthetic */ ProducerScope<ReaderBatteryInfo> $$this$callbackFlow;
                                                {
                                                    this.$$this$callbackFlow = $$this$callbackFlow;
                                                }

                                                public final void accept(@NotNull ReaderException it) {
                                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                                    ChannelsKt.trySendBlocking((SendChannel)((SendChannel)this.$$this$callbackFlow), null);
                                                }
                                            });
                                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"readerStatusListener.rea\u2026ll)\n                    }");
                                            exceptionSubscription = v2;
                                            v3 = BbposAdapter.access$getReaderStatusListener$p(this.this$0).getReaderDeviceBusyObservable().subscribe(new Consumer(this.this$0, (ProducerScope<? super ReaderBatteryInfo>)$this$callbackFlow){
                                                final /* synthetic */ BbposAdapter this$0;
                                                final /* synthetic */ ProducerScope<ReaderBatteryInfo> $$this$callbackFlow;
                                                {
                                                    this.this$0 = $receiver;
                                                    this.$$this$callbackFlow = $$this$callbackFlow;
                                                }

                                                public final void accept(@NotNull Unit it) {
                                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                                    if (BbposAdapter.access$getOperationInProgress(this.this$0) instanceof RequestReaderBatteryInfoOperation) {
                                                        ChannelsKt.trySendBlocking((SendChannel)((SendChannel)this.$$this$callbackFlow), null);
                                                    }
                                                }
                                            });
                                            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"@ExperimentalCoroutinesA\u2026pter::class.java)\n    }\n}");
                                            deviceBusySubscription = v3;
                                            BbposAdapter.access$getReaderInfoController$p(this.this$0).requestReaderBatteryInfo();
                                            this.L$0 = null;
                                            this.label = 2;
                                            v4 = ProduceKt.awaitClose((ProducerScope)$this$callbackFlow, (Function0)((Function0)new Function0<Unit>(subscription, exceptionSubscription, deviceBusySubscription){
                                                final /* synthetic */ Disposable $subscription;
                                                final /* synthetic */ Disposable $exceptionSubscription;
                                                final /* synthetic */ Disposable $deviceBusySubscription;
                                                {
                                                    this.$subscription = $subscription;
                                                    this.$exceptionSubscription = $exceptionSubscription;
                                                    this.$deviceBusySubscription = $deviceBusySubscription;
                                                    super(0);
                                                }

                                                public final void invoke() {
                                                    this.$subscription.dispose();
                                                    this.$exceptionSubscription.dispose();
                                                    this.$deviceBusySubscription.dispose();
                                                }
                                            }), (Continuation)((Continuation)this));
                                            if (v4 == var6_2) {
                                                return var6_2;
                                            }
                                            ** GOTO lbl35
                                        }
                                        case 2: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v4 = $result;
lbl35:
                                            // 2 sources

                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    Function2<ProducerScope<? super ReaderBatteryInfo>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                    function2.L$0 = value;
                                    return (Continuation)function2;
                                }

                                @Nullable
                                public final Object invoke(@NotNull ProducerScope<? super ReaderBatteryInfo> p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            })), (Continuation)((Continuation)this));
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            readerBatteryInfo = (ReaderBatteryInfo)v0;
                            this.this$0.set(readerBatteryInfo);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            return (ReaderBatteryInfo)this.get();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0002H\u0016J\u001f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\u0004\u001a\u00020\nH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\f"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter$StartSessionOperation;", "Lcom/stripe/stripeterminal/internal/common/Adapter$ReaderOperation;", "", "Lcom/stripe/stripeterminal/internal/common/Adapter;", "reader", "Lcom/stripe/stripeterminal/external/models/Reader;", "(Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter;Lcom/stripe/stripeterminal/external/models/Reader;)V", "execute", "startSession", "Lkotlinx/coroutines/flow/Flow;", "Lcom/stripe/core/hardware/Reader;", "(Lcom/stripe/core/hardware/Reader;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "adapter_release"})
    private final class StartSessionOperation
    extends Adapter.ReaderOperation<Unit> {
        @NotNull
        private final com.stripe.stripeterminal.external.models.Reader reader;

        public StartSessionOperation(com.stripe.stripeterminal.external.models.Reader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            this.reader = reader;
        }

        @Override
        public void execute() {
            block3: {
                Reader reader;
                block2: {
                    reader = BbposAdapter.this.makeHardwareReader(this.reader);
                    if (reader == null) break block2;
                    Reader reader2 = reader;
                    BbposAdapter bbposAdapter = BbposAdapter.this;
                    Reader hardwareReader = reader2;
                    boolean bl = false;
                    Job job = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)bbposAdapter.dispatcher)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, hardwareReader, bbposAdapter, null){
                        int label;
                        final /* synthetic */ StartSessionOperation this$0;
                        final /* synthetic */ Reader $hardwareReader;
                        final /* synthetic */ BbposAdapter this$1;
                        {
                            this.this$0 = $receiver;
                            this.$hardwareReader = $hardwareReader;
                            this.this$1 = $receiver2;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object var1_1) {
                            var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    this.label = 1;
                                    v0 = StartSessionOperation.access$startSession(this.this$0, this.$hardwareReader, (Continuation)this);
                                    if (v0 == var2_2) {
                                        return var2_2;
                                    }
                                    ** GOTO lbl13
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl13:
                                    // 2 sources

                                    this.label = 2;
                                    v1 = FlowKt.firstOrNull((Flow)FlowKt.catch((Flow)((Flow)v0), (Function3)((Function3)new Function3<FlowCollector<? super Unit>, Throwable, Continuation<? super Unit>, Object>(this.this$0, null){
                                        int label;
                                        /* synthetic */ Object L$0;
                                        final /* synthetic */ StartSessionOperation this$0;
                                        {
                                            this.this$0 = $receiver;
                                            super(3, $completion);
                                        }

                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object object) {
                                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)object);
                                                    Throwable e2 = (Throwable)this.L$0;
                                                    this.this$0.setException(new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Session initialization failed", e2, null, 8, null));
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        @Nullable
                                        public final Object invoke(@NotNull FlowCollector<? super Unit> p1, @NotNull Throwable p2, @Nullable Continuation<? super Unit> p3) {
                                            Function3<FlowCollector<? super Unit>, Throwable, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                                            function3.L$0 = p2;
                                            return function3.invokeSuspend((Object)Unit.INSTANCE);
                                        }
                                    })), (Continuation)((Continuation)this));
                                    if (v1 == var2_2) {
                                        return var2_2;
                                    }
                                    ** GOTO lbl21
                                }
                                case 2: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v1 = $result;
lbl21:
                                    // 2 sources

                                    this.this$0.set(Unit.INSTANCE);
                                    BbposAdapter.access$getConnectionManager$p(this.this$1).endOperation();
                                    this.this$1.update();
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                    reader = job;
                    if (job != null) break block3;
                }
                this.setException(new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Missing hardware.Reader", null, null, 12, null));
                reader = Unit.INSTANCE;
            }
            this.get();
        }

        private final Object startSession(Reader reader, Continuation<? super Flow<Unit>> $completion) {
            return FlowKt.callbackFlow((Function2)((Function2)new Function2<ProducerScope<? super Unit>, Continuation<? super Unit>, Object>(BbposAdapter.this, reader, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ BbposAdapter this$0;
                final /* synthetic */ Reader $reader;
                {
                    this.this$0 = $receiver;
                    this.$reader = $reader;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            ProducerScope $this$callbackFlow = (ProducerScope)this.L$0;
                            Disposable disposable = BbposAdapter.access$getReaderStatusListener$p(this.this$0).getSessionInitializedObservable().subscribe(new Consumer((ProducerScope<? super Unit>)$this$callbackFlow){
                                final /* synthetic */ ProducerScope<Unit> $$this$callbackFlow;
                                {
                                    this.$$this$callbackFlow = $$this$callbackFlow;
                                }

                                public final void accept(@NotNull Unit it) {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    ChannelsKt.trySendBlocking((SendChannel)((SendChannel)this.$$this$callbackFlow), (Object)Unit.INSTANCE);
                                    SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.$$this$callbackFlow), null, (int)1, null);
                                }
                            });
                            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"readerStatusListener.ses\u2026close()\n                }");
                            Disposable successSubscription2 = disposable;
                            Disposable disposable2 = BbposAdapter.access$getReaderStatusListener$p(this.this$0).getSessionExceptionObservable().subscribe(new Consumer((ProducerScope<? super Unit>)$this$callbackFlow){
                                final /* synthetic */ ProducerScope<Unit> $$this$callbackFlow;
                                {
                                    this.$$this$callbackFlow = $$this$callbackFlow;
                                }

                                public final void accept(@NotNull ReaderException it) {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    CoroutineScopeKt.cancel((CoroutineScope)((CoroutineScope)this.$$this$callbackFlow), (CancellationException)ExceptionsKt.CancellationException((String)it.getMessage(), (Throwable)it));
                                }
                            });
                            Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"readerStatusListener.ses\u2026e, it))\n                }");
                            Disposable errorSubscription2 = disposable2;
                            BbposAdapter.access$getConnectionManager$p(this.this$0).startSession(this.$reader);
                            this.this$0.update();
                            this.label = 1;
                            Object object3 = ProduceKt.awaitClose((ProducerScope)$this$callbackFlow, (Function0)((Function0)new Function0<Unit>(successSubscription2, errorSubscription2){
                                final /* synthetic */ Disposable $successSubscription;
                                final /* synthetic */ Disposable $errorSubscription;
                                {
                                    this.$successSubscription = $successSubscription;
                                    this.$errorSubscription = $errorSubscription;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.$successSubscription.dispose();
                                    this.$errorSubscription.dispose();
                                }
                            }), (Continuation)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<ProducerScope<? super Unit>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(@NotNull ProducerScope<? super Unit> p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        public static final /* synthetic */ Object access$startSession(StartSessionOperation $this, Reader reader, Continuation $completion) {
            return $this.startSession(reader, (Continuation<? super Flow<Unit>>)$completion);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00a2\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\f\u0012\u0004\u0012\u0002H\u00010\u0002R\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter$UpdateOperation;", "T", "Lcom/stripe/stripeterminal/internal/common/Adapter$ReaderOperation;", "Lcom/stripe/stripeterminal/internal/common/Adapter;", "(Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter;)V", "onUpdateException", "", "e", "Lcom/stripe/core/hardware/updates/ReaderUpdateException;", "adapter_release"})
    private abstract class UpdateOperation<T>
    extends Adapter.ReaderOperation<T> {
        public final void onUpdateException(@NotNull ReaderUpdateException e2) {
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            BbposAdapter.this.onFailure(TerminalExceptionMaker.Companion.fromReaderUpdateException(e2));
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[DeviceType.values().length];
            try {
                nArray[DeviceType.CHIPPER_1X.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.CHIPPER_2X.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.STRIPE_M2.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.WISECUBE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.WISEPAD_3.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.WISEPAD_3S.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ReaderConfiguration.ReaderType.values().length];
            try {
                nArray[ReaderConfiguration.ReaderType.MAGSTRIPE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReaderConfiguration.ReaderType.ICC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReaderConfiguration.ReaderType.NFC.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReaderConfiguration.ReaderType.MANUAL_ENTRY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

