/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.adapter;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.hardware.usb.UsbDevice;
import com.stripe.core.bbpos.hardware.BbposPaymentCollectionListener;
import com.stripe.core.bbpos.hardware.DeviceListenerRegistry;
import com.stripe.core.bbpos.hardware.api.DeviceControllerWrapper;
import com.stripe.core.hardware.ConnectionType;
import com.stripe.core.hardware.Reader;
import com.stripe.core.hardware.ReaderInfoController;
import com.stripe.core.hardware.reactive.emv.ReactiveConfigurationListener;
import com.stripe.core.hardware.reactive.status.ReactiveReaderStatusListener;
import com.stripe.core.hardware.reactive.updates.ReactiveReaderUpdateListener;
import com.stripe.core.hardware.status.ReaderStatusListener;
import com.stripe.core.hardware.updates.ReaderUpdateController;
import com.stripe.core.readerconnection.ConnectionManager;
import com.stripe.core.readerupdate.UpdateClient;
import com.stripe.core.readerupdate.UpdateInstaller;
import com.stripe.core.readerupdate.UpdateManager;
import com.stripe.core.transaction.Settings;
import com.stripe.core.transaction.SettingsRepository;
import com.stripe.core.transaction.TransactionManager;
import com.stripe.core.transaction.TransactionRepository;
import com.stripe.jvmcore.dagger.Transaction;
import com.stripe.jvmcore.featureflag.FeatureFlagsRepository;
import com.stripe.jvmcore.hardware.emv.DomesticDebitAidsParser;
import com.stripe.jvmcore.hardware.emv.TransactionType;
import com.stripe.jvmcore.hardware.status.DisconnectCause;
import com.stripe.jvmcore.hardware.status.ReaderInfo;
import com.stripe.jvmcore.logging.HealthLogger;
import com.stripe.jvmcore.logging.PendingTimer;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.loggingmodels.Outcome;
import com.stripe.jvmcore.terminal.appinfo.ApplicationInformation;
import com.stripe.jvmcore.terminal.tokenrepositories.SessionTokenRepository;
import com.stripe.proto.model.config.MobileClientConfig;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.connectivity.BluetoothScope;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.connectivity.ConnectivityDomain;
import com.stripe.proto.terminal.terminal.pub.message.config.BluetoothAutoReconnectConfigPb;
import com.stripe.stripeterminal.external.callable.DiscoveryListener;
import com.stripe.stripeterminal.external.models.DeviceType;
import com.stripe.stripeterminal.external.models.DiscoveryConfiguration;
import com.stripe.stripeterminal.external.models.ExpandableLocation;
import com.stripe.stripeterminal.external.models.Location;
import com.stripe.stripeterminal.external.models.LocationStatus;
import com.stripe.stripeterminal.external.models.Reader;
import com.stripe.stripeterminal.external.models.TerminalException;
import com.stripe.stripeterminal.internal.common.Adapter;
import com.stripe.stripeterminal.internal.common.TerminalStatusManager;
import com.stripe.stripeterminal.internal.common.adapter.BbposAdapter;
import com.stripe.stripeterminal.internal.common.adapter.BbposBluetoothAdapter;
import com.stripe.stripeterminal.internal.common.adapter.PaymentCollectionCoordinatorWrapper;
import com.stripe.stripeterminal.internal.common.bluetooth.BluetoothBondStateReceiverManager;
import com.stripe.stripeterminal.internal.common.connectandupdate.ConnectAndUpdateStateMachine;
import com.stripe.stripeterminal.internal.common.makers.DeviceTypeMaker;
import com.stripe.stripeterminal.internal.common.resourcerepository.ProxyResourceRepository;
import com.stripe.stripeterminal.internal.common.storage.BluetoothDeviceNameRepository;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.ExperimentalCoroutinesApi;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.channels.ChannelsKt;
import kotlinx.coroutines.channels.ProduceKt;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001:\u0003cdeB\u0091\u0002\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u0012\u0006\u0010 \u001a\u00020!\u0012\u0006\u0010\"\u001a\u00020#\u0012\u0006\u0010$\u001a\u00020%\u0012\u0006\u0010&\u001a\u00020'\u0012\u0006\u0010(\u001a\u00020)\u0012\u0006\u0010*\u001a\u00020+\u0012\u0006\u0010,\u001a\u00020-\u0012\u0006\u0010.\u001a\u00020/\u0012\b\u00100\u001a\u0004\u0018\u000101\u0012\"\u00102\u001a\u001e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020703j\u0002`8\u0012\u0006\u00109\u001a\u00020:\u0012\u0006\u0010;\u001a\u00020<\u0012\u0006\u0010=\u001a\u00020>\u0012\u0006\u0010?\u001a\u00020@\u00a2\u0006\u0002\u0010AJ\"\u0010F\u001a\u000e\u0012\u0004\u0012\u00020H\u0012\u0004\u0012\u00020I0G2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020H0KH\u0014J\u0014\u0010L\u001a\u00060MR\u00020\u00012\u0006\u0010N\u001a\u00020OH\u0014J\u001c\u0010P\u001a\u00060QR\u00020\u00012\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020UH\u0014J\u0012\u0010V\u001a\u0004\u0018\u00010W2\u0006\u0010N\u001a\u00020OH\u0014J\u0014\u0010X\u001a\u00060YR\u00020\u00012\u0006\u0010N\u001a\u00020OH\u0014J\u0010\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020]H\u0014J\u0010\u0010^\u001a\u00020[2\u0006\u0010_\u001a\u00020`H\u0014J\u0010\u0010a\u001a\u00020[2\u0006\u0010R\u001a\u00020bH\u0014R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u0004\u0018\u000101X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020@X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u00102\u001a\u001e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020703j\u0002`8X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010B\u001a\u0004\u0018\u00010CX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010DR\u0012\u0010E\u001a\u0004\u0018\u00010CX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010DR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006f"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/BbposBluetoothAdapter;", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter;", "updateClient", "Lcom/stripe/core/readerupdate/UpdateClient;", "sessionTokenRepository", "Lcom/stripe/jvmcore/terminal/tokenrepositories/SessionTokenRepository;", "scheduler", "Lio/reactivex/rxjava3/core/Scheduler;", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "connectionManager", "Lcom/stripe/core/readerconnection/ConnectionManager;", "transactionManager", "Lcom/stripe/core/transaction/TransactionManager;", "updateManager", "Lcom/stripe/core/readerupdate/UpdateManager;", "configListener", "Lcom/stripe/core/hardware/reactive/emv/ReactiveConfigurationListener;", "readerStatusListener", "Lcom/stripe/core/hardware/reactive/status/ReactiveReaderStatusListener;", "updateListener", "Lcom/stripe/core/hardware/reactive/updates/ReactiveReaderUpdateListener;", "updateInstaller", "Lcom/stripe/core/readerupdate/UpdateInstaller;", "statusManager", "Lcom/stripe/stripeterminal/internal/common/TerminalStatusManager;", "settingsRepository", "Lcom/stripe/core/transaction/SettingsRepository;", "bluetoothBondStateReceiver", "Lcom/stripe/stripeterminal/internal/common/bluetooth/BluetoothBondStateReceiverManager;", "featureFlagsRepository", "Lcom/stripe/jvmcore/featureflag/FeatureFlagsRepository;", "readerUpdateController", "Lcom/stripe/core/hardware/updates/ReaderUpdateController;", "readerInfoController", "Lcom/stripe/core/hardware/ReaderInfoController;", "applicationInformation", "Lcom/stripe/jvmcore/terminal/appinfo/ApplicationInformation;", "transactionRepository", "Lcom/stripe/core/transaction/TransactionRepository;", "connectAndUpdateStateMachine", "Lcom/stripe/stripeterminal/internal/common/connectandupdate/ConnectAndUpdateStateMachine;", "paymentCollectionWrapper", "Lcom/stripe/stripeterminal/internal/common/adapter/PaymentCollectionCoordinatorWrapper;", "resourceRepository", "Lcom/stripe/stripeterminal/internal/common/resourcerepository/ProxyResourceRepository;", "deviceController", "Lcom/stripe/core/bbpos/hardware/api/DeviceControllerWrapper;", "bluetoothAdapter", "Landroid/bluetooth/BluetoothAdapter;", "connectivityHealthLogger", "Lcom/stripe/jvmcore/logging/HealthLogger;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/connectivity/ConnectivityDomain;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/connectivity/ConnectivityDomain$Builder;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/connectivity/BluetoothScope;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/connectivity/BluetoothScope$Builder;", "Lcom/stripe/stripeterminal/internal/common/log/BluetoothConnectivityHealthLogger;", "deviceListener", "Lcom/stripe/core/bbpos/hardware/BbposPaymentCollectionListener;", "deviceListenerRegistry", "Lcom/stripe/core/bbpos/hardware/DeviceListenerRegistry;", "domesticDebitAidsParser", "Lcom/stripe/jvmcore/hardware/emv/DomesticDebitAidsParser;", "bluetoothDeviceNameRepository", "Lcom/stripe/stripeterminal/internal/common/storage/BluetoothDeviceNameRepository;", "(Lcom/stripe/core/readerupdate/UpdateClient;Lcom/stripe/jvmcore/terminal/tokenrepositories/SessionTokenRepository;Lio/reactivex/rxjava3/core/Scheduler;Lkotlinx/coroutines/CoroutineDispatcher;Lcom/stripe/core/readerconnection/ConnectionManager;Lcom/stripe/core/transaction/TransactionManager;Lcom/stripe/core/readerupdate/UpdateManager;Lcom/stripe/core/hardware/reactive/emv/ReactiveConfigurationListener;Lcom/stripe/core/hardware/reactive/status/ReactiveReaderStatusListener;Lcom/stripe/core/hardware/reactive/updates/ReactiveReaderUpdateListener;Lcom/stripe/core/readerupdate/UpdateInstaller;Lcom/stripe/stripeterminal/internal/common/TerminalStatusManager;Lcom/stripe/core/transaction/SettingsRepository;Lcom/stripe/stripeterminal/internal/common/bluetooth/BluetoothBondStateReceiverManager;Lcom/stripe/jvmcore/featureflag/FeatureFlagsRepository;Lcom/stripe/core/hardware/updates/ReaderUpdateController;Lcom/stripe/core/hardware/ReaderInfoController;Lcom/stripe/jvmcore/terminal/appinfo/ApplicationInformation;Lcom/stripe/core/transaction/TransactionRepository;Lcom/stripe/stripeterminal/internal/common/connectandupdate/ConnectAndUpdateStateMachine;Lcom/stripe/stripeterminal/internal/common/adapter/PaymentCollectionCoordinatorWrapper;Lcom/stripe/stripeterminal/internal/common/resourcerepository/ProxyResourceRepository;Lcom/stripe/core/bbpos/hardware/api/DeviceControllerWrapper;Landroid/bluetooth/BluetoothAdapter;Lcom/stripe/jvmcore/logging/HealthLogger;Lcom/stripe/core/bbpos/hardware/BbposPaymentCollectionListener;Lcom/stripe/core/bbpos/hardware/DeviceListenerRegistry;Lcom/stripe/jvmcore/hardware/emv/DomesticDebitAidsParser;Lcom/stripe/stripeterminal/internal/common/storage/BluetoothDeviceNameRepository;)V", "reconnectionMaxAttempts", "", "Ljava/lang/Integer;", "reconnectionMaxTimeoutInSeconds", "getLocationsForDiscovery", "", "", "Lcom/stripe/stripeterminal/external/models/Location;", "deviceSerials", "", "makeConnectReaderOperation", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter$ConnectReaderOperation;", "reader", "Lcom/stripe/stripeterminal/external/models/Reader;", "makeDiscoverReadersOperation", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter$DiscoverReadersOperation;", "config", "Lcom/stripe/stripeterminal/external/models/DiscoveryConfiguration;", "listener", "Lcom/stripe/stripeterminal/external/callable/DiscoveryListener;", "makeHardwareReader", "Lcom/stripe/core/hardware/Reader$BluetoothReader;", "makeReconnectReaderOperation", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter$ReconnectReaderOperation;", "onDisconnect", "", "disconnectCause", "Lcom/stripe/jvmcore/hardware/status/DisconnectCause;", "onFailure", "e", "Lcom/stripe/stripeterminal/external/models/TerminalException;", "saveReconnectParams", "Lcom/stripe/proto/model/config/MobileClientConfig;", "ConnectBluetoothReaderOperation", "DiscoverBluetoothReadersOperation", "ReconnectBluetoothReaderOperation", "adapter_release"})
@ExperimentalCoroutinesApi
@SourceDebugExtension(value={"SMAP\nBbposBluetoothAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BbposBluetoothAdapter.kt\ncom/stripe/stripeterminal/internal/common/adapter/BbposBluetoothAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,636:1\n1549#2:637\n1620#2,2:638\n1622#2:641\n1238#2,4:644\n1#3:640\n457#4:642\n403#4:643\n*S KotlinDebug\n*F\n+ 1 BbposBluetoothAdapter.kt\ncom/stripe/stripeterminal/internal/common/adapter/BbposBluetoothAdapter\n*L\n225#1:637\n225#1:638,2\n225#1:641\n234#1:644,4\n234#1:642\n234#1:643\n*E\n"})
public class BbposBluetoothAdapter
extends BbposAdapter {
    @NotNull
    private final SessionTokenRepository sessionTokenRepository;
    @NotNull
    private final Scheduler scheduler;
    @NotNull
    private final CoroutineDispatcher dispatcher;
    @NotNull
    private final ConnectionManager connectionManager;
    @NotNull
    private final TransactionManager transactionManager;
    @NotNull
    private final UpdateManager updateManager;
    @NotNull
    private final ReactiveReaderStatusListener readerStatusListener;
    @NotNull
    private final TerminalStatusManager statusManager;
    @NotNull
    private final BluetoothBondStateReceiverManager bluetoothBondStateReceiver;
    @NotNull
    private final FeatureFlagsRepository featureFlagsRepository;
    @NotNull
    private final ApplicationInformation applicationInformation;
    @NotNull
    private final DeviceControllerWrapper deviceController;
    @Nullable
    private final BluetoothAdapter bluetoothAdapter;
    @NotNull
    private final HealthLogger<ConnectivityDomain, ConnectivityDomain.Builder, BluetoothScope, BluetoothScope.Builder> connectivityHealthLogger;
    @NotNull
    private final BluetoothDeviceNameRepository bluetoothDeviceNameRepository;
    @Nullable
    private Integer reconnectionMaxTimeoutInSeconds;
    @Nullable
    private Integer reconnectionMaxAttempts;

    @Inject
    public BbposBluetoothAdapter(@NotNull UpdateClient updateClient, @NotNull SessionTokenRepository sessionTokenRepository, @Transaction @NotNull Scheduler scheduler, @Transaction @NotNull CoroutineDispatcher dispatcher, @NotNull ConnectionManager connectionManager, @NotNull TransactionManager transactionManager, @NotNull UpdateManager updateManager, @NotNull ReactiveConfigurationListener configListener, @NotNull ReactiveReaderStatusListener readerStatusListener, @NotNull ReactiveReaderUpdateListener updateListener, @NotNull UpdateInstaller updateInstaller, @NotNull TerminalStatusManager statusManager, @NotNull SettingsRepository settingsRepository, @NotNull BluetoothBondStateReceiverManager bluetoothBondStateReceiver, @NotNull FeatureFlagsRepository featureFlagsRepository, @NotNull ReaderUpdateController readerUpdateController, @NotNull ReaderInfoController readerInfoController, @NotNull ApplicationInformation applicationInformation, @NotNull TransactionRepository transactionRepository, @NotNull ConnectAndUpdateStateMachine connectAndUpdateStateMachine, @NotNull PaymentCollectionCoordinatorWrapper paymentCollectionWrapper, @NotNull ProxyResourceRepository resourceRepository, @NotNull DeviceControllerWrapper deviceController, @Nullable BluetoothAdapter bluetoothAdapter, @NotNull HealthLogger<ConnectivityDomain, ConnectivityDomain.Builder, BluetoothScope, BluetoothScope.Builder> connectivityHealthLogger, @NotNull BbposPaymentCollectionListener deviceListener, @NotNull DeviceListenerRegistry deviceListenerRegistry, @NotNull DomesticDebitAidsParser domesticDebitAidsParser, @NotNull BluetoothDeviceNameRepository bluetoothDeviceNameRepository) {
        Intrinsics.checkNotNullParameter((Object)updateClient, (String)"updateClient");
        Intrinsics.checkNotNullParameter((Object)sessionTokenRepository, (String)"sessionTokenRepository");
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)connectionManager, (String)"connectionManager");
        Intrinsics.checkNotNullParameter((Object)transactionManager, (String)"transactionManager");
        Intrinsics.checkNotNullParameter((Object)updateManager, (String)"updateManager");
        Intrinsics.checkNotNullParameter((Object)configListener, (String)"configListener");
        Intrinsics.checkNotNullParameter((Object)readerStatusListener, (String)"readerStatusListener");
        Intrinsics.checkNotNullParameter((Object)updateListener, (String)"updateListener");
        Intrinsics.checkNotNullParameter((Object)updateInstaller, (String)"updateInstaller");
        Intrinsics.checkNotNullParameter((Object)statusManager, (String)"statusManager");
        Intrinsics.checkNotNullParameter((Object)settingsRepository, (String)"settingsRepository");
        Intrinsics.checkNotNullParameter((Object)bluetoothBondStateReceiver, (String)"bluetoothBondStateReceiver");
        Intrinsics.checkNotNullParameter((Object)featureFlagsRepository, (String)"featureFlagsRepository");
        Intrinsics.checkNotNullParameter((Object)readerUpdateController, (String)"readerUpdateController");
        Intrinsics.checkNotNullParameter((Object)readerInfoController, (String)"readerInfoController");
        Intrinsics.checkNotNullParameter((Object)applicationInformation, (String)"applicationInformation");
        Intrinsics.checkNotNullParameter((Object)transactionRepository, (String)"transactionRepository");
        Intrinsics.checkNotNullParameter((Object)connectAndUpdateStateMachine, (String)"connectAndUpdateStateMachine");
        Intrinsics.checkNotNullParameter((Object)paymentCollectionWrapper, (String)"paymentCollectionWrapper");
        Intrinsics.checkNotNullParameter((Object)resourceRepository, (String)"resourceRepository");
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        Intrinsics.checkNotNullParameter(connectivityHealthLogger, (String)"connectivityHealthLogger");
        Intrinsics.checkNotNullParameter((Object)deviceListener, (String)"deviceListener");
        Intrinsics.checkNotNullParameter((Object)deviceListenerRegistry, (String)"deviceListenerRegistry");
        Intrinsics.checkNotNullParameter((Object)domesticDebitAidsParser, (String)"domesticDebitAidsParser");
        Intrinsics.checkNotNullParameter((Object)bluetoothDeviceNameRepository, (String)"bluetoothDeviceNameRepository");
        Log log = Log.Companion.getLogger(BbposBluetoothAdapter.class);
        super(updateClient, sessionTokenRepository, scheduler, dispatcher, connectionManager, updateManager, configListener, readerStatusListener, updateListener, updateInstaller, statusManager, settingsRepository, featureFlagsRepository, readerUpdateController, paymentCollectionWrapper, transactionRepository, connectAndUpdateStateMachine, readerInfoController, resourceRepository, deviceListener, deviceListenerRegistry, domesticDebitAidsParser, log);
        this.sessionTokenRepository = sessionTokenRepository;
        this.scheduler = scheduler;
        this.dispatcher = dispatcher;
        this.connectionManager = connectionManager;
        this.transactionManager = transactionManager;
        this.updateManager = updateManager;
        this.readerStatusListener = readerStatusListener;
        this.statusManager = statusManager;
        this.bluetoothBondStateReceiver = bluetoothBondStateReceiver;
        this.featureFlagsRepository = featureFlagsRepository;
        this.applicationInformation = applicationInformation;
        this.deviceController = deviceController;
        this.bluetoothAdapter = bluetoothAdapter;
        this.connectivityHealthLogger = connectivityHealthLogger;
        this.bluetoothDeviceNameRepository = bluetoothDeviceNameRepository;
    }

    @Override
    @NotNull
    protected BbposAdapter.ConnectReaderOperation makeConnectReaderOperation(@NotNull com.stripe.stripeterminal.external.models.Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        return new ConnectBluetoothReaderOperation(reader);
    }

    @Override
    @NotNull
    protected BbposAdapter.DiscoverReadersOperation makeDiscoverReadersOperation(@NotNull DiscoveryConfiguration config, @NotNull DiscoveryListener listener2) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        return new DiscoverBluetoothReadersOperation(config, listener2);
    }

    @Override
    @Nullable
    protected Reader.BluetoothReader makeHardwareReader(@NotNull com.stripe.stripeterminal.external.models.Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        return Reader.BluetoothReader.Companion.fromBluetoothDeviceOrNull(reader.getBluetoothDevice());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onDisconnect(@NotNull DisconnectCause disconnectCause) {
        Intrinsics.checkNotNullParameter((Object)((Object)disconnectCause), (String)"disconnectCause");
        if (!this.featureFlagsRepository.getFeatureFlags().disable_bluetooth_auto_reconnect_android_sdk && this.getRequestReconnection() != null && !(this.getOperationInProgress() instanceof BbposAdapter.ConnectReaderOperation)) {
            BluetoothAdapter bluetoothAdapter = this.bluetoothAdapter;
            boolean bl = bluetoothAdapter != null ? bluetoothAdapter.isEnabled() : false;
            if (bl) {
                super.onDisconnect(disconnectCause);
                this.onFailure(new TerminalException(TerminalException.TerminalErrorCode.BLUETOOTH_RECONNECT_STARTED, "Bluetooth unexpectedly disconnected during operation, reconnecting.", null, null, 12, null));
                Function0<Unit> function0 = this.getRequestReconnection();
                if (function0 == null) return;
                function0.invoke();
                return;
            }
        }
        if (this.getOperationInProgress() instanceof BbposAdapter.ReconnectReaderOperation) {
            this.getLogger().d("onDisconnect: Reconnection is in progress. Ignore.", new Pair[0]);
            return;
        }
        super.onDisconnect(disconnectCause);
        BluetoothAdapter bluetoothAdapter = this.bluetoothAdapter;
        TerminalException exception = (bluetoothAdapter != null ? bluetoothAdapter.isEnabled() : false) ? (WhenMappings.$EnumSwitchMapping$0[disconnectCause.ordinal()] == 1 ? new TerminalException(TerminalException.TerminalErrorCode.READER_CONNECTED_TO_ANOTHER_DEVICE, "Reader is already connected to another device.", null, null, 12, null) : new TerminalException(TerminalException.TerminalErrorCode.BLUETOOTH_DISCONNECTED, "Bluetooth unexpectedly disconnected during operation.", null, null, 12, null)) : new TerminalException(TerminalException.TerminalErrorCode.BLUETOOTH_ERROR, "Bluetooth is disabled on your device, please turn it on.", null, null, 12, null);
        this.onFailure(exception);
        HealthLogger.incrementCounter$default(this.connectivityHealthLogger, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"reason", (Object)exception.getErrorCode().toLogString())), null, onDisconnect.1.INSTANCE, 5, null);
        this.statusManager.unexpectedDisconnect();
    }

    @Override
    protected void onFailure(@NotNull TerminalException e2) {
        Intrinsics.checkNotNullParameter((Object)((Object)e2), (String)"e");
        this.bluetoothBondStateReceiver.stopListening();
        super.onFailure(e2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Map<String, Location> getLocationsForDiscovery(@NotNull List<String> deviceSerials) {
        void $this$mapKeysTo$iv$iv;
        Object object;
        Object object2;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(deviceSerials, (String)"deviceSerials");
        Map serialToNameMap = new LinkedHashMap();
        Iterable $this$map$iv = deviceSerials;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void serialOrDeviceName;
            String string2 = (String)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object = this.bluetoothDeviceNameRepository.getDeviceSerialFromName((String)serialOrDeviceName);
            if (object != null) {
                String string3;
                String it = string3 = object;
                boolean bl2 = false;
                serialToNameMap.put(it, serialOrDeviceName);
                string = string3;
            } else {
                string = serialOrDeviceName;
            }
            object2.add(string);
        }
        List it = (List)destination$iv$iv;
        boolean $i$a$-let-BbposBluetoothAdapter$getLocationsForDiscovery$32 = false;
        Map<String, Location> $this$mapKeys$iv = super.getLocationsForDiscovery(it);
        boolean $i$f$mapKeys = false;
        Map<String, Location> $i$a$-let-BbposBluetoothAdapter$getLocationsForDiscovery$32 = $this$mapKeys$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            object = (Map.Entry)element$iv$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            String serial = (String)object.getKey();
            String string = (String)serialToNameMap.get(serial);
            if (string == null) {
                string = serial;
            }
            Map.Entry bl2 = (Map.Entry)element$iv$iv$iv;
            String string4 = string;
            Object object3 = object2;
            boolean bl3 = false;
            Object v2 = it$iv$iv.getValue();
            object3.put(string4, v2);
        }
        return destination$iv$iv;
    }

    @Override
    protected void saveReconnectParams(@NotNull MobileClientConfig config) {
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        BluetoothAutoReconnectConfigPb bluetoothAutoReconnectConfigPb = config.bluetooth_auto_reconnect_config;
        this.reconnectionMaxAttempts = bluetoothAutoReconnectConfigPb != null ? Integer.valueOf(bluetoothAutoReconnectConfigPb.max_retry_attempts) : null;
        BluetoothAutoReconnectConfigPb bluetoothAutoReconnectConfigPb2 = config.bluetooth_auto_reconnect_config;
        this.reconnectionMaxTimeoutInSeconds = bluetoothAutoReconnectConfigPb2 != null ? Integer.valueOf(bluetoothAutoReconnectConfigPb2.max_timeout_seconds) : null;
    }

    @Override
    @NotNull
    protected BbposAdapter.ReconnectReaderOperation makeReconnectReaderOperation(@NotNull com.stripe.stripeterminal.external.models.Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        return new ReconnectBluetoothReaderOperation(reader);
    }

    public static final /* synthetic */ ReactiveReaderStatusListener access$getReaderStatusListener$p(BbposBluetoothAdapter $this) {
        return $this.readerStatusListener;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\u0004H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0010\u001a\u00020\nH\u0002J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0007H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/BbposBluetoothAdapter$ConnectBluetoothReaderOperation;", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter$ConnectReaderOperation;", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter;", "reader", "Lcom/stripe/stripeterminal/external/models/Reader;", "(Lcom/stripe/stripeterminal/internal/common/adapter/BbposBluetoothAdapter;Lcom/stripe/stripeterminal/external/models/Reader;)V", "device", "Landroid/bluetooth/BluetoothDevice;", "execute", "onConnectDevice", "", "Lcom/stripe/core/hardware/Reader;", "onReportReaderInfo", "info", "Lcom/stripe/jvmcore/hardware/status/ReaderInfo;", "saveDeviceNameSerialMapping", "startConnect", "startConnectWithManualBonding", "bluetoothDevice", "adapter_release"})
    @SourceDebugExtension(value={"SMAP\nBbposBluetoothAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BbposBluetoothAdapter.kt\ncom/stripe/stripeterminal/internal/common/adapter/BbposBluetoothAdapter$ConnectBluetoothReaderOperation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,636:1\n1#2:637\n*E\n"})
    private final class ConnectBluetoothReaderOperation
    extends BbposAdapter.ConnectReaderOperation {
        @NotNull
        private final com.stripe.stripeterminal.external.models.Reader reader;
        @Nullable
        private BluetoothDevice device;

        public ConnectBluetoothReaderOperation(com.stripe.stripeterminal.external.models.Reader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            this.reader = reader;
        }

        @Override
        @NotNull
        public com.stripe.stripeterminal.external.models.Reader execute() throws TerminalException {
            block5: {
                Unit unit;
                Reader.BluetoothReader bluetoothReader = BbposBluetoothAdapter.this.makeHardwareReader(this.reader);
                if (bluetoothReader != null) {
                    Reader.BluetoothReader bluetoothReader2 = bluetoothReader;
                    BbposBluetoothAdapter bbposBluetoothAdapter = BbposBluetoothAdapter.this;
                    Reader.BluetoothReader bluetoothReader3 = bluetoothReader2;
                    boolean bl = false;
                    bbposBluetoothAdapter.connectionManager.startConnect(bluetoothReader3);
                    switch (WhenMappings.$EnumSwitchMapping$0[this.reader.getDeviceType().ordinal()]) {
                        case 1: 
                        case 2: 
                        case 3: {
                            this.startConnectWithManualBonding(bluetoothReader3.getDevice());
                            break;
                        }
                        default: {
                            this.startConnect();
                        }
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit != null) break block5;
                BbposBluetoothAdapter.this.onFailure(new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Connect reader failed unexpectedly", null, null, 12, null));
            }
            return (com.stripe.stripeterminal.external.models.Reader)this.get();
        }

        @Override
        public void onConnectDevice(@NotNull Reader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            if (!(reader instanceof Reader.BluetoothReader)) {
                BbposBluetoothAdapter.this.onFailure(new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Unexpected reader type", null, null, 12, null));
            }
            BbposBluetoothAdapter.this.bluetoothBondStateReceiver.stopListening();
            this.device = ((Reader.BluetoothReader)reader).getDevice();
            BbposBluetoothAdapter.this.connectionManager.startReaderInfo();
            BbposBluetoothAdapter.this.update();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onReportReaderInfo(@NotNull ReaderInfo info) {
            block9: {
                Unit unit;
                block8: {
                    block5: {
                        Object object;
                        DeviceTypeMaker.Companion companion;
                        BbposBluetoothAdapter bbposBluetoothAdapter;
                        block7: {
                            block6: {
                                void it;
                                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                                BluetoothDevice bluetoothDevice = this.device;
                                if (bluetoothDevice == null) break block5;
                                BluetoothDevice bluetoothDevice2 = bluetoothDevice;
                                bbposBluetoothAdapter = BbposBluetoothAdapter.this;
                                BluetoothDevice it2 = bluetoothDevice2;
                                boolean bl = false;
                                companion = DeviceTypeMaker.Companion;
                                object = this.device;
                                if (object == null) break block6;
                                BluetoothDevice bluetoothDevice3 = object;
                                DeviceTypeMaker.Companion companion2 = companion;
                                boolean bl2 = false;
                                String string = Reader.BluetoothReader.Companion.nameFromDevice((BluetoothDevice)it);
                                companion = companion2;
                                object = string;
                                if (string != null) break block7;
                            }
                            if ((object = info.getSerial()) == null) {
                                object = "";
                            }
                        }
                        DefaultConstructorMarker defaultConstructorMarker = null;
                        int n2 = 114670;
                        Location location = null;
                        UsbDevice usbDevice = null;
                        BluetoothDevice bluetoothDevice = this.device;
                        BluetoothDevice bluetoothDevice4 = null;
                        Boolean bl = null;
                        String string = null;
                        String string2 = null;
                        String string3 = null;
                        String string4 = null;
                        String string5 = null;
                        Reader.NetworkStatus networkStatus = null;
                        boolean bl3 = false;
                        ReaderInfo readerInfo = info;
                        String string6 = null;
                        LocationStatus locationStatus = null;
                        ExpandableLocation expandableLocation = null;
                        DeviceType deviceType = companion.fromSerial((String)object);
                        com.stripe.stripeterminal.external.models.Reader reader = new com.stripe.stripeterminal.external.models.Reader(deviceType, expandableLocation, locationStatus, string6, readerInfo, bl3, networkStatus, string5, string4, string3, string2, string, bl, bluetoothDevice4, bluetoothDevice, usbDevice, location, n2, defaultConstructorMarker);
                        Log log = bbposBluetoothAdapter.getLogger();
                        Pair[] pairArray = new Pair[2];
                        pairArray[0] = TuplesKt.to((Object)"reader_software_version", (Object)reader.getSoftwareVersion());
                        Object object2 = reader.getBatteryLevel();
                        if (object2 == null || (object2 = ((Float)object2).toString()) == null) {
                            object2 = "unavailable";
                        }
                        pairArray[1] = TuplesKt.to((Object)"reader_battery_level", (Object)object2);
                        log.i(null, pairArray);
                        TransactionType emvTransactionType = bbposBluetoothAdapter.emvTransactionTypeForDeviceType(reader.getDeviceType());
                        bbposBluetoothAdapter.setSettings(new Settings(emvTransactionType, false));
                        bbposBluetoothAdapter.connectionManager.endOperation();
                        bbposBluetoothAdapter.update();
                        this.saveDeviceNameSerialMapping(reader);
                        this.set(reader);
                        unit = Unit.INSTANCE;
                        break block8;
                    }
                    unit = null;
                }
                if (unit != null) break block9;
                BbposBluetoothAdapter.this.onFailure(new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Connect reader failed unexpectedly", null, null, 12, null));
            }
        }

        private final void startConnect() {
            BbposBluetoothAdapter.this.update();
            BbposBluetoothAdapter.this.sessionTokenRepository.setSessionTokenListener(new SessionTokenRepository.TokenChangeListener(BbposBluetoothAdapter.this){
                final /* synthetic */ BbposBluetoothAdapter this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onSessionTokenChanged(@Nullable String token) {
                    BbposBluetoothAdapter.access$getTransactionManager$p(this.this$0).reset();
                    this.this$0.update();
                }
            });
        }

        private final void startConnectWithManualBonding(BluetoothDevice bluetoothDevice) {
            switch (Reader.BluetoothReader.Companion.bondStateFromDevice(bluetoothDevice)) {
                case 12: {
                    this.startConnect();
                    break;
                }
                case 10: {
                    BbposBluetoothAdapter.this.bluetoothBondStateReceiver.startListening(bluetoothDevice, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

                        public final void invoke() {
                            ConnectBluetoothReaderOperation.access$startConnect((ConnectBluetoothReaderOperation)this.receiver);
                        }
                    }), (Function0<Unit>)((Function0)new Function0<Unit>(BbposBluetoothAdapter.this){
                        final /* synthetic */ BbposBluetoothAdapter this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        public final void invoke() {
                            ReaderStatusListener.handleReaderDisconnect$default(BbposBluetoothAdapter.access$getReaderStatusListener$p(this.this$0), null, 1, null);
                        }
                    }));
                    Reader.BluetoothReader.Companion.createBondWithDevice(bluetoothDevice);
                    break;
                }
                default: {
                    BbposBluetoothAdapter.this.getLogger().d("startConnectWithManualBonding no-op, bluetoothDevice.bondState=" + Reader.BluetoothReader.Companion.bondStateFromDevice(bluetoothDevice), new Pair[0]);
                }
            }
        }

        private final void saveDeviceNameSerialMapping(com.stripe.stripeterminal.external.models.Reader reader) {
            block5: {
                Object object;
                Object object2 = this;
                BbposBluetoothAdapter bbposBluetoothAdapter = BbposBluetoothAdapter.this;
                try {
                    String string;
                    ConnectBluetoothReaderOperation $this$saveDeviceNameSerialMapping_u24lambda_u243 = object2;
                    boolean bl = false;
                    String serial = reader.getSerialNumber();
                    BluetoothDevice bluetoothDevice = reader.getBluetoothDevice();
                    if (bluetoothDevice != null) {
                        BluetoothDevice bluetoothDevice2 = bluetoothDevice;
                        Reader.BluetoothReader.Companion companion = Reader.BluetoothReader.Companion;
                        BluetoothDevice p0 = bluetoothDevice2;
                        boolean bl2 = false;
                        string = companion.nameFromDevice(p0);
                    } else {
                        string = null;
                    }
                    String name = string;
                    CharSequence charSequence = serial;
                    if (!(charSequence == null || charSequence.length() == 0) && !((charSequence = (CharSequence)name) == null || charSequence.length() == 0)) {
                        bbposBluetoothAdapter.bluetoothDeviceNameRepository.saveDeviceSerialMapping(name, serial);
                    }
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                object2 = object;
                bbposBluetoothAdapter = BbposBluetoothAdapter.this;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable == null) break block5;
                Object e2 = object = throwable;
                boolean bl = false;
                bbposBluetoothAdapter.getLogger().w((Throwable)e2, "Failed to save bluetooth reader name <> serial mapping.", new Pair[0]);
            }
        }

        public static final /* synthetic */ void access$startConnect(ConnectBluetoothReaderOperation $this) {
            $this.startConnect();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[DeviceType.values().length];
                try {
                    nArray[DeviceType.STRIPE_M2.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DeviceType.WISEPAD_3.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DeviceType.WISEPAD_3S.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0016\u0010\u000e\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/BbposBluetoothAdapter$DiscoverBluetoothReadersOperation;", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter$DiscoverReadersOperation;", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter;", "config", "Lcom/stripe/stripeterminal/external/models/DiscoveryConfiguration;", "listener", "Lcom/stripe/stripeterminal/external/callable/DiscoveryListener;", "(Lcom/stripe/stripeterminal/internal/common/adapter/BbposBluetoothAdapter;Lcom/stripe/stripeterminal/external/models/DiscoveryConfiguration;Lcom/stripe/stripeterminal/external/callable/DiscoveryListener;)V", "cancel", "", "cancelSilently", "", "execute", "Ljava/lang/Void;", "onUpdateDiscoveredReaders", "readers", "", "Lcom/stripe/core/hardware/Reader;", "adapter_release"})
    @SourceDebugExtension(value={"SMAP\nBbposBluetoothAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BbposBluetoothAdapter.kt\ncom/stripe/stripeterminal/internal/common/adapter/BbposBluetoothAdapter$DiscoverBluetoothReadersOperation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,636:1\n800#2,11:637\n1549#2:648\n1620#2,3:649\n1603#2,9:652\n1855#2:661\n1856#2:663\n1612#2:664\n1603#2,9:665\n1855#2:674\n1856#2:676\n1612#2:677\n1#3:662\n1#3:675\n*S KotlinDebug\n*F\n+ 1 BbposBluetoothAdapter.kt\ncom/stripe/stripeterminal/internal/common/adapter/BbposBluetoothAdapter$DiscoverBluetoothReadersOperation\n*L\n581#1:637,11\n585#1:648\n585#1:649,3\n594#1:652,9\n594#1:661\n594#1:663\n594#1:664\n598#1:665,9\n598#1:674\n598#1:676\n598#1:677\n594#1:662\n598#1:675\n*E\n"})
    private final class DiscoverBluetoothReadersOperation
    extends BbposAdapter.DiscoverReadersOperation {
        @NotNull
        private final DiscoveryConfiguration config;
        @NotNull
        private final DiscoveryListener listener;

        public DiscoverBluetoothReadersOperation(@NotNull DiscoveryConfiguration config, DiscoveryListener listener2) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            this.config = config;
            this.listener = listener2;
        }

        @Override
        @Nullable
        public Void execute() throws TerminalException {
            List list;
            if (Intrinsics.areEqual((Object)BbposBluetoothAdapter.this.getOperationToCancel(), BbposAdapter.DiscoverReadersOperation.class)) {
                BbposBluetoothAdapter.this.setOperationToCancel(null);
                throw new TerminalException(TerminalException.TerminalErrorCode.CANCELED, "DiscoverReaders was canceled by the user", null, null, 12, null);
            }
            BluetoothAdapter bluetoothAdapter = BbposBluetoothAdapter.this.bluetoothAdapter;
            if (!(bluetoothAdapter != null ? bluetoothAdapter.isEnabled() : false)) {
                throw new TerminalException(TerminalException.TerminalErrorCode.BLUETOOTH_ERROR, "Bluetooth is disabled on your device, please turn it on.", null, null, 12, null);
            }
            Object object = BbposBluetoothAdapter.this;
            List $this$execute_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$execute_u24lambda_u240.add(Reflection.getOrCreateKotlinClass(Reader.BluetoothReader.Chipper2xReader.class));
            $this$execute_u24lambda_u240.add(Reflection.getOrCreateKotlinClass(Reader.BluetoothReader.StripeM2Reader.class));
            $this$execute_u24lambda_u240.add(Reflection.getOrCreateKotlinClass(Reader.BluetoothReader.Wisepad3Reader.class));
            if (((BbposBluetoothAdapter)object).applicationInformation.getShopifyReadersEnabled()) {
                $this$execute_u24lambda_u240.add(Reflection.getOrCreateKotlinClass(Reader.BluetoothReader.Chipper1xReader.class));
                $this$execute_u24lambda_u240.add(Reflection.getOrCreateKotlinClass(Reader.BluetoothReader.WisecubeReader.class));
            }
            List bluetoothReaders = CollectionsKt.build((List)list);
            BbposBluetoothAdapter.this.connectionManager.startDiscovery(bluetoothReaders, ConnectionType.BLUETOOTH);
            BbposBluetoothAdapter.this.update();
            if (this.config.getTimeout() != 0) {
                object = new Timer();
                long l2 = (long)this.config.getTimeout() * 1000L;
                BbposBluetoothAdapter bbposBluetoothAdapter = BbposBluetoothAdapter.this;
                TimerTask timerTask = new TimerTask(this, bbposBluetoothAdapter){
                    final /* synthetic */ DiscoverBluetoothReadersOperation this$0;
                    final /* synthetic */ BbposBluetoothAdapter this$1$inlined;
                    {
                        this.this$0 = discoverBluetoothReadersOperation;
                        this.this$1$inlined = bbposBluetoothAdapter;
                    }

                    public void run() {
                        TimerTask $this$execute_u24lambda_u241 = this;
                        boolean bl = false;
                        if (!this.this$0.getFuture().isDone()) {
                            this.this$1$inlined.onFailure(new TerminalException(TerminalException.TerminalErrorCode.BLUETOOTH_SCAN_TIMED_OUT, "Bluetooth scan timed out", null, null, 12, null));
                        }
                    }
                };
                ((Timer)object).schedule(timerTask, l2);
            }
            return (Void)this.get();
        }

        @Override
        public void cancel(boolean cancelSilently) {
            BbposBluetoothAdapter.this.transactionManager.endTransaction();
            BbposBluetoothAdapter.this.connectionManager.endOperation();
            BbposBluetoothAdapter.this.updateManager.endOperation();
            BbposBluetoothAdapter.this.update();
            if (cancelSilently) {
                this.set(null);
            } else {
                this.setException(new TerminalException(TerminalException.TerminalErrorCode.CANCELED, "DiscoverReaders was canceled by the user", null, null, 12, null));
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onUpdateDiscoveredReaders(@NotNull Set<? extends Reader> readers) {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter(readers, (String)"readers");
            Iterable $this$filterIsInstance$iv = readers;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof Reader.BluetoothReader)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List bluetoothReaders = (List)destination$iv$iv;
            BbposBluetoothAdapter.this.scheduler.scheduleDirect(() -> DiscoverBluetoothReadersOperation.onUpdateDiscoveredReaders$lambda$6(bluetoothReaders, BbposBluetoothAdapter.this, this));
        }

        /*
         * WARNING - void declaration
         */
        private static final void onUpdateDiscoveredReaders$lambda$6(List $bluetoothReaders, BbposBluetoothAdapter this$0, DiscoverBluetoothReadersOperation this$1) {
            List returnList2;
            Object object;
            Object object2;
            Iterable $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$bluetoothReaders, (String)"$bluetoothReaders");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
            Iterable $this$map$iv = $bluetoothReaders;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void reader;
                Reader.BluetoothReader bluetoothReader = (Reader.BluetoothReader)item$iv$iv;
                object2 = destination$iv$iv;
                boolean bl = false;
                object2.add(reader.getDevice());
            }
            List bluetoothDevices = (List)destination$iv$iv;
            if (bluetoothDevices.isEmpty()) {
                object = CollectionsKt.emptyList();
            } else {
                Object knownLocations;
                try {
                    boolean bl;
                    Object element$iv$iv;
                    Object element$iv$iv$iv;
                    Iterable $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv;
                    $this$mapTo$iv$iv = bluetoothDevices;
                    object2 = this$0;
                    boolean $i$f$mapNotNull = false;
                    void $i$f$mapTo2 = $this$mapNotNull$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        String it$iv$iv;
                        element$iv$iv = element$iv$iv$iv = iterator.next();
                        bl = false;
                        BluetoothDevice it = (BluetoothDevice)element$iv$iv;
                        boolean bl2 = false;
                        if (Reader.BluetoothReader.Companion.nameFromDevice(it) == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv2.add(it$iv$iv);
                    }
                    knownLocations = ((BbposBluetoothAdapter)object2).getLocationsForDiscovery((List)destination$iv$iv2);
                    $this$mapNotNull$iv = bluetoothDevices;
                    $i$f$mapNotNull = false;
                    $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
                    destination$iv$iv2 = new ArrayList();
                    $i$f$mapNotNullTo = false;
                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        com.stripe.stripeterminal.external.models.Reader reader;
                        element$iv$iv = element$iv$iv$iv = iterator.next();
                        bl = false;
                        BluetoothDevice bluetoothDevice = (BluetoothDevice)element$iv$iv;
                        boolean bl4 = false;
                        if (Reader.BluetoothReader.Companion.nameFromDevice(bluetoothDevice) != null) {
                            String it;
                            boolean bl5 = false;
                            Location location = (Location)knownLocations.get(it);
                            LocationStatus locationStatus = location == null ? LocationStatus.NOT_SET : LocationStatus.SET;
                            reader = new com.stripe.stripeterminal.external.models.Reader(DeviceTypeMaker.Companion.fromSerial(it), null, locationStatus, null, null, false, null, null, null, null, null, null, null, null, bluetoothDevice, null, location, 49146, null);
                        } else {
                            reader = null;
                        }
                        if (reader == null) continue;
                        com.stripe.stripeterminal.external.models.Reader it$iv$iv = reader;
                        boolean bl6 = false;
                        destination$iv$iv2.add(it$iv$iv);
                    }
                    knownLocations = (List)destination$iv$iv2;
                }
                catch (TerminalException e2) {
                    this$0.onFailure(e2);
                    return;
                }
                catch (Exception e3) {
                    this$0.onUnexpectedFailure(e3);
                    return;
                }
                object = returnList2 = knownLocations;
            }
            if (!this$1.getFuture().isDone() && !this$1.getFuture().isCancelled()) {
                try {
                    this$1.listener.onUpdateDiscoveredReaders(returnList2);
                }
                catch (Exception e4) {
                    this$0.onUnexpectedFailure(e4);
                }
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/BbposBluetoothAdapter$ReconnectBluetoothReaderOperation;", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter$ReconnectReaderOperation;", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter;", "reader", "Lcom/stripe/stripeterminal/external/models/Reader;", "(Lcom/stripe/stripeterminal/internal/common/adapter/BbposBluetoothAdapter;Lcom/stripe/stripeterminal/external/models/Reader;)V", "device", "Landroid/bluetooth/BluetoothDevice;", "healthLoggerTags", "", "", "pendingTimer", "Lcom/stripe/jvmcore/logging/PendingTimer;", "reconnectJob", "Lkotlinx/coroutines/Job;", "cancel", "", "execute", "failReconnection", "onConnectDevice", "Lcom/stripe/core/hardware/Reader;", "onReportReaderInfo", "info", "Lcom/stripe/jvmcore/hardware/status/ReaderInfo;", "adapter_release"})
    @SourceDebugExtension(value={"SMAP\nBbposBluetoothAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BbposBluetoothAdapter.kt\ncom/stripe/stripeterminal/internal/common/adapter/BbposBluetoothAdapter$ReconnectBluetoothReaderOperation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,636:1\n1#2:637\n*E\n"})
    private final class ReconnectBluetoothReaderOperation
    extends BbposAdapter.ReconnectReaderOperation {
        @NotNull
        private final com.stripe.stripeterminal.external.models.Reader reader;
        @Nullable
        private Job reconnectJob;
        @Nullable
        private BluetoothDevice device;
        @Nullable
        private PendingTimer pendingTimer;
        @NotNull
        private Map<String, String> healthLoggerTags;

        public ReconnectBluetoothReaderOperation(com.stripe.stripeterminal.external.models.Reader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            this.reader = reader;
            this.healthLoggerTags = new LinkedHashMap();
        }

        @Override
        public void onConnectDevice(@NotNull Reader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            this.device = ((Reader.BluetoothReader)reader).getDevice();
            BbposBluetoothAdapter.this.connectionManager.startReaderInfo();
            BbposBluetoothAdapter.this.update();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onReportReaderInfo(@NotNull ReaderInfo info) {
            block8: {
                Unit unit;
                block7: {
                    block4: {
                        Object object;
                        DeviceTypeMaker.Companion companion;
                        BbposBluetoothAdapter bbposBluetoothAdapter;
                        block6: {
                            block5: {
                                void it;
                                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                                BluetoothDevice bluetoothDevice = this.device;
                                if (bluetoothDevice == null) break block4;
                                BluetoothDevice bluetoothDevice2 = bluetoothDevice;
                                bbposBluetoothAdapter = BbposBluetoothAdapter.this;
                                BluetoothDevice it2 = bluetoothDevice2;
                                boolean bl = false;
                                companion = DeviceTypeMaker.Companion;
                                object = this.device;
                                if (object == null) break block5;
                                BluetoothDevice bluetoothDevice3 = object;
                                DeviceTypeMaker.Companion companion2 = companion;
                                boolean bl2 = false;
                                String string = Reader.BluetoothReader.Companion.nameFromDevice((BluetoothDevice)it);
                                companion = companion2;
                                object = string;
                                if (string != null) break block6;
                            }
                            if ((object = info.getSerial()) == null) {
                                object = "";
                            }
                        }
                        DefaultConstructorMarker defaultConstructorMarker = null;
                        int n2 = 114670;
                        Location location = null;
                        UsbDevice usbDevice = null;
                        BluetoothDevice bluetoothDevice = this.device;
                        BluetoothDevice bluetoothDevice4 = null;
                        Boolean bl = null;
                        String string = null;
                        String string2 = null;
                        String string3 = null;
                        String string4 = null;
                        String string5 = null;
                        Reader.NetworkStatus networkStatus = null;
                        boolean bl3 = false;
                        ReaderInfo readerInfo = info;
                        String string6 = null;
                        LocationStatus locationStatus = null;
                        ExpandableLocation expandableLocation = null;
                        DeviceType deviceType = companion.fromSerial((String)object);
                        com.stripe.stripeterminal.external.models.Reader reader = new com.stripe.stripeterminal.external.models.Reader(deviceType, expandableLocation, locationStatus, string6, readerInfo, bl3, networkStatus, string5, string4, string3, string2, string, bl, bluetoothDevice4, bluetoothDevice, usbDevice, location, n2, defaultConstructorMarker);
                        bbposBluetoothAdapter.getLogger().i("reader reconnected:" + reader.getSerialNumber(), new Pair[0]);
                        bbposBluetoothAdapter.statusManager.reconnected(reader);
                        HealthLogger.endTimer$default(bbposBluetoothAdapter.connectivityHealthLogger, this.pendingTimer, Outcome.Ok.INSTANCE, this.healthLoggerTags, null, 8, null);
                        bbposBluetoothAdapter.connectionManager.endOperation();
                        bbposBluetoothAdapter.update();
                        this.set(reader);
                        bbposBluetoothAdapter.setOperationInProgress(bbposBluetoothAdapter.new Adapter.NullOperation());
                        unit = Unit.INSTANCE;
                        break block7;
                    }
                    unit = null;
                }
                if (unit != null) break block8;
                BbposBluetoothAdapter.this.onFailure(new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Connect reader failed unexpectedly", null, null, 12, null));
            }
        }

        @Override
        public void cancel() {
            block1: {
                this.healthLoggerTags.put("reconnection_outcome", "cancelled");
                Job job = this.reconnectJob;
                if (job == null) break block1;
                Job it = job;
                boolean bl = false;
                if (it.isActive()) {
                    Job.DefaultImpls.cancel$default((Job)it, null, (int)1, null);
                    this.failReconnection();
                }
            }
        }

        private final void failReconnection() {
            BbposBluetoothAdapter.this.deviceController.disconnectBt();
            BbposBluetoothAdapter.this.onFailure(new TerminalException(TerminalException.TerminalErrorCode.BLUETOOTH_DISCONNECTED, "Bluetooth reconnection failed.", null, null, 12, null));
            BbposBluetoothAdapter.this.statusManager.reconnectFailed(this.reader);
            HealthLogger.endTimer$default(BbposBluetoothAdapter.this.connectivityHealthLogger, this.pendingTimer, Outcome.GenericError.INSTANCE, this.healthLoggerTags, null, 8, null);
        }

        @Override
        @NotNull
        public com.stripe.stripeterminal.external.models.Reader execute() {
            block2: {
                int it;
                this.pendingTimer = HealthLogger.startTimer$default(BbposBluetoothAdapter.this.connectivityHealthLogger, null, execute.1.INSTANCE, 1, null);
                Integer n2 = BbposBluetoothAdapter.this.reconnectionMaxTimeoutInSeconds;
                if (n2 != null) {
                    it = ((Number)n2).intValue();
                    boolean bl = false;
                    this.healthLoggerTags.put("maxTimeoutInSeconds", String.valueOf(it));
                }
                Integer n3 = BbposBluetoothAdapter.this.reconnectionMaxAttempts;
                if (n3 != null) {
                    it = ((Number)n3).intValue();
                    boolean bl = false;
                    this.healthLoggerTags.put("maxAttempts", String.valueOf(it));
                }
                Reader.BluetoothReader bluetoothReader = BbposBluetoothAdapter.this.makeHardwareReader(this.reader);
                if (bluetoothReader == null) break block2;
                Reader.BluetoothReader bluetoothReader2 = bluetoothReader;
                BbposBluetoothAdapter bbposBluetoothAdapter = BbposBluetoothAdapter.this;
                Reader.BluetoothReader btReader = bluetoothReader2;
                boolean bl = false;
                this.reconnectJob = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)bbposBluetoothAdapter.dispatcher)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(bbposBluetoothAdapter, this, btReader, null){
                    int label;
                    final /* synthetic */ BbposBluetoothAdapter this$0;
                    final /* synthetic */ ReconnectBluetoothReaderOperation this$1;
                    final /* synthetic */ Reader.BluetoothReader $btReader;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        this.$btReader = $btReader;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                v0 = BbposBluetoothAdapter.access$getReconnectionMaxTimeoutInSeconds$p(this.this$0);
                                this.label = 1;
                                v1 = TimeoutKt.withTimeoutOrNull((long)(v0 != null ? (long)(v0 * 1000) : 30000L), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this.this$0, this.$btReader, this.this$1, null){
                                    int label;
                                    final /* synthetic */ BbposBluetoothAdapter this$0;
                                    final /* synthetic */ Reader.BluetoothReader $btReader;
                                    final /* synthetic */ ReconnectBluetoothReaderOperation this$1;
                                    {
                                        this.this$0 = $receiver;
                                        this.$btReader = $btReader;
                                        this.this$1 = $receiver2;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                this.label = 1;
                                                Object object3 = FlowKt.first((Flow)FlowKt.callbackFlow((Function2)((Function2)new Function2<ProducerScope<? super Boolean>, Continuation<? super Unit>, Object>(this.this$0, this.$btReader, this.this$1, null){
                                                    Object L$1;
                                                    Object L$2;
                                                    Object L$3;
                                                    int label;
                                                    private /* synthetic */ Object L$0;
                                                    final /* synthetic */ BbposBluetoothAdapter this$0;
                                                    final /* synthetic */ Reader.BluetoothReader $btReader;
                                                    final /* synthetic */ ReconnectBluetoothReaderOperation this$1;
                                                    {
                                                        this.this$0 = $receiver;
                                                        this.$btReader = $btReader;
                                                        this.this$1 = $receiver2;
                                                        super(2, $completion);
                                                    }

                                                    /*
                                                     * Unable to fully structure code
                                                     */
                                                    @Nullable
                                                    public final Object invokeSuspend(@NotNull Object var1_1) {
                                                        var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                        switch (this.label) {
                                                            case 0: {
                                                                ResultKt.throwOnFailure((Object)var1_1);
                                                                $this$callbackFlow = (ProducerScope)this.L$0;
                                                                reconnectAttempts = new Ref.IntRef();
                                                                v0 = BbposBluetoothAdapter.access$getReaderStatusListener$p(this.this$0).getReaderConnectObservable().subscribe(new Consumer((ProducerScope<? super Boolean>)$this$callbackFlow){
                                                                    final /* synthetic */ ProducerScope<Boolean> $$this$callbackFlow;
                                                                    {
                                                                        this.$$this$callbackFlow = $$this$callbackFlow;
                                                                    }

                                                                    public final void accept(@NotNull Reader it) {
                                                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                                                        ChannelsKt.trySendBlocking((SendChannel)((SendChannel)this.$$this$callbackFlow), (Object)true);
                                                                        SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.$$this$callbackFlow), null, (int)1, null);
                                                                    }
                                                                });
                                                                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"readerStatusListener.rea\u2026                        }");
                                                                connectedSubscription = v0;
                                                                v1 = BbposBluetoothAdapter.access$getReaderStatusListener$p(this.this$0).getReaderDisconnectObservable().subscribe(new Consumer(this.this$0, reconnectAttempts, (ProducerScope<? super Boolean>)$this$callbackFlow, this.$btReader){
                                                                    final /* synthetic */ BbposBluetoothAdapter this$0;
                                                                    final /* synthetic */ Ref.IntRef $reconnectAttempts;
                                                                    final /* synthetic */ ProducerScope<Boolean> $$this$callbackFlow;
                                                                    final /* synthetic */ Reader.BluetoothReader $btReader;
                                                                    {
                                                                        this.this$0 = $receiver;
                                                                        this.$reconnectAttempts = $reconnectAttempts;
                                                                        this.$$this$callbackFlow = $$this$callbackFlow;
                                                                        this.$btReader = $btReader;
                                                                    }

                                                                    public final void accept(@NotNull DisconnectCause it) {
                                                                        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                                                                        if (it.equals((Object)((Object)DisconnectCause.COMM_LINK_UNINITIALIZED))) {
                                                                            return;
                                                                        }
                                                                        BbposBluetoothAdapter.access$getLogger(this.this$0).d("Reconnect attempt failed. End connecting.", new Pair[0]);
                                                                        BbposBluetoothAdapter.access$getConnectionManager$p(this.this$0).endOperation();
                                                                        this.this$0.update();
                                                                        Integer n2 = BbposBluetoothAdapter.access$getReconnectionMaxAttempts$p(this.this$0);
                                                                        if (this.$reconnectAttempts.element > (n2 != null ? n2 : 4)) {
                                                                            ChannelsKt.trySendBlocking((SendChannel)((SendChannel)this.$$this$callbackFlow), (Object)false);
                                                                            SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.$$this$callbackFlow), null, (int)1, null);
                                                                        } else {
                                                                            BbposBluetoothAdapter.access$getLogger(this.this$0).d("Reconnect re-started, calling bbpos SDK", new Pair[0]);
                                                                            BbposBluetoothAdapter.access$getConnectionManager$p(this.this$0).startConnect(this.$btReader);
                                                                            this.this$0.update();
                                                                            int n3 = this.$reconnectAttempts.element;
                                                                            this.$reconnectAttempts.element = n3 + 1;
                                                                        }
                                                                    }
                                                                });
                                                                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"@ExperimentalCoroutinesA\u2026      }\n        }\n    }\n}");
                                                                disconnectedSubscription = v1;
                                                                BbposBluetoothAdapter.access$getLogger(this.this$0).d("Reconnect started, calling bbpos SDK", new Pair[0]);
                                                                if (this.$btReader instanceof Reader.BluetoothReader.Chipper2xReader) {
                                                                    this.L$0 = $this$callbackFlow;
                                                                    this.L$1 = reconnectAttempts;
                                                                    this.L$2 = connectedSubscription;
                                                                    this.L$3 = disconnectedSubscription;
                                                                    this.label = 1;
                                                                    v2 = DelayKt.delay((long)1500L, (Continuation)((Continuation)this));
                                                                    if (v2 == var7_2) {
                                                                        return var7_2;
                                                                    }
                                                                }
                                                                ** GOTO lbl31
                                                            }
                                                            case 1: {
                                                                disconnectedSubscription = (Disposable)this.L$3;
                                                                connectedSubscription = (Disposable)this.L$2;
                                                                reconnectAttempts = (Ref.IntRef)this.L$1;
                                                                $this$callbackFlow = (ProducerScope)this.L$0;
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                v2 = $result;
lbl31:
                                                                // 2 sources

                                                                BbposBluetoothAdapter.access$getConnectionManager$p(this.this$0).startConnect(this.$btReader);
                                                                this.this$0.update();
                                                                var6_7 = reconnectAttempts.element;
                                                                reconnectAttempts.element = var6_7 + 1;
                                                                this.L$0 = null;
                                                                this.L$1 = null;
                                                                this.L$2 = null;
                                                                this.L$3 = null;
                                                                this.label = 2;
                                                                v3 = ProduceKt.awaitClose((ProducerScope)$this$callbackFlow, (Function0)((Function0)new Function0<Unit>(connectedSubscription, disconnectedSubscription, this.this$1, reconnectAttempts){
                                                                    final /* synthetic */ Disposable $connectedSubscription;
                                                                    final /* synthetic */ Disposable $disconnectedSubscription;
                                                                    final /* synthetic */ ReconnectBluetoothReaderOperation this$0;
                                                                    final /* synthetic */ Ref.IntRef $reconnectAttempts;
                                                                    {
                                                                        this.$connectedSubscription = $connectedSubscription;
                                                                        this.$disconnectedSubscription = $disconnectedSubscription;
                                                                        this.this$0 = $receiver;
                                                                        this.$reconnectAttempts = $reconnectAttempts;
                                                                        super(0);
                                                                    }

                                                                    public final void invoke() {
                                                                        this.$connectedSubscription.dispose();
                                                                        this.$disconnectedSubscription.dispose();
                                                                        ReconnectBluetoothReaderOperation.access$getHealthLoggerTags$p(this.this$0).put("reconnectionAttempts", String.valueOf(this.$reconnectAttempts.element));
                                                                    }
                                                                }), (Continuation)((Continuation)this));
                                                                if (v3 == var7_2) {
                                                                    return var7_2;
                                                                }
                                                                ** GOTO lbl47
                                                            }
                                                            case 2: {
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                v3 = $result;
lbl47:
                                                                // 2 sources

                                                                return Unit.INSTANCE;
                                                            }
                                                        }
                                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                    }

                                                    @NotNull
                                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                        Function2<ProducerScope<? super Boolean>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                                        function2.L$0 = value;
                                                        return (Continuation)function2;
                                                    }

                                                    @Nullable
                                                    public final Object invoke(@NotNull ProducerScope<? super Boolean> p1, @Nullable Continuation<? super Unit> p2) {
                                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                    }
                                                })), (Continuation)((Continuation)this));
                                                if (object3 != object2) return object3;
                                                return object2;
                                            }
                                            case 1: {
                                                void $result;
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object3 = $result;
                                                return object3;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (v1 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl14
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl14:
                                // 2 sources

                                if ((reconnectResult = (Boolean)v1) == null) {
                                    BbposBluetoothAdapter.access$getLogger(this.this$0).d("Reconnect timed out", new Pair[0]);
                                    ReconnectBluetoothReaderOperation.access$getHealthLoggerTags$p(this.this$1).put("reconnection_outcome", "hit_timeout");
                                    ReconnectBluetoothReaderOperation.access$failReconnection(this.this$1);
                                } else if (reconnectResult.booleanValue()) {
                                    BbposBluetoothAdapter.access$getLogger(this.this$0).d("Reconnect succeeded", new Pair[0]);
                                    ReconnectBluetoothReaderOperation.access$getHealthLoggerTags$p(this.this$1).put("reconnection_outcome", "reconnected");
                                } else {
                                    BbposBluetoothAdapter.access$getLogger(this.this$0).d("Reconnect exceeded max attempts", new Pair[0]);
                                    ReconnectBluetoothReaderOperation.access$getHealthLoggerTags$p(this.this$1).put("reconnection_outcome", "hit_max_retries");
                                    ReconnectBluetoothReaderOperation.access$failReconnection(this.this$1);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
            return (com.stripe.stripeterminal.external.models.Reader)this.get();
        }

        public static final /* synthetic */ Map access$getHealthLoggerTags$p(ReconnectBluetoothReaderOperation $this) {
            return $this.healthLoggerTags;
        }

        public static final /* synthetic */ void access$failReconnection(ReconnectBluetoothReaderOperation $this) {
            $this.failReconnection();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DisconnectCause.values().length];
            try {
                nArray[DisconnectCause.CONNECTED_TO_ANOTHER_DEVICE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

