/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.adapter;

import android.hardware.usb.UsbDevice;
import com.stripe.core.bbpos.hardware.BbposPaymentCollectionListener;
import com.stripe.core.bbpos.hardware.DeviceListenerRegistry;
import com.stripe.core.bbpos.hardware.api.DeviceControllerWrapper;
import com.stripe.core.hardware.ConnectionType;
import com.stripe.core.hardware.Optional;
import com.stripe.core.hardware.Reader;
import com.stripe.core.hardware.ReaderInfoController;
import com.stripe.core.hardware.reactive.emv.ReactiveConfigurationListener;
import com.stripe.core.hardware.reactive.status.ReactiveReaderStatusListener;
import com.stripe.core.hardware.reactive.updates.ReactiveReaderUpdateListener;
import com.stripe.core.hardware.updates.ReaderUpdateController;
import com.stripe.core.readerconnection.ConnectionManager;
import com.stripe.core.readerupdate.UpdateClient;
import com.stripe.core.readerupdate.UpdateInstaller;
import com.stripe.core.readerupdate.UpdateManager;
import com.stripe.core.transaction.Settings;
import com.stripe.core.transaction.SettingsRepository;
import com.stripe.core.transaction.TransactionManager;
import com.stripe.core.transaction.TransactionRepository;
import com.stripe.jvmcore.dagger.Transaction;
import com.stripe.jvmcore.featureflag.FeatureFlagsRepository;
import com.stripe.jvmcore.hardware.emv.DomesticDebitAidsParser;
import com.stripe.jvmcore.hardware.emv.TransactionType;
import com.stripe.jvmcore.hardware.status.DisconnectCause;
import com.stripe.jvmcore.hardware.status.ReaderInfo;
import com.stripe.jvmcore.logging.HealthLogger;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.terminal.appinfo.ApplicationInformation;
import com.stripe.jvmcore.terminal.tokenrepositories.SessionTokenRepository;
import com.stripe.proto.model.config.MobileClientConfig;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.connectivity.ConnectivityDomain;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.connectivity.UsbScope;
import com.stripe.proto.terminal.terminal.pub.message.config.UsbAutoReconnectConfigPb;
import com.stripe.stripeterminal.external.callable.DiscoveryListener;
import com.stripe.stripeterminal.external.models.DeviceType;
import com.stripe.stripeterminal.external.models.DiscoveryConfiguration;
import com.stripe.stripeterminal.external.models.LocationStatus;
import com.stripe.stripeterminal.external.models.TerminalException;
import com.stripe.stripeterminal.internal.common.Adapter;
import com.stripe.stripeterminal.internal.common.TerminalStatusManager;
import com.stripe.stripeterminal.internal.common.adapter.BbposAdapter;
import com.stripe.stripeterminal.internal.common.adapter.BbposUsbAdapter;
import com.stripe.stripeterminal.internal.common.adapter.BbposUsbAdapter$DiscoverUsbReadersOperation$onUpdateDiscoveredReaders$1$invokeSuspend$lambda$4$;
import com.stripe.stripeterminal.internal.common.adapter.PaymentCollectionCoordinatorWrapper;
import com.stripe.stripeterminal.internal.common.adapter.connection.UsbReaderReconnector;
import com.stripe.stripeterminal.internal.common.connectandupdate.ConnectAndUpdateStateMachine;
import com.stripe.stripeterminal.internal.common.makers.DeviceTypeMaker;
import com.stripe.stripeterminal.internal.common.resourcerepository.ProxyResourceRepository;
import com.stripe.stripeterminal.internal.common.usb.UsbPermissionReceiverManager;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CancellationException;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.SafeContinuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.NonCancellable;
import kotlinx.coroutines.channels.ChannelsKt;
import kotlinx.coroutines.channels.ProduceKt;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0090\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 Y2\u00020\u0001:\u0004YZ[\\B\u00ff\u0001\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u0012\u0006\u0010 \u001a\u00020!\u0012\u0006\u0010\"\u001a\u00020#\u0012\u0006\u0010$\u001a\u00020%\u0012\u0006\u0010&\u001a\u00020'\u0012\u0006\u0010(\u001a\u00020)\u0012\u0006\u0010*\u001a\u00020+\u0012\u0006\u0010,\u001a\u00020-\u0012\u0006\u0010.\u001a\u00020/\u0012\u0006\u00100\u001a\u000201\u0012\u0006\u00102\u001a\u000203\u0012\u0006\u00104\u001a\u000205\u0012\"\u00106\u001a\u001e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020;07j\u0002`<\u00a2\u0006\u0002\u0010=J\u0014\u0010E\u001a\u00060FR\u00020\u00012\u0006\u0010G\u001a\u00020HH\u0014J\u001c\u0010I\u001a\u00060JR\u00020\u00012\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NH\u0014J\u0012\u0010O\u001a\u0004\u0018\u00010P2\u0006\u0010G\u001a\u00020HH\u0014J\u0014\u0010Q\u001a\u00060RR\u00020\u00012\u0006\u0010G\u001a\u00020HH\u0014J\u0010\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020VH\u0014J\u0010\u0010W\u001a\u00020T2\u0006\u0010K\u001a\u00020XH\u0014R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010>\u001a\u0004\u0018\u00010?X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010@R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u00106\u001a\u001e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020;07j\u0002`<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010A\u001a\u0004\u0018\u00010BX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010CR\u0012\u0010D\u001a\u0004\u0018\u00010BX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010CR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006]"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/BbposUsbAdapter;", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter;", "updateClient", "Lcom/stripe/core/readerupdate/UpdateClient;", "sessionTokenRepository", "Lcom/stripe/jvmcore/terminal/tokenrepositories/SessionTokenRepository;", "scheduler", "Lio/reactivex/rxjava3/core/Scheduler;", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "connectionManager", "Lcom/stripe/core/readerconnection/ConnectionManager;", "transactionManager", "Lcom/stripe/core/transaction/TransactionManager;", "updateManager", "Lcom/stripe/core/readerupdate/UpdateManager;", "configListener", "Lcom/stripe/core/hardware/reactive/emv/ReactiveConfigurationListener;", "readerStatusListener", "Lcom/stripe/core/hardware/reactive/status/ReactiveReaderStatusListener;", "updateListener", "Lcom/stripe/core/hardware/reactive/updates/ReactiveReaderUpdateListener;", "updateInstaller", "Lcom/stripe/core/readerupdate/UpdateInstaller;", "statusManager", "Lcom/stripe/stripeterminal/internal/common/TerminalStatusManager;", "settingsRepository", "Lcom/stripe/core/transaction/SettingsRepository;", "deviceController", "Lcom/stripe/core/bbpos/hardware/api/DeviceControllerWrapper;", "usbPermissionReceiver", "Lcom/stripe/stripeterminal/internal/common/usb/UsbPermissionReceiverManager;", "featureFlagsRepository", "Lcom/stripe/jvmcore/featureflag/FeatureFlagsRepository;", "readerUpdateController", "Lcom/stripe/core/hardware/updates/ReaderUpdateController;", "readerInfoController", "Lcom/stripe/core/hardware/ReaderInfoController;", "applicationInformation", "Lcom/stripe/jvmcore/terminal/appinfo/ApplicationInformation;", "transactionRepository", "Lcom/stripe/core/transaction/TransactionRepository;", "connectAndUpdateStateMachine", "Lcom/stripe/stripeterminal/internal/common/connectandupdate/ConnectAndUpdateStateMachine;", "paymentCollectionWrapper", "Lcom/stripe/stripeterminal/internal/common/adapter/PaymentCollectionCoordinatorWrapper;", "resourceRepository", "Lcom/stripe/stripeterminal/internal/common/resourcerepository/ProxyResourceRepository;", "deviceListener", "Lcom/stripe/core/bbpos/hardware/BbposPaymentCollectionListener;", "deviceListenerRegistry", "Lcom/stripe/core/bbpos/hardware/DeviceListenerRegistry;", "domesticDebitAidsParser", "Lcom/stripe/jvmcore/hardware/emv/DomesticDebitAidsParser;", "connectivityHealthLogger", "Lcom/stripe/jvmcore/logging/HealthLogger;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/connectivity/ConnectivityDomain;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/connectivity/ConnectivityDomain$Builder;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/connectivity/UsbScope;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/connectivity/UsbScope$Builder;", "Lcom/stripe/stripeterminal/internal/common/log/UsbConnectivityHealthLogger;", "(Lcom/stripe/core/readerupdate/UpdateClient;Lcom/stripe/jvmcore/terminal/tokenrepositories/SessionTokenRepository;Lio/reactivex/rxjava3/core/Scheduler;Lkotlinx/coroutines/CoroutineDispatcher;Lcom/stripe/core/readerconnection/ConnectionManager;Lcom/stripe/core/transaction/TransactionManager;Lcom/stripe/core/readerupdate/UpdateManager;Lcom/stripe/core/hardware/reactive/emv/ReactiveConfigurationListener;Lcom/stripe/core/hardware/reactive/status/ReactiveReaderStatusListener;Lcom/stripe/core/hardware/reactive/updates/ReactiveReaderUpdateListener;Lcom/stripe/core/readerupdate/UpdateInstaller;Lcom/stripe/stripeterminal/internal/common/TerminalStatusManager;Lcom/stripe/core/transaction/SettingsRepository;Lcom/stripe/core/bbpos/hardware/api/DeviceControllerWrapper;Lcom/stripe/stripeterminal/internal/common/usb/UsbPermissionReceiverManager;Lcom/stripe/jvmcore/featureflag/FeatureFlagsRepository;Lcom/stripe/core/hardware/updates/ReaderUpdateController;Lcom/stripe/core/hardware/ReaderInfoController;Lcom/stripe/jvmcore/terminal/appinfo/ApplicationInformation;Lcom/stripe/core/transaction/TransactionRepository;Lcom/stripe/stripeterminal/internal/common/connectandupdate/ConnectAndUpdateStateMachine;Lcom/stripe/stripeterminal/internal/common/adapter/PaymentCollectionCoordinatorWrapper;Lcom/stripe/stripeterminal/internal/common/resourcerepository/ProxyResourceRepository;Lcom/stripe/core/bbpos/hardware/BbposPaymentCollectionListener;Lcom/stripe/core/bbpos/hardware/DeviceListenerRegistry;Lcom/stripe/jvmcore/hardware/emv/DomesticDebitAidsParser;Lcom/stripe/jvmcore/logging/HealthLogger;)V", "attemptDelayMillis", "", "Ljava/lang/Long;", "reconnectionMaxAttempts", "", "Ljava/lang/Integer;", "reconnectionMaxTimeoutInSeconds", "makeConnectReaderOperation", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter$ConnectReaderOperation;", "reader", "Lcom/stripe/stripeterminal/external/models/Reader;", "makeDiscoverReadersOperation", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter$DiscoverReadersOperation;", "config", "Lcom/stripe/stripeterminal/external/models/DiscoveryConfiguration;", "listener", "Lcom/stripe/stripeterminal/external/callable/DiscoveryListener;", "makeHardwareReader", "Lcom/stripe/core/hardware/Reader$UsbReader;", "makeReconnectReaderOperation", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter$ReconnectReaderOperation;", "onDisconnect", "", "disconnectCause", "Lcom/stripe/jvmcore/hardware/status/DisconnectCause;", "saveReconnectParams", "Lcom/stripe/proto/model/config/MobileClientConfig;", "Companion", "ConnectUsbReaderOperation", "DiscoverUsbReadersOperation", "ReconnectUsbReaderOperation", "adapter_release"})
public final class BbposUsbAdapter
extends BbposAdapter {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final SessionTokenRepository sessionTokenRepository;
    @NotNull
    private final Scheduler scheduler;
    @NotNull
    private final CoroutineDispatcher dispatcher;
    @NotNull
    private final ConnectionManager connectionManager;
    @NotNull
    private final TransactionManager transactionManager;
    @NotNull
    private final UpdateManager updateManager;
    @NotNull
    private final ReactiveReaderStatusListener readerStatusListener;
    @NotNull
    private final TerminalStatusManager statusManager;
    @NotNull
    private final DeviceControllerWrapper deviceController;
    @NotNull
    private final UsbPermissionReceiverManager usbPermissionReceiver;
    @NotNull
    private final FeatureFlagsRepository featureFlagsRepository;
    @NotNull
    private final ApplicationInformation applicationInformation;
    @NotNull
    private final HealthLogger<ConnectivityDomain, ConnectivityDomain.Builder, UsbScope, UsbScope.Builder> connectivityHealthLogger;
    @Nullable
    private Integer reconnectionMaxTimeoutInSeconds;
    @Nullable
    private Integer reconnectionMaxAttempts;
    @Nullable
    private Long attemptDelayMillis;
    @NotNull
    private static final List<DeviceType> UNSUPPORTED_USB_DEVICE_TYPE = CollectionsKt.listOf((Object)DeviceType.CHIPPER_1X);

    @Inject
    public BbposUsbAdapter(@NotNull UpdateClient updateClient, @NotNull SessionTokenRepository sessionTokenRepository, @Transaction @NotNull Scheduler scheduler, @Transaction @NotNull CoroutineDispatcher dispatcher, @NotNull ConnectionManager connectionManager, @NotNull TransactionManager transactionManager, @NotNull UpdateManager updateManager, @NotNull ReactiveConfigurationListener configListener, @NotNull ReactiveReaderStatusListener readerStatusListener, @NotNull ReactiveReaderUpdateListener updateListener, @NotNull UpdateInstaller updateInstaller, @NotNull TerminalStatusManager statusManager, @NotNull SettingsRepository settingsRepository, @NotNull DeviceControllerWrapper deviceController, @NotNull UsbPermissionReceiverManager usbPermissionReceiver, @NotNull FeatureFlagsRepository featureFlagsRepository, @NotNull ReaderUpdateController readerUpdateController, @NotNull ReaderInfoController readerInfoController, @NotNull ApplicationInformation applicationInformation, @NotNull TransactionRepository transactionRepository, @NotNull ConnectAndUpdateStateMachine connectAndUpdateStateMachine, @NotNull PaymentCollectionCoordinatorWrapper paymentCollectionWrapper, @NotNull ProxyResourceRepository resourceRepository, @NotNull BbposPaymentCollectionListener deviceListener, @NotNull DeviceListenerRegistry deviceListenerRegistry, @NotNull DomesticDebitAidsParser domesticDebitAidsParser, @NotNull HealthLogger<ConnectivityDomain, ConnectivityDomain.Builder, UsbScope, UsbScope.Builder> connectivityHealthLogger) {
        Intrinsics.checkNotNullParameter((Object)updateClient, (String)"updateClient");
        Intrinsics.checkNotNullParameter((Object)sessionTokenRepository, (String)"sessionTokenRepository");
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)connectionManager, (String)"connectionManager");
        Intrinsics.checkNotNullParameter((Object)transactionManager, (String)"transactionManager");
        Intrinsics.checkNotNullParameter((Object)updateManager, (String)"updateManager");
        Intrinsics.checkNotNullParameter((Object)configListener, (String)"configListener");
        Intrinsics.checkNotNullParameter((Object)readerStatusListener, (String)"readerStatusListener");
        Intrinsics.checkNotNullParameter((Object)updateListener, (String)"updateListener");
        Intrinsics.checkNotNullParameter((Object)updateInstaller, (String)"updateInstaller");
        Intrinsics.checkNotNullParameter((Object)statusManager, (String)"statusManager");
        Intrinsics.checkNotNullParameter((Object)settingsRepository, (String)"settingsRepository");
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        Intrinsics.checkNotNullParameter((Object)usbPermissionReceiver, (String)"usbPermissionReceiver");
        Intrinsics.checkNotNullParameter((Object)featureFlagsRepository, (String)"featureFlagsRepository");
        Intrinsics.checkNotNullParameter((Object)readerUpdateController, (String)"readerUpdateController");
        Intrinsics.checkNotNullParameter((Object)readerInfoController, (String)"readerInfoController");
        Intrinsics.checkNotNullParameter((Object)applicationInformation, (String)"applicationInformation");
        Intrinsics.checkNotNullParameter((Object)transactionRepository, (String)"transactionRepository");
        Intrinsics.checkNotNullParameter((Object)connectAndUpdateStateMachine, (String)"connectAndUpdateStateMachine");
        Intrinsics.checkNotNullParameter((Object)paymentCollectionWrapper, (String)"paymentCollectionWrapper");
        Intrinsics.checkNotNullParameter((Object)resourceRepository, (String)"resourceRepository");
        Intrinsics.checkNotNullParameter((Object)deviceListener, (String)"deviceListener");
        Intrinsics.checkNotNullParameter((Object)deviceListenerRegistry, (String)"deviceListenerRegistry");
        Intrinsics.checkNotNullParameter((Object)domesticDebitAidsParser, (String)"domesticDebitAidsParser");
        Intrinsics.checkNotNullParameter(connectivityHealthLogger, (String)"connectivityHealthLogger");
        super(updateClient, sessionTokenRepository, scheduler, dispatcher, connectionManager, updateManager, configListener, readerStatusListener, updateListener, updateInstaller, statusManager, settingsRepository, featureFlagsRepository, readerUpdateController, paymentCollectionWrapper, transactionRepository, connectAndUpdateStateMachine, readerInfoController, resourceRepository, deviceListener, deviceListenerRegistry, domesticDebitAidsParser, Log.Companion.getLogger(BbposUsbAdapter.class));
        this.sessionTokenRepository = sessionTokenRepository;
        this.scheduler = scheduler;
        this.dispatcher = dispatcher;
        this.connectionManager = connectionManager;
        this.transactionManager = transactionManager;
        this.updateManager = updateManager;
        this.readerStatusListener = readerStatusListener;
        this.statusManager = statusManager;
        this.deviceController = deviceController;
        this.usbPermissionReceiver = usbPermissionReceiver;
        this.featureFlagsRepository = featureFlagsRepository;
        this.applicationInformation = applicationInformation;
        this.connectivityHealthLogger = connectivityHealthLogger;
    }

    @Override
    @NotNull
    protected BbposAdapter.ConnectReaderOperation makeConnectReaderOperation(@NotNull com.stripe.stripeterminal.external.models.Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        return new ConnectUsbReaderOperation(reader);
    }

    @Override
    @NotNull
    protected BbposAdapter.DiscoverReadersOperation makeDiscoverReadersOperation(@NotNull DiscoveryConfiguration config, @NotNull DiscoveryListener listener2) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        return new DiscoverUsbReadersOperation(config, listener2);
    }

    @Override
    @Nullable
    protected Reader.UsbReader makeHardwareReader(@NotNull com.stripe.stripeterminal.external.models.Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        return Reader.UsbReader.Companion.fromUsbDevice(reader.getUsbDevice());
    }

    @Override
    protected void saveReconnectParams(@NotNull MobileClientConfig config) {
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        UsbAutoReconnectConfigPb usbAutoReconnectConfigPb = config.usb_auto_reconnect_config;
        this.reconnectionMaxAttempts = usbAutoReconnectConfigPb != null ? Integer.valueOf(usbAutoReconnectConfigPb.max_retry_attempts) : null;
        UsbAutoReconnectConfigPb usbAutoReconnectConfigPb2 = config.usb_auto_reconnect_config;
        this.reconnectionMaxTimeoutInSeconds = usbAutoReconnectConfigPb2 != null ? Integer.valueOf(usbAutoReconnectConfigPb2.max_timeout_seconds) : null;
        UsbAutoReconnectConfigPb usbAutoReconnectConfigPb3 = config.usb_auto_reconnect_config;
        this.attemptDelayMillis = usbAutoReconnectConfigPb3 != null ? Long.valueOf(usbAutoReconnectConfigPb3.attempt_delay_millis) : null;
    }

    @Override
    @NotNull
    protected BbposAdapter.ReconnectReaderOperation makeReconnectReaderOperation(@NotNull com.stripe.stripeterminal.external.models.Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        return new ReconnectUsbReaderOperation(reader);
    }

    @Override
    protected void onDisconnect(@NotNull DisconnectCause disconnectCause) {
        Intrinsics.checkNotNullParameter((Object)((Object)disconnectCause), (String)"disconnectCause");
        if (this.getOperationInProgress() instanceof BbposAdapter.DiscoverReadersOperation && disconnectCause == DisconnectCause.CONNECTED_TO_ANOTHER_DEVICE) {
            this.getLogger().d("onDisconnect: Discovery is in progress. Ignore.", new Pair[0]);
        } else if (!this.featureFlagsRepository.getFeatureFlags().disable_bluetooth_auto_reconnect_android_sdk && this.getRequestReconnection() != null && !(this.getOperationInProgress() instanceof BbposAdapter.ConnectReaderOperation)) {
            super.onDisconnect(disconnectCause);
            this.onFailure(new TerminalException(TerminalException.TerminalErrorCode.USB_RECONNECT_STARTED, "USB unexpectedly disconnected during operation, reconnecting.", null, null, 12, null));
            Function0<Unit> function0 = this.getRequestReconnection();
            if (function0 != null) {
                function0.invoke();
            }
        } else if (this.getOperationInProgress() instanceof BbposAdapter.ReconnectReaderOperation) {
            this.getLogger().d("onDisconnect: Reconnection is in progress. Ignore.", new Pair[0]);
        } else {
            TerminalException terminalException;
            super.onDisconnect(disconnectCause);
            switch (WhenMappings.$EnumSwitchMapping$0[disconnectCause.ordinal()]) {
                case 1: {
                    terminalException = new TerminalException(TerminalException.TerminalErrorCode.READER_CONNECTED_TO_ANOTHER_DEVICE, "Reader is already connected to another device.", null, null, 12, null);
                    break;
                }
                case 2: {
                    terminalException = new TerminalException(TerminalException.TerminalErrorCode.USB_PERMISSION_DENIED, "You must grant Terminal SDK permission to connect to USB reader.", null, null, 12, null);
                    break;
                }
                case 3: {
                    terminalException = new TerminalException(TerminalException.TerminalErrorCode.USB_DISCONNECTED, "USB not supported by device hardware.", null, null, 12, null);
                    break;
                }
                default: {
                    terminalException = new TerminalException(TerminalException.TerminalErrorCode.USB_DISCONNECTED, "USB unexpectedly disconnected during operation.", null, null, 12, null);
                }
            }
            TerminalException exception = terminalException;
            this.onFailure(exception);
            HealthLogger.incrementCounter$default(this.connectivityHealthLogger, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"reason", (Object)exception.getErrorCode().toLogString())), null, onDisconnect.1.INSTANCE, 5, null);
            this.statusManager.unexpectedDisconnect();
        }
    }

    public static final /* synthetic */ void access$setOperationInProgress(BbposUsbAdapter $this, Adapter.ReaderOperation readerOperation) {
        $this.setOperationInProgress(readerOperation);
    }

    public static final /* synthetic */ List access$getUNSUPPORTED_USB_DEVICE_TYPE$cp() {
        return UNSUPPORTED_USB_DEVICE_TYPE;
    }

    public static final /* synthetic */ UsbPermissionReceiverManager access$getUsbPermissionReceiver$p(BbposUsbAdapter $this) {
        return $this.usbPermissionReceiver;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/BbposUsbAdapter$Companion;", "", "()V", "UNSUPPORTED_USB_DEVICE_TYPE", "", "Lcom/stripe/stripeterminal/external/models/DeviceType;", "adapter_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\u0004H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/BbposUsbAdapter$ConnectUsbReaderOperation;", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter$ConnectReaderOperation;", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter;", "reader", "Lcom/stripe/stripeterminal/external/models/Reader;", "(Lcom/stripe/stripeterminal/internal/common/adapter/BbposUsbAdapter;Lcom/stripe/stripeterminal/external/models/Reader;)V", "device", "Landroid/hardware/usb/UsbDevice;", "execute", "onConnectDevice", "", "Lcom/stripe/core/hardware/Reader;", "onReportReaderInfo", "info", "Lcom/stripe/jvmcore/hardware/status/ReaderInfo;", "adapter_release"})
    private final class ConnectUsbReaderOperation
    extends BbposAdapter.ConnectReaderOperation {
        @NotNull
        private final com.stripe.stripeterminal.external.models.Reader reader;
        @Nullable
        private UsbDevice device;

        public ConnectUsbReaderOperation(com.stripe.stripeterminal.external.models.Reader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            this.reader = reader;
        }

        @Override
        @NotNull
        public com.stripe.stripeterminal.external.models.Reader execute() throws TerminalException {
            block2: {
                Unit unit;
                Object object;
                Reader.UsbReader usbReader = BbposUsbAdapter.this.makeHardwareReader(this.reader);
                if (usbReader != null) {
                    object = usbReader;
                    BbposUsbAdapter bbposUsbAdapter = BbposUsbAdapter.this;
                    Reader.UsbReader usbReader2 = object;
                    boolean bl = false;
                    this.device = this.reader.getUsbDevice();
                    bbposUsbAdapter.connectionManager.startConnect(usbReader2);
                    bbposUsbAdapter.update();
                    bbposUsbAdapter.sessionTokenRepository.setSessionTokenListener(new SessionTokenRepository.TokenChangeListener(bbposUsbAdapter){
                        final /* synthetic */ BbposUsbAdapter this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        public void onSessionTokenChanged(@Nullable String token) {
                            BbposUsbAdapter.access$getTransactionManager$p(this.this$0).reset();
                            this.this$0.update();
                        }
                    });
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit != null) break block2;
                ConnectUsbReaderOperation connectUsbReaderOperation = this;
                object = BbposUsbAdapter.this;
                ConnectUsbReaderOperation $this$execute_u24lambda_u241 = connectUsbReaderOperation;
                boolean bl = false;
                ((BbposAdapter)object).onFailure(new TerminalException(TerminalException.TerminalErrorCode.MISSING_REQUIRED_PARAMETER, "Connect reader requires usbDevice", null, null, 12, null));
            }
            return (com.stripe.stripeterminal.external.models.Reader)this.get();
        }

        @Override
        public void onConnectDevice(@NotNull Reader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            if (!(reader instanceof Reader.UsbReader)) {
                BbposUsbAdapter.this.onFailure(new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Unexpected reader type: " + reader.getClass().getSimpleName(), null, null, 12, null));
            }
            BbposUsbAdapter.this.connectionManager.startReaderInfo();
            BbposUsbAdapter.this.update();
        }

        @Override
        public void onReportReaderInfo(@NotNull ReaderInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            String string = info.getSerial();
            if (string == null) {
                string = "";
            }
            com.stripe.stripeterminal.external.models.Reader reader = new com.stripe.stripeterminal.external.models.Reader(DeviceTypeMaker.Companion.fromSerial(string), null, null, null, null, info, false, null, this.device, 222, null);
            Log log = BbposUsbAdapter.this.getLogger();
            Pair[] pairArray = new Pair[2];
            pairArray[0] = TuplesKt.to((Object)"reader_software_version", (Object)reader.getSoftwareVersion());
            Object object = reader.getBatteryLevel();
            if (object == null || (object = ((Float)object).toString()) == null) {
                object = "unavailable";
            }
            pairArray[1] = TuplesKt.to((Object)"reader_battery_level", (Object)object);
            log.i(null, pairArray);
            TransactionType emvTransactionType = BbposUsbAdapter.this.emvTransactionTypeForDeviceType(reader.getDeviceType());
            BbposUsbAdapter.this.setSettings(new Settings(emvTransactionType, false));
            BbposUsbAdapter.this.connectionManager.endOperation();
            BbposUsbAdapter.this.update();
            this.set(reader);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0019\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J!\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00162\u0006\u0010\u0013\u001a\u00020\u0012H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0016H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u000eH\u0002J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J+\u0010\u001c\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001e0\u001d0\u00162\u0006\u0010\u0013\u001a\u00020\u0012H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J'\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d2\u0006\u0010 \u001a\u00020\u0012H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010!\u001a\u00020\u0010J\u0016\u0010\"\u001a\u00020\u000e2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006&"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/BbposUsbAdapter$DiscoverUsbReadersOperation;", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter$DiscoverReadersOperation;", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter;", "config", "Lcom/stripe/stripeterminal/external/models/DiscoveryConfiguration;", "listener", "Lcom/stripe/stripeterminal/external/callable/DiscoveryListener;", "(Lcom/stripe/stripeterminal/internal/common/adapter/BbposUsbAdapter;Lcom/stripe/stripeterminal/external/models/DiscoveryConfiguration;Lcom/stripe/stripeterminal/external/callable/DiscoveryListener;)V", "discoveredProductNames", "", "", "discoveryJob", "Lkotlinx/coroutines/Job;", "cancel", "", "cancelSilently", "", "checkUsbPermission", "Landroid/hardware/usb/UsbDevice;", "usbDevice", "(Landroid/hardware/usb/UsbDevice;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "connect", "Lkotlinx/coroutines/flow/Flow;", "disconnect", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "disconnectUnsafe", "execute", "Ljava/lang/Void;", "getDeviceInfo", "Lkotlin/Pair;", "Lcom/stripe/jvmcore/hardware/status/ReaderInfo;", "getDeviceName", "device", "isCancelled", "onUpdateDiscoveredReaders", "readers", "", "Lcom/stripe/core/hardware/Reader;", "adapter_release"})
    @SourceDebugExtension(value={"SMAP\nBbposUsbAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BbposUsbAdapter.kt\ncom/stripe/stripeterminal/internal/common/adapter/BbposUsbAdapter$DiscoverUsbReadersOperation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,607:1\n800#2,11:608\n1603#2,9:619\n1855#2:628\n1856#2:630\n1612#2:631\n1603#2,9:632\n1855#2:641\n1856#2:643\n1612#2:644\n1#3:629\n1#3:642\n*S KotlinDebug\n*F\n+ 1 BbposUsbAdapter.kt\ncom/stripe/stripeterminal/internal/common/adapter/BbposUsbAdapter$DiscoverUsbReadersOperation\n*L\n431#1:608,11\n431#1:619,9\n431#1:628\n431#1:630\n431#1:631\n432#1:632,9\n432#1:641\n432#1:643\n432#1:644\n431#1:629\n432#1:642\n*E\n"})
    private final class DiscoverUsbReadersOperation
    extends BbposAdapter.DiscoverReadersOperation {
        @NotNull
        private final DiscoveryConfiguration config;
        @NotNull
        private final DiscoveryListener listener;
        @NotNull
        private List<String> discoveredProductNames;
        @Nullable
        private Job discoveryJob;

        public DiscoverUsbReadersOperation(@NotNull DiscoveryConfiguration config, DiscoveryListener listener2) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            this.config = config;
            this.listener = listener2;
            this.discoveredProductNames = CollectionsKt.emptyList();
        }

        @Override
        @Nullable
        public Void execute() throws TerminalException {
            List list;
            if (Intrinsics.areEqual((Object)BbposUsbAdapter.this.getOperationToCancel(), BbposAdapter.DiscoverReadersOperation.class)) {
                BbposUsbAdapter.this.setOperationToCancel(null);
                throw new TerminalException(TerminalException.TerminalErrorCode.CANCELED, "DiscoverReaders was canceled by the user", null, null, 12, null);
            }
            Object object = BbposUsbAdapter.this;
            List $this$execute_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$execute_u24lambda_u240.add(Reflection.getOrCreateKotlinClass(Reader.UsbReader.Chipper2xReader.class));
            $this$execute_u24lambda_u240.add(Reflection.getOrCreateKotlinClass(Reader.UsbReader.StripeM2Reader.class));
            $this$execute_u24lambda_u240.add(Reflection.getOrCreateKotlinClass(Reader.UsbReader.Wisepad3Reader.class));
            if (((BbposUsbAdapter)object).applicationInformation.getWisepad3SReadersEnabled()) {
                $this$execute_u24lambda_u240.add(Reflection.getOrCreateKotlinClass(Reader.UsbReader.Wisepad3SReader.class));
            }
            if (((BbposUsbAdapter)object).applicationInformation.getShopifyReadersEnabled()) {
                $this$execute_u24lambda_u240.add(Reflection.getOrCreateKotlinClass(Reader.UsbReader.WisecubeReader.class));
            }
            List usbReaders = CollectionsKt.build((List)list);
            BbposUsbAdapter.this.connectionManager.startDiscovery(usbReaders, ConnectionType.USB);
            BbposUsbAdapter.this.update();
            if (this.config.getTimeout() != 0) {
                object = new Timer();
                long l2 = (long)this.config.getTimeout() * 1000L;
                BbposUsbAdapter bbposUsbAdapter = BbposUsbAdapter.this;
                TimerTask timerTask = new TimerTask(this, bbposUsbAdapter){
                    final /* synthetic */ DiscoverUsbReadersOperation this$0;
                    final /* synthetic */ BbposUsbAdapter this$1$inlined;
                    {
                        this.this$0 = discoverUsbReadersOperation;
                        this.this$1$inlined = bbposUsbAdapter;
                    }

                    public void run() {
                        TimerTask $this$execute_u24lambda_u241 = this;
                        boolean bl = false;
                        if (!this.this$0.getFuture().isDone()) {
                            this.this$1$inlined.onFailure(new TerminalException(TerminalException.TerminalErrorCode.USB_DISCOVERY_TIMED_OUT, "Usb discovery timed out", null, null, 12, null));
                        }
                    }
                };
                ((Timer)object).schedule(timerTask, l2);
            }
            return (Void)this.get();
        }

        @Override
        public void cancel(boolean cancelSilently) {
            Job job = this.discoveryJob;
            boolean bl = job != null ? job.isActive() : false;
            if (bl) {
                BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(BbposUsbAdapter.this, this, null){
                    int label;
                    final /* synthetic */ BbposUsbAdapter this$0;
                    final /* synthetic */ DiscoverUsbReadersOperation this$1;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        block5: {
                            var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    BbposUsbAdapter.access$getLogger(this.this$0).d("discoveryJob.cancelAndJoin()", new Pair[0]);
                                    v0 = DiscoverUsbReadersOperation.access$getDiscoveryJob$p(this.this$1);
                                    if (v0 == null) break;
                                    this.label = 1;
                                    v1 = JobKt.cancelAndJoin((Job)v0, (Continuation)((Continuation)this));
                                    if (v1 == var2_2) {
                                        return var2_2;
                                    }
                                    ** GOTO lbl16
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v1 = $result;
lbl16:
                                    // 2 sources

                                    v2 = Unit.INSTANCE;
                                    break block5;
                                }
                            }
                            v2 = null;
                        }
                        return v2;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)1, null);
            }
            BbposUsbAdapter.this.transactionManager.endTransaction();
            BbposUsbAdapter.this.connectionManager.endOperation();
            BbposUsbAdapter.this.updateManager.endOperation();
            BbposUsbAdapter.this.update();
            if (cancelSilently) {
                this.set(null);
            } else {
                this.setException(new TerminalException(TerminalException.TerminalErrorCode.CANCELED, "DiscoverReaders was canceled by the user", null, null, 12, null));
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onUpdateDiscoveredReaders(@NotNull Set<? extends Reader> readers) {
            List usbDevices;
            block7: {
                block6: {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNullTo$iv$iv2;
                    Iterable $this$filterIsInstanceTo$iv$iv;
                    Intrinsics.checkNotNullParameter(readers, (String)"readers");
                    Iterable $this$filterIsInstance$iv = readers;
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Iterable<UsbDevice> destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof Reader.UsbReader)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
                    boolean $i$f$mapNotNull = false;
                    $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        UsbDevice it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        Reader.UsbReader it = (Reader.UsbReader)element$iv$iv;
                        boolean bl2 = false;
                        if (it.getDevice() == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    usbDevices = (List)destination$iv$iv;
                    Iterable $this$mapNotNull$iv2 = usbDevices;
                    boolean $i$f$mapNotNull2 = false;
                    destination$iv$iv = $this$mapNotNull$iv2;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$mapNotNullTo2 = false;
                    void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach2 = false;
                    Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
                    while (iterator2.hasNext()) {
                        String it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl = false;
                        UsbDevice it = (UsbDevice)element$iv$iv;
                        boolean bl4 = false;
                        if (it.getProductName() == null) continue;
                        boolean bl5 = false;
                        destination$iv$iv2.add(it$iv$iv);
                    }
                    List usbDeviceNames = (List)destination$iv$iv2;
                    if (Intrinsics.areEqual(this.discoveredProductNames, (Object)usbDeviceNames)) break block6;
                    Job job = this.discoveryJob;
                    boolean bl = job != null ? !job.isCompleted() : false;
                    if (!bl) break block7;
                }
                return;
            }
            CoroutineScope defaultScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()));
            this.discoveryJob = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)BbposUsbAdapter.this.dispatcher)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((List<? extends UsbDevice>)usbDevices, this, defaultScope, BbposUsbAdapter.this, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ List<UsbDevice> $usbDevices;
                final /* synthetic */ DiscoverUsbReadersOperation this$0;
                final /* synthetic */ CoroutineScope $defaultScope;
                final /* synthetic */ BbposUsbAdapter this$1;
                {
                    this.$usbDevices = $usbDevices;
                    this.this$0 = $receiver;
                    this.$defaultScope = $defaultScope;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var28_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$launch = (CoroutineScope)this.L$0;
                            if (!this.$usbDevices.isEmpty()) ** GOTO lbl9
                            v0 = CollectionsKt.emptyList();
                            ** GOTO lbl108
lbl9:
                            // 1 sources

                            var4_4 = $this$launch;
                            var5_5 = this.$usbDevices;
                            var6_6 = this.this$0;
                            var7_7 = this.this$1;
                            $this$invokeSuspend_u24lambda_u244 = var4_4;
                            $i$a$-run-BbposUsbAdapter$DiscoverUsbReadersOperation$onUpdateDiscoveredReaders$1$returnList$1 = false;
                            $this$map$iv = FlowKt.onEach((Flow)FlowKt.cancellable((Flow)FlowKt.asFlow((Iterable)var5_5)), (Function2)((Function2)new Function2<UsbDevice, Continuation<? super Unit>, Object>(var6_6, $this$invokeSuspend_u24lambda_u244, null){
                                int label;
                                final /* synthetic */ DiscoverUsbReadersOperation this$0;
                                final /* synthetic */ CoroutineScope $this_run;
                                {
                                    this.this$0 = $receiver;
                                    this.$this_run = $receiver2;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            if (this.this$0.isCancelled()) {
                                                CoroutineScopeKt.cancel$default((CoroutineScope)this.$this_run, null, (int)1, null);
                                            }
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull UsbDevice p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }));
                            $i$f$map = false;
                            $this$unsafeTransform$iv$iv = $this$map$iv;
                            $i$f$unsafeTransform = false;
                            $i$f$unsafeFlow = false;
                            $this$mapNotNull$iv = (Flow)new Flow<UsbDevice>($this$unsafeTransform$iv$iv, var6_6){
                                final /* synthetic */ Flow $this_unsafeTransform$inlined;
                                final /* synthetic */ DiscoverUsbReadersOperation $receiver$inlined;
                                {
                                    this.$this_unsafeTransform$inlined = flow;
                                    this.$receiver$inlined = discoverUsbReadersOperation;
                                }

                                @Nullable
                                public Object collect(@NotNull FlowCollector collector, @NotNull Continuation $completion) {
                                    Continuation continuation = $completion;
                                    FlowCollector $this$unsafeTransform_u24lambda_u240 = collector;
                                    boolean bl = false;
                                    Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240, this.$receiver$inlined){
                                        final /* synthetic */ FlowCollector $this_unsafeFlow;
                                        final /* synthetic */ DiscoverUsbReadersOperation $receiver$inlined;
                                        {
                                            this.$this_unsafeFlow = $receiver;
                                            this.$receiver$inlined = discoverUsbReadersOperation;
                                        }

                                        /*
                                         * Unable to fully structure code
                                         */
                                        @Nullable
                                        public final Object emit(Object var1_1, @NotNull Continuation var2_2) {
                                            if (!(var2_2 instanceof DiscoverUsbReadersOperation$onUpdateDiscoveredReaders$1$invokeSuspend$lambda$4$$inlined$map$1$2$1)) ** GOTO lbl-1000
                                            var3_3 = var2_2;
                                            if ((var3_3.label & -2147483648) != 0) {
                                                var3_3.label -= -2147483648;
                                            } else lbl-1000:
                                            // 2 sources

                                            {
                                                $continuation = new ContinuationImpl(this, var2_2){
                                                    /* synthetic */ Object result;
                                                    int label;
                                                    Object L$0;
                                                    final /* synthetic */ DiscoverUsbReadersOperation$onUpdateDiscoveredReaders$1$invokeSuspend$lambda$4$$inlined$map$1$2 this$0;
                                                    {
                                                        this.this$0 = this$0;
                                                        super($completion);
                                                    }

                                                    @Nullable
                                                    public final Object invokeSuspend(@NotNull Object $result) {
                                                        this.result = $result;
                                                        this.label |= Integer.MIN_VALUE;
                                                        return this.this$0.emit(null, (Continuation)this);
                                                    }
                                                };
                                            }
                                            $result = $continuation.result;
                                            var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch ($continuation.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    var6_6 = value;
                                                    $this$map_u24lambda_u245 = this.$this_unsafeFlow;
                                                    $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                                    var9_11 = $this$map_u24lambda_u245;
                                                    (Continuation)$continuation;
                                                    p0 = (UsbDevice)value;
                                                    $i$a$-map-BbposUsbAdapter$DiscoverUsbReadersOperation$onUpdateDiscoveredReaders$1$returnList$1$usbDevicesWithDeviceInfo$2 = false;
                                                    $continuation.L$0 = var9_11;
                                                    $continuation.label = 1;
                                                    v0 = DiscoverUsbReadersOperation.access$checkUsbPermission(this.$receiver$inlined, p0, (Continuation)$continuation);
                                                    if (v0 == var5_5) {
                                                        return var5_5;
                                                    }
                                                    ** GOTO lbl33
                                                }
                                                case 1: {
                                                    $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                                    $i$a$-map-BbposUsbAdapter$DiscoverUsbReadersOperation$onUpdateDiscoveredReaders$1$returnList$1$usbDevicesWithDeviceInfo$2 = false;
                                                    var9_11 = (FlowCollector)$continuation.L$0;
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v0 = $result;
lbl33:
                                                    // 2 sources

                                                    $continuation.L$0 = null;
                                                    $continuation.label = 2;
                                                    v1 = var9_11.emit(v0, (Continuation)$continuation);
                                                    if (v1 == var5_5) {
                                                        return var5_5;
                                                    }
                                                    ** GOTO lbl43
                                                }
                                                case 2: {
                                                    $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v1 = $result;
lbl43:
                                                    // 2 sources

                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }
                                    }, $completion);
                                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                        return object;
                                    }
                                    return Unit.INSTANCE;
                                }
                            };
                            $i$f$mapNotNull = false;
                            $this$unsafeTransform$iv$iv = $this$mapNotNull$iv;
                            $i$f$unsafeTransform = false;
                            $i$f$unsafeFlow = false;
                            $this$filter$iv = (Flow)new Flow<Pair<? extends UsbDevice, ? extends ReaderInfo>>($this$unsafeTransform$iv$iv, var6_6){
                                final /* synthetic */ Flow $this_unsafeTransform$inlined;
                                final /* synthetic */ DiscoverUsbReadersOperation $receiver$inlined;
                                {
                                    this.$this_unsafeTransform$inlined = flow;
                                    this.$receiver$inlined = discoverUsbReadersOperation;
                                }

                                @Nullable
                                public Object collect(@NotNull FlowCollector collector, @NotNull Continuation $completion) {
                                    Continuation continuation = $completion;
                                    FlowCollector $this$unsafeTransform_u24lambda_u240 = collector;
                                    boolean bl = false;
                                    Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240, this.$receiver$inlined){
                                        final /* synthetic */ FlowCollector $this_unsafeFlow;
                                        final /* synthetic */ DiscoverUsbReadersOperation $receiver$inlined;
                                        {
                                            this.$this_unsafeFlow = $receiver;
                                            this.$receiver$inlined = discoverUsbReadersOperation;
                                        }

                                        /*
                                         * Unable to fully structure code
                                         */
                                        @Nullable
                                        public final Object emit(Object var1_1, @NotNull Continuation var2_2) {
                                            if (!(var2_2 instanceof DiscoverUsbReadersOperation$onUpdateDiscoveredReaders$1$invokeSuspend$lambda$4$$inlined$mapNotNull$1$2$1)) ** GOTO lbl-1000
                                            var3_3 = var2_2;
                                            if ((var3_3.label & -2147483648) != 0) {
                                                var3_3.label -= -2147483648;
                                            } else lbl-1000:
                                            // 2 sources

                                            {
                                                $continuation = new ContinuationImpl(this, var2_2){
                                                    /* synthetic */ Object result;
                                                    int label;
                                                    Object L$0;
                                                    final /* synthetic */ DiscoverUsbReadersOperation$onUpdateDiscoveredReaders$1$invokeSuspend$lambda$4$$inlined$mapNotNull$1$2 this$0;
                                                    {
                                                        this.this$0 = this$0;
                                                        super($completion);
                                                    }

                                                    @Nullable
                                                    public final Object invokeSuspend(@NotNull Object $result) {
                                                        this.result = $result;
                                                        this.label |= Integer.MIN_VALUE;
                                                        return this.this$0.emit(null, (Continuation)this);
                                                    }
                                                };
                                            }
                                            $result = $continuation.result;
                                            var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch ($continuation.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    var6_6 = value;
                                                    $this$mapNotNull_u24lambda_u246 = this.$this_unsafeFlow;
                                                    $i$a$-unsafeTransform-FlowKt__TransformKt$mapNotNull$1 = false;
                                                    (Continuation)$continuation;
                                                    p0 = (UsbDevice)value;
                                                    $i$a$-mapNotNull-BbposUsbAdapter$DiscoverUsbReadersOperation$onUpdateDiscoveredReaders$1$returnList$1$usbDevicesWithDeviceInfo$3 = false;
                                                    $continuation.L$0 = $this$mapNotNull_u24lambda_u246;
                                                    $continuation.label = 1;
                                                    v0 = DiscoverUsbReadersOperation.access$getDeviceName(this.$receiver$inlined, p0, (Continuation)$continuation);
                                                    if (v0 == var5_5) {
                                                        return var5_5;
                                                    }
                                                    ** GOTO lbl32
                                                }
                                                case 1: {
                                                    $i$a$-unsafeTransform-FlowKt__TransformKt$mapNotNull$1 = false;
                                                    $i$a$-mapNotNull-BbposUsbAdapter$DiscoverUsbReadersOperation$onUpdateDiscoveredReaders$1$returnList$1$usbDevicesWithDeviceInfo$3 = false;
                                                    $this$mapNotNull_u24lambda_u246 = (FlowCollector)$continuation.L$0;
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v0 = $result;
lbl32:
                                                    // 2 sources

                                                    var11_14 = v0;
                                                    if (var11_14 != null) {
                                                        transformed = var11_14;
                                                        $continuation.L$0 = null;
                                                        $continuation.label = 2;
                                                        v1 = $this$mapNotNull_u24lambda_u246.emit(transformed, (Continuation)$continuation);
                                                        if (v1 == var5_5) {
                                                            return var5_5;
                                                        }
                                                    }
                                                    ** GOTO lbl45
                                                }
                                                case 2: {
                                                    $i$a$-unsafeTransform-FlowKt__TransformKt$mapNotNull$1 = false;
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v1 = $result;
lbl45:
                                                    // 2 sources

                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }
                                    }, $completion);
                                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                        return object;
                                    }
                                    return Unit.INSTANCE;
                                }
                            };
                            $i$f$filter = false;
                            $this$unsafeTransform$iv$iv = $this$filter$iv;
                            $i$f$unsafeTransform = false;
                            $i$f$unsafeFlow = false;
                            this.L$0 = var7_7;
                            this.label = 1;
                            v1 = FlowKt.toList$default((Flow)((Flow)new Flow<Pair<? extends UsbDevice, ? extends ReaderInfo>>($this$unsafeTransform$iv$iv){
                                final /* synthetic */ Flow $this_unsafeTransform$inlined;
                                {
                                    this.$this_unsafeTransform$inlined = flow;
                                }

                                @Nullable
                                public Object collect(@NotNull FlowCollector collector, @NotNull Continuation $completion) {
                                    Continuation continuation = $completion;
                                    FlowCollector $this$unsafeTransform_u24lambda_u240 = collector;
                                    boolean bl = false;
                                    Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240){
                                        final /* synthetic */ FlowCollector $this_unsafeFlow;
                                        {
                                            this.$this_unsafeFlow = $receiver;
                                        }

                                        /*
                                         * Unable to fully structure code
                                         */
                                        @Nullable
                                        public final Object emit(Object var1_1, @NotNull Continuation var2_2) {
                                            if (!(var2_2 instanceof DiscoverUsbReadersOperation$onUpdateDiscoveredReaders$1$invokeSuspend$lambda$4$$inlined$filter$1$2$1)) ** GOTO lbl-1000
                                            var3_3 = var2_2;
                                            if ((var3_3.label & -2147483648) != 0) {
                                                var3_3.label -= -2147483648;
                                            } else lbl-1000:
                                            // 2 sources

                                            {
                                                $continuation = new ContinuationImpl(this, var2_2){
                                                    /* synthetic */ Object result;
                                                    int label;
                                                    Object L$0;
                                                    Object L$1;
                                                    final /* synthetic */ DiscoverUsbReadersOperation$onUpdateDiscoveredReaders$1$invokeSuspend$lambda$4$$inlined$filter$1$2 this$0;
                                                    {
                                                        this.this$0 = this$0;
                                                        super($completion);
                                                    }

                                                    @Nullable
                                                    public final Object invokeSuspend(@NotNull Object $result) {
                                                        this.result = $result;
                                                        this.label |= Integer.MIN_VALUE;
                                                        return this.this$0.emit(null, (Continuation)this);
                                                    }
                                                };
                                            }
                                            $result = $continuation.result;
                                            var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch ($continuation.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    var6_6 = value;
                                                    $this$filter_u24lambda_u240 = this.$this_unsafeFlow;
                                                    $i$a$-unsafeTransform-FlowKt__TransformKt$filter$1 = false;
                                                    (Continuation)$continuation;
                                                    it = (Pair)value;
                                                    $i$a$-filter-BbposUsbAdapter$DiscoverUsbReadersOperation$onUpdateDiscoveredReaders$1$returnList$1$usbDevicesWithDeviceInfo$4 = false;
                                                    for (DeviceType deviceType : BbposUsbAdapter.access$getUNSUPPORTED_USB_DEVICE_TYPE$cp()) {
                                                        for (String prefix : deviceType.getSerialPrefixes()) {
                                                            v0 = ((ReaderInfo)it.getSecond()).getSerial();
                                                            v1 = v0 != null ? StringsKt.startsWith$default((String)v0, (String)prefix, (boolean)false, (int)2, null) : false;
                                                            if (!v1) continue;
                                                            v2 = false;
                                                            ** GOTO lbl28
                                                        }
                                                    }
                                                    v2 = true;
lbl28:
                                                    // 2 sources

                                                    if (!v2) break;
                                                    $continuation.label = 1;
                                                    v3 = $this$filter_u24lambda_u240.emit((Object)value, (Continuation)$continuation);
                                                    if (v3 == var5_5) {
                                                        return var5_5;
                                                    }
                                                    break;
                                                }
                                                case 1: {
                                                    $i$a$-unsafeTransform-FlowKt__TransformKt$filter$1 = false;
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v3 = $result;
                                                    break;
                                                }
                                            }
                                            return Unit.INSTANCE;
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }
                                    }, $completion);
                                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                        return object;
                                    }
                                    return Unit.INSTANCE;
                                }
                            }), null, (Continuation)this, (int)1, null);
                            ** if (v1 != var28_2) goto lbl43
lbl42:
                            // 1 sources

                            return var28_2;
lbl43:
                            // 1 sources

                            ** GOTO lbl51
                        }
                        case 1: {
                            $i$a$-run-BbposUsbAdapter$DiscoverUsbReadersOperation$onUpdateDiscoveredReaders$1$returnList$1 = false;
                            var7_7 = (BbposUsbAdapter)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl51:
                                // 2 sources

                                if (!(usbDevicesWithDeviceInfo = (List)v1).isEmpty()) ** GOTO lbl54
                                v0 = CollectionsKt.emptyList();
                                ** GOTO lbl108
lbl54:
                                // 1 sources

                                BbposUsbAdapter.access$getLogger(var7_7).d("readersWithDeviceInfo = " + usbDevicesWithDeviceInfo, new Pair[0]);
                                $i$f$filter = usbDevicesWithDeviceInfo;
                                var16_23 = var7_7;
                                $i$f$mapNotNull = false;
                                $i$f$unsafeTransform = $this$mapNotNull$iv;
                                destination$iv$iv = new ArrayList<E>();
                                $i$f$mapNotNullTo = false;
                                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                                $i$f$forEach = false;
                                var20_28 = $this$forEach$iv$iv$iv.iterator();
                                while (var20_28.hasNext()) {
                                    element$iv$iv = element$iv$iv$iv = var20_28.next();
                                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                                    it = (Pair)element$iv$iv;
                                    $i$a$-mapNotNull-BbposUsbAdapter$DiscoverUsbReadersOperation$onUpdateDiscoveredReaders$1$returnList$1$locationsMap$1 = false;
                                    if (((ReaderInfo)it.getSecond()).getSerial() == null) continue;
                                    $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                                    destination$iv$iv.add(it$iv$iv);
                                }
                                locationsMap = var16_23.getLocationsForDiscovery((List)destination$iv$iv);
                                $this$map$iv = usbDevicesWithDeviceInfo;
                                $i$f$map = false;
                                $this$mapNotNullTo$iv$iv = $this$map$iv;
                                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    var20_28 = (Pair)item$iv$iv;
                                    var16_23 = destination$iv$iv;
                                    $i$a$-map-BbposUsbAdapter$DiscoverUsbReadersOperation$onUpdateDiscoveredReaders$1$returnList$1$1 = false;
                                    location = locationsMap.get(((ReaderInfo)it.getSecond()).getSerial());
                                    v2 = ((ReaderInfo)it.getSecond()).getSerial();
                                    Intrinsics.checkNotNull((Object)v2);
                                    var23_33 = DeviceTypeMaker.Companion.fromSerial(v2);
                                    var24_34 = location == null ? LocationStatus.NOT_SET : LocationStatus.SET;
                                    var25_36 = (ReaderInfo)it.getSecond();
                                    var26_37 = (UsbDevice)it.getFirst();
                                    var16_23.add(new com.stripe.stripeterminal.external.models.Reader(var23_33, null, null, location, var24_34, var25_36, false, null, var26_37, 198, null));
                                }
                                var15_22 = (List)destination$iv$iv;
                            }
                            catch (TerminalException e) {
                                var7_7.onFailure(e);
                                return Unit.INSTANCE;
                            }
                            catch (CancellationException e) {
                                BbposUsbAdapter.access$getLogger(var7_7).w(e, "DiscoverReaders was canceled by the user", new Pair[0]);
                                throw e;
                            }
                            catch (Exception e) {
                                var7_7.onUnexpectedFailure(e);
                                return Unit.INSTANCE;
                            }
                            v0 = var15_22;
lbl108:
                            // 3 sources

                            returnList = v0;
                            if (!this.this$0.isCancelled()) {
                                BuildersKt.launch$default((CoroutineScope)this.$defaultScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, (List<com.stripe.stripeterminal.external.models.Reader>)returnList, this.this$1, null){
                                    int label;
                                    final /* synthetic */ DiscoverUsbReadersOperation this$0;
                                    final /* synthetic */ List<com.stripe.stripeterminal.external.models.Reader> $returnList;
                                    final /* synthetic */ BbposUsbAdapter this$1;
                                    {
                                        this.this$0 = $receiver;
                                        this.$returnList = $returnList;
                                        this.this$1 = $receiver2;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     */
                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                try {
                                                    void $this$mapNotNullTo$iv$iv;
                                                    void $this$mapNotNull$iv;
                                                    Iterable iterable = this.$returnList;
                                                    DiscoverUsbReadersOperation discoverUsbReadersOperation = this.this$0;
                                                    boolean $i$f$mapNotNull = false;
                                                    void var4_6 = $this$mapNotNull$iv;
                                                    Collection destination$iv$iv = new ArrayList<E>();
                                                    boolean $i$f$mapNotNullTo = false;
                                                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                                                    boolean $i$f$forEach = false;
                                                    Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                                                    while (iterator.hasNext()) {
                                                        String it$iv$iv;
                                                        T element$iv$iv$iv;
                                                        T element$iv$iv = element$iv$iv$iv = iterator.next();
                                                        boolean bl = false;
                                                        com.stripe.stripeterminal.external.models.Reader it = (com.stripe.stripeterminal.external.models.Reader)element$iv$iv;
                                                        boolean bl2 = false;
                                                        UsbDevice usbDevice = it.getUsbDevice();
                                                        if ((usbDevice != null ? usbDevice.getProductName() : null) == null) continue;
                                                        it$iv$iv = it$iv$iv;
                                                        boolean bl3 = false;
                                                        destination$iv$iv.add(it$iv$iv);
                                                    }
                                                    DiscoverUsbReadersOperation.access$setDiscoveredProductNames$p(discoverUsbReadersOperation, (List)destination$iv$iv);
                                                    DiscoverUsbReadersOperation.access$getListener$p(this.this$0).onUpdateDiscoveredReaders(this.$returnList);
                                                }
                                                catch (Exception e2) {
                                                    this.this$1.onUnexpectedFailure(e2);
                                                }
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        /*
         * Unable to fully structure code
         */
        private final Object checkUsbPermission(UsbDevice var1_1, Continuation<? super UsbDevice> var2_2) {
            if (!(var2_2 instanceof checkUsbPermission.1)) ** GOTO lbl-1000
            var10_3 = var2_2;
            if ((var10_3.label & -2147483648) != 0) {
                var10_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ DiscoverUsbReadersOperation this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return DiscoverUsbReadersOperation.access$checkUsbPermission(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    var4_6 = BbposUsbAdapter.this;
                    $continuation.L$0 = this;
                    $continuation.L$1 = usbDevice;
                    $continuation.L$2 = var4_6;
                    $continuation.label = 1;
                    var5_7 = (Continuation)$continuation;
                    var6_8 = new SafeContinuation(IntrinsicsKt.intercepted((Continuation)var5_7));
                    continuation = (Continuation)var6_8;
                    $i$a$-suspendCoroutine-BbposUsbAdapter$DiscoverUsbReadersOperation$checkUsbPermission$permissionCheckResult$1 = false;
                    BbposUsbAdapter.access$getUsbPermissionReceiver$p(var4_6).startListening(var1_1, (Function1<? super UsbDevice, Unit>)((Function1)new Function1<UsbDevice, Unit>((Object)continuation){

                        public final void invoke(@NotNull UsbDevice p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            ((Continuation)this.receiver).resumeWith(Result.constructor-impl((Object)p0));
                        }
                    }), (Function0<Unit>)((Function0)new Function0<Unit>((Continuation<? super UsbDevice>)continuation){
                        final /* synthetic */ Continuation<UsbDevice> $continuation;
                        {
                            this.$continuation = $continuation;
                            super(0);
                        }

                        public final void invoke() {
                            this.$continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new TerminalException(TerminalException.TerminalErrorCode.USB_PERMISSION_DENIED, "You must grant Terminal SDK permission to connect to USB reader.", null, null, 12, null))));
                        }
                    }));
                    v0 = var6_8.getOrThrow();
                    if (v0 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        DebugProbesKt.probeCoroutineSuspended((Continuation)((Continuation)$continuation));
                    }
                    v1 = v0;
                    if (v0 == var11_5) {
                        return var11_5;
                    }
                    ** GOTO lbl39
                }
                case 1: {
                    (BbposUsbAdapter)$continuation.L$2;
                    (UsbDevice)$continuation.L$1;
                    this = (DiscoverUsbReadersOperation)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl39:
                    // 2 sources

                    permissionCheckResult = (UsbDevice)v1;
                    BbposUsbAdapter.access$getUsbPermissionReceiver$p(BbposUsbAdapter.this).stopListening();
                    return permissionCheckResult;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final Object getDeviceName(UsbDevice device2, Continuation<? super Pair<? extends UsbDevice, ReaderInfo>> $completion) {
            return CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Pair<? extends UsbDevice, ? extends ReaderInfo>>, Object>(this, device2, BbposUsbAdapter.this, null){
                Object L$1;
                Object L$2;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ DiscoverUsbReadersOperation this$0;
                final /* synthetic */ UsbDevice $device;
                final /* synthetic */ BbposUsbAdapter this$1;
                {
                    this.this$0 = $receiver;
                    this.$device = $device;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    block23: {
                        block21: {
                            block22: {
                                block20: {
                                    block19: {
                                        var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)var1_1);
                                                $this$coroutineScope = (CoroutineScope)this.L$0;
                                                this.L$0 = $this$coroutineScope;
                                                this.label = 1;
                                                v0 = DiscoverUsbReadersOperation.access$connect(this.this$0, this.$device, (Continuation)this);
                                                if (v0 == var10_2) {
                                                    return var10_2;
                                                }
                                                ** GOTO lbl16
                                            }
                                            case 1: {
                                                $this$coroutineScope = (CoroutineScope)this.L$0;
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = $result;
lbl16:
                                                // 2 sources

                                                this.L$0 = $this$coroutineScope;
                                                this.label = 2;
                                                v1 = FlowKt.first((Flow)((Flow)v0), (Continuation)((Continuation)this));
                                                if (v1 == var10_2) {
                                                    return var10_2;
                                                }
                                                ** GOTO lbl26
                                            }
                                            case 2: {
                                                $this$coroutineScope = (CoroutineScope)this.L$0;
                                                ResultKt.throwOnFailure((Object)$result);
                                                v1 = $result;
lbl26:
                                                // 2 sources

                                                v2 = (UsbDevice)v1;
                                                if (v2 == null) break block21;
                                                var3_4 = v2;
                                                var4_5 = this.this$0;
                                                var5_6 = this.this$1;
                                                connectedDevice = var3_4;
                                                $i$a$-let-BbposUsbAdapter$DiscoverUsbReadersOperation$getDeviceName$2$1 = false;
                                                this.L$0 = $this$coroutineScope;
                                                this.L$1 = var4_5;
                                                this.L$2 = var5_6;
                                                this.label = 3;
                                                v3 = DiscoverUsbReadersOperation.access$getDeviceInfo(var4_5, connectedDevice, (Continuation)this);
                                                ** if (v3 != var10_2) goto lbl42
lbl41:
                                                // 1 sources

                                                return var10_2;
lbl42:
                                                // 1 sources

                                                ** GOTO lbl52
                                            }
                                            case 3: {
                                                $i$a$-let-BbposUsbAdapter$DiscoverUsbReadersOperation$getDeviceName$2$1 = false;
                                                var5_6 = (BbposUsbAdapter)this.L$2;
                                                var4_5 = (DiscoverUsbReadersOperation)this.L$1;
                                                $this$coroutineScope = (CoroutineScope)this.L$0;
                                                ResultKt.throwOnFailure((Object)$result);
                                                v3 = $result;
lbl52:
                                                // 2 sources

                                                this.L$0 = $this$coroutineScope;
                                                this.L$1 = var4_5;
                                                this.L$2 = var5_6;
                                                this.label = 4;
                                                v4 = FlowKt.first((Flow)((Flow)v3), (Continuation)this);
                                                ** if (v4 != var10_2) goto lbl59
lbl58:
                                                // 1 sources

                                                return var10_2;
lbl59:
                                                // 1 sources

                                                ** GOTO lbl69
                                            }
                                            case 4: {
                                                $i$a$-let-BbposUsbAdapter$DiscoverUsbReadersOperation$getDeviceName$2$1 = false;
                                                var5_6 = (BbposUsbAdapter)this.L$2;
                                                var4_5 = (DiscoverUsbReadersOperation)this.L$1;
                                                $this$coroutineScope = (CoroutineScope)this.L$0;
                                                ResultKt.throwOnFailure((Object)$result);
                                                v4 = $result;
lbl69:
                                                // 2 sources

                                                var8_13 = (Pair)v4;
                                                if (!CoroutineScopeKt.isActive((CoroutineScope)$this$coroutineScope)) break;
                                                this.L$0 = var8_13;
                                                this.L$1 = null;
                                                this.L$2 = null;
                                                this.label = 5;
                                                v5 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)NonCancellable.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(var4_5, null){
                                                    int label;
                                                    final /* synthetic */ DiscoverUsbReadersOperation this$0;
                                                    {
                                                        this.this$0 = $receiver;
                                                        super(2, $completion);
                                                    }

                                                    /*
                                                     * Unable to fully structure code
                                                     */
                                                    @Nullable
                                                    public final Object invokeSuspend(@NotNull Object var1_1) {
                                                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                        switch (this.label) {
                                                            case 0: {
                                                                ResultKt.throwOnFailure((Object)var1_1);
                                                                this.label = 1;
                                                                v0 = DiscoverUsbReadersOperation.access$disconnect(this.this$0, (Continuation)this);
                                                                if (v0 == var2_2) {
                                                                    return var2_2;
                                                                }
                                                                ** GOTO lbl13
                                                            }
                                                            case 1: {
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                v0 = $result;
lbl13:
                                                                // 2 sources

                                                                this.label = 2;
                                                                v1 = FlowKt.collect((Flow)((Flow)v0), (Continuation)((Continuation)this));
                                                                if (v1 == var2_2) {
                                                                    return var2_2;
                                                                }
                                                                ** GOTO lbl21
                                                            }
                                                            case 2: {
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                v1 = $result;
lbl21:
                                                                // 2 sources

                                                                return Unit.INSTANCE;
                                                            }
                                                        }
                                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                    }

                                                    @NotNull
                                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                    }

                                                    @Nullable
                                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                    }
                                                }), (Continuation)this);
                                                if (v5 == var10_2) {
                                                    return var10_2;
                                                }
                                                break block22;
                                            }
                                            case 5: {
                                                $i$a$-let-BbposUsbAdapter$DiscoverUsbReadersOperation$getDeviceName$2$1 = false;
                                                var8_13 = (Pair)this.L$0;
                                                ResultKt.throwOnFailure((Object)$result);
                                                v5 = $result;
                                                break block22;
                                            }
                                        }
                                        BbposUsbAdapter.access$getLogger(var5_6).i("disconnectUnsafe()", new Pair[0]);
                                        DiscoverUsbReadersOperation.access$disconnectUnsafe(var4_5);
                                        break block22;
                                        catch (Throwable var9_14) {
                                            if (!CoroutineScopeKt.isActive((CoroutineScope)$this$coroutineScope)) break block19;
                                            this.L$0 = var9_14;
                                            this.L$1 = null;
                                            this.L$2 = null;
                                            this.label = 6;
                                            v6 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)NonCancellable.INSTANCE), (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (Continuation)this);
                                            if (v6 == var10_2) {
                                                return var10_2;
                                            }
                                            break block20;
                                        }
                                        {
                                            case 6: {
                                                $i$a$-let-BbposUsbAdapter$DiscoverUsbReadersOperation$getDeviceName$2$1 = false;
                                                var9_15 = (Throwable)this.L$0;
                                                ResultKt.throwOnFailure((Object)$result);
                                                v6 = $result;
                                                break block20;
                                            }
                                        }
                                    }
                                    BbposUsbAdapter.access$getLogger(var5_6).i("disconnectUnsafe()", new Pair[0]);
                                    DiscoverUsbReadersOperation.access$disconnectUnsafe(var4_5);
                                }
                                throw var9_15;
                            }
                            v7 = var8_13;
                            break block23;
                        }
                        v7 = null;
                    }
                    return v7;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<CoroutineScope, Continuation<? super Pair<? extends UsbDevice, ? extends ReaderInfo>>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Pair<? extends UsbDevice, ReaderInfo>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }

        private final Object connect(UsbDevice usbDevice, Continuation<? super Flow<? extends UsbDevice>> $completion) {
            return FlowKt.callbackFlow((Function2)((Function2)new Function2<ProducerScope<? super UsbDevice>, Continuation<? super Unit>, Object>(BbposUsbAdapter.this, usbDevice, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ BbposUsbAdapter this$0;
                final /* synthetic */ UsbDevice $usbDevice;
                {
                    this.this$0 = $receiver;
                    this.$usbDevice = $usbDevice;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            ProducerScope $this$callbackFlow = (ProducerScope)this.L$0;
                            ObservableSource[] observableSourceArray = new ObservableSource[]{BbposUsbAdapter.access$getReaderStatusListener$p(this.this$0).getReaderConnectObservable().map(new Function(this.$usbDevice){
                                final /* synthetic */ UsbDevice $usbDevice;
                                {
                                    this.$usbDevice = $usbDevice;
                                }

                                @NotNull
                                public final Optional.Present<UsbDevice> apply(@NotNull Reader it) {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    return Optional.Companion.of(this.$usbDevice);
                                }
                            }), BbposUsbAdapter.access$getReaderStatusListener$p(this.this$0).getReaderDisconnectObservable().map((Function)connect.subscription.2.INSTANCE)};
                            Disposable disposable = Observable.ambArray((ObservableSource[])observableSourceArray).subscribe(new Consumer((ProducerScope<? super UsbDevice>)$this$callbackFlow){
                                final /* synthetic */ ProducerScope<UsbDevice> $$this$callbackFlow;
                                {
                                    this.$$this$callbackFlow = $$this$callbackFlow;
                                }

                                public final void accept(@NotNull Optional<UsbDevice> it) {
                                    Intrinsics.checkNotNullParameter(it, (String)"it");
                                    ChannelsKt.trySendBlocking((SendChannel)((SendChannel)this.$$this$callbackFlow), (Object)it.getOrNull());
                                    SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.$$this$callbackFlow), null, (int)1, null);
                                }
                            });
                            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"usbDevice: UsbDevice) =\n\u2026close()\n                }");
                            Disposable subscription2 = disposable;
                            DeviceControllerWrapper deviceControllerWrapper = BbposUsbAdapter.access$getDeviceController$p(this.this$0);
                            String string = this.$usbDevice.getDeviceName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"usbDevice.deviceName");
                            deviceControllerWrapper.startUsbWithDeviceName(string);
                            this.label = 1;
                            Object object3 = ProduceKt.awaitClose((ProducerScope)$this$callbackFlow, (Function0)((Function0)new Function0<Unit>(subscription2){
                                final /* synthetic */ Disposable $subscription;
                                {
                                    this.$subscription = $subscription;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.$subscription.dispose();
                                }
                            }), (Continuation)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<ProducerScope<? super UsbDevice>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(@NotNull ProducerScope<? super UsbDevice> p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        private final Object disconnect(Continuation<? super Flow<Unit>> $completion) {
            return FlowKt.callbackFlow((Function2)((Function2)new Function2<ProducerScope<? super Unit>, Continuation<? super Unit>, Object>(BbposUsbAdapter.this, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ BbposUsbAdapter this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            ProducerScope $this$callbackFlow = (ProducerScope)this.L$0;
                            Disposable disposable = BbposUsbAdapter.access$getReaderStatusListener$p(this.this$0).getReaderDisconnectObservable().subscribe(new Consumer((ProducerScope<? super Unit>)$this$callbackFlow){
                                final /* synthetic */ ProducerScope<Unit> $$this$callbackFlow;
                                {
                                    this.$$this$callbackFlow = $$this$callbackFlow;
                                }

                                public final void accept(@NotNull DisconnectCause it) {
                                    Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                                    ChannelsKt.trySendBlocking((SendChannel)((SendChannel)this.$$this$callbackFlow), (Object)Unit.INSTANCE);
                                    SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.$$this$callbackFlow), null, (int)1, null);
                                }
                            });
                            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"readerStatusListener.rea\u2026close()\n                }");
                            Disposable subscription2 = disposable;
                            this.this$0.removeReaderDisconnectHandler();
                            BbposUsbAdapter.access$getDeviceController$p(this.this$0).stopUsb();
                            this.label = 1;
                            Object object3 = ProduceKt.awaitClose((ProducerScope)$this$callbackFlow, (Function0)((Function0)new Function0<Unit>(subscription2, this.this$0){
                                final /* synthetic */ Disposable $subscription;
                                final /* synthetic */ BbposUsbAdapter this$0;
                                {
                                    this.$subscription = $subscription;
                                    this.this$0 = $receiver;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.$subscription.dispose();
                                    this.this$0.registerReaderDisconnectHandler();
                                }
                            }), (Continuation)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<ProducerScope<? super Unit>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(@NotNull ProducerScope<? super Unit> p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        private final Object getDeviceInfo(UsbDevice usbDevice, Continuation<? super Flow<? extends Pair<? extends UsbDevice, ReaderInfo>>> $completion) {
            return FlowKt.callbackFlow((Function2)((Function2)new Function2<ProducerScope<? super Pair<? extends UsbDevice, ? extends ReaderInfo>>, Continuation<? super Unit>, Object>(BbposUsbAdapter.this, usbDevice, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ BbposUsbAdapter this$0;
                final /* synthetic */ UsbDevice $usbDevice;
                {
                    this.this$0 = $receiver;
                    this.$usbDevice = $usbDevice;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            ProducerScope $this$callbackFlow = (ProducerScope)this.L$0;
                            Disposable disposable = BbposUsbAdapter.access$getReaderStatusListener$p(this.this$0).getReaderInfoObservable().subscribe(new Consumer((ProducerScope<? super Pair<? extends UsbDevice, ReaderInfo>>)$this$callbackFlow, this.$usbDevice){
                                final /* synthetic */ ProducerScope<Pair<? extends UsbDevice, ReaderInfo>> $$this$callbackFlow;
                                final /* synthetic */ UsbDevice $usbDevice;
                                {
                                    this.$$this$callbackFlow = $$this$callbackFlow;
                                    this.$usbDevice = $usbDevice;
                                }

                                public final void accept(@NotNull ReaderInfo it) {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    ChannelsKt.trySendBlocking((SendChannel)((SendChannel)this.$$this$callbackFlow), (Object)new Pair((Object)this.$usbDevice, (Object)it));
                                    SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.$$this$callbackFlow), null, (int)1, null);
                                }
                            });
                            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"usbDevice: UsbDevice) =\n\u2026close()\n                }");
                            Disposable subscription2 = disposable;
                            BbposUsbAdapter.access$getDeviceController$p(this.this$0).getDeviceInfo();
                            this.label = 1;
                            Object object3 = ProduceKt.awaitClose((ProducerScope)$this$callbackFlow, (Function0)((Function0)new Function0<Unit>(subscription2){
                                final /* synthetic */ Disposable $subscription;
                                {
                                    this.$subscription = $subscription;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.$subscription.dispose();
                                }
                            }), (Continuation)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<ProducerScope<? super Pair<? extends UsbDevice, ? extends ReaderInfo>>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(@NotNull ProducerScope<? super Pair<? extends UsbDevice, ReaderInfo>> p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        private final void disconnectUnsafe() {
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)BbposUsbAdapter.this.dispatcher)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ DiscoverUsbReadersOperation this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = DiscoverUsbReadersOperation.access$disconnect(this.this$0, (Continuation)this);
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            this.label = 2;
                            v1 = FlowKt.collect((Flow)((Flow)v0), (Continuation)((Continuation)this));
                            if (v1 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl21
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl21:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        public final boolean isCancelled() {
            return this.getFuture().isDone() || this.getFuture().isCancelled();
        }

        public static final /* synthetic */ Job access$getDiscoveryJob$p(DiscoverUsbReadersOperation $this) {
            return $this.discoveryJob;
        }

        public static final /* synthetic */ void access$setDiscoveredProductNames$p(DiscoverUsbReadersOperation $this, List list) {
            $this.discoveredProductNames = list;
        }

        public static final /* synthetic */ DiscoveryListener access$getListener$p(DiscoverUsbReadersOperation $this) {
            return $this.listener;
        }

        public static final /* synthetic */ Object access$checkUsbPermission(DiscoverUsbReadersOperation $this, UsbDevice usbDevice, Continuation $completion) {
            return $this.checkUsbPermission(usbDevice, (Continuation<? super UsbDevice>)$completion);
        }

        public static final /* synthetic */ Object access$getDeviceName(DiscoverUsbReadersOperation $this, UsbDevice device2, Continuation $completion) {
            return $this.getDeviceName(device2, (Continuation<? super Pair<? extends UsbDevice, ReaderInfo>>)$completion);
        }

        public static final /* synthetic */ Object access$connect(DiscoverUsbReadersOperation $this, UsbDevice usbDevice, Continuation $completion) {
            return $this.connect(usbDevice, (Continuation<? super Flow<? extends UsbDevice>>)$completion);
        }

        public static final /* synthetic */ Object access$getDeviceInfo(DiscoverUsbReadersOperation $this, UsbDevice usbDevice, Continuation $completion) {
            return $this.getDeviceInfo(usbDevice, (Continuation<? super Flow<? extends Pair<? extends UsbDevice, ReaderInfo>>>)$completion);
        }

        public static final /* synthetic */ Object access$disconnect(DiscoverUsbReadersOperation $this, Continuation $completion) {
            return $this.disconnect((Continuation<? super Flow<Unit>>)$completion);
        }

        public static final /* synthetic */ void access$disconnectUnsafe(DiscoverUsbReadersOperation $this) {
            $this.disconnectUnsafe();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\r\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/BbposUsbAdapter$ReconnectUsbReaderOperation;", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter$ReconnectReaderOperation;", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposAdapter;", "reader", "Lcom/stripe/stripeterminal/external/models/Reader;", "(Lcom/stripe/stripeterminal/internal/common/adapter/BbposUsbAdapter;Lcom/stripe/stripeterminal/external/models/Reader;)V", "reconnectJob", "Lkotlinx/coroutines/Job;", "reconnector", "Lcom/stripe/stripeterminal/internal/common/adapter/connection/UsbReaderReconnector;", "cancel", "", "execute", "failReconnection", "onConnectDevice", "Lcom/stripe/core/hardware/Reader;", "onReportReaderInfo", "info", "Lcom/stripe/jvmcore/hardware/status/ReaderInfo;", "adapter_release"})
    private final class ReconnectUsbReaderOperation
    extends BbposAdapter.ReconnectReaderOperation {
        @NotNull
        private final com.stripe.stripeterminal.external.models.Reader reader;
        @NotNull
        private final UsbReaderReconnector reconnector;
        @Nullable
        private Job reconnectJob;

        public ReconnectUsbReaderOperation(com.stripe.stripeterminal.external.models.Reader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            this.reader = reader;
            this.reconnector = new UsbReaderReconnector(BbposUsbAdapter.this.readerStatusListener, BbposUsbAdapter.this.connectivityHealthLogger, BbposUsbAdapter.this.getLogger(), BbposUsbAdapter.this.scheduler, BbposUsbAdapter.this.reconnectionMaxTimeoutInSeconds, BbposUsbAdapter.this.reconnectionMaxAttempts, BbposUsbAdapter.this.attemptDelayMillis);
        }

        @Override
        public void onConnectDevice(@NotNull Reader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        }

        @Override
        public void onReportReaderInfo(@NotNull ReaderInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        }

        @Override
        public void cancel() {
            block1: {
                Job job = this.reconnectJob;
                if (job == null) break block1;
                Job it = job;
                boolean bl = false;
                if (it.isActive()) {
                    Job.DefaultImpls.cancel$default((Job)it, null, (int)1, null);
                    this.failReconnection();
                }
            }
        }

        @Override
        @NotNull
        public com.stripe.stripeterminal.external.models.Reader execute() {
            this.reconnectJob = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)BbposUsbAdapter.this.dispatcher)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, BbposUsbAdapter.this, null){
                int label;
                final /* synthetic */ ReconnectUsbReaderOperation this$0;
                final /* synthetic */ BbposUsbAdapter this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = ReconnectUsbReaderOperation.access$getReconnector$p(this.this$0).reconnect(ReconnectUsbReaderOperation.access$getReader$p(this.this$0)).collect(new FlowCollector(this.this$1, this.this$0){
                                final /* synthetic */ BbposUsbAdapter this$0;
                                final /* synthetic */ ReconnectUsbReaderOperation this$1;
                                {
                                    this.this$0 = $receiver;
                                    this.this$1 = $receiver2;
                                }

                                @Nullable
                                public final Object emit(@NotNull UsbReaderReconnector.ReconnectionEvent event, @NotNull Continuation<? super Unit> $completion) {
                                    UsbReaderReconnector.ReconnectionEvent reconnectionEvent = event;
                                    if (reconnectionEvent instanceof UsbReaderReconnector.ReconnectionEvent.UpdateConnectivity) {
                                        UsbReaderReconnector.ReconnectionEvent.UpdateConnectivity updateConnectivity = (UsbReaderReconnector.ReconnectionEvent.UpdateConnectivity)event;
                                        if (updateConnectivity instanceof UsbReaderReconnector.ReconnectionEvent.UpdateConnectivity.StartConnectAttempt) {
                                            BbposUsbAdapter.access$getConnectionManager$p(this.this$0).startConnect(((UsbReaderReconnector.ReconnectionEvent.UpdateConnectivity.StartConnectAttempt)event).getReader());
                                        } else if (updateConnectivity instanceof UsbReaderReconnector.ReconnectionEvent.UpdateConnectivity.GetReaderInfo) {
                                            BbposUsbAdapter.access$getConnectionManager$p(this.this$0).startReaderInfo();
                                        } else if (updateConnectivity instanceof UsbReaderReconnector.ReconnectionEvent.UpdateConnectivity.EndConnectAttempt) {
                                            BbposUsbAdapter.access$getConnectionManager$p(this.this$0).endOperation();
                                        }
                                        this.this$0.update();
                                    } else if (reconnectionEvent instanceof UsbReaderReconnector.ReconnectionEvent.FailedToReconnect) {
                                        ReconnectUsbReaderOperation.access$failReconnection(this.this$1);
                                    } else if (reconnectionEvent instanceof UsbReaderReconnector.ReconnectionEvent.ReconnectedToReader) {
                                        BbposUsbAdapter.access$getStatusManager$p(this.this$0).reconnected(((UsbReaderReconnector.ReconnectionEvent.ReconnectedToReader)event).getReader());
                                        this.this$1.set(((UsbReaderReconnector.ReconnectionEvent.ReconnectedToReader)event).getReader());
                                        BbposUsbAdapter.access$setOperationInProgress(this.this$0, this.this$0.new Adapter.NullOperation());
                                    }
                                    return Unit.INSTANCE;
                                }
                            }, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            return (com.stripe.stripeterminal.external.models.Reader)this.get();
        }

        private final void failReconnection() {
            BbposUsbAdapter.this.deviceController.stopUsb();
            BbposUsbAdapter.this.statusManager.reconnectFailed(this.reader);
            BbposUsbAdapter.this.onFailure(new TerminalException(TerminalException.TerminalErrorCode.USB_DISCONNECTED, "USB reconnection failed.", null, null, 12, null));
        }

        public static final /* synthetic */ UsbReaderReconnector access$getReconnector$p(ReconnectUsbReaderOperation $this) {
            return $this.reconnector;
        }

        public static final /* synthetic */ com.stripe.stripeterminal.external.models.Reader access$getReader$p(ReconnectUsbReaderOperation $this) {
            return $this.reader;
        }

        public static final /* synthetic */ void access$failReconnection(ReconnectUsbReaderOperation $this) {
            $this.failReconnection();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DisconnectCause.values().length];
            try {
                nArray[DisconnectCause.CONNECTED_TO_ANOTHER_DEVICE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisconnectCause.USB_DEVICE_PERMISSION_DENIED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisconnectCause.USB_NOT_SUPPORTED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

