/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.adapter;

import com.stripe.cots.aidlservice.CotsContactlessResult;
import com.stripe.cots.aidlservice.CotsReader;
import com.stripe.cots.common.CotsClientInterface;
import com.stripe.cots.common.CotsError;
import com.stripe.cots.common.CotsException;
import com.stripe.cots.common.DebuggableException;
import com.stripe.cots.common.ReaderNotConnectedException;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.terminal.api.ActivateReaderResponse;
import com.stripe.jvmcore.terminal.appinfo.ApplicationInformation;
import com.stripe.jvmcore.transaction.PaymentMethodCollectionType;
import com.stripe.stripeterminal.external.callable.DiscoveryListener;
import com.stripe.stripeterminal.external.models.ConnectionConfiguration;
import com.stripe.stripeterminal.external.models.DeviceType;
import com.stripe.stripeterminal.external.models.DiscoveryConfiguration;
import com.stripe.stripeterminal.external.models.DiscoveryMethod;
import com.stripe.stripeterminal.external.models.Location;
import com.stripe.stripeterminal.external.models.Reader;
import com.stripe.stripeterminal.external.models.ReaderSoftwareUpdate;
import com.stripe.stripeterminal.external.models.ReaderSupportResult;
import com.stripe.stripeterminal.external.models.TerminalException;
import com.stripe.stripeterminal.internal.common.Adapter;
import com.stripe.stripeterminal.internal.common.CotsDescriptor;
import com.stripe.stripeterminal.internal.common.adapter.MposAdapter;
import com.stripe.stripeterminal.internal.common.api.ApiClient;
import com.stripe.stripeterminal.internal.common.makers.PaymentMethodDataMaker;
import com.stripe.stripeterminal.internal.common.makers.ReaderMaker;
import com.stripe.stripeterminal.internal.models.PaymentMethodData;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 F2\u00020\u0001:\u0002FGB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJA\u0010\u000e\u001a\u0004\u0018\u0001H\u000f\"\u0004\b\u0000\u0010\u000f2'\u0010\u0010\u001a#\b\u0001\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000f0\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0011\u00a2\u0006\u0002\b\u0014H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0017H\u0016J\u0012\u0010\u001c\u001a\u00020\u00172\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001aH\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u000e\u0010&\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\b\u0010'\u001a\u00020\u0017H\u0016J\u0018\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\u0012\u0010-\u001a\u00020.2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u0006\u0010/\u001a\u00020\u0017J\u0010\u00100\u001a\u00020\u00172\u0006\u00101\u001a\u00020 H\u0016J(\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u00105\u001a\u0002062\u000e\u00107\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u000108H\u0014J\u0018\u00109\u001a\u00020\u00172\u0006\u00104\u001a\u0002032\u0006\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020#H\u0016J \u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\u001aH\u0016J\u000e\u0010D\u001a\u0004\u0018\u00010E*\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006H"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/CotsAdapter;", "Lcom/stripe/stripeterminal/internal/common/adapter/MposAdapter;", "applicationInformation", "Lcom/stripe/jvmcore/terminal/appinfo/ApplicationInformation;", "apiClient", "Lcom/stripe/stripeterminal/internal/common/api/ApiClient;", "cotsServiceClient", "Lcom/stripe/cots/common/CotsClientInterface;", "(Lcom/stripe/jvmcore/terminal/appinfo/ApplicationInformation;Lcom/stripe/stripeterminal/internal/common/api/ApiClient;Lcom/stripe/cots/common/CotsClientInterface;)V", "toMessage", "", "Lcom/stripe/cots/aidlservice/CotsReader$CotsError;", "getToMessage", "(Lcom/stripe/cots/aidlservice/CotsReader$CotsError;)Ljava/lang/String;", "callAidlWithExceptionConverted", "T", "call", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "cancelCollectPaymentMethod", "", "cancelDiscoverReaders", "cancelSilently", "", "cancelInstallUpdate", "checkAndThrowCotsError", "cotsReader", "Lcom/stripe/cots/aidlservice/CotsReader;", "checkForUpdate", "Lcom/stripe/stripeterminal/external/models/ReaderSoftwareUpdate;", "failSilently", "collectPaymentMethod", "Lcom/stripe/stripeterminal/internal/models/PaymentMethodData;", "paymentMethodCollectionType", "Lcom/stripe/jvmcore/transaction/PaymentMethodCollectionType;", "collectPaymentMethodHandler", "disconnectReader", "discoverReaders", "config", "Lcom/stripe/stripeterminal/external/models/DiscoveryConfiguration;", "listener", "Lcom/stripe/stripeterminal/external/callable/DiscoveryListener;", "getCotsDescriptor", "Lcom/stripe/stripeterminal/internal/common/CotsDescriptor;", "initKeystore", "installUpdate", "update", "onConnectReader", "Lcom/stripe/stripeterminal/external/models/Reader;", "reader", "connectionConfiguration", "Lcom/stripe/stripeterminal/external/models/ConnectionConfiguration;", "requestReconnection", "Lkotlin/Function0;", "onReaderActivated", "response", "Lcom/stripe/jvmcore/terminal/api/ActivateReaderResponse;", "readReusableCard", "supportsReadersOfType", "Lcom/stripe/stripeterminal/external/models/ReaderSupportResult;", "deviceType", "Lcom/stripe/stripeterminal/external/models/DeviceType;", "discoveryMethod", "Lcom/stripe/stripeterminal/external/models/DiscoveryMethod;", "simulated", "toCommonCotsError", "Lcom/stripe/cots/common/CotsError;", "Companion", "DiscoverReadersOperation", "adapter_release"})
public final class CotsAdapter
extends MposAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ApplicationInformation applicationInformation;
    @NotNull
    private final CotsClientInterface cotsServiceClient;
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(CotsAdapter.class);

    public CotsAdapter(@NotNull ApplicationInformation applicationInformation, @NotNull ApiClient apiClient, @NotNull CotsClientInterface cotsServiceClient) {
        Intrinsics.checkNotNullParameter((Object)applicationInformation, (String)"applicationInformation");
        Intrinsics.checkNotNullParameter((Object)apiClient, (String)"apiClient");
        Intrinsics.checkNotNullParameter((Object)cotsServiceClient, (String)"cotsServiceClient");
        super(apiClient, LOGGER);
        this.applicationInformation = applicationInformation;
        this.cotsServiceClient = cotsServiceClient;
    }

    @Override
    public void cancelCollectPaymentMethod() {
        this.callAidlWithExceptionConverted((Function2)new Function2<CotsClientInterface, Continuation<? super Unit>, Object>(null){
            int label;
            private /* synthetic */ Object L$0;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CotsClientInterface $this$callAidlWithExceptionConverted = (CotsClientInterface)this.L$0;
                        this.label = 1;
                        Object object3 = $this$callAidlWithExceptionConverted.cancelCollectPayment((Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CotsClientInterface, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CotsClientInterface p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Override
    public void cancelDiscoverReaders(boolean cancelSilently) {
        Adapter.ReaderOperation<?> readerOperation = this.getOperationInProgress();
        if (readerOperation instanceof DiscoverReadersOperation) {
            Adapter.ReaderOperation<?> readerOperation2 = this.getOperationInProgress();
            Intrinsics.checkNotNull(readerOperation2, (String)"null cannot be cast to non-null type com.stripe.stripeterminal.internal.common.adapter.CotsAdapter.DiscoverReadersOperation");
            ((DiscoverReadersOperation)readerOperation2).cancel(cancelSilently);
            this.setOperationInProgress(new Adapter.NullOperation());
        } else if (readerOperation instanceof Adapter.NullOperation) {
            this.setOperationToCancel(DiscoverReadersOperation.class);
        } else {
            this.logUnexpectedOperationInProgressWarning(DiscoverReadersOperation.class);
        }
    }

    @Override
    public void cancelInstallUpdate() throws TerminalException {
        throw new TerminalException(TerminalException.TerminalErrorCode.UNSUPPORTED_OPERATION, "The Tap to Pay adapter doesn't support updates", null, null, 12, null);
    }

    @Override
    @NotNull
    public ReaderSoftwareUpdate checkForUpdate(boolean failSilently) throws TerminalException {
        throw new TerminalException(TerminalException.TerminalErrorCode.UNSUPPORTED_OPERATION, "The Tap to Pay adapter doesn't support updates", null, null, 12, null);
    }

    @Override
    @NotNull
    public ReaderSupportResult supportsReadersOfType(@NotNull DeviceType deviceType, @NotNull DiscoveryMethod discoveryMethod, boolean simulated) {
        TerminalException.TerminalErrorCode terminalErrorCode;
        Intrinsics.checkNotNullParameter((Object)deviceType, (String)"deviceType");
        Intrinsics.checkNotNullParameter((Object)discoveryMethod, (String)"discoveryMethod");
        CotsError error = this.cotsServiceClient.checkDeviceCompatibility();
        switch (WhenMappings.$EnumSwitchMapping$0[error.ordinal()]) {
            case 1: {
                return (ReaderSupportResult)ReaderSupportResult.Supported.INSTANCE;
            }
            case 2: {
                terminalErrorCode = TerminalException.TerminalErrorCode.LOCAL_MOBILE_UNSUPPORTED_ANDROID_VERSION;
                break;
            }
            case 3: {
                terminalErrorCode = TerminalException.TerminalErrorCode.LOCAL_MOBILE_DEBUG_NOT_SUPPORTED;
                break;
            }
            case 4: 
            case 5: {
                terminalErrorCode = TerminalException.TerminalErrorCode.LOCAL_MOBILE_UNSUPPORTED_DEVICE;
                break;
            }
            default: {
                terminalErrorCode = TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR;
            }
        }
        TerminalException.TerminalErrorCode terminalError = terminalErrorCode;
        return (ReaderSupportResult)new ReaderSupportResult.NotSupported((Throwable)new TerminalException(terminalError, error.getMessage(), null, null, 12, null));
    }

    public final void initKeystore() {
        this.cotsServiceClient.initializeKeys();
    }

    @Override
    @NotNull
    public PaymentMethodData collectPaymentMethod(@NotNull PaymentMethodCollectionType paymentMethodCollectionType) throws TerminalException {
        Intrinsics.checkNotNullParameter((Object)paymentMethodCollectionType, (String)"paymentMethodCollectionType");
        PaymentMethodCollectionType paymentMethodCollectionType2 = paymentMethodCollectionType;
        if (paymentMethodCollectionType2 instanceof PaymentMethodCollectionType.SetupIntent) {
            throw new TerminalException(TerminalException.TerminalErrorCode.UNSUPPORTED_OPERATION, "Setup intents are not available with Tap to Pay on Android", null, null, 12, null);
        }
        if (paymentMethodCollectionType2 instanceof PaymentMethodCollectionType.Refund) {
            throw new TerminalException(TerminalException.TerminalErrorCode.UNSUPPORTED_OPERATION, "Refunds are not available with Tap to Pay on Android", null, null, 12, null);
        }
        if (paymentMethodCollectionType2 instanceof PaymentMethodCollectionType.StrongCustomerAuthentication) {
            LOGGER.e("Tap to Pay shouldn't be getting SCA collectPaymentMethod requests", new Pair[0]);
        } else if (paymentMethodCollectionType2 instanceof PaymentMethodCollectionType.Sale) {
            // empty if block
        }
        return this.collectPaymentMethodHandler(paymentMethodCollectionType);
    }

    @NotNull
    public final PaymentMethodData collectPaymentMethodHandler(@NotNull PaymentMethodCollectionType paymentMethodCollectionType) throws TerminalException {
        CotsContactlessResult result2;
        Intrinsics.checkNotNullParameter((Object)paymentMethodCollectionType, (String)"paymentMethodCollectionType");
        CotsContactlessResult cotsContactlessResult = result2 = (CotsContactlessResult)((Object)this.callAidlWithExceptionConverted((Function2)new Function2<CotsClientInterface, Continuation<? super CotsContactlessResult>, Object>(paymentMethodCollectionType, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ PaymentMethodCollectionType $paymentMethodCollectionType;
            {
                this.$paymentMethodCollectionType = $paymentMethodCollectionType;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void var2_3;
                        ResultKt.throwOnFailure((Object)object);
                        CotsClientInterface $this$callAidlWithExceptionConverted = (CotsClientInterface)this.L$0;
                        this.label = 1;
                        Object object3 = var2_3.collectPayment(this.$paymentMethodCollectionType.getAmount().getValue(), this.$paymentMethodCollectionType.getAmount().getCurrencyCode(), (Continuation<? super CotsContactlessResult>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CotsClientInterface, Continuation<? super CotsContactlessResult>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CotsClientInterface p1, @Nullable Continuation<? super CotsContactlessResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        CotsContactlessResult.ContactlessOutcome contactlessOutcome = cotsContactlessResult != null ? cotsContactlessResult.outcome : null;
        switch (contactlessOutcome == null ? -1 : WhenMappings.$EnumSwitchMapping$1[contactlessOutcome.ordinal()]) {
            case 1: {
                if (((CharSequence)result2.emvBlob).length() > 0 && ((CharSequence)result2.encryptedTrack2).length() > 0 && ((CharSequence)result2.cryptogram).length() > 0) {
                    return PaymentMethodDataMaker.INSTANCE.newEncryptedEmvData(result2.emvBlob, result2.encryptedTrack2, result2.cryptogram);
                }
                throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Invalid contactless result", null, null, 12, null);
            }
            case 2: {
                throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Contactless transaction was rejected", null, null, 12, null);
            }
            case 3: {
                throw new TerminalException(TerminalException.TerminalErrorCode.CANCELED, "Contactless transaction was canceled", null, null, 12, null);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Contactless transaction failed " + (Object)((Object)result2), null, null, 12, null);
            }
            case 10: {
                throw new TerminalException(TerminalException.TerminalErrorCode.INVALID_REQUIRED_PARAMETER, "Currency is unsupported or not set", null, null, 12, null);
            }
            case 11: {
                throw new TerminalException(TerminalException.TerminalErrorCode.LOCAL_MOBILE_NFC_DISABLED, "NFC is disabled", null, null, 12, null);
            }
            case 12: {
                throw new TerminalException(TerminalException.TerminalErrorCode.NOT_CONNECTED_TO_READER, "LocalMobile reader is not connected", null, null, 12, null);
            }
            case -1: 
            case 13: {
                throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Invalid contactless result " + (Object)((Object)result2), null, null, 12, null);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @Override
    @NotNull
    protected Reader onConnectReader(@NotNull Reader reader, @NotNull ConnectionConfiguration connectionConfiguration, @Nullable Function0<Unit> requestReconnection) throws TerminalException {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)connectionConfiguration, (String)"connectionConfiguration");
        if (reader.getDeviceType() != DeviceType.COTS_DEVICE) {
            throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Invalid reader type", null, null, 12, null);
        }
        return reader;
    }

    @Override
    public void onReaderActivated(@NotNull Reader reader, @NotNull ActivateReaderResponse response) throws TerminalException {
        Object object;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Object object2 = this;
        try {
            CotsAdapter $this$onReaderActivated_u24lambda_u240 = object2;
            boolean bl = false;
            if (reader.getDeviceType() != DeviceType.COTS_DEVICE) {
                throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Invalid reader type", null, null, 12, null);
            }
            Location location = reader.getLocation();
            String countryCode = location != null && (location = location.getAddress()) != null ? location.getCountry() : null;
            CharSequence charSequence = countryCode;
            if (charSequence == null || charSequence.length() == 0) {
                throw new TerminalException(TerminalException.TerminalErrorCode.MISSING_REQUIRED_PARAMETER, "Must have a country code to connect to a Tap to Pay reader.", null, null, 12, null);
            }
            CotsReader cotsReader2 = (CotsReader)((Object)$this$onReaderActivated_u24lambda_u240.callAidlWithExceptionConverted((Function2)new Function2<CotsClientInterface, Continuation<? super CotsReader>, Object>(response, $this$onReaderActivated_u24lambda_u240, countryCode, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ ActivateReaderResponse $response;
                final /* synthetic */ CotsAdapter $this_runCatching;
                final /* synthetic */ String $countryCode;
                {
                    this.$response = $response;
                    this.$this_runCatching = $receiver;
                    this.$countryCode = $countryCode;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            void var2_3;
                            String string;
                            ResultKt.throwOnFailure((Object)object);
                            CotsClientInterface $this$callAidlWithExceptionConverted = (CotsClientInterface)this.L$0;
                            String string2 = this.$response.getStripeSessionToken();
                            if (string2 == null) {
                                string2 = "";
                            }
                            if ((string = this.$response.getRpcSessionToken()) == null) {
                                string = "";
                            }
                            this.label = 1;
                            Object object3 = var2_3.activate(string2, string, CotsAdapter.access$getApplicationInformation$p(this.$this_runCatching).getClientType(), CotsAdapter.access$getApplicationInformation$p(this.$this_runCatching).getClientVersion(), CotsAdapter.access$getApplicationInformation$p(this.$this_runCatching).getDeviceUuid(), this.$countryCode, (Continuation<? super CotsReader>)((Continuation)this));
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<CotsClientInterface, Continuation<? super CotsReader>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(@NotNull CotsClientInterface p1, @Nullable Continuation<? super CotsReader> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            $this$onReaderActivated_u24lambda_u240.checkAndThrowCotsError(cotsReader2);
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object e2 = object = throwable;
            boolean bl = false;
            throw e2;
        }
    }

    @Override
    public void disconnectReader() throws TerminalException {
        LOGGER.i("disconnectReader", new Pair[0]);
        this.callAidlWithExceptionConverted((Function2)new Function2<CotsClientInterface, Continuation<? super Unit>, Object>(null){
            int label;
            private /* synthetic */ Object L$0;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CotsClientInterface $this$callAidlWithExceptionConverted = (CotsClientInterface)this.L$0;
                        this.label = 1;
                        Object object3 = $this$callAidlWithExceptionConverted.disconnect((Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CotsClientInterface, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CotsClientInterface p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Override
    public void discoverReaders(@NotNull DiscoveryConfiguration config, @NotNull DiscoveryListener listener2) throws TerminalException {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.setOperationInProgress(new DiscoverReadersOperation(listener2));
        this.getOperationInProgress().execute();
    }

    @Override
    public void installUpdate(@NotNull ReaderSoftwareUpdate update2) throws TerminalException {
        Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
        throw new TerminalException(TerminalException.TerminalErrorCode.UNSUPPORTED_OPERATION, "The Tap to Pay adapter doesn't support updates", null, null, 12, null);
    }

    @Override
    @NotNull
    public PaymentMethodData readReusableCard() throws TerminalException {
        throw new TerminalException(TerminalException.TerminalErrorCode.UNSUPPORTED_OPERATION, "The Tap to Pay adapter doesn't support readReusableCard", null, null, 12, null);
    }

    private final void checkAndThrowCotsError(CotsReader cotsReader2) {
        CharSequence charSequence;
        TerminalException.TerminalErrorCode terminalErrorCode;
        if (cotsReader2 == null) {
            throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Null cotsReader", null, null, 12, null);
        }
        switch (WhenMappings.$EnumSwitchMapping$2[cotsReader2.errorCode.ordinal()]) {
            case 1: {
                return;
            }
            case 2: {
                terminalErrorCode = TerminalException.TerminalErrorCode.LOCAL_MOBILE_UNSUPPORTED_DEVICE;
                break;
            }
            case 3: {
                terminalErrorCode = TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR;
                break;
            }
            case 4: {
                terminalErrorCode = TerminalException.TerminalErrorCode.LOCAL_MOBILE_UNSUPPORTED_DEVICE;
                break;
            }
            case 5: {
                terminalErrorCode = TerminalException.TerminalErrorCode.LOCAL_MOBILE_UNSUPPORTED_ANDROID_VERSION;
                break;
            }
            case 6: {
                terminalErrorCode = TerminalException.TerminalErrorCode.LOCAL_MOBILE_DEVICE_TAMPERED;
                break;
            }
            case 7: {
                terminalErrorCode = TerminalException.TerminalErrorCode.STRIPE_API_CONNECTION_ERROR;
                break;
            }
            case 8: {
                terminalErrorCode = TerminalException.TerminalErrorCode.STRIPE_API_RESPONSE_DECODING_ERROR;
                break;
            }
            case 9: {
                terminalErrorCode = TerminalException.TerminalErrorCode.STRIPE_API_ERROR;
                break;
            }
            case 10: {
                terminalErrorCode = TerminalException.TerminalErrorCode.LOCAL_MOBILE_DEBUG_NOT_SUPPORTED;
                break;
            }
            case 11: 
            case 12: {
                terminalErrorCode = TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        TerminalException.TerminalErrorCode terminalErrorCode2 = terminalErrorCode;
        CharSequence charSequence2 = cotsReader2.errorMessage;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = this.getToMessage(cotsReader2.errorCode);
        } else {
            charSequence = charSequence2;
        }
        String reason = (String)charSequence;
        throw new TerminalException(terminalErrorCode2, reason, null, null, 12, null);
    }

    private final CotsError toCommonCotsError(CotsReader.CotsError $this$toCommonCotsError) {
        CotsError cotsError;
        switch (WhenMappings.$EnumSwitchMapping$2[$this$toCommonCotsError.ordinal()]) {
            case 1: {
                cotsError = CotsError.NONE;
                break;
            }
            case 3: {
                cotsError = CotsError.DISCOVERY_MISSING_KEY_CERTIFICATES;
                break;
            }
            case 5: {
                cotsError = CotsError.DISCOVERY_UNSUPPORTED_ANDROID_VERSION;
                break;
            }
            case 4: {
                cotsError = CotsError.DISCOVERY_MISSING_NFC_READER;
                break;
            }
            case 2: {
                cotsError = CotsError.DISCOVERY_UNTRUSTED_HARDWARE;
                break;
            }
            case 10: {
                cotsError = CotsError.DISCOVERY_DEBUG_NOT_ALLOWED;
                break;
            }
            case 6: {
                cotsError = CotsError.ATTESTATION_DEVICE_TAMPERED;
                break;
            }
            case 7: {
                cotsError = CotsError.ATTESTATION_API_CONNECTION_ERROR;
                break;
            }
            case 9: {
                cotsError = CotsError.ATTESTATION_SERVER_ERROR;
                break;
            }
            case 8: {
                cotsError = CotsError.ATTESTATION_API_RESPONSE_DECODING;
                break;
            }
            case 11: {
                cotsError = CotsError.UNEXPECTED_ERROR;
                break;
            }
            case 12: {
                cotsError = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return cotsError;
    }

    private final String getToMessage(CotsReader.CotsError $this$toMessage) {
        Object object = this.toCommonCotsError($this$toMessage);
        if (object == null || (object = object.getMessage()) == null) {
            object = "Unknown error";
        }
        return object;
    }

    private final CotsDescriptor getCotsDescriptor(CotsReader cotsReader2) {
        Object object = cotsReader2;
        if (object == null || (object = object.serial) == null) {
            object = "";
        }
        CotsReader cotsReader3 = cotsReader2;
        return new CotsDescriptor((String)object, this.applicationInformation.getDeviceName(), this.applicationInformation.getDeviceModel(), this.applicationInformation.getDeviceModel(), cotsReader3 != null ? cotsReader3.isSimulated : false);
    }

    private final <T> T callAidlWithExceptionConverted(Function2<? super CotsClientInterface, ? super Continuation<? super T>, ? extends Object> call) throws TerminalException {
        Object object;
        Object object2 = this;
        try {
            CotsAdapter $this$callAidlWithExceptionConverted_u24lambda_u243 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)BuildersKt.runBlocking$default(null, (Function2)new Function2<CoroutineScope, Continuation<? super T>, Object>(call, $this$callAidlWithExceptionConverted_u24lambda_u243, null){
                int label;
                final /* synthetic */ Function2<CotsClientInterface, Continuation<? super T>, Object> $call;
                final /* synthetic */ CotsAdapter $this_runCatching;
                {
                    this.$call = $call;
                    this.$this_runCatching = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.$call.invoke((Object)CotsAdapter.access$getCotsServiceClient$p(this.$this_runCatching), (Object)((Object)this));
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super T> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, (int)1, null));
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object it = object = throwable;
            boolean bl = false;
            if (it instanceof CotsException) {
                CotsException cotsException = (CotsException)it;
                if (cotsException instanceof DebuggableException) {
                    String string = ((Throwable)it).getMessage();
                    if (string == null) {
                        string = "";
                    }
                    throw new TerminalException(TerminalException.TerminalErrorCode.LOCAL_MOBILE_DEBUG_NOT_SUPPORTED, string, null, null, 12, null);
                }
                if (cotsException instanceof ReaderNotConnectedException) {
                    String string = ((Throwable)it).getMessage();
                    if (string == null) {
                        string = "";
                    }
                    throw new TerminalException(TerminalException.TerminalErrorCode.NOT_CONNECTED_TO_READER, string, null, null, 12, null);
                }
                throw new NoWhenBranchMatchedException();
            }
            throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Contactless transaction failed " + it + '.', null, null, 12, null);
        }
        return (T)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    public static final /* synthetic */ ApplicationInformation access$getApplicationInformation$p(CotsAdapter $this) {
        return $this.applicationInformation;
    }

    public static final /* synthetic */ CotsClientInterface access$getCotsServiceClient$p(CotsAdapter $this) {
        return $this.cotsServiceClient;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/CotsAdapter$Companion;", "", "()V", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "adapter_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/CotsAdapter$DiscoverReadersOperation;", "Lcom/stripe/stripeterminal/internal/common/Adapter$ReaderOperation;", "", "Lcom/stripe/stripeterminal/internal/common/Adapter;", "listener", "Lcom/stripe/stripeterminal/external/callable/DiscoveryListener;", "(Lcom/stripe/stripeterminal/internal/common/adapter/CotsAdapter;Lcom/stripe/stripeterminal/external/callable/DiscoveryListener;)V", "cancel", "cancelSilently", "", "execute", "adapter_release"})
    private final class DiscoverReadersOperation
    extends Adapter.ReaderOperation<Unit> {
        @NotNull
        private final DiscoveryListener listener;

        public DiscoverReadersOperation(DiscoveryListener listener2) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            this.listener = listener2;
        }

        @Override
        public void execute() {
            CotsReader cotsReader2 = (CotsReader)((Object)CotsAdapter.this.callAidlWithExceptionConverted((Function2)new Function2<CotsClientInterface, Continuation<? super CotsReader>, Object>(null){
                int label;
                private /* synthetic */ Object L$0;

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            CotsClientInterface $this$callAidlWithExceptionConverted = (CotsClientInterface)this.L$0;
                            this.label = 1;
                            Object object3 = $this$callAidlWithExceptionConverted.discover((Continuation<? super CotsReader>)((Continuation)this));
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<CotsClientInterface, Continuation<? super CotsReader>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(@NotNull CotsClientInterface p1, @Nullable Continuation<? super CotsReader> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            CotsAdapter.this.checkAndThrowCotsError(cotsReader2);
            DiscoverReadersOperation discoverReadersOperation = this;
            CotsAdapter cotsAdapter = CotsAdapter.this;
            DiscoverReadersOperation $this$execute_u24lambda_u240 = discoverReadersOperation;
            boolean bl = false;
            Reader reader = ReaderMaker.INSTANCE.fromCotsDescriptor(cotsAdapter.getCotsDescriptor(cotsReader2));
            $this$execute_u24lambda_u240.listener.onUpdateDiscoveredReaders(CollectionsKt.listOf((Object)reader));
            $this$execute_u24lambda_u240.get();
        }

        public final void cancel(boolean cancelSilently) {
            if (cancelSilently) {
                this.set(null);
            } else {
                this.setException(new TerminalException(TerminalException.TerminalErrorCode.CANCELED, "DiscoverReaders was canceled by the user", null, null, 12, null));
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[CotsError.values().length];
            try {
                nArray[CotsError.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CotsError.DISCOVERY_UNSUPPORTED_ANDROID_VERSION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CotsError.DISCOVERY_DEBUG_NOT_ALLOWED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CotsError.DISCOVERY_MISSING_NFC_READER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CotsError.DISCOVERY_UNTRUSTED_HARDWARE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CotsContactlessResult.ContactlessOutcome.values().length];
            try {
                nArray[CotsContactlessResult.ContactlessOutcome.PROCEED_ONLINE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CotsContactlessResult.ContactlessOutcome.ACCESS_NOT_ALLOWED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CotsContactlessResult.ContactlessOutcome.CANCELED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CotsContactlessResult.ContactlessOutcome.IRRECOVERABLE_ERROR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CotsContactlessResult.ContactlessOutcome.RECOVERABLE_ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CotsContactlessResult.ContactlessOutcome.APPROVED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CotsContactlessResult.ContactlessOutcome.DECLINED.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CotsContactlessResult.ContactlessOutcome.NO_MUTUALLY_SUPPORTED_APPLICATIONS.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CotsContactlessResult.ContactlessOutcome.SEE_PHONE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CotsContactlessResult.ContactlessOutcome.INVALID_CURRENCY.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CotsContactlessResult.ContactlessOutcome.NFC_IS_DISABLED.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CotsContactlessResult.ContactlessOutcome.READER_NOT_ACTIVE.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CotsContactlessResult.ContactlessOutcome.UNKNOWN.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[CotsReader.CotsError.values().length];
            try {
                nArray[CotsReader.CotsError.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CotsReader.CotsError.DISCOVERY_UNTRUSTED_HARDWARE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CotsReader.CotsError.DISCOVERY_MISSING_KEY_CERTIFICATES.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CotsReader.CotsError.DISCOVERY_MISSING_NFC_READER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CotsReader.CotsError.DISCOVERY_UNSUPPORTED_ANDROID_VERSION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CotsReader.CotsError.ATTESTATION_DEVICE_TAMPERED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CotsReader.CotsError.ATTESTATION_API_CONNECTION_ERROR.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CotsReader.CotsError.ATTESTATION_API_RESPONSE_DECODING.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CotsReader.CotsError.ATTESTATION_SERVER_ERROR.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CotsReader.CotsError.DISCOVERY_DEBUG_NOT_ALLOWED.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CotsReader.CotsError.UNEXPECTED_ERROR.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CotsReader.CotsError.UNKNOWN.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

