/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.adapter;

import com.neovisionaries.i18n.CurrencyCode;
import com.stripe.core.paymentcollection.Cancelled;
import com.stripe.core.paymentcollection.EmvResult;
import com.stripe.core.paymentcollection.Failed;
import com.stripe.core.paymentcollection.ManualEntryResult;
import com.stripe.core.paymentcollection.MsrResult;
import com.stripe.core.paymentcollection.PaymentCollectionCoordinator;
import com.stripe.core.paymentcollection.PaymentCollectionListener;
import com.stripe.core.paymentcollection.PaymentCollectionResult;
import com.stripe.core.paymentcollection.SCARequirement;
import com.stripe.core.paymentcollection.Timeout;
import com.stripe.core.paymentcollection.TippingState;
import com.stripe.core.transaction.SettingsRepository;
import com.stripe.core.transaction.TransactionRepository;
import com.stripe.jvmcore.cart.Item;
import com.stripe.jvmcore.currency.Amount;
import com.stripe.jvmcore.hardware.ReaderConfiguration;
import com.stripe.jvmcore.hardware.emv.InterfaceType;
import com.stripe.jvmcore.hardware.emv.SourceType;
import com.stripe.jvmcore.hardware.emv.TlvMap;
import com.stripe.jvmcore.hardware.emv.TransactionResult;
import com.stripe.jvmcore.hardware.emv.TransactionType;
import com.stripe.jvmcore.hardware.magstripe.MagStripePaymentCollectionAuthority;
import com.stripe.jvmcore.hardware.magstripe.MagStripeReadSuccess;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.paymentcollection.OnlineAuthState;
import com.stripe.jvmcore.paymentcollection.OnlineAuthStateListener;
import com.stripe.jvmcore.transaction.ChargeAttempt;
import com.stripe.jvmcore.transaction.CollectiblePayment;
import com.stripe.jvmcore.transaction.PaymentCollectionDeviceCapability;
import com.stripe.jvmcore.transaction.PaymentMethodCollectionType;
import com.stripe.jvmcore.transaction.payment.EmvPayment;
import com.stripe.jvmcore.transaction.payment.MagstripePayment;
import com.stripe.jvmcore.transaction.payment.ManualEntryPayment;
import com.stripe.jvmcore.transaction.payment.Payment;
import com.stripe.proto.model.sdk.PaymentMethod;
import com.stripe.stripeterminal.external.models.Cart;
import com.stripe.stripeterminal.external.models.CartLineItem;
import com.stripe.stripeterminal.external.models.Reader;
import com.stripe.stripeterminal.external.models.TerminalException;
import com.stripe.stripeterminal.internal.common.Adapter;
import com.stripe.stripeterminal.internal.models.PaymentMethodData;
import com.stripe.stripeterminal.internal.models.SwipeReason;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.ExperimentalCoroutinesApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 T2\u00020\u0001:\u0002TUB\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001a\u001a\u00020\u001bH\u0007J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJd\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&2\b\b\u0002\u0010'\u001a\u00020\u00172\b\b\u0002\u0010(\u001a\u00020\u00172\b\b\u0002\u0010)\u001a\u00020\u00172\n\b\u0002\u0010*\u001a\u0004\u0018\u00010$2\b\b\u0002\u0010+\u001a\u00020\u00172\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-H\u0002J\u0010\u0010.\u001a\u00020\"2\u0006\u0010/\u001a\u00020\u001fH\u0002J\u0016\u00100\u001a\b\u0012\u0004\u0012\u000202012\u0006\u00103\u001a\u000204H\u0007J\u0012\u00105\u001a\u00020\u001b2\b\u00106\u001a\u0004\u0018\u000107H\u0007J\u0011\u00108\u001a\u00020\u001b2\u0006\u00109\u001a\u00020:H\u0096\u0001J\u0006\u0010;\u001a\u00020\u001dJ\u000e\u0010<\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020>J\u0010\u0010?\u001a\u00020\u001b2\u0006\u0010@\u001a\u00020AH\u0002J\u0010\u0010B\u001a\u00020\u001b2\u0006\u0010C\u001a\u00020DH\u0002J\u0010\u0010E\u001a\u00020\u001b2\u0006\u0010@\u001a\u00020FH\u0002J\u000e\u0010G\u001a\u00020\u001b2\u0006\u0010H\u001a\u00020IJ\u0010\u0010J\u001a\u00020\u001b2\u0006\u0010K\u001a\u00020LH\u0002J\f\u0010M\u001a\u00020N*\u00020OH\u0002J\f\u0010P\u001a\u00020Q*\u00020OH\u0002J\f\u0010R\u001a\u00020S*\u00020>H\u0002R(\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/PaymentCollectionCoordinatorWrapper;", "Lcom/stripe/jvmcore/paymentcollection/OnlineAuthStateListener;", "paymentCollectionCoordinator", "Lcom/stripe/core/paymentcollection/PaymentCollectionCoordinator;", "transactionRepository", "Lcom/stripe/core/transaction/TransactionRepository;", "settingsRepository", "Lcom/stripe/core/transaction/SettingsRepository;", "(Lcom/stripe/core/paymentcollection/PaymentCollectionCoordinator;Lcom/stripe/core/transaction/TransactionRepository;Lcom/stripe/core/transaction/SettingsRepository;)V", "value", "Lcom/stripe/jvmcore/transaction/CollectiblePayment;", "collectiblePayment", "getCollectiblePayment", "()Lcom/stripe/jvmcore/transaction/CollectiblePayment;", "setCollectiblePayment", "(Lcom/stripe/jvmcore/transaction/CollectiblePayment;)V", "paymentCollectionListener", "Lcom/stripe/core/paymentcollection/PaymentCollectionListener;", "getPaymentCollectionListener", "()Lcom/stripe/core/paymentcollection/PaymentCollectionListener;", "setPaymentCollectionListener", "(Lcom/stripe/core/paymentcollection/PaymentCollectionListener;)V", "supportsSca", "", "getSupportsSca", "()Z", "cancelCollectPaymentMethod", "", "collectPaymentMethod", "Lcom/stripe/stripeterminal/internal/models/PaymentMethodData;", "paymentMethodCollectionType", "Lcom/stripe/jvmcore/transaction/PaymentMethodCollectionType;", "collectPaymentMethodHelper", "transactionType", "Lcom/stripe/core/hardware/paymentcollection/TransactionType;", "amount", "Lcom/stripe/jvmcore/currency/Amount;", "scaRequirement", "Lcom/stripe/core/paymentcollection/SCARequirement;", "skipTipping", "manualEntry", "isOffline", "tipEligibleAmount", "isDeferredAuthorizationCountry", "domesticDebitPriority", "Lcom/stripe/jvmcore/hardware/ReaderConfiguration$DomesticDebitPriority;", "convertCollectionTypeToTransactionType", "collectionType", "handleAuthResponse", "Lkotlinx/coroutines/Deferred;", "Lcom/stripe/jvmcore/hardware/emv/TransactionResult;", "tlvBlob", "", "onChargeAttemptChanged", "chargeAttempt", "Lcom/stripe/jvmcore/transaction/ChargeAttempt;", "onOnlineAuthStateChanged", "state", "Lcom/stripe/jvmcore/paymentcollection/OnlineAuthState;", "readReusableCard", "setReaderDisplay", "cart", "Lcom/stripe/stripeterminal/external/models/Cart;", "updateCollectibleEmvPayment", "collectionResult", "Lcom/stripe/core/paymentcollection/EmvResult;", "updateCollectibleManualEntryPayment", "result", "Lcom/stripe/core/paymentcollection/ManualEntryResult;", "updateCollectibleMsrPayment", "Lcom/stripe/core/paymentcollection/MsrResult;", "updateDevicePaymentCapability", "reader", "Lcom/stripe/stripeterminal/external/models/Reader;", "updateTipResult", "tipResult", "Lcom/stripe/core/paymentcollection/TippingState$EndState;", "asFallbackReason", "Lcom/stripe/jvmcore/transaction/payment/MagstripePayment$FallbackReason;", "Lcom/stripe/jvmcore/hardware/magstripe/MagStripePaymentCollectionAuthority;", "asSwipeReason", "Lcom/stripe/stripeterminal/internal/models/SwipeReason;", "toCoreCart", "Lcom/stripe/jvmcore/cart/Cart;", "Companion", "Tuple", "adapter_release"})
@ExperimentalCoroutinesApi
@SourceDebugExtension(value={"SMAP\nPaymentCollectionCoordinatorWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentCollectionCoordinatorWrapper.kt\ncom/stripe/stripeterminal/internal/common/adapter/PaymentCollectionCoordinatorWrapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,384:1\n1549#2:385\n1620#2,3:386\n*S KotlinDebug\n*F\n+ 1 PaymentCollectionCoordinatorWrapper.kt\ncom/stripe/stripeterminal/internal/common/adapter/PaymentCollectionCoordinatorWrapper\n*L\n188#1:385\n188#1:386,3\n*E\n"})
public final class PaymentCollectionCoordinatorWrapper
implements OnlineAuthStateListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PaymentCollectionCoordinator paymentCollectionCoordinator;
    @NotNull
    private final TransactionRepository transactionRepository;
    @NotNull
    private final SettingsRepository settingsRepository;
    @Nullable
    private PaymentCollectionListener paymentCollectionListener;
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(PaymentCollectionCoordinatorWrapper.class);
    @NotNull
    private static final Amount REUSABLE_CARD_AMOUNT = new Amount(0L, CurrencyCode.USD);

    @Inject
    public PaymentCollectionCoordinatorWrapper(@NotNull PaymentCollectionCoordinator paymentCollectionCoordinator, @NotNull TransactionRepository transactionRepository, @NotNull SettingsRepository settingsRepository) {
        Intrinsics.checkNotNullParameter((Object)paymentCollectionCoordinator, (String)"paymentCollectionCoordinator");
        Intrinsics.checkNotNullParameter((Object)transactionRepository, (String)"transactionRepository");
        Intrinsics.checkNotNullParameter((Object)settingsRepository, (String)"settingsRepository");
        this.paymentCollectionCoordinator = paymentCollectionCoordinator;
        this.transactionRepository = transactionRepository;
        this.settingsRepository = settingsRepository;
    }

    @Override
    public void onOnlineAuthStateChanged(@NotNull OnlineAuthState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.paymentCollectionCoordinator.onOnlineAuthStateChanged(state);
    }

    @Nullable
    public final PaymentCollectionListener getPaymentCollectionListener() {
        return this.paymentCollectionListener;
    }

    public final void setPaymentCollectionListener(@Nullable PaymentCollectionListener paymentCollectionListener) {
        this.paymentCollectionListener = paymentCollectionListener;
    }

    private final boolean getSupportsSca() {
        return this.transactionRepository.getAllowExtendedTransactions();
    }

    @Nullable
    public final CollectiblePayment getCollectiblePayment() {
        return this.transactionRepository.getCollectiblePayment();
    }

    public final void setCollectiblePayment(@Nullable CollectiblePayment value) {
        this.transactionRepository.setCollectiblePayment(value);
    }

    @NotNull
    public final PaymentMethodData readReusableCard() {
        return PaymentCollectionCoordinatorWrapper.collectPaymentMethodHelper$default(this, com.stripe.core.hardware.paymentcollection.TransactionType.REUSABLE_CARD, REUSABLE_CARD_AMOUNT, null, false, false, false, null, false, null, 508, null);
    }

    public final void setReaderDisplay(@NotNull Cart cart) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)cart, (String)"cart");
            PaymentCollectionListener paymentCollectionListener = this.paymentCollectionListener;
            if (paymentCollectionListener == null) break block0;
            PaymentCollectionListener it = paymentCollectionListener;
            boolean bl = false;
            this.paymentCollectionCoordinator.displayCart(this.toCoreCart(cart), it);
        }
    }

    @NotNull
    public final PaymentMethodData collectPaymentMethod(@NotNull PaymentMethodCollectionType paymentMethodCollectionType) {
        SCARequirement sCARequirement;
        ReaderConfiguration.DomesticDebitPriority domesticDebitPriority;
        Amount tipEligibleAmount;
        boolean isDeferredAuthorizationCountry;
        boolean isOffline;
        boolean manualEntry;
        boolean skipTipping;
        Amount amount;
        com.stripe.core.hardware.paymentcollection.TransactionType transactionType;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)paymentMethodCollectionType, (String)"paymentMethodCollectionType");
                transactionType = this.convertCollectionTypeToTransactionType(paymentMethodCollectionType);
                amount = paymentMethodCollectionType.getAmount();
                PaymentMethodCollectionType paymentMethodCollectionType2 = paymentMethodCollectionType;
                Tuple<Boolean, Boolean, Boolean, Boolean, Amount, ReaderConfiguration.DomesticDebitPriority> tuple = paymentMethodCollectionType2 instanceof PaymentMethodCollectionType.Sale ? new Tuple<Boolean, Boolean, Boolean, Boolean, Amount, ReaderConfiguration.DomesticDebitPriority>(((PaymentMethodCollectionType.Sale)paymentMethodCollectionType).getSkipTipping(), ((PaymentMethodCollectionType.Sale)paymentMethodCollectionType).getManualEntry(), ((PaymentMethodCollectionType.Sale)paymentMethodCollectionType).isOffline(), ((PaymentMethodCollectionType.Sale)paymentMethodCollectionType).isDeferredAuthorizationCountry(), ((PaymentMethodCollectionType.Sale)paymentMethodCollectionType).getTipEligibleAmount(), ((PaymentMethodCollectionType.Sale)paymentMethodCollectionType).getDomesticDebitPriority()) : (paymentMethodCollectionType2 instanceof PaymentMethodCollectionType.SetupIntent ? new Tuple<Boolean, Boolean, Boolean, Boolean, Object, Object>(false, ((PaymentMethodCollectionType.SetupIntent)paymentMethodCollectionType).getManualEntry(), false, false, null, null) : new Tuple<Boolean, Boolean, Boolean, Boolean, Object, Object>(false, false, false, false, null, null));
                skipTipping = (Boolean)tuple.component1();
                manualEntry = (Boolean)tuple.component2();
                isOffline = tuple.component3();
                isDeferredAuthorizationCountry = tuple.component4();
                tipEligibleAmount = tuple.component5();
                domesticDebitPriority = tuple.component6();
                if (manualEntry && !skipTipping) {
                    LOGGER.w("Tipping is not supported for MOTO (manual entry) transactions, disabling tipping", new Pair[0]);
                    skipTipping = true;
                }
                if (!(paymentMethodCollectionType instanceof PaymentMethodCollectionType.StrongCustomerAuthentication)) break block5;
                switch (WhenMappings.$EnumSwitchMapping$0[((PaymentMethodCollectionType.StrongCustomerAuthentication)paymentMethodCollectionType).getRequirement().ordinal()]) {
                    case 1: {
                        sCARequirement = SCARequirement.GENERIC;
                        break block6;
                    }
                    case 2: {
                        sCARequirement = SCARequirement.ONLINE_OR_OFFLINE_PIN;
                        break block6;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            sCARequirement = null;
        }
        SCARequirement scaRequirement = sCARequirement;
        return this.collectPaymentMethodHelper(transactionType, amount, scaRequirement, skipTipping, manualEntry, isOffline, tipEligibleAmount, isDeferredAuthorizationCountry, domesticDebitPriority);
    }

    @ExperimentalCoroutinesApi
    public final void cancelCollectPaymentMethod() {
        this.paymentCollectionCoordinator.cancelPaymentMethodCollection();
    }

    @ExperimentalCoroutinesApi
    public final void onChargeAttemptChanged(@Nullable ChargeAttempt chargeAttempt) {
        block0: {
            ChargeAttempt chargeAttempt2 = chargeAttempt;
            if (chargeAttempt2 == null) break block0;
            ChargeAttempt it = chargeAttempt2;
            boolean bl = false;
            this.paymentCollectionCoordinator.updateChargeAttempt(chargeAttempt);
        }
    }

    @ExperimentalCoroutinesApi
    @NotNull
    public final Deferred<TransactionResult> handleAuthResponse(@NotNull String tlvBlob) {
        Intrinsics.checkNotNullParameter((Object)tlvBlob, (String)"tlvBlob");
        return this.paymentCollectionCoordinator.handleOnlineAuthResponse(tlvBlob);
    }

    public final void updateDevicePaymentCapability(@NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        PaymentCollectionDeviceCapability it = Adapter.Companion.getPaymentCollectionCapability(reader);
        boolean bl = false;
        LOGGER.i("Updating devicePaymentCapability to " + it, new Pair[0]);
        this.transactionRepository.setDevicePaymentCapability(it);
    }

    /*
     * WARNING - void declaration
     */
    private final com.stripe.jvmcore.cart.Cart toCoreCart(Cart $this$toCoreCart) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toCoreCart.getLineItems();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CartLineItem cartLineItem = (CartLineItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getDescription();
            int n2 = it.getQuantity();
            Amount amount = new Amount(it.getAmount(), $this$toCoreCart.getCurrency());
            List list = CollectionsKt.emptyList();
            List list2 = CollectionsKt.emptyList();
            collection.add(new Item(n2, string, amount, list, list2));
        }
        List list = (List)destination$iv$iv;
        Amount amount = new Amount($this$toCoreCart.getTax(), $this$toCoreCart.getCurrency());
        Amount amount2 = new Amount($this$toCoreCart.getTotal(), $this$toCoreCart.getCurrency());
        iterable = CollectionsKt.emptyList();
        List list3 = CollectionsKt.emptyList();
        List list4 = CollectionsKt.emptyList();
        return new com.stripe.jvmcore.cart.Cart(list, (List)iterable, list3, list4, amount, amount2);
    }

    private final PaymentMethodData collectPaymentMethodHelper(com.stripe.core.hardware.paymentcollection.TransactionType transactionType, Amount amount, SCARequirement scaRequirement, boolean skipTipping, boolean manualEntry, boolean isOffline, Amount tipEligibleAmount, boolean isDeferredAuthorizationCountry, ReaderConfiguration.DomesticDebitPriority domesticDebitPriority) throws TerminalException {
        PaymentMethodData paymentMethodData;
        this.setCollectiblePayment(null);
        PaymentCollectionListener paymentCollectionListener = this.paymentCollectionListener;
        if (paymentCollectionListener == null) {
            PaymentCollectionCoordinatorWrapper $this$collectPaymentMethodHelper_u24lambda_u245 = this;
            boolean bl = false;
            TerminalException $this$collectPaymentMethodHelper_u24lambda_u245_u24lambda_u244 = new TerminalException(TerminalException.TerminalErrorCode.NOT_CONNECTED_TO_READER, "No connected reader", null, null, 12, null);
            boolean bl2 = false;
            LOGGER.e("paymentCollectionListener is not set.", $this$collectPaymentMethodHelper_u24lambda_u245_u24lambda_u244, new Pair[0]);
            throw $this$collectPaymentMethodHelper_u24lambda_u245_u24lambda_u244;
        }
        PaymentCollectionListener listener2 = paymentCollectionListener;
        Amount tippingAmount = transactionType == com.stripe.core.hardware.paymentcollection.TransactionType.STRONG_CUSTOMER_AUTHENTICATION ? this.transactionRepository.getAmountTip() : null;
        PaymentCollectionResult paymentCollectionResult2 = (PaymentCollectionResult)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super PaymentCollectionResult>, Object>(this, amount, transactionType, listener2, scaRequirement, tippingAmount, skipTipping, manualEntry, isOffline, tipEligibleAmount, isDeferredAuthorizationCountry, domesticDebitPriority, null){
            int label;
            final /* synthetic */ PaymentCollectionCoordinatorWrapper this$0;
            final /* synthetic */ Amount $amount;
            final /* synthetic */ com.stripe.core.hardware.paymentcollection.TransactionType $transactionType;
            final /* synthetic */ PaymentCollectionListener $listener;
            final /* synthetic */ SCARequirement $scaRequirement;
            final /* synthetic */ Amount $tippingAmount;
            final /* synthetic */ boolean $skipTipping;
            final /* synthetic */ boolean $manualEntry;
            final /* synthetic */ boolean $isOffline;
            final /* synthetic */ Amount $tipEligibleAmount;
            final /* synthetic */ boolean $isDeferredAuthorizationCountry;
            final /* synthetic */ ReaderConfiguration.DomesticDebitPriority $domesticDebitPriority;
            {
                this.this$0 = $receiver;
                this.$amount = $amount;
                this.$transactionType = $transactionType;
                this.$listener = $listener;
                this.$scaRequirement = $scaRequirement;
                this.$tippingAmount = $tippingAmount;
                this.$skipTipping = $skipTipping;
                this.$manualEntry = $manualEntry;
                this.$isOffline = $isOffline;
                this.$tipEligibleAmount = $tipEligibleAmount;
                this.$isDeferredAuthorizationCountry = $isDeferredAuthorizationCountry;
                this.$domesticDebitPriority = $domesticDebitPriority;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = PaymentCollectionCoordinatorWrapper.access$getPaymentCollectionCoordinator$p(this.this$0).collectPaymentMethod(this.$amount, this.$transactionType, this.$listener, this.$scaRequirement, this.$tippingAmount, this.$skipTipping, this.$manualEntry, this.$isOffline, this.$tipEligibleAmount, this.$isDeferredAuthorizationCountry, this.$domesticDebitPriority).await((Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super PaymentCollectionResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        PaymentCollectionResult paymentCollectionResult3 = paymentCollectionResult2;
        if (paymentCollectionResult3 instanceof EmvResult) {
            Object object;
            this.updateCollectibleEmvPayment((EmvResult)paymentCollectionResult2);
            this.updateTipResult(((EmvResult)paymentCollectionResult2).getTipResult());
            paymentMethodData = new PaymentMethodData(((EmvResult)paymentCollectionResult2).getEmvBlob(), null, null, null, null, (object = this.getCollectiblePayment()) != null && (object = ((CollectiblePayment)object).getPayment()) != null ? ((Payment)object).asProtobuf() : null, null, 94, null);
        } else if (paymentCollectionResult3 instanceof MsrResult) {
            this.updateCollectibleMsrPayment((MsrResult)paymentCollectionResult2);
            this.updateTipResult(((MsrResult)paymentCollectionResult2).getTipResult());
            String string = ((MsrResult)paymentCollectionResult2).getMagStripeReadSuccess().getEncryptedTrack2();
            MagStripeReadSuccess magStripeReadSuccess = ((MsrResult)paymentCollectionResult2).getMagStripeReadSuccess();
            SwipeReason swipeReason = this.asSwipeReason(((MsrResult)paymentCollectionResult2).getCollectionAuthority());
            Object object = this.getCollectiblePayment();
            PaymentMethod paymentMethod = object != null && (object = ((CollectiblePayment)object).getPayment()) != null ? ((Payment)object).asProtobuf() : null;
            paymentMethodData = new PaymentMethodData(null, magStripeReadSuccess, swipeReason, string, null, paymentMethod, null, 81, null);
        } else if (paymentCollectionResult3 instanceof ManualEntryResult) {
            this.updateCollectibleManualEntryPayment((ManualEntryResult)paymentCollectionResult2);
            this.updateTipResult(((ManualEntryResult)paymentCollectionResult2).getTipResult());
            Object object = this.getCollectiblePayment();
            paymentMethodData = new PaymentMethodData(null, null, null, null, null, object != null && (object = ((CollectiblePayment)object).getPayment()) != null ? ((Payment)object).asProtobuf() : null, null, 95, null);
        } else {
            if (Intrinsics.areEqual((Object)paymentCollectionResult3, (Object)Cancelled.INSTANCE)) {
                throw new TerminalException(TerminalException.TerminalErrorCode.CANCELED, "User canceled the transaction.", null, null, 12, null);
            }
            if (Intrinsics.areEqual((Object)paymentCollectionResult3, (Object)Timeout.INSTANCE)) {
                throw new TerminalException(TerminalException.TerminalErrorCode.CARD_READ_TIMED_OUT, "Transaction timed out.", null, null, 12, null);
            }
            if (Intrinsics.areEqual((Object)paymentCollectionResult3, (Object)Failed.INSTANCE)) {
                throw new TerminalException(TerminalException.TerminalErrorCode.READER_COMMUNICATION_ERROR, "Transaction failed with unexpected reader failure.", null, null, 12, null);
            }
            throw new NoWhenBranchMatchedException();
        }
        return paymentMethodData;
    }

    static /* synthetic */ PaymentMethodData collectPaymentMethodHelper$default(PaymentCollectionCoordinatorWrapper paymentCollectionCoordinatorWrapper, com.stripe.core.hardware.paymentcollection.TransactionType transactionType, Amount amount, SCARequirement sCARequirement, boolean bl, boolean bl2, boolean bl3, Amount amount2, boolean bl4, ReaderConfiguration.DomesticDebitPriority domesticDebitPriority, int n2, Object object) throws TerminalException {
        if ((n2 & 4) != 0) {
            sCARequirement = null;
        }
        if ((n2 & 8) != 0) {
            bl = false;
        }
        if ((n2 & 0x10) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x20) != 0) {
            bl3 = false;
        }
        if ((n2 & 0x40) != 0) {
            amount2 = null;
        }
        if ((n2 & 0x80) != 0) {
            bl4 = false;
        }
        if ((n2 & 0x100) != 0) {
            domesticDebitPriority = null;
        }
        return paymentCollectionCoordinatorWrapper.collectPaymentMethodHelper(transactionType, amount, sCARequirement, bl, bl2, bl3, amount2, bl4, domesticDebitPriority);
    }

    private final void updateTipResult(TippingState.EndState tipResult) {
        Amount amount;
        TippingState.EndState endState = tipResult;
        if (Intrinsics.areEqual((Object)endState, (Object)TippingState.Ineligible.INSTANCE)) {
            amount = null;
        } else if (endState instanceof TippingState.Completed) {
            amount = ((TippingState.Completed)tipResult).getResult().getAmount();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.transactionRepository.setAmountTip(amount);
    }

    private final void updateCollectibleManualEntryPayment(ManualEntryResult result2) {
        this.setCollectiblePayment(new CollectiblePayment(new ManualEntryPayment(result2.getData().getEncPAN(), result2.getData().getExpiryDate(), result2.getData().getEncCVV(), result2.getData().getMaskedPan(), result2.getData().getKsn(), result2.getData().getPosEntryMode(), result2.getData().getZipCode()), null, false, 6, null));
    }

    private final SwipeReason asSwipeReason(MagStripePaymentCollectionAuthority $this$asSwipeReason) {
        SwipeReason swipeReason;
        switch (WhenMappings.$EnumSwitchMapping$1[$this$asSwipeReason.ordinal()]) {
            case 1: {
                swipeReason = SwipeReason.CHIP_ERROR;
                break;
            }
            case 2: {
                swipeReason = SwipeReason.CHIP_ERROR;
                break;
            }
            case 3: {
                swipeReason = SwipeReason.EMPTY_CANDIDATE_LIST;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return swipeReason;
    }

    private final com.stripe.core.hardware.paymentcollection.TransactionType convertCollectionTypeToTransactionType(PaymentMethodCollectionType collectionType) {
        com.stripe.core.hardware.paymentcollection.TransactionType transactionType;
        PaymentMethodCollectionType paymentMethodCollectionType = collectionType;
        if (paymentMethodCollectionType instanceof PaymentMethodCollectionType.Refund) {
            transactionType = com.stripe.core.hardware.paymentcollection.TransactionType.REFUND;
        } else if (paymentMethodCollectionType instanceof PaymentMethodCollectionType.Sale) {
            transactionType = com.stripe.core.hardware.paymentcollection.TransactionType.CHARGE;
        } else if (paymentMethodCollectionType instanceof PaymentMethodCollectionType.StrongCustomerAuthentication) {
            transactionType = com.stripe.core.hardware.paymentcollection.TransactionType.STRONG_CUSTOMER_AUTHENTICATION;
        } else if (paymentMethodCollectionType instanceof PaymentMethodCollectionType.SetupIntent) {
            transactionType = com.stripe.core.hardware.paymentcollection.TransactionType.SETUP;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return transactionType;
    }

    private final void updateCollectibleEmvPayment(EmvResult collectionResult) {
        TransactionType emvTransactionType = this.settingsRepository.getSettings().getEmvTransactionType();
        Object object = TlvMap.Companion.toTlvMap(collectionResult.getEmvBlob());
        if (object == null || (object = object.getSourceType()) == null) {
            object = SourceType.CARD_PRESENT;
        }
        Object sourceType = object;
        InterfaceType interfaceType = collectionResult.getInterfaceType();
        EmvPayment payment = new EmvPayment(collectionResult.getEmvBlob(), interfaceType, emvTransactionType, (SourceType)((Object)sourceType), false, 16, null);
        this.setCollectiblePayment(new CollectiblePayment(payment, interfaceType, this.getSupportsSca()));
    }

    private final void updateCollectibleMsrPayment(MsrResult collectionResult) {
        MagStripeReadSuccess readSuccess = collectionResult.getMagStripeReadSuccess();
        MagStripePaymentCollectionAuthority collectionAuthority = collectionResult.getCollectionAuthority();
        MagstripePayment payment = new MagstripePayment(readSuccess.getEncryptedTrack2(), readSuccess.getKsn(), readSuccess.getMaskedPan(), readSuccess.getExpiryDate(), this.asFallbackReason(collectionAuthority), readSuccess.getEpb(), readSuccess.getEpbKsn());
        this.setCollectiblePayment(new CollectiblePayment(payment, null, false, 6, null));
    }

    private final MagstripePayment.FallbackReason asFallbackReason(MagStripePaymentCollectionAuthority $this$asFallbackReason) {
        MagstripePayment.FallbackReason fallbackReason;
        switch (WhenMappings.$EnumSwitchMapping$1[$this$asFallbackReason.ordinal()]) {
            case 1: {
                fallbackReason = MagstripePayment.FallbackReason.NONE;
                break;
            }
            case 2: {
                fallbackReason = MagstripePayment.FallbackReason.CHIP_ERROR;
                break;
            }
            case 3: {
                fallbackReason = MagstripePayment.FallbackReason.EMPTY_CANDIDATE_LIST;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return fallbackReason;
    }

    public static final /* synthetic */ PaymentCollectionCoordinator access$getPaymentCollectionCoordinator$p(PaymentCollectionCoordinatorWrapper $this) {
        return $this.paymentCollectionCoordinator;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/PaymentCollectionCoordinatorWrapper$Companion;", "", "()V", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "REUSABLE_CARD_AMOUNT", "Lcom/stripe/jvmcore/currency/Amount;", "adapter_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u0003*\u0004\b\u0003\u0010\u0004*\u0004\b\u0004\u0010\u0005*\u0004\b\u0005\u0010\u00062\u00020\u0007B5\u0012\u0006\u0010\b\u001a\u00028\u0000\u0012\u0006\u0010\t\u001a\u00028\u0001\u0012\u0006\u0010\n\u001a\u00028\u0002\u0012\u0006\u0010\u000b\u001a\u00028\u0003\u0012\u0006\u0010\f\u001a\u00028\u0004\u0012\u0006\u0010\r\u001a\u00028\u0005\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u0015\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0016\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0017\u001a\u00028\u0002H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0018\u001a\u00028\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0019\u001a\u00028\u0004H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u001a\u001a\u00028\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010Jn\u0010\u001b\u001a&\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00002\b\b\u0002\u0010\b\u001a\u00028\u00002\b\b\u0002\u0010\t\u001a\u00028\u00012\b\b\u0002\u0010\n\u001a\u00028\u00022\b\b\u0002\u0010\u000b\u001a\u00028\u00032\b\b\u0002\u0010\f\u001a\u00028\u00042\b\b\u0002\u0010\r\u001a\u00028\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u001cJ\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0013\u0010\r\u001a\u00028\u0005\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u000b\u001a\u00028\u0003\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000b\u0010\u0010R\u0013\u0010\n\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\n\u0010\u0010R\u0013\u0010\t\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u0012\u0010\u0010R\u0013\u0010\b\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u0013\u0010\u0010R\u0013\u0010\f\u001a\u00028\u0004\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u0014\u0010\u0010\u00a8\u0006$"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/PaymentCollectionCoordinatorWrapper$Tuple;", "A", "B", "C", "D", "E", "F", "", "skipTipping", "manualEntry", "isOffline", "isDeferredAuthorizationCountry", "tipEligibleAmount", "domesticDebitPriority", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "getDomesticDebitPriority", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getManualEntry", "getSkipTipping", "getTipEligibleAmount", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Lcom/stripe/stripeterminal/internal/common/adapter/PaymentCollectionCoordinatorWrapper$Tuple;", "equals", "", "other", "hashCode", "", "toString", "", "adapter_release"})
    public static final class Tuple<A, B, C, D, E, F> {
        private final A skipTipping;
        private final B manualEntry;
        private final C isOffline;
        private final D isDeferredAuthorizationCountry;
        private final E tipEligibleAmount;
        private final F domesticDebitPriority;

        public Tuple(A skipTipping, B manualEntry, C isOffline, D isDeferredAuthorizationCountry, E tipEligibleAmount, F domesticDebitPriority) {
            this.skipTipping = skipTipping;
            this.manualEntry = manualEntry;
            this.isOffline = isOffline;
            this.isDeferredAuthorizationCountry = isDeferredAuthorizationCountry;
            this.tipEligibleAmount = tipEligibleAmount;
            this.domesticDebitPriority = domesticDebitPriority;
        }

        public final A getSkipTipping() {
            return this.skipTipping;
        }

        public final B getManualEntry() {
            return this.manualEntry;
        }

        public final C isOffline() {
            return this.isOffline;
        }

        public final D isDeferredAuthorizationCountry() {
            return this.isDeferredAuthorizationCountry;
        }

        public final E getTipEligibleAmount() {
            return this.tipEligibleAmount;
        }

        public final F getDomesticDebitPriority() {
            return this.domesticDebitPriority;
        }

        public final A component1() {
            return this.skipTipping;
        }

        public final B component2() {
            return this.manualEntry;
        }

        public final C component3() {
            return this.isOffline;
        }

        public final D component4() {
            return this.isDeferredAuthorizationCountry;
        }

        public final E component5() {
            return this.tipEligibleAmount;
        }

        public final F component6() {
            return this.domesticDebitPriority;
        }

        @NotNull
        public final Tuple<A, B, C, D, E, F> copy(A skipTipping, B manualEntry, C isOffline, D isDeferredAuthorizationCountry, E tipEligibleAmount, F domesticDebitPriority) {
            return new Tuple<A, B, C, D, E, F>(skipTipping, manualEntry, isOffline, isDeferredAuthorizationCountry, tipEligibleAmount, domesticDebitPriority);
        }

        public static /* synthetic */ Tuple copy$default(Tuple tuple, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, int n2, Object object7) {
            if ((n2 & 1) != 0) {
                object = tuple.skipTipping;
            }
            if ((n2 & 2) != 0) {
                object2 = tuple.manualEntry;
            }
            if ((n2 & 4) != 0) {
                object3 = tuple.isOffline;
            }
            if ((n2 & 8) != 0) {
                object4 = tuple.isDeferredAuthorizationCountry;
            }
            if ((n2 & 0x10) != 0) {
                object5 = tuple.tipEligibleAmount;
            }
            if ((n2 & 0x20) != 0) {
                object6 = tuple.domesticDebitPriority;
            }
            return tuple.copy(object, object2, object3, object4, object5, object6);
        }

        @NotNull
        public String toString() {
            return "Tuple(skipTipping=" + this.skipTipping + ", manualEntry=" + this.manualEntry + ", isOffline=" + this.isOffline + ", isDeferredAuthorizationCountry=" + this.isDeferredAuthorizationCountry + ", tipEligibleAmount=" + this.tipEligibleAmount + ", domesticDebitPriority=" + this.domesticDebitPriority + ')';
        }

        public int hashCode() {
            int result2 = this.skipTipping == null ? 0 : this.skipTipping.hashCode();
            result2 = result2 * 31 + (this.manualEntry == null ? 0 : this.manualEntry.hashCode());
            result2 = result2 * 31 + (this.isOffline == null ? 0 : this.isOffline.hashCode());
            result2 = result2 * 31 + (this.isDeferredAuthorizationCountry == null ? 0 : this.isDeferredAuthorizationCountry.hashCode());
            result2 = result2 * 31 + (this.tipEligibleAmount == null ? 0 : this.tipEligibleAmount.hashCode());
            result2 = result2 * 31 + (this.domesticDebitPriority == null ? 0 : this.domesticDebitPriority.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Tuple)) {
                return false;
            }
            Tuple tuple = (Tuple)other;
            if (!Intrinsics.areEqual(this.skipTipping, tuple.skipTipping)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.manualEntry, tuple.manualEntry)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.isOffline, tuple.isOffline)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.isDeferredAuthorizationCountry, tuple.isDeferredAuthorizationCountry)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.tipEligibleAmount, tuple.tipEligibleAmount)) {
                return false;
            }
            return Intrinsics.areEqual(this.domesticDebitPriority, tuple.domesticDebitPriority);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PaymentMethodCollectionType.StrongCustomerAuthentication.Requirement.values().length];
            try {
                nArray[PaymentMethodCollectionType.StrongCustomerAuthentication.Requirement.GENERIC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentMethodCollectionType.StrongCustomerAuthentication.Requirement.ONLINE_OR_OFFLINE_PIN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[MagStripePaymentCollectionAuthority.values().length];
            try {
                nArray[MagStripePaymentCollectionAuthority.NON_ICC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MagStripePaymentCollectionAuthority.TECHNICAL_FALLBACK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MagStripePaymentCollectionAuthority.EMPTY_CANDIDATE_LIST_FALLBACK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

