/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.adapter;

import androidx.annotation.VisibleForTesting;
import com.stripe.jvmcore.hardware.emv.TransactionResult;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.paymentcollection.OnlineAuthState;
import com.stripe.jvmcore.terminal.api.ActivateReaderResponse;
import com.stripe.jvmcore.transaction.ChargeAttempt;
import com.stripe.jvmcore.transaction.CollectiblePayment;
import com.stripe.jvmcore.transaction.PaymentMethodCollectionType;
import com.stripe.stripeterminal.external.InternalApi;
import com.stripe.stripeterminal.external.callable.Cancelable;
import com.stripe.stripeterminal.external.callable.DiscoveryListener;
import com.stripe.stripeterminal.external.models.Cart;
import com.stripe.stripeterminal.external.models.CollectInputsParameters;
import com.stripe.stripeterminal.external.models.ConnectionConfiguration;
import com.stripe.stripeterminal.external.models.DeviceType;
import com.stripe.stripeterminal.external.models.DiscoveryConfiguration;
import com.stripe.stripeterminal.external.models.DiscoveryMethod;
import com.stripe.stripeterminal.external.models.Reader;
import com.stripe.stripeterminal.external.models.ReaderBatteryInfo;
import com.stripe.stripeterminal.external.models.ReaderSoftwareUpdate;
import com.stripe.stripeterminal.external.models.ReaderSupportResult;
import com.stripe.stripeterminal.external.models.TerminalException;
import com.stripe.stripeterminal.internal.common.Adapter;
import com.stripe.stripeterminal.internal.common.adapter.BbposBluetoothAdapter;
import com.stripe.stripeterminal.internal.common.adapter.BbposBluetoothAdapterLegacy;
import com.stripe.stripeterminal.internal.common.adapter.BbposUsbAdapter;
import com.stripe.stripeterminal.internal.common.adapter.BbposUsbAdapterLegacy;
import com.stripe.stripeterminal.internal.common.adapter.CotsAdapter;
import com.stripe.stripeterminal.internal.common.adapter.ProxiedAdapter;
import com.stripe.stripeterminal.internal.common.adapter.RemoteReaderAdapter;
import com.stripe.stripeterminal.internal.common.adapter.SimulatedBluetoothAdapter;
import com.stripe.stripeterminal.internal.common.adapter.SimulatedIpAdapter;
import com.stripe.stripeterminal.internal.common.adapter.SimulatedUsbAdapter;
import com.stripe.stripeterminal.internal.common.forms.CollectInputsResult;
import com.stripe.stripeterminal.internal.models.PaymentMethodData;
import dagger.Lazy;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.ExperimentalCoroutinesApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0084\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0089\u0001\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0003\u0012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0003\u0012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\u0002\u0010\u001aJ\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020&H\u0016J\u0010\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020\u0019H\u0016J\b\u0010*\u001a\u00020&H\u0016J\b\u0010+\u001a\u00020&H\u0016J\u0012\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020\u0019H\u0016J\b\u0010/\u001a\u00020&H\u0016J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0017J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J\n\u00108\u001a\u0004\u0018\u000109H\u0016J\b\u0010:\u001a\u00020&H\u0016J\u0018\u0010;\u001a\u00020&2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0016J\u001c\u0010@\u001a\u0004\u0018\u00010\u00012\u0006\u0010A\u001a\u00020B2\b\b\u0002\u0010C\u001a\u00020\u0019H\u0002J\n\u0010D\u001a\u0004\u0018\u00010\u0001H\u0007J\u0016\u0010E\u001a\b\u0012\u0004\u0012\u00020G0F2\u0006\u0010H\u001a\u00020IH\u0016J\u0010\u0010J\u001a\u00020&2\u0006\u0010K\u001a\u00020-H\u0016J\u0012\u0010L\u001a\u00020&2\b\u0010M\u001a\u0004\u0018\u00010NH\u0016J(\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020P2\u0006\u0010R\u001a\u00020S2\u000e\u0010T\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010UH\u0014J\u0010\u0010V\u001a\u00020&2\u0006\u0010W\u001a\u00020XH\u0016J\u0018\u0010Y\u001a\u00020&2\u0006\u0010Q\u001a\u00020P2\u0006\u0010Z\u001a\u00020[H\u0016J\b\u0010\\\u001a\u000205H\u0016J\u0018\u0010]\u001a\u00020P2\u0006\u0010Q\u001a\u00020P2\u0006\u0010^\u001a\u00020_H\u0016J\u0016\u0010`\u001a\u00020a2\f\u0010b\u001a\b\u0012\u0004\u0012\u00020&0UH\u0016J\u0010\u0010c\u001a\u00020&2\u0006\u0010d\u001a\u00020eH\u0016J\u0010\u0010f\u001a\u00020&2\u0006\u0010Q\u001a\u00020PH\u0016J \u0010g\u001a\u00020h2\u0006\u0010i\u001a\u00020j2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\u0019H\u0016J\b\u0010k\u001a\u00020&H\u0002J\u0012\u0010l\u001a\u00020&2\b\u0010m\u001a\u0004\u0018\u00010\u0001H\u0002R\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\u0004\u0018\u00010\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001eR\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006n"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/ProxyAdapter;", "Lcom/stripe/stripeterminal/internal/common/Adapter;", "bluetoothAdapterLegacyProvider", "Ldagger/Lazy;", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposBluetoothAdapterLegacy;", "bluetoothAdapterProvider", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposBluetoothAdapter;", "cotsAdapter", "Lcom/stripe/stripeterminal/internal/common/adapter/CotsAdapter;", "simulatedCotsAdapter", "remoteReaderAdapter", "Lcom/stripe/stripeterminal/internal/common/adapter/RemoteReaderAdapter;", "simulatedBluetoothAdapter", "Lcom/stripe/stripeterminal/internal/common/adapter/SimulatedBluetoothAdapter;", "simulatedIpAdapter", "Lcom/stripe/stripeterminal/internal/common/adapter/SimulatedIpAdapter;", "simulatedUsbAdapter", "Lcom/stripe/stripeterminal/internal/common/adapter/SimulatedUsbAdapter;", "embeddedAdapter", "usbAdapterLegacyProvider", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposUsbAdapterLegacy;", "usbAdapterProvider", "Lcom/stripe/stripeterminal/internal/common/adapter/BbposUsbAdapter;", "connectAndCollectForMPos", "Ljavax/inject/Provider;", "", "(Ldagger/Lazy;Ldagger/Lazy;Lcom/stripe/stripeterminal/internal/common/adapter/CotsAdapter;Lcom/stripe/stripeterminal/internal/common/adapter/CotsAdapter;Lcom/stripe/stripeterminal/internal/common/adapter/RemoteReaderAdapter;Lcom/stripe/stripeterminal/internal/common/adapter/SimulatedBluetoothAdapter;Lcom/stripe/stripeterminal/internal/common/adapter/SimulatedIpAdapter;Lcom/stripe/stripeterminal/internal/common/adapter/SimulatedUsbAdapter;Lcom/stripe/stripeterminal/internal/common/Adapter;Ldagger/Lazy;Ldagger/Lazy;Ljavax/inject/Provider;)V", "bluetoothAdapter", "Lcom/stripe/stripeterminal/internal/common/adapter/ProxiedAdapter;", "getBluetoothAdapter", "()Lcom/stripe/stripeterminal/internal/common/adapter/ProxiedAdapter;", "currentAdapter", "immediateRecollectForSca", "getImmediateRecollectForSca", "()Z", "usbAdapter", "getUsbAdapter", "cancelCollectInputs", "", "cancelCollectPaymentMethod", "cancelDiscoverReaders", "cancelSilently", "cancelInstallUpdate", "cancelReconnectReader", "checkForUpdate", "Lcom/stripe/stripeterminal/external/models/ReaderSoftwareUpdate;", "failSilently", "clearReaderDisplay", "collectInputsBlocking", "Lcom/stripe/stripeterminal/internal/common/forms/CollectInputsResult;", "collectInputsParameters", "Lcom/stripe/stripeterminal/external/models/CollectInputsParameters;", "collectPaymentMethod", "Lcom/stripe/stripeterminal/internal/models/PaymentMethodData;", "paymentMethodCollectionType", "Lcom/stripe/jvmcore/transaction/PaymentMethodCollectionType;", "collectiblePayment", "Lcom/stripe/jvmcore/transaction/CollectiblePayment;", "disconnectReader", "discoverReaders", "config", "Lcom/stripe/stripeterminal/external/models/DiscoveryConfiguration;", "listener", "Lcom/stripe/stripeterminal/external/callable/DiscoveryListener;", "getAdapterByDiscoveryMethod", "discoveryMethod", "Lcom/stripe/stripeterminal/external/models/DiscoveryMethod;", "simulated", "getCurrentAdapter", "handleAuthResponse", "Lkotlinx/coroutines/Deferred;", "Lcom/stripe/jvmcore/hardware/emv/TransactionResult;", "tlvBlob", "", "installUpdate", "update", "onChargeAttemptChanged", "chargeAttempt", "Lcom/stripe/jvmcore/transaction/ChargeAttempt;", "onConnectReader", "Lcom/stripe/stripeterminal/external/models/Reader;", "reader", "connectionConfiguration", "Lcom/stripe/stripeterminal/external/models/ConnectionConfiguration;", "requestReconnection", "Lkotlin/Function0;", "onOnlineAuthStateChanged", "state", "Lcom/stripe/jvmcore/paymentcollection/OnlineAuthState;", "onReaderActivated", "response", "Lcom/stripe/jvmcore/terminal/api/ActivateReaderResponse;", "readReusableCard", "reconnectReader", "cancelReconnect", "Lcom/stripe/stripeterminal/external/callable/Cancelable;", "requestReaderBatteryInfo", "Lcom/stripe/stripeterminal/external/models/ReaderBatteryInfo;", "endPolling", "setReaderDisplay", "cart", "Lcom/stripe/stripeterminal/external/models/Cart;", "startSession", "supportsReadersOfType", "Lcom/stripe/stripeterminal/external/models/ReaderSupportResult;", "deviceType", "Lcom/stripe/stripeterminal/external/models/DeviceType;", "switchAdapterIfFeatureFlagChanged", "switchToAdapter", "newAdapter", "adapter_release"})
@ExperimentalCoroutinesApi
@SourceDebugExtension(value={"SMAP\nProxyAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProxyAdapter.kt\ncom/stripe/stripeterminal/internal/common/adapter/ProxyAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,350:1\n1#2:351\n*E\n"})
public final class ProxyAdapter
extends Adapter {
    @NotNull
    private final Lazy<BbposBluetoothAdapterLegacy> bluetoothAdapterLegacyProvider;
    @NotNull
    private final Lazy<BbposBluetoothAdapter> bluetoothAdapterProvider;
    @Nullable
    private final CotsAdapter cotsAdapter;
    @Nullable
    private final CotsAdapter simulatedCotsAdapter;
    @NotNull
    private final RemoteReaderAdapter remoteReaderAdapter;
    @NotNull
    private final SimulatedBluetoothAdapter simulatedBluetoothAdapter;
    @NotNull
    private final SimulatedIpAdapter simulatedIpAdapter;
    @NotNull
    private final SimulatedUsbAdapter simulatedUsbAdapter;
    @Nullable
    private final Adapter embeddedAdapter;
    @NotNull
    private final Lazy<BbposUsbAdapterLegacy> usbAdapterLegacyProvider;
    @NotNull
    private final Lazy<BbposUsbAdapter> usbAdapterProvider;
    @NotNull
    private final Provider<Boolean> connectAndCollectForMPos;
    @Nullable
    private Adapter currentAdapter;

    public ProxyAdapter(@NotNull Lazy<BbposBluetoothAdapterLegacy> bluetoothAdapterLegacyProvider, @NotNull Lazy<BbposBluetoothAdapter> bluetoothAdapterProvider, @Nullable CotsAdapter cotsAdapter, @Nullable CotsAdapter simulatedCotsAdapter, @NotNull RemoteReaderAdapter remoteReaderAdapter, @NotNull SimulatedBluetoothAdapter simulatedBluetoothAdapter, @NotNull SimulatedIpAdapter simulatedIpAdapter, @NotNull SimulatedUsbAdapter simulatedUsbAdapter, @Nullable Adapter embeddedAdapter, @NotNull Lazy<BbposUsbAdapterLegacy> usbAdapterLegacyProvider, @NotNull Lazy<BbposUsbAdapter> usbAdapterProvider, @NotNull Provider<Boolean> connectAndCollectForMPos) {
        Intrinsics.checkNotNullParameter(bluetoothAdapterLegacyProvider, (String)"bluetoothAdapterLegacyProvider");
        Intrinsics.checkNotNullParameter(bluetoothAdapterProvider, (String)"bluetoothAdapterProvider");
        Intrinsics.checkNotNullParameter((Object)remoteReaderAdapter, (String)"remoteReaderAdapter");
        Intrinsics.checkNotNullParameter((Object)simulatedBluetoothAdapter, (String)"simulatedBluetoothAdapter");
        Intrinsics.checkNotNullParameter((Object)simulatedIpAdapter, (String)"simulatedIpAdapter");
        Intrinsics.checkNotNullParameter((Object)simulatedUsbAdapter, (String)"simulatedUsbAdapter");
        Intrinsics.checkNotNullParameter(usbAdapterLegacyProvider, (String)"usbAdapterLegacyProvider");
        Intrinsics.checkNotNullParameter(usbAdapterProvider, (String)"usbAdapterProvider");
        Intrinsics.checkNotNullParameter(connectAndCollectForMPos, (String)"connectAndCollectForMPos");
        super(Log.Companion.getLogger(ProxyAdapter.class));
        this.bluetoothAdapterLegacyProvider = bluetoothAdapterLegacyProvider;
        this.bluetoothAdapterProvider = bluetoothAdapterProvider;
        this.cotsAdapter = cotsAdapter;
        this.simulatedCotsAdapter = simulatedCotsAdapter;
        this.remoteReaderAdapter = remoteReaderAdapter;
        this.simulatedBluetoothAdapter = simulatedBluetoothAdapter;
        this.simulatedIpAdapter = simulatedIpAdapter;
        this.simulatedUsbAdapter = simulatedUsbAdapter;
        this.embeddedAdapter = embeddedAdapter;
        this.usbAdapterLegacyProvider = usbAdapterLegacyProvider;
        this.usbAdapterProvider = usbAdapterProvider;
        this.connectAndCollectForMPos = connectAndCollectForMPos;
    }

    private final ProxiedAdapter getBluetoothAdapter() {
        ProxiedAdapter proxiedAdapter;
        if (this.embeddedAdapter != null) {
            proxiedAdapter = null;
        } else {
            Object object = this.connectAndCollectForMPos.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"connectAndCollectForMPos.get()");
            proxiedAdapter = (Boolean)object != false ? (ProxiedAdapter)this.bluetoothAdapterProvider.get() : (ProxiedAdapter)this.bluetoothAdapterLegacyProvider.get();
        }
        return proxiedAdapter;
    }

    private final ProxiedAdapter getUsbAdapter() {
        ProxiedAdapter proxiedAdapter;
        if (this.embeddedAdapter != null) {
            proxiedAdapter = null;
        } else {
            Object object = this.connectAndCollectForMPos.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"connectAndCollectForMPos.get()");
            proxiedAdapter = (Boolean)object != false ? (ProxiedAdapter)this.usbAdapterProvider.get() : (ProxiedAdapter)this.usbAdapterLegacyProvider.get();
        }
        return proxiedAdapter;
    }

    @Override
    public boolean getImmediateRecollectForSca() {
        Adapter adapter = this.currentAdapter;
        return adapter != null ? adapter.getImmediateRecollectForSca() : true;
    }

    @VisibleForTesting
    @Nullable
    public final Adapter getCurrentAdapter() {
        return this.currentAdapter;
    }

    @Override
    public void onReaderActivated(@NotNull Reader reader, @NotNull ActivateReaderResponse response) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            Adapter adapter = this.currentAdapter;
            if (adapter == null) break block0;
            adapter.onReaderActivated(reader, response);
        }
    }

    @Override
    public void onChargeAttemptChanged(@Nullable ChargeAttempt chargeAttempt) {
        block0: {
            Adapter adapter = this.currentAdapter;
            if (adapter == null) break block0;
            adapter.onChargeAttemptChanged(chargeAttempt);
        }
    }

    @Override
    public void cancelCollectPaymentMethod() {
        block0: {
            Adapter adapter = this.currentAdapter;
            if (adapter == null) break block0;
            adapter.cancelCollectPaymentMethod();
        }
    }

    @Override
    public void cancelDiscoverReaders(boolean cancelSilently) {
        block0: {
            Adapter adapter = this.currentAdapter;
            if (adapter == null) break block0;
            adapter.cancelDiscoverReaders(cancelSilently);
        }
    }

    @Override
    public void cancelInstallUpdate() {
        block0: {
            Adapter adapter = this.currentAdapter;
            if (adapter == null) break block0;
            adapter.cancelInstallUpdate();
        }
    }

    @Override
    @Nullable
    public ReaderSoftwareUpdate checkForUpdate(boolean failSilently) throws TerminalException {
        Adapter adapter = this.currentAdapter;
        if (adapter != null) {
            Adapter it = adapter;
            boolean bl = false;
            return it.checkForUpdate(failSilently);
        }
        throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "DiscoverReaders must be called before checkForUpdate", null, null, 12, null);
    }

    @Override
    @NotNull
    public ReaderSupportResult supportsReadersOfType(@NotNull DeviceType deviceType, @NotNull DiscoveryMethod discoveryMethod, boolean simulated) {
        Object object;
        Object object2;
        Object object3;
        Object it;
        Object $this$supportsReadersOfType_u24lambda_u241;
        Intrinsics.checkNotNullParameter((Object)deviceType, (String)"deviceType");
        Intrinsics.checkNotNullParameter((Object)discoveryMethod, (String)"discoveryMethod");
        Object object4 = this;
        try {
            $this$supportsReadersOfType_u24lambda_u241 = object4;
            boolean bl = false;
            $this$supportsReadersOfType_u24lambda_u241 = Result.constructor-impl((Object)super.getAdapterByDiscoveryMethod(discoveryMethod, simulated));
        }
        catch (Throwable bl) {
            $this$supportsReadersOfType_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object4 = $this$supportsReadersOfType_u24lambda_u241;
        if (Result.isSuccess-impl((Object)object4)) {
            it = (Adapter)object4;
            boolean bl = false;
            Adapter adapter = it;
            object3 = Result.constructor-impl(adapter != null ? adapter.supportsReadersOfType(deviceType, discoveryMethod, simulated) : null);
        } else {
            object3 = object4 = Result.constructor-impl((Object)object4);
        }
        if (Result.isSuccess-impl((Object)object4)) {
            it = (ReaderSupportResult)object4;
            boolean bl = false;
            Object object5 = it;
            if (object5 == null) {
                object5 = (ReaderSupportResult)new ReaderSupportResult.NotSupported((Throwable)new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "No Adapter for type", null, null, 12, null));
            }
            object2 = Result.constructor-impl((Object)object5);
        } else {
            object2 = Result.constructor-impl((Object)object4);
        }
        object4 = object2;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object4);
        if (throwable == null) {
            object = object4;
        } else {
            it = throwable;
            boolean bl = false;
            object = (ReaderSupportResult)new ReaderSupportResult.NotSupported((Throwable)it);
        }
        return (ReaderSupportResult)object;
    }

    @Override
    public void clearReaderDisplay() {
        Unit unit;
        Adapter adapter = this.currentAdapter;
        if (adapter != null) {
            adapter.clearReaderDisplay();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "DiscoverReaders must be called before clearReaderDisplay", null, null, 12, null);
        }
    }

    @Override
    @NotNull
    public PaymentMethodData collectPaymentMethod(@NotNull PaymentMethodCollectionType paymentMethodCollectionType) throws TerminalException {
        Intrinsics.checkNotNullParameter((Object)paymentMethodCollectionType, (String)"paymentMethodCollectionType");
        this.switchAdapterIfFeatureFlagChanged();
        Adapter adapter = this.currentAdapter;
        if (adapter == null || (adapter = adapter.collectPaymentMethod(paymentMethodCollectionType)) == null) {
            throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "DiscoverReaders must be called before collectPaymentMethod", null, null, 12, null);
        }
        return adapter;
    }

    @Override
    @NotNull
    protected Reader onConnectReader(@NotNull Reader reader, @NotNull ConnectionConfiguration connectionConfiguration, @Nullable Function0<Unit> requestReconnection) throws TerminalException {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)connectionConfiguration, (String)"connectionConfiguration");
        Adapter adapter = this.currentAdapter;
        if (adapter == null || (adapter = adapter.connectReader(reader, connectionConfiguration, requestReconnection)) == null) {
            throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "DiscoverReaders must be called before connectReader", null, null, 12, null);
        }
        return adapter;
    }

    @Override
    public void cancelReconnectReader() {
        Unit unit;
        Adapter adapter = this.currentAdapter;
        if (adapter != null) {
            adapter.cancelReconnectReader();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "reconnectReader must be called before cancelReconnectReader", null, null, 12, null);
        }
    }

    @Override
    @NotNull
    public Reader reconnectReader(@NotNull Reader reader, @NotNull Cancelable cancelReconnect) throws TerminalException {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)cancelReconnect, (String)"cancelReconnect");
        Adapter adapter = this.currentAdapter;
        if (!(((adapter instanceof BbposBluetoothAdapterLegacy ? true : adapter instanceof BbposBluetoothAdapter) ? true : adapter instanceof BbposUsbAdapterLegacy) ? true : adapter instanceof BbposUsbAdapter)) {
            if (adapter == null) {
                throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "reconnectReader is not supported for your reader", null, null, 12, null);
            }
            throw new TerminalException(TerminalException.TerminalErrorCode.UNSUPPORTED_OPERATION, "reconnectReader is not supported for your reader", null, null, 12, null);
        }
        return adapter.reconnectReader(reader, cancelReconnect);
    }

    @Override
    public void disconnectReader() throws TerminalException {
        block0: {
            Adapter adapter = this.currentAdapter;
            if (adapter == null) break block0;
            adapter.disconnectReader();
        }
    }

    @Override
    public void discoverReaders(@NotNull DiscoveryConfiguration config, @NotNull DiscoveryListener listener2) throws TerminalException {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Adapter newAdapter = this.getAdapterByDiscoveryMethod(config.getDiscoveryMethod(), config.isSimulated());
        this.switchToAdapter(newAdapter);
        Adapter adapter = this.currentAdapter;
        if (adapter != null) {
            adapter.discoverReaders(config, listener2);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "No DeviceType selected", null, null, 12, null);
        }
    }

    private final Adapter getAdapterByDiscoveryMethod(DiscoveryMethod discoveryMethod, boolean simulated) {
        Adapter adapter;
        switch (WhenMappings.$EnumSwitchMapping$0[discoveryMethod.ordinal()]) {
            case 1: {
                CotsAdapter cotsAdapter = simulated ? this.simulatedCotsAdapter : this.cotsAdapter;
                if (cotsAdapter == null) {
                    throw new TerminalException(TerminalException.TerminalErrorCode.LOCAL_MOBILE_LIBRARY_NOT_INCLUDED, "The Terminal `localmobile` module must be included for this DiscoveryMethod", null, null, 12, null);
                }
                adapter = cotsAdapter;
                break;
            }
            case 2: {
                adapter = simulated ? (ProxiedAdapter)this.simulatedBluetoothAdapter : this.getBluetoothAdapter();
                break;
            }
            case 3: {
                adapter = simulated ? (ProxiedAdapter)this.simulatedIpAdapter : (ProxiedAdapter)this.remoteReaderAdapter;
                break;
            }
            case 4: {
                adapter = this.embeddedAdapter;
                if (adapter != null) break;
                throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "The Terminal `embedded` module must be included for this DiscoveryMethod", null, null, 12, null);
            }
            case 5: {
                adapter = this.remoteReaderAdapter;
                break;
            }
            case 6: {
                adapter = simulated ? (ProxiedAdapter)this.simulatedUsbAdapter : this.getUsbAdapter();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return adapter;
    }

    static /* synthetic */ Adapter getAdapterByDiscoveryMethod$default(ProxyAdapter proxyAdapter, DiscoveryMethod discoveryMethod, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return proxyAdapter.getAdapterByDiscoveryMethod(discoveryMethod, bl);
    }

    private final void switchToAdapter(Adapter newAdapter) {
        if (!Intrinsics.areEqual((Object)newAdapter, (Object)this.currentAdapter)) {
            Object object;
            Object object2;
            this.getLogger().d("Switching from " + ((object2 = this.currentAdapter) != null && (object2 = object2.getClass()) != null ? ((Class)object2).getSimpleName() : null) + " to " + ((object = newAdapter) != null && (object = object.getClass()) != null ? ((Class)object).getSimpleName() : null), new Pair[0]);
            Adapter adapter = this.currentAdapter;
            if (adapter != null) {
                adapter.dispose();
            }
            Adapter adapter2 = newAdapter;
            if (adapter2 != null) {
                adapter2.init();
            }
            this.currentAdapter = newAdapter;
        }
    }

    private final void switchAdapterIfFeatureFlagChanged() {
        if (this.currentAdapter instanceof BbposBluetoothAdapter || this.currentAdapter instanceof BbposBluetoothAdapterLegacy) {
            this.switchToAdapter(this.getBluetoothAdapter());
        } else if (this.currentAdapter instanceof BbposUsbAdapter || this.currentAdapter instanceof BbposUsbAdapterLegacy) {
            this.switchToAdapter(this.getUsbAdapter());
        }
    }

    @Override
    public void installUpdate(@NotNull ReaderSoftwareUpdate update2) throws TerminalException {
        block0: {
            Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
            Adapter adapter = this.currentAdapter;
            if (adapter == null) break block0;
            adapter.installUpdate(update2);
        }
    }

    @Override
    @Nullable
    public CollectiblePayment collectiblePayment() {
        Adapter adapter = this.currentAdapter;
        Intrinsics.checkNotNull((Object)adapter);
        return adapter.collectiblePayment();
    }

    @Override
    @NotNull
    public Deferred<TransactionResult> handleAuthResponse(@NotNull String tlvBlob) {
        Intrinsics.checkNotNullParameter((Object)tlvBlob, (String)"tlvBlob");
        Adapter adapter = this.currentAdapter;
        Intrinsics.checkNotNull((Object)adapter);
        return adapter.handleAuthResponse(tlvBlob);
    }

    @Override
    @NotNull
    public PaymentMethodData readReusableCard() throws TerminalException {
        this.switchAdapterIfFeatureFlagChanged();
        Adapter adapter = this.currentAdapter;
        if (adapter == null || (adapter = adapter.readReusableCard()) == null) {
            throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "DiscoverReaders must be called before readReusableCard", null, null, 12, null);
        }
        return adapter;
    }

    @Override
    public void setReaderDisplay(@NotNull Cart cart) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)cart, (String)"cart");
        Adapter adapter = this.currentAdapter;
        if (adapter != null) {
            adapter.setReaderDisplay(cart);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "DiscoverReaders must be called before setReaderDisplay", null, null, 12, null);
        }
    }

    @Override
    public void startSession(@NotNull Reader reader) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Adapter adapter = this.currentAdapter;
        if (adapter != null) {
            adapter.startSession(reader);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "DiscoverReaders must be called before startSession", null, null, 12, null);
        }
    }

    @Override
    @NotNull
    public ReaderBatteryInfo requestReaderBatteryInfo(@NotNull Function0<Unit> endPolling) {
        Intrinsics.checkNotNullParameter(endPolling, (String)"endPolling");
        Adapter adapter = this.currentAdapter;
        if (adapter == null || (adapter = adapter.requestReaderBatteryInfo(endPolling)) == null) {
            throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "DiscoverReaders must be called before requestReaderBatteryInfo", null, null, 12, null);
        }
        return adapter;
    }

    @Override
    public void onOnlineAuthStateChanged(@NotNull OnlineAuthState state) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Adapter adapter = this.currentAdapter;
            if (adapter == null) break block0;
            adapter.onOnlineAuthStateChanged(state);
        }
    }

    @Override
    @InternalApi
    @NotNull
    public CollectInputsResult collectInputsBlocking(@NotNull CollectInputsParameters collectInputsParameters) {
        Intrinsics.checkNotNullParameter((Object)collectInputsParameters, (String)"collectInputsParameters");
        Object object = this.currentAdapter;
        if (object == null || (object = ((Adapter)object).collectInputsBlocking(collectInputsParameters)) == null) {
            throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "DiscoverReaders must be called before collectInputs", null, null, 12, null);
        }
        return object;
    }

    @Override
    public void cancelCollectInputs() {
        Unit unit;
        Adapter adapter = this.currentAdapter;
        if (adapter != null) {
            adapter.cancelCollectInputs();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "DiscoverReaders must be called before cancelCollectInputs", null, null, 12, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DiscoveryMethod.values().length];
            try {
                nArray[DiscoveryMethod.LOCAL_MOBILE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiscoveryMethod.BLUETOOTH_SCAN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiscoveryMethod.INTERNET.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiscoveryMethod.EMBEDDED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiscoveryMethod.HANDOFF.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiscoveryMethod.USB.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

