/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.adapter;

import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.transaction.CollectiblePayment;
import com.stripe.jvmcore.transaction.PaymentMethodCollectionType;
import com.stripe.jvmcore.transaction.payment.Payment;
import com.stripe.jvmcore.transaction.payment.RemotePayment;
import com.stripe.stripeterminal.external.InternalApi;
import com.stripe.stripeterminal.external.callable.DiscoveryListener;
import com.stripe.stripeterminal.external.models.Cart;
import com.stripe.stripeterminal.external.models.CollectInputsParameters;
import com.stripe.stripeterminal.external.models.ConnectionConfiguration;
import com.stripe.stripeterminal.external.models.DiscoveryConfiguration;
import com.stripe.stripeterminal.external.models.Reader;
import com.stripe.stripeterminal.external.models.ReaderSoftwareUpdate;
import com.stripe.stripeterminal.external.models.TerminalException;
import com.stripe.stripeterminal.internal.common.Adapter;
import com.stripe.stripeterminal.internal.common.TerminalStatusManager;
import com.stripe.stripeterminal.internal.common.adapter.ProxiedAdapter;
import com.stripe.stripeterminal.internal.common.forms.CollectInputsResult;
import com.stripe.stripeterminal.internal.common.remotereadercontrollers.ProxyRemoteReaderController;
import com.stripe.stripeterminal.internal.common.tokenrepositories.ConnectionTokenRepository;
import com.stripe.stripeterminal.internal.models.PaymentMethodData;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u000223B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\fH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\b\u0010\u0015\u001a\u00020\fH\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u001f\u001a\u00020\fH\u0016J\u0018\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020\u0013H\u0016J(\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020+2\u000e\u0010,\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010-H\u0014J\b\u0010.\u001a\u00020\u001bH\u0016J\u0010\u0010/\u001a\u00020\f2\u0006\u00100\u001a\u000201H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/RemoteReaderAdapter;", "Lcom/stripe/stripeterminal/internal/common/adapter/ProxiedAdapter;", "proxyRemoteReaderController", "Lcom/stripe/stripeterminal/internal/common/remotereadercontrollers/ProxyRemoteReaderController;", "terminalStatusManager", "Lcom/stripe/stripeterminal/internal/common/TerminalStatusManager;", "connectionTokenRepository", "Lcom/stripe/stripeterminal/internal/common/tokenrepositories/ConnectionTokenRepository;", "(Lcom/stripe/stripeterminal/internal/common/remotereadercontrollers/ProxyRemoteReaderController;Lcom/stripe/stripeterminal/internal/common/TerminalStatusManager;Lcom/stripe/stripeterminal/internal/common/tokenrepositories/ConnectionTokenRepository;)V", "currentRefundPaymentMethod", "Lcom/stripe/jvmcore/transaction/CollectiblePayment;", "cancelCollectInputs", "", "cancelCollectPaymentMethod", "cancelDiscoverReaders", "cancelSilently", "", "cancelInstallUpdate", "checkForUpdate", "Lcom/stripe/stripeterminal/external/models/ReaderSoftwareUpdate;", "failSilently", "clearReaderDisplay", "collectInputsBlocking", "Lcom/stripe/stripeterminal/internal/common/forms/CollectInputsResult;", "collectInputsParameters", "Lcom/stripe/stripeterminal/external/models/CollectInputsParameters;", "collectPaymentMethod", "Lcom/stripe/stripeterminal/internal/models/PaymentMethodData;", "paymentMethodCollectionType", "Lcom/stripe/jvmcore/transaction/PaymentMethodCollectionType;", "collectiblePayment", "disconnectReader", "discoverReaders", "config", "Lcom/stripe/stripeterminal/external/models/DiscoveryConfiguration;", "listener", "Lcom/stripe/stripeterminal/external/callable/DiscoveryListener;", "installUpdate", "update", "onConnectReader", "Lcom/stripe/stripeterminal/external/models/Reader;", "reader", "connectionConfiguration", "Lcom/stripe/stripeterminal/external/models/ConnectionConfiguration;", "requestReconnection", "Lkotlin/Function0;", "readReusableCard", "setReaderDisplay", "cart", "Lcom/stripe/stripeterminal/external/models/Cart;", "CollectPaymentMethodOperation", "DiscoverReadersOperation", "adapter_release"})
public final class RemoteReaderAdapter
extends ProxiedAdapter {
    @NotNull
    private final ProxyRemoteReaderController proxyRemoteReaderController;
    @NotNull
    private final TerminalStatusManager terminalStatusManager;
    @NotNull
    private final ConnectionTokenRepository connectionTokenRepository;
    @Nullable
    private CollectiblePayment currentRefundPaymentMethod;

    public RemoteReaderAdapter(@NotNull ProxyRemoteReaderController proxyRemoteReaderController, @NotNull TerminalStatusManager terminalStatusManager, @NotNull ConnectionTokenRepository connectionTokenRepository) {
        Intrinsics.checkNotNullParameter((Object)proxyRemoteReaderController, (String)"proxyRemoteReaderController");
        Intrinsics.checkNotNullParameter((Object)terminalStatusManager, (String)"terminalStatusManager");
        Intrinsics.checkNotNullParameter((Object)connectionTokenRepository, (String)"connectionTokenRepository");
        super(Log.Companion.getLogger(RemoteReaderAdapter.class));
        this.proxyRemoteReaderController = proxyRemoteReaderController;
        this.terminalStatusManager = terminalStatusManager;
        this.connectionTokenRepository = connectionTokenRepository;
    }

    @Override
    @InternalApi
    @NotNull
    public CollectInputsResult collectInputsBlocking(@NotNull CollectInputsParameters collectInputsParameters) {
        Intrinsics.checkNotNullParameter((Object)collectInputsParameters, (String)"collectInputsParameters");
        return this.proxyRemoteReaderController.collectInputs(collectInputsParameters);
    }

    @Override
    @Nullable
    public CollectiblePayment collectiblePayment() {
        Object object = this.currentRefundPaymentMethod;
        return (object != null && (object = ((CollectiblePayment)object).getPayment()) != null ? ((Payment)object).isCollectible() : false) ? this.currentRefundPaymentMethod : null;
    }

    @Override
    public void cancelCollectPaymentMethod() {
        this.getLogger().d("cancelCollectPaymentMethod", new Pair[0]);
        this.currentRefundPaymentMethod = null;
        if (this.getOperationInProgress() instanceof CollectPaymentMethodOperation) {
            Adapter.ReaderOperation<?> readerOperation = this.getOperationInProgress();
            Intrinsics.checkNotNull(readerOperation, (String)"null cannot be cast to non-null type com.stripe.stripeterminal.internal.common.adapter.RemoteReaderAdapter.CollectPaymentMethodOperation");
            ((CollectPaymentMethodOperation)readerOperation).cancel();
        } else {
            this.logUnexpectedOperationInProgressWarning(CollectPaymentMethodOperation.class);
        }
    }

    @Override
    public void cancelDiscoverReaders(boolean cancelSilently) {
        this.getLogger().d("cancelDiscoverReaders", new Pair[0]);
        this.currentRefundPaymentMethod = null;
        Adapter.ReaderOperation<?> readerOperation = this.getOperationInProgress();
        if (readerOperation instanceof DiscoverReadersOperation) {
            Adapter.ReaderOperation<?> readerOperation2 = this.getOperationInProgress();
            Intrinsics.checkNotNull(readerOperation2, (String)"null cannot be cast to non-null type com.stripe.stripeterminal.internal.common.adapter.RemoteReaderAdapter.DiscoverReadersOperation");
            ((DiscoverReadersOperation)readerOperation2).cancel(cancelSilently);
        } else if (readerOperation instanceof Adapter.NullOperation) {
            this.setOperationToCancel(DiscoverReadersOperation.class);
        } else {
            this.logUnexpectedOperationInProgressWarning(DiscoverReadersOperation.class);
        }
    }

    @Override
    public void cancelInstallUpdate() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @Nullable
    public ReaderSoftwareUpdate checkForUpdate(boolean failSilently) {
        String string = "not implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public PaymentMethodData collectPaymentMethod(@NotNull PaymentMethodCollectionType paymentMethodCollectionType) {
        CollectPaymentMethodOperation collectPaymentMethodOperation;
        Intrinsics.checkNotNullParameter((Object)paymentMethodCollectionType, (String)"paymentMethodCollectionType");
        this.getLogger().d("collectPaymentMethod", new Pair[0]);
        this.currentRefundPaymentMethod = null;
        PaymentMethodCollectionType paymentMethodCollectionType2 = paymentMethodCollectionType;
        if (paymentMethodCollectionType2 instanceof PaymentMethodCollectionType.Sale) {
            collectPaymentMethodOperation = new CollectPaymentMethodOperation(paymentMethodCollectionType);
        } else if ((paymentMethodCollectionType2 instanceof PaymentMethodCollectionType.StrongCustomerAuthentication ? true : paymentMethodCollectionType2 instanceof PaymentMethodCollectionType.Refund) ? true : paymentMethodCollectionType2 instanceof PaymentMethodCollectionType.SetupIntent) {
            collectPaymentMethodOperation = new CollectPaymentMethodOperation(paymentMethodCollectionType);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        CollectPaymentMethodOperation paymentMethodOperation = collectPaymentMethodOperation;
        this.setOperationInProgress(paymentMethodOperation);
        return paymentMethodOperation.execute();
    }

    @Override
    @NotNull
    protected Reader onConnectReader(@NotNull Reader reader, @NotNull ConnectionConfiguration connectionConfiguration, @Nullable Function0<Unit> requestReconnection) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)connectionConfiguration, (String)"connectionConfiguration");
        this.currentRefundPaymentMethod = null;
        this.proxyRemoteReaderController.connectReader(reader, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ RemoteReaderAdapter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                RemoteReaderAdapter.access$getTerminalStatusManager$p(this.this$0).unexpectedDisconnect();
            }
        }));
        return reader;
    }

    @Override
    public void clearReaderDisplay() {
        this.getLogger().d("clearReaderDisplay", new Pair[0]);
        this.currentRefundPaymentMethod = null;
        this.setOperationInProgress(new Adapter.NullOperation());
        this.proxyRemoteReaderController.clearReaderDisplay();
    }

    @Override
    public void disconnectReader() {
        this.getLogger().d("disconnectReader", new Pair[0]);
        this.currentRefundPaymentMethod = null;
        this.proxyRemoteReaderController.disconnectReader();
    }

    @Override
    public void discoverReaders(@NotNull DiscoveryConfiguration config, @NotNull DiscoveryListener listener2) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.getLogger().d("discoverReaders", new Pair[0]);
        this.currentRefundPaymentMethod = null;
        this.setOperationInProgress(new DiscoverReadersOperation(config, listener2));
        this.getOperationInProgress().execute();
    }

    @Override
    public void installUpdate(@NotNull ReaderSoftwareUpdate update2) {
        Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
        String string = "not implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public PaymentMethodData readReusableCard() {
        String string = "not implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public void cancelCollectInputs() {
        this.proxyRemoteReaderController.cancelCollectInputs();
    }

    @Override
    public void setReaderDisplay(@NotNull Cart cart) {
        Intrinsics.checkNotNullParameter((Object)cart, (String)"cart");
        this.getLogger().d("setReaderDisplay", new Pair[0]);
        this.currentRefundPaymentMethod = null;
        this.setOperationInProgress(new Adapter.NullOperation());
        this.proxyRemoteReaderController.setReaderDisplay(cart);
    }

    public static final /* synthetic */ TerminalStatusManager access$getTerminalStatusManager$p(RemoteReaderAdapter $this) {
        return $this.terminalStatusManager;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\t\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/RemoteReaderAdapter$CollectPaymentMethodOperation;", "Lcom/stripe/stripeterminal/internal/common/Adapter$ReaderOperation;", "Lcom/stripe/stripeterminal/internal/models/PaymentMethodData;", "Lcom/stripe/stripeterminal/internal/common/Adapter;", "paymentMethodCollectionType", "Lcom/stripe/jvmcore/transaction/PaymentMethodCollectionType;", "(Lcom/stripe/stripeterminal/internal/common/adapter/RemoteReaderAdapter;Lcom/stripe/jvmcore/transaction/PaymentMethodCollectionType;)V", "cancel", "", "execute", "adapter_release"})
    private final class CollectPaymentMethodOperation
    extends Adapter.ReaderOperation<PaymentMethodData> {
        @NotNull
        private final PaymentMethodCollectionType paymentMethodCollectionType;

        public CollectPaymentMethodOperation(PaymentMethodCollectionType paymentMethodCollectionType) {
            Intrinsics.checkNotNullParameter((Object)paymentMethodCollectionType, (String)"paymentMethodCollectionType");
            this.paymentMethodCollectionType = paymentMethodCollectionType;
        }

        @Override
        @NotNull
        public PaymentMethodData execute() {
            PaymentMethodCollectionType paymentMethodCollectionType = this.paymentMethodCollectionType;
            if (paymentMethodCollectionType instanceof PaymentMethodCollectionType.Sale) {
                RemoteReaderAdapter.this.proxyRemoteReaderController.startPaymentCollection(this.paymentMethodCollectionType.getAmount(), (Function1<? super PaymentMethodData, Unit>)((Function1)new Function1<PaymentMethodData, Unit>((Object)this){

                    public final void invoke(@Nullable PaymentMethodData p0) {
                        ((CollectPaymentMethodOperation)this.receiver).set(p0);
                    }
                }), (Function1<? super TerminalException, Unit>)((Function1)new Function1<TerminalException, Unit>((Object)this){

                    public final void invoke(@NotNull TerminalException p0) {
                        Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                        ((CollectPaymentMethodOperation)this.receiver).setException(p0);
                    }
                }), ((PaymentMethodCollectionType.Sale)this.paymentMethodCollectionType).getSkipTipping(), ((PaymentMethodCollectionType.Sale)this.paymentMethodCollectionType).getManualEntry(), ((PaymentMethodCollectionType.Sale)this.paymentMethodCollectionType).getUpdatePaymentIntent(), ((PaymentMethodCollectionType.Sale)this.paymentMethodCollectionType).getIntentId(), ((PaymentMethodCollectionType.Sale)this.paymentMethodCollectionType).getTipEligibleAmount(), ((PaymentMethodCollectionType.Sale)this.paymentMethodCollectionType).getComputedPriorities(), ((PaymentMethodCollectionType.Sale)this.paymentMethodCollectionType).getStripeAccountId(), ((PaymentMethodCollectionType.Sale)this.paymentMethodCollectionType).getOfflineDetails());
            } else if (paymentMethodCollectionType instanceof PaymentMethodCollectionType.StrongCustomerAuthentication) {
                RemoteReaderAdapter.this.proxyRemoteReaderController.resumeCollectPaymentMethod(((PaymentMethodCollectionType.StrongCustomerAuthentication)this.paymentMethodCollectionType).getIntentId(), ((PaymentMethodCollectionType.StrongCustomerAuthentication)this.paymentMethodCollectionType).getOfflineDetails(), (Function1<? super PaymentMethodData, Unit>)((Function1)new Function1<PaymentMethodData, Unit>((Object)this){

                    public final void invoke(@Nullable PaymentMethodData p0) {
                        ((CollectPaymentMethodOperation)this.receiver).set(p0);
                    }
                }), (Function1<? super TerminalException, Unit>)((Function1)new Function1<TerminalException, Unit>((Object)this){

                    public final void invoke(@NotNull TerminalException p0) {
                        Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                        ((CollectPaymentMethodOperation)this.receiver).setException(p0);
                    }
                }));
            } else if (paymentMethodCollectionType instanceof PaymentMethodCollectionType.Refund) {
                RemoteReaderAdapter.this.proxyRemoteReaderController.startInteracRefund(this.paymentMethodCollectionType.getAmount(), ((PaymentMethodCollectionType.Refund)this.paymentMethodCollectionType).getChargeId(), (Function1<? super PaymentMethodData, Unit>)((Function1)new Function1<PaymentMethodData, Unit>((Object)this){

                    public final void invoke(@Nullable PaymentMethodData p0) {
                        ((CollectPaymentMethodOperation)this.receiver).set(p0);
                    }
                }), (Function1<? super TerminalException, Unit>)((Function1)new Function1<TerminalException, Unit>((Object)this){

                    public final void invoke(@NotNull TerminalException p0) {
                        Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                        ((CollectPaymentMethodOperation)this.receiver).setException(p0);
                    }
                }));
            } else if (paymentMethodCollectionType instanceof PaymentMethodCollectionType.SetupIntent) {
                RemoteReaderAdapter.this.proxyRemoteReaderController.startSetupIntentPaymentCollection(((PaymentMethodCollectionType.SetupIntent)this.paymentMethodCollectionType).getIntentId(), (Function1<? super PaymentMethodData, Unit>)((Function1)new Function1<PaymentMethodData, Unit>((Object)this){

                    public final void invoke(@Nullable PaymentMethodData p0) {
                        ((CollectPaymentMethodOperation)this.receiver).set(p0);
                    }
                }), (Function1<? super TerminalException, Unit>)((Function1)new Function1<TerminalException, Unit>((Object)this){

                    public final void invoke(@NotNull TerminalException p0) {
                        Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                        ((CollectPaymentMethodOperation)this.receiver).setException(p0);
                    }
                }));
            }
            PaymentMethodData data = (PaymentMethodData)this.get();
            RemoteReaderAdapter.this.currentRefundPaymentMethod = new CollectiblePayment(new RemotePayment(data.getIpPaymentMethod()), null, false, 6, null);
            return data;
        }

        public final void cancel() {
            PaymentMethodCollectionType paymentMethodCollectionType = this.paymentMethodCollectionType;
            if (paymentMethodCollectionType instanceof PaymentMethodCollectionType.Sale ? true : paymentMethodCollectionType instanceof PaymentMethodCollectionType.StrongCustomerAuthentication) {
                RemoteReaderAdapter.this.proxyRemoteReaderController.cancelCollectPaymentMethod();
            } else if (paymentMethodCollectionType instanceof PaymentMethodCollectionType.Refund) {
                RemoteReaderAdapter.this.proxyRemoteReaderController.cancelCollectInteracRefundMethod();
            } else if (paymentMethodCollectionType instanceof PaymentMethodCollectionType.SetupIntent) {
                RemoteReaderAdapter.this.proxyRemoteReaderController.cancelCollectSetupIntentPaymentMethod();
            }
            RemoteReaderAdapter.this.currentRefundPaymentMethod = null;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001R\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\n\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/RemoteReaderAdapter$DiscoverReadersOperation;", "Lcom/stripe/stripeterminal/internal/common/Adapter$ReaderOperation;", "Ljava/lang/Void;", "Lcom/stripe/stripeterminal/internal/common/Adapter;", "config", "Lcom/stripe/stripeterminal/external/models/DiscoveryConfiguration;", "listener", "Lcom/stripe/stripeterminal/external/callable/DiscoveryListener;", "(Lcom/stripe/stripeterminal/internal/common/adapter/RemoteReaderAdapter;Lcom/stripe/stripeterminal/external/models/DiscoveryConfiguration;Lcom/stripe/stripeterminal/external/callable/DiscoveryListener;)V", "cancel", "", "cancelSilently", "", "execute", "adapter_release"})
    private final class DiscoverReadersOperation
    extends Adapter.ReaderOperation<Void> {
        @NotNull
        private final DiscoveryConfiguration config;
        @NotNull
        private final DiscoveryListener listener;

        public DiscoverReadersOperation(@NotNull DiscoveryConfiguration config, DiscoveryListener listener2) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            this.config = config;
            this.listener = listener2;
        }

        @Override
        @Nullable
        public Void execute() {
            RemoteReaderAdapter.this.proxyRemoteReaderController.setReaderController(this.config.getDiscoveryMethod());
            this.listener.onUpdateDiscoveredReaders(RemoteReaderAdapter.this.proxyRemoteReaderController.discoverReaders(RemoteReaderAdapter.this.connectionTokenRepository.getToken(), this.config.getLocation()));
            return (Void)this.get();
        }

        public final void cancel(boolean cancelSilently) {
            if (cancelSilently) {
                this.set(null);
            } else {
                this.setException(new TerminalException(TerminalException.TerminalErrorCode.CANCELED, "DiscoverReaders was canceled by the user", null, null, 12, null));
            }
        }
    }
}

