/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.adapter;

import android.os.Handler;
import android.os.Looper;
import com.stripe.core.bbpos.hardware.BbposReaderInfoFactory;
import com.stripe.core.transaction.TransactionRepository;
import com.stripe.jvmcore.dagger.IO;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.terminal.appinfo.ApplicationInformation;
import com.stripe.jvmcore.time.Clock;
import com.stripe.jvmcore.transaction.PaymentMethodCollectionType;
import com.stripe.proto.model.common.ClientVersionSpecPb;
import com.stripe.proto.model.config.MobileClientConfig;
import com.stripe.stripeterminal.external.models.BatteryStatus;
import com.stripe.stripeterminal.external.models.DeviceType;
import com.stripe.stripeterminal.external.models.Reader;
import com.stripe.stripeterminal.external.models.ReaderBatteryInfo;
import com.stripe.stripeterminal.external.models.ReaderDisplayMessage;
import com.stripe.stripeterminal.external.models.ReaderInputOptions;
import com.stripe.stripeterminal.external.models.ReaderSoftwareUpdate;
import com.stripe.stripeterminal.external.models.SimulateReaderUpdate;
import com.stripe.stripeterminal.external.models.TerminalException;
import com.stripe.stripeterminal.internal.common.TerminalStatusManager;
import com.stripe.stripeterminal.internal.common.adapter.BaseSimulatedAdapter;
import com.stripe.stripeterminal.internal.common.adapter.SimulatedBbposAdapter;
import com.stripe.stripeterminal.internal.common.adapter.SimulatorConfigurationRepository;
import com.stripe.stripeterminal.internal.common.api.ApiClient;
import com.stripe.stripeterminal.internal.common.makers.ReaderMaker;
import com.stripe.stripeterminal.internal.models.PaymentMethodData;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b&\u0018\u0000 ,2\u00020\u0001:\u0001,BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001aH\u0016J\b\u0010(\u001a\u00020&H\u0016J\b\u0010)\u001a\u00020&H\u0016J\b\u0010*\u001a\u00020&H\u0002J\b\u0010+\u001a\u00020&H\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/SimulatedBbposAdapter;", "Lcom/stripe/stripeterminal/internal/common/adapter/BaseSimulatedAdapter;", "clock", "Lcom/stripe/jvmcore/time/Clock;", "transactionRepository", "Lcom/stripe/core/transaction/TransactionRepository;", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "simulatorConfigurationRepository", "Lcom/stripe/stripeterminal/internal/common/adapter/SimulatorConfigurationRepository;", "statusManager", "Lcom/stripe/stripeterminal/internal/common/TerminalStatusManager;", "apiClient", "Lcom/stripe/stripeterminal/internal/common/api/ApiClient;", "applicationInformation", "Lcom/stripe/jvmcore/terminal/appinfo/ApplicationInformation;", "bbposReaderInfoFactory", "Lcom/stripe/core/bbpos/hardware/BbposReaderInfoFactory;", "logger", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "(Lcom/stripe/jvmcore/time/Clock;Lcom/stripe/core/transaction/TransactionRepository;Lkotlinx/coroutines/CoroutineDispatcher;Lcom/stripe/stripeterminal/internal/common/adapter/SimulatorConfigurationRepository;Lcom/stripe/stripeterminal/internal/common/TerminalStatusManager;Lcom/stripe/stripeterminal/internal/common/api/ApiClient;Lcom/stripe/jvmcore/terminal/appinfo/ApplicationInformation;Lcom/stripe/core/bbpos/hardware/BbposReaderInfoFactory;Lcom/stripe/jvmcore/logging/terminal/log/Log;)V", "batteryStatusJob", "Lkotlinx/coroutines/Job;", "batteryStatusUpdateDelay", "", "checkForUpdate", "Lcom/stripe/stripeterminal/external/models/ReaderSoftwareUpdate;", "failSilently", "", "collectPaymentMethod", "Lcom/stripe/stripeterminal/internal/models/PaymentMethodData;", "paymentMethodCollectionType", "Lcom/stripe/jvmcore/transaction/PaymentMethodCollectionType;", "getSimulatedReader", "Lcom/stripe/stripeterminal/external/models/Reader;", "deviceType", "Lcom/stripe/stripeterminal/external/models/DeviceType;", "installUpdate", "", "update", "onConnect", "onDisconnect", "startBatteryStatusUpdates", "stopBatteryStatusUpdates", "Companion", "adapter_release"})
@SourceDebugExtension(value={"SMAP\nSimulatedBbposAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimulatedBbposAdapter.kt\ncom/stripe/stripeterminal/internal/common/adapter/SimulatedBbposAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,217:1\n766#2:218\n857#2,2:219\n*S KotlinDebug\n*F\n+ 1 SimulatedBbposAdapter.kt\ncom/stripe/stripeterminal/internal/common/adapter/SimulatedBbposAdapter\n*L\n196#1:218\n196#1:219,2\n*E\n"})
public abstract class SimulatedBbposAdapter
extends BaseSimulatedAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineDispatcher dispatcher;
    @NotNull
    private final ApplicationInformation applicationInformation;
    @NotNull
    private final BbposReaderInfoFactory bbposReaderInfoFactory;
    private final long batteryStatusUpdateDelay;
    @Nullable
    private Job batteryStatusJob;
    private static final long SLEEP_QUANTUM_MS = 2000L;

    public SimulatedBbposAdapter(@NotNull Clock clock, @NotNull TransactionRepository transactionRepository, @IO @NotNull CoroutineDispatcher dispatcher, @NotNull SimulatorConfigurationRepository simulatorConfigurationRepository, @NotNull TerminalStatusManager statusManager, @NotNull ApiClient apiClient, @NotNull ApplicationInformation applicationInformation, @NotNull BbposReaderInfoFactory bbposReaderInfoFactory, @NotNull Log logger2) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)transactionRepository, (String)"transactionRepository");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)simulatorConfigurationRepository, (String)"simulatorConfigurationRepository");
        Intrinsics.checkNotNullParameter((Object)statusManager, (String)"statusManager");
        Intrinsics.checkNotNullParameter((Object)apiClient, (String)"apiClient");
        Intrinsics.checkNotNullParameter((Object)applicationInformation, (String)"applicationInformation");
        Intrinsics.checkNotNullParameter((Object)bbposReaderInfoFactory, (String)"bbposReaderInfoFactory");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        super(clock, transactionRepository, simulatorConfigurationRepository, statusManager, apiClient, logger2);
        this.dispatcher = dispatcher;
        this.applicationInformation = applicationInformation;
        this.bbposReaderInfoFactory = bbposReaderInfoFactory;
        this.batteryStatusUpdateDelay = 600000L;
    }

    @Override
    public void onConnect() {
        super.onConnect();
        this.startBatteryStatusUpdates();
    }

    @Override
    public void onDisconnect() {
        super.onDisconnect();
        this.stopBatteryStatusUpdates();
    }

    private final void startBatteryStatusUpdates() {
        this.stopBatteryStatusUpdates();
        this.batteryStatusJob = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)this.dispatcher)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SimulatedBbposAdapter this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        new Handler(Looper.getMainLooper()).post(() -> startBatteryStatusUpdates.1.invokeSuspend$lambda$0(this.this$0));
                        this.label = 1;
                        Object object3 = DelayKt.delay((long)SimulatedBbposAdapter.access$getBatteryStatusUpdateDelay$p(this.this$0), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(SimulatedBbposAdapter this$0) {
                this$0.getStatusManager().reportReaderBatteryInfo(new ReaderBatteryInfo(BatteryStatus.NOMINAL, Float.valueOf(0.85f), Boolean.valueOf(true)));
            }
        }), (int)3, null);
    }

    private final void stopBatteryStatusUpdates() {
        block0: {
            Job job = this.batteryStatusJob;
            if (job == null) break block0;
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
    }

    @Override
    @NotNull
    public Reader getSimulatedReader(@NotNull DeviceType deviceType) {
        Intrinsics.checkNotNullParameter((Object)deviceType, (String)"deviceType");
        String serialNumber = (String)deviceType.getSerialPrefixes().get(0) + "SIMULATOR:" + this.applicationInformation.getDeviceUuid();
        BbposReaderInfoFactory bbposReaderInfoFactory = this.bbposReaderInfoFactory;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"batteryPercentage", (Object)"80"), TuplesKt.to((Object)"deviceSettingVersion", (Object)"SZZZ_Generic_v36"), TuplesKt.to((Object)"firmwareVersion", (Object)"1.00.03.32"), TuplesKt.to((Object)"emvKsn", (Object)"30000888"), TuplesKt.to((Object)"pinKsn", (Object)"58000145356786E99997")};
        Map map2 = MapsKt.mapOf((Pair[])pairArray);
        return ReaderMaker.INSTANCE.fromReaderInfoSimulated(deviceType, bbposReaderInfoFactory.create("58000145356786E99997", "58000352221789E01EB4", "58000414301183E01F2F", "58000214301740E01EC8", "80", "SZZZ_Generic_v36", null, null, null, "1.00.03.32", null, null, null, null, null, null, map2, serialNumber, null, null));
    }

    @Override
    @Nullable
    public ReaderSoftwareUpdate checkForUpdate(boolean failSilently) throws TerminalException {
        this.sleep(2000L);
        SimulateReaderUpdate updateType = this.getSimulatorConfigurationRepository().getSimulatorConfiguration().getUpdate() == SimulateReaderUpdate.RANDOM ? (Random.Default.nextInt(2) == 0 ? SimulateReaderUpdate.UPDATE_AVAILABLE : SimulateReaderUpdate.REQUIRED) : this.getSimulatorConfigurationRepository().getSimulatorConfiguration().getUpdate();
        Calendar cal = Calendar.getInstance();
        switch (WhenMappings.$EnumSwitchMapping$0[updateType.ordinal()]) {
            case 1: {
                cal.add(3, 1);
                ClientVersionSpecPb spec = new ClientVersionSpecPb(null, null, null, null, null, null, null, null, 255, null);
                Date date = cal.getTime();
                Intrinsics.checkNotNullExpressionValue((Object)date, (String)"cal.time");
                return new ReaderSoftwareUpdate(date, ReaderSoftwareUpdate.UpdateTimeEstimate.TWO_TO_FIVE_MINUTES, "1.00.03.32-SZZZ_Generic_v37-30000", spec, null, null, "new-hash", null, new MobileClientConfig(null, null, null, null, null, null, null, null, null, 511, null));
            }
            case 2: {
                cal.add(3, -1);
                ClientVersionSpecPb spec = new ClientVersionSpecPb(null, null, null, null, null, null, null, null, 255, null);
                Date date = cal.getTime();
                Intrinsics.checkNotNullExpressionValue((Object)date, (String)"cal.time");
                return new ReaderSoftwareUpdate(date, ReaderSoftwareUpdate.UpdateTimeEstimate.TWO_TO_FIVE_MINUTES, "1.00.03.32-SZZZ_Generic_v37-30000", spec, spec, "300001", "new-hash", null, new MobileClientConfig(null, null, null, null, null, null, null, null, null, 511, null));
            }
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return null;
    }

    @Override
    @NotNull
    public PaymentMethodData collectPaymentMethod(@NotNull PaymentMethodCollectionType paymentMethodCollectionType) throws TerminalException {
        Intrinsics.checkNotNullParameter((Object)paymentMethodCollectionType, (String)"paymentMethodCollectionType");
        Object[] objectArray = new ReaderInputOptions.ReaderInputOption[]{ReaderInputOptions.ReaderInputOption.INSERT, ReaderInputOptions.ReaderInputOption.SWIPE, ReaderInputOptions.ReaderInputOption.TAP};
        List options = CollectionsKt.listOf((Object[])objectArray);
        this.getStatusManager().requestReaderInput(new ReaderInputOptions(options));
        PaymentMethodData card = this.readCard(false, paymentMethodCollectionType);
        this.getStatusManager().requestReaderDisplayMessage(ReaderDisplayMessage.REMOVE_CARD);
        return card;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void installUpdate(@NotNull ReaderSoftwareUpdate update2) throws TerminalException {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
        this.setCancelInstallUpdate(BaseSimulatedAdapter.CancellationState.NOT_CANCELED);
        boolean shouldInstallBase = update2.getRequiredAt().before(new Date()) || !update2.getOnlyInstallRequiredUpdates();
        Object object = new Boolean[]{update2.hasKeyUpdate() && shouldInstallBase, update2.hasConfigUpdate() && shouldInstallBase, update2.hasFirmwareUpdate() && shouldInstallBase, update2.hasIncrementalUpdate()};
        object = CollectionsKt.listOf((Object[])object);
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean it = (Boolean)element$iv$iv;
            boolean bl = false;
            if (!it) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        int numUpdates = ((List)destination$iv$iv).size();
        for (int i2 = 0; i2 < numUpdates; ++i2) {
            for (int j2 = 0; j2 < 5; ++j2) {
                Thread.sleep(2000L);
                if (this.getCancelInstallUpdate() == BaseSimulatedAdapter.CancellationState.CANCELED_WITH_ERROR) {
                    throw new TerminalException(TerminalException.TerminalErrorCode.CANCELED, "Update installation was canceled by the user.", null, null, 12, null);
                }
                this.getStatusManager().reportReaderSoftwareUpdateProgress((float)(5 * i2 + j2) / (float)(numUpdates * 5));
            }
        }
    }

    public static final /* synthetic */ long access$getBatteryStatusUpdateDelay$p(SimulatedBbposAdapter $this) {
        return $this.batteryStatusUpdateDelay;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/SimulatedBbposAdapter$Companion;", "", "()V", "SLEEP_QUANTUM_MS", "", "adapter_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SimulateReaderUpdate.values().length];
            try {
                nArray[SimulateReaderUpdate.UPDATE_AVAILABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SimulateReaderUpdate.REQUIRED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SimulateReaderUpdate.RANDOM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SimulateReaderUpdate.NONE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

