/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.adapter.connection;

import com.stripe.core.hardware.Reader;
import com.stripe.core.hardware.reactive.RxJavaHelper;
import com.stripe.core.hardware.reactive.status.ReactiveReaderStatusListener;
import com.stripe.jvmcore.hardware.status.DisconnectCause;
import com.stripe.jvmcore.hardware.status.ReaderInfo;
import com.stripe.jvmcore.logging.HealthLogger;
import com.stripe.jvmcore.logging.PendingTimer;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.loggingmodels.Outcome;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.connectivity.ConnectivityDomain;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.connectivity.UsbScope;
import com.stripe.proto.terminal.clientlogger.pub.message.health.metrictype.Timer;
import com.stripe.stripeterminal.internal.common.adapter.connection.UsbReaderReconnector;
import com.stripe.stripeterminal.internal.common.makers.DeviceTypeMaker;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Predicate;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 02\u00020\u0001:\u0003012B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\"\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0005j\u0002`\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0002\u0010\u0014J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 J#\u0010!\u001a\u00020\"*\b\u0012\u0004\u0012\u00020\u001e0#2\u0006\u0010$\u001a\u00020%H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J\f\u0010'\u001a\u00020(*\u00020\u001bH\u0002J\u001b\u0010)\u001a\u00020(*\u00020\u001b2\b\u0010*\u001a\u0004\u0018\u00010+H\u0002\u00a2\u0006\u0002\u0010,J\u001b\u0010-\u001a\u00020.*\b\u0012\u0004\u0012\u00020\u001e0#H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010/R\u0019\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u0017R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0005j\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0019\u001a\u00020\u0016X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u00063"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/connection/UsbReaderReconnector;", "", "readerStatusListener", "Lcom/stripe/core/hardware/reactive/status/ReactiveReaderStatusListener;", "connectivityHealthLogger", "Lcom/stripe/jvmcore/logging/HealthLogger;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/connectivity/ConnectivityDomain;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/connectivity/ConnectivityDomain$Builder;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/connectivity/UsbScope;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/connectivity/UsbScope$Builder;", "Lcom/stripe/stripeterminal/internal/common/log/UsbConnectivityHealthLogger;", "logger", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "readerEventScheduler", "Lio/reactivex/rxjava3/core/Scheduler;", "reconnectionMaxTimeoutInSeconds", "", "reconnectionMaxAttempts", "attemptDelayMillis", "", "(Lcom/stripe/core/hardware/reactive/status/ReactiveReaderStatusListener;Lcom/stripe/jvmcore/logging/HealthLogger;Lcom/stripe/jvmcore/logging/terminal/log/Log;Lio/reactivex/rxjava3/core/Scheduler;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Long;)V", "attemptDelay", "Lkotlin/time/Duration;", "J", "maxAttempts", "operationTimeout", "initializeHealthMetrics", "Lcom/stripe/jvmcore/logging/PendingTimer;", "reconnect", "Lkotlinx/coroutines/flow/Flow;", "Lcom/stripe/stripeterminal/internal/common/adapter/connection/UsbReaderReconnector$ReconnectionEvent;", "disconnectedReader", "Lcom/stripe/stripeterminal/external/models/Reader;", "attemptToReconnect", "Lcom/stripe/stripeterminal/internal/common/adapter/connection/UsbReaderReconnector$ConnectionAttemptResult;", "Lkotlinx/coroutines/flow/FlowCollector;", "usbReader", "Lcom/stripe/core/hardware/Reader;", "(Lkotlinx/coroutines/flow/FlowCollector;Lcom/stripe/core/hardware/Reader;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "finalizeHealthMetricsForCancel", "", "finalizeHealthMetricsForResult", "reconnected", "", "(Lcom/stripe/jvmcore/logging/PendingTimer;Ljava/lang/Boolean;)V", "getReaderInfo", "Lcom/stripe/jvmcore/hardware/status/ReaderInfo;", "(Lkotlinx/coroutines/flow/FlowCollector;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "ConnectionAttemptResult", "ReconnectionEvent", "adapter_release"})
public final class UsbReaderReconnector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReactiveReaderStatusListener readerStatusListener;
    @NotNull
    private final HealthLogger<ConnectivityDomain, ConnectivityDomain.Builder, UsbScope, UsbScope.Builder> connectivityHealthLogger;
    @NotNull
    private final Log logger;
    @NotNull
    private final Scheduler readerEventScheduler;
    private final long operationTimeout;
    private final int maxAttempts;
    private final long attemptDelay;
    private static final long DEFAULT_ATTEMPT_DELAY = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS);
    private static final long DEFAULT_RECONNECTION_TIMEOUT = DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS);
    public static final int DEFAULT_RECONNECTION_MAX_ATTEMPTS = 4;
    @NotNull
    public static final String OUTCOME_TAG_KEY = "reconnection_outcome";

    public UsbReaderReconnector(@NotNull ReactiveReaderStatusListener readerStatusListener, @NotNull HealthLogger<ConnectivityDomain, ConnectivityDomain.Builder, UsbScope, UsbScope.Builder> connectivityHealthLogger, @NotNull Log logger2, @NotNull Scheduler readerEventScheduler, @Nullable Integer reconnectionMaxTimeoutInSeconds, @Nullable Integer reconnectionMaxAttempts, @Nullable Long attemptDelayMillis) {
        Intrinsics.checkNotNullParameter((Object)readerStatusListener, (String)"readerStatusListener");
        Intrinsics.checkNotNullParameter(connectivityHealthLogger, (String)"connectivityHealthLogger");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)readerEventScheduler, (String)"readerEventScheduler");
        this.readerStatusListener = readerStatusListener;
        this.connectivityHealthLogger = connectivityHealthLogger;
        this.logger = logger2;
        this.readerEventScheduler = readerEventScheduler;
        this.operationTimeout = reconnectionMaxTimeoutInSeconds != null ? DurationKt.toDuration((int)reconnectionMaxTimeoutInSeconds, (DurationUnit)DurationUnit.SECONDS) : DEFAULT_RECONNECTION_TIMEOUT;
        Integer n2 = reconnectionMaxAttempts;
        int n3 = this.maxAttempts = n2 != null ? n2 : 4;
        this.attemptDelay = attemptDelayMillis != null ? DurationKt.toDuration((long)attemptDelayMillis, (DurationUnit)DurationUnit.MILLISECONDS) : DEFAULT_ATTEMPT_DELAY;
    }

    @NotNull
    public final Flow<ReconnectionEvent> reconnect(@NotNull com.stripe.stripeterminal.external.models.Reader disconnectedReader) {
        Intrinsics.checkNotNullParameter((Object)disconnectedReader, (String)"disconnectedReader");
        return FlowKt.flow((Function2)((Function2)new Function2<FlowCollector<? super ReconnectionEvent>, Continuation<? super Unit>, Object>(disconnectedReader, this, null){
            Object L$1;
            Object L$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ com.stripe.stripeterminal.external.models.Reader $disconnectedReader;
            final /* synthetic */ UsbReaderReconnector this$0;
            {
                this.$disconnectedReader = $disconnectedReader;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$flow = (FlowCollector)this.L$0;
                        disconnectedUsbReader = Reader.UsbReader.Companion.fromUsbDevice(this.$disconnectedReader.getUsbDevice());
                        if (disconnectedUsbReader != null && UsbReaderReconnector.access$getMaxAttempts$p(this.this$0) > 0) break;
                        this.label = 1;
                        v0 = $this$flow.emit((Object)ReconnectionEvent.FailedToReconnect.INSTANCE, (Continuation)this);
                        if (v0 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                pendingTimer = UsbReaderReconnector.access$initializeHealthMetrics(this.this$0);
                reconnected = new Ref.ObjectRef();
                this.L$0 = $this$flow;
                this.L$1 = pendingTimer;
                this.L$2 = reconnected;
                this.label = 2;
                v1 = TimeoutKt.withTimeoutOrNull-KLykuaI((long)UsbReaderReconnector.access$getOperationTimeout$p(this.this$0), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, (FlowCollector<? super ReconnectionEvent>)$this$flow, disconnectedUsbReader, this.$disconnectedReader, (Ref.ObjectRef<Boolean>)reconnected, null){
                    int I$0;
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ UsbReaderReconnector this$0;
                    final /* synthetic */ FlowCollector<ReconnectionEvent> $$this$flow;
                    final /* synthetic */ Reader.UsbReader $disconnectedUsbReader;
                    final /* synthetic */ com.stripe.stripeterminal.external.models.Reader $disconnectedReader;
                    final /* synthetic */ Ref.ObjectRef<Boolean> $reconnected;
                    {
                        this.this$0 = $receiver;
                        this.$$this$flow = $$this$flow;
                        this.$disconnectedUsbReader = $disconnectedUsbReader;
                        this.$disconnectedReader = $disconnectedReader;
                        this.$reconnected = $reconnected;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                $this$withTimeoutOrNull = (CoroutineScope)this.L$0;
                                reconnectionAttempt = 1;
                                UsbReaderReconnector.access$getLogger$p(this.this$0).d("Reconnect started, calling bbpos SDK", new Pair[0]);
lbl8:
                                // 3 sources

                                while (JobKt.isActive((CoroutineContext)$this$withTimeoutOrNull.getCoroutineContext())) {
                                    this.L$0 = $this$withTimeoutOrNull;
                                    this.I$0 = reconnectionAttempt;
                                    this.label = 1;
                                    v0 = UsbReaderReconnector.access$attemptToReconnect(this.this$0, this.$$this$flow, this.$disconnectedUsbReader, (Continuation)this);
                                    if (v0 == var8_2) {
                                        return var8_2;
                                    }
                                    ** GOTO lbl22
                                }
                                break;
                            }
                            case 1: {
                                reconnectionAttempt = this.I$0;
                                $this$withTimeoutOrNull = (CoroutineScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl22:
                                // 2 sources

                                if (!((var4_5 = (ConnectionAttemptResult)v0) instanceof ConnectionAttemptResult.ConnectedToReader)) break;
                                this.L$0 = null;
                                this.label = 2;
                                v1 = UsbReaderReconnector.access$getReaderInfo(this.this$0, this.$$this$flow, (Continuation)this);
                                if (v1 == var8_2) {
                                    return var8_2;
                                }
                                ** GOTO lbl32
                            }
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl32:
                                // 2 sources

                                if ((v2 = (info = (ReaderInfo)v1).getSerial()) == null) {
                                    v2 = "";
                                }
                                reader = new com.stripe.stripeterminal.external.models.Reader(DeviceTypeMaker.Companion.fromSerial(v2), null, null, null, null, info, false, null, this.$disconnectedReader.getUsbDevice(), 222, null);
                                UsbReaderReconnector.access$getLogger$p(this.this$0).i("reader reconnected:" + reader.getSerialNumber(), new Pair[0]);
                                if (!Intrinsics.areEqual((Object)this.$disconnectedReader.getSerialNumber(), (Object)info.getSerial())) {
                                    var7_8 = new Pair[]{TuplesKt.to((Object)"oldSerialNumber", (Object)this.$disconnectedReader.getSerialNumber()), TuplesKt.to((Object)"newSerialNumber", (Object)info.getSerial())};
                                    UsbReaderReconnector.access$getLogger$p(this.this$0).d("serialNumber for reconnected reader has changed", var7_8);
                                }
                                this.L$0 = reader;
                                this.label = 3;
                                v3 = this.$$this$flow.emit((Object)ReconnectionEvent.UpdateConnectivity.EndConnectAttempt.INSTANCE, (Continuation)this);
                                if (v3 == var8_2) {
                                    return var8_2;
                                }
                                ** GOTO lbl49
                            }
                            case 3: {
                                reader = (com.stripe.stripeterminal.external.models.Reader)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v3 = $result;
lbl49:
                                // 2 sources

                                this.L$0 = null;
                                this.label = 4;
                                v4 = this.$$this$flow.emit((Object)new ReconnectionEvent.ReconnectedToReader(reader), (Continuation)this);
                                if (v4 == var8_2) {
                                    return var8_2;
                                }
                                ** GOTO lbl58
                            }
                            case 4: {
                                ResultKt.throwOnFailure((Object)$result);
                                v4 = $result;
lbl58:
                                // 2 sources

                                this.$reconnected.element = Boxing.boxBoolean((boolean)true);
                                break;
                            }
                        }
                        if (!(var4_5 instanceof ConnectionAttemptResult.CouldNotConnect)) ** GOTO lbl8
                        UsbReaderReconnector.access$getLogger$p(this.this$0).d("Reconnect attempt failed. End connecting.", new Pair[0]);
                        this.L$0 = $this$withTimeoutOrNull;
                        this.I$0 = reconnectionAttempt;
                        this.label = 5;
                        v5 = this.$$this$flow.emit((Object)ReconnectionEvent.UpdateConnectivity.EndConnectAttempt.INSTANCE, (Continuation)this);
                        if (v5 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl74
                        {
                            case 5: {
                                reconnectionAttempt = this.I$0;
                                $this$withTimeoutOrNull = (CoroutineScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v5 = $result;
lbl74:
                                // 2 sources

                                if (reconnectionAttempt < UsbReaderReconnector.access$getMaxAttempts$p(this.this$0)) break;
                                this.L$0 = null;
                                this.label = 6;
                                v6 = this.$$this$flow.emit((Object)ReconnectionEvent.FailedToReconnect.INSTANCE, (Continuation)this);
                                if (v6 == var8_2) {
                                    return var8_2;
                                }
                                ** GOTO lbl84
                            }
                            case 6: {
                                ResultKt.throwOnFailure((Object)$result);
                                v6 = $result;
lbl84:
                                // 2 sources

                                this.$reconnected.element = Boxing.boxBoolean((boolean)false);
                                break;
                            }
                        }
                        this.L$0 = $this$withTimeoutOrNull;
                        this.I$0 = reconnectionAttempt;
                        this.label = 7;
                        v7 = DelayKt.delay-VtjQ1oo((long)UsbReaderReconnector.access$getAttemptDelay$p(this.this$0), (Continuation)((Continuation)this));
                        if (v7 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl98
                        {
                            case 7: {
                                reconnectionAttempt = this.I$0;
                                $this$withTimeoutOrNull = (CoroutineScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v7 = $result;
lbl98:
                                // 2 sources

                                UsbReaderReconnector.access$getLogger$p(this.this$0).d("Reconnect re-started, calling bbpos SDK", new Pair[0]);
                                ++reconnectionAttempt;
                                ** GOTO lbl8
                            }
                        }
                        return Unit.INSTANCE;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        function2.L$0 = value;
                        return (Continuation)function2;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)((Continuation)this));
                ** if (v1 != var7_2) goto lbl28
lbl27:
                // 1 sources

                return var7_2;
lbl28:
                // 1 sources

                ** GOTO lbl37
                {
                    case 2: {
                        reconnected = (Ref.ObjectRef)this.L$2;
                        pendingTimer = (PendingTimer)this.L$1;
                        $this$flow = (FlowCollector)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl37:
                        // 2 sources

                        if (reconnected.element != null) ** GOTO lbl53
                        this.L$0 = pendingTimer;
                        this.L$1 = reconnected;
                        this.L$2 = null;
                        this.label = 3;
                        v2 = $this$flow.emit((Object)ReconnectionEvent.FailedToReconnect.INSTANCE, (Continuation)this);
                        ** if (v2 != var7_2) goto lbl45
lbl44:
                        // 1 sources

                        return var7_2;
lbl45:
                        // 1 sources

                        ** GOTO lbl53
                    }
                    case 3: {
                        reconnected = (Ref.ObjectRef)this.L$1;
                        pendingTimer = (PendingTimer)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl53:
                            // 3 sources

                            if (pendingTimer != null) {
                                UsbReaderReconnector.access$finalizeHealthMetricsForResult(this.this$0, pendingTimer, (Boolean)reconnected.element);
                            }
                        }
                        catch (CancellationException var6_7) {
                            if (pendingTimer == null) ** GOTO lbl59
                            UsbReaderReconnector.access$finalizeHealthMetricsForCancel(this.this$0, pendingTimer);
                        }
lbl59:
                        // 3 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<FlowCollector<? super ReconnectionEvent>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull FlowCollector<? super ReconnectionEvent> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final PendingTimer initializeHealthMetrics() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"maxTimeoutInSeconds", (Object)String.valueOf(Duration.getInWholeSeconds-impl((long)this.operationTimeout))), TuplesKt.to((Object)"maxAttempts", (Object)String.valueOf(this.maxAttempts)), TuplesKt.to((Object)"attemptDelay", (Object)String.valueOf(Duration.getInWholeMilliseconds-impl((long)this.attemptDelay)))};
        Map healthLoggerTags = MapsKt.mapOf((Pair[])pairArray);
        return this.connectivityHealthLogger.startTimer(healthLoggerTags, (Function2<UsbScope.Builder, Timer, Unit>)((Function2)initializeHealthMetrics.1.INSTANCE));
    }

    private final void finalizeHealthMetricsForCancel(PendingTimer $this$finalizeHealthMetricsForCancel) {
        HealthLogger.endTimer$default(this.connectivityHealthLogger, $this$finalizeHealthMetricsForCancel, Outcome.GenericError.INSTANCE, null, null, 12, null);
    }

    private final void finalizeHealthMetricsForResult(PendingTimer $this$finalizeHealthMetricsForResult, Boolean reconnected) {
        if (reconnected == null) {
            this.logger.d("Reconnect timed out", new Pair[0]);
            HealthLogger.endTimer$default(this.connectivityHealthLogger, $this$finalizeHealthMetricsForResult, Outcome.GenericError.INSTANCE, MapsKt.mapOf((Pair)TuplesKt.to((Object)OUTCOME_TAG_KEY, (Object)"hit_timeout")), null, 8, null);
        } else if (reconnected.booleanValue()) {
            this.logger.d("Reconnect succeeded", new Pair[0]);
            HealthLogger.endTimer$default(this.connectivityHealthLogger, $this$finalizeHealthMetricsForResult, Outcome.Ok.INSTANCE, MapsKt.mapOf((Pair)TuplesKt.to((Object)OUTCOME_TAG_KEY, (Object)"reconnected")), null, 8, null);
        } else {
            this.logger.d("Reconnect exceeded max attempts", new Pair[0]);
            HealthLogger.endTimer$default(this.connectivityHealthLogger, $this$finalizeHealthMetricsForResult, Outcome.GenericError.INSTANCE, MapsKt.mapOf((Pair)TuplesKt.to((Object)OUTCOME_TAG_KEY, (Object)"hit_max_retries")), null, 8, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Object attemptToReconnect(FlowCollector<? super ReconnectionEvent> var1_1, Reader var2_2, Continuation<? super ConnectionAttemptResult> var3_3) {
        if (!(var3_3 instanceof attemptToReconnect.1)) ** GOTO lbl-1000
        var7_4 = var3_3;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                final /* synthetic */ UsbReaderReconnector this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return UsbReaderReconnector.access$attemptToReconnect(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var5_7 = new ObservableSource[]{this.readerStatusListener.getReaderConnectObservable().map((Function)attemptToReconnect.2.INSTANCE), this.readerStatusListener.getReaderDisconnectObservable().filter((Predicate)attemptToReconnect.3.INSTANCE).map((Function)attemptToReconnect.4.INSTANCE)};
                v0 = Observable.ambArray((ObservableSource[])var5_7);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"ambArray(\n            re\u2026tConnect(it) },\n        )");
                $continuation.label = 1;
                v1 = RxJavaHelper.INSTANCE.awaitFirstWithBlock(v0, this.readerEventScheduler, (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>((FlowCollector<? super ReconnectionEvent>)$this$attemptToReconnect, (Reader)usbReader, null){
                    int label;
                    final /* synthetic */ FlowCollector<ReconnectionEvent> $this_attemptToReconnect;
                    final /* synthetic */ Reader $usbReader;
                    {
                        this.$this_attemptToReconnect = $receiver;
                        this.$usbReader = $usbReader;
                        super(1, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = this.$this_attemptToReconnect.emit((Object)new ReconnectionEvent.UpdateConnectivity.StartConnectAttempt(this.$usbReader), (Continuation)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }
                }), $continuation);
                if (v1 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl23
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl23:
                // 2 sources

                var4_8 = v1;
                Intrinsics.checkNotNullExpressionValue((Object)var4_8, (String)"FlowCollector<Reconnecti\u2026mpt(usbReader))\n        }");
                return var4_8;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object getReaderInfo(FlowCollector<? super ReconnectionEvent> $this$getReaderInfo, Continuation<? super ReaderInfo> $completion) {
        return RxJavaHelper.INSTANCE.awaitFirstWithBlock(this.readerStatusListener.getReaderInfoObservable(), this.readerEventScheduler, (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>($this$getReaderInfo, null){
            int label;
            final /* synthetic */ FlowCollector<ReconnectionEvent> $this_getReaderInfo;
            {
                this.$this_getReaderInfo = $receiver;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$this_getReaderInfo.emit((Object)ReconnectionEvent.UpdateConnectivity.GetReaderInfo.INSTANCE, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public static final /* synthetic */ int access$getMaxAttempts$p(UsbReaderReconnector $this) {
        return $this.maxAttempts;
    }

    public static final /* synthetic */ PendingTimer access$initializeHealthMetrics(UsbReaderReconnector $this) {
        return $this.initializeHealthMetrics();
    }

    public static final /* synthetic */ long access$getOperationTimeout$p(UsbReaderReconnector $this) {
        return $this.operationTimeout;
    }

    public static final /* synthetic */ Log access$getLogger$p(UsbReaderReconnector $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Object access$attemptToReconnect(UsbReaderReconnector $this, FlowCollector $receiver, Reader usbReader, Continuation $completion) {
        return $this.attemptToReconnect((FlowCollector<? super ReconnectionEvent>)$receiver, usbReader, (Continuation<? super ConnectionAttemptResult>)$completion);
    }

    public static final /* synthetic */ Object access$getReaderInfo(UsbReaderReconnector $this, FlowCollector $receiver, Continuation $completion) {
        return $this.getReaderInfo((FlowCollector<? super ReconnectionEvent>)$receiver, (Continuation<? super ReaderInfo>)$completion);
    }

    public static final /* synthetic */ long access$getAttemptDelay$p(UsbReaderReconnector $this) {
        return $this.attemptDelay;
    }

    public static final /* synthetic */ void access$finalizeHealthMetricsForResult(UsbReaderReconnector $this, PendingTimer $receiver, Boolean reconnected) {
        $this.finalizeHealthMetricsForResult($receiver, reconnected);
    }

    public static final /* synthetic */ void access$finalizeHealthMetricsForCancel(UsbReaderReconnector $this, PendingTimer $receiver) {
        $this.finalizeHealthMetricsForCancel($receiver);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001f\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\b\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000R\u001f\u0010\n\u001a\u00020\u0004X\u0080\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u000b\u0010\u0006R\u000e\u0010\f\u001a\u00020\rX\u0080T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u000e"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/connection/UsbReaderReconnector$Companion;", "", "()V", "DEFAULT_ATTEMPT_DELAY", "Lkotlin/time/Duration;", "getDEFAULT_ATTEMPT_DELAY-UwyO8pc$adapter_release", "()J", "J", "DEFAULT_RECONNECTION_MAX_ATTEMPTS", "", "DEFAULT_RECONNECTION_TIMEOUT", "getDEFAULT_RECONNECTION_TIMEOUT-UwyO8pc$adapter_release", "OUTCOME_TAG_KEY", "", "adapter_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getDEFAULT_ATTEMPT_DELAY-UwyO8pc$adapter_release() {
            return DEFAULT_ATTEMPT_DELAY;
        }

        public final long getDEFAULT_RECONNECTION_TIMEOUT-UwyO8pc$adapter_release() {
            return DEFAULT_RECONNECTION_TIMEOUT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/connection/UsbReaderReconnector$ConnectionAttemptResult;", "", "ConnectedToReader", "CouldNotConnect", "Lcom/stripe/stripeterminal/internal/common/adapter/connection/UsbReaderReconnector$ConnectionAttemptResult$ConnectedToReader;", "Lcom/stripe/stripeterminal/internal/common/adapter/connection/UsbReaderReconnector$ConnectionAttemptResult$CouldNotConnect;", "adapter_release"})
    private static interface ConnectionAttemptResult {

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/connection/UsbReaderReconnector$ConnectionAttemptResult$ConnectedToReader;", "Lcom/stripe/stripeterminal/internal/common/adapter/connection/UsbReaderReconnector$ConnectionAttemptResult;", "reader", "Lcom/stripe/core/hardware/Reader;", "(Lcom/stripe/core/hardware/Reader;)V", "getReader", "()Lcom/stripe/core/hardware/Reader;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "adapter_release"})
        public static final class ConnectedToReader
        implements ConnectionAttemptResult {
            @NotNull
            private final Reader reader;

            public ConnectedToReader(@NotNull Reader reader) {
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                this.reader = reader;
            }

            @NotNull
            public final Reader getReader() {
                return this.reader;
            }

            @NotNull
            public final Reader component1() {
                return this.reader;
            }

            @NotNull
            public final ConnectedToReader copy(@NotNull Reader reader) {
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                return new ConnectedToReader(reader);
            }

            public static /* synthetic */ ConnectedToReader copy$default(ConnectedToReader connectedToReader, Reader reader, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    reader = connectedToReader.reader;
                }
                return connectedToReader.copy(reader);
            }

            @NotNull
            public String toString() {
                return "ConnectedToReader(reader=" + this.reader + ')';
            }

            public int hashCode() {
                return this.reader.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ConnectedToReader)) {
                    return false;
                }
                ConnectedToReader connectedToReader = (ConnectedToReader)other;
                return Intrinsics.areEqual((Object)this.reader, (Object)connectedToReader.reader);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/connection/UsbReaderReconnector$ConnectionAttemptResult$CouldNotConnect;", "Lcom/stripe/stripeterminal/internal/common/adapter/connection/UsbReaderReconnector$ConnectionAttemptResult;", "disconnectCause", "Lcom/stripe/jvmcore/hardware/status/DisconnectCause;", "(Lcom/stripe/jvmcore/hardware/status/DisconnectCause;)V", "getDisconnectCause", "()Lcom/stripe/jvmcore/hardware/status/DisconnectCause;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "adapter_release"})
        public static final class CouldNotConnect
        implements ConnectionAttemptResult {
            @NotNull
            private final DisconnectCause disconnectCause;

            public CouldNotConnect(@NotNull DisconnectCause disconnectCause) {
                Intrinsics.checkNotNullParameter((Object)((Object)disconnectCause), (String)"disconnectCause");
                this.disconnectCause = disconnectCause;
            }

            @NotNull
            public final DisconnectCause getDisconnectCause() {
                return this.disconnectCause;
            }

            @NotNull
            public final DisconnectCause component1() {
                return this.disconnectCause;
            }

            @NotNull
            public final CouldNotConnect copy(@NotNull DisconnectCause disconnectCause) {
                Intrinsics.checkNotNullParameter((Object)((Object)disconnectCause), (String)"disconnectCause");
                return new CouldNotConnect(disconnectCause);
            }

            public static /* synthetic */ CouldNotConnect copy$default(CouldNotConnect couldNotConnect, DisconnectCause disconnectCause, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    disconnectCause = couldNotConnect.disconnectCause;
                }
                return couldNotConnect.copy(disconnectCause);
            }

            @NotNull
            public String toString() {
                return "CouldNotConnect(disconnectCause=" + (Object)((Object)this.disconnectCause) + ')';
            }

            public int hashCode() {
                return this.disconnectCause.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CouldNotConnect)) {
                    return false;
                }
                CouldNotConnect couldNotConnect = (CouldNotConnect)other;
                return this.disconnectCause == couldNotConnect.disconnectCause;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u0082\u0001\u0003\u0005\u0006\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/connection/UsbReaderReconnector$ReconnectionEvent;", "", "FailedToReconnect", "ReconnectedToReader", "UpdateConnectivity", "Lcom/stripe/stripeterminal/internal/common/adapter/connection/UsbReaderReconnector$ReconnectionEvent$FailedToReconnect;", "Lcom/stripe/stripeterminal/internal/common/adapter/connection/UsbReaderReconnector$ReconnectionEvent$ReconnectedToReader;", "Lcom/stripe/stripeterminal/internal/common/adapter/connection/UsbReaderReconnector$ReconnectionEvent$UpdateConnectivity;", "adapter_release"})
    public static interface ReconnectionEvent {

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/connection/UsbReaderReconnector$ReconnectionEvent$FailedToReconnect;", "Lcom/stripe/stripeterminal/internal/common/adapter/connection/UsbReaderReconnector$ReconnectionEvent;", "()V", "adapter_release"})
        public static final class FailedToReconnect
        implements ReconnectionEvent {
            @NotNull
            public static final FailedToReconnect INSTANCE = new FailedToReconnect();

            private FailedToReconnect() {
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/connection/UsbReaderReconnector$ReconnectionEvent$ReconnectedToReader;", "Lcom/stripe/stripeterminal/internal/common/adapter/connection/UsbReaderReconnector$ReconnectionEvent;", "reader", "Lcom/stripe/stripeterminal/external/models/Reader;", "(Lcom/stripe/stripeterminal/external/models/Reader;)V", "getReader", "()Lcom/stripe/stripeterminal/external/models/Reader;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "adapter_release"})
        public static final class ReconnectedToReader
        implements ReconnectionEvent {
            @NotNull
            private final com.stripe.stripeterminal.external.models.Reader reader;

            public ReconnectedToReader(@NotNull com.stripe.stripeterminal.external.models.Reader reader) {
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                this.reader = reader;
            }

            @NotNull
            public final com.stripe.stripeterminal.external.models.Reader getReader() {
                return this.reader;
            }

            @NotNull
            public final com.stripe.stripeterminal.external.models.Reader component1() {
                return this.reader;
            }

            @NotNull
            public final ReconnectedToReader copy(@NotNull com.stripe.stripeterminal.external.models.Reader reader) {
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                return new ReconnectedToReader(reader);
            }

            public static /* synthetic */ ReconnectedToReader copy$default(ReconnectedToReader reconnectedToReader, com.stripe.stripeterminal.external.models.Reader reader, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    reader = reconnectedToReader.reader;
                }
                return reconnectedToReader.copy(reader);
            }

            @NotNull
            public String toString() {
                return "ReconnectedToReader(reader=" + this.reader + ')';
            }

            public int hashCode() {
                return this.reader.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ReconnectedToReader)) {
                    return false;
                }
                ReconnectedToReader reconnectedToReader = (ReconnectedToReader)other;
                return Intrinsics.areEqual((Object)this.reader, (Object)reconnectedToReader.reader);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u0082\u0001\u0003\u0005\u0006\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/connection/UsbReaderReconnector$ReconnectionEvent$UpdateConnectivity;", "Lcom/stripe/stripeterminal/internal/common/adapter/connection/UsbReaderReconnector$ReconnectionEvent;", "EndConnectAttempt", "GetReaderInfo", "StartConnectAttempt", "Lcom/stripe/stripeterminal/internal/common/adapter/connection/UsbReaderReconnector$ReconnectionEvent$UpdateConnectivity$EndConnectAttempt;", "Lcom/stripe/stripeterminal/internal/common/adapter/connection/UsbReaderReconnector$ReconnectionEvent$UpdateConnectivity$GetReaderInfo;", "Lcom/stripe/stripeterminal/internal/common/adapter/connection/UsbReaderReconnector$ReconnectionEvent$UpdateConnectivity$StartConnectAttempt;", "adapter_release"})
        public static interface UpdateConnectivity
        extends ReconnectionEvent {

            @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/connection/UsbReaderReconnector$ReconnectionEvent$UpdateConnectivity$EndConnectAttempt;", "Lcom/stripe/stripeterminal/internal/common/adapter/connection/UsbReaderReconnector$ReconnectionEvent$UpdateConnectivity;", "()V", "adapter_release"})
            public static final class EndConnectAttempt
            implements UpdateConnectivity {
                @NotNull
                public static final EndConnectAttempt INSTANCE = new EndConnectAttempt();

                private EndConnectAttempt() {
                }
            }

            @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/connection/UsbReaderReconnector$ReconnectionEvent$UpdateConnectivity$GetReaderInfo;", "Lcom/stripe/stripeterminal/internal/common/adapter/connection/UsbReaderReconnector$ReconnectionEvent$UpdateConnectivity;", "()V", "adapter_release"})
            public static final class GetReaderInfo
            implements UpdateConnectivity {
                @NotNull
                public static final GetReaderInfo INSTANCE = new GetReaderInfo();

                private GetReaderInfo() {
                }
            }

            @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/stripe/stripeterminal/internal/common/adapter/connection/UsbReaderReconnector$ReconnectionEvent$UpdateConnectivity$StartConnectAttempt;", "Lcom/stripe/stripeterminal/internal/common/adapter/connection/UsbReaderReconnector$ReconnectionEvent$UpdateConnectivity;", "reader", "Lcom/stripe/core/hardware/Reader;", "(Lcom/stripe/core/hardware/Reader;)V", "getReader", "()Lcom/stripe/core/hardware/Reader;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "adapter_release"})
            public static final class StartConnectAttempt
            implements UpdateConnectivity {
                @NotNull
                private final Reader reader;

                public StartConnectAttempt(@NotNull Reader reader) {
                    Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                    this.reader = reader;
                }

                @NotNull
                public final Reader getReader() {
                    return this.reader;
                }

                @NotNull
                public final Reader component1() {
                    return this.reader;
                }

                @NotNull
                public final StartConnectAttempt copy(@NotNull Reader reader) {
                    Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                    return new StartConnectAttempt(reader);
                }

                public static /* synthetic */ StartConnectAttempt copy$default(StartConnectAttempt startConnectAttempt, Reader reader, int n2, Object object) {
                    if ((n2 & 1) != 0) {
                        reader = startConnectAttempt.reader;
                    }
                    return startConnectAttempt.copy(reader);
                }

                @NotNull
                public String toString() {
                    return "StartConnectAttempt(reader=" + this.reader + ')';
                }

                public int hashCode() {
                    return this.reader.hashCode();
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof StartConnectAttempt)) {
                        return false;
                    }
                    StartConnectAttempt startConnectAttempt = (StartConnectAttempt)other;
                    return Intrinsics.areEqual((Object)this.reader, (Object)startConnectAttempt.reader);
                }
            }
        }
    }
}

