/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.api;

import com.squareup.wire.Message;
import com.stripe.jvmcore.currency.Amount;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.restclient.AuthenticatedRestClient;
import com.stripe.jvmcore.restclient.RestRequest;
import com.stripe.jvmcore.restclient.RestResponse;
import com.stripe.jvmcore.restclient.RestTimeout;
import com.stripe.jvmcore.terminal.api.ActivateReaderResponse;
import com.stripe.proto.api.rest.ActivateConnectionTokenRequest;
import com.stripe.proto.api.rest.ConfirmPaymentIntentRequest;
import com.stripe.proto.api.rest.RetrieveLocationRequest;
import com.stripe.proto.api.rest.UpdatePaymentIntentRequest;
import com.stripe.proto.model.merchant.ApiLocationPb;
import com.stripe.proto.model.rest.ActivatedConnectionToken;
import com.stripe.proto.model.rest.ErrorResponse;
import com.stripe.proto.model.rest.ErrorWrapper;
import com.stripe.proto.model.rest.PaymentIntentExpandedMethod;
import com.stripe.proto.model.rest.PaymentMethod;
import com.stripe.proto.model.rest.Refund;
import com.stripe.proto.model.rest.SetupIntent;
import com.stripe.proto.model.rest.StatusCode;
import com.stripe.stripeterminal.external.models.ConnectionConfiguration;
import com.stripe.stripeterminal.external.models.DeviceType;
import com.stripe.stripeterminal.external.models.ListLocationsParameters;
import com.stripe.stripeterminal.external.models.Location;
import com.stripe.stripeterminal.external.models.PaymentIntent;
import com.stripe.stripeterminal.external.models.PaymentIntentParameters;
import com.stripe.stripeterminal.external.models.ReadReusableCardParameters;
import com.stripe.stripeterminal.external.models.Reader;
import com.stripe.stripeterminal.external.models.SetupIntentCancellationParameters;
import com.stripe.stripeterminal.external.models.SetupIntentParameters;
import com.stripe.stripeterminal.external.models.TerminalException;
import com.stripe.stripeterminal.internal.common.api.ApiClient;
import com.stripe.stripeterminal.internal.common.api.ApiRequestFactory;
import com.stripe.stripeterminal.internal.common.api.DiscoverLocationsResponse;
import com.stripe.stripeterminal.internal.common.api.ListAllReadersResponse;
import com.stripe.stripeterminal.internal.common.api.ListLocationsResponse;
import com.stripe.stripeterminal.internal.common.proto.ProtoConverter;
import com.stripe.stripeterminal.internal.models.PaymentMethodData;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 <2\u00020\u0001:\u0001<B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J,\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0017J \u0010\u001f\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\u0010\u001b\u001a\u0004\u0018\u00010\fJ\u0016\u0010$\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020%2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010&\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020'J\u000e\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020 J\u001c\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000e0-2\u0006\u0010\r\u001a\u00020\u000eJ&\u0010.\u001a\u00020/2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u00100\u001a\u0004\u0018\u0001012\n\b\u0002\u00102\u001a\u0004\u0018\u00010\u000eJ\u0016\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u00107\u001a\u00020\u00142\u0006\u00108\u001a\u00020\u000e2\n\b\u0002\u00109\u001a\u0004\u0018\u00010\u000eJ\u001a\u0010:\u001a\u00020\u00172\u0006\u00108\u001a\u00020\u000e2\n\b\u0002\u00109\u001a\u0004\u0018\u00010\u000eJ\"\u0010;\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006="}, d2={"Lcom/stripe/stripeterminal/internal/common/api/ApiClient;", "", "apiRequestFactory", "Lcom/stripe/stripeterminal/internal/common/api/ApiRequestFactory;", "restClient", "Lcom/stripe/jvmcore/restclient/AuthenticatedRestClient;", "(Lcom/stripe/stripeterminal/internal/common/api/ApiRequestFactory;Lcom/stripe/jvmcore/restclient/AuthenticatedRestClient;)V", "getRestClient", "()Lcom/stripe/jvmcore/restclient/AuthenticatedRestClient;", "activateReader", "Lcom/stripe/jvmcore/terminal/api/ActivateReaderResponse;", "reader", "Lcom/stripe/stripeterminal/external/models/Reader;", "token", "", "connectionConfig", "Lcom/stripe/stripeterminal/external/models/ConnectionConfiguration;", "timeout", "Lcom/stripe/jvmcore/restclient/RestTimeout;", "cancelPaymentIntent", "Lcom/stripe/stripeterminal/external/models/PaymentIntent;", "intent", "cancelSetupIntent", "Lcom/stripe/stripeterminal/external/models/SetupIntent;", "params", "Lcom/stripe/stripeterminal/external/models/SetupIntentCancellationParameters;", "confirmPaymentIntent", "connectedReader", "amountTip", "Lcom/stripe/jvmcore/currency/Amount;", "confirmSetupIntent", "createCardPaymentMethod", "Lcom/stripe/stripeterminal/external/models/PaymentMethod;", "Lcom/stripe/stripeterminal/external/models/ReadReusableCardParameters;", "paymentMethodData", "Lcom/stripe/stripeterminal/internal/models/PaymentMethodData;", "createPaymentIntent", "Lcom/stripe/stripeterminal/external/models/PaymentIntentParameters;", "createSetupIntent", "Lcom/stripe/stripeterminal/external/models/SetupIntentParameters;", "detachPaymentMethod", "method", "discoverLocations", "Lcom/stripe/stripeterminal/internal/common/api/DiscoverLocationsResponse;", "devices", "", "listAllReaders", "Lcom/stripe/stripeterminal/internal/common/api/ListAllReadersResponse;", "deviceType", "Lcom/stripe/stripeterminal/external/models/DeviceType;", "location", "listLocations", "Lcom/stripe/stripeterminal/internal/common/api/ListLocationsResponse;", "parameters", "Lcom/stripe/stripeterminal/external/models/ListLocationsParameters;", "retrievePaymentIntent", "clientSecret", "connectionToken", "retrieveSetupIntent", "updatePaymentIntentExpandMethod", "Companion", "common_publish"})
@SourceDebugExtension(value={"SMAP\nApiClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiClient.kt\ncom/stripe/stripeterminal/internal/common/api/ApiClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,292:1\n1#2:293\n*E\n"})
public final class ApiClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ApiRequestFactory apiRequestFactory;
    @NotNull
    private final AuthenticatedRestClient restClient;
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(ApiClient.class);

    @Inject
    public ApiClient(@NotNull ApiRequestFactory apiRequestFactory, @NotNull AuthenticatedRestClient restClient) {
        Intrinsics.checkNotNullParameter((Object)apiRequestFactory, (String)"apiRequestFactory");
        Intrinsics.checkNotNullParameter((Object)restClient, (String)"restClient");
        this.apiRequestFactory = apiRequestFactory;
        this.restClient = restClient;
    }

    @NotNull
    public final AuthenticatedRestClient getRestClient() {
        return this.restClient;
    }

    @NotNull
    public final ActivateReaderResponse activateReader(@NotNull Reader reader, @NotNull String token, @NotNull ConnectionConfiguration connectionConfig, @NotNull RestTimeout timeout) throws TerminalException {
        Object object;
        boolean bl;
        String string;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)connectionConfig, (String)"connectionConfig");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        LOGGER.d("activateReader", new Pair[0]);
        ActivateConnectionTokenRequest request = this.apiRequestFactory.activateReader(reader, connectionConfig);
        RestResponse<ActivatedConnectionToken, ErrorWrapper> response = this.restClient.activateTerminal(token, "", request, timeout);
        ActivatedConnectionToken decodedResponse = (ActivatedConnectionToken)com.stripe.stripeterminal.internal.common.api.ApiClient$Companion.decodeResponse$default(Companion, response, null, 2, null);
        ActivatedConnectionToken.AccountRef accountRef = decodedResponse.account_ref;
        String string2 = string = accountRef != null ? accountRef.store_id : null;
        if (string == null) {
            bl = true;
        } else {
            Location location = reader.getLocation();
            bl = Intrinsics.areEqual((Object)string, (Object)(location != null ? location.getId() : null));
        }
        if (bl) {
            Location location = reader.getLocation();
            object = location != null ? ProtoConverter.INSTANCE.toProtoLocation(location) : null;
        } else {
            Object object2;
            try {
                object2 = this.restClient;
                String string3 = decodedResponse.stripe_session_token;
                if (string3 == null) {
                    string3 = "";
                }
                String string4 = string3;
                ActivatedConnectionToken.AccountRef accountRef2 = decodedResponse.account_ref;
                RetrieveLocationRequest retrieveLocationRequest = new RetrieveLocationRequest(accountRef2 != null ? accountRef2.store_id : null, null, 2, null);
                RestResponse<ApiLocationPb, ErrorWrapper> it = object2.retrieveLocationWithSessionToken(retrieveLocationRequest, string4);
                boolean bl2 = false;
                object2 = (ApiLocationPb)com.stripe.stripeterminal.internal.common.api.ApiClient$Companion.decodeResponse$default(Companion, it, null, 2, null);
            }
            catch (Throwable e2) {
                LOGGER.w(e2, "Error fetching location after reader activation.", new Pair[0]);
                object2 = null;
            }
            object = object2;
        }
        ApiLocationPb location = object;
        Boolean bl3 = decodedResponse.livemode;
        return new ActivateReaderResponse(decodedResponse.account_id, bl3 != null ? bl3 : false, decodedResponse.reader_id, decodedResponse.stripe_session_token, decodedResponse.offline_stripe_session_token, decodedResponse.sdk_rpc_session_token, decodedResponse.connection_context_id, null, location);
    }

    @NotNull
    public final PaymentIntent cancelPaymentIntent(@NotNull PaymentIntent intent) throws TerminalException {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        LOGGER.d("cancelPaymentIntent", new Pair[0]);
        RestResponse<com.stripe.proto.model.rest.PaymentIntent, ErrorWrapper> response = this.restClient.cancelPaymentIntent(this.apiRequestFactory.cancelPaymentIntent(intent));
        return ProtoConverter.INSTANCE.toSdkPaymentIntent((com.stripe.proto.model.rest.PaymentIntent)com.stripe.stripeterminal.internal.common.api.ApiClient$Companion.decodeResponse$default(Companion, response, null, 2, null));
    }

    @NotNull
    public final PaymentIntent confirmPaymentIntent(@NotNull PaymentIntent intent, @Nullable Reader connectedReader2, @Nullable Amount amountTip, @NotNull RestTimeout timeout) throws TerminalException {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        LOGGER.d("confirmPaymentIntent", new Pair[0]);
        Reader reader = connectedReader2;
        RestRequest<ConfirmPaymentIntentRequest, ConfirmPaymentIntentRequest.Builder> restRequest = this.apiRequestFactory.confirmPaymentIntent(intent, reader != null ? reader.getId() : null, amountTip);
        RestResponse<com.stripe.proto.model.rest.PaymentIntent, ErrorWrapper> response = this.restClient.confirmPaymentIntent(restRequest.getBody(), restRequest.getHeaders(), timeout);
        return ProtoConverter.INSTANCE.toSdkPaymentIntent((com.stripe.proto.model.rest.PaymentIntent)com.stripe.stripeterminal.internal.common.api.ApiClient$Companion.decodeResponse$default(Companion, response, null, 2, null));
    }

    public static /* synthetic */ PaymentIntent confirmPaymentIntent$default(ApiClient apiClient, PaymentIntent paymentIntent2, Reader reader, Amount amount, RestTimeout restTimeout, int n2, Object object) throws TerminalException {
        if ((n2 & 4) != 0) {
            amount = null;
        }
        return apiClient.confirmPaymentIntent(paymentIntent2, reader, amount, restTimeout);
    }

    @NotNull
    public final PaymentIntent updatePaymentIntentExpandMethod(@NotNull PaymentIntent intent, @Nullable Reader connectedReader2, @Nullable Amount amountTip) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        LOGGER.d("updatePaymentIntentExpandMethod", new Pair[0]);
        Reader reader = connectedReader2;
        RestRequest<UpdatePaymentIntentRequest, UpdatePaymentIntentRequest.Builder> restRequest = this.apiRequestFactory.updatePaymentIntent(intent, reader != null ? reader.getId() : null, amountTip);
        RestResponse<PaymentIntentExpandedMethod, ErrorWrapper> response = this.restClient.updatePaymentIntentExpandedMethod(restRequest.getBody(), restRequest.getHeaders());
        return ProtoConverter.INSTANCE.toSdkPaymentIntent((PaymentIntentExpandedMethod)com.stripe.stripeterminal.internal.common.api.ApiClient$Companion.decodeResponse$default(Companion, response, null, 2, null));
    }

    @NotNull
    public final com.stripe.stripeterminal.external.models.PaymentMethod createCardPaymentMethod(@NotNull ReadReusableCardParameters params, @NotNull PaymentMethodData paymentMethodData, @Nullable Reader connectedReader2) throws TerminalException {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)paymentMethodData, (String)"paymentMethodData");
        LOGGER.d("createCardPaymentMethod", new Pair[0]);
        Reader reader = connectedReader2;
        RestResponse<PaymentMethod, ErrorWrapper> response = this.restClient.readCardPaymentMethod(this.apiRequestFactory.createPaymentMethod(params, paymentMethodData, reader != null ? reader.getId() : null));
        return ProtoConverter.INSTANCE.toSdkPaymentMethod((PaymentMethod)com.stripe.stripeterminal.internal.common.api.ApiClient$Companion.decodeResponse$default(Companion, response, null, 2, null));
    }

    @NotNull
    public final PaymentIntent createPaymentIntent(@NotNull PaymentIntentParameters params, @NotNull RestTimeout timeout) throws TerminalException {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        LOGGER.d("createPaymentIntent", new Pair[0]);
        RestResponse<com.stripe.proto.model.rest.PaymentIntent, ErrorWrapper> response = this.restClient.createPaymentIntent(this.apiRequestFactory.createPaymentIntent(params), timeout);
        return ProtoConverter.INSTANCE.toSdkPaymentIntent((com.stripe.proto.model.rest.PaymentIntent)com.stripe.stripeterminal.internal.common.api.ApiClient$Companion.decodeResponse$default(Companion, response, null, 2, null));
    }

    @NotNull
    public final com.stripe.stripeterminal.external.models.SetupIntent retrieveSetupIntent(@NotNull String clientSecret, @Nullable String connectionToken) throws TerminalException {
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        LOGGER.d("retrieveSetupIntent", new Pair[0]);
        RestResponse<SetupIntent, ErrorWrapper> response = this.restClient.retrieveSetupIntent(this.apiRequestFactory.retrieveSetupIntent(clientSecret), connectionToken);
        return ProtoConverter.INSTANCE.toSdkSetupIntent((SetupIntent)com.stripe.stripeterminal.internal.common.api.ApiClient$Companion.decodeResponse$default(Companion, response, null, 2, null));
    }

    public static /* synthetic */ com.stripe.stripeterminal.external.models.SetupIntent retrieveSetupIntent$default(ApiClient apiClient, String string, String string2, int n2, Object object) throws TerminalException {
        if ((n2 & 2) != 0) {
            string2 = null;
        }
        return apiClient.retrieveSetupIntent(string, string2);
    }

    @NotNull
    public final com.stripe.stripeterminal.external.models.SetupIntent confirmSetupIntent(@NotNull com.stripe.stripeterminal.external.models.SetupIntent intent) throws TerminalException {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        LOGGER.d("confirmSetupIntent", new Pair[0]);
        RestResponse<SetupIntent, ErrorWrapper> response = this.restClient.confirmSetupIntent(this.apiRequestFactory.confirmSetupIntent(intent));
        return ProtoConverter.INSTANCE.toSdkSetupIntent((SetupIntent)com.stripe.stripeterminal.internal.common.api.ApiClient$Companion.decodeResponse$default(Companion, response, null, 2, null));
    }

    @NotNull
    public final com.stripe.stripeterminal.external.models.SetupIntent createSetupIntent(@NotNull SetupIntentParameters params) throws TerminalException {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        LOGGER.d("createSetupIntent", new Pair[0]);
        RestResponse<SetupIntent, ErrorWrapper> response = this.restClient.createSetupIntent(this.apiRequestFactory.createSetupIntent(params));
        return ProtoConverter.INSTANCE.toSdkSetupIntent((SetupIntent)com.stripe.stripeterminal.internal.common.api.ApiClient$Companion.decodeResponse$default(Companion, response, null, 2, null));
    }

    @NotNull
    public final com.stripe.stripeterminal.external.models.SetupIntent cancelSetupIntent(@NotNull com.stripe.stripeterminal.external.models.SetupIntent intent, @NotNull SetupIntentCancellationParameters params) throws TerminalException {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        LOGGER.d("cancelSetupIntent", new Pair[0]);
        RestResponse<SetupIntent, ErrorWrapper> response = this.restClient.cancelSetupIntent(this.apiRequestFactory.cancelSetupIntent(intent, params));
        return ProtoConverter.INSTANCE.toSdkSetupIntent((SetupIntent)com.stripe.stripeterminal.internal.common.api.ApiClient$Companion.decodeResponse$default(Companion, response, null, 2, null));
    }

    @NotNull
    public final com.stripe.stripeterminal.external.models.PaymentMethod detachPaymentMethod(@NotNull com.stripe.stripeterminal.external.models.PaymentMethod method) throws TerminalException {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        LOGGER.d("detachPaymentMethod", new Pair[0]);
        RestResponse<PaymentMethod, ErrorWrapper> response = this.restClient.detachPaymentMethod(this.apiRequestFactory.detachPaymentMethod(method));
        return ProtoConverter.INSTANCE.toSdkPaymentMethod((PaymentMethod)com.stripe.stripeterminal.internal.common.api.ApiClient$Companion.decodeResponse$default(Companion, response, null, 2, null));
    }

    @NotNull
    public final DiscoverLocationsResponse discoverLocations(@NotNull List<String> devices, @NotNull String token) throws TerminalException {
        Intrinsics.checkNotNullParameter(devices, (String)"devices");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        LOGGER.d("discoverLocations", new Pair[0]);
        RestResponse<com.stripe.proto.api.rest.DiscoverLocationsResponse, ErrorWrapper> response = this.restClient.discoverLocations(token, this.apiRequestFactory.discoverLocations(devices));
        return ProtoConverter.INSTANCE.toSdkDiscoverLocationsResponse((com.stripe.proto.api.rest.DiscoverLocationsResponse)com.stripe.stripeterminal.internal.common.api.ApiClient$Companion.decodeResponse$default(Companion, response, null, 2, null));
    }

    @NotNull
    public final ListAllReadersResponse listAllReaders(@NotNull String token, @Nullable DeviceType deviceType, @Nullable String location) throws TerminalException {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        LOGGER.d("listAllReaders", new Pair[0]);
        RestResponse<com.stripe.proto.api.rest.ListAllReadersResponse, ErrorWrapper> response = this.restClient.listAllReaders(token, this.apiRequestFactory.listAllReaders(deviceType, location), RestTimeout.DEFAULT.INSTANCE);
        return ProtoConverter.INSTANCE.toSdkListAllReadersResponse((com.stripe.proto.api.rest.ListAllReadersResponse)com.stripe.stripeterminal.internal.common.api.ApiClient$Companion.decodeResponse$default(Companion, response, null, 2, null));
    }

    public static /* synthetic */ ListAllReadersResponse listAllReaders$default(ApiClient apiClient, String string, DeviceType deviceType, String string2, int n2, Object object) throws TerminalException {
        if ((n2 & 2) != 0) {
            deviceType = null;
        }
        if ((n2 & 4) != 0) {
            string2 = null;
        }
        return apiClient.listAllReaders(string, deviceType, string2);
    }

    @NotNull
    public final PaymentIntent retrievePaymentIntent(@NotNull String clientSecret, @Nullable String connectionToken) throws TerminalException {
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        LOGGER.d("retrievePaymentIntent", new Pair[0]);
        RestResponse<com.stripe.proto.model.rest.PaymentIntent, ErrorWrapper> response = this.restClient.retrievePaymentIntent(this.apiRequestFactory.retrievePaymentIntent(clientSecret), connectionToken);
        return ProtoConverter.INSTANCE.toSdkPaymentIntent((com.stripe.proto.model.rest.PaymentIntent)com.stripe.stripeterminal.internal.common.api.ApiClient$Companion.decodeResponse$default(Companion, response, null, 2, null));
    }

    public static /* synthetic */ PaymentIntent retrievePaymentIntent$default(ApiClient apiClient, String string, String string2, int n2, Object object) throws TerminalException {
        if ((n2 & 2) != 0) {
            string2 = null;
        }
        return apiClient.retrievePaymentIntent(string, string2);
    }

    @NotNull
    public final ListLocationsResponse listLocations(@NotNull ListLocationsParameters parameters, @NotNull String token) throws TerminalException {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        LOGGER.d("listLocations", new Pair[0]);
        RestResponse<com.stripe.proto.api.rest.ListLocationsResponse, ErrorWrapper> response = this.restClient.listLocations(this.apiRequestFactory.listLocations(parameters), token);
        return ProtoConverter.INSTANCE.toSdkListLocationsResponse((com.stripe.proto.api.rest.ListLocationsResponse)com.stripe.stripeterminal.internal.common.api.ApiClient$Companion.decodeResponse$default(Companion, response, null, 2, null));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\bJ\u001a\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\bJM\u0010\f\u001a\u0002H\r\"\u0012\b\u0000\u0010\r*\f\u0012\u0004\u0012\u0002H\r\u0012\u0002\b\u00030\u000e2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u00020\t0\b2\u0018\b\u0002\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u0002H\r\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/stripe/stripeterminal/internal/common/api/ApiClient$Companion;", "", "()V", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "decodePaymentResponseCatchingLastPaymentError", "Lcom/stripe/proto/model/rest/PaymentIntent;", "response", "Lcom/stripe/jvmcore/restclient/RestResponse;", "Lcom/stripe/proto/model/rest/ErrorWrapper;", "decodeRefundResponseCatchingInlineFailure", "Lcom/stripe/proto/model/rest/Refund;", "decodeResponse", "T", "Lcom/squareup/wire/Message;", "getInlineError", "Lkotlin/Function1;", "Lcom/stripe/proto/model/rest/ErrorResponse;", "(Lcom/stripe/jvmcore/restclient/RestResponse;Lkotlin/jvm/functions/Function1;)Lcom/squareup/wire/Message;", "common_publish"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T extends Message<T, ?>> T decodeResponse(@NotNull RestResponse<T, ErrorWrapper> response, @Nullable Function1<? super T, ErrorResponse> getInlineError) throws TerminalException {
            Intrinsics.checkNotNullParameter(response, (String)"response");
            RestResponse<T, ErrorWrapper> restResponse = response;
            if (restResponse instanceof RestResponse.Success) {
                ErrorResponse errorResponse;
                if (getInlineError != null && (errorResponse = (ErrorResponse)((Object)getInlineError.invoke(((RestResponse.Success)response).getResponse()))) != null) {
                    ErrorResponse it = errorResponse;
                    boolean bl = false;
                    throw ProtoConverter.INSTANCE.toTerminalException(it);
                }
            } else {
                if (restResponse instanceof RestResponse.ServerError) {
                    if (response.getStatusCode() == StatusCode.HTTP_ERROR || response.getStatusCode() == StatusCode.HTTP_ERROR_UNKNOWN_STATE) {
                        throw new TerminalException(TerminalException.TerminalErrorCode.STRIPE_API_CONNECTION_ERROR, "Could not connect to Stripe. Please retry.", null, null, 12, null);
                    }
                    throw ProtoConverter.INSTANCE.toTerminalException(((ErrorWrapper)((Object)((RestResponse.ServerError)response).getResponse())).error);
                }
                if (restResponse instanceof RestResponse.ParseError) {
                    throw new TerminalException(TerminalException.TerminalErrorCode.STRIPE_API_RESPONSE_DECODING_ERROR, response.toLogString(), null, null, 12, null);
                }
                throw new NoWhenBranchMatchedException();
            }
            Companion $this$decodeResponse_u24lambda_u241 = this;
            boolean bl = false;
            return (T)((RestResponse.Success)response).getResponse();
        }

        public static /* synthetic */ Message decodeResponse$default(Companion companion, RestResponse restResponse, Function1 function1, int n2, Object object) throws TerminalException {
            if ((n2 & 2) != 0) {
                function1 = null;
            }
            return companion.decodeResponse(restResponse, function1);
        }

        @NotNull
        public final Refund decodeRefundResponseCatchingInlineFailure(@NotNull RestResponse<Refund, ErrorWrapper> response) {
            Intrinsics.checkNotNullParameter(response, (String)"response");
            return this.decodeResponse(response, decodeRefundResponseCatchingInlineFailure.1.INSTANCE);
        }

        @NotNull
        public final com.stripe.proto.model.rest.PaymentIntent decodePaymentResponseCatchingLastPaymentError(@NotNull RestResponse<com.stripe.proto.model.rest.PaymentIntent, ErrorWrapper> response) {
            Intrinsics.checkNotNullParameter(response, (String)"response");
            return this.decodeResponse(response, decodePaymentResponseCatchingLastPaymentError.1.INSTANCE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

