/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.api;

import android.location.Location;
import com.squareup.wire.Message;
import com.stripe.core.transaction.SettingsRepository;
import com.stripe.core.transaction.TransactionRepository;
import com.stripe.jvmcore.currency.Amount;
import com.stripe.jvmcore.hardware.emv.TransactionResult;
import com.stripe.jvmcore.restclient.RestRequest;
import com.stripe.jvmcore.terminal.api.PosInfo;
import com.stripe.jvmcore.terminal.api.PosInfoFactory;
import com.stripe.jvmcore.transaction.payment.EmvPaymentKt;
import com.stripe.jvmcore.transaction.payment.ManualEntryPayment;
import com.stripe.proto.api.rest.ActivateConnectionTokenRequest;
import com.stripe.proto.api.rest.AddEmvSecondGenerationDataRefundRequest;
import com.stripe.proto.api.rest.AddEmvSecondGenerationDataRequest;
import com.stripe.proto.api.rest.CancelPaymentIntentRequest;
import com.stripe.proto.api.rest.CancelSetupIntentRequest;
import com.stripe.proto.api.rest.ConfirmPaymentIntentRequest;
import com.stripe.proto.api.rest.ConfirmSetupIntentRequest;
import com.stripe.proto.api.rest.ConnectionType;
import com.stripe.proto.api.rest.CreatePaymentIntentRequest;
import com.stripe.proto.api.rest.CreateSetupIntentRequest;
import com.stripe.proto.api.rest.DetachPaymentMethodRequest;
import com.stripe.proto.api.rest.DiscoverLocationsRequest;
import com.stripe.proto.api.rest.ListAllReadersRequest;
import com.stripe.proto.api.rest.ListLocationsRequest;
import com.stripe.proto.api.rest.PaymentMethodOptions;
import com.stripe.proto.api.rest.ReadCardPaymentMethodRequest;
import com.stripe.proto.api.rest.RefundChargeRequest;
import com.stripe.proto.api.rest.ReportedReaderConfig;
import com.stripe.proto.api.rest.RequestedPaymentMethod;
import com.stripe.proto.api.rest.RetrieveLocationRequest;
import com.stripe.proto.api.rest.RetrievePaymentIntentRequest;
import com.stripe.proto.api.rest.RetrieveSetupIntentRequest;
import com.stripe.proto.api.rest.UpdatePaymentIntentRequest;
import com.stripe.proto.model.common.DeviceInfo;
import com.stripe.proto.model.common.VersionInfoPb;
import com.stripe.stripeterminal.external.models.ConnectionConfiguration;
import com.stripe.stripeterminal.external.models.DeviceType;
import com.stripe.stripeterminal.external.models.ListLocationsParameters;
import com.stripe.stripeterminal.external.models.PaymentIntent;
import com.stripe.stripeterminal.external.models.PaymentIntentParameters;
import com.stripe.stripeterminal.external.models.PaymentMethod;
import com.stripe.stripeterminal.external.models.PosConnectionType;
import com.stripe.stripeterminal.external.models.ReadReusableCardParameters;
import com.stripe.stripeterminal.external.models.Reader;
import com.stripe.stripeterminal.external.models.SetupIntent;
import com.stripe.stripeterminal.external.models.SetupIntentCancellationParameters;
import com.stripe.stripeterminal.external.models.SetupIntentCancellationReason;
import com.stripe.stripeterminal.external.models.SetupIntentParameters;
import com.stripe.stripeterminal.external.models.TerminalException;
import com.stripe.stripeterminal.internal.common.LocationHandler;
import com.stripe.stripeterminal.internal.common.TerminalStatusManager;
import com.stripe.stripeterminal.internal.common.extensions.ReaderExtensionsKt;
import com.stripe.stripeterminal.internal.common.makers.CreatePaymentIntentRequestMaker;
import com.stripe.stripeterminal.internal.common.makers.CreateSetupIntentRequestMaker;
import com.stripe.stripeterminal.internal.models.PaymentMethodData;
import com.stripe.stripeterminal.internal.models.ReadMethod;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00de\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 v2\u00020\u0001:\u0001vB/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J&\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014j\u0002`\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0019J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020!2\u0006\u0010\"\u001a\u00020#J2\u0010$\u001a\u0012\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&0\u0014j\u0002`'2\u0006\u0010\u001e\u001a\u00020\u00192\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010+J&\u0010,\u001a\u0012\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&0\u0014j\u0002`'2\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010-\u001a\u00020.J\u0016\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020!2\u0006\u0010-\u001a\u00020.J4\u00102\u001a\u0012\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&0\u0014j\u0002`'2\u0006\u0010\u001e\u001a\u00020\u00192\b\u00103\u001a\u0004\u0018\u0001042\n\b\u0002\u0010*\u001a\u0004\u0018\u00010+J>\u00105\u001a\u0012\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&0\u0014j\u0002`'2\u0006\u0010\u001e\u001a\u00020\u00192\b\u0010(\u001a\u0004\u0018\u00010)2\b\u00106\u001a\u0004\u0018\u0001072\b\u0010*\u001a\u0004\u0018\u00010+H\u0002J\u000e\u00108\u001a\u0002002\u0006\u00101\u001a\u00020!J\u000e\u00109\u001a\u00020:2\u0006\u0010\"\u001a\u00020;J \u0010<\u001a\u00020=2\u0006\u0010\"\u001a\u00020>2\u0006\u0010?\u001a\u00020@2\b\u00103\u001a\u0004\u0018\u000104J\u001a\u0010A\u001a\u00020)2\u0006\u0010?\u001a\u00020@2\b\u00103\u001a\u0004\u0018\u000104H\u0002J\u000e\u0010B\u001a\u00020C2\u0006\u0010\"\u001a\u00020DJ\u000e\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HJ\u0014\u0010I\u001a\u00020J2\f\u0010K\u001a\b\u0012\u0004\u0012\u0002040LJB\u0010M\u001a\u0012\u0012\u0004\u0012\u00020N\u0012\u0004\u0012\u00020O0\u0014j\u0002`P2\b\u0010Q\u001a\u0004\u0018\u0001042\u0006\u0010R\u001a\u00020\u001b2\u0006\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020T2\b\u0010V\u001a\u0004\u0018\u000104J\u001e\u0010W\u001a\u00020X2\n\b\u0002\u0010Y\u001a\u0004\u0018\u00010Z2\n\b\u0002\u0010[\u001a\u0004\u0018\u000104J\u000e\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020_J\u0010\u0010`\u001a\u00020)2\u0006\u0010-\u001a\u00020.H\u0002Jd\u0010a\u001a\u0012\u0012\u0004\u0012\u00020b\u0012\u0004\u0012\u00020c0\u0014j\u0002`d2\u0006\u0010e\u001a\u0002042\u0006\u0010f\u001a\u00020g2\u0006\u0010(\u001a\u00020)2\u0006\u0010U\u001a\u00020T2\u0006\u0010S\u001a\u00020T2\u0006\u0010h\u001a\u0002042\u0012\u0010i\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u0002040j2\b\u0010V\u001a\u0004\u0018\u000104J\u000e\u0010k\u001a\u00020l2\u0006\u0010m\u001a\u000204J\u000e\u0010n\u001a\u00020o2\u0006\u0010p\u001a\u000204J\u000e\u0010q\u001a\u00020r2\u0006\u0010p\u001a\u000204J.\u0010s\u001a\u000e\u0012\u0004\u0012\u00020t\u0012\u0004\u0012\u00020u0\u00142\u0006\u0010\u001e\u001a\u00020\u00192\b\u00103\u001a\u0004\u0018\u0001042\b\u0010*\u001a\u0004\u0018\u00010+R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006w"}, d2={"Lcom/stripe/stripeterminal/internal/common/api/ApiRequestFactory;", "", "posInfoFactory", "Lcom/stripe/jvmcore/terminal/api/PosInfoFactory;", "locationHandler", "Lcom/stripe/stripeterminal/internal/common/LocationHandler;", "statusManager", "Lcom/stripe/stripeterminal/internal/common/TerminalStatusManager;", "settingsRepository", "Lcom/stripe/core/transaction/SettingsRepository;", "transactionRepository", "Lcom/stripe/core/transaction/TransactionRepository;", "(Lcom/stripe/jvmcore/terminal/api/PosInfoFactory;Lcom/stripe/stripeterminal/internal/common/LocationHandler;Lcom/stripe/stripeterminal/internal/common/TerminalStatusManager;Lcom/stripe/core/transaction/SettingsRepository;Lcom/stripe/core/transaction/TransactionRepository;)V", "activateReader", "Lcom/stripe/proto/api/rest/ActivateConnectionTokenRequest;", "reader", "Lcom/stripe/stripeterminal/external/models/Reader;", "connectionConfig", "Lcom/stripe/stripeterminal/external/models/ConnectionConfiguration;", "addEmvSecondGenerationData", "Lcom/stripe/jvmcore/restclient/RestRequest;", "Lcom/stripe/proto/api/rest/AddEmvSecondGenerationDataRequest;", "Lcom/stripe/proto/api/rest/AddEmvSecondGenerationDataRequest$Builder;", "Lcom/stripe/stripeterminal/internal/common/api/AddEmvSecondGenerationDataRestRequest;", "paymentIntent", "Lcom/stripe/stripeterminal/external/models/PaymentIntent;", "transactionResult", "Lcom/stripe/jvmcore/hardware/emv/TransactionResult;", "cancelPaymentIntent", "Lcom/stripe/proto/api/rest/CancelPaymentIntentRequest;", "intent", "cancelSetupIntent", "Lcom/stripe/proto/api/rest/CancelSetupIntentRequest;", "Lcom/stripe/stripeterminal/external/models/SetupIntent;", "params", "Lcom/stripe/stripeterminal/external/models/SetupIntentCancellationParameters;", "confirmCollectiblePayment", "Lcom/stripe/proto/api/rest/ConfirmPaymentIntentRequest;", "Lcom/stripe/proto/api/rest/ConfirmPaymentIntentRequest$Builder;", "Lcom/stripe/stripeterminal/internal/common/api/ConfirmPaymentIntentRestRequest;", "paymentMethodData", "Lcom/stripe/proto/api/rest/RequestedPaymentMethod;", "amountTip", "Lcom/stripe/jvmcore/currency/Amount;", "confirmManualEntryPaymentIntent", "manualEntryPayment", "Lcom/stripe/jvmcore/transaction/payment/ManualEntryPayment;", "confirmManualEntrySetupIntent", "Lcom/stripe/proto/api/rest/ConfirmSetupIntentRequest;", "setupIntent", "confirmPaymentIntent", "readerId", "", "confirmPaymentIntentRequest", "paymentMethodOptions", "Lcom/stripe/proto/api/rest/PaymentMethodOptions;", "confirmSetupIntent", "createPaymentIntent", "Lcom/stripe/proto/api/rest/CreatePaymentIntentRequest;", "Lcom/stripe/stripeterminal/external/models/PaymentIntentParameters;", "createPaymentMethod", "Lcom/stripe/proto/api/rest/ReadCardPaymentMethodRequest;", "Lcom/stripe/stripeterminal/external/models/ReadReusableCardParameters;", "data", "Lcom/stripe/stripeterminal/internal/models/PaymentMethodData;", "createPaymentMethodRequest", "createSetupIntent", "Lcom/stripe/proto/api/rest/CreateSetupIntentRequest;", "Lcom/stripe/stripeterminal/external/models/SetupIntentParameters;", "detachPaymentMethod", "Lcom/stripe/proto/api/rest/DetachPaymentMethodRequest;", "method", "Lcom/stripe/stripeterminal/external/models/PaymentMethod;", "discoverLocations", "Lcom/stripe/proto/api/rest/DiscoverLocationsRequest;", "serialNumbers", "", "emvSecondGenerationDataRefundRequest", "Lcom/stripe/proto/api/rest/AddEmvSecondGenerationDataRefundRequest;", "Lcom/stripe/proto/api/rest/AddEmvSecondGenerationDataRefundRequest$Builder;", "Lcom/stripe/stripeterminal/internal/common/api/AddEmvSecondGenerationRefundDataRestRequest;", "refundId", "result", "refundApplicationFee", "", "reverseTransfer", "stripeAccountId", "listAllReaders", "Lcom/stripe/proto/api/rest/ListAllReadersRequest;", "deviceType", "Lcom/stripe/stripeterminal/external/models/DeviceType;", "location", "listLocations", "Lcom/stripe/proto/api/rest/ListLocationsRequest;", "parameters", "Lcom/stripe/stripeterminal/external/models/ListLocationsParameters;", "manualEntryRequestedPaymentMethod", "refundChargeRequest", "Lcom/stripe/proto/api/rest/RefundChargeRequest;", "Lcom/stripe/proto/api/rest/RefundChargeRequest$Builder;", "Lcom/stripe/stripeterminal/internal/common/api/RefundChargeRestRequest;", "charge", "amount", "", "reason", "metadata", "", "retrieveLocation", "Lcom/stripe/proto/api/rest/RetrieveLocationRequest;", "id", "retrievePaymentIntent", "Lcom/stripe/proto/api/rest/RetrievePaymentIntentRequest;", "clientSecret", "retrieveSetupIntent", "Lcom/stripe/proto/api/rest/RetrieveSetupIntentRequest;", "updatePaymentIntent", "Lcom/stripe/proto/api/rest/UpdatePaymentIntentRequest;", "Lcom/stripe/proto/api/rest/UpdatePaymentIntentRequest$Builder;", "Companion", "common_publish"})
@SourceDebugExtension(value={"SMAP\nApiRequestFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiRequestFactory.kt\ncom/stripe/stripeterminal/internal/common/api/ApiRequestFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,618:1\n1#2:619\n*E\n"})
public final class ApiRequestFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PosInfoFactory posInfoFactory;
    @NotNull
    private final LocationHandler locationHandler;
    @NotNull
    private final TerminalStatusManager statusManager;
    @NotNull
    private final SettingsRepository settingsRepository;
    @NotNull
    private final TransactionRepository transactionRepository;
    @NotNull
    private static final String CARD_TYPE = "card";
    @NotNull
    private static final String CARD_PRESENT_TYPE = "card_present";
    @NotNull
    private static final String EMV_TYPE = "emv";
    @NotNull
    private static final String ENCRYPTED_EMV_TYPE = "encrypted_emv";
    @NotNull
    private static final String ENCRYPTED_TRACK_DATA_TYPE = "encrypted_track_data";
    @NotNull
    private static final String INTERAC_PRESENT_TYPE = "interac_present";
    @NotNull
    private static final String INVALID_CLIENT_SECRET = "Invalid client secret.";
    @NotNull
    private static final String SECRET_DELIMITER = "_secret_";
    @NotNull
    private static final String STRIPE_ACCOUNT_HEADER = "Stripe-Account";

    @Inject
    public ApiRequestFactory(@NotNull PosInfoFactory posInfoFactory, @NotNull LocationHandler locationHandler, @NotNull TerminalStatusManager statusManager, @NotNull SettingsRepository settingsRepository, @NotNull TransactionRepository transactionRepository) {
        Intrinsics.checkNotNullParameter((Object)posInfoFactory, (String)"posInfoFactory");
        Intrinsics.checkNotNullParameter((Object)locationHandler, (String)"locationHandler");
        Intrinsics.checkNotNullParameter((Object)statusManager, (String)"statusManager");
        Intrinsics.checkNotNullParameter((Object)settingsRepository, (String)"settingsRepository");
        Intrinsics.checkNotNullParameter((Object)transactionRepository, (String)"transactionRepository");
        this.posInfoFactory = posInfoFactory;
        this.locationHandler = locationHandler;
        this.statusManager = statusManager;
        this.settingsRepository = settingsRepository;
        this.transactionRepository = transactionRepository;
    }

    @NotNull
    public final ActivateConnectionTokenRequest activateReader(@NotNull Reader reader, @NotNull ConnectionConfiguration connectionConfig) throws TerminalException {
        ReportedReaderConfig reportedReaderConfig;
        String string;
        ConnectionType connectionType;
        Object object;
        PosInfo posInfo;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)connectionConfig, (String)"connectionConfig");
        PosInfo posInfo2 = posInfo = connectionConfig instanceof ConnectionConfiguration.EmbeddedConnectionConfiguration ? this.posInfoFactory.createForRemotePos(this.transactionRepository.getRemotePosSdkVersionInfo(), this.transactionRepository.getRemotePosSecondarySdkVersionInfo(), this.transactionRepository.getRemotePosDeviceInfo()) : this.posInfoFactory.createForLocalPos();
        if ((connectionConfig instanceof ConnectionConfiguration.EmbeddedConnectionConfiguration ? (Intrinsics.areEqual((Object)(object = ((ConnectionConfiguration.EmbeddedConnectionConfiguration)connectionConfig).getPosConnectionType()), (Object)PosConnectionType.Handoff.INSTANCE) ? ConnectionType.handoff : (Intrinsics.areEqual((Object)object, (Object)PosConnectionType.Countertop.INSTANCE) ? ConnectionType.countertop : null)) : (connectionType = null)) == null) {
            connectionType = ReaderExtensionsKt.getConnectionType(reader);
        }
        ConnectionType connectionType2 = connectionType;
        String string2 = posInfo.getDeviceUuid();
        DeviceInfo deviceInfo = posInfo.getDeviceInfo();
        object = posInfo.getSecondaryVersionInfo();
        VersionInfoPb versionInfoPb = posInfo.getVersionInfo();
        DeviceInfo deviceInfo2 = reader.toDeviceInfo();
        String string3 = reader.getSerialNumber();
        String it = string = reader.getDeviceType().getDeviceName();
        boolean bl = false;
        String string4 = !reader.isSimulated() ? string : null;
        if (string4 == null) {
            string4 = "simulator";
        }
        String string5 = string4;
        String string6 = reader.getPinKeysetId();
        if (string6 != null) {
            String it2 = string6;
            boolean bl2 = false;
            reportedReaderConfig = new ReportedReaderConfig(it2, null, 2, null);
        } else {
            reportedReaderConfig = null;
        }
        ReportedReaderConfig reportedReaderConfig2 = reportedReaderConfig;
        string = connectionConfig.getLocationId();
        return new ActivateConnectionTokenRequest(string2, string5, string3, deviceInfo2, null, deviceInfo, versionInfoPb, reportedReaderConfig2, string, connectionType2, (VersionInfoPb)((Object)object), null, 2064, null);
    }

    @NotNull
    public final ConfirmSetupIntentRequest confirmManualEntrySetupIntent(@NotNull SetupIntent setupIntent, @NotNull ManualEntryPayment manualEntryPayment) throws TerminalException {
        Intrinsics.checkNotNullParameter((Object)setupIntent, (String)"setupIntent");
        Intrinsics.checkNotNullParameter((Object)manualEntryPayment, (String)"manualEntryPayment");
        return new ConfirmSetupIntentRequest(CollectionsKt.listOf((Object)"latest_attempt"), this.manualEntryRequestedPaymentMethod(manualEntryPayment), null, null, null, setupIntent.getId(), null, 92, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public final ConfirmSetupIntentRequest confirmSetupIntent(@NotNull SetupIntent setupIntent) throws TerminalException {
        Intrinsics.checkNotNullParameter((Object)setupIntent, (String)"setupIntent");
        location = this.locationHandler.getLocation();
        v0 = setupIntent.getPaymentMethodData();
        Intrinsics.checkNotNull((Object)v0);
        data = v0;
        v1 = location;
        var5_4 = v1 != null ? Double.valueOf(v1.getLongitude()).toString() : null;
        v2 = location;
        var6_5 = v2 != null ? Double.valueOf(v2.getLatitude()).toString() : null;
        var7_6 /* !! */  = data.getReadMethod().getMethod();
        cardPresent = new RequestedPaymentMethod.RequestedCardPresent(null, var7_6 /* !! */ , null, null, null, null, null, null, null, null, null, null, (String)var6_5, var5_4, null, 20477, null);
        switch (WhenMappings.$EnumSwitchMapping$0[data.getReadMethod().ordinal()]) {
            case 1: 
            case 2: {
                var7_6 /* !! */  = cardPresent;
                var9_8 /* !! */  = this.statusManager.getConnectedReader();
                if (var9_8 /* !! */  == null) ** GOTO lbl-1000
                it = var11_9 = var9_8 /* !! */ ;
                $i$a$-takeIf-ApiRequestFactory$confirmSetupIntent$1 = false;
                v3 /* !! */  = var10_13 = it.isSimulated() != false ? var11_9 : null;
                if (var10_13 != null) {
                    it = var10_13;
                    $i$a$-let-ApiRequestFactory$confirmSetupIntent$2 = false;
                    v4 = "emv";
                } else lbl-1000:
                // 2 sources

                {
                    v4 = "encrypted_emv";
                }
                var8_16 = v4;
                var9_8 /* !! */  = data.getTlv();
                var10_13 = data.getEncryptedTrack2();
                v5 = data.getEncryptedTrack2();
                if (v5 != null) {
                    it = v5;
                    $i$a$-let-ApiRequestFactory$confirmSetupIntent$3 = false;
                    v6 = "rsa_aes";
                } else {
                    v6 = null;
                }
                var11_9 = v6;
                v7 = data.getEncryptedTrack2();
                if (v7 != null) {
                    it = v7;
                    $i$a$-let-ApiRequestFactory$confirmSetupIntent$4 = false;
                    v8 = data.getCryptogram();
                } else {
                    v8 = null;
                }
                var12_10 = v8;
                v9 = RequestedPaymentMethod.RequestedCardPresent.copy$default((RequestedPaymentMethod.RequestedCardPresent)var7_6 /* !! */ , var8_16, null, null, var10_13, null, (String)var9_8 /* !! */ , null, null, null, (String)var11_9, var12_10, null, null, null, null, 31190, null);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                v9 = RequestedPaymentMethod.RequestedCardPresent.copy$default(cardPresent, "encrypted_track_data", null, data.getSwipeReason().getReason(), data.getTrack2(), null, null, null, null, null, null, null, data.getKsn(), null, null, null, 30706, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        cardPresent = v9;
        var5_4 = setupIntent.getId();
        var6_5 = CollectionsKt.listOf((Object)"latest_attempt");
        var7_6 /* !! */  = new RequestedPaymentMethod("card_present", cardPresent, null, null, null, null, 60, null);
        return new ConfirmSetupIntentRequest((List)var6_5, (RequestedPaymentMethod)var7_6 /* !! */ , null, null, null, var5_4, null, 92, null);
    }

    @NotNull
    public final CreatePaymentIntentRequest createPaymentIntent(@NotNull PaymentIntentParameters params) throws TerminalException {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return CreatePaymentIntentRequestMaker.Companion.fromPaymentIntentParameters(params);
    }

    @NotNull
    public final RetrieveSetupIntentRequest retrieveSetupIntent(@NotNull String clientSecret) throws TerminalException {
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        String[] stringArray = new String[]{SECRET_DELIMITER};
        List components = StringsKt.split$default((CharSequence)clientSecret, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String string = (String)CollectionsKt.firstOrNull((List)components);
        if (string == null) {
            throw new TerminalException(TerminalException.TerminalErrorCode.INVALID_CLIENT_SECRET, INVALID_CLIENT_SECRET, null, null, 12, null);
        }
        String intentId = string;
        return new RetrieveSetupIntentRequest(null, intentId, clientSecret, null, 9, null);
    }

    @NotNull
    public final CreateSetupIntentRequest createSetupIntent(@NotNull SetupIntentParameters params) throws TerminalException {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return CreateSetupIntentRequestMaker.Companion.fromSetupIntentParameters(params);
    }

    @NotNull
    public final CancelSetupIntentRequest cancelSetupIntent(@NotNull SetupIntent intent, @NotNull SetupIntentCancellationParameters params) throws TerminalException {
        CancelSetupIntentRequest.Reason reason;
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        String string = intent.getId();
        SetupIntentCancellationReason setupIntentCancellationReason = params.getReason();
        switch (setupIntentCancellationReason == null ? -1 : WhenMappings.$EnumSwitchMapping$1[setupIntentCancellationReason.ordinal()]) {
            case 1: {
                reason = CancelSetupIntentRequest.Reason.duplicate;
                break;
            }
            case 2: {
                reason = CancelSetupIntentRequest.Reason.requested_by_customer;
                break;
            }
            case 3: {
                reason = CancelSetupIntentRequest.Reason.abandoned;
                break;
            }
            case -1: {
                reason = CancelSetupIntentRequest.Reason.duplicate;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return new CancelSetupIntentRequest(string, reason, null, 4, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public final ReadCardPaymentMethodRequest createPaymentMethod(@NotNull ReadReusableCardParameters params, @NotNull PaymentMethodData data, @Nullable String readerId) throws TerminalException {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        v0 = this.locationHandler.getLocation();
        var5_4 /* !! */  = v0 != null ? Double.valueOf(v0.getLongitude()).toString() : null;
        v1 = this.locationHandler.getLocation();
        var6_5 = v1 != null ? Double.valueOf(v1.getLatitude()).toString() : null;
        var7_6 = data.getReadMethod().getMethod();
        cardPresent = new RequestedPaymentMethod.RequestedCardPresent(null, var7_6, null, null, null, null, null, null, readerId, null, null, null, (String)var6_5, var5_4 /* !! */ , null, 20221, null);
        switch (WhenMappings.$EnumSwitchMapping$0[data.getReadMethod().ordinal()]) {
            case 1: 
            case 2: {
                v2 = cardPresent;
                var7_6 = this.statusManager.getConnectedReader();
                if (var7_6 == null) ** GOTO lbl-1000
                var10_9 = var9_8 = var7_6;
                var13_10 = v2;
                $i$a$-takeIf-ApiRequestFactory$createPaymentMethod$1 = false;
                var14_13 = it.isSimulated();
                v2 = var13_10;
                v3 = var8_14 = var14_13 != false ? var9_8 : null;
                if (var8_14 != null) {
                    $i$a$-takeIf-ApiRequestFactory$createPaymentMethod$1 = var8_14;
                    var13_10 = v2;
                    $i$a$-let-ApiRequestFactory$createPaymentMethod$2 = false;
                    v4 = "emv";
                    v2 = var13_10;
                } else lbl-1000:
                // 2 sources

                {
                    v4 = "encrypted_emv";
                }
                v5 = RequestedPaymentMethod.RequestedCardPresent.copy$default(v2, v4, null, null, null, null, data.getTlv(), null, null, null, null, null, null, null, null, null, 32734, null);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                v5 = RequestedPaymentMethod.RequestedCardPresent.copy$default(cardPresent, "encrypted_track_data", null, data.getSwipeReason().getReason(), data.getTrack2(), null, null, null, null, null, null, null, data.getKsn(), null, null, null, 30706, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        cardPresent = v5;
        var5_4 /* !! */  = new RequestedPaymentMethod("card_present", cardPresent, null, null, null, null, 60, null);
        v6 = params.getMetadata();
        if (v6 == null) {
            v6 = MapsKt.emptyMap();
        }
        var6_5 = v6;
        var7_6 = params.getCustomer();
        return new ReadCardPaymentMethodRequest(null, var7_6, (RequestedPaymentMethod)var5_4 /* !! */ , (Map)var6_5, null, 17, null);
    }

    @NotNull
    public final RestRequest<UpdatePaymentIntentRequest, UpdatePaymentIntentRequest.Builder> updatePaymentIntent(@NotNull PaymentIntent intent, @Nullable String readerId, @Nullable Amount amountTip) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        List list = CollectionsKt.listOf((Object)"payment_method.card_present");
        String string = intent.getId();
        PaymentMethodData paymentMethodData = intent.getPaymentMethodData();
        Intrinsics.checkNotNull((Object)paymentMethodData);
        Amount amount = amountTip;
        return new RestRequest(new UpdatePaymentIntentRequest(list, null, string, this.createPaymentMethodRequest(paymentMethodData, readerId), amount != null ? Long.valueOf(amount.getValue()) : null, null, 34, null), ApiRequestFactory.Companion.getHeaders(intent));
    }

    @NotNull
    public final RestRequest<ConfirmPaymentIntentRequest, ConfirmPaymentIntentRequest.Builder> confirmPaymentIntent(@NotNull PaymentIntent intent, @Nullable String readerId, @Nullable Amount amountTip) throws TerminalException {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        PaymentMethodData paymentMethodData = intent.getPaymentMethodData();
        Intrinsics.checkNotNull((Object)paymentMethodData);
        PaymentMethodData data = paymentMethodData;
        return this.confirmPaymentIntentRequest(intent, this.createPaymentMethodRequest(data, readerId), null, amountTip);
    }

    public static /* synthetic */ RestRequest confirmPaymentIntent$default(ApiRequestFactory apiRequestFactory, PaymentIntent paymentIntent2, String string, Amount amount, int n2, Object object) throws TerminalException {
        if ((n2 & 4) != 0) {
            amount = null;
        }
        return apiRequestFactory.confirmPaymentIntent(paymentIntent2, string, amount);
    }

    @NotNull
    public final RestRequest<AddEmvSecondGenerationDataRequest, AddEmvSecondGenerationDataRequest.Builder> addEmvSecondGenerationData(@NotNull PaymentIntent paymentIntent2, @NotNull TransactionResult transactionResult2) throws TerminalException {
        String string;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)paymentIntent2, (String)"paymentIntent");
        Intrinsics.checkNotNullParameter((Object)transactionResult2, (String)"transactionResult");
        String string2 = paymentIntent2.getId();
        switch (WhenMappings.$EnumSwitchMapping$2[transactionResult2.getResult().ordinal()]) {
            case 1: {
                bl = true;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        boolean bl2 = bl;
        switch (WhenMappings.$EnumSwitchMapping$2[transactionResult2.getResult().ordinal()]) {
            case 1: {
                string = null;
                break;
            }
            case 2: {
                string = "card_absent";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "card_rejected";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String string3 = string;
        String string4 = transactionResult2.getTlvBlob();
        return new RestRequest(new AddEmvSecondGenerationDataRequest(null, bl2, string4, string3, string2, null, 33, null), ApiRequestFactory.Companion.getHeaders(paymentIntent2));
    }

    private final RequestedPaymentMethod manualEntryRequestedPaymentMethod(ManualEntryPayment manualEntryPayment) {
        RequestedPaymentMethod.BillingDetails billingDetails = new RequestedPaymentMethod.BillingDetails(new RequestedPaymentMethod.BillingDetails.Address(manualEntryPayment.getZipCode(), null, 2, null), null, 2, null);
        String string = manualEntryPayment.getEncPAN();
        String string2 = manualEntryPayment.getKsn();
        String string3 = StringsKt.takeLast((String)manualEntryPayment.getExpiryDate(), (int)2);
        String string4 = StringsKt.take((String)manualEntryPayment.getExpiryDate(), (int)2);
        String string5 = manualEntryPayment.getEncCVV();
        String string6 = manualEntryPayment.getKsn();
        RequestedPaymentMethod.RequestedCard requestedCardNotPresent = new RequestedPaymentMethod.RequestedCard(string, string6, string3, string4, string5, string2, null, 64, null);
        return new RequestedPaymentMethod(CARD_TYPE, null, null, requestedCardNotPresent, billingDetails, null, 38, null);
    }

    @NotNull
    public final RestRequest<ConfirmPaymentIntentRequest, ConfirmPaymentIntentRequest.Builder> confirmManualEntryPaymentIntent(@NotNull PaymentIntent intent, @NotNull ManualEntryPayment manualEntryPayment) throws TerminalException {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)manualEntryPayment, (String)"manualEntryPayment");
        return this.confirmPaymentIntentRequest(intent, this.manualEntryRequestedPaymentMethod(manualEntryPayment), new PaymentMethodOptions(null, new PaymentMethodOptions.Card(true, null, 2, null), null, 5, null), null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RestRequest<ConfirmPaymentIntentRequest, ConfirmPaymentIntentRequest.Builder> confirmCollectiblePayment(@NotNull PaymentIntent intent, @Nullable RequestedPaymentMethod paymentMethodData, @Nullable Amount amountTip) throws TerminalException {
        RequestedPaymentMethod requestedPaymentMethod;
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Location location = this.locationHandler.getLocation();
        ApiRequestFactory apiRequestFactory = this;
        PaymentIntent paymentIntent2 = intent;
        RequestedPaymentMethod requestedPaymentMethod2 = paymentMethodData;
        if (requestedPaymentMethod2 != null) {
            RequestedPaymentMethod.RequestedCardPresent requestedCardPresent;
            void $this$confirmCollectiblePayment_u24lambda_u248;
            RequestedPaymentMethod requestedPaymentMethod3 = requestedPaymentMethod2;
            PaymentIntent paymentIntent3 = paymentIntent2;
            ApiRequestFactory apiRequestFactory2 = apiRequestFactory;
            boolean bl = false;
            RequestedPaymentMethod.RequestedCardPresent requestedCardPresent2 = $this$confirmCollectiblePayment_u24lambda_u248.card_present;
            if (requestedCardPresent2 != null) {
                Location location2 = location;
                String string = location2 != null ? Double.valueOf(location2.getLongitude()).toString() : null;
                Location location3 = location;
                String string2 = location3 != null ? Double.valueOf(location3.getLatitude()).toString() : null;
                requestedCardPresent = RequestedPaymentMethod.RequestedCardPresent.copy$default(requestedCardPresent2, null, null, null, null, null, null, null, null, null, null, null, null, string2, string, null, 20479, null);
            } else {
                requestedCardPresent = null;
            }
            RequestedPaymentMethod requestedPaymentMethod4 = RequestedPaymentMethod.copy$default((RequestedPaymentMethod)$this$confirmCollectiblePayment_u24lambda_u248, null, requestedCardPresent, null, null, null, null, 61, null);
            apiRequestFactory = apiRequestFactory2;
            paymentIntent2 = paymentIntent3;
            requestedPaymentMethod = requestedPaymentMethod4;
        } else {
            requestedPaymentMethod = null;
        }
        return apiRequestFactory.confirmPaymentIntentRequest(paymentIntent2, requestedPaymentMethod, null, amountTip);
    }

    @NotNull
    public final CancelPaymentIntentRequest cancelPaymentIntent(@NotNull PaymentIntent intent) throws TerminalException {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        return new CancelPaymentIntentRequest(null, intent.getId(), null, null, 13, null);
    }

    @NotNull
    public final DetachPaymentMethodRequest detachPaymentMethod(@NotNull PaymentMethod method) throws TerminalException {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return new DetachPaymentMethodRequest(method.getId(), null, 2, null);
    }

    @NotNull
    public final DiscoverLocationsRequest discoverLocations(@NotNull List<String> serialNumbers) throws TerminalException {
        Intrinsics.checkNotNullParameter(serialNumbers, (String)"serialNumbers");
        return new DiscoverLocationsRequest(serialNumbers, null, 2, null);
    }

    @NotNull
    public final ListAllReadersRequest listAllReaders(@Nullable DeviceType deviceType, @Nullable String location) throws TerminalException {
        DeviceType deviceType2 = deviceType;
        return new ListAllReadersRequest(deviceType2 != null ? deviceType2.getDeviceName() : null, location, CollectionsKt.listOf((Object)"data.location"), null, null, "android", "2.23.3", 100, null, 280, null);
    }

    public static /* synthetic */ ListAllReadersRequest listAllReaders$default(ApiRequestFactory apiRequestFactory, DeviceType deviceType, String string, int n2, Object object) throws TerminalException {
        if ((n2 & 1) != 0) {
            deviceType = null;
        }
        if ((n2 & 2) != 0) {
            string = null;
        }
        return apiRequestFactory.listAllReaders(deviceType, string);
    }

    @NotNull
    public final RetrievePaymentIntentRequest retrievePaymentIntent(@NotNull String clientSecret) throws TerminalException {
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        String[] stringArray = new String[]{SECRET_DELIMITER};
        List components = StringsKt.split$default((CharSequence)clientSecret, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String string = (String)CollectionsKt.firstOrNull((List)components);
        if (string == null) {
            throw new TerminalException(TerminalException.TerminalErrorCode.INVALID_CLIENT_SECRET, INVALID_CLIENT_SECRET, null, null, 12, null);
        }
        String intentId = string;
        return new RetrievePaymentIntentRequest(null, intentId, clientSecret, null, 9, null);
    }

    @NotNull
    public final ListLocationsRequest listLocations(@NotNull ListLocationsParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string = parameters.getEndingBefore();
        String string2 = parameters.getStartingAfter();
        Integer n2 = parameters.getLimit();
        return new ListLocationsRequest(string, n2, string2, null, 8, null);
    }

    @NotNull
    public final RetrieveLocationRequest retrieveLocation(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return new RetrieveLocationRequest(id, null, 2, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final RequestedPaymentMethod createPaymentMethodRequest(PaymentMethodData data, String readerId) {
        location = this.locationHandler.getLocation();
        readMethod = data.getReadMethod();
        processingMethod = EmvPaymentKt.toEmvProcessingMethod(this.settingsRepository.getSettings().getEmvTransactionType());
        v0 = location;
        var7_6 /* !! */  = v0 != null ? Double.valueOf(v0.getLongitude()).toString() : null;
        v1 = location;
        var8_7 = v1 != null ? Double.valueOf(v1.getLatitude()).toString() : null;
        var9_8 = readMethod.getMethod();
        it = var11_10 = processingMethod;
        $i$a$-takeIf-ApiRequestFactory$createPaymentMethodRequest$cardPresent$1 = false;
        var10_14 = readMethod == ReadMethod.CONTACT_EMV != false ? var11_10 : null;
        it /* !! */  = new RequestedPaymentMethod.RequestedCardPresent(null, var9_8, null, null, var10_14, null, null, null, readerId, null, null, null, var8_7, var7_6 /* !! */ , null, 20205, null);
        $i$a$-let-ApiRequestFactory$createPaymentMethodRequest$cardPresent$2 = false;
        switch (WhenMappings.$EnumSwitchMapping$0[readMethod.ordinal()]) {
            case 1: 
            case 2: {
                var10_14 = this.statusManager.getConnectedReader();
                if (var10_14 == null) ** GOTO lbl-1000
                connectedReader = var11_10 = var10_14;
                $i$a$-takeIf-ApiRequestFactory$createPaymentMethodRequest$cardPresent$2$1 = false;
                v2 = var14_15 = connectedReader.isSimulated() != false ? var11_10 : null;
                if (var14_15 != null) {
                    it = var14_15;
                    $i$a$-let-ApiRequestFactory$createPaymentMethodRequest$cardPresent$2$2 = false;
                    v3 = "emv";
                } else lbl-1000:
                // 2 sources

                {
                    v3 = "encrypted_emv";
                }
                var16_18 = v3;
                var10_14 = data.getTlv();
                var14_15 = data.getEncryptedTrack2();
                v4 = data.getEncryptedTrack2();
                if (v4 != null) {
                    it = v4;
                    $i$a$-let-ApiRequestFactory$createPaymentMethodRequest$cardPresent$2$3 = false;
                    v5 = "rsa_aes";
                } else {
                    v5 = null;
                }
                var11_10 = v5;
                v6 = data.getEncryptedTrack2();
                if (v6 != null) {
                    it = v6;
                    $i$a$-let-ApiRequestFactory$createPaymentMethodRequest$cardPresent$2$4 = false;
                    v7 = data.getCryptogram();
                } else {
                    v7 = null;
                }
                var12_11 = v7;
                v8 = RequestedPaymentMethod.RequestedCardPresent.copy$default(it /* !! */ , var16_18, null, null, var14_15, null, var10_14, null, null, null, var11_10, var12_11, null, null, null, null, 31190, null);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                v8 = RequestedPaymentMethod.RequestedCardPresent.copy$default(it /* !! */ , "encrypted_track_data", null, data.getSwipeReason().getReason(), data.getTrack2(), null, null, null, null, null, null, null, data.getKsn(), null, null, null, 30706, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        cardPresent = v8;
        var7_6 /* !! */  = cardPresent;
        it /* !! */  = var7_6 /* !! */ ;
        var19_23 = data.isInterac() != false ? "interac_present" : "card_present";
        $i$a$-takeUnless-ApiRequestFactory$createPaymentMethodRequest$1 = false;
        var20_24 = data.isInterac();
        v9 /* !! */  = var20_24 == false ? var7_6 /* !! */  : null;
        var7_6 /* !! */  = cardPresent;
        it /* !! */  = var7_6 /* !! */ ;
        var20_25 /* !! */  = v9 /* !! */ ;
        $i$a$-takeIf-ApiRequestFactory$createPaymentMethodRequest$2 = false;
        var21_26 = data.isInterac();
        var22_27 = null;
        var23_28 = 56;
        var24_29 = null;
        var25_30 = null;
        var26_31 = null;
        var27_32 /* !! */  = var21_26 != false ? var7_6 /* !! */  : null;
        var28_33 /* !! */  = var20_25 /* !! */ ;
        var29_34 = var19_23;
        return new RequestedPaymentMethod(var29_34, (RequestedPaymentMethod.RequestedCardPresent)var28_33 /* !! */ , (RequestedPaymentMethod.RequestedCardPresent)var27_32 /* !! */ , var26_31, var25_30, var24_29, var23_28, var22_27);
    }

    private final RestRequest<ConfirmPaymentIntentRequest, ConfirmPaymentIntentRequest.Builder> confirmPaymentIntentRequest(PaymentIntent intent, RequestedPaymentMethod paymentMethodData, PaymentMethodOptions paymentMethodOptions, Amount amountTip) {
        Object object;
        String string = intent.getId();
        RequestedPaymentMethod it = object = paymentMethodData;
        boolean bl = false;
        PaymentMethod paymentMethod = intent.getPaymentMethod();
        RequestedPaymentMethod requestedPaymentMethod = (paymentMethod != null ? paymentMethod.getId() : null) == null ? object : null;
        Amount amount = amountTip;
        object = amount != null ? Long.valueOf(amount.getValue()) : null;
        Map map2 = ApiRequestFactory.Companion.getHeaders(intent);
        Message message = new ConfirmPaymentIntentRequest(null, null, requestedPaymentMethod, null, string, (Long)object, paymentMethodOptions, null, 139, null);
        return new RestRequest(message, map2);
    }

    @NotNull
    public final RestRequest<RefundChargeRequest, RefundChargeRequest.Builder> refundChargeRequest(@NotNull String charge, long amount, @NotNull RequestedPaymentMethod paymentMethodData, boolean reverseTransfer, boolean refundApplicationFee, @NotNull String reason, @NotNull Map<String, String> metadata, @Nullable String stripeAccountId) {
        Intrinsics.checkNotNullParameter((Object)charge, (String)"charge");
        Intrinsics.checkNotNullParameter((Object)((Object)paymentMethodData), (String)"paymentMethodData");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Intrinsics.checkNotNullParameter(metadata, (String)"metadata");
        return new RestRequest(new RefundChargeRequest(charge, reason, refundApplicationFee, reverseTransfer, paymentMethodData, amount, metadata, null, 128, null), ApiRequestFactory.Companion.withStripeAccountId(new LinkedHashMap(), stripeAccountId));
    }

    @NotNull
    public final RestRequest<AddEmvSecondGenerationDataRefundRequest, AddEmvSecondGenerationDataRefundRequest.Builder> emvSecondGenerationDataRefundRequest(@Nullable String refundId, @NotNull TransactionResult result2, boolean refundApplicationFee, boolean reverseTransfer, @Nullable String stripeAccountId) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        boolean bl = result2.getResult() == TransactionResult.Result.APPROVED;
        String string = result2.getTlvBlob();
        String string2 = result2.getResult() != TransactionResult.Result.APPROVED ? (result2.getResult() == TransactionResult.Result.ICC_CARD_REMOVED ? "card_absent" : "card_rejected") : null;
        return new RestRequest(new AddEmvSecondGenerationDataRefundRequest(null, bl, string, string2, refundId, refundApplicationFee, reverseTransfer, null, 129, null), ApiRequestFactory.Companion.withStripeAccountId(new LinkedHashMap(), stripeAccountId));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0015*\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000e*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lcom/stripe/stripeterminal/internal/common/api/ApiRequestFactory$Companion;", "", "()V", "CARD_PRESENT_TYPE", "", "CARD_TYPE", "EMV_TYPE", "ENCRYPTED_EMV_TYPE", "ENCRYPTED_TRACK_DATA_TYPE", "INTERAC_PRESENT_TYPE", "INVALID_CLIENT_SECRET", "SECRET_DELIMITER", "STRIPE_ACCOUNT_HEADER", "headers", "", "Lcom/stripe/stripeterminal/external/models/PaymentIntent;", "getHeaders$annotations", "(Lcom/stripe/stripeterminal/external/models/PaymentIntent;)V", "getHeaders", "(Lcom/stripe/stripeterminal/external/models/PaymentIntent;)Ljava/util/Map;", "withStripeAccountId", "", "stripeAccountId", "common_publish"})
    @SourceDebugExtension(value={"SMAP\nApiRequestFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiRequestFactory.kt\ncom/stripe/stripeterminal/internal/common/api/ApiRequestFactory$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,618:1\n1#2:619\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Map<String, String> withStripeAccountId(Map<String, String> $this$withStripeAccountId, String stripeAccountId) {
            Map<String, String> map2;
            block0: {
                Map<String, String> $this$withStripeAccountId_u24lambda_u241 = map2 = $this$withStripeAccountId;
                boolean bl = false;
                String string = stripeAccountId;
                if (string == null) break block0;
                String it = string;
                boolean bl2 = false;
                $this$withStripeAccountId_u24lambda_u241.put(ApiRequestFactory.STRIPE_ACCOUNT_HEADER, it);
            }
            return map2;
        }

        private final Map<String, String> getHeaders(PaymentIntent $this$headers) {
            return this.withStripeAccountId(new LinkedHashMap(), $this$headers.getStripeAccountId());
        }

        private static /* synthetic */ void getHeaders$annotations(PaymentIntent paymentIntent2) {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[ReadMethod.values().length];
            try {
                nArray[ReadMethod.CONTACT_EMV.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadMethod.CONTACTLESS_EMV.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadMethod.MAGNETIC_STRIPE_FALLBACK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadMethod.MAGNETIC_STRIPE_TRACK_2.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadMethod.CONTACTLESS_MAGSTRIPE_MODE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SetupIntentCancellationReason.values().length];
            try {
                nArray[SetupIntentCancellationReason.DUPLICATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SetupIntentCancellationReason.REQUESTED_BY_CUSTOMER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SetupIntentCancellationReason.ABANDONED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[TransactionResult.Result.values().length];
            try {
                nArray[TransactionResult.Result.APPROVED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionResult.Result.ICC_CARD_REMOVED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionResult.Result.CONTACTLESS_LIMIT_EXCEEDED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionResult.Result.DECLINED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionResult.Result.TERMINATED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionResult.Result.CANCELED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionResult.Result.EMPTY_CANDIDATE_LIST.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionResult.Result.CARD_BLOCKED.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionResult.Result.DEVICE_FAILURE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionResult.Result.CHECK_MOBILE_DEVICE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionResult.Result.INSERT_OR_SWIPE_REQUIRED.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionResult.Result.MULTIPLE_CARDS_DETECTED.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionResult.Result.MOBILE_WALLET_TOO_MANY_TAPS.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionResult.Result.CARD_STILL_INSERTED.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

