/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import androidx.core.content.IntentCompat;
import com.stripe.jvmcore.dagger.ForApplication;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.stripeterminal.internal.common.bluetooth.BluetoothBondStateReceiverManager;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0002\u000f\u0010B\u0011\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\fJ\u0006\u0010\u000e\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/stripe/stripeterminal/internal/common/bluetooth/BluetoothBondStateReceiverManager;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "receiver", "Lcom/stripe/stripeterminal/internal/common/bluetooth/BluetoothBondStateReceiverManager$BluetoothBondStateReceiver;", "startListening", "", "bluetoothDevice", "Landroid/bluetooth/BluetoothDevice;", "onBonded", "Lkotlin/Function0;", "onError", "stopListening", "BluetoothBondStateReceiver", "Companion", "common_publish"})
public final class BluetoothBondStateReceiverManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @Nullable
    private BluetoothBondStateReceiver receiver;
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(BluetoothBondStateReceiver.class);

    @Inject
    public BluetoothBondStateReceiverManager(@ForApplication @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    public final void startListening(@NotNull BluetoothDevice bluetoothDevice, @NotNull Function0<Unit> onBonded, @NotNull Function0<Unit> onError2) {
        Intrinsics.checkNotNullParameter((Object)bluetoothDevice, (String)"bluetoothDevice");
        Intrinsics.checkNotNullParameter(onBonded, (String)"onBonded");
        Intrinsics.checkNotNullParameter(onError2, (String)"onError");
        LOGGER.d("startListening", new Pair[0]);
        if (this.receiver == null) {
            Function0 delayedOnBonded2 = (Function0)new Function0<Unit>(this, onBonded){
                final /* synthetic */ BluetoothBondStateReceiverManager this$0;
                final /* synthetic */ Function0<Unit> $onBonded;
                {
                    this.this$0 = $receiver;
                    this.$onBonded = $onBonded;
                    super(0);
                }

                public final void invoke() {
                    new Handler(BluetoothBondStateReceiverManager.access$getContext$p(this.this$0).getMainLooper()).postDelayed(() -> startListening.delayedOnBonded.1.invoke$lambda$0(this.$onBonded), 1000L);
                }

                private static final void invoke$lambda$0(Function0 $tmp0) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    $tmp0.invoke();
                }
            };
            IntentFilter bondFilter = new IntentFilter("android.bluetooth.device.action.BOND_STATE_CHANGED");
            this.receiver = new BluetoothBondStateReceiver(bluetoothDevice, (Function0<Unit>)delayedOnBonded2, onError2);
            this.context.registerReceiver((BroadcastReceiver)this.receiver, bondFilter);
        }
    }

    public final void stopListening() {
        block0: {
            LOGGER.d("stopListening", new Pair[0]);
            BluetoothBondStateReceiver bluetoothBondStateReceiver = this.receiver;
            if (bluetoothBondStateReceiver == null) break block0;
            BluetoothBondStateReceiver it = bluetoothBondStateReceiver;
            boolean bl = false;
            this.context.unregisterReceiver((BroadcastReceiver)it);
            this.receiver = null;
        }
    }

    public static final /* synthetic */ Context access$getContext$p(BluetoothBondStateReceiverManager $this) {
        return $this.context;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/stripeterminal/internal/common/bluetooth/BluetoothBondStateReceiverManager$BluetoothBondStateReceiver;", "Landroid/content/BroadcastReceiver;", "bluetoothDevice", "Landroid/bluetooth/BluetoothDevice;", "onBonded", "Lkotlin/Function0;", "", "onError", "(Landroid/bluetooth/BluetoothDevice;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "onReceive", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "common_publish"})
    public static final class BluetoothBondStateReceiver
    extends BroadcastReceiver {
        @NotNull
        private final BluetoothDevice bluetoothDevice;
        @NotNull
        private final Function0<Unit> onBonded;
        @NotNull
        private final Function0<Unit> onError;

        public BluetoothBondStateReceiver(@NotNull BluetoothDevice bluetoothDevice, @NotNull Function0<Unit> onBonded, @NotNull Function0<Unit> onError2) {
            Intrinsics.checkNotNullParameter((Object)bluetoothDevice, (String)"bluetoothDevice");
            Intrinsics.checkNotNullParameter(onBonded, (String)"onBonded");
            Intrinsics.checkNotNullParameter(onError2, (String)"onError");
            this.bluetoothDevice = bluetoothDevice;
            this.onBonded = onBonded;
            this.onError = onError2;
        }

        public void onReceive(@Nullable Context context, @NotNull Intent intent) {
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            LOGGER.d("onReceive", new Pair[0]);
            BluetoothDevice bondStateChangedDevice = (BluetoothDevice)IntentCompat.getParcelableExtra((Intent)intent, (String)"android.bluetooth.device.extra.DEVICE", BluetoothDevice.class);
            BluetoothDevice bluetoothDevice = bondStateChangedDevice;
            if (!Intrinsics.areEqual((Object)this.bluetoothDevice.getAddress(), (Object)(bluetoothDevice != null ? bluetoothDevice.getAddress() : null))) {
                return;
            }
            int bondState = intent.getIntExtra("android.bluetooth.device.extra.BOND_STATE", -1);
            int previousBondState = intent.getIntExtra("android.bluetooth.device.extra.PREVIOUS_BOND_STATE", -1);
            if (bondState != 11) {
                if (bondState == 12) {
                    this.onBonded.invoke();
                } else if (bondState == 10 && previousBondState == 11) {
                    this.onError.invoke();
                }
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/stripeterminal/internal/common/bluetooth/BluetoothBondStateReceiverManager$Companion;", "", "()V", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "common_publish"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

