/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.callable;

import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.stripeterminal.external.callable.BluetoothReaderListener;
import com.stripe.stripeterminal.external.callable.Cancelable;
import com.stripe.stripeterminal.external.callable.HandoffReaderListener;
import com.stripe.stripeterminal.external.callable.UsbReaderListener;
import com.stripe.stripeterminal.external.models.BatteryStatus;
import com.stripe.stripeterminal.external.models.ConnectionConfiguration;
import com.stripe.stripeterminal.external.models.ReaderBatteryInfo;
import com.stripe.stripeterminal.external.models.ReaderDisplayMessage;
import com.stripe.stripeterminal.external.models.ReaderEvent;
import com.stripe.stripeterminal.external.models.ReaderInputOptions;
import com.stripe.stripeterminal.external.models.ReaderSoftwareUpdate;
import com.stripe.stripeterminal.external.models.TerminalException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B)\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0013\u001a\u00020\nJ\u0010\u0010\u0014\u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\"J\u0018\u0010#\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010$\u001a\u0004\u0018\u00010%R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/stripe/stripeterminal/internal/common/callable/ProxyReaderListener;", "", "bluetoothReaderListener", "Lcom/stripe/stripeterminal/external/callable/BluetoothReaderListener;", "handoffReaderListener", "Lcom/stripe/stripeterminal/external/callable/HandoffReaderListener;", "usbReaderListener", "Lcom/stripe/stripeterminal/external/callable/UsbReaderListener;", "(Lcom/stripe/stripeterminal/external/callable/BluetoothReaderListener;Lcom/stripe/stripeterminal/external/callable/HandoffReaderListener;Lcom/stripe/stripeterminal/external/callable/UsbReaderListener;)V", "assertRequiredListener", "", "config", "Lcom/stripe/stripeterminal/external/models/ConnectionConfiguration;", "onFinishInstallingUpdate", "update", "Lcom/stripe/stripeterminal/external/models/ReaderSoftwareUpdate;", "e", "Lcom/stripe/stripeterminal/external/models/TerminalException;", "onReportAvailableUpdate", "onReportLowBatteryWarning", "onReportReaderBatteryInfo", "readerBatteryInfo", "Lcom/stripe/stripeterminal/external/models/ReaderBatteryInfo;", "onReportReaderEvent", "event", "Lcom/stripe/stripeterminal/external/models/ReaderEvent;", "onReportReaderSoftwareUpdateProgress", "progress", "", "onRequestReaderDisplayMessage", "message", "Lcom/stripe/stripeterminal/external/models/ReaderDisplayMessage;", "onRequestReaderInput", "options", "Lcom/stripe/stripeterminal/external/models/ReaderInputOptions;", "onStartInstallingUpdate", "cancelable", "Lcom/stripe/stripeterminal/external/callable/Cancelable;", "Companion", "common_publish"})
public final class ProxyReaderListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final BluetoothReaderListener bluetoothReaderListener;
    @Nullable
    private final HandoffReaderListener handoffReaderListener;
    @Nullable
    private final UsbReaderListener usbReaderListener;
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(ProxyReaderListener.class);

    public ProxyReaderListener(@Nullable BluetoothReaderListener bluetoothReaderListener, @Nullable HandoffReaderListener handoffReaderListener, @Nullable UsbReaderListener usbReaderListener) {
        this.bluetoothReaderListener = bluetoothReaderListener;
        this.handoffReaderListener = handoffReaderListener;
        this.usbReaderListener = usbReaderListener;
    }

    public /* synthetic */ ProxyReaderListener(BluetoothReaderListener bluetoothReaderListener, HandoffReaderListener handoffReaderListener, UsbReaderListener usbReaderListener, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            bluetoothReaderListener = null;
        }
        if ((n2 & 2) != 0) {
            handoffReaderListener = null;
        }
        if ((n2 & 4) != 0) {
            usbReaderListener = null;
        }
        this(bluetoothReaderListener, handoffReaderListener, usbReaderListener);
    }

    public final void assertRequiredListener(@NotNull ConnectionConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        ConnectionConfiguration connectionConfiguration = config;
        if (connectionConfiguration instanceof ConnectionConfiguration.BluetoothConnectionConfiguration) {
            if (this.bluetoothReaderListener == null) {
                throw new TerminalException(TerminalException.TerminalErrorCode.MISSING_REQUIRED_PARAMETER, "A BluetoothReaderListener is required when using BluetoothConnectionConfiguration.", null, null, 12, null);
            }
            if (((ConnectionConfiguration.BluetoothConnectionConfiguration)config).getAutoReconnectOnUnexpectedDisconnect() && ((ConnectionConfiguration.BluetoothConnectionConfiguration)config).getBluetoothReaderReconnectionListener() == null) {
                throw new TerminalException(TerminalException.TerminalErrorCode.MISSING_REQUIRED_PARAMETER, "A ReaderReconnectionListener is required when auto reconnection is turned on", null, null, 12, null);
            }
        } else if (connectionConfiguration instanceof ConnectionConfiguration.UsbConnectionConfiguration) {
            if (this.usbReaderListener == null) {
                throw new TerminalException(TerminalException.TerminalErrorCode.MISSING_REQUIRED_PARAMETER, "A UsbReaderListener is required when using UsbConnectionConfiguration.", null, null, 12, null);
            }
            if (((ConnectionConfiguration.UsbConnectionConfiguration)config).getAutoReconnectOnUnexpectedDisconnect() && ((ConnectionConfiguration.UsbConnectionConfiguration)config).getUsbReaderReconnectionListener() == null) {
                throw new TerminalException(TerminalException.TerminalErrorCode.MISSING_REQUIRED_PARAMETER, "A ReaderReconnectionListener is required when auto reconnection is turned on", null, null, 12, null);
            }
        } else if (((connectionConfiguration instanceof ConnectionConfiguration.EmbeddedConnectionConfiguration ? true : connectionConfiguration instanceof ConnectionConfiguration.HandoffConnectionConfiguration) ? true : connectionConfiguration instanceof ConnectionConfiguration.InternetConnectionConfiguration) ? true : connectionConfiguration instanceof ConnectionConfiguration.LocalMobileConnectionConfiguration) {
            // empty if block
        }
    }

    public final void onStartInstallingUpdate(@NotNull ReaderSoftwareUpdate update2, @Nullable Cancelable cancelable) {
        Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"version", (Object)update2.getVersion()), TuplesKt.to((Object)"components", (Object)update2.getComponents().toString()), TuplesKt.to((Object)"cancelable?", (Object)String.valueOf(cancelable != null))};
        LOGGER.i("onStartInstallingUpdate", pairArray);
        try {
            BluetoothReaderListener bluetoothReaderListener = this.bluetoothReaderListener;
            if (bluetoothReaderListener != null) {
                bluetoothReaderListener.onStartInstallingUpdate(update2, cancelable);
            }
        }
        catch (Exception e2) {
            LOGGER.e("Unexpected failure in BluetoothReaderListener.onStartInstallingUpdate", e2, new Pair[0]);
        }
        try {
            UsbReaderListener usbReaderListener = this.usbReaderListener;
            if (usbReaderListener != null) {
                usbReaderListener.onStartInstallingUpdate(update2, cancelable);
            }
        }
        catch (Exception e3) {
            LOGGER.e("Unexpected failure in UsbReaderListener.onStartInstallingUpdate", e3, new Pair[0]);
        }
    }

    public final void onReportReaderSoftwareUpdateProgress(float progress) {
        LOGGER.i("onReportReaderSoftwareUpdateProgress(" + progress + ')', new Pair[0]);
        try {
            BluetoothReaderListener bluetoothReaderListener = this.bluetoothReaderListener;
            if (bluetoothReaderListener != null) {
                bluetoothReaderListener.onReportReaderSoftwareUpdateProgress(progress);
            }
        }
        catch (Exception e2) {
            LOGGER.e("Unexpected failure in BluetoothReaderListener.onReportReaderSoftwareUpdateProgress", e2, new Pair[0]);
        }
        try {
            UsbReaderListener usbReaderListener = this.usbReaderListener;
            if (usbReaderListener != null) {
                usbReaderListener.onReportReaderSoftwareUpdateProgress(progress);
            }
        }
        catch (Exception e3) {
            LOGGER.e("Unexpected failure in UsbReaderListener.onReportReaderSoftwareUpdateProgress", e3, new Pair[0]);
        }
    }

    public final void onFinishInstallingUpdate(@Nullable ReaderSoftwareUpdate update2, @Nullable TerminalException e2) {
        Pair[] pairArray = new Pair[2];
        ReaderSoftwareUpdate readerSoftwareUpdate = update2;
        pairArray[0] = TuplesKt.to((Object)"version", (Object)(readerSoftwareUpdate != null ? readerSoftwareUpdate.getVersion() : null));
        pairArray[1] = TuplesKt.to((Object)"exception?", (Object)String.valueOf(e2 != null));
        LOGGER.i("onFinishInstallingUpdate", pairArray);
        try {
            BluetoothReaderListener bluetoothReaderListener = this.bluetoothReaderListener;
            if (bluetoothReaderListener != null) {
                bluetoothReaderListener.onFinishInstallingUpdate(update2, e2);
            }
        }
        catch (Exception e3) {
            LOGGER.e("Unexpected failure in BluetoothReaderListener.onFinishInstallingUpdate", e3, new Pair[0]);
        }
        try {
            UsbReaderListener usbReaderListener = this.usbReaderListener;
            if (usbReaderListener != null) {
                usbReaderListener.onFinishInstallingUpdate(update2, e2);
            }
        }
        catch (Exception e4) {
            LOGGER.e("Unexpected failure in UsbReaderListener.onFinishInstallingUpdate", e4, new Pair[0]);
        }
    }

    public static /* synthetic */ void onFinishInstallingUpdate$default(ProxyReaderListener proxyReaderListener, ReaderSoftwareUpdate readerSoftwareUpdate, TerminalException terminalException, int n2, Object object) {
        if ((n2 & 2) != 0) {
            terminalException = null;
        }
        proxyReaderListener.onFinishInstallingUpdate(readerSoftwareUpdate, terminalException);
    }

    public final void onReportAvailableUpdate(@NotNull ReaderSoftwareUpdate update2) {
        Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
        LOGGER.i("onReportAvailableUpdate(" + update2.getVersion() + ')', new Pair[0]);
        try {
            BluetoothReaderListener bluetoothReaderListener = this.bluetoothReaderListener;
            if (bluetoothReaderListener != null) {
                bluetoothReaderListener.onReportAvailableUpdate(update2);
            }
        }
        catch (Exception e2) {
            LOGGER.e("Unexpected failure in BluetoothReaderListener.onReportAvailableUpdate", e2, new Pair[0]);
        }
        try {
            UsbReaderListener usbReaderListener = this.usbReaderListener;
            if (usbReaderListener != null) {
                usbReaderListener.onReportAvailableUpdate(update2);
            }
        }
        catch (Exception e3) {
            LOGGER.e("Unexpected failure in UsbReaderListener.onReportAvailableUpdate", e3, new Pair[0]);
        }
    }

    public final void onRequestReaderInput(@NotNull ReaderInputOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        LOGGER.i("onRequestReaderInput(" + options + ')', new Pair[0]);
        try {
            BluetoothReaderListener bluetoothReaderListener = this.bluetoothReaderListener;
            if (bluetoothReaderListener != null) {
                bluetoothReaderListener.onRequestReaderInput(options);
            }
        }
        catch (Exception e2) {
            LOGGER.e("Unexpected failure in BluetoothReaderListener.onRequestReaderInput", e2, new Pair[0]);
        }
        try {
            UsbReaderListener usbReaderListener = this.usbReaderListener;
            if (usbReaderListener != null) {
                usbReaderListener.onRequestReaderInput(options);
            }
        }
        catch (Exception e3) {
            LOGGER.e("Unexpected failure in UsbReaderListener.onRequestReaderInput", e3, new Pair[0]);
        }
    }

    public final void onRequestReaderDisplayMessage(@NotNull ReaderDisplayMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        LOGGER.i("onRequestReaderDisplayMessage(" + message + ')', new Pair[0]);
        try {
            BluetoothReaderListener bluetoothReaderListener = this.bluetoothReaderListener;
            if (bluetoothReaderListener != null) {
                bluetoothReaderListener.onRequestReaderDisplayMessage(message);
            }
        }
        catch (Exception e2) {
            LOGGER.e("Unexpected failure in BluetoothReaderListener.onRequestReaderDisplayMessage", e2, new Pair[0]);
        }
        try {
            UsbReaderListener usbReaderListener = this.usbReaderListener;
            if (usbReaderListener != null) {
                usbReaderListener.onRequestReaderDisplayMessage(message);
            }
        }
        catch (Exception e3) {
            LOGGER.e("Unexpected failure in UsbReaderListener.onRequestReaderDisplayMessage", e3, new Pair[0]);
        }
    }

    public final void onReportReaderEvent(@NotNull ReaderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LOGGER.i("onReportReaderEvent(" + event + ')', new Pair[0]);
        try {
            BluetoothReaderListener bluetoothReaderListener = this.bluetoothReaderListener;
            if (bluetoothReaderListener != null) {
                bluetoothReaderListener.onReportReaderEvent(event);
            }
        }
        catch (Exception e2) {
            LOGGER.e("Unexpected failure in BluetoothReaderListener.onReportReaderEvent", e2, new Pair[0]);
        }
        try {
            HandoffReaderListener handoffReaderListener = this.handoffReaderListener;
            if (handoffReaderListener != null) {
                handoffReaderListener.onReportReaderEvent(event);
            }
        }
        catch (Exception e3) {
            LOGGER.e("Unexpected failure in HandoffReaderListener.onReportReaderEvent", e3, new Pair[0]);
        }
        try {
            UsbReaderListener usbReaderListener = this.usbReaderListener;
            if (usbReaderListener != null) {
                usbReaderListener.onReportReaderEvent(event);
            }
        }
        catch (Exception e4) {
            LOGGER.e("Unexpected failure in UsbReaderListener.onReportReaderEvent", e4, new Pair[0]);
        }
    }

    public final void onReportLowBatteryWarning() {
        LOGGER.i("onReportLowBatteryWarning", new Pair[0]);
        try {
            BluetoothReaderListener bluetoothReaderListener = this.bluetoothReaderListener;
            if (bluetoothReaderListener != null) {
                bluetoothReaderListener.onReportLowBatteryWarning();
            }
        }
        catch (Exception e2) {
            LOGGER.e("Unexpected failure in BluetoothReaderListener.onReportLowBatteryWarning", e2, new Pair[0]);
        }
        try {
            UsbReaderListener usbReaderListener = this.usbReaderListener;
            if (usbReaderListener != null) {
                usbReaderListener.onReportLowBatteryWarning();
            }
        }
        catch (Exception e3) {
            LOGGER.e("Unexpected failure in UsbReaderListener.onReportLowBatteryWarning", e3, new Pair[0]);
        }
    }

    public final void onReportReaderBatteryInfo(@Nullable ReaderBatteryInfo readerBatteryInfo2) {
        block11: {
            block10: {
                ReaderBatteryInfo readerBatteryInfo3 = readerBatteryInfo2;
                if ((readerBatteryInfo3 != null ? readerBatteryInfo3.getBatteryLevel() : null) == null) break block10;
                ReaderBatteryInfo readerBatteryInfo4 = readerBatteryInfo2;
                if ((readerBatteryInfo4 != null ? readerBatteryInfo4.isCharging() : null) != null) break block11;
            }
            LOGGER.e("onReportReaderBatteryInfo batteryLevel and/or isCharging are null", new Pair[0]);
            return;
        }
        LOGGER.i("onReportBTReaderBatteryInfo", new Pair[0]);
        try {
            BluetoothReaderListener bluetoothReaderListener = this.bluetoothReaderListener;
            if (bluetoothReaderListener != null) {
                Float f2 = readerBatteryInfo2.getBatteryLevel();
                Intrinsics.checkNotNull((Object)f2);
                float f3 = f2.floatValue();
                BatteryStatus batteryStatus = readerBatteryInfo2.getBatteryStatus();
                Boolean bl = readerBatteryInfo2.isCharging();
                Intrinsics.checkNotNull((Object)bl);
                bluetoothReaderListener.onBatteryLevelUpdate(f3, batteryStatus, bl.booleanValue());
            }
        }
        catch (Exception e2) {
            LOGGER.e("Unexpected failure in BluetoothReaderListener.onBatteryLevelUpdate", e2, new Pair[0]);
        }
        try {
            UsbReaderListener usbReaderListener = this.usbReaderListener;
            if (usbReaderListener != null) {
                Float f4 = readerBatteryInfo2.getBatteryLevel();
                Intrinsics.checkNotNull((Object)f4);
                float f5 = f4.floatValue();
                BatteryStatus batteryStatus = readerBatteryInfo2.getBatteryStatus();
                Boolean bl = readerBatteryInfo2.isCharging();
                Intrinsics.checkNotNull((Object)bl);
                usbReaderListener.onBatteryLevelUpdate(f5, batteryStatus, bl.booleanValue());
            }
        }
        catch (Exception e3) {
            LOGGER.e("Unexpected failure in UsbReaderListener.onBatteryLevelUpdate", e3, new Pair[0]);
        }
    }

    public ProxyReaderListener() {
        this(null, null, null, 7, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/stripeterminal/internal/common/callable/ProxyReaderListener$Companion;", "", "()V", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "common_publish"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

