/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.connectivity;

import com.stripe.offlinemode.helpers.OfflineConfigHelper;
import com.stripe.stripeterminal.internal.common.connectivity.StripeHealthCheckerState;
import com.stripe.stripeterminal.internal.common.connectivity.StripeHealthCheckerStateMachine;
import com.stripe.stripeterminal.internal.common.connectivity.StripeNetworkHealthChecker;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0019\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0011\u0010\u0014\u001a\u00020\u0013H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J#\u0010\u0016\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\u00130\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2={"Lcom/stripe/stripeterminal/internal/common/connectivity/DefaultStripeNetworkHealthChecker;", "Lcom/stripe/stripeterminal/internal/common/connectivity/StripeNetworkHealthChecker;", "stateMachine", "Lcom/stripe/stripeterminal/internal/common/connectivity/StripeHealthCheckerStateMachine;", "networkClient", "Lokhttp3/OkHttpClient;", "stripeHealthCheckUrl", "Lokhttp3/HttpUrl;", "offlineConfigHelper", "Lcom/stripe/offlinemode/helpers/OfflineConfigHelper;", "(Lcom/stripe/stripeterminal/internal/common/connectivity/StripeHealthCheckerStateMachine;Lokhttp3/OkHttpClient;Lokhttp3/HttpUrl;Lcom/stripe/offlinemode/helpers/OfflineConfigHelper;)V", "healthCheckTimeoutClient", "delayForState", "", "state", "Lcom/stripe/stripeterminal/internal/common/connectivity/StripeHealthCheckerState;", "(Lcom/stripe/stripeterminal/internal/common/connectivity/StripeHealthCheckerState;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getNetworkHealthStatusFlow", "Lkotlinx/coroutines/flow/Flow;", "", "isNetworkHealthy", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "emitValueForState", "Lkotlinx/coroutines/flow/FlowCollector;", "(Lkotlinx/coroutines/flow/FlowCollector;Lcom/stripe/stripeterminal/internal/common/connectivity/StripeHealthCheckerState;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "connectivity_release"})
@SourceDebugExtension(value={"SMAP\nDefaultStripeNetworkHealthChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultStripeNetworkHealthChecker.kt\ncom/stripe/stripeterminal/internal/common/connectivity/DefaultStripeNetworkHealthChecker\n+ 2 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n*L\n1#1,97:1\n314#2,11:98\n*S KotlinDebug\n*F\n+ 1 DefaultStripeNetworkHealthChecker.kt\ncom/stripe/stripeterminal/internal/common/connectivity/DefaultStripeNetworkHealthChecker\n*L\n36#1:98,11\n*E\n"})
public final class DefaultStripeNetworkHealthChecker
implements StripeNetworkHealthChecker {
    @NotNull
    private final StripeHealthCheckerStateMachine stateMachine;
    @NotNull
    private final HttpUrl stripeHealthCheckUrl;
    @NotNull
    private final OkHttpClient healthCheckTimeoutClient;

    @Inject
    public DefaultStripeNetworkHealthChecker(@NotNull StripeHealthCheckerStateMachine stateMachine, @NotNull OkHttpClient networkClient, @NotNull HttpUrl stripeHealthCheckUrl, @NotNull OfflineConfigHelper offlineConfigHelper) {
        Intrinsics.checkNotNullParameter((Object)stateMachine, (String)"stateMachine");
        Intrinsics.checkNotNullParameter((Object)networkClient, (String)"networkClient");
        Intrinsics.checkNotNullParameter((Object)stripeHealthCheckUrl, (String)"stripeHealthCheckUrl");
        Intrinsics.checkNotNullParameter((Object)offlineConfigHelper, (String)"offlineConfigHelper");
        this.stateMachine = stateMachine;
        this.stripeHealthCheckUrl = stripeHealthCheckUrl;
        this.healthCheckTimeoutClient = networkClient.newBuilder().callTimeout(offlineConfigHelper.getHttpHealthCheckTimeoutMs(), TimeUnit.MILLISECONDS).build();
    }

    @Override
    @Nullable
    public Object isNetworkHealthy(@NotNull Continuation<? super Boolean> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super Boolean> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        Call $this$isNetworkHealthy_u24lambda_u241_u24lambda_u240 = this.healthCheckTimeoutClient.newCall(new Request.Builder().url(this.stripeHealthCheckUrl).build());
        boolean bl3 = false;
        $this$isNetworkHealthy_u24lambda_u241_u24lambda_u240.enqueue(new Callback((CancellableContinuation<? super Boolean>)continuation){
            final /* synthetic */ CancellableContinuation<Boolean> $continuation;
            {
                this.$continuation = $continuation;
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e2) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                ((Continuation)this.$continuation).resumeWith(Result.constructor-impl((Object)false));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Boolean bl;
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Continuation continuation = (Continuation)this.$continuation;
                Object object = (Closeable)response;
                Throwable throwable = null;
                try {
                    Response p0 = (Response)object;
                    boolean bl2 = false;
                    bl = p0.isSuccessful();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                object = bl;
                continuation.resumeWith(Result.constructor-impl((Object)object));
            }
        });
        continuation.invokeOnCancellation((Function1)new Function1<Throwable, Unit>($this$isNetworkHealthy_u24lambda_u241_u24lambda_u240){
            final /* synthetic */ Call $this_run;
            {
                this.$this_run = $receiver;
                super(1);
            }

            public final void invoke(@Nullable Throwable it) {
                try {
                    this.$this_run.cancel();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    @Override
    @NotNull
    public Flow<Boolean> getNetworkHealthStatusFlow() {
        return FlowKt.distinctUntilChanged((Flow)FlowKt.flow((Function2)((Function2)new Function2<FlowCollector<? super Boolean>, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ DefaultStripeNetworkHealthChecker this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$flow = (FlowCollector)this.L$0;
                        DefaultStripeNetworkHealthChecker.access$getStateMachine$p(this.this$0).reset(StripeHealthCheckerState.UNKNOWN);
lbl7:
                        // 3 sources

                        while (JobKt.isActive((CoroutineContext)this.getContext())) {
                            var4_5 = DefaultStripeNetworkHealthChecker.access$getStateMachine$p(this.this$0);
                            this.L$0 = $this$flow;
                            this.L$1 = var4_5;
                            this.label = 1;
                            v0 = this.this$0.isNetworkHealthy((Continuation<? super Boolean>)((Continuation)this));
                            if (v0 == var5_2) {
                                return var5_2;
                            }
                            ** GOTO lbl22
                        }
                        break;
                    }
                    case 1: {
                        var4_5 = (StripeHealthCheckerStateMachine)this.L$1;
                        $this$flow = (FlowCollector)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl22:
                        // 2 sources

                        var4_5.update((Boolean)v0);
                        v1 = (StripeHealthCheckerState)DefaultStripeNetworkHealthChecker.access$getStateMachine$p(this.this$0).getState();
                        if (v1 == null) {
                            v1 = StripeHealthCheckerState.UNKNOWN;
                        }
                        state = v1;
                        this.L$0 = $this$flow;
                        this.L$1 = state;
                        this.label = 2;
                        v2 = DefaultStripeNetworkHealthChecker.access$emitValueForState(this.this$0, $this$flow, state, (Continuation)this);
                        if (v2 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl39
                    }
                    case 2: {
                        state = (StripeHealthCheckerState)this.L$1;
                        $this$flow = (FlowCollector)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl39:
                        // 2 sources

                        this.L$0 = $this$flow;
                        this.L$1 = null;
                        this.label = 3;
                        v3 = DefaultStripeNetworkHealthChecker.access$delayForState(this.this$0, state, (Continuation)this);
                        if (v3 != var5_2) ** GOTO lbl7
                        return var5_2;
                    }
                    case 3: {
                        $this$flow = (FlowCollector)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
                        ** GOTO lbl7
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<FlowCollector<? super Boolean>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull FlowCollector<? super Boolean> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })));
    }

    private final Object delayForState(StripeHealthCheckerState state, Continuation<? super Unit> $completion) {
        long l2;
        switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
            case 1: {
                l2 = 60000L;
                break;
            }
            case 2: {
                l2 = 30000L;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                l2 = 5000L;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Object object = DelayKt.delay((long)l2, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object emitValueForState(FlowCollector<? super Boolean> $this$emitValueForState, StripeHealthCheckerState state, Continuation<? super Unit> $completion) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
            case 2: 
            case 3: 
            case 4: {
                bl = false;
                break;
            }
            case 1: 
            case 5: {
                bl = true;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Object object = $this$emitValueForState.emit((Object)Boxing.boxBoolean((boolean)bl), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ StripeHealthCheckerStateMachine access$getStateMachine$p(DefaultStripeNetworkHealthChecker $this) {
        return $this.stateMachine;
    }

    public static final /* synthetic */ Object access$emitValueForState(DefaultStripeNetworkHealthChecker $this, FlowCollector $receiver, StripeHealthCheckerState state, Continuation $completion) {
        return $this.emitValueForState((FlowCollector<? super Boolean>)$receiver, state, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$delayForState(DefaultStripeNetworkHealthChecker $this, StripeHealthCheckerState state, Continuation $completion) {
        return $this.delayForState(state, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StripeHealthCheckerState.values().length];
            try {
                nArray[StripeHealthCheckerState.ONLINE_STABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeHealthCheckerState.OFFLINE_STABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeHealthCheckerState.UNKNOWN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeHealthCheckerState.OFFLINE_UNSTABLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeHealthCheckerState.ONLINE_UNSTABLE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

