/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.connectivity;

import com.stripe.core.statemachine.StateMachine;
import com.stripe.stripeterminal.internal.common.connectivity.StripeHealthCheckerData;
import com.stripe.stripeterminal.internal.common.connectivity.StripeHealthCheckerState;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u0004B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u001a\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/stripe/stripeterminal/internal/common/connectivity/OfflineUnstableHandler;", "Lcom/stripe/core/statemachine/StateMachine$StateHandler;", "Lcom/stripe/stripeterminal/internal/common/connectivity/StripeHealthCheckerState;", "Lcom/stripe/stripeterminal/internal/common/connectivity/StripeHealthCheckerData;", "Lcom/stripe/stripeterminal/internal/common/connectivity/StripeHealthCheckerStateHandler;", "()V", "attemptCount", "", "onEnter", "", "current", "from", "onExit", "to", "onUpdate", "new", "old", "connectivity_release"})
public final class OfflineUnstableHandler
extends StateMachine.StateHandler<StripeHealthCheckerState, StripeHealthCheckerData> {
    private int attemptCount;

    @Inject
    public OfflineUnstableHandler() {
        super(StripeHealthCheckerState.OFFLINE_UNSTABLE);
    }

    @Override
    public void onEnter(@Nullable StripeHealthCheckerData current, @Nullable StripeHealthCheckerState from) {
        super.onEnter(current, from);
        int n2 = this.attemptCount;
        this.attemptCount = n2 + 1;
    }

    @Override
    public void onUpdate(@NotNull StripeHealthCheckerData stripeHealthCheckerData, @Nullable StripeHealthCheckerData old) {
        Intrinsics.checkNotNullParameter((Object)stripeHealthCheckerData, (String)"new");
        super.onUpdate(stripeHealthCheckerData, old);
        if (!stripeHealthCheckerData.getReachable()) {
            this.transitionTo(StripeHealthCheckerState.OFFLINE_STABLE, "Health check call failed");
        } else {
            int n2 = this.attemptCount;
            this.attemptCount = n2 + 1;
            if (this.attemptCount >= 3) {
                this.transitionTo(StripeHealthCheckerState.ONLINE_STABLE, "Consecutive health check calls succeeded");
            }
        }
    }

    @Override
    public void onExit(@NotNull StripeHealthCheckerState to) {
        Intrinsics.checkNotNullParameter((Object)((Object)to), (String)"to");
        super.onExit(to);
        this.attemptCount = 0;
    }
}

