/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.connectivity;

import com.stripe.core.statemachine.StateMachine;
import com.stripe.stripeterminal.internal.common.connectivity.OfflineStableHandler;
import com.stripe.stripeterminal.internal.common.connectivity.OfflineUnstableHandler;
import com.stripe.stripeterminal.internal.common.connectivity.OnlineStableHandler;
import com.stripe.stripeterminal.internal.common.connectivity.OnlineUnstableHandler;
import com.stripe.stripeterminal.internal.common.connectivity.StripeHealthCheckerData;
import com.stripe.stripeterminal.internal.common.connectivity.StripeHealthCheckerState;
import com.stripe.stripeterminal.internal.common.connectivity.UnknownHandler;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B/\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0003H\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0002H\u0002J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/stripe/stripeterminal/internal/common/connectivity/StripeHealthCheckerStateMachine;", "Lcom/stripe/core/statemachine/StateMachine;", "Lcom/stripe/stripeterminal/internal/common/connectivity/StripeHealthCheckerState;", "Lcom/stripe/stripeterminal/internal/common/connectivity/StripeHealthCheckerData;", "unknownHandler", "Lcom/stripe/stripeterminal/internal/common/connectivity/UnknownHandler;", "onlineStableHandler", "Lcom/stripe/stripeterminal/internal/common/connectivity/OnlineStableHandler;", "offlineStableHandler", "Lcom/stripe/stripeterminal/internal/common/connectivity/OfflineStableHandler;", "onlineUnstableHandler", "Lcom/stripe/stripeterminal/internal/common/connectivity/OnlineUnstableHandler;", "offlineUnstableHandler", "Lcom/stripe/stripeterminal/internal/common/connectivity/OfflineUnstableHandler;", "(Lcom/stripe/stripeterminal/internal/common/connectivity/UnknownHandler;Lcom/stripe/stripeterminal/internal/common/connectivity/OnlineStableHandler;Lcom/stripe/stripeterminal/internal/common/connectivity/OfflineStableHandler;Lcom/stripe/stripeterminal/internal/common/connectivity/OnlineUnstableHandler;Lcom/stripe/stripeterminal/internal/common/connectivity/OfflineUnstableHandler;)V", "getDataOrDefault", "registerHandlers", "", "reset", "state", "setInitialState", "update", "reachable", "", "connectivity_release"})
@SourceDebugExtension(value={"SMAP\nStripeHealthCheckerStateMachine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StripeHealthCheckerStateMachine.kt\ncom/stripe/stripeterminal/internal/common/connectivity/StripeHealthCheckerStateMachine\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,56:1\n13579#2,2:57\n*S KotlinDebug\n*F\n+ 1 StripeHealthCheckerStateMachine.kt\ncom/stripe/stripeterminal/internal/common/connectivity/StripeHealthCheckerStateMachine\n*L\n24#1:57,2\n*E\n"})
public final class StripeHealthCheckerStateMachine
extends StateMachine<StripeHealthCheckerState, StripeHealthCheckerData> {
    @NotNull
    private final UnknownHandler unknownHandler;
    @NotNull
    private final OnlineStableHandler onlineStableHandler;
    @NotNull
    private final OfflineStableHandler offlineStableHandler;
    @NotNull
    private final OnlineUnstableHandler onlineUnstableHandler;
    @NotNull
    private final OfflineUnstableHandler offlineUnstableHandler;

    @Inject
    public StripeHealthCheckerStateMachine(@NotNull UnknownHandler unknownHandler, @NotNull OnlineStableHandler onlineStableHandler, @NotNull OfflineStableHandler offlineStableHandler, @NotNull OnlineUnstableHandler onlineUnstableHandler, @NotNull OfflineUnstableHandler offlineUnstableHandler) {
        Intrinsics.checkNotNullParameter((Object)unknownHandler, (String)"unknownHandler");
        Intrinsics.checkNotNullParameter((Object)onlineStableHandler, (String)"onlineStableHandler");
        Intrinsics.checkNotNullParameter((Object)offlineStableHandler, (String)"offlineStableHandler");
        Intrinsics.checkNotNullParameter((Object)onlineUnstableHandler, (String)"onlineUnstableHandler");
        Intrinsics.checkNotNullParameter((Object)offlineUnstableHandler, (String)"offlineUnstableHandler");
        this.unknownHandler = unknownHandler;
        this.onlineStableHandler = onlineStableHandler;
        this.offlineStableHandler = offlineStableHandler;
        this.onlineUnstableHandler = onlineUnstableHandler;
        this.offlineUnstableHandler = offlineUnstableHandler;
        this.registerHandlers();
        this.setInitialState(StripeHealthCheckerState.UNKNOWN);
    }

    private final void registerHandlers() {
        StripeHealthCheckerState[] $this$forEach$iv = StripeHealthCheckerState.values();
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            StateMachine.StateHandler stateHandler;
            StripeHealthCheckerState element$iv;
            StripeHealthCheckerState it = element$iv = $this$forEach$iv[i2];
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
                case 1: {
                    stateHandler = this.unknownHandler;
                    break;
                }
                case 2: {
                    stateHandler = this.onlineStableHandler;
                    break;
                }
                case 3: {
                    stateHandler = this.onlineUnstableHandler;
                    break;
                }
                case 4: {
                    stateHandler = this.offlineStableHandler;
                    break;
                }
                case 5: {
                    stateHandler = this.offlineUnstableHandler;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            stateHandler.register(this);
        }
    }

    private final void setInitialState(StripeHealthCheckerState state) {
        StateMachine.transitionTo$default(this, (Object)state, null, 2, null);
    }

    public final void reset(@NotNull StripeHealthCheckerState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.setInitialState(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void update(boolean reachable) {
        StripeHealthCheckerStateMachine stripeHealthCheckerStateMachine = this;
        synchronized (stripeHealthCheckerStateMachine) {
            boolean bl = false;
            StripeHealthCheckerData data = this.getDataOrDefault();
            this.updateData(data.copy(reachable));
            Unit unit = Unit.INSTANCE;
        }
    }

    private final StripeHealthCheckerData getDataOrDefault() {
        StripeHealthCheckerData stripeHealthCheckerData = (StripeHealthCheckerData)this.getData();
        if (stripeHealthCheckerData == null) {
            stripeHealthCheckerData = new StripeHealthCheckerData(false);
        }
        return stripeHealthCheckerData;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StripeHealthCheckerState.values().length];
            try {
                nArray[StripeHealthCheckerState.UNKNOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeHealthCheckerState.ONLINE_STABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeHealthCheckerState.ONLINE_UNSTABLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeHealthCheckerState.OFFLINE_STABLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeHealthCheckerState.OFFLINE_UNSTABLE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

