/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.crpc;

import com.squareup.wire.Message;
import com.stripe.core.logginginterceptors.CrpcLogLevel;
import com.stripe.core.logginginterceptors.CrpcLogLevelKt;
import com.stripe.jvmcore.crpcclient.CrpcClient;
import com.stripe.jvmcore.crpcclient.CrpcResponse;
import com.stripe.jvmcore.crpcclient.CustomCrpcInterceptor;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.redaction.Extensions;
import com.stripe.jvmcore.redaction.terminal.TerminalMessageRedactor;
import com.stripe.proto.net.rpc.base.RpcRequest;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0002J[\u0010\u0007\u001a\u00020\b\"\u0012\b\u0000\u0010\t*\f\u0012\u0004\u0012\u0002H\t\u0012\u0002\b\u00030\n\"\u0012\b\u0001\u0010\u000b*\f\u0012\u0004\u0012\u0002H\u000b\u0012\u0002\b\u00030\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u0002H\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\t0\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J9\u0010\u0014\u001a\u00020\b\"\u0012\b\u0000\u0010\t*\f\u0012\u0004\u0012\u0002H\t\u0012\u0002\b\u00030\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u0002H\tH\u0016\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/stripe/stripeterminal/internal/common/crpc/CrpcLogPointInterceptor;", "Lcom/stripe/jvmcore/crpcclient/CustomCrpcInterceptor;", "()V", "name", "", "getName", "()Ljava/lang/String;", "postCallAction", "", "M", "Lcom/squareup/wire/Message;", "RE", "okHttpRequest", "Lokhttp3/Request;", "rpcRequest", "Lcom/stripe/proto/net/rpc/base/RpcRequest;", "apiRequest", "crpcResponse", "Lcom/stripe/jvmcore/crpcclient/CrpcResponse;", "(Lokhttp3/Request;Lcom/stripe/proto/net/rpc/base/RpcRequest;Lcom/squareup/wire/Message;Lcom/stripe/jvmcore/crpcclient/CrpcResponse;)V", "preCallAction", "(Lokhttp3/Request;Lcom/stripe/proto/net/rpc/base/RpcRequest;Lcom/squareup/wire/Message;)V", "Companion", "common_publish"})
public final class CrpcLogPointInterceptor
extends CustomCrpcInterceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(CrpcClient.class);
    @NotNull
    private static final String CUSTOM_INTERCEPTOR_NAME = "CrpcLogPointInterceptor";

    @Inject
    public CrpcLogPointInterceptor() {
        this.name = CUSTOM_INTERCEPTOR_NAME;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public <M extends Message<M, ?>> void preCallAction(@NotNull Request okHttpRequest, @NotNull RpcRequest rpcRequest, @NotNull M apiRequest) {
        Intrinsics.checkNotNullParameter((Object)okHttpRequest, (String)"okHttpRequest");
        Intrinsics.checkNotNullParameter((Object)((Object)rpcRequest), (String)"rpcRequest");
        Intrinsics.checkNotNullParameter(apiRequest, (String)"apiRequest");
        if (CrpcLogLevelKt.getTraceLogLevel(rpcRequest).compareTo((Enum)CrpcLogLevel.NONE) > 0) {
            LOGGER.i(rpcRequest.service + '.' + rpcRequest.method + " request=" + Extensions.toLogJson$default(Extensions.INSTANCE, apiRequest, TerminalMessageRedactor.INSTANCE, null, 2, null), new Pair[0]);
        }
    }

    @Override
    public <M extends Message<M, ?>, RE extends Message<RE, ?>> void postCallAction(@NotNull Request okHttpRequest, @NotNull RpcRequest rpcRequest, @NotNull RE apiRequest, @NotNull CrpcResponse<M> crpcResponse) {
        Intrinsics.checkNotNullParameter((Object)okHttpRequest, (String)"okHttpRequest");
        Intrinsics.checkNotNullParameter((Object)((Object)rpcRequest), (String)"rpcRequest");
        Intrinsics.checkNotNullParameter(apiRequest, (String)"apiRequest");
        Intrinsics.checkNotNullParameter(crpcResponse, (String)"crpcResponse");
        if (CrpcLogLevelKt.getTraceLogLevel(rpcRequest).compareTo((Enum)CrpcLogLevel.NONE) > 0) {
            LOGGER.i(rpcRequest.service + '.' + rpcRequest.method + ' ' + crpcResponse.toLogString(), new Pair[0]);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/stripeterminal/internal/common/crpc/CrpcLogPointInterceptor$Companion;", "", "()V", "CUSTOM_INTERCEPTOR_NAME", "", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "common_publish"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

