/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.deviceinfo;

import android.content.Context;
import android.content.SharedPreferences;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"PREF_UNIQUE_ID", "", "SHARED_PREFS", "createDeviceUuid", "sharedPrefs", "Landroid/content/SharedPreferences;", "getDeviceUuid", "context", "Landroid/content/Context;", "common_publish"})
public final class DeviceUuidProviderKt {
    @NotNull
    private static final String SHARED_PREFS = "stripe_terminal_shared_prefs";
    @NotNull
    private static final String PREF_UNIQUE_ID = "pref_unique_id";

    @NotNull
    public static final String getDeviceUuid(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences sharedPrefs = context.getSharedPreferences(SHARED_PREFS, 0);
        String string = sharedPrefs.getString(PREF_UNIQUE_ID, null);
        if (string == null) {
            Intrinsics.checkNotNullExpressionValue((Object)sharedPrefs, (String)"sharedPrefs");
            string = DeviceUuidProviderKt.createDeviceUuid(sharedPrefs);
        }
        return string;
    }

    private static final String createDeviceUuid(SharedPreferences sharedPrefs) {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String uuid = string;
        SharedPreferences.Editor editor = sharedPrefs.edit();
        editor.putString(PREF_UNIQUE_ID, uuid);
        editor.apply();
        return uuid;
    }
}

