/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.deviceinfo;

import com.stripe.jvmcore.device.MainlandDeviceType;
import com.stripe.jvmcore.device.PlatformDeviceInfo;
import com.stripe.proto.model.common.BBPosHardware;
import com.stripe.proto.model.common.HardwareModel;
import com.stripe.proto.model.common.SimulatedHardware;
import com.stripe.proto.model.common.UnknownHardware;
import com.stripe.proto.model.common.VerifoneHardware;
import com.stripe.stripeterminal.external.models.DeviceType;
import com.stripe.stripeterminal.external.models.Reader;
import com.stripe.stripeterminal.internal.common.TerminalStatusManager;
import dagger.Reusable;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Reusable
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\n\u0010\b\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u0011\u001a\u00020\u0006H\u0016J\u0016\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0006H\u0016J\b\u0010\u0015\u001a\u00020\u0006H\u0016J\u001a\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0013j\u0002`\u0017H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/stripe/stripeterminal/internal/common/deviceinfo/ReaderPlatformDeviceInfo;", "Lcom/stripe/jvmcore/device/PlatformDeviceInfo;", "statusManager", "Lcom/stripe/stripeterminal/internal/common/TerminalStatusManager;", "(Lcom/stripe/stripeterminal/internal/common/TerminalStatusManager;)V", "getBootloaderVersion", "", "getConfigVersion", "getEmvKeyProfileId", "getFirmwareVersion", "getHardwareModel", "Lcom/stripe/proto/model/common/HardwareModel;", "getHardwareVersion", "getMacKeyProfileId", "getMainlandDeviceType", "Lcom/stripe/jvmcore/device/MainlandDeviceType;", "getPinKeyProfileId", "getPinKeysetId", "getRawReaderData", "", "getSerialNumber", "getSoftwareVersion", "getSystemProperties", "Lcom/stripe/jvmcore/device/DeviceAttributes;", "getTrackKeyProfileId", "isEmulator", "", "Companion", "common_publish"})
public final class ReaderPlatformDeviceInfo
implements PlatformDeviceInfo {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalStatusManager statusManager;
    @NotNull
    private static final String UNKNOWN = "unknown";
    @NotNull
    private static final String NO_CONNECTED_READER = "No connected reader";
    @NotNull
    private static final String UNKNOWN_READER_CONNECTED = "Unknown reader connected";

    @Inject
    public ReaderPlatformDeviceInfo(@NotNull TerminalStatusManager statusManager) {
        Intrinsics.checkNotNullParameter((Object)statusManager, (String)"statusManager");
        this.statusManager = statusManager;
    }

    @Override
    @NotNull
    public HardwareModel getHardwareModel() {
        HardwareModel hardwareModel;
        Reader reader = this.statusManager.getConnectedReader();
        if (reader != null) {
            Reader it = reader;
            boolean bl = false;
            if (it.isSimulated()) {
                SimulatedHardware simulatedHardware;
                switch (WhenMappings.$EnumSwitchMapping$0[it.getDeviceType().ordinal()]) {
                    case 1: {
                        simulatedHardware = new SimulatedHardware(null, BBPosHardware.CHIPPER1X, null, null, 13, null);
                        break;
                    }
                    case 2: {
                        simulatedHardware = new SimulatedHardware(null, BBPosHardware.CHIPPER2X, null, null, 13, null);
                        break;
                    }
                    case 3: {
                        simulatedHardware = new SimulatedHardware(null, BBPosHardware.STRIPEM2, null, null, 13, null);
                        break;
                    }
                    case 4: {
                        simulatedHardware = new SimulatedHardware(null, BBPosHardware.CHIPPER2X, null, null, 13, null);
                        break;
                    }
                    case 5: {
                        simulatedHardware = new SimulatedHardware(VerifoneHardware.P400, null, null, null, 14, null);
                        break;
                    }
                    case 6: {
                        simulatedHardware = new SimulatedHardware(null, BBPosHardware.WISECUBE, null, null, 13, null);
                        break;
                    }
                    case 7: {
                        simulatedHardware = new SimulatedHardware(null, BBPosHardware.WISEPAD3, null, null, 13, null);
                        break;
                    }
                    case 8: {
                        simulatedHardware = new SimulatedHardware(null, BBPosHardware.WISEPAD3S, null, null, 13, null);
                        break;
                    }
                    case 9: {
                        simulatedHardware = new SimulatedHardware(null, BBPosHardware.WISEPOS_E, null, null, 13, null);
                        break;
                    }
                    case 10: {
                        simulatedHardware = new SimulatedHardware(null, BBPosHardware.WISEPOS_E_DEVKIT, null, null, 13, null);
                        break;
                    }
                    case 11: {
                        simulatedHardware = new SimulatedHardware(null, BBPosHardware.SHOPIFY_ETNA, null, null, 13, null);
                        break;
                    }
                    case 12: {
                        simulatedHardware = new SimulatedHardware(null, BBPosHardware.STRIPE_S700, null, null, 13, null);
                        break;
                    }
                    case 13: {
                        simulatedHardware = new SimulatedHardware(null, BBPosHardware.STRIPE_S700_DEVKIT, null, null, 13, null);
                        break;
                    }
                    case 14: {
                        simulatedHardware = new SimulatedHardware(null, BBPosHardware.BBPOS_MODEL_NOT_SET, null, null, 13, null);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                SimulatedHardware simulatedHardware2 = simulatedHardware;
                hardwareModel = new HardwareModel(null, null, null, null, simulatedHardware2, null, null, null, 239, null);
            } else {
                switch (WhenMappings.$EnumSwitchMapping$0[it.getDeviceType().ordinal()]) {
                    case 1: {
                        hardwareModel = new HardwareModel(null, null, null, BBPosHardware.CHIPPER1X, null, null, null, null, 247, null);
                        break;
                    }
                    case 2: {
                        hardwareModel = new HardwareModel(null, null, null, BBPosHardware.CHIPPER2X, null, null, null, null, 247, null);
                        break;
                    }
                    case 3: {
                        hardwareModel = new HardwareModel(null, null, null, BBPosHardware.STRIPEM2, null, null, null, null, 247, null);
                        break;
                    }
                    case 4: {
                        hardwareModel = new HardwareModel(null, null, null, BBPosHardware.CHIPPER2X, null, null, null, null, 247, null);
                        break;
                    }
                    case 5: {
                        hardwareModel = new HardwareModel(null, VerifoneHardware.P400, null, null, null, null, null, null, 253, null);
                        break;
                    }
                    case 6: {
                        hardwareModel = new HardwareModel(null, null, null, BBPosHardware.WISECUBE, null, null, null, null, 247, null);
                        break;
                    }
                    case 7: {
                        hardwareModel = new HardwareModel(null, null, null, BBPosHardware.WISEPAD3, null, null, null, null, 247, null);
                        break;
                    }
                    case 8: {
                        hardwareModel = new HardwareModel(null, null, null, BBPosHardware.WISEPAD3S, null, null, null, null, 247, null);
                        break;
                    }
                    case 9: {
                        hardwareModel = new HardwareModel(null, null, null, BBPosHardware.WISEPOS_E, null, null, null, null, 247, null);
                        break;
                    }
                    case 10: {
                        hardwareModel = new HardwareModel(null, null, null, BBPosHardware.WISEPOS_E_DEVKIT, null, null, null, null, 247, null);
                        break;
                    }
                    case 11: {
                        hardwareModel = new HardwareModel(null, null, null, BBPosHardware.SHOPIFY_ETNA, null, null, null, null, 247, null);
                        break;
                    }
                    case 12: {
                        hardwareModel = new HardwareModel(null, null, null, BBPosHardware.STRIPE_S700, null, null, null, null, 247, null);
                        break;
                    }
                    case 13: {
                        hardwareModel = new HardwareModel(null, null, null, BBPosHardware.STRIPE_S700_DEVKIT, null, null, null, null, 247, null);
                        break;
                    }
                    case 14: {
                        hardwareModel = new HardwareModel(new UnknownHardware(UNKNOWN_READER_CONNECTED, null, 2, null), null, null, null, null, null, null, null, 254, null);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
        } else {
            hardwareModel = new HardwareModel(new UnknownHardware(NO_CONNECTED_READER, null, 2, null), null, null, null, null, null, null, null, 254, null);
        }
        return hardwareModel;
    }

    @Override
    @NotNull
    public String getHardwareVersion() {
        Object object = this.statusManager.getConnectedReader();
        if (object == null || (object = object.getHardwareVersion()) == null) {
            object = UNKNOWN;
        }
        return object;
    }

    @Override
    @NotNull
    public MainlandDeviceType getMainlandDeviceType() {
        Object object = this.statusManager.getConnectedReader();
        if (object == null || (object = object.getDeviceType()) == null || (object = object.getDeviceName()) == null) {
            object = UNKNOWN;
        }
        return new MainlandDeviceType((String)object);
    }

    @Override
    @NotNull
    public String getSerialNumber() {
        Object object = this.statusManager.getConnectedReader();
        if (object == null || (object = object.getSerialNumber()) == null) {
            object = UNKNOWN;
        }
        return object;
    }

    @Override
    @NotNull
    public String getSoftwareVersion() {
        Object object = this.statusManager.getConnectedReader();
        if (object == null || (object = object.getSoftwareVersion()) == null) {
            object = UNKNOWN;
        }
        return object;
    }

    @Override
    @NotNull
    public String getFirmwareVersion() {
        Object object = this.statusManager.getConnectedReader();
        if (object == null || (object = object.getFirmwareVersion()) == null) {
            object = UNKNOWN;
        }
        return object;
    }

    @Override
    @NotNull
    public String getConfigVersion() {
        Object object = this.statusManager.getConnectedReader();
        if (object == null || (object = object.getConfigVersion()) == null) {
            object = UNKNOWN;
        }
        return object;
    }

    @Override
    @NotNull
    public String getBootloaderVersion() {
        Object object = this.statusManager.getConnectedReader();
        if (object == null || (object = object.getBootloaderVersion()) == null) {
            object = UNKNOWN;
        }
        return object;
    }

    @Override
    @Nullable
    public String getPinKeyProfileId() {
        Reader reader = this.statusManager.getConnectedReader();
        return reader != null ? reader.getPinKeyProfileId() : null;
    }

    @Override
    @Nullable
    public String getMacKeyProfileId() {
        Reader reader = this.statusManager.getConnectedReader();
        return reader != null ? reader.getMacKeyProfileId() : null;
    }

    @Override
    @Nullable
    public String getEmvKeyProfileId() {
        Reader reader = this.statusManager.getConnectedReader();
        return reader != null ? reader.getEmvKeyProfileId() : null;
    }

    @Override
    @Nullable
    public String getTrackKeyProfileId() {
        Reader reader = this.statusManager.getConnectedReader();
        return reader != null ? reader.getTrackKeyProfileId() : null;
    }

    @Override
    @NotNull
    public String getPinKeysetId() {
        Object object = this.statusManager.getConnectedReader();
        if (object == null || (object = object.getPinKeysetId()) == null) {
            object = UNKNOWN;
        }
        return object;
    }

    @Override
    @Nullable
    public Map<String, String> getRawReaderData() {
        Reader reader = this.statusManager.getConnectedReader();
        return reader != null ? reader.getRawReaderData() : null;
    }

    @Override
    @NotNull
    public Map<String, String> getSystemProperties() {
        return MapsKt.emptyMap();
    }

    @Override
    public boolean isEmulator() {
        return false;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/stripeterminal/internal/common/deviceinfo/ReaderPlatformDeviceInfo$Companion;", "", "()V", "NO_CONNECTED_READER", "", "UNKNOWN", "UNKNOWN_READER_CONNECTED", "common_publish"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DeviceType.values().length];
            try {
                nArray[DeviceType.CHIPPER_1X.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.CHIPPER_2X.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.STRIPE_M2.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.COTS_DEVICE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.VERIFONE_P400.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.WISECUBE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.WISEPAD_3.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.WISEPAD_3S.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.WISEPOS_E.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.WISEPOS_E_DEVKIT.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.ETNA.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.STRIPE_S700.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.STRIPE_S700_DEVKIT.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.UNKNOWN.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

