/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.dns;

import com.stripe.stripeterminal.internal.common.validators.InetAddressValidator;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.Dns;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/stripe/stripeterminal/internal/common/dns/InternetReaderDns;", "Lokhttp3/Dns;", "inetAddressValidator", "Lcom/stripe/stripeterminal/internal/common/validators/InetAddressValidator;", "fallbackDns", "lookupDomains", "", "", "(Lcom/stripe/stripeterminal/internal/common/validators/InetAddressValidator;Lokhttp3/Dns;[Ljava/lang/String;)V", "[Ljava/lang/String;", "lookup", "", "Ljava/net/InetAddress;", "hostname", "lookupForDomain", "lookupDomain", "Companion", "common_publish"})
@SourceDebugExtension(value={"SMAP\nInternetReaderDns.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InternetReaderDns.kt\ncom/stripe/stripeterminal/internal/common/dns/InternetReaderDns\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n11653#2,9:94\n13579#2:103\n13580#2:105\n11662#2:106\n1#3:104\n1#3:110\n766#4:107\n857#4,2:108\n*S KotlinDebug\n*F\n+ 1 InternetReaderDns.kt\ncom/stripe/stripeterminal/internal/common/dns/InternetReaderDns\n*L\n64#1:94,9\n64#1:103\n64#1:105\n64#1:106\n64#1:104\n65#1:107\n65#1:108,2\n*E\n"})
public final class InternetReaderDns
implements Dns {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final InetAddressValidator inetAddressValidator;
    @NotNull
    private final Dns fallbackDns;
    @NotNull
    private final String[] lookupDomains;
    @NotNull
    private static final String IP_OCTET_PATTERN = "(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])";
    @NotNull
    private static final String IP24B_BLOCK_PATTERN = "10\\-(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])\\-(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])\\-(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])";
    @NotNull
    private static final String IP20B_BLOCK_PATTERN = "172\\-(1[6-9]|2[0-9]|3[0-1])\\-(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])\\-(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])";
    @NotNull
    private static final String IP16B_BLOCK_PATTERN = "192\\-168\\-(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])\\-(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])";
    @NotNull
    private static final String IP32B_BLOCK_PATTERN = "127\\-0\\-0\\-1";
    @NotNull
    private static final String IP_PARTS_PATTERN = "(10\\-(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])\\-(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])\\-(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])|172\\-(1[6-9]|2[0-9]|3[0-1])\\-(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])\\-(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])|192\\-168\\-(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])\\-(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])|127\\-0\\-0\\-1)";
    @NotNull
    private static final String HASH_VALUE_PATTERN = "[a-z0-9]+";
    @NotNull
    private static final Regex ipPartsMatcher = new Regex("(10\\-(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])\\-(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])\\-(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])|172\\-(1[6-9]|2[0-9]|3[0-1])\\-(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])\\-(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])|192\\-168\\-(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])\\-(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])|127\\-0\\-0\\-1)");

    public InternetReaderDns(@NotNull InetAddressValidator inetAddressValidator, @NotNull Dns fallbackDns, String ... lookupDomains) {
        Intrinsics.checkNotNullParameter((Object)inetAddressValidator, (String)"inetAddressValidator");
        Intrinsics.checkNotNullParameter((Object)fallbackDns, (String)"fallbackDns");
        Intrinsics.checkNotNullParameter((Object)lookupDomains, (String)"lookupDomains");
        this.inetAddressValidator = inetAddressValidator;
        this.fallbackDns = fallbackDns;
        this.lookupDomains = lookupDomains;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<InetAddress> lookup(@NotNull String hostname) {
        Collection collection;
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        String[] $this$mapNotNull$iv = this.lookupDomains;
        boolean $i$f$mapNotNull = false;
        String[] stringArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n2 = ((void)$this$forEach$iv$iv$iv).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            InetAddress it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i2];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            if (this.lookupForDomain((String)it, hostname) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            InetAddress it = (InetAddress)element$iv$iv;
            boolean bl = false;
            if (!this.inetAddressValidator.isValid(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection collection2 = (List)destination$iv$iv;
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = this.fallbackDns.lookup(hostname);
        } else {
            collection = collection2;
        }
        return (List)collection;
    }

    private final InetAddress lookupForDomain(String lookupDomain, String hostname) {
        MatchResult matchResult;
        Regex fullDomainMatcher = new Regex("^(?i)(10\\-(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])\\-(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])\\-(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])|172\\-(1[6-9]|2[0-9]|3[0-1])\\-(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])\\-(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])|192\\-168\\-(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])\\-(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])|127\\-0\\-0\\-1)\\.([a-z0-9]+\\.)?" + lookupDomain + '$');
        if (fullDomainMatcher.matches((CharSequence)hostname)) {
            MatchResult matchResult2;
            try {
                InetAddress inetAddress;
                String string;
                String string2;
                List list;
                matchResult2 = Regex.find$default((Regex)ipPartsMatcher, (CharSequence)hostname, (int)0, (int)2, null);
                if (matchResult2 != null && (list = matchResult2.getGroupValues()) != null && (string2 = (String)list.get(1)) != null && (string = StringsKt.replace$default((String)string2, (String)"-", (String)".", (boolean)false, (int)4, null)) != null) {
                    String it = string;
                    boolean bl = false;
                    inetAddress = InetAddress.getByName(it);
                } else {
                    inetAddress = null;
                }
                matchResult2 = inetAddress;
            }
            catch (UnknownHostException e2) {
                matchResult2 = null;
            }
            catch (SecurityException e3) {
                matchResult2 = null;
            }
            matchResult = matchResult2;
        } else {
            matchResult = null;
        }
        return matchResult;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/stripe/stripeterminal/internal/common/dns/InternetReaderDns$Companion;", "", "()V", "HASH_VALUE_PATTERN", "", "IP16B_BLOCK_PATTERN", "IP20B_BLOCK_PATTERN", "IP24B_BLOCK_PATTERN", "IP32B_BLOCK_PATTERN", "IP_OCTET_PATTERN", "IP_PARTS_PATTERN", "ipPartsMatcher", "Lkotlin/text/Regex;", "common_publish"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

