/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.makers;

import com.stripe.core.hardware.Reader;
import com.stripe.stripeterminal.external.models.DeviceType;
import com.stripe.stripeterminal.external.models.TerminalException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/stripe/stripeterminal/internal/common/makers/DeviceTypeMaker;", "", "()V", "Companion", "common_publish"})
public final class DeviceTypeMaker {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/stripe/stripeterminal/internal/common/makers/DeviceTypeMaker$Companion;", "", "()V", "fromSerial", "Lcom/stripe/stripeterminal/external/models/DeviceType;", "serialNumber", "", "fromUsbReader", "reader", "Lcom/stripe/core/hardware/Reader$UsbReader;", "common_publish"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DeviceType fromSerial(@NotNull String serialNumber) throws TerminalException {
            Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
            for (DeviceType type : DeviceType.values()) {
                for (String prefix : type.getSerialPrefixes()) {
                    if (!StringsKt.startsWith$default((String)serialNumber, (String)prefix, (boolean)false, (int)2, null)) continue;
                    return type;
                }
            }
            throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Serial number doesn't match any known device type", null, null, 12, null);
        }

        @NotNull
        public final DeviceType fromUsbReader(@NotNull Reader.UsbReader reader) {
            DeviceType deviceType;
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Reader.UsbReader usbReader = reader;
            if (usbReader instanceof Reader.UsbReader.Chipper2xReader) {
                deviceType = DeviceType.CHIPPER_2X;
            } else if (usbReader instanceof Reader.UsbReader.StripeM2Reader) {
                deviceType = DeviceType.STRIPE_M2;
            } else if (usbReader instanceof Reader.UsbReader.WisecubeReader) {
                deviceType = DeviceType.WISECUBE;
            } else if (usbReader instanceof Reader.UsbReader.Wisepad3Reader) {
                deviceType = DeviceType.WISEPAD_3;
            } else if (usbReader instanceof Reader.UsbReader.Wisepad3SReader) {
                deviceType = DeviceType.WISEPAD_3S;
            } else {
                if (usbReader instanceof Reader.UsbReader.UnspecifiedUsbReader) {
                    throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Reader doesn't match any known device type", null, null, 12, null);
                }
                throw new NoWhenBranchMatchedException();
            }
            return deviceType;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

