/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.makers;

import android.bluetooth.BluetoothDevice;
import android.hardware.usb.UsbDevice;
import com.stripe.core.hardware.Reader;
import com.stripe.jvmcore.hardware.status.ReaderInfo;
import com.stripe.proto.api.sdk.DiscoveredReader;
import com.stripe.proto.model.merchant.ApiLocationPb;
import com.stripe.proto.model.rest.ExpandedLocationReader;
import com.stripe.stripeterminal.external.models.DeviceType;
import com.stripe.stripeterminal.external.models.ExpandableLocation;
import com.stripe.stripeterminal.external.models.Location;
import com.stripe.stripeterminal.external.models.LocationStatus;
import com.stripe.stripeterminal.external.models.Reader;
import com.stripe.stripeterminal.internal.common.CotsDescriptor;
import com.stripe.stripeterminal.internal.common.json.DeviceTypeJsonAdapter;
import com.stripe.stripeterminal.internal.common.json.NetworkStatusJsonAdapter;
import com.stripe.stripeterminal.internal.common.proto.ProtoConverter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\u0014"}, d2={"Lcom/stripe/stripeterminal/internal/common/makers/ReaderMaker;", "", "()V", "fromCotsDescriptor", "Lcom/stripe/stripeterminal/external/models/Reader;", "cotsDescriptor", "Lcom/stripe/stripeterminal/internal/common/CotsDescriptor;", "fromDiscoveredReader", "discoveredReader", "Lcom/stripe/proto/api/sdk/DiscoveredReader;", "fromReaderInfoSimulated", "deviceType", "Lcom/stripe/stripeterminal/external/models/DeviceType;", "readerInfo", "Lcom/stripe/jvmcore/hardware/status/ReaderInfo;", "simulatedLocation", "Lcom/stripe/stripeterminal/external/models/Location;", "toHardwareReader", "Lcom/stripe/core/hardware/Reader;", "reader", "common_publish"})
@SourceDebugExtension(value={"SMAP\nReaderMaker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReaderMaker.kt\ncom/stripe/stripeterminal/internal/common/makers/ReaderMaker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
public final class ReaderMaker {
    @NotNull
    public static final ReaderMaker INSTANCE = new ReaderMaker();

    private ReaderMaker() {
    }

    @Nullable
    public final Reader fromDiscoveredReader(@NotNull DiscoveredReader discoveredReader) {
        Reader.NetworkStatus networkStatus;
        ExpandableLocation.Expanded expanded;
        String string;
        NetworkStatusJsonAdapter networkStatusJsonAdapter;
        ExpandedLocationReader expandedLocationReader;
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)((Object)discoveredReader), (String)"discoveredReader");
                ExpandedLocationReader expandedLocationReader2 = discoveredReader.expandedLocationReader;
                if (expandedLocationReader2 == null) {
                    return null;
                }
                expandedLocationReader = expandedLocationReader2;
                DeviceTypeJsonAdapter deviceTypeJsonAdapter = new DeviceTypeJsonAdapter();
                networkStatusJsonAdapter = new NetworkStatusJsonAdapter();
                string = expandedLocationReader.device_type;
                if (string == null) break block8;
                String p0 = string;
                boolean bl = false;
                DeviceType deviceType = deviceTypeJsonAdapter.fromJson(p0);
                string = deviceType;
                if (deviceType != null) break block9;
            }
            string = DeviceType.UNKNOWN;
        }
        String deviceType = string;
        ApiLocationPb apiLocationPb = expandedLocationReader.location;
        if (apiLocationPb != null) {
            ApiLocationPb apiLocation = apiLocationPb;
            boolean bl = false;
            expanded = new ExpandableLocation.Expanded(ProtoConverter.INSTANCE.toSdkLocation(apiLocation));
        } else {
            expanded = null;
        }
        ExpandableLocation.Expanded location = expanded;
        LocationStatus locationStatus = location != null ? LocationStatus.SET : LocationStatus.NOT_SET;
        String string2 = expandedLocationReader.id;
        String string3 = expandedLocationReader.status;
        if (string3 != null) {
            String p0 = string3;
            boolean bl = false;
            networkStatus = networkStatusJsonAdapter.fromJson(p0);
        } else {
            networkStatus = null;
        }
        Reader.NetworkStatus networkStatus2 = networkStatus;
        String string4 = expandedLocationReader.serial_number;
        String string5 = expandedLocationReader.label;
        String string6 = expandedLocationReader.device_sw_version;
        String string7 = expandedLocationReader.base_url;
        String string8 = expandedLocationReader.ip_address;
        Boolean bl = expandedLocationReader.livemode;
        com.stripe.proto.api.sdk.ReaderInfo readerInfo = discoveredReader.readerInfo;
        ReaderInfo readerInfo2 = readerInfo != null ? ProtoConverter.INSTANCE.toSdkReaderInfo(readerInfo) : null;
        return new Reader((DeviceType)deviceType, (ExpandableLocation)location, locationStatus, string2, readerInfo2, false, networkStatus2, string4, string5, string6, string7, string8, bl, null, null, null, null, 122912, null);
    }

    @NotNull
    public final Reader fromCotsDescriptor(@NotNull CotsDescriptor cotsDescriptor) {
        Intrinsics.checkNotNullParameter((Object)cotsDescriptor, (String)"cotsDescriptor");
        DeviceType deviceType = DeviceType.COTS_DEVICE;
        String string = cotsDescriptor.getCotsUuid();
        boolean bl = cotsDescriptor.isSimulated();
        return new Reader(deviceType, null, null, null, null, bl, null, string, null, null, null, null, null, null, null, null, null, 130902, null);
    }

    @NotNull
    public final Reader fromReaderInfoSimulated(@NotNull DeviceType deviceType, @NotNull ReaderInfo readerInfo) {
        Intrinsics.checkNotNullParameter((Object)deviceType, (String)"deviceType");
        Intrinsics.checkNotNullParameter((Object)readerInfo, (String)"readerInfo");
        return new Reader(deviceType, null, null, null, readerInfo, true, null, null, null, null, null, null, null, null, null, null, this.simulatedLocation(), 65478, null);
    }

    @NotNull
    public final Location simulatedLocation() {
        return new Location("tml_simulated", null, "Simulated Location", Boolean.valueOf(false), null, 18, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final com.stripe.core.hardware.Reader toHardwareReader(@Nullable Reader reader) {
        com.stripe.core.hardware.Reader reader2;
        Object object = reader;
        if (object != null && (object = object.getBluetoothDevice()) != null) {
            Reader it = object;
            boolean bl = false;
            Reader.BluetoothReader bluetoothReader = Reader.BluetoothReader.Companion.fromBluetoothDevice((BluetoothDevice)it);
            object = bluetoothReader;
            if (bluetoothReader != null) {
                reader2 = (com.stripe.core.hardware.Reader)object;
                return reader2;
            }
        }
        ReaderMaker it = this;
        boolean bl = false;
        Reader reader3 = reader;
        Reader.UsbReader usbReader = Reader.UsbReader.Companion.fromUsbDevice((UsbDevice)(reader3 != null ? reader3.getUsbDevice() : null));
        if (usbReader != null) {
            reader2 = usbReader;
            return reader2;
        }
        reader2 = Reader.SerialReader.INSTANCE;
        return reader2;
    }
}

