/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.makers;

import com.stripe.core.hardware.updates.ReaderUpdateException;
import com.stripe.stripeterminal.external.models.TerminalException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/stripe/stripeterminal/internal/common/makers/TerminalExceptionMaker;", "", "()V", "Companion", "common_publish"})
public final class TerminalExceptionMaker {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stripe/stripeterminal/internal/common/makers/TerminalExceptionMaker$Companion;", "", "()V", "fromReaderUpdateException", "Lcom/stripe/stripeterminal/external/models/TerminalException;", "exception", "Lcom/stripe/core/hardware/updates/ReaderUpdateException;", "common_publish"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TerminalException fromReaderUpdateException(@NotNull ReaderUpdateException exception) {
            TerminalException terminalException;
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            ReaderUpdateException readerUpdateException = exception;
            if (readerUpdateException instanceof ReaderUpdateException.UpdateFailed) {
                terminalException = new TerminalException(TerminalException.TerminalErrorCode.READER_SOFTWARE_UPDATE_FAILED, "Update failed due to configuration error", (Throwable)exception, null, 8, null);
            } else if (readerUpdateException instanceof ReaderUpdateException.UpdateFailedBatteryLow) {
                terminalException = new TerminalException(TerminalException.TerminalErrorCode.READER_SOFTWARE_UPDATE_FAILED_BATTERY_LOW, "Update failed due to low battery", (Throwable)exception, null, 8, null);
            } else if (readerUpdateException instanceof ReaderUpdateException.UpdateFailedInterrupted) {
                terminalException = new TerminalException(TerminalException.TerminalErrorCode.READER_SOFTWARE_UPDATE_FAILED_INTERRUPTED, "Update failed due to being interrupted", (Throwable)exception, null, 8, null);
            } else if (readerUpdateException instanceof ReaderUpdateException.UpdateFailedReaderError) {
                terminalException = new TerminalException(TerminalException.TerminalErrorCode.READER_SOFTWARE_UPDATE_FAILED_READER_ERROR, "Update failed since there is no connected reader", (Throwable)exception, null, 8, null);
            } else if (readerUpdateException instanceof ReaderUpdateException.UpdateFailedServerError) {
                terminalException = new TerminalException(TerminalException.TerminalErrorCode.READER_SOFTWARE_UPDATE_FAILED_SERVER_ERROR, "Update failed due to lack of internet connection", (Throwable)exception, null, 8, null);
            } else if (readerUpdateException instanceof ReaderUpdateException.UnexpectedError) {
                terminalException = new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Unexpected SDK error", (Throwable)exception, null, 8, null);
            } else if (readerUpdateException instanceof ReaderUpdateException.Canceled) {
                terminalException = new TerminalException(TerminalException.TerminalErrorCode.CANCELED, "Update canceled", (Throwable)exception, null, 8, null);
            } else if (readerUpdateException instanceof ReaderUpdateException.NotConnectedToReader) {
                terminalException = new TerminalException(TerminalException.TerminalErrorCode.NOT_CONNECTED_TO_READER, "Not connected to reader", (Throwable)exception, null, 8, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return terminalException;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

