/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.remotereadercontrollers;

import androidx.annotation.VisibleForTesting;
import com.stripe.jvmcore.crpcclient.CrpcResponse;
import com.stripe.jvmcore.crpcclient.CrpcServiceResolver;
import com.stripe.jvmcore.currency.Amount;
import com.stripe.jvmcore.featureflag.FeatureFlagsRepository;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.transaction.OfflineDetails;
import com.stripe.proto.api.sdk.ActivateTerminalResponse;
import com.stripe.proto.api.sdk.CancelCollectInputsRequest;
import com.stripe.proto.api.sdk.CancelCollectPaymentMethodRequest;
import com.stripe.proto.api.sdk.CancelCollectPaymentMethodResponse;
import com.stripe.proto.api.sdk.CancelPaymentIntentResponse;
import com.stripe.proto.api.sdk.CancelSetupIntentPaymentMethodRequest;
import com.stripe.proto.api.sdk.CancelSetupIntentPaymentMethodResponse;
import com.stripe.proto.api.sdk.CancelSetupIntentResponse;
import com.stripe.proto.api.sdk.ClearReaderDisplayResponse;
import com.stripe.proto.api.sdk.ConfirmInteracRefundResponse;
import com.stripe.proto.api.sdk.ConfirmPaymentRequest;
import com.stripe.proto.api.sdk.ConfirmSetupIntentResponse;
import com.stripe.proto.api.sdk.CreatePaymentIntentOptions;
import com.stripe.proto.api.sdk.CreatePaymentIntentRequest;
import com.stripe.proto.api.sdk.CreatePaymentIntentResponse;
import com.stripe.proto.api.sdk.CreateSetupIntentRequest;
import com.stripe.proto.api.sdk.CreateSetupIntentResponse;
import com.stripe.proto.api.sdk.JackRabbitApi;
import com.stripe.proto.api.sdk.OfflinePaymentDetails;
import com.stripe.proto.api.sdk.QueryCollectInputsRequest;
import com.stripe.proto.api.sdk.SetReaderDisplayResponse;
import com.stripe.proto.model.rest.ErrorWrapper;
import com.stripe.proto.model.rest.PaymentMethodOptions;
import com.stripe.proto.model.rest.SetupIntent;
import com.stripe.proto.model.sdk.PaymentMethod;
import com.stripe.stripeterminal.external.InternalApi;
import com.stripe.stripeterminal.external.OfflineMode;
import com.stripe.stripeterminal.external.models.Cart;
import com.stripe.stripeterminal.external.models.CollectInputsParameters;
import com.stripe.stripeterminal.external.models.ConnectionConfiguration;
import com.stripe.stripeterminal.external.models.CreateConfiguration;
import com.stripe.stripeterminal.external.models.OfflineBehavior;
import com.stripe.stripeterminal.external.models.OfflineBehaviorKtxKt;
import com.stripe.stripeterminal.external.models.PaymentIntent;
import com.stripe.stripeterminal.external.models.PaymentIntentParameters;
import com.stripe.stripeterminal.external.models.Reader;
import com.stripe.stripeterminal.external.models.Refund;
import com.stripe.stripeterminal.external.models.RefundParameters;
import com.stripe.stripeterminal.external.models.SetupIntentCancellationParameters;
import com.stripe.stripeterminal.external.models.SetupIntentParameters;
import com.stripe.stripeterminal.external.models.TerminalException;
import com.stripe.stripeterminal.internal.common.TerminalStatusManager;
import com.stripe.stripeterminal.internal.common.adapter.OfflineAdapterKt;
import com.stripe.stripeterminal.internal.common.api.ApiClient;
import com.stripe.stripeterminal.internal.common.api.JackRabbitApiRequestFactory;
import com.stripe.stripeterminal.internal.common.crpc.RemoteReaderRequestContextProvider;
import com.stripe.stripeterminal.internal.common.extensions.ConfirmInteracRefundResponseExtensions;
import com.stripe.stripeterminal.internal.common.extensions.ConfirmPaymentResponseExtensions;
import com.stripe.stripeterminal.internal.common.extensions.ConfirmSetupIntentResponseExtensions;
import com.stripe.stripeterminal.internal.common.extensions.OfflineDetailsExtensionsKt;
import com.stripe.stripeterminal.internal.common.forms.CollectInputsResult;
import com.stripe.stripeterminal.internal.common.makers.CreateSetupIntentRequestMaker;
import com.stripe.stripeterminal.internal.common.proto.ProtoConverter;
import com.stripe.stripeterminal.internal.common.remotereadercontrollers.CollectPaymentJob;
import com.stripe.stripeterminal.internal.common.remotereadercontrollers.CollectRefundPaymentJob;
import com.stripe.stripeterminal.internal.common.remotereadercontrollers.CollectSetupIntentPaymentJob;
import com.stripe.stripeterminal.internal.common.remotereadercontrollers.CrpcResponseExtensions;
import com.stripe.stripeterminal.internal.common.remotereadercontrollers.IpReaderController;
import com.stripe.stripeterminal.internal.common.remotereadercontrollers.ReaderActivator;
import com.stripe.stripeterminal.internal.common.remotereadercontrollers.RemoteReaderController;
import com.stripe.stripeterminal.internal.common.remotereadercontrollers.ResumePaymentJob;
import com.stripe.stripeterminal.internal.models.PaymentMethodData;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u007f2\u00020\u0001:\u0001\u007fBK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\u0012\u0010$\u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\u001a\u0010%\u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020!H\u0016J\b\u0010)\u001a\u00020!H\u0016J\b\u0010*\u001a\u00020!H\u0016J\b\u0010+\u001a\u00020!H\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0016J$\u0010/\u001a\u00020!2\u001a\u00100\u001a\u0016\u0012\u0004\u0012\u000202\u0012\f\u0012\n\u0012\u0004\u0012\u000204\u0018\u00010301H\u0002J\u0018\u00105\u001a\u0002062\u0006\u00107\u001a\u0002062\u0006\u00108\u001a\u000209H\u0016J$\u0010:\u001a\u00020!2\u001a\u00100\u001a\u0016\u0012\u0004\u0012\u00020;\u0012\f\u0012\n\u0012\u0004\u0012\u00020<\u0018\u00010301H\u0002J\b\u0010=\u001a\u00020!H\u0016J\u0010\u0010>\u001a\u00020\u00182\u0006\u0010?\u001a\u00020@H\u0017J\u001b\u0010A\u001a\u00020\u00182\u0006\u0010?\u001a\u00020@H\u0081@\u00f8\u0001\u0000\u00a2\u0006\u0004\bB\u0010CJ \u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\u001eH\u0016J\u0010\u0010K\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0016J\u0010\u0010L\u001a\u0002062\u0006\u0010M\u001a\u000206H\u0016J\u001e\u0010N\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020!0PH\u0016J\u0010\u0010Q\u001a\u0002062\u0006\u0010R\u001a\u00020SH\u0016J\b\u0010T\u001a\u00020!H\u0016J \u0010U\u001a\b\u0012\u0004\u0012\u00020#0V2\u0006\u0010W\u001a\u00020\u001e2\b\u0010X\u001a\u0004\u0018\u00010\u001eH\u0016J\b\u0010Y\u001a\u00020!H\u0016J\u001e\u0010Z\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020!0PH\u0002J\b\u0010[\u001a\u00020\\H\u0002J \u0010]\u001a\u00020^2\u0006\u0010\"\u001a\u00020#2\u0006\u0010W\u001a\u00020\u001e2\u0006\u0010_\u001a\u00020`H\u0014J\u0018\u0010a\u001a\u00020-2\u0006\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020eH\u0015JB\u0010f\u001a\u00020!2\u0006\u0010g\u001a\u00020\u001e2\b\u0010h\u001a\u0004\u0018\u00010i2\u0012\u0010j\u001a\u000e\u0012\u0004\u0012\u00020k\u0012\u0004\u0012\u00020!012\u0012\u0010l\u001a\u000e\u0012\u0004\u0012\u00020\\\u0012\u0004\u0012\u00020!01H\u0016J\u0010\u0010m\u001a\u00020!2\u0006\u0010n\u001a\u00020oH\u0016J@\u0010p\u001a\u00020!2\u0006\u0010q\u001a\u00020r2\u0006\u0010s\u001a\u00020\u001e2\u0012\u0010j\u001a\u000e\u0012\u0004\u0012\u00020k\u0012\u0004\u0012\u00020!012\u0012\u0010l\u001a\u000e\u0012\u0004\u0012\u00020\\\u0012\u0004\u0012\u00020!01H\u0016J\u0088\u0001\u0010t\u001a\u00020!2\u0006\u0010q\u001a\u00020r2\u0012\u0010j\u001a\u000e\u0012\u0004\u0012\u00020k\u0012\u0004\u0012\u00020!012\u0012\u0010l\u001a\u000e\u0012\u0004\u0012\u00020\\\u0012\u0004\u0012\u00020!012\u0006\u0010u\u001a\u00020v2\u0006\u0010w\u001a\u00020v2\u0006\u0010x\u001a\u00020v2\b\u0010g\u001a\u0004\u0018\u00010\u001e2\b\u0010y\u001a\u0004\u0018\u00010r2\u000e\u0010z\u001a\n\u0012\u0004\u0012\u00020{\u0018\u00010V2\b\u0010|\u001a\u0004\u0018\u00010\u001e2\b\u0010h\u001a\u0004\u0018\u00010iH\u0016J8\u0010}\u001a\u00020!2\u0006\u0010g\u001a\u00020\u001e2\u0012\u0010j\u001a\u000e\u0012\u0004\u0012\u00020k\u0012\u0004\u0012\u00020!012\u0012\u0010l\u001a\u000e\u0012\u0004\u0012\u00020\\\u0012\u0004\u0012\u00020!01H\u0016J\b\u0010~\u001a\u00020!H\u0002R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0080\u0001"}, d2={"Lcom/stripe/stripeterminal/internal/common/remotereadercontrollers/IpReaderController;", "Lcom/stripe/stripeterminal/internal/common/remotereadercontrollers/RemoteReaderController;", "apiClient", "Lcom/stripe/stripeterminal/internal/common/api/ApiClient;", "jackrabbitApiResolver", "Lcom/stripe/jvmcore/crpcclient/CrpcServiceResolver;", "Lcom/stripe/proto/api/sdk/JackRabbitApi;", "requestContextProvider", "Lcom/stripe/stripeterminal/internal/common/crpc/RemoteReaderRequestContextProvider;", "apiRequestFactory", "Lcom/stripe/stripeterminal/internal/common/api/JackRabbitApiRequestFactory;", "featureFlagsRepository", "Lcom/stripe/jvmcore/featureflag/FeatureFlagsRepository;", "ioCoroutineDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "terminalStatusManager", "Lcom/stripe/stripeterminal/internal/common/TerminalStatusManager;", "readerActivator", "Lcom/stripe/stripeterminal/internal/common/remotereadercontrollers/ReaderActivator;", "(Lcom/stripe/stripeterminal/internal/common/api/ApiClient;Lcom/stripe/jvmcore/crpcclient/CrpcServiceResolver;Lcom/stripe/stripeterminal/internal/common/crpc/RemoteReaderRequestContextProvider;Lcom/stripe/stripeterminal/internal/common/api/JackRabbitApiRequestFactory;Lcom/stripe/jvmcore/featureflag/FeatureFlagsRepository;Lkotlinx/coroutines/CoroutineDispatcher;Lcom/stripe/stripeterminal/internal/common/TerminalStatusManager;Lcom/stripe/stripeterminal/internal/common/remotereadercontrollers/ReaderActivator;)V", "activateJob", "Lkotlinx/coroutines/Job;", "collectInputsJob", "Lkotlinx/coroutines/Deferred;", "Lcom/stripe/stripeterminal/internal/common/forms/CollectInputsResult;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "heartbeatJob", "jackrabbitApiClient", "lastReaderConfigHash", "", "paymentCollectionJob", "assertClientSideCancellationIsSupported", "", "reader", "Lcom/stripe/stripeterminal/external/models/Reader;", "assertClientSideCreationIsSupported", "assertReaderVersionAtLeast", "minVersion", "", "cancelCollectInputs", "cancelCollectInteracRefundMethod", "cancelCollectPaymentMethod", "cancelCollectSetupIntentPaymentMethod", "cancelPaymentIntent", "Lcom/stripe/stripeterminal/external/models/PaymentIntent;", "paymentIntent", "cancelPaymentMethodCollect", "cancelFun", "Lkotlin/Function1;", "Lcom/stripe/proto/api/sdk/CancelCollectPaymentMethodRequest;", "Lcom/stripe/jvmcore/crpcclient/CrpcResponse;", "Lcom/stripe/proto/api/sdk/CancelCollectPaymentMethodResponse;", "cancelSetupIntent", "Lcom/stripe/stripeterminal/external/models/SetupIntent;", "intent", "params", "Lcom/stripe/stripeterminal/external/models/SetupIntentCancellationParameters;", "cancelSetupIntentPaymentCollect", "Lcom/stripe/proto/api/sdk/CancelSetupIntentPaymentMethodRequest;", "Lcom/stripe/proto/api/sdk/CancelSetupIntentPaymentMethodResponse;", "clearReaderDisplay", "collectInputs", "collectInputsParameters", "Lcom/stripe/stripeterminal/external/models/CollectInputsParameters;", "collectInputsSuspendUntilComplete", "collectInputsSuspendUntilComplete$common_publish", "(Lcom/stripe/stripeterminal/external/models/CollectInputsParameters;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "confirmInteracRefund", "Lcom/stripe/stripeterminal/external/models/Refund;", "refundParams", "Lcom/stripe/stripeterminal/external/models/RefundParameters;", "paymentMethod", "Lcom/stripe/proto/model/sdk/PaymentMethod;", "reason", "confirmPayment", "confirmSetupIntent", "setupIntent", "connectReader", "disconnectCallback", "Lkotlin/Function0;", "createSetupIntent", "setupIntentParameters", "Lcom/stripe/stripeterminal/external/models/SetupIntentParameters;", "disconnectReader", "discoverReaders", "", "connectionToken", "location", "finishConfirmPayment", "maintainConnectivity", "noActiveReaderException", "Lcom/stripe/stripeterminal/external/models/TerminalException;", "onActivateReader", "Lcom/stripe/proto/api/sdk/ActivateTerminalResponse;", "connectionConfiguration", "Lcom/stripe/stripeterminal/external/models/ConnectionConfiguration;", "onCreatePaymentIntent", "paymentIntentParameters", "Lcom/stripe/stripeterminal/external/models/PaymentIntentParameters;", "createConfiguration", "Lcom/stripe/stripeterminal/external/models/CreateConfiguration;", "resumeCollectPaymentMethod", "intentId", "offlineDetails", "Lcom/stripe/jvmcore/transaction/OfflineDetails;", "onPaymentCollected", "Lcom/stripe/stripeterminal/internal/models/PaymentMethodData;", "onFailure", "setReaderDisplay", "cart", "Lcom/stripe/stripeterminal/external/models/Cart;", "startInteracRefund", "amount", "Lcom/stripe/jvmcore/currency/Amount;", "chargeId", "startPaymentCollection", "skipTipping", "", "manualEntry", "updatePaymentIntent", "tipEligibleAmount", "computedPriorities", "Lcom/stripe/proto/model/rest/PaymentMethodOptions$RoutingPriority;", "stripeAccountId", "startSetupIntentPaymentCollection", "tearDownConnection", "Companion", "common_publish"})
@SourceDebugExtension(value={"SMAP\nIpReaderController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IpReaderController.kt\ncom/stripe/stripeterminal/internal/common/remotereadercontrollers/IpReaderController\n+ 2 Log.kt\ncom/stripe/jvmcore/logging/terminal/log/Log$Companion\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,602:1\n193#2:603\n1#3:604\n*S KotlinDebug\n*F\n+ 1 IpReaderController.kt\ncom/stripe/stripeterminal/internal/common/remotereadercontrollers/IpReaderController\n*L\n89#1:603\n*E\n"})
public final class IpReaderController
extends RemoteReaderController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ApiClient apiClient;
    @NotNull
    private final CrpcServiceResolver<JackRabbitApi> jackrabbitApiResolver;
    @NotNull
    private final RemoteReaderRequestContextProvider requestContextProvider;
    @NotNull
    private final JackRabbitApiRequestFactory apiRequestFactory;
    @NotNull
    private final FeatureFlagsRepository featureFlagsRepository;
    @NotNull
    private final CoroutineDispatcher ioCoroutineDispatcher;
    @NotNull
    private final TerminalStatusManager terminalStatusManager;
    @NotNull
    private final ReaderActivator readerActivator;
    @Nullable
    private JackRabbitApi jackrabbitApiClient;
    @NotNull
    private CoroutineScope coroutineScope;
    @Nullable
    private Job heartbeatJob;
    @Nullable
    private Job paymentCollectionJob;
    @Nullable
    private Deferred<? extends CollectInputsResult> collectInputsJob;
    @Nullable
    private Job activateJob;
    @Nullable
    private String lastReaderConfigHash;
    private static final int MAX_CONNECTION_FAILURES = 2;
    public static final long HEARTBEAT_INTERVAL_MS = 15000L;
    public static final long HEARTBEAT_RECOVERY_INTERVAL_MS = 3000L;
    private static final long MINIMUM_CLIENT_SIDE_CREATE_SW_VERSION = 2100100L;
    private static final long MINIMUM_CLIENT_SIDE_CANCEL_SW_VERSION = 2110024L;

    public IpReaderController(@NotNull ApiClient apiClient, @NotNull CrpcServiceResolver<JackRabbitApi> jackrabbitApiResolver, @NotNull RemoteReaderRequestContextProvider requestContextProvider, @NotNull JackRabbitApiRequestFactory apiRequestFactory, @NotNull FeatureFlagsRepository featureFlagsRepository, @NotNull CoroutineDispatcher ioCoroutineDispatcher, @NotNull TerminalStatusManager terminalStatusManager, @NotNull ReaderActivator readerActivator) {
        Intrinsics.checkNotNullParameter((Object)apiClient, (String)"apiClient");
        Intrinsics.checkNotNullParameter(jackrabbitApiResolver, (String)"jackrabbitApiResolver");
        Intrinsics.checkNotNullParameter((Object)requestContextProvider, (String)"requestContextProvider");
        Intrinsics.checkNotNullParameter((Object)apiRequestFactory, (String)"apiRequestFactory");
        Intrinsics.checkNotNullParameter((Object)featureFlagsRepository, (String)"featureFlagsRepository");
        Intrinsics.checkNotNullParameter((Object)ioCoroutineDispatcher, (String)"ioCoroutineDispatcher");
        Intrinsics.checkNotNullParameter((Object)terminalStatusManager, (String)"terminalStatusManager");
        Intrinsics.checkNotNullParameter((Object)readerActivator, (String)"readerActivator");
        Log.Companion this_$iv = Log.Companion;
        boolean $i$f$getLogger = false;
        super(this_$iv.getLogger(IpReaderController.class));
        this.apiClient = apiClient;
        this.jackrabbitApiResolver = jackrabbitApiResolver;
        this.requestContextProvider = requestContextProvider;
        this.apiRequestFactory = apiRequestFactory;
        this.featureFlagsRepository = featureFlagsRepository;
        this.ioCoroutineDispatcher = ioCoroutineDispatcher;
        this.terminalStatusManager = terminalStatusManager;
        this.readerActivator = readerActivator;
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)this.ioCoroutineDispatcher));
    }

    @Override
    public void connectReader(@NotNull Reader reader, @NotNull Function0<Unit> disconnectCallback) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter(disconnectCallback, (String)"disconnectCallback");
        this.heartbeatJob = this.maintainConnectivity(reader, disconnectCallback);
    }

    @Override
    public void disconnectReader() {
        this.tearDownConnection();
    }

    private final void tearDownConnection() {
        Job job = this.heartbeatJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.heartbeatJob = null;
        Job job2 = this.paymentCollectionJob;
        if (job2 != null) {
            Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
        }
        this.paymentCollectionJob = null;
        Deferred<? extends CollectInputsResult> deferred = this.collectInputsJob;
        if (deferred != null) {
            Job.DefaultImpls.cancel$default((Job)((Job)deferred), null, (int)1, null);
        }
        this.collectInputsJob = null;
        Job job3 = this.activateJob;
        if (job3 != null) {
            Job.DefaultImpls.cancel$default((Job)job3, null, (int)1, null);
        }
        this.activateJob = null;
        this.jackrabbitApiClient = null;
    }

    @Override
    @NotNull
    public List<Reader> discoverReaders(@NotNull String connectionToken, @Nullable String location) {
        Intrinsics.checkNotNullParameter((Object)connectionToken, (String)"connectionToken");
        return ApiClient.listAllReaders$default(this.apiClient, connectionToken, null, location, 2, null).getReaderList();
    }

    @Override
    public void setReaderDisplay(@NotNull Cart cart) {
        Intrinsics.checkNotNullParameter((Object)cart, (String)"cart");
        JackRabbitApi jackRabbitApi = this.jackrabbitApiClient;
        CrpcResponse<SetReaderDisplayResponse> response = jackRabbitApi != null ? jackRabbitApi.setReaderDisplay(this.apiRequestFactory.setReaderDisplay(cart)) : null;
        CrpcResponseExtensions.INSTANCE.withJackrabbitResponse(response);
    }

    @Override
    @InternalApi
    @NotNull
    public CollectInputsResult collectInputs(@NotNull CollectInputsParameters collectInputsParameters) {
        Intrinsics.checkNotNullParameter((Object)collectInputsParameters, (String)"collectInputsParameters");
        return (CollectInputsResult)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super CollectInputsResult>, Object>(this, collectInputsParameters, null){
            int label;
            final /* synthetic */ IpReaderController this$0;
            final /* synthetic */ CollectInputsParameters $collectInputsParameters;
            {
                this.this$0 = $receiver;
                this.$collectInputsParameters = $collectInputsParameters;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.collectInputsSuspendUntilComplete$common_publish(this.$collectInputsParameters, (Continuation<? super CollectInputsResult>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super CollectInputsResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    /*
     * Unable to fully structure code
     */
    @InternalApi
    @VisibleForTesting
    @Nullable
    public final Object collectInputsSuspendUntilComplete$common_publish(@NotNull CollectInputsParameters var1_1, @NotNull Continuation<? super CollectInputsResult> var2_2) {
        if (!(var2_2 instanceof collectInputsSuspendUntilComplete.1)) ** GOTO lbl-1000
        var6_3 = var2_2;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ IpReaderController this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.collectInputsSuspendUntilComplete$common_publish(null, (Continuation<? super CollectInputsResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.jackrabbitApiClient;
                if (v0 != null) {
                    it = v0;
                    $i$a$-let-IpReaderController$collectInputsSuspendUntilComplete$2 = false;
                    this.collectInputsJob = BuildersKt.async$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super CollectInputsResult>, Object>(it, this, (CollectInputsParameters)collectInputsParameters, null){
                        Object L$1;
                        int label;
                        private /* synthetic */ Object L$0;
                        final /* synthetic */ JackRabbitApi $it;
                        final /* synthetic */ IpReaderController this$0;
                        final /* synthetic */ CollectInputsParameters $collectInputsParameters;
                        {
                            this.$it = $it;
                            this.this$0 = $receiver;
                            this.$collectInputsParameters = $collectInputsParameters;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         * Enabled aggressive block sorting
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object var1_1) {
                            var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            block0 : switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    $this$async = (CoroutineScope)this.L$0;
                                    crpcResponse = this.$it.collectInputs(IpReaderController.access$getApiRequestFactory$p(this.this$0).collectInputs(this.$collectInputsParameters));
                                    CrpcResponseExtensions.INSTANCE.withJackrabbitResponse(crpcResponse);
                                    break;
                                }
                                case 1: {
                                    $i$a$-let-IpReaderController$collectInputsSuspendUntilComplete$2$1$1 = false;
                                    var7_8 = (IpReaderController)this.L$1;
                                    $this$async = (CoroutineScope)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
                                    while (true) {
                                        var7_8.getLogger().i("code after delay", new Pair[0]);
                                        break block0;
                                        break;
                                    }
                                }
                                default: {
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }
                            }
                            while (CoroutineScopeKt.isActive((CoroutineScope)$this$async)) {
                                queryCollectInputsRequest = new QueryCollectInputsRequest(null, 1, null);
                                queryResponse = this.$it.queryCollectInputs(queryCollectInputsRequest);
                                var6_7 = CrpcResponseExtensions.INSTANCE.withJackrabbitResponse(queryResponse);
                                var7_8 = this.this$0;
                                queryCollectInputsResponse = var6_7;
                                $i$a$-let-IpReaderController$collectInputsSuspendUntilComplete$2$1$1 = false;
                                var7_8.getLogger().i("QueryCollectInputsResponseType: " + (Object)queryCollectInputsResponse.response_type, new Pair[0]);
                                switch (collectInputsSuspendUntilComplete.2.WhenMappings.$EnumSwitchMapping$0[queryCollectInputsResponse.response_type.ordinal()]) {
                                    case 1: {
                                        var7_8.getLogger().i(String.valueOf(IpReaderController.access$getCoroutineScope$p(var7_8).getCoroutineContext()), new Pair[0]);
                                        this.L$0 = $this$async;
                                        this.L$1 = var7_8;
                                        this.label = 1;
                                        if ((v0 = DelayKt.delay((long)2000L, (Continuation)this)) != var10_2) ** continue;
                                        return var10_2;
                                    }
                                    case 2: 
                                    case 3: 
                                    case 4: {
                                        return new CollectInputsResult.Failure.ApplicationError("application error");
                                    }
                                    case 5: {
                                        return CollectInputsResult.Failure.Timeout.INSTANCE;
                                    }
                                    case 6: {
                                        return CollectInputsResult.Failure.MerchantCancelled.INSTANCE;
                                    }
                                    case 7: {
                                        var7_8.getLogger().i("collect inputs successfully completed " + (Object)queryCollectInputsResponse.successfully_completed, new Pair[0]);
                                        v1 = queryCollectInputsResponse.successfully_completed;
                                        Intrinsics.checkNotNull((Object)v1);
                                        return new CollectInputsResult.Success(v1);
                                    }
                                }
                            }
                            return new CollectInputsResult.Failure.ApplicationError("application error");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            Function2<CoroutineScope, Continuation<? super CollectInputsResult>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                            function2.L$0 = value;
                            return (Continuation)function2;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super CollectInputsResult> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                    v1 = Unit.INSTANCE;
                } else {
                    v1 = null;
                }
                if (v1 == null) {
                    throw this.noActiveReaderException();
                }
                v2 = this.collectInputsJob;
                if (v2 == null) ** GOTO lbl35
                $continuation.label = 1;
                v3 = v2.await((Continuation)$continuation);
                if (v3 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl34
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl34:
                // 2 sources

                if ((v2 = (Deferred<? extends CollectInputsResult>)v3) != null) ** GOTO lbl36
lbl35:
                // 2 sources

                v2 = new CollectInputsResult.Failure.ApplicationError("application error");
lbl36:
                // 2 sources

                return v2;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public void cancelCollectInputs() {
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ IpReaderController this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        JackRabbitApi jackRabbitApi = IpReaderController.access$getJackrabbitApiClient$p(this.this$0);
                        if (jackRabbitApi != null) {
                            jackRabbitApi.cancelCollectInputs(new CancelCollectInputsRequest(null, 1, null));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    @NotNull
    protected ActivateTerminalResponse onActivateReader(@NotNull Reader reader, @NotNull String connectionToken, @NotNull ConnectionConfiguration connectionConfiguration) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)connectionToken, (String)"connectionToken");
        Intrinsics.checkNotNullParameter((Object)connectionConfiguration, (String)"connectionConfiguration");
        this.jackrabbitApiClient = this.jackrabbitApiResolver.resolve(reader.getIpAddress(), reader.getBaseUrl());
        Object object = this.jackrabbitApiClient;
        if (object == null || (object = ((JackRabbitApi)object).activateTerminal(this.apiRequestFactory.activateTerminal(connectionToken, connectionConfiguration.getFailIfInUse()))) == null) {
            throw this.noActiveReaderException();
        }
        Object response = object;
        Object t2 = CrpcResponseExtensions.INSTANCE.withJackrabbitResponse(response);
        ActivateTerminalResponse it = (ActivateTerminalResponse)((Object)t2);
        boolean bl = false;
        this.requestContextProvider.setToken(it.session_token);
        return (ActivateTerminalResponse)((Object)t2);
    }

    @Override
    @OfflineMode
    @NotNull
    protected PaymentIntent onCreatePaymentIntent(@NotNull PaymentIntentParameters paymentIntentParameters, @NotNull CreateConfiguration createConfiguration) {
        Intrinsics.checkNotNullParameter((Object)paymentIntentParameters, (String)"paymentIntentParameters");
        Intrinsics.checkNotNullParameter((Object)createConfiguration, (String)"createConfiguration");
        this.assertClientSideCreationIsSupported(this.terminalStatusManager.getConnectedReader());
        CreatePaymentIntentRequest createPaymentIntentSdkRequest = this.apiRequestFactory.createPaymentIntent(paymentIntentParameters, createConfiguration);
        JackRabbitApi jackRabbitApi = this.jackrabbitApiClient;
        CrpcResponse<CreatePaymentIntentResponse> response = jackRabbitApi != null ? jackRabbitApi.createPaymentIntent(createPaymentIntentSdkRequest) : null;
        CreatePaymentIntentResponse createPaymentIntentResponse = CrpcResponseExtensions.INSTANCE.withJackrabbitResponse(response);
        boolean bl = false;
        com.stripe.proto.model.rest.PaymentIntent paymentIntent2 = createPaymentIntentResponse.payment_intent;
        if (paymentIntent2 != null && (paymentIntent2 = ProtoConverter.INSTANCE.toSdkPaymentIntent(paymentIntent2)) != null) {
            com.stripe.proto.model.rest.PaymentIntent paymentIntent3;
            com.stripe.proto.model.rest.PaymentIntent it = paymentIntent2;
            boolean bl2 = false;
            com.stripe.proto.model.rest.PaymentIntent $this$onCreatePaymentIntent_u24lambda_u245_u24lambda_u243_u24lambda_u242 = paymentIntent3 = it;
            boolean bl3 = false;
            Object object = createPaymentIntentResponse.options;
            if (object == null || (object = object.offline_behavior) == null || (object = OfflineBehaviorKtxKt.toOfflineBehavior((CreatePaymentIntentOptions.OfflineBehavior)((Object)object))) == null) {
                object = OfflineBehavior.REQUIRE_ONLINE;
            }
            OfflineAdapterKt.setOfflineBehavior((PaymentIntent)$this$onCreatePaymentIntent_u24lambda_u245_u24lambda_u243_u24lambda_u242, (OfflineBehavior)object);
            OfflinePaymentDetails offlinePaymentDetails = createPaymentIntentResponse.offline_details;
            OfflineAdapterKt.setOfflineDetails((PaymentIntent)$this$onCreatePaymentIntent_u24lambda_u245_u24lambda_u243_u24lambda_u242, offlinePaymentDetails != null ? ProtoConverter.INSTANCE.toSdkOfflineDetails(offlinePaymentDetails) : null);
            return paymentIntent3;
        }
        ErrorWrapper errorWrapper = createPaymentIntentResponse.decline_response;
        if (errorWrapper != null) {
            ErrorWrapper it = errorWrapper;
            boolean bl4 = false;
            throw ProtoConverter.INSTANCE.toTerminalException(it.error);
        }
        Object object = createPaymentIntentResponse.error;
        if (object == null || (object = object.message) == null) {
            object = "Unexpected error";
        }
        throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, (String)object, null, null, 12, null);
    }

    @Override
    @NotNull
    public com.stripe.stripeterminal.external.models.SetupIntent createSetupIntent(@NotNull SetupIntentParameters setupIntentParameters) {
        Intrinsics.checkNotNullParameter((Object)setupIntentParameters, (String)"setupIntentParameters");
        this.assertClientSideCreationIsSupported(this.terminalStatusManager.getConnectedReader());
        CreateSetupIntentRequest createSetupIntentSdkRequest = new CreateSetupIntentRequest(CreateSetupIntentRequestMaker.Companion.fromSetupIntentParameters(setupIntentParameters), null, 2, null);
        JackRabbitApi jackRabbitApi = this.jackrabbitApiClient;
        CrpcResponse<CreateSetupIntentResponse> response = jackRabbitApi != null ? jackRabbitApi.createSetupIntent(createSetupIntentSdkRequest) : null;
        CreateSetupIntentResponse createSetupIntentResponse = CrpcResponseExtensions.INSTANCE.withJackrabbitResponse(response);
        boolean bl = false;
        SetupIntent setupIntent = createSetupIntentResponse.setup_intent;
        if (setupIntent != null && (setupIntent = ProtoConverter.INSTANCE.toSdkSetupIntent(setupIntent)) != null) {
            SetupIntent it = setupIntent;
            boolean bl2 = false;
            return it;
        }
        ErrorWrapper errorWrapper = createSetupIntentResponse.decline_response;
        if (errorWrapper != null) {
            ErrorWrapper it = errorWrapper;
            boolean bl3 = false;
            throw ProtoConverter.INSTANCE.toTerminalException(it.error);
        }
        Object object = createSetupIntentResponse.error;
        if (object == null || (object = object.message) == null) {
            object = "Unexpected error";
        }
        throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, (String)object, null, null, 12, null);
    }

    @Override
    public void cancelCollectInteracRefundMethod() {
        this.cancelPaymentMethodCollect((Function1<? super CancelCollectPaymentMethodRequest, ? extends CrpcResponse<CancelCollectPaymentMethodResponse>>)((Function1)new Function1<CancelCollectPaymentMethodRequest, CrpcResponse<CancelCollectPaymentMethodResponse>>(this){
            final /* synthetic */ IpReaderController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final CrpcResponse<CancelCollectPaymentMethodResponse> invoke(@NotNull CancelCollectPaymentMethodRequest it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                JackRabbitApi jackRabbitApi = IpReaderController.access$getJackrabbitApiClient$p(this.this$0);
                return jackRabbitApi != null ? jackRabbitApi.cancelCollectInteracRefundMethod(it) : null;
            }
        }));
    }

    @Override
    public void startPaymentCollection(@NotNull Amount amount, @NotNull Function1<? super PaymentMethodData, Unit> onPaymentCollected, @NotNull Function1<? super TerminalException, Unit> onFailure, boolean skipTipping, boolean manualEntry, boolean updatePaymentIntent2, @Nullable String intentId, @Nullable Amount tipEligibleAmount, @Nullable List<? extends PaymentMethodOptions.RoutingPriority> computedPriorities, @Nullable String stripeAccountId, @Nullable OfflineDetails offlineDetails) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        Intrinsics.checkNotNullParameter(onPaymentCollected, (String)"onPaymentCollected");
        Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
        JackRabbitApi jackRabbitApi = this.jackrabbitApiClient;
        if (jackRabbitApi != null) {
            JackRabbitApi it = jackRabbitApi;
            boolean bl = false;
            this.paymentCollectionJob = new CollectPaymentJob(this.coroutineScope, onPaymentCollected, onFailure, this.apiRequestFactory.collectPaymentMethod(amount, skipTipping, manualEntry, updatePaymentIntent2, intentId, tipEligibleAmount, computedPriorities, stripeAccountId, offlineDetails), it).launch();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw this.noActiveReaderException();
        }
    }

    @Override
    public void startInteracRefund(@NotNull Amount amount, @NotNull String chargeId, @NotNull Function1<? super PaymentMethodData, Unit> onPaymentCollected, @NotNull Function1<? super TerminalException, Unit> onFailure) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)chargeId, (String)"chargeId");
        Intrinsics.checkNotNullParameter(onPaymentCollected, (String)"onPaymentCollected");
        Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
        JackRabbitApi jackRabbitApi = this.jackrabbitApiClient;
        if (jackRabbitApi != null) {
            JackRabbitApi it = jackRabbitApi;
            boolean bl = false;
            this.paymentCollectionJob = new CollectRefundPaymentJob(this.coroutineScope, onPaymentCollected, onFailure, this.apiRequestFactory.collectInteracRefundMethod(amount, chargeId), it).launch();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw this.noActiveReaderException();
        }
    }

    @Override
    public void startSetupIntentPaymentCollection(@NotNull String intentId, @NotNull Function1<? super PaymentMethodData, Unit> onPaymentCollected, @NotNull Function1<? super TerminalException, Unit> onFailure) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)intentId, (String)"intentId");
        Intrinsics.checkNotNullParameter(onPaymentCollected, (String)"onPaymentCollected");
        Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
        JackRabbitApi jackRabbitApi = this.jackrabbitApiClient;
        if (jackRabbitApi != null) {
            JackRabbitApi it = jackRabbitApi;
            boolean bl = false;
            this.paymentCollectionJob = new CollectSetupIntentPaymentJob(this.coroutineScope, onPaymentCollected, onFailure, this.apiRequestFactory.collectSetupIntentPaymentMethod(intentId), it).launch();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw this.noActiveReaderException();
        }
    }

    @Override
    public void cancelCollectPaymentMethod() {
        this.cancelPaymentMethodCollect((Function1<? super CancelCollectPaymentMethodRequest, ? extends CrpcResponse<CancelCollectPaymentMethodResponse>>)((Function1)new Function1<CancelCollectPaymentMethodRequest, CrpcResponse<CancelCollectPaymentMethodResponse>>(this){
            final /* synthetic */ IpReaderController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final CrpcResponse<CancelCollectPaymentMethodResponse> invoke(@NotNull CancelCollectPaymentMethodRequest it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                JackRabbitApi jackRabbitApi = IpReaderController.access$getJackrabbitApiClient$p(this.this$0);
                return jackRabbitApi != null ? jackRabbitApi.cancelCollectPaymentMethod(it) : null;
            }
        }));
    }

    @Override
    public void cancelCollectSetupIntentPaymentMethod() {
        this.cancelSetupIntentPaymentCollect((Function1<? super CancelSetupIntentPaymentMethodRequest, ? extends CrpcResponse<CancelSetupIntentPaymentMethodResponse>>)((Function1)new Function1<CancelSetupIntentPaymentMethodRequest, CrpcResponse<CancelSetupIntentPaymentMethodResponse>>(this){
            final /* synthetic */ IpReaderController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final CrpcResponse<CancelSetupIntentPaymentMethodResponse> invoke(@NotNull CancelSetupIntentPaymentMethodRequest it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                JackRabbitApi jackRabbitApi = IpReaderController.access$getJackrabbitApiClient$p(this.this$0);
                return jackRabbitApi != null ? jackRabbitApi.cancelSetupIntentPaymentMethod(it) : null;
            }
        }));
    }

    @Override
    public void clearReaderDisplay() {
        JackRabbitApi jackRabbitApi = this.jackrabbitApiClient;
        CrpcResponse<ClearReaderDisplayResponse> response = jackRabbitApi != null ? jackRabbitApi.clearReaderDisplay(this.apiRequestFactory.clearReaderDisplay()) : null;
        CrpcResponseExtensions.INSTANCE.withJackrabbitResponse(response);
    }

    @Override
    @NotNull
    public Refund confirmInteracRefund(@NotNull RefundParameters refundParams, @NotNull PaymentMethod paymentMethod, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)refundParams, (String)"refundParams");
        Intrinsics.checkNotNullParameter((Object)((Object)paymentMethod), (String)"paymentMethod");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        JackRabbitApi jackRabbitApi = this.jackrabbitApiClient;
        CrpcResponse<ConfirmInteracRefundResponse> confirmResponse = jackRabbitApi != null ? jackRabbitApi.confirmInteracRefund(this.apiRequestFactory.confirmInteracRefund(refundParams, paymentMethod, reason)) : null;
        ConfirmInteracRefundResponse it = (ConfirmInteracRefundResponse)((Object)CrpcResponseExtensions.INSTANCE.withJackrabbitResponse(confirmResponse));
        boolean bl = false;
        ConfirmInteracRefundResponseExtensions.ConfirmInteracRefundResponseResult result2 = ConfirmInteracRefundResponseExtensions.INSTANCE.toResult(it);
        if (result2 instanceof ConfirmInteracRefundResponseExtensions.ConfirmInteracRefundResponseResult.Success) {
            return ((ConfirmInteracRefundResponseExtensions.ConfirmInteracRefundResponseResult.Success)result2).getRefund();
        }
        if (result2 instanceof ConfirmInteracRefundResponseExtensions.ConfirmInteracRefundResponseResult.Error) {
            throw ((ConfirmInteracRefundResponseExtensions.ConfirmInteracRefundResponseResult.Error)result2).getException();
        }
        throw new NoWhenBranchMatchedException();
    }

    @Override
    @NotNull
    public PaymentIntent confirmPayment(@NotNull PaymentIntent paymentIntent2) {
        PaymentIntent paymentIntent3;
        Intrinsics.checkNotNullParameter((Object)paymentIntent2, (String)"paymentIntent");
        com.stripe.stripeterminal.external.models.OfflineDetails offlineDetails = OfflineAdapterKt.offlineDetails(paymentIntent2);
        Object it = this.apiRequestFactory.confirmPayment(paymentIntent2, offlineDetails != null ? OfflineDetailsExtensionsKt.getTransactionOfflineDetails(offlineDetails) : null);
        boolean bl = false;
        JackRabbitApi jackRabbitApi = this.jackrabbitApiClient;
        it = ConfirmPaymentResponseExtensions.INSTANCE.toResult(CrpcResponseExtensions.INSTANCE.withJackrabbitResponse(jackRabbitApi != null ? jackRabbitApi.confirmPayment((ConfirmPaymentRequest)((Object)it)) : null));
        boolean bl2 = false;
        Object object = it;
        if (object instanceof ConfirmPaymentResponseExtensions.ConfirmPaymentResponseResult.Error) {
            throw ((ConfirmPaymentResponseExtensions.ConfirmPaymentResponseResult.Error)it).getException();
        }
        if (!(object instanceof ConfirmPaymentResponseExtensions.ConfirmPaymentResponseResult.Success)) {
            throw new NoWhenBranchMatchedException();
        }
        PaymentIntent $this$confirmPayment_u24lambda_u2415_u24lambda_u2414 = paymentIntent3 = ((ConfirmPaymentResponseExtensions.ConfirmPaymentResponseResult.Success)it).getPaymentIntent();
        boolean bl3 = false;
        OfflineAdapterKt.setOfflineDetails($this$confirmPayment_u24lambda_u2415_u24lambda_u2414, ((ConfirmPaymentResponseExtensions.ConfirmPaymentResponseResult.Success)it).getOfflineDetails());
        return paymentIntent3;
    }

    @Override
    public void finishConfirmPayment() {
    }

    @Override
    public void resumeCollectPaymentMethod(@NotNull String intentId, @Nullable OfflineDetails offlineDetails, @NotNull Function1<? super PaymentMethodData, Unit> onPaymentCollected, @NotNull Function1<? super TerminalException, Unit> onFailure) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)intentId, (String)"intentId");
        Intrinsics.checkNotNullParameter(onPaymentCollected, (String)"onPaymentCollected");
        Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
        JackRabbitApi jackRabbitApi = this.jackrabbitApiClient;
        if (jackRabbitApi != null) {
            JackRabbitApi it = jackRabbitApi;
            boolean bl = false;
            this.paymentCollectionJob = new ResumePaymentJob(this.coroutineScope, onPaymentCollected, onFailure, this.apiRequestFactory.resumeCollectPaymentMethod(intentId, offlineDetails), it).launch();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw this.noActiveReaderException();
        }
    }

    @Override
    @NotNull
    public com.stripe.stripeterminal.external.models.SetupIntent confirmSetupIntent(@NotNull com.stripe.stripeterminal.external.models.SetupIntent setupIntent) {
        Intrinsics.checkNotNullParameter((Object)setupIntent, (String)"setupIntent");
        JackRabbitApi jackRabbitApi = this.jackrabbitApiClient;
        CrpcResponse<ConfirmSetupIntentResponse> confirmResponse = jackRabbitApi != null ? jackRabbitApi.confirmSetupIntent(this.apiRequestFactory.confirmSetupIntentJackRabbit(setupIntent)) : null;
        ConfirmSetupIntentResponse it = CrpcResponseExtensions.INSTANCE.withJackrabbitResponse(confirmResponse);
        boolean bl = false;
        ConfirmSetupIntentResponseExtensions.ConfirmSetupIntentResponseResult result2 = ConfirmSetupIntentResponseExtensions.INSTANCE.toResult(it);
        if (result2 instanceof ConfirmSetupIntentResponseExtensions.ConfirmSetupIntentResponseResult.Error) {
            throw ((ConfirmSetupIntentResponseExtensions.ConfirmSetupIntentResponseResult.Error)result2).getException();
        }
        if (result2 instanceof ConfirmSetupIntentResponseExtensions.ConfirmSetupIntentResponseResult.Success) {
            return ((ConfirmSetupIntentResponseExtensions.ConfirmSetupIntentResponseResult.Success)result2).getSetupIntent();
        }
        throw new NoWhenBranchMatchedException();
    }

    @Override
    @NotNull
    public PaymentIntent cancelPaymentIntent(@NotNull PaymentIntent paymentIntent2) {
        Intrinsics.checkNotNullParameter((Object)paymentIntent2, (String)"paymentIntent");
        this.assertClientSideCancellationIsSupported(this.terminalStatusManager.getConnectedReader());
        JackRabbitApi jackRabbitApi = this.jackrabbitApiClient;
        CrpcResponse<CancelPaymentIntentResponse> response = jackRabbitApi != null ? jackRabbitApi.cancelPaymentIntent(this.apiRequestFactory.cancelPaymentIntent(paymentIntent2)) : null;
        CancelPaymentIntentResponse cancelResponse = CrpcResponseExtensions.INSTANCE.withJackrabbitResponse(response);
        boolean bl = false;
        com.stripe.proto.model.rest.PaymentIntent paymentIntent3 = cancelResponse.payment_intent;
        if (paymentIntent3 != null && (paymentIntent3 = ProtoConverter.INSTANCE.toSdkPaymentIntent(paymentIntent3)) != null) {
            com.stripe.proto.model.rest.PaymentIntent it = paymentIntent3;
            boolean bl2 = false;
            return it;
        }
        ErrorWrapper errorWrapper = cancelResponse.wrapped_error;
        if (errorWrapper != null) {
            ErrorWrapper it = errorWrapper;
            boolean bl3 = false;
            throw ProtoConverter.INSTANCE.toTerminalException(it.error);
        }
        Object object = cancelResponse.error;
        if (object == null || (object = object.message) == null) {
            object = "Unexpected error";
        }
        throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, (String)object, null, null, 12, null);
    }

    @Override
    @NotNull
    public com.stripe.stripeterminal.external.models.SetupIntent cancelSetupIntent(@NotNull com.stripe.stripeterminal.external.models.SetupIntent intent, @NotNull SetupIntentCancellationParameters params) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.assertClientSideCancellationIsSupported(this.terminalStatusManager.getConnectedReader());
        JackRabbitApi jackRabbitApi = this.jackrabbitApiClient;
        CrpcResponse<CancelSetupIntentResponse> response = jackRabbitApi != null ? jackRabbitApi.cancelSetupIntent(this.apiRequestFactory.cancelSetupIntent(intent, params)) : null;
        CancelSetupIntentResponse cancelSetupIntentResponse = CrpcResponseExtensions.INSTANCE.withJackrabbitResponse(response);
        boolean bl = false;
        SetupIntent setupIntent = cancelSetupIntentResponse.setup_intent;
        if (setupIntent != null && (setupIntent = ProtoConverter.INSTANCE.toSdkSetupIntent(setupIntent)) != null) {
            SetupIntent it = setupIntent;
            boolean bl2 = false;
            return it;
        }
        ErrorWrapper errorWrapper = cancelSetupIntentResponse.wrapped_error;
        if (errorWrapper != null) {
            ErrorWrapper it = errorWrapper;
            boolean bl3 = false;
            throw ProtoConverter.INSTANCE.toTerminalException(it.error);
        }
        Object object = cancelSetupIntentResponse.error;
        if (object == null || (object = object.message) == null) {
            object = "Unexpected error";
        }
        throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, (String)object, null, null, 12, null);
    }

    private final Job maintainConnectivity(Reader reader, Function0<Unit> disconnectCallback) {
        return BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, disconnectCallback, reader, null){
            int I$0;
            int I$1;
            Object L$0;
            int label;
            final /* synthetic */ IpReaderController this$0;
            final /* synthetic */ Function0<Unit> $disconnectCallback;
            final /* synthetic */ Reader $reader;
            {
                this.this$0 = $receiver;
                this.$disconnectCallback = $disconnectCallback;
                this.$reader = $reader;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.dump(StructuredReturn.java:60)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void cancelPaymentMethodCollect(Function1<? super CancelCollectPaymentMethodRequest, ? extends CrpcResponse<CancelCollectPaymentMethodResponse>> cancelFun) {
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, cancelFun, null){
            int label;
            final /* synthetic */ IpReaderController this$0;
            final /* synthetic */ Function1<CancelCollectPaymentMethodRequest, CrpcResponse<CancelCollectPaymentMethodResponse>> $cancelFun;
            {
                this.this$0 = $receiver;
                this.$cancelFun = $cancelFun;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Job job = IpReaderController.access$getPaymentCollectionJob$p(this.this$0);
                        if (job == null) return Unit.INSTANCE;
                        this.label = 1;
                        Object object3 = JobKt.cancelAndJoin((Job)job, (Continuation)((Continuation)this));
                        Object object4 = object3;
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object4 = $result;
                        return Unit.INSTANCE;
                    }
                    default: {
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        CrpcResponse cancelResponse = (CrpcResponse)this.$cancelFun.invoke((Object)((Object)IpReaderController.access$getApiRequestFactory$p(this.this$0).cancelCollectPaymentMethod()));
                        CrpcResponseExtensions.INSTANCE.withJackrabbitResponse(cancelResponse);
                    }
                    catch (TerminalException e2) {
                        this.this$0.getLogger().e(e2);
                    }
                }
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void cancelSetupIntentPaymentCollect(Function1<? super CancelSetupIntentPaymentMethodRequest, ? extends CrpcResponse<CancelSetupIntentPaymentMethodResponse>> cancelFun) {
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, cancelFun, null){
            int label;
            final /* synthetic */ IpReaderController this$0;
            final /* synthetic */ Function1<CancelSetupIntentPaymentMethodRequest, CrpcResponse<CancelSetupIntentPaymentMethodResponse>> $cancelFun;
            {
                this.this$0 = $receiver;
                this.$cancelFun = $cancelFun;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Job job = IpReaderController.access$getPaymentCollectionJob$p(this.this$0);
                        if (job == null) return Unit.INSTANCE;
                        this.label = 1;
                        Object object3 = JobKt.cancelAndJoin((Job)job, (Continuation)((Continuation)this));
                        Object object4 = object3;
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object4 = $result;
                        return Unit.INSTANCE;
                    }
                    default: {
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        CrpcResponse cancelResponse = (CrpcResponse)this.$cancelFun.invoke((Object)((Object)IpReaderController.access$getApiRequestFactory$p(this.this$0).cancelSetupIntentPaymentMethod()));
                        CrpcResponseExtensions.INSTANCE.withJackrabbitResponse(cancelResponse);
                    }
                    catch (TerminalException e2) {
                        this.this$0.getLogger().e(e2);
                    }
                }
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final TerminalException noActiveReaderException() {
        return new TerminalException(TerminalException.TerminalErrorCode.NOT_CONNECTED_TO_READER, "No active reader", null, null, 12, null);
    }

    private final void assertClientSideCreationIsSupported(Reader reader) {
        this.assertReaderVersionAtLeast(reader, 2100100L);
    }

    private final void assertClientSideCancellationIsSupported(Reader reader) {
        this.assertReaderVersionAtLeast(reader, 2110024L);
    }

    private final void assertReaderVersionAtLeast(Reader reader, long minVersion) {
        long version;
        Object object = reader;
        long l2 = object != null && (object = object.getCanonicalReaderVersion()) != null ? (Long)object : (version = 0L);
        if (version < minVersion) {
            throw new TerminalException(TerminalException.TerminalErrorCode.UNSUPPORTED_OPERATION, "This operation is not supported for this reader", null, null, 12, null);
        }
    }

    public static final /* synthetic */ JackRabbitApi access$getJackrabbitApiClient$p(IpReaderController $this) {
        return $this.jackrabbitApiClient;
    }

    public static final /* synthetic */ String access$getLastReaderConfigHash$p(IpReaderController $this) {
        return $this.lastReaderConfigHash;
    }

    public static final /* synthetic */ Job access$getActivateJob$p(IpReaderController $this) {
        return $this.activateJob;
    }

    public static final /* synthetic */ void access$setActivateJob$p(IpReaderController $this, Job job) {
        $this.activateJob = job;
    }

    public static final /* synthetic */ CoroutineScope access$getCoroutineScope$p(IpReaderController $this) {
        return $this.coroutineScope;
    }

    public static final /* synthetic */ ReaderActivator access$getReaderActivator$p(IpReaderController $this) {
        return $this.readerActivator;
    }

    public static final /* synthetic */ FeatureFlagsRepository access$getFeatureFlagsRepository$p(IpReaderController $this) {
        return $this.featureFlagsRepository;
    }

    public static final /* synthetic */ void access$setLastReaderConfigHash$p(IpReaderController $this, String string) {
        $this.lastReaderConfigHash = string;
    }

    public static final /* synthetic */ Job access$getPaymentCollectionJob$p(IpReaderController $this) {
        return $this.paymentCollectionJob;
    }

    public static final /* synthetic */ JackRabbitApiRequestFactory access$getApiRequestFactory$p(IpReaderController $this) {
        return $this.apiRequestFactory;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/stripeterminal/internal/common/remotereadercontrollers/IpReaderController$Companion;", "", "()V", "HEARTBEAT_INTERVAL_MS", "", "HEARTBEAT_RECOVERY_INTERVAL_MS", "MAX_CONNECTION_FAILURES", "", "MINIMUM_CLIENT_SIDE_CANCEL_SW_VERSION", "MINIMUM_CLIENT_SIDE_CREATE_SW_VERSION", "common_publish"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

