/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.resourcerepository;

import com.squareup.wire.Message;
import com.stripe.core.transaction.TransactionRepository;
import com.stripe.jvmcore.currency.Amount;
import com.stripe.jvmcore.hardware.emv.CvmType;
import com.stripe.jvmcore.hardware.emv.TlvMap;
import com.stripe.jvmcore.hardware.emv.TransactionResult;
import com.stripe.jvmcore.logging.HealthLogger;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.loggingmodels.ApplicationTraceResult;
import com.stripe.jvmcore.paymentcollection.OnlineAuthFailureReason;
import com.stripe.jvmcore.paymentcollection.OnlineAuthState;
import com.stripe.jvmcore.paymentcollection.OnlineAuthStateListener;
import com.stripe.jvmcore.restclient.AuthenticatedRestClient;
import com.stripe.jvmcore.restclient.CustomHeadersProvider;
import com.stripe.jvmcore.restclient.RestRequest;
import com.stripe.jvmcore.terminal.api.ActivateReaderResponse;
import com.stripe.jvmcore.transaction.ChargeAttempt;
import com.stripe.jvmcore.transaction.ChargeAttemptManager;
import com.stripe.jvmcore.transaction.CollectiblePayment;
import com.stripe.jvmcore.transaction.payment.Payment;
import com.stripe.offlinemode.OfflineEventHandler;
import com.stripe.offlinemode.helpers.OfflineConfigHelper;
import com.stripe.offlinemode.helpers.OfflineRequestHelper;
import com.stripe.offlinemode.log.OfflineTrace;
import com.stripe.proto.api.rest.ConfirmPaymentIntentRequest;
import com.stripe.proto.api.rest.CreatePaymentIntentRequest;
import com.stripe.proto.api.rest.RequestedPaymentMethod;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.offline.DiscreteScope;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.offline.OfflineDomain;
import com.stripe.stripeterminal.external.models.ConnectionConfiguration;
import com.stripe.stripeterminal.external.models.CreateConfiguration;
import com.stripe.stripeterminal.external.models.Location;
import com.stripe.stripeterminal.external.models.OfflineBehavior;
import com.stripe.stripeterminal.external.models.PaymentIntent;
import com.stripe.stripeterminal.external.models.PaymentIntentParameters;
import com.stripe.stripeterminal.external.models.PaymentIntentStatus;
import com.stripe.stripeterminal.external.models.PaymentMethod;
import com.stripe.stripeterminal.external.models.PaymentMethodType;
import com.stripe.stripeterminal.external.models.ReadReusableCardParameters;
import com.stripe.stripeterminal.external.models.Reader;
import com.stripe.stripeterminal.external.models.Refund;
import com.stripe.stripeterminal.external.models.RefundParameters;
import com.stripe.stripeterminal.external.models.SetupIntent;
import com.stripe.stripeterminal.external.models.SetupIntentCancellationParameters;
import com.stripe.stripeterminal.external.models.SetupIntentParameters;
import com.stripe.stripeterminal.external.models.TerminalException;
import com.stripe.stripeterminal.internal.common.TerminalStatusManager;
import com.stripe.stripeterminal.internal.common.adapter.OfflineAdapterKt;
import com.stripe.stripeterminal.internal.common.api.ApiRequestFactory;
import com.stripe.stripeterminal.internal.common.enum.EmvProcessingMethod;
import com.stripe.stripeterminal.internal.common.resourcerepository.OfflineDirectResourceRepository;
import com.stripe.stripeterminal.internal.common.resourcerepository.ResourceRepository;
import com.stripe.stripeterminal.internal.models.PaymentMethodData;
import com.stripe.stripeterminal.internal.models.ReadMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 w2\u00020\u0001:\u0001wBs\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\"\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0015j\u0002`\u001a\u00a2\u0006\u0002\u0010\u001bJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J0\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0#j\u0002`&2\u0006\u0010'\u001a\u00020(2\u000e\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010+0*H\u0002J\u0010\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020(H\u0016J\u0018\u0010.\u001a\u00020/2\u0006\u0010-\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016JD\u00102\u001a\u00020/2\u0006\u0010-\u001a\u00020/2\b\u00103\u001a\u0004\u0018\u00010+2\u0018\u00104\u001a\u0014\u0012\u0004\u0012\u000206\u0012\n\u0012\b\u0012\u0004\u0012\u00020807052\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0016J\u0018\u0010=\u001a\u00020(2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u00020/2\u0006\u0010C\u001a\u00020DH\u0016J\u0010\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HH\u0002J0\u0010I\u001a\u0002HJ\"\n\b\u0000\u0010J\u0018\u0001*\u00020K2\u0006\u0010L\u001a\u00020M2\f\u0010N\u001a\b\u0012\u0004\u0012\u0002HJ0*H\u0082\b\u00a2\u0006\u0002\u0010OJ\u001a\u0010P\u001a\u0002062\u0006\u0010Q\u001a\u00020R2\b\u0010S\u001a\u0004\u0018\u000106H\u0002J\"\u0010T\u001a\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020V0U2\f\u0010W\u001a\b\u0012\u0004\u0012\u0002060XH\u0016J\u0010\u0010Y\u001a\u00020H2\u0006\u0010Z\u001a\u000206H\u0002J\u0010\u0010[\u001a\u00020:2\u0006\u0010\\\u001a\u00020RH\u0002J\u0010\u0010]\u001a\u00020:2\u0006\u0010^\u001a\u00020RH\u0002JX\u0010_\u001a\u00020(2\u0006\u0010'\u001a\u00020(2\u000e\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010+0*2\u0018\u00104\u001a\u0014\u0012\u0004\u0012\u000206\u0012\n\u0012\b\u0012\u0004\u0012\u00020807052\f\u0010`\u001a\b\u0012\u0004\u0012\u00020a0*2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0016J<\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020e2\b\u00103\u001a\u0004\u0018\u00010+2\u0018\u00104\u001a\u0014\u0012\u0004\u0012\u000206\u0012\n\u0012\b\u0012\u0004\u0012\u00020807052\u0006\u0010;\u001a\u00020<H\u0016J\u0018\u0010f\u001a\u00020g2\u0006\u0010h\u001a\u00020i2\u0006\u0010j\u001a\u00020aH\u0016JL\u0010k\u001a\u00020F2\u0006\u0010-\u001a\u00020(2\u0006\u0010l\u001a\u00020m2\u0006\u0010n\u001a\u0002062\u0018\u00104\u001a\u0014\u0012\u0004\u0012\u000206\u0012\n\u0012\b\u0012\u0004\u0012\u00020807052\u0006\u0010;\u001a\u00020<2\b\u0010o\u001a\u0004\u0018\u00010pH\u0002J\u0010\u0010q\u001a\u00020(2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010r\u001a\u00020F2\u0006\u0010-\u001a\u00020(H\u0002J(\u0010s\u001a\u0010\u0012\u0004\u0012\u00020R\u0012\u0006\u0012\u0004\u0018\u0001060t2\b\u0010u\u001a\u0004\u0018\u00010v2\u0006\u0010-\u001a\u00020(H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0015j\u0002`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006x"}, d2={"Lcom/stripe/stripeterminal/internal/common/resourcerepository/OfflineDirectResourceRepository;", "Lcom/stripe/stripeterminal/internal/common/resourcerepository/ResourceRepository;", "apiRequestFactory", "Lcom/stripe/stripeterminal/internal/common/api/ApiRequestFactory;", "transactionRepository", "Lcom/stripe/core/transaction/TransactionRepository;", "offlineEventHandler", "Lcom/stripe/offlinemode/OfflineEventHandler;", "statusManager", "Lcom/stripe/stripeterminal/internal/common/TerminalStatusManager;", "offlineRequestHelper", "Lcom/stripe/offlinemode/helpers/OfflineRequestHelper;", "customHeadersProvider", "Lcom/stripe/jvmcore/restclient/CustomHeadersProvider;", "chargeAttemptManager", "Lcom/stripe/jvmcore/transaction/ChargeAttemptManager;", "authenticatedRestClient", "Lcom/stripe/jvmcore/restclient/AuthenticatedRestClient;", "offlineConfigHelper", "Lcom/stripe/offlinemode/helpers/OfflineConfigHelper;", "offlineDiscreteLogger", "Lcom/stripe/jvmcore/logging/HealthLogger;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/offline/OfflineDomain;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/offline/OfflineDomain$Builder;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/offline/DiscreteScope;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/offline/DiscreteScope$Builder;", "Lcom/stripe/offlinemode/log/OfflineDiscreteLogger;", "(Lcom/stripe/stripeterminal/internal/common/api/ApiRequestFactory;Lcom/stripe/core/transaction/TransactionRepository;Lcom/stripe/offlinemode/OfflineEventHandler;Lcom/stripe/stripeterminal/internal/common/TerminalStatusManager;Lcom/stripe/offlinemode/helpers/OfflineRequestHelper;Lcom/stripe/jvmcore/restclient/CustomHeadersProvider;Lcom/stripe/jvmcore/transaction/ChargeAttemptManager;Lcom/stripe/jvmcore/restclient/AuthenticatedRestClient;Lcom/stripe/offlinemode/helpers/OfflineConfigHelper;Lcom/stripe/jvmcore/logging/HealthLogger;)V", "activateReader", "Lcom/stripe/jvmcore/terminal/api/ActivateReaderResponse;", "reader", "Lcom/stripe/stripeterminal/external/models/Reader;", "connectionConfiguration", "Lcom/stripe/stripeterminal/external/models/ConnectionConfiguration;", "buildConfirmPaymentIntentRequest", "Lcom/stripe/jvmcore/restclient/RestRequest;", "Lcom/stripe/proto/api/rest/ConfirmPaymentIntentRequest;", "Lcom/stripe/proto/api/rest/ConfirmPaymentIntentRequest$Builder;", "Lcom/stripe/stripeterminal/internal/common/api/ConfirmPaymentIntentRestRequest;", "paymentIntent", "Lcom/stripe/stripeterminal/external/models/PaymentIntent;", "getCollectiblePayment", "Lkotlin/Function0;", "Lcom/stripe/jvmcore/transaction/CollectiblePayment;", "cancelPaymentIntent", "intent", "cancelSetupIntent", "Lcom/stripe/stripeterminal/external/models/SetupIntent;", "params", "Lcom/stripe/stripeterminal/external/models/SetupIntentCancellationParameters;", "confirmSetupIntent", "collectiblePayment", "handleAuthResponse", "Lkotlin/Function1;", "", "Lkotlinx/coroutines/Deferred;", "Lcom/stripe/jvmcore/hardware/emv/TransactionResult;", "immediateRecollectForSca", "", "authStateListener", "Lcom/stripe/jvmcore/paymentcollection/OnlineAuthStateListener;", "createPaymentIntent", "paymentIntentParameters", "Lcom/stripe/stripeterminal/external/models/PaymentIntentParameters;", "createConfiguration", "Lcom/stripe/stripeterminal/external/models/CreateConfiguration;", "createSetupIntent", "setupIntentParameters", "Lcom/stripe/stripeterminal/external/models/SetupIntentParameters;", "emitHealthMetrics", "", "error", "Lcom/stripe/stripeterminal/external/models/TerminalException;", "executeWithOfflineTracing", "T", "", "offlineTrace", "Lcom/stripe/offlinemode/log/OfflineTrace;", "operation", "(Lcom/stripe/offlinemode/log/OfflineTrace;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getAuthorizationResponseCode", "parsedEmvData", "Lcom/stripe/jvmcore/hardware/emv/TlvMap;", "readMethod", "getReaderLocations", "", "Lcom/stripe/stripeterminal/external/models/Location;", "deviceSerials", "", "getUnsupportedOpException", "name", "isCardExpired", "tlvMap", "isOnlinePINCvm", "emvTlvMap", "processPayment", "collectScaPaymentMethodData", "Lcom/stripe/stripeterminal/internal/models/PaymentMethodData;", "processRefund", "Lcom/stripe/stripeterminal/external/models/Refund;", "refundParams", "Lcom/stripe/stripeterminal/external/models/RefundParameters;", "readReusableCard", "Lcom/stripe/stripeterminal/external/models/PaymentMethod;", "readReusableCardParams", "Lcom/stripe/stripeterminal/external/models/ReadReusableCardParameters;", "paymentMethodData", "sendAuthResponseCodeToDevice", "tipAmount", "", "authResponseCode", "declineCode", "Lcom/stripe/stripeterminal/external/models/TerminalException$TerminalErrorCode;", "updatePaymentIntent", "validatePaymentIntent", "validatePaymentMethod", "Lkotlin/Pair;", "paymentMethod", "Lcom/stripe/proto/api/rest/RequestedPaymentMethod;", "Companion", "resourcerepository_release"})
@SourceDebugExtension(value={"SMAP\nOfflineDirectResourceRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OfflineDirectResourceRepository.kt\ncom/stripe/stripeterminal/internal/common/resourcerepository/OfflineDirectResourceRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,565:1\n462#1,2:566\n464#1,6:569\n462#1,2:575\n464#1,6:578\n462#1,2:584\n464#1,6:587\n1#2:568\n1#2:577\n1#2:586\n1#2:593\n1549#3:594\n1620#3,3:595\n*S KotlinDebug\n*F\n+ 1 OfflineDirectResourceRepository.kt\ncom/stripe/stripeterminal/internal/common/resourcerepository/OfflineDirectResourceRepository\n*L\n79#1:566,2\n79#1:569,6\n92#1:575,2\n92#1:578,6\n139#1:584,2\n139#1:587,6\n79#1:568\n92#1:577\n139#1:586\n560#1:594\n560#1:595,3\n*E\n"})
public final class OfflineDirectResourceRepository
implements ResourceRepository {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final ApiRequestFactory apiRequestFactory;
    @NotNull
    private final TransactionRepository transactionRepository;
    @NotNull
    private final OfflineEventHandler offlineEventHandler;
    @NotNull
    private final TerminalStatusManager statusManager;
    @NotNull
    private final OfflineRequestHelper offlineRequestHelper;
    @NotNull
    private final CustomHeadersProvider customHeadersProvider;
    @NotNull
    private final ChargeAttemptManager chargeAttemptManager;
    @NotNull
    private final AuthenticatedRestClient authenticatedRestClient;
    @NotNull
    private final OfflineConfigHelper offlineConfigHelper;
    @NotNull
    private final HealthLogger<OfflineDomain, OfflineDomain.Builder, DiscreteScope, DiscreteScope.Builder> offlineDiscreteLogger;
    @NotNull
    private static final Log LOGGER;
    @NotNull
    private static final Set<String> MAGSTRIPE_READ_METHODS;
    @NotNull
    private static final String TVR_MISSING_ERROR_MESSAGE = "Failed to retrieve verification results from EMV data.";
    @NotNull
    private static final String AID_MISSING_ERROR_MESSAGE = "Failed to retrieve application ID from card EMV data.";

    @Inject
    public OfflineDirectResourceRepository(@NotNull ApiRequestFactory apiRequestFactory, @NotNull TransactionRepository transactionRepository, @NotNull OfflineEventHandler offlineEventHandler, @NotNull TerminalStatusManager statusManager, @NotNull OfflineRequestHelper offlineRequestHelper, @NotNull CustomHeadersProvider customHeadersProvider, @NotNull ChargeAttemptManager chargeAttemptManager, @NotNull AuthenticatedRestClient authenticatedRestClient, @NotNull OfflineConfigHelper offlineConfigHelper, @NotNull HealthLogger<OfflineDomain, OfflineDomain.Builder, DiscreteScope, DiscreteScope.Builder> offlineDiscreteLogger) {
        Intrinsics.checkNotNullParameter((Object)apiRequestFactory, (String)"apiRequestFactory");
        Intrinsics.checkNotNullParameter((Object)transactionRepository, (String)"transactionRepository");
        Intrinsics.checkNotNullParameter((Object)offlineEventHandler, (String)"offlineEventHandler");
        Intrinsics.checkNotNullParameter((Object)statusManager, (String)"statusManager");
        Intrinsics.checkNotNullParameter((Object)offlineRequestHelper, (String)"offlineRequestHelper");
        Intrinsics.checkNotNullParameter((Object)customHeadersProvider, (String)"customHeadersProvider");
        Intrinsics.checkNotNullParameter((Object)chargeAttemptManager, (String)"chargeAttemptManager");
        Intrinsics.checkNotNullParameter((Object)authenticatedRestClient, (String)"authenticatedRestClient");
        Intrinsics.checkNotNullParameter((Object)offlineConfigHelper, (String)"offlineConfigHelper");
        Intrinsics.checkNotNullParameter(offlineDiscreteLogger, (String)"offlineDiscreteLogger");
        this.apiRequestFactory = apiRequestFactory;
        this.transactionRepository = transactionRepository;
        this.offlineEventHandler = offlineEventHandler;
        this.statusManager = statusManager;
        this.offlineRequestHelper = offlineRequestHelper;
        this.customHeadersProvider = customHeadersProvider;
        this.chargeAttemptManager = chargeAttemptManager;
        this.authenticatedRestClient = authenticatedRestClient;
        this.offlineConfigHelper = offlineConfigHelper;
        this.offlineDiscreteLogger = offlineDiscreteLogger;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ActivateReaderResponse activateReader(@NotNull Reader reader, @NotNull ConnectionConfiguration connectionConfiguration) {
        Object $this$executeWithOfflineTracing_u24lambda_u2413$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)connectionConfiguration, (String)"connectionConfiguration");
        OfflineDirectResourceRepository offlineDirectResourceRepository = this;
        OfflineTrace offlineTrace$iv = OfflineTrace.OfflineActivateReader.INSTANCE;
        boolean $i$f$executeWithOfflineTracing = false;
        LOGGER.startOperation(offlineTrace$iv, "offline_mode_trace");
        Object object = this_$iv;
        try {
            ActivateReaderResponse activateReaderResponse;
            $this$executeWithOfflineTracing_u24lambda_u2413$iv = (OfflineDirectResourceRepository)object;
            boolean bl = false;
            boolean bl2 = false;
            ActivateReaderResponse it = activateReaderResponse = this.offlineEventHandler.onActivateReaderRequest(reader, connectionConfiguration);
            boolean bl3 = false;
            this.authenticatedRestClient.setBlankSession();
            $this$executeWithOfflineTracing_u24lambda_u2413$iv = Result.constructor-impl((Object)activateReaderResponse);
        }
        catch (Throwable bl) {
            $this$executeWithOfflineTracing_u24lambda_u2413$iv = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$executeWithOfflineTracing_u24lambda_u2413$iv;
        if (Result.isSuccess-impl((Object)object)) {
            Object it$iv = object;
            boolean bl = false;
            LOGGER.endOperation(ApplicationTraceResult.Companion.success(), "offline_mode_trace");
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable throwable2;
            Throwable e$iv = throwable2 = throwable;
            boolean bl = false;
            LOGGER.e(e$iv);
            LOGGER.endOperation(ApplicationTraceResult.Companion.failure(e$iv), "offline_mode_trace");
        }
        ResultKt.throwOnFailure((Object)object);
        return (ActivateReaderResponse)object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PaymentIntent createPaymentIntent(@NotNull PaymentIntentParameters paymentIntentParameters, @NotNull CreateConfiguration createConfiguration) {
        Object $this$executeWithOfflineTracing_u24lambda_u2413$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)paymentIntentParameters, (String)"paymentIntentParameters");
        Intrinsics.checkNotNullParameter((Object)createConfiguration, (String)"createConfiguration");
        OfflineDirectResourceRepository offlineDirectResourceRepository = this;
        OfflineTrace offlineTrace$iv = OfflineTrace.OfflineCreatePayment.INSTANCE;
        boolean $i$f$executeWithOfflineTracing = false;
        LOGGER.startOperation(offlineTrace$iv, "offline_mode_trace");
        Object object = this_$iv;
        try {
            $this$executeWithOfflineTracing_u24lambda_u2413$iv = (OfflineDirectResourceRepository)object;
            boolean bl = false;
            boolean bl2 = false;
            if (createConfiguration.getOfflineBehavior() == OfflineBehavior.REQUIRE_ONLINE) {
                throw new TerminalException(TerminalException.TerminalErrorCode.NOT_CONNECTED_TO_INTERNET_AND_REQUIRE_ONLINE_SET, "provided createConfiguration does not allow creating payment intents offline", null, null, 12, null);
            }
            CreatePaymentIntentRequest createPaymentIntentRequest = this.apiRequestFactory.createPaymentIntent(paymentIntentParameters);
            $this$executeWithOfflineTracing_u24lambda_u2413$iv = Result.constructor-impl((Object)this.offlineEventHandler.onCreatePaymentIntentRequest(createPaymentIntentRequest, MapsKt.plus(this.offlineRequestHelper.getHeaders(createPaymentIntentRequest), this.customHeadersProvider.customHeaders()), this.offlineRequestHelper.getBody(createPaymentIntentRequest), this.offlineRequestHelper.getUrl(createPaymentIntentRequest)));
        }
        catch (Throwable bl) {
            $this$executeWithOfflineTracing_u24lambda_u2413$iv = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$executeWithOfflineTracing_u24lambda_u2413$iv;
        if (Result.isSuccess-impl((Object)object)) {
            Object it$iv = object;
            boolean bl = false;
            LOGGER.endOperation(ApplicationTraceResult.Companion.success(), "offline_mode_trace");
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable throwable2;
            Throwable e$iv = throwable2 = throwable;
            boolean bl = false;
            LOGGER.e(e$iv);
            LOGGER.endOperation(ApplicationTraceResult.Companion.failure(e$iv), "offline_mode_trace");
        }
        ResultKt.throwOnFailure((Object)object);
        return (PaymentIntent)object;
    }

    @Override
    @NotNull
    public SetupIntent createSetupIntent(@NotNull SetupIntentParameters setupIntentParameters) {
        Intrinsics.checkNotNullParameter((Object)setupIntentParameters, (String)"setupIntentParameters");
        throw this.getUnsupportedOpException("createSetupIntent");
    }

    @Override
    @NotNull
    public Refund processRefund(@NotNull RefundParameters refundParams, @Nullable CollectiblePayment collectiblePayment, @NotNull Function1<? super String, ? extends Deferred<TransactionResult>> handleAuthResponse, @NotNull OnlineAuthStateListener authStateListener) {
        Intrinsics.checkNotNullParameter((Object)refundParams, (String)"refundParams");
        Intrinsics.checkNotNullParameter(handleAuthResponse, (String)"handleAuthResponse");
        Intrinsics.checkNotNullParameter((Object)authStateListener, (String)"authStateListener");
        throw this.getUnsupportedOpException("processRefund");
    }

    @Override
    @NotNull
    public PaymentIntent updatePaymentIntent(@NotNull PaymentIntent paymentIntent2) {
        Intrinsics.checkNotNullParameter((Object)paymentIntent2, (String)"paymentIntent");
        throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_OPERATION, "Updating PaymentIntents is not supported in offline mode.", null, null, 12, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PaymentIntent processPayment(@NotNull PaymentIntent paymentIntent2, @NotNull Function0<CollectiblePayment> getCollectiblePayment, @NotNull Function1<? super String, ? extends Deferred<TransactionResult>> handleAuthResponse, @NotNull Function0<PaymentMethodData> collectScaPaymentMethodData, boolean immediateRecollectForSca, @NotNull OnlineAuthStateListener authStateListener) {
        Object $this$executeWithOfflineTracing_u24lambda_u2413$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)paymentIntent2, (String)"paymentIntent");
        Intrinsics.checkNotNullParameter(getCollectiblePayment, (String)"getCollectiblePayment");
        Intrinsics.checkNotNullParameter(handleAuthResponse, (String)"handleAuthResponse");
        Intrinsics.checkNotNullParameter(collectScaPaymentMethodData, (String)"collectScaPaymentMethodData");
        Intrinsics.checkNotNullParameter((Object)authStateListener, (String)"authStateListener");
        OfflineDirectResourceRepository offlineDirectResourceRepository = this;
        OfflineTrace offlineTrace$iv = OfflineTrace.OfflineConfirmPayment.INSTANCE;
        boolean $i$f$executeWithOfflineTracing = false;
        LOGGER.startOperation(offlineTrace$iv, "offline_mode_trace");
        Object object = this_$iv;
        try {
            PaymentIntent paymentIntent3;
            Object object2;
            $this$executeWithOfflineTracing_u24lambda_u2413$iv = (OfflineDirectResourceRepository)object;
            boolean bl = false;
            boolean bl2 = false;
            TlvMap parsedEmvData = null;
            RestRequest<ConfirmPaymentIntentRequest, ConfirmPaymentIntentRequest.Builder> confirmRequest = null;
            String authResponseCode = null;
            try {
                this.validatePaymentIntent(paymentIntent2);
                confirmRequest = this.buildConfirmPaymentIntentRequest(paymentIntent2, getCollectiblePayment);
                object2 = this.validatePaymentMethod(confirmRequest.getBody().payment_method_data, paymentIntent2);
                TlvMap emvData = (TlvMap)object2.component1();
                String readMethod = (String)object2.component2();
                authResponseCode = this.getAuthorizationResponseCode(emvData, readMethod);
                parsedEmvData = emvData;
            }
            catch (TerminalException validationException) {
                this.emitHealthMetrics(validationException);
                this.sendAuthResponseCodeToDevice(paymentIntent2, 0L, "8A023035", handleAuthResponse, authStateListener, validationException.getErrorCode());
                throw validationException;
            }
            Long l2 = confirmRequest.getBody().amount_tip;
            this.sendAuthResponseCodeToDevice(paymentIntent2, l2 != null ? l2 : 0L, authResponseCode, handleAuthResponse, authStateListener, null);
            if (authResponseCode != "8A023030") {
                paymentIntent2.setPaymentMethodData((PaymentMethodData)collectScaPaymentMethodData.invoke());
                paymentIntent3 = this.processPayment(paymentIntent2, getCollectiblePayment, handleAuthResponse, collectScaPaymentMethodData, immediateRecollectForSca, authStateListener);
            } else {
                object2 = this.offlineEventHandler;
                Map map2 = MapsKt.plus((Map)MapsKt.plus(confirmRequest.getHeaders(), this.offlineRequestHelper.getHeaders(confirmRequest.getBody())), this.customHeadersProvider.customHeaders());
                List<Pair<String, String>> list = this.offlineRequestHelper.getBody(confirmRequest.getBody());
                String string = this.offlineRequestHelper.getUrl(confirmRequest.getBody());
                ConfirmPaymentIntentRequest confirmPaymentIntentRequest = confirmRequest.getBody();
                String string2 = parsedEmvData.toBlob();
                paymentIntent3 = object2.onConfirmPaymentIntentRequest(paymentIntent2, string2, confirmPaymentIntentRequest, map2, list, string);
            }
            $this$executeWithOfflineTracing_u24lambda_u2413$iv = Result.constructor-impl((Object)paymentIntent3);
        }
        catch (Throwable bl) {
            $this$executeWithOfflineTracing_u24lambda_u2413$iv = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$executeWithOfflineTracing_u24lambda_u2413$iv;
        if (Result.isSuccess-impl((Object)object)) {
            Object it$iv = object;
            boolean bl = false;
            LOGGER.endOperation(ApplicationTraceResult.Companion.success(), "offline_mode_trace");
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable throwable2;
            Throwable e$iv = throwable2 = throwable;
            boolean bl = false;
            LOGGER.e(e$iv);
            LOGGER.endOperation(ApplicationTraceResult.Companion.failure(e$iv), "offline_mode_trace");
        }
        ResultKt.throwOnFailure((Object)object);
        return (PaymentIntent)object;
    }

    @Override
    @NotNull
    public SetupIntent confirmSetupIntent(@NotNull SetupIntent intent, @Nullable CollectiblePayment collectiblePayment, @NotNull Function1<? super String, ? extends Deferred<TransactionResult>> handleAuthResponse, boolean immediateRecollectForSca, @NotNull OnlineAuthStateListener authStateListener) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter(handleAuthResponse, (String)"handleAuthResponse");
        Intrinsics.checkNotNullParameter((Object)authStateListener, (String)"authStateListener");
        throw this.getUnsupportedOpException("confirmSetupIntent");
    }

    @Override
    @NotNull
    public PaymentIntent cancelPaymentIntent(@NotNull PaymentIntent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        throw this.getUnsupportedOpException("cancelPaymentIntent");
    }

    @Override
    @NotNull
    public SetupIntent cancelSetupIntent(@NotNull SetupIntent intent, @NotNull SetupIntentCancellationParameters params) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        throw this.getUnsupportedOpException("cancelSetupIntent");
    }

    @Override
    @NotNull
    public PaymentMethod readReusableCard(@NotNull ReadReusableCardParameters readReusableCardParams, @NotNull PaymentMethodData paymentMethodData) {
        Intrinsics.checkNotNullParameter((Object)readReusableCardParams, (String)"readReusableCardParams");
        Intrinsics.checkNotNullParameter((Object)paymentMethodData, (String)"paymentMethodData");
        throw this.getUnsupportedOpException("createCardPaymentMethod");
    }

    private final TerminalException getUnsupportedOpException(String name) {
        return new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_OPERATION, name + " is not supported in offline mode.", null, null, 12, null);
    }

    @Override
    @NotNull
    public Map<String, Location> getReaderLocations(@NotNull List<String> deviceSerials) {
        Object object;
        Intrinsics.checkNotNullParameter(deviceSerials, (String)"deviceSerials");
        Object object2 = this;
        try {
            OfflineDirectResourceRepository $this$getReaderLocations_u24lambda_u244 = object2;
            boolean bl = false;
            object = Result.constructor-impl($this$getReaderLocations_u24lambda_u244.offlineEventHandler.onLocationsRequests(deviceSerials));
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object e2 = object = throwable;
            boolean bl = false;
            if (!(e2 instanceof TerminalException) || ((TerminalException)((Object)e2)).getErrorCode() != TerminalException.TerminalErrorCode.OFFLINE_MODE_UNSUPPORTED_ANDROID_VERSION) {
                LOGGER.w((Throwable)e2, "Failed to fetch saved locations", new Pair[0]);
            }
        }
        object = MapsKt.emptyMap();
        return (Map)(Result.isFailure-impl((Object)object2) ? object : object2);
    }

    private final RestRequest<ConfirmPaymentIntentRequest, ConfirmPaymentIntentRequest.Builder> buildConfirmPaymentIntentRequest(PaymentIntent paymentIntent2, Function0<CollectiblePayment> getCollectiblePayment) {
        Object object;
        block5: {
            Amount amountTip;
            block4: {
                amountTip = this.transactionRepository.getAmountTip();
                object = (CollectiblePayment)getCollectiblePayment.invoke();
                if (object == null || (object = ((CollectiblePayment)object).getPayment()) == null) break block4;
                RestRequest<ConfirmPaymentIntentRequest, ConfirmPaymentIntentRequest.Builder> it = object;
                boolean bl = false;
                RestRequest<ConfirmPaymentIntentRequest, ConfirmPaymentIntentRequest.Builder> restRequest = this.apiRequestFactory.confirmCollectiblePayment(paymentIntent2, ((Payment)((Object)it)).asRest(), amountTip);
                object = restRequest;
                if (restRequest != null) break block5;
            }
            OfflineDirectResourceRepository $this$buildConfirmPaymentIntentRequest_u24lambda_u247 = this;
            boolean bl = false;
            LOGGER.w("Collectible payment is null in processPayment.", new Pair[0]);
            Reader reader = $this$buildConfirmPaymentIntentRequest_u24lambda_u247.statusManager.getConnectedReader();
            object = $this$buildConfirmPaymentIntentRequest_u24lambda_u247.apiRequestFactory.confirmPaymentIntent(paymentIntent2, reader != null ? reader.getId() : null, amountTip);
        }
        RestRequest<ConfirmPaymentIntentRequest, ConfirmPaymentIntentRequest.Builder> confirmRequest = object;
        if (this.offlineConfigHelper.isDeferredAuthorizationCountry()) {
            Message message;
            RequestedPaymentMethod requestedPaymentMethod = confirmRequest.getBody().payment_method_data;
            return RestRequest.copy$default(confirmRequest, ConfirmPaymentIntentRequest.copy$default(confirmRequest.getBody(), null, null, requestedPaymentMethod != null ? RequestedPaymentMethod.copy$default(requestedPaymentMethod, null, (message = confirmRequest.getBody().payment_method_data) != null && (message = message.card_present) != null ? RequestedPaymentMethod.RequestedCardPresent.copy$default((RequestedPaymentMethod.RequestedCardPresent)message, null, null, null, null, EmvProcessingMethod.QUICK_CHIP.getMethod(), null, null, null, null, null, null, null, null, null, null, 32751, null) : null, null, null, null, null, 61, null) : null, null, null, null, null, null, 251, null), null, 2, null);
        }
        return confirmRequest;
    }

    private final void validatePaymentIntent(PaymentIntent intent) {
        if (intent.getOfflineBehavior() == OfflineBehavior.REQUIRE_ONLINE) {
            throw new TerminalException(TerminalException.TerminalErrorCode.NOT_CONNECTED_TO_INTERNET_AND_REQUIRE_ONLINE_SET, "provided payment intent cannot be processed in offline mode, allowedOffline is false", null, null, 12, null);
        }
        if (intent.getStatus() == PaymentIntentStatus.REQUIRES_CAPTURE) {
            throw new TerminalException(TerminalException.TerminalErrorCode.PROCESS_INVALID_PAYMENT_INTENT, "Provided payment intent already has requires_capture status and cannot be processed again.", null, null, 12, null);
        }
    }

    private final Pair<TlvMap, String> validatePaymentMethod(RequestedPaymentMethod paymentMethod, PaymentIntent intent) throws TerminalException {
        if (paymentMethod == null) {
            throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Payment method data must not be null.", null, null, 12, null);
        }
        if (Intrinsics.areEqual((Object)paymentMethod.type, (Object)PaymentMethodType.INTERAC_PRESENT.getTypeName())) {
            throw new TerminalException(TerminalException.TerminalErrorCode.INTERAC_NOT_SUPPORTED_OFFLINE, "Interac payments are not supported offline.", null, null, 12, null);
        }
        RequestedPaymentMethod.RequestedCardPresent requestedCardPresent = paymentMethod.card_present;
        if (requestedCardPresent == null) {
            throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Card present data must not be null.", null, null, 12, null);
        }
        RequestedPaymentMethod.RequestedCardPresent cardPresent = requestedCardPresent;
        if (CollectionsKt.contains((Iterable)MAGSTRIPE_READ_METHODS, (Object)cardPresent.read_method)) {
            throw new TerminalException(TerminalException.TerminalErrorCode.CARD_SWIPE_NOT_AVAILABLE, "Payments collected by swipe cannot be processed offline.", null, null, 12, null);
        }
        if (this.statusManager.getConnectedReader() == null) {
            throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Connected reader must not be null.", null, null, 12, null);
        }
        String string = cardPresent.emv_data;
        if (string == null) {
            throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Emv Data must not be null.", null, null, 12, null);
        }
        String emvData = string;
        TlvMap tlvMap = TlvMap.Companion.toTlvMap(emvData);
        if (tlvMap == null) {
            throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Failed to parse EMV data.", null, null, 12, null);
        }
        TlvMap emvTlvMap = tlvMap;
        if (emvTlvMap.getSize() == 0) {
            throw new TerminalException(TerminalException.TerminalErrorCode.MISSING_EMV_DATA, "Failed to read EMV data from presented payment method.", null, null, 12, null);
        }
        if (this.isOnlinePINCvm(emvTlvMap)) {
            throw new TerminalException(TerminalException.TerminalErrorCode.ONLINE_PIN_NOT_SUPPORTED_OFFLINE, "Payments collected with an online PIN cannot be processed offline.", null, null, 12, null);
        }
        if (intent.getLivemode() && this.isCardExpired(emvTlvMap)) {
            throw new TerminalException(TerminalException.TerminalErrorCode.OFFLINE_AND_CARD_EXPIRED, "Card expired.", null, null, 12, null);
        }
        String string2 = emvTlvMap.get("95");
        if (string2 == null) {
            throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, TVR_MISSING_ERROR_MESSAGE, null, null, 12, null);
        }
        String tvrHex = string2;
        if (!this.offlineConfigHelper.shouldAllowOfflineTransaction(tvrHex)) {
            throw new TerminalException(TerminalException.TerminalErrorCode.OFFLINE_TRANSACTION_DECLINED, "Card verification failed.", null, null, 12, null);
        }
        if (this.offlineConfigHelper.isDeferredAuthorizationCountry() && !OfflineAdapterKt.collectedOffline(intent)) {
            throw new TerminalException(TerminalException.TerminalErrorCode.OFFLINE_COLLECT_AND_PROCESS_MISMATCH, "Payment was collected online and cannot be processed offline. Please retry the payment.", null, null, 12, null);
        }
        return new Pair((Object)emvTlvMap, (Object)cardPresent.read_method);
    }

    private final String getAuthorizationResponseCode(TlvMap parsedEmvData, String readMethod) {
        if (this.offlineConfigHelper.supportsSca() && Intrinsics.areEqual((Object)readMethod, (Object)ReadMethod.CONTACTLESS_EMV.getMethod()) && !parsedEmvData.isMobileWallet()) {
            Object object = parsedEmvData.getApplicationId();
            if ((object == null || (object = object.getId()) == null) && (object = parsedEmvData.get("9F06")) == null) {
                OfflineDirectResourceRepository it = this;
                boolean bl = false;
                throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, AID_MISSING_ERROR_MESSAGE, null, null, 12, null);
            }
            Object applicationId = object;
            String switchInterfaceAuthResponseCode = this.offlineConfigHelper.switchInterfaceAuthorizationResponseCodeForAid((String)applicationId);
            if (switchInterfaceAuthResponseCode != null) {
                String it = switchInterfaceAuthResponseCode;
                boolean bl = false;
                return it;
            }
            OfflineDirectResourceRepository it = this;
            boolean bl = false;
            HealthLogger.incrementCounter$default(this.offlineDiscreteLogger, null, null, null, getAuthorizationResponseCode.2.1.INSTANCE, 7, null);
            LOGGER.w("Attempted to force SCA flow for unrecognized AID: " + (String)applicationId + ". Succeeding transaction.", new Pair[0]);
            return "8A023030";
        }
        return "8A023030";
    }

    private final boolean isOnlinePINCvm(TlvMap emvTlvMap) {
        boolean bl;
        String string = emvTlvMap.getCardholderVerificationMethod();
        if (string != null) {
            String cvm = string;
            boolean bl2 = false;
            bl = CvmType.Companion.fromStatus(cvm) == CvmType.ONLINE_ENCIPHERED_PIN;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isCardExpired(TlvMap tlvMap) {
        TlvMap $this$isCardExpired_u24lambda_u2412 = tlvMap;
        boolean bl = false;
        String expirationDate = $this$isCardExpired_u24lambda_u2412.get("5F24");
        String transactionDate = $this$isCardExpired_u24lambda_u2412.get("9A");
        if (expirationDate == null || transactionDate == null) {
            LOGGER.w("Unable to determine whether card expired due to missing date tags. Expiration date: " + expirationDate + ". Transaction date: " + transactionDate, new Pair[0]);
            HealthLogger.incrementCounter$default(this.offlineDiscreteLogger, null, null, null, isCardExpired.1.1.INSTANCE, 7, null);
            return false;
        }
        return Integer.parseInt(expirationDate, CharsKt.checkRadix((int)10)) < Integer.parseInt(transactionDate, CharsKt.checkRadix((int)10));
    }

    private final /* synthetic */ <T> T executeWithOfflineTracing(OfflineTrace offlineTrace, Function0<? extends T> operation) {
        Object $this$executeWithOfflineTracing_u24lambda_u2413;
        boolean $i$f$executeWithOfflineTracing = false;
        LOGGER.startOperation(offlineTrace, "offline_mode_trace");
        Object object = this;
        try {
            $this$executeWithOfflineTracing_u24lambda_u2413 = object;
            boolean bl = false;
            $this$executeWithOfflineTracing_u24lambda_u2413 = Result.constructor-impl((Object)operation.invoke());
        }
        catch (Throwable bl) {
            $this$executeWithOfflineTracing_u24lambda_u2413 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$executeWithOfflineTracing_u24lambda_u2413;
        if (Result.isSuccess-impl((Object)object)) {
            Object it = object;
            boolean bl = false;
            LOGGER.endOperation(ApplicationTraceResult.Companion.success(), "offline_mode_trace");
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable throwable2;
            Throwable e2 = throwable2 = throwable;
            boolean bl = false;
            LOGGER.e(e2);
            LOGGER.endOperation(ApplicationTraceResult.Companion.failure(e2), "offline_mode_trace");
        }
        ResultKt.throwOnFailure((Object)object);
        return (T)object;
    }

    private final void emitHealthMetrics(TerminalException error) {
        block11: {
            String declineReason;
            String string;
            switch (WhenMappings.$EnumSwitchMapping$0[error.getErrorCode().ordinal()]) {
                case 1: {
                    string = "interac_not_supported";
                    break;
                }
                case 2: {
                    string = "swipe_not_available";
                    break;
                }
                case 3: {
                    string = "online_pin_not_supported";
                    break;
                }
                case 4: {
                    string = "card_is_expired";
                    break;
                }
                case 5: {
                    String string2 = error.getErrorMessage();
                    if (Intrinsics.areEqual((Object)string2, (Object)TVR_MISSING_ERROR_MESSAGE)) {
                        string = "tvr_is_missing";
                        break;
                    }
                    if (Intrinsics.areEqual((Object)string2, (Object)AID_MISSING_ERROR_MESSAGE)) {
                        string = "missing_aid";
                        break;
                    }
                    string = null;
                    break;
                }
                case 6: {
                    string = "tvr_mask_failed";
                    break;
                }
                case 7: {
                    string = "started_online_and_is_now_offline";
                    break;
                }
                default: {
                    string = null;
                }
            }
            String string3 = declineReason = string;
            if (string3 == null) break block11;
            String declineReason2 = string3;
            boolean bl = false;
            HealthLogger.incrementCounter$default(this.offlineDiscreteLogger, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"DeclineReason", (Object)declineReason2)), null, emitHealthMetrics.1.1.INSTANCE, 5, null);
        }
    }

    private final void sendAuthResponseCodeToDevice(PaymentIntent intent, long tipAmount, String authResponseCode, Function1<? super String, ? extends Deferred<TransactionResult>> handleAuthResponse, OnlineAuthStateListener authStateListener, TerminalException.TerminalErrorCode declineCode) {
        OnlineAuthState onlineAuthState = null;
        ChargeAttempt chargeAttempt = null;
        String string = authResponseCode;
        if (Intrinsics.areEqual((Object)string, (Object)"8A023030")) {
            long l2 = intent.getAmount() + tipAmount;
            String string2 = intent.getCurrency();
            if (string2 == null) {
                string2 = "";
            }
            chargeAttempt = new ChargeAttempt.CompletedAttempt.SuccessfulCharge("", "", new Amount(l2, string2));
            onlineAuthState = new OnlineAuthState.ConfirmationResponseReceived.Success("8A023030", chargeAttempt);
        } else if (Intrinsics.areEqual((Object)string, (Object)"8A023035")) {
            chargeAttempt = new ChargeAttempt.CompletedAttempt.DeclinedCharge(String.valueOf(declineCode));
            onlineAuthState = new OnlineAuthState.ConfirmationResponseReceived.Failed(OnlineAuthFailureReason.DECLINED, "8A023035", chargeAttempt);
        } else {
            String string3;
            String it = string3 = intent.getId();
            boolean bl = false;
            String string4 = ((CharSequence)it).length() > 0 ? string3 : null;
            if (string4 == null && (string4 = OfflineAdapterKt.offlineId(intent)) == null) {
                throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Payment intent should always have ID or offline ID.", null, null, 12, null);
            }
            String intentId = string4;
            chargeAttempt = new ChargeAttempt.ExtendedAttempt(intentId, ChargeAttempt.ExtendedAttempt.Requirement.OFFLINE_PIN_REQUIRED);
            onlineAuthState = new OnlineAuthState.ConfirmationResponseReceived.Failed(OnlineAuthFailureReason.SCA_NEEDED, authResponseCode, chargeAttempt);
        }
        handleAuthResponse.invoke((Object)authResponseCode);
        this.chargeAttemptManager.setChargeAttempt(chargeAttempt);
        authStateListener.onOnlineAuthStateChanged(onlineAuthState);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        LOGGER = Log.Companion.getLogger(OfflineDirectResourceRepository.class);
        Object[] objectArray = new ReadMethod[]{ReadMethod.MAGNETIC_STRIPE_TRACK_2, ReadMethod.MAGNETIC_STRIPE_FALLBACK};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ReadMethod readMethod = (ReadMethod)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getMethod());
        }
        MAGSTRIPE_READ_METHODS = CollectionsKt.toSet((Iterable)((List)var3_3));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/stripeterminal/internal/common/resourcerepository/OfflineDirectResourceRepository$Companion;", "", "()V", "AID_MISSING_ERROR_MESSAGE", "", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "MAGSTRIPE_READ_METHODS", "", "TVR_MISSING_ERROR_MESSAGE", "resourcerepository_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TerminalException.TerminalErrorCode.values().length];
            try {
                nArray[TerminalException.TerminalErrorCode.INTERAC_NOT_SUPPORTED_OFFLINE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TerminalException.TerminalErrorCode.CARD_SWIPE_NOT_AVAILABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TerminalException.TerminalErrorCode.ONLINE_PIN_NOT_SUPPORTED_OFFLINE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TerminalException.TerminalErrorCode.OFFLINE_AND_CARD_EXPIRED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TerminalException.TerminalErrorCode.OFFLINE_TRANSACTION_DECLINED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TerminalException.TerminalErrorCode.OFFLINE_COLLECT_AND_PROCESS_MISMATCH.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

