/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.resourcerepository;

import com.squareup.wire.Message;
import com.stripe.core.transaction.ConfirmRefundParams;
import com.stripe.core.transaction.TransactionRepository;
import com.stripe.core.transaction.payment.TraditionalEmvManager;
import com.stripe.jvmcore.currency.Amount;
import com.stripe.jvmcore.hardware.emv.InterfaceType;
import com.stripe.jvmcore.hardware.emv.TransactionResult;
import com.stripe.jvmcore.hardware.emv.TransactionType;
import com.stripe.jvmcore.logging.HealthLogger;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.logwriter.LogWriter;
import com.stripe.jvmcore.paymentcollection.OnlineAuthFailureReason;
import com.stripe.jvmcore.paymentcollection.OnlineAuthState;
import com.stripe.jvmcore.paymentcollection.OnlineAuthStateListener;
import com.stripe.jvmcore.restclient.AuthenticatedRestClient;
import com.stripe.jvmcore.restclient.IdempotencyGenerator;
import com.stripe.jvmcore.restclient.IdempotencyHeader;
import com.stripe.jvmcore.restclient.IntegrationType;
import com.stripe.jvmcore.restclient.RestRequest;
import com.stripe.jvmcore.restclient.RestResponse;
import com.stripe.jvmcore.restclient.RestTimeout;
import com.stripe.jvmcore.terminal.api.ActivateReaderResponse;
import com.stripe.jvmcore.transaction.ChargeAttempt;
import com.stripe.jvmcore.transaction.ChargeAttemptManager;
import com.stripe.jvmcore.transaction.CollectiblePayment;
import com.stripe.jvmcore.transaction.Extensions;
import com.stripe.jvmcore.transaction.payment.ManualEntryPayment;
import com.stripe.jvmcore.transaction.payment.Payment;
import com.stripe.offlinemode.helpers.OfflineConfigHelper;
import com.stripe.proto.api.rest.AddEmvSecondGenerationDataRefundRequest;
import com.stripe.proto.api.rest.AddEmvSecondGenerationDataRequest;
import com.stripe.proto.api.rest.ConfirmPaymentIntentRequest;
import com.stripe.proto.api.rest.ConfirmSetupIntentRequest;
import com.stripe.proto.api.rest.RefundChargeRequest;
import com.stripe.proto.api.rest.RequestedPaymentMethod;
import com.stripe.proto.api.rest.RetrievePaymentIntentRequest;
import com.stripe.proto.model.rest.ErrorResponse;
import com.stripe.proto.model.rest.ErrorWrapper;
import com.stripe.proto.model.rest.Method;
import com.stripe.proto.model.rest.SetupIntent;
import com.stripe.proto.model.rest.StatusCode;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.offline.DiscreteScope;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.offline.OfflineDomain;
import com.stripe.stripeterminal.external.models.ConnectionConfiguration;
import com.stripe.stripeterminal.external.models.CreateConfiguration;
import com.stripe.stripeterminal.external.models.Location;
import com.stripe.stripeterminal.external.models.OfflineBehavior;
import com.stripe.stripeterminal.external.models.PaymentIntent;
import com.stripe.stripeterminal.external.models.PaymentIntentParameters;
import com.stripe.stripeterminal.external.models.PaymentIntentStatus;
import com.stripe.stripeterminal.external.models.PaymentMethod;
import com.stripe.stripeterminal.external.models.PaymentMethodType;
import com.stripe.stripeterminal.external.models.ReadReusableCardParameters;
import com.stripe.stripeterminal.external.models.Reader;
import com.stripe.stripeterminal.external.models.Refund;
import com.stripe.stripeterminal.external.models.RefundParameters;
import com.stripe.stripeterminal.external.models.SetupIntentCancellationParameters;
import com.stripe.stripeterminal.external.models.SetupIntentParameters;
import com.stripe.stripeterminal.external.models.TerminalException;
import com.stripe.stripeterminal.internal.common.TerminalStatusManager;
import com.stripe.stripeterminal.internal.common.adapter.OfflineAdapterKt;
import com.stripe.stripeterminal.internal.common.api.ApiClient;
import com.stripe.stripeterminal.internal.common.api.ApiRequestFactory;
import com.stripe.stripeterminal.internal.common.api.DiscoverLocationsResponse;
import com.stripe.stripeterminal.internal.common.makers.ReaderMaker;
import com.stripe.stripeterminal.internal.common.proto.ProtoConverter;
import com.stripe.stripeterminal.internal.common.resourcerepository.CombinedRefundParams;
import com.stripe.stripeterminal.internal.common.resourcerepository.OnlineDirectResourceRepository;
import com.stripe.stripeterminal.internal.common.resourcerepository.ResourceRepository;
import com.stripe.stripeterminal.internal.common.tokenrepositories.ConnectionTokenRepository;
import com.stripe.stripeterminal.internal.models.PaymentMethodData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0084\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u0092\u00012\u00020\u0001:\u0002\u0092\u0001Bs\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\"\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0013j\u0002`\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001bJ\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J,\u0010(\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+0)2\u0016\u0010,\u001a\u0012\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/0-j\u0002`0H\u0002J0\u00101\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020+0)2\u0006\u0010,\u001a\u0002032\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020605H\u0002J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u000208H\u0016J\u0018\u0010:\u001a\u00020;2\u0006\u00109\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0016JZ\u0010>\u001a\u0010\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+\u0018\u00010)2\u0006\u0010?\u001a\u0002082\u0006\u0010@\u001a\u00020A2\u0018\u0010B\u001a\u0014\u0012\u0004\u0012\u000206\u0012\n\u0012\b\u0012\u0004\u0012\u00020E0D0C2\b\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020KH\u0002JD\u0010L\u001a\u00020;2\u0006\u00109\u001a\u00020;2\b\u0010@\u001a\u0004\u0018\u00010A2\u0018\u0010B\u001a\u0014\u0012\u0004\u0012\u000206\u0012\n\u0012\b\u0012\u0004\u0012\u00020E0D0C2\u0006\u0010M\u001a\u00020\u001f2\u0006\u0010H\u001a\u00020IH\u0016JN\u0010L\u001a\u000e\u0012\u0004\u0012\u00020N\u0012\u0004\u0012\u00020+0)2\u0006\u00109\u001a\u00020;2\u0006\u0010O\u001a\u00020P2\u0018\u0010B\u001a\u0014\u0012\u0004\u0012\u000206\u0012\n\u0012\b\u0012\u0004\u0012\u00020E0D0C2\u0006\u0010@\u001a\u00020A2\u0006\u0010H\u001a\u00020IH\u0002J\u0018\u0010Q\u001a\u0002082\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020UH\u0016J\u0010\u0010V\u001a\u00020;2\u0006\u0010W\u001a\u00020XH\u0016J\"\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020\\2\b\u0010]\u001a\u0004\u0018\u0001062\u0006\u0010^\u001a\u00020\u001fH\u0002J\"\u0010_\u001a\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020`052\f\u0010a\u001a\b\u0012\u0004\u0012\u0002060bH\u0016J\u0010\u0010c\u001a\u00020d2\u0006\u0010[\u001a\u00020\\H\u0002J:\u0010e\u001a\u00020f2\u0006\u0010H\u001a\u00020I2\u0006\u0010[\u001a\u00020\\2\u0018\u0010B\u001a\u0014\u0012\u0004\u0012\u000206\u0012\n\u0012\b\u0012\u0004\u0012\u00020E0D0C2\u0006\u0010g\u001a\u000206H\u0002J\u001c\u0010h\u001a\u00020\u001f2\u0012\u0010i\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+0)H\u0002JX\u0010j\u001a\u0002082\u0006\u0010?\u001a\u0002082\u000e\u0010k\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010A0l2\u0018\u0010B\u001a\u0014\u0012\u0004\u0012\u000206\u0012\n\u0012\b\u0012\u0004\u0012\u00020E0D0C2\f\u0010m\u001a\b\u0012\u0004\u0012\u00020n0l2\u0006\u0010M\u001a\u00020\u001f2\u0006\u0010H\u001a\u00020IH\u0016J<\u0010o\u001a\u00020p2\u0006\u0010q\u001a\u00020r2\b\u0010@\u001a\u0004\u0018\u00010A2\u0018\u0010B\u001a\u0014\u0012\u0004\u0012\u000206\u0012\n\u0012\b\u0012\u0004\u0012\u00020E0D0C2\u0006\u0010H\u001a\u00020IH\u0016J\u0018\u0010s\u001a\u00020t2\u0006\u0010u\u001a\u00020v2\u0006\u0010w\u001a\u00020nH\u0016JT\u0010x\u001a\u00020\u001f\"\u0012\b\u0000\u0010y*\f\u0012\u0004\u0012\u0002Hy\u0012\u0002\b\u00030z\"\u0012\b\u0001\u0010{*\f\u0012\u0004\u0012\u0002H{\u0012\u0002\b\u00030z2\u0012\u0010i\u001a\u000e\u0012\u0004\u0012\u0002Hy\u0012\u0004\u0012\u0002H{0)2\u0006\u0010[\u001a\u00020\\2\u0006\u0010M\u001a\u00020\u001fH\u0002JN\u0010|\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020+0)2\u0006\u0010q\u001a\u00020}2\u0006\u0010O\u001a\u00020P2\u0006\u0010~\u001a\u00020\u007f2\u0018\u0010B\u001a\u0014\u0012\u0004\u0012\u000206\u0012\n\u0012\b\u0012\u0004\u0012\u00020E0D0C2\u0006\u0010H\u001a\u00020IH\u0002JH\u0010\u0080\u0001\u001a\u000f\u0012\u0005\u0012\u0003H\u0081\u0001\u0012\u0004\u0012\u00020+0)\"\u0014\b\u0000\u0010\u0081\u0001*\r\u0012\u0005\u0012\u0003H\u0081\u0001\u0012\u0002\b\u00030z2\u001a\u0010\u0082\u0001\u001a\u0015\u0012\u0011\u0012\u000f\u0012\u0005\u0012\u0003H\u0081\u0001\u0012\u0004\u0012\u00020+0)0lH\u0002Jg\u0010\u0083\u0001\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+0)2\u0006\u0010?\u001a\u0002082\u0012\u0010i\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+0)2\u0006\u0010@\u001a\u00020A2\u0018\u0010B\u001a\u0014\u0012\u0004\u0012\u000206\u0012\n\u0012\b\u0012\u0004\u0012\u00020E0D0C2\u0006\u0010H\u001a\u00020I2\n\u0010\u0084\u0001\u001a\u0005\u0018\u00010\u0085\u0001H\u0002JU\u0010\u0086\u0001\u001a\u000e\u0012\u0004\u0012\u00020N\u0012\u0004\u0012\u00020+0)2\u0013\u0010\u0087\u0001\u001a\u000e\u0012\u0004\u0012\u00020N\u0012\u0004\u0012\u00020+0)2\u0018\u0010B\u001a\u0014\u0012\u0004\u0012\u000206\u0012\n\u0012\b\u0012\u0004\u0012\u00020E0D0C2\u0007\u0010\u0088\u0001\u001a\u00020\u001f2\u0006\u0010H\u001a\u00020IH\u0002J\u0011\u0010\u0089\u0001\u001a\u00020\u001f2\u0006\u0010@\u001a\u00020AH\u0002J\u0011\u0010\u008a\u0001\u001a\u0002082\u0006\u0010?\u001a\u000208H\u0016J\u001d\u0010\u008b\u0001\u001a\u00020}2\u0006\u0010q\u001a\u00020r2\n\u0010\u008c\u0001\u001a\u0005\u0018\u00010\u008d\u0001H\u0002J\u0018\u0010\u008e\u0001\u001a\u00020K*\u00020\u00112\t\u0010\u008f\u0001\u001a\u0004\u0018\u000106H\u0002J\u0016\u0010\u0090\u0001\u001a\u00020K*\u00020\u00112\u0007\u0010\u0091\u0001\u001a\u00020\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0013j\u0002`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0093\u0001"}, d2={"Lcom/stripe/stripeterminal/internal/common/resourcerepository/OnlineDirectResourceRepository;", "Lcom/stripe/stripeterminal/internal/common/resourcerepository/ResourceRepository;", "apiClient", "Lcom/stripe/stripeterminal/internal/common/api/ApiClient;", "chargeAttemptManager", "Lcom/stripe/jvmcore/transaction/ChargeAttemptManager;", "statusManager", "Lcom/stripe/stripeterminal/internal/common/TerminalStatusManager;", "transactionRepository", "Lcom/stripe/core/transaction/TransactionRepository;", "connectionTokenRepository", "Lcom/stripe/stripeterminal/internal/common/tokenrepositories/ConnectionTokenRepository;", "apiRequestFactory", "Lcom/stripe/stripeterminal/internal/common/api/ApiRequestFactory;", "idempotencyGenerator", "Lcom/stripe/jvmcore/restclient/IdempotencyGenerator;", "offlineConfigHelper", "Lcom/stripe/offlinemode/helpers/OfflineConfigHelper;", "offlineDiscreteLogger", "Lcom/stripe/jvmcore/logging/HealthLogger;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/offline/OfflineDomain;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/offline/OfflineDomain$Builder;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/offline/DiscreteScope;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/offline/DiscreteScope$Builder;", "Lcom/stripe/offlinemode/log/OfflineDiscreteLogger;", "logWriter", "Lcom/stripe/jvmcore/logwriter/LogWriter;", "(Lcom/stripe/stripeterminal/internal/common/api/ApiClient;Lcom/stripe/jvmcore/transaction/ChargeAttemptManager;Lcom/stripe/stripeterminal/internal/common/TerminalStatusManager;Lcom/stripe/core/transaction/TransactionRepository;Lcom/stripe/stripeterminal/internal/common/tokenrepositories/ConnectionTokenRepository;Lcom/stripe/stripeterminal/internal/common/api/ApiRequestFactory;Lcom/stripe/jvmcore/restclient/IdempotencyGenerator;Lcom/stripe/offlinemode/helpers/OfflineConfigHelper;Lcom/stripe/jvmcore/logging/HealthLogger;Lcom/stripe/jvmcore/logwriter/LogWriter;)V", "idempotencyHeader", "Lcom/stripe/jvmcore/restclient/IdempotencyHeader;", "shouldSendAuthResponseToDevice", "", "getShouldSendAuthResponseToDevice", "()Z", "activateReader", "Lcom/stripe/jvmcore/terminal/api/ActivateReaderResponse;", "reader", "Lcom/stripe/stripeterminal/external/models/Reader;", "connectionConfiguration", "Lcom/stripe/stripeterminal/external/models/ConnectionConfiguration;", "addEmvSecondGenerationData", "Lcom/stripe/jvmcore/restclient/RestResponse;", "Lcom/stripe/proto/model/rest/PaymentIntent;", "Lcom/stripe/proto/model/rest/ErrorWrapper;", "request", "Lcom/stripe/jvmcore/restclient/RestRequest;", "Lcom/stripe/proto/api/rest/AddEmvSecondGenerationDataRequest;", "Lcom/stripe/proto/api/rest/AddEmvSecondGenerationDataRequest$Builder;", "Lcom/stripe/stripeterminal/internal/common/api/AddEmvSecondGenerationDataRestRequest;", "addEmvSecondGenerationRefundData", "Lcom/stripe/proto/model/rest/Refund;", "Lcom/stripe/proto/api/rest/AddEmvSecondGenerationDataRefundRequest;", "headers", "", "", "cancelPaymentIntent", "Lcom/stripe/stripeterminal/external/models/PaymentIntent;", "intent", "cancelSetupIntent", "Lcom/stripe/stripeterminal/external/models/SetupIntent;", "params", "Lcom/stripe/stripeterminal/external/models/SetupIntentCancellationParameters;", "confirmPaymentIntent", "paymentIntent", "collectiblePayment", "Lcom/stripe/jvmcore/transaction/CollectiblePayment;", "handleAuthResponse", "Lkotlin/Function1;", "Lkotlinx/coroutines/Deferred;", "Lcom/stripe/jvmcore/hardware/emv/TransactionResult;", "amountTip", "Lcom/stripe/jvmcore/currency/Amount;", "authStateListener", "Lcom/stripe/jvmcore/paymentcollection/OnlineAuthStateListener;", "timeout", "Lcom/stripe/jvmcore/restclient/RestTimeout;", "confirmSetupIntent", "immediateRecollectForSca", "Lcom/stripe/proto/model/rest/SetupIntent;", "paymentAsRest", "Lcom/stripe/proto/api/rest/RequestedPaymentMethod;", "createPaymentIntent", "paymentIntentParameters", "Lcom/stripe/stripeterminal/external/models/PaymentIntentParameters;", "createConfiguration", "Lcom/stripe/stripeterminal/external/models/CreateConfiguration;", "createSetupIntent", "setupIntentParameters", "Lcom/stripe/stripeterminal/external/models/SetupIntentParameters;", "getConfirmationResponseReceived", "Lcom/stripe/jvmcore/paymentcollection/OnlineAuthState$ConfirmationResponseReceived;", "chargeAttempt", "Lcom/stripe/jvmcore/transaction/ChargeAttempt;", "authResponse", "needSecondGenAc", "getReaderLocations", "Lcom/stripe/stripeterminal/external/models/Location;", "deviceSerials", "", "getSecondGenAcResponseReceived", "Lcom/stripe/jvmcore/paymentcollection/OnlineAuthState$SecondGenAcResponseReceived;", "handleConfirmationFailed", "", "authResponseTlv", "isNetworkError", "response", "processPayment", "getCollectiblePayment", "Lkotlin/Function0;", "collectScaPaymentMethodData", "Lcom/stripe/stripeterminal/internal/models/PaymentMethodData;", "processRefund", "Lcom/stripe/stripeterminal/external/models/Refund;", "refundParams", "Lcom/stripe/stripeterminal/external/models/RefundParameters;", "readReusableCard", "Lcom/stripe/stripeterminal/external/models/PaymentMethod;", "readReusableCardParams", "Lcom/stripe/stripeterminal/external/models/ReadReusableCardParameters;", "paymentMethodData", "recollectPaymentMethodNeeded", "S", "Lcom/squareup/wire/Message;", "E", "refundCharge", "Lcom/stripe/stripeterminal/internal/common/resourcerepository/CombinedRefundParams;", "interfaceType", "Lcom/stripe/jvmcore/hardware/emv/InterfaceType;", "retryableEmvSecondGenerationRequest", "M", "networkCall", "sendPaymentIntentAuthResponseToDevice", "authIntegrationType", "Lcom/stripe/jvmcore/restclient/IntegrationType;", "sendSetupIntentAuthResponseToDevice", "restResponse", "allowExtendedTransaction", "shouldFetch2ndGenAc", "updatePaymentIntent", "updateRefundParams", "confirmRefundParameters", "Lcom/stripe/core/transaction/ConfirmRefundParams;", "getTimeoutForActivate", "serialId", "getTimeoutForPayments", "preferOnline", "Companion", "resourcerepository_release"})
@SourceDebugExtension(value={"SMAP\nOnlineDirectResourceRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OnlineDirectResourceRepository.kt\ncom/stripe/stripeterminal/internal/common/resourcerepository/OnlineDirectResourceRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,917:1\n766#2:918\n857#2,2:919\n1360#2:921\n1446#2,2:922\n1549#2:924\n1620#2,3:925\n1448#2,3:928\n1179#2,2:931\n1253#2,4:933\n1#3:937\n*S KotlinDebug\n*F\n+ 1 OnlineDirectResourceRepository.kt\ncom/stripe/stripeterminal/internal/common/resourcerepository/OnlineDirectResourceRepository\n*L\n887#1:918\n887#1:919,2\n888#1:921\n888#1:922,2\n889#1:924\n889#1:925,3\n888#1:928,3\n893#1:931,2\n893#1:933,4\n*E\n"})
public final class OnlineDirectResourceRepository
implements ResourceRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ApiClient apiClient;
    @NotNull
    private final ChargeAttemptManager chargeAttemptManager;
    @NotNull
    private final TerminalStatusManager statusManager;
    @NotNull
    private final TransactionRepository transactionRepository;
    @NotNull
    private final ConnectionTokenRepository connectionTokenRepository;
    @NotNull
    private final ApiRequestFactory apiRequestFactory;
    @NotNull
    private final OfflineConfigHelper offlineConfigHelper;
    @NotNull
    private final HealthLogger<OfflineDomain, OfflineDomain.Builder, DiscreteScope, DiscreteScope.Builder> offlineDiscreteLogger;
    @NotNull
    private final LogWriter logWriter;
    @NotNull
    private final IdempotencyHeader idempotencyHeader;
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(OnlineDirectResourceRepository.class);
    @NotNull
    private static final List<String> serverProcessingErrors;

    @Inject
    public OnlineDirectResourceRepository(@NotNull ApiClient apiClient, @NotNull ChargeAttemptManager chargeAttemptManager, @NotNull TerminalStatusManager statusManager, @NotNull TransactionRepository transactionRepository, @NotNull ConnectionTokenRepository connectionTokenRepository, @NotNull ApiRequestFactory apiRequestFactory, @NotNull IdempotencyGenerator idempotencyGenerator, @NotNull OfflineConfigHelper offlineConfigHelper, @NotNull HealthLogger<OfflineDomain, OfflineDomain.Builder, DiscreteScope, DiscreteScope.Builder> offlineDiscreteLogger, @NotNull LogWriter logWriter) {
        Intrinsics.checkNotNullParameter((Object)apiClient, (String)"apiClient");
        Intrinsics.checkNotNullParameter((Object)chargeAttemptManager, (String)"chargeAttemptManager");
        Intrinsics.checkNotNullParameter((Object)statusManager, (String)"statusManager");
        Intrinsics.checkNotNullParameter((Object)transactionRepository, (String)"transactionRepository");
        Intrinsics.checkNotNullParameter((Object)connectionTokenRepository, (String)"connectionTokenRepository");
        Intrinsics.checkNotNullParameter((Object)apiRequestFactory, (String)"apiRequestFactory");
        Intrinsics.checkNotNullParameter((Object)idempotencyGenerator, (String)"idempotencyGenerator");
        Intrinsics.checkNotNullParameter((Object)offlineConfigHelper, (String)"offlineConfigHelper");
        Intrinsics.checkNotNullParameter(offlineDiscreteLogger, (String)"offlineDiscreteLogger");
        Intrinsics.checkNotNullParameter((Object)logWriter, (String)"logWriter");
        this.apiClient = apiClient;
        this.chargeAttemptManager = chargeAttemptManager;
        this.statusManager = statusManager;
        this.transactionRepository = transactionRepository;
        this.connectionTokenRepository = connectionTokenRepository;
        this.apiRequestFactory = apiRequestFactory;
        this.offlineConfigHelper = offlineConfigHelper;
        this.offlineDiscreteLogger = offlineDiscreteLogger;
        this.logWriter = logWriter;
        this.idempotencyHeader = new IdempotencyHeader(idempotencyGenerator);
    }

    private final boolean getShouldSendAuthResponseToDevice() {
        return this.transactionRepository.getSettings().getEmvTransactionType() == TransactionType.TRADITIONAL || !ReaderMaker.INSTANCE.toHardwareReader(this.statusManager.getConnectedReader()).getQuickEmvAutoResponse();
    }

    private final boolean shouldFetch2ndGenAc(CollectiblePayment collectiblePayment) {
        return this.transactionRepository.getSettings().getEmvTransactionType() == TransactionType.TRADITIONAL && collectiblePayment.getInterfaceType() == InterfaceType.CONTACT;
    }

    @Override
    @NotNull
    public ActivateReaderResponse activateReader(@NotNull Reader reader, @NotNull ConnectionConfiguration connectionConfiguration) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)connectionConfiguration, (String)"connectionConfiguration");
        LOGGER.d("activateReader", new Pair[0]);
        String connectionToken = this.connectionTokenRepository.getTokenAndRefresh();
        return this.apiClient.activateReader(reader, connectionToken, connectionConfiguration, this.getTimeoutForActivate(this.offlineConfigHelper, reader.getSerialNumber()));
    }

    @Override
    @NotNull
    public PaymentIntent createPaymentIntent(@NotNull PaymentIntentParameters paymentIntentParameters, @NotNull CreateConfiguration createConfiguration) {
        Intrinsics.checkNotNullParameter((Object)paymentIntentParameters, (String)"paymentIntentParameters");
        Intrinsics.checkNotNullParameter((Object)createConfiguration, (String)"createConfiguration");
        LOGGER.d("createPaymentIntent", new Pair[0]);
        return this.apiClient.createPaymentIntent(paymentIntentParameters, this.getTimeoutForPayments(this.offlineConfigHelper, createConfiguration.getOfflineBehavior() == OfflineBehavior.REQUIRE_ONLINE));
    }

    @Override
    @NotNull
    public com.stripe.stripeterminal.external.models.SetupIntent createSetupIntent(@NotNull SetupIntentParameters setupIntentParameters) {
        Intrinsics.checkNotNullParameter((Object)setupIntentParameters, (String)"setupIntentParameters");
        LOGGER.d("createSetupIntent", new Pair[0]);
        return this.apiClient.createSetupIntent(setupIntentParameters);
    }

    @Override
    @NotNull
    public Refund processRefund(@NotNull RefundParameters refundParams, @Nullable CollectiblePayment collectiblePayment, @NotNull Function1<? super String, ? extends Deferred<TransactionResult>> handleAuthResponse, @NotNull OnlineAuthStateListener authStateListener) {
        InterfaceType interfaceType;
        Intrinsics.checkNotNullParameter((Object)refundParams, (String)"refundParams");
        Intrinsics.checkNotNullParameter(handleAuthResponse, (String)"handleAuthResponse");
        Intrinsics.checkNotNullParameter((Object)authStateListener, (String)"authStateListener");
        Object object = collectiblePayment;
        RequestedPaymentMethod paymentAsRest = object != null && (object = ((CollectiblePayment)object).getPayment()) != null ? ((Payment)object).asRest() : null;
        CollectiblePayment collectiblePayment2 = collectiblePayment;
        InterfaceType interfaceType2 = interfaceType = collectiblePayment2 != null ? collectiblePayment2.getInterfaceType() : null;
        if (paymentAsRest == null || interfaceType == null) {
            throw new TerminalException(TerminalException.TerminalErrorCode.CARD_REMOVED, "Failed to retrieve payment method data", null, null, 12, null);
        }
        CombinedRefundParams combinedRefundParams = this.updateRefundParams(refundParams, this.transactionRepository.getRefundParams());
        authStateListener.onOnlineAuthStateChanged(OnlineAuthState.ConfirmationStarted.INSTANCE);
        RestResponse<com.stripe.proto.model.rest.Refund, ErrorWrapper> refundResponse = this.refundCharge(combinedRefundParams, paymentAsRest, interfaceType, handleAuthResponse, authStateListener);
        this.chargeAttemptManager.setChargeAttempt(Extensions.INSTANCE.toChargeAttemptForRefund(refundResponse, this.logWriter));
        return ProtoConverter.INSTANCE.toSdkRefund(ApiClient.Companion.decodeRefundResponseCatchingInlineFailure(refundResponse));
    }

    private final CombinedRefundParams updateRefundParams(RefundParameters refundParams, ConfirmRefundParams confirmRefundParameters) {
        CombinedRefundParams combinedRefundParams;
        ConfirmRefundParams confirmRefundParams = confirmRefundParameters;
        if (confirmRefundParams != null) {
            ConfirmRefundParams it = confirmRefundParams;
            boolean bl = false;
            combinedRefundParams = new CombinedRefundParams(refundParams.getChargeId(), refundParams.getAmount(), refundParams.getCurrency(), it.getMetadata(), it.getReverseTransfer(), it.getRefundApplicationFee(), it.getStripeAccountId());
        } else {
            combinedRefundParams = new CombinedRefundParams(refundParams.getChargeId(), refundParams.getAmount(), refundParams.getCurrency(), refundParams.getMetadata(), refundParams.getReverseTransfer(), refundParams.getRefundApplicationFee(), null);
        }
        return combinedRefundParams;
    }

    private final RestResponse<com.stripe.proto.model.rest.Refund, ErrorWrapper> refundCharge(CombinedRefundParams refundParams, RequestedPaymentMethod paymentAsRest, InterfaceType interfaceType, Function1<? super String, ? extends Deferred<TransactionResult>> handleAuthResponse, OnlineAuthStateListener authStateListener) {
        String string = refundParams.getChargeId();
        long l2 = refundParams.getAmount();
        boolean bl = refundParams.getReverseTransfer();
        boolean bl2 = refundParams.getRefundApplicationFee();
        String string2 = this.getDefaultRefundReason();
        Map map2 = refundParams.getMetadata();
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        RestRequest<RefundChargeRequest, RefundChargeRequest.Builder> request = this.apiRequestFactory.refundChargeRequest(string, l2, paymentAsRest, bl, bl2, string2, map2, refundParams.getStripeAccountId());
        IntegrationType refundIntegrationType = this.transactionRepository.getIntegrationType();
        RestResponse<com.stripe.proto.model.rest.Refund, ErrorWrapper> refundResponse = this.apiClient.getRestClient().refundCharge(request.getBody(), request.getHeaders());
        ChargeAttempt chargeAttempt = Extensions.INSTANCE.toChargeAttemptForRefund(refundResponse, this.logWriter);
        RestResponse<com.stripe.proto.model.rest.Refund, ErrorWrapper> restResponse = refundResponse;
        if (restResponse instanceof RestResponse.Success) {
            if (Extensions.INSTANCE.isSuccess((com.stripe.proto.model.rest.Refund)((Object)((RestResponse.Success)refundResponse).getResponse()))) {
                TransactionResult transactionResult2;
                String responseBlob = TraditionalEmvManager.Companion.authData(((com.stripe.proto.model.rest.Refund)((Object)((RestResponse.Success)refundResponse).getResponse())).payment_method_details, "8A023030");
                boolean needSecondGenAc = interfaceType == InterfaceType.CONTACT && Intrinsics.areEqual((Object)PaymentMethodType.INTERAC_PRESENT.getTypeName(), (Object)paymentAsRest.type);
                authStateListener.onOnlineAuthStateChanged(this.getConfirmationResponseReceived(chargeAttempt, responseBlob, needSecondGenAc));
                try {
                    transactionResult2 = (TransactionResult)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super TransactionResult>, Object>(handleAuthResponse, responseBlob, null){
                        int label;
                        final /* synthetic */ Function1<String, Deferred<TransactionResult>> $handleAuthResponse;
                        final /* synthetic */ String $responseBlob;
                        {
                            this.$handleAuthResponse = $handleAuthResponse;
                            this.$responseBlob = $responseBlob;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.label = 1;
                                    Object object3 = ((Deferred)this.$handleAuthResponse.invoke((Object)this.$responseBlob)).await((Continuation)this);
                                    if (object3 != object2) return object3;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return object3;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super TransactionResult> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)1, null);
                }
                catch (Exception e2) {
                    transactionResult2 = new TransactionResult(TransactionResult.Result.DEVICE_FAILURE, "");
                }
                TransactionResult result2 = transactionResult2;
                if (needSecondGenAc) {
                    IntegrationType currentIntegrationType = this.transactionRepository.getIntegrationType();
                    if (refundIntegrationType != currentIntegrationType) {
                        Pair[] e2 = new Pair[]{TuplesKt.to((Object)"previous", (Object)((Object)refundIntegrationType)), TuplesKt.to((Object)"current", (Object)((Object)currentIntegrationType))};
                        LOGGER.w("Skipping Refund 2nd Gen AC: Integration type changed after refund charge", e2);
                        return refundResponse;
                    }
                    RestRequest<AddEmvSecondGenerationDataRefundRequest, AddEmvSecondGenerationDataRefundRequest.Builder> secondRequest = this.apiRequestFactory.emvSecondGenerationDataRefundRequest(((com.stripe.proto.model.rest.Refund)((Object)((RestResponse.Success)refundResponse).getResponse())).id, result2, refundParams.getRefundApplicationFee(), refundParams.getReverseTransfer(), refundParams.getStripeAccountId());
                    authStateListener.onOnlineAuthStateChanged(OnlineAuthState.SecondGenAcStarted.INSTANCE);
                    RestResponse<com.stripe.proto.model.rest.Refund, ErrorWrapper> secondGenAcResponse = this.addEmvSecondGenerationRefundData(secondRequest.getBody(), secondRequest.getHeaders());
                    authStateListener.onOnlineAuthStateChanged(this.getSecondGenAcResponseReceived(Extensions.INSTANCE.toChargeAttemptForRefund(secondGenAcResponse, this.logWriter)));
                    return secondGenAcResponse;
                }
            } else {
                String authResponseTlv = "8A023035";
                this.handleConfirmationFailed(authStateListener, chargeAttempt, handleAuthResponse, authResponseTlv);
            }
        } else if (restResponse instanceof RestResponse.ServerError) {
            ErrorResponse errorResponse = ((ErrorWrapper)((Object)((RestResponse.ServerError)refundResponse).getResponse())).error;
            String authResponseTlv = CollectionsKt.contains((Iterable)serverProcessingErrors, (Object)(errorResponse != null ? errorResponse.code : null)) ? "8A023035" : "8A025A33";
            this.handleConfirmationFailed(authStateListener, chargeAttempt, handleAuthResponse, authResponseTlv);
        } else if (restResponse instanceof RestResponse.ParseError) {
            String authResponseTlv = "8A025A33";
            this.handleConfirmationFailed(authStateListener, chargeAttempt, handleAuthResponse, authResponseTlv);
        }
        return refundResponse;
    }

    @Override
    @NotNull
    public PaymentIntent updatePaymentIntent(@NotNull PaymentIntent paymentIntent2) {
        Intrinsics.checkNotNullParameter((Object)paymentIntent2, (String)"paymentIntent");
        return this.apiClient.updatePaymentIntentExpandMethod(paymentIntent2, this.statusManager.getConnectedReader(), this.transactionRepository.getAmountTip());
    }

    @Override
    @NotNull
    public PaymentIntent processPayment(@NotNull PaymentIntent paymentIntent2, @NotNull Function0<CollectiblePayment> getCollectiblePayment, @NotNull Function1<? super String, ? extends Deferred<TransactionResult>> handleAuthResponse, @NotNull Function0<PaymentMethodData> collectScaPaymentMethodData, boolean immediateRecollectForSca, @NotNull OnlineAuthStateListener authStateListener) {
        PaymentIntent paymentIntent3;
        Intrinsics.checkNotNullParameter((Object)paymentIntent2, (String)"paymentIntent");
        Intrinsics.checkNotNullParameter(getCollectiblePayment, (String)"getCollectiblePayment");
        Intrinsics.checkNotNullParameter(handleAuthResponse, (String)"handleAuthResponse");
        Intrinsics.checkNotNullParameter(collectScaPaymentMethodData, (String)"collectScaPaymentMethodData");
        Intrinsics.checkNotNullParameter((Object)authStateListener, (String)"authStateListener");
        Amount amountTip = this.transactionRepository.getAmountTip();
        RestTimeout timeout = this.getTimeoutForPayments(this.offlineConfigHelper, paymentIntent2.getOfflineBehavior() == OfflineBehavior.REQUIRE_ONLINE);
        CollectiblePayment collectiblePayment = (CollectiblePayment)getCollectiblePayment.invoke();
        if (collectiblePayment == null) {
            OnlineDirectResourceRepository $this$processPayment_u24lambda_u241 = this;
            boolean bl = false;
            LOGGER.w("Collectible payment is null in processPayment!", new Pair[0]);
            return $this$processPayment_u24lambda_u241.apiClient.confirmPaymentIntent(paymentIntent2, $this$processPayment_u24lambda_u241.statusManager.getConnectedReader(), amountTip, timeout);
        }
        CollectiblePayment collectiblePayment2 = collectiblePayment;
        authStateListener.onOnlineAuthStateChanged(OnlineAuthState.ConfirmationStarted.INSTANCE);
        RestResponse<com.stripe.proto.model.rest.PaymentIntent, ErrorWrapper> restResponse = this.confirmPaymentIntent(paymentIntent2, collectiblePayment2, handleAuthResponse, amountTip, authStateListener, timeout);
        if (restResponse == null) {
            throw new TerminalException(TerminalException.TerminalErrorCode.STRIPE_API_ERROR, "Failed to process payment", null, null, 12, null);
        }
        RestResponse<com.stripe.proto.model.rest.PaymentIntent, ErrorWrapper> response = restResponse;
        ChargeAttempt chargeAttempt = Extensions.INSTANCE.toChargeAttemptForPaymentIntent(response, collectiblePayment2.getTransactionSupportsSca(), this.logWriter);
        if (!this.offlineConfigHelper.isOfflineModeEnabled() || !this.isNetworkError(response)) {
            this.chargeAttemptManager.setChargeAttempt(chargeAttempt);
        }
        if (this.recollectPaymentMethodNeeded(response, chargeAttempt, immediateRecollectForSca)) {
            PaymentIntent paymentIntent4;
            PaymentIntent paymentIntent5;
            com.stripe.proto.model.rest.PaymentIntent paymentIntent6;
            ErrorResponse errorResponse = ((ErrorWrapper)((Object)((RestResponse.ServerError)response).getResponse())).error;
            PaymentIntent processedPaymentIntent = errorResponse != null && (paymentIntent6 = errorResponse.payment_intent) != null && (paymentIntent5 = ProtoConverter.INSTANCE.toSdkPaymentIntent(paymentIntent6)) != null && (paymentIntent4 = PaymentIntent.copy$default((PaymentIntent)paymentIntent5, null, (long)0L, (long)0L, (long)0L, null, (long)0L, (long)0L, null, null, null, null, null, (long)0L, null, null, null, null, null, (boolean)false, null, null, null, null, null, null, null, null, null, null, null, null, null, (String)paymentIntent2.getStripeAccountId(), (int)-1, (int)0, null)) != null ? paymentIntent4 : paymentIntent2;
            processedPaymentIntent.setPaymentMethodData((PaymentMethodData)collectScaPaymentMethodData.invoke());
            OfflineAdapterKt.setOfflineBehavior(processedPaymentIntent, paymentIntent2.getOfflineBehavior());
            paymentIntent3 = this.processPayment(processedPaymentIntent, getCollectiblePayment, handleAuthResponse, collectScaPaymentMethodData, immediateRecollectForSca, authStateListener);
        } else {
            paymentIntent3 = ProtoConverter.INSTANCE.toSdkPaymentIntent(ApiClient.Companion.decodePaymentResponseCatchingLastPaymentError(response));
        }
        return paymentIntent3;
    }

    private final <S extends Message<S, ?>, E extends Message<E, ?>> boolean recollectPaymentMethodNeeded(RestResponse<S, E> response, ChargeAttempt chargeAttempt, boolean immediateRecollectForSca) {
        return response instanceof RestResponse.ServerError && chargeAttempt instanceof ChargeAttempt.ExtendedAttempt && immediateRecollectForSca;
    }

    private final RestResponse<com.stripe.proto.model.rest.PaymentIntent, ErrorWrapper> confirmPaymentIntent(PaymentIntent paymentIntent2, CollectiblePayment collectiblePayment, Function1<? super String, ? extends Deferred<TransactionResult>> handleAuthResponse, Amount amountTip, OnlineAuthStateListener authStateListener, RestTimeout timeout) {
        Payment payment = collectiblePayment.getPayment();
        if (payment != null) {
            Payment payment2 = payment;
            boolean bl = false;
            RestRequest<ConfirmPaymentIntentRequest, ConfirmPaymentIntentRequest.Builder> request = payment2 instanceof ManualEntryPayment ? this.apiRequestFactory.confirmManualEntryPaymentIntent(paymentIntent2, (ManualEntryPayment)payment2) : this.apiRequestFactory.confirmCollectiblePayment(paymentIntent2, payment2.asRest(), amountTip);
            String string = paymentIntent2.getId();
            if (string != null) {
                RestResponse<com.stripe.proto.model.rest.PaymentIntent, ErrorWrapper> restResponse;
                boolean sendAuthResponseToDevice;
                String paymentIntentId = string;
                boolean bl2 = false;
                IntegrationType authIntegrationType = this.transactionRepository.getIntegrationType();
                RestResponse<com.stripe.proto.model.rest.PaymentIntent, ErrorWrapper> response = this.apiClient.getRestClient().confirmPaymentIntent(request.getBody(), request.getHeaders(), timeout);
                boolean bl3 = sendAuthResponseToDevice = this.getShouldSendAuthResponseToDevice() && !(payment2 instanceof ManualEntryPayment);
                if (sendAuthResponseToDevice) {
                    restResponse = this.sendPaymentIntentAuthResponseToDevice(paymentIntent2, response, collectiblePayment, handleAuthResponse, authStateListener, authIntegrationType);
                } else {
                    ChargeAttempt chargeAttempt = Extensions.INSTANCE.toChargeAttemptForPaymentIntent(response, collectiblePayment.getTransactionSupportsSca(), this.logWriter);
                    authStateListener.onOnlineAuthStateChanged(this.getConfirmationResponseReceived(chargeAttempt, null, false));
                    restResponse = response;
                }
                return restResponse;
            }
            throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Payment intent ID cannot be null.", null, null, 12, null);
        }
        OnlineDirectResourceRepository $this$confirmPaymentIntent_u24lambda_u244 = this;
        boolean bl = false;
        RetrievePaymentIntentRequest request = new RetrievePaymentIntentRequest(null, paymentIntent2.getId(), null, null, 13, null);
        return AuthenticatedRestClient.retrievePaymentIntent$default($this$confirmPaymentIntent_u24lambda_u244.apiClient.getRestClient(), request, null, 2, null);
    }

    private final RestResponse<com.stripe.proto.model.rest.PaymentIntent, ErrorWrapper> sendPaymentIntentAuthResponseToDevice(PaymentIntent paymentIntent2, RestResponse<com.stripe.proto.model.rest.PaymentIntent, ErrorWrapper> response, CollectiblePayment collectiblePayment, Function1<? super String, ? extends Deferred<TransactionResult>> handleAuthResponse, OnlineAuthStateListener authStateListener, IntegrationType authIntegrationType) {
        boolean allowExtendedTransaction = collectiblePayment.getTransactionSupportsSca();
        ChargeAttempt chargeAttempt = Extensions.INSTANCE.toChargeAttemptForPaymentIntent(response, allowExtendedTransaction, this.logWriter);
        RestResponse<com.stripe.proto.model.rest.PaymentIntent, ErrorWrapper> restResponse = response;
        if (restResponse instanceof RestResponse.Success) {
            TransactionResult transactionResult2;
            String responseBlob = TraditionalEmvManager.Companion.authData(((com.stripe.proto.model.rest.PaymentIntent)((Object)((RestResponse.Success)response).getResponse())).charges, "8A023030");
            authStateListener.onOnlineAuthStateChanged(this.getConfirmationResponseReceived(chargeAttempt, responseBlob, this.shouldFetch2ndGenAc(collectiblePayment)));
            try {
                transactionResult2 = (TransactionResult)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super TransactionResult>, Object>(handleAuthResponse, responseBlob, null){
                    int label;
                    final /* synthetic */ Function1<String, Deferred<TransactionResult>> $handleAuthResponse;
                    final /* synthetic */ String $responseBlob;
                    {
                        this.$handleAuthResponse = $handleAuthResponse;
                        this.$responseBlob = $responseBlob;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = ((Deferred)this.$handleAuthResponse.invoke((Object)this.$responseBlob)).await((Continuation)this);
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super TransactionResult> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)1, null);
            }
            catch (Exception e2) {
                transactionResult2 = new TransactionResult(TransactionResult.Result.DEVICE_FAILURE, "");
            }
            TransactionResult result2 = transactionResult2;
            if (this.shouldFetch2ndGenAc(collectiblePayment)) {
                IntegrationType currentIntegrationType = this.transactionRepository.getIntegrationType();
                if (authIntegrationType != currentIntegrationType) {
                    Pair[] e2 = new Pair[]{TuplesKt.to((Object)"previous", (Object)((Object)authIntegrationType)), TuplesKt.to((Object)"current", (Object)((Object)currentIntegrationType))};
                    LOGGER.w("Skipping Payment 2nd Gen AC: Integration type changed after payment confirm", e2);
                    return response;
                }
                RestRequest<AddEmvSecondGenerationDataRequest, AddEmvSecondGenerationDataRequest.Builder> request = this.apiRequestFactory.addEmvSecondGenerationData(paymentIntent2, result2);
                authStateListener.onOnlineAuthStateChanged(OnlineAuthState.SecondGenAcStarted.INSTANCE);
                RestResponse<com.stripe.proto.model.rest.PaymentIntent, ErrorWrapper> secondGenResponse = this.addEmvSecondGenerationData(request);
                if (this.isNetworkError(secondGenResponse)) {
                    boolean cardApprovedTransaction = result2.getResult() == TransactionResult.Result.APPROVED;
                    HealthLogger.incrementCounter$default(this.offlineDiscreteLogger, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"card_approved_transaction", (Object)String.valueOf(cardApprovedTransaction))), null, sendPaymentIntentAuthResponseToDevice.1.INSTANCE, 5, null);
                    if (cardApprovedTransaction) {
                        String string;
                        LOGGER.w("Failed to forward 2nd gen data due to network error. Succeeding payment.", new Pair[0]);
                        if (((com.stripe.proto.model.rest.PaymentIntent)((Object)((RestResponse.Success)response).getResponse())).capture_method == Method.automatic) {
                            String string2 = PaymentIntentStatus.SUCCEEDED.toString().toLowerCase(Locale.ROOT);
                            string = string2;
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                        } else {
                            String string3 = PaymentIntentStatus.REQUIRES_CAPTURE.toString().toLowerCase(Locale.ROOT);
                            string = string3;
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                        }
                        String intentStatus = string;
                        RestResponse.Success responseWithCompletedStatus = RestResponse.Success.copy$default((RestResponse.Success)response, com.stripe.proto.model.rest.PaymentIntent.copy$default((com.stripe.proto.model.rest.PaymentIntent)((Object)((RestResponse.Success)response).getResponse()), null, null, intentStatus, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0x1FFFFFFB, null), null, null, null, null, null, null, 126, null);
                        authStateListener.onOnlineAuthStateChanged(this.getSecondGenAcResponseReceived(Extensions.INSTANCE.toChargeAttemptForPaymentIntent(responseWithCompletedStatus, allowExtendedTransaction, this.logWriter)));
                        return responseWithCompletedStatus;
                    }
                }
                authStateListener.onOnlineAuthStateChanged(this.getSecondGenAcResponseReceived(Extensions.INSTANCE.toChargeAttemptForPaymentIntent(secondGenResponse, allowExtendedTransaction, this.logWriter)));
                return secondGenResponse;
            }
        } else if (restResponse instanceof RestResponse.ServerError) {
            Message message;
            if (this.isNetworkError(response) && this.offlineConfigHelper.isOfflineModeEnabled()) {
                return response;
            }
            ErrorResponse errorResponse = ((ErrorWrapper)((Object)((RestResponse.ServerError)response).getResponse())).error;
            String authResponseTlv = CollectionsKt.contains((Iterable)serverProcessingErrors, (Object)(errorResponse != null ? errorResponse.code : null)) || Extensions.INSTANCE.requiresExtendedActionForPaymentIntent(response) ? TraditionalEmvManager.Companion.authData((message = ((ErrorWrapper)((Object)((RestResponse.ServerError)response).getResponse())).error) != null && (message = message.payment_intent) != null ? message.charges : null, "8A023035") : "8A025A33";
            this.handleConfirmationFailed(authStateListener, chargeAttempt, handleAuthResponse, authResponseTlv);
        } else if (restResponse instanceof RestResponse.ParseError) {
            String authResponseTlv = "8A025A33";
            this.handleConfirmationFailed(authStateListener, chargeAttempt, handleAuthResponse, authResponseTlv);
        }
        return response;
    }

    @Override
    @NotNull
    public com.stripe.stripeterminal.external.models.SetupIntent confirmSetupIntent(@NotNull com.stripe.stripeterminal.external.models.SetupIntent intent, @Nullable CollectiblePayment collectiblePayment, @NotNull Function1<? super String, ? extends Deferred<TransactionResult>> handleAuthResponse, boolean immediateRecollectForSca, @NotNull OnlineAuthStateListener authStateListener) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter(handleAuthResponse, (String)"handleAuthResponse");
        Intrinsics.checkNotNullParameter((Object)authStateListener, (String)"authStateListener");
        if (collectiblePayment == null) {
            return this.apiClient.confirmSetupIntent(intent);
        }
        Object object = collectiblePayment.getPayment();
        if (object == null || (object = object.asRest()) == null) {
            throw new TerminalException(TerminalException.TerminalErrorCode.STRIPE_API_ERROR, "Failed to confirm SetupIntent. Payment object is malformed.", null, null, 12, null);
        }
        Object paymentAsRest = object;
        authStateListener.onOnlineAuthStateChanged(OnlineAuthState.ConfirmationStarted.INSTANCE);
        RestResponse<SetupIntent, ErrorWrapper> response = this.confirmSetupIntent(intent, (RequestedPaymentMethod)((Object)paymentAsRest), handleAuthResponse, collectiblePayment, authStateListener);
        this.chargeAttemptManager.setChargeAttempt(Extensions.INSTANCE.toChargeAttemptForSetupIntent(response, collectiblePayment.getTransactionSupportsSca()));
        return ProtoConverter.INSTANCE.toSdkSetupIntent((SetupIntent)ApiClient.Companion.decodeResponse$default(ApiClient.Companion, response, null, 2, null));
    }

    private final RestResponse<SetupIntent, ErrorWrapper> confirmSetupIntent(com.stripe.stripeterminal.external.models.SetupIntent intent, RequestedPaymentMethod paymentAsRest, Function1<? super String, ? extends Deferred<TransactionResult>> handleAuthResponse, CollectiblePayment collectiblePayment, OnlineAuthStateListener authStateListener) {
        RestResponse<SetupIntent, ErrorWrapper> restResponse;
        ConfirmSetupIntentRequest confirmSetupIntentRequest;
        boolean allowExtendedTransaction = collectiblePayment.getTransactionSupportsSca();
        Payment payment = collectiblePayment.getPayment();
        if (payment instanceof ManualEntryPayment) {
            confirmSetupIntentRequest = this.apiRequestFactory.confirmManualEntrySetupIntent(intent, (ManualEntryPayment)payment);
        } else {
            List list = CollectionsKt.listOf((Object)"latest_attempt");
            String string = intent.getId();
            confirmSetupIntentRequest = new ConfirmSetupIntentRequest(list, paymentAsRest, null, null, null, string, null, 92, null);
        }
        ConfirmSetupIntentRequest request = confirmSetupIntentRequest;
        LOGGER.d("confirmSetupIntent: Performing API call with setup intent ID(" + intent + ".id)", new Pair[0]);
        RestResponse<SetupIntent, ErrorWrapper> restResponse2 = this.apiClient.getRestClient().confirmSetupIntent(request);
        if (this.getShouldSendAuthResponseToDevice()) {
            restResponse = this.sendSetupIntentAuthResponseToDevice(restResponse2, handleAuthResponse, allowExtendedTransaction, authStateListener);
        } else {
            ChargeAttempt chargeAttempt = Extensions.INSTANCE.toChargeAttemptForSetupIntent(restResponse2, allowExtendedTransaction);
            authStateListener.onOnlineAuthStateChanged(this.getConfirmationResponseReceived(chargeAttempt, null, false));
            restResponse = restResponse2;
        }
        return restResponse;
    }

    private final RestResponse<SetupIntent, ErrorWrapper> sendSetupIntentAuthResponseToDevice(RestResponse<SetupIntent, ErrorWrapper> restResponse, Function1<? super String, ? extends Deferred<TransactionResult>> handleAuthResponse, boolean allowExtendedTransaction, OnlineAuthStateListener authStateListener) {
        ChargeAttempt chargeAttempt = Extensions.INSTANCE.toChargeAttemptForSetupIntent(restResponse, allowExtendedTransaction);
        RestResponse<SetupIntent, ErrorWrapper> restResponse2 = restResponse;
        if (restResponse2 instanceof RestResponse.Success) {
            LOGGER.d("confirmSetupIntent: card approved", new Pair[0]);
            SetupIntent.SetupAttempt setupAttempt = ((SetupIntent)((Object)((RestResponse.Success)restResponse).getResponse())).latest_attempt;
            String responseBlob = TraditionalEmvManager.Companion.authData(setupAttempt != null ? setupAttempt.payment_method_details : null, "8A023030");
            authStateListener.onOnlineAuthStateChanged(this.getConfirmationResponseReceived(chargeAttempt, responseBlob, false));
            try {
                LOGGER.d("confirmSetupIntent: passing data back to card", new Pair[0]);
                handleAuthResponse.invoke((Object)responseBlob);
            }
            catch (Exception e2) {
                LOGGER.d("confirmSetupIntent: card declined the data", new Pair[0]);
            }
        } else if (restResponse2 instanceof RestResponse.ServerError) {
            String string;
            ErrorResponse errorResponse = ((ErrorWrapper)((Object)((RestResponse.ServerError)restResponse).getResponse())).error;
            if (CollectionsKt.contains((Iterable)serverProcessingErrors, (Object)(errorResponse != null ? errorResponse.code : null)) || Extensions.INSTANCE.requiresExtendedActionForSetupIntent(restResponse)) {
                LOGGER.d("confirmSetupIntent: card decline or SCA", new Pair[0]);
                Message message = ((ErrorWrapper)((Object)((RestResponse.ServerError)restResponse).getResponse())).error;
                string = TraditionalEmvManager.Companion.authData(message != null && (message = message.payment_intent) != null ? message.charges : null, "8A023035");
            } else {
                ErrorResponse errorResponse2 = ((ErrorWrapper)((Object)((RestResponse.ServerError)restResponse).getResponse())).error;
                LOGGER.d("confirmSetupIntent: unknown server error response " + (Object)((Object)restResponse.getStatusCode()) + ": " + (errorResponse2 != null ? errorResponse2.message : null), new Pair[0]);
                string = "8A025A33";
            }
            String authResponseTlv = string;
            this.handleConfirmationFailed(authStateListener, chargeAttempt, handleAuthResponse, authResponseTlv);
        } else if (restResponse2 instanceof RestResponse.ParseError) {
            LOGGER.d("confirmSetupIntent: unknown parse error", new Pair[0]);
            String authResponseTlv = "8A025A33";
            this.handleConfirmationFailed(authStateListener, chargeAttempt, handleAuthResponse, authResponseTlv);
        }
        return restResponse;
    }

    @Override
    @NotNull
    public PaymentMethod readReusableCard(@NotNull ReadReusableCardParameters readReusableCardParams, @NotNull PaymentMethodData paymentMethodData) {
        Intrinsics.checkNotNullParameter((Object)readReusableCardParams, (String)"readReusableCardParams");
        Intrinsics.checkNotNullParameter((Object)paymentMethodData, (String)"paymentMethodData");
        try {
            PaymentMethod paymentMethod;
            PaymentMethod it = paymentMethod = this.apiClient.createCardPaymentMethod(readReusableCardParams, paymentMethodData, this.statusManager.getConnectedReader());
            boolean bl = false;
            this.chargeAttemptManager.setChargeAttempt(ChargeAttempt.CompletedAttempt.SuccessfulReusableCard.INSTANCE);
            return paymentMethod;
        }
        catch (TerminalException e2) {
            this.chargeAttemptManager.setChargeAttempt(ChargeAttempt.CompletedAttempt.UnknownReusableCardResult.INSTANCE);
            throw e2;
        }
    }

    @Override
    @NotNull
    public PaymentIntent cancelPaymentIntent(@NotNull PaymentIntent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        return this.apiClient.cancelPaymentIntent(intent);
    }

    @Override
    @NotNull
    public com.stripe.stripeterminal.external.models.SetupIntent cancelSetupIntent(@NotNull com.stripe.stripeterminal.external.models.SetupIntent intent, @NotNull SetupIntentCancellationParameters params) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return this.apiClient.cancelSetupIntent(intent, params);
    }

    private final RestResponse<com.stripe.proto.model.rest.PaymentIntent, ErrorWrapper> addEmvSecondGenerationData(RestRequest<AddEmvSecondGenerationDataRequest, AddEmvSecondGenerationDataRequest.Builder> request) {
        Pair idempotencyHeader = IdempotencyHeader.headerEntry$default(this.idempotencyHeader, null, 1, null);
        return this.retryableEmvSecondGenerationRequest((Function0)new Function0<RestResponse<com.stripe.proto.model.rest.PaymentIntent, ErrorWrapper>>(this, request, (Pair<String, String>)idempotencyHeader){
            final /* synthetic */ OnlineDirectResourceRepository this$0;
            final /* synthetic */ RestRequest<AddEmvSecondGenerationDataRequest, AddEmvSecondGenerationDataRequest.Builder> $request;
            final /* synthetic */ Pair<String, String> $idempotencyHeader;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$idempotencyHeader = $idempotencyHeader;
                super(0);
            }

            @NotNull
            public final RestResponse<com.stripe.proto.model.rest.PaymentIntent, ErrorWrapper> invoke() {
                return OnlineDirectResourceRepository.access$getApiClient$p(this.this$0).getRestClient().addEmvSecondGenerationData(this.$request.getBody(), MapsKt.plus(this.$request.getHeaders(), (Map)MapsKt.mapOf(this.$idempotencyHeader)));
            }
        });
    }

    private final RestResponse<com.stripe.proto.model.rest.Refund, ErrorWrapper> addEmvSecondGenerationRefundData(AddEmvSecondGenerationDataRefundRequest request, Map<String, String> headers) {
        Pair idempotencyHeader = IdempotencyHeader.headerEntry$default(this.idempotencyHeader, null, 1, null);
        return this.retryableEmvSecondGenerationRequest((Function0)new Function0<RestResponse<com.stripe.proto.model.rest.Refund, ErrorWrapper>>(this, request, (Pair<String, String>)idempotencyHeader, headers){
            final /* synthetic */ OnlineDirectResourceRepository this$0;
            final /* synthetic */ AddEmvSecondGenerationDataRefundRequest $request;
            final /* synthetic */ Pair<String, String> $idempotencyHeader;
            final /* synthetic */ Map<String, String> $headers;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$idempotencyHeader = $idempotencyHeader;
                this.$headers = $headers;
                super(0);
            }

            @NotNull
            public final RestResponse<com.stripe.proto.model.rest.Refund, ErrorWrapper> invoke() {
                return OnlineDirectResourceRepository.access$getApiClient$p(this.this$0).getRestClient().addEmvSecondGenerationRefundData(this.$request, MapsKt.plus((Map)MapsKt.mapOf(this.$idempotencyHeader), this.$headers));
            }
        });
    }

    private final <M extends Message<M, ?>> RestResponse<M, ErrorWrapper> retryableEmvSecondGenerationRequest(Function0<? extends RestResponse<M, ErrorWrapper>> networkCall) {
        int attemptsToSendData = 3;
        for (int i2 = 0; i2 < attemptsToSendData; ++i2) {
            boolean bl;
            int attempt = i2;
            boolean bl2 = false;
            RestResponse response = (RestResponse)networkCall.invoke();
            RestResponse restResponse = response;
            if (restResponse instanceof RestResponse.Success) {
                bl = true;
            } else if (restResponse instanceof RestResponse.ParseError) {
                bl = false;
            } else if (restResponse instanceof RestResponse.ServerError) {
                switch (WhenMappings.$EnumSwitchMapping$0[response.getStatusCode().ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        bl = false;
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
            boolean successful = bl;
            int attemptsRemaining = attemptsToSendData - attempt - 1;
            if (!successful && attemptsRemaining != 0) continue;
            return response;
        }
        throw new IllegalStateException("Not expected to get here.".toString());
    }

    private final boolean isNetworkError(RestResponse<com.stripe.proto.model.rest.PaymentIntent, ErrorWrapper> response) {
        return response instanceof RestResponse.ServerError && (response.getStatusCode() == StatusCode.HTTP_ERROR || response.getStatusCode() == StatusCode.HTTP_ERROR_UNKNOWN_STATE);
    }

    private final void handleConfirmationFailed(OnlineAuthStateListener authStateListener, ChargeAttempt chargeAttempt, Function1<? super String, ? extends Deferred<TransactionResult>> handleAuthResponse, String authResponseTlv) {
        authStateListener.onOnlineAuthStateChanged(this.getConfirmationResponseReceived(chargeAttempt, authResponseTlv, false));
        try {
            handleAuthResponse.invoke((Object)authResponseTlv);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final OnlineAuthState.ConfirmationResponseReceived getConfirmationResponseReceived(ChargeAttempt chargeAttempt, String authResponse, boolean needSecondGenAc) {
        OnlineAuthState.ConfirmationResponseReceived confirmationResponseReceived;
        ChargeAttempt chargeAttempt2 = chargeAttempt;
        if ((chargeAttempt2 instanceof ChargeAttempt.CompletedAttempt.DeclinedCharge ? true : chargeAttempt2 instanceof ChargeAttempt.CompletedAttempt.DeclinedRefund) ? true : chargeAttempt2 instanceof ChargeAttempt.CompletedAttempt.AlreadyRefunded) {
            confirmationResponseReceived = new OnlineAuthState.ConfirmationResponseReceived.Failed(OnlineAuthFailureReason.DECLINED, authResponse, chargeAttempt);
        } else if (((chargeAttempt2 instanceof ChargeAttempt.CompletedAttempt.SuccessfulCharge ? true : chargeAttempt2 instanceof ChargeAttempt.CompletedAttempt.SuccessfulRefund) ? true : Intrinsics.areEqual((Object)chargeAttempt2, (Object)ChargeAttempt.CompletedAttempt.SuccessfulReusableCard.INSTANCE)) ? true : Intrinsics.areEqual((Object)chargeAttempt2, (Object)ChargeAttempt.CompletedAttempt.SuccessfulSetupIntent.INSTANCE)) {
            confirmationResponseReceived = needSecondGenAc ? (OnlineAuthState.ConfirmationResponseReceived)new OnlineAuthState.ConfirmationResponseReceived.NeedSecondGenAc(authResponse, chargeAttempt) : (OnlineAuthState.ConfirmationResponseReceived)new OnlineAuthState.ConfirmationResponseReceived.Success(authResponse, chargeAttempt);
        } else if ((Intrinsics.areEqual((Object)chargeAttempt2, (Object)ChargeAttempt.CompletedAttempt.UnknownChargeResult.INSTANCE) ? true : Intrinsics.areEqual((Object)chargeAttempt2, (Object)ChargeAttempt.CompletedAttempt.UnknownRefundResult.INSTANCE)) ? true : Intrinsics.areEqual((Object)chargeAttempt2, (Object)ChargeAttempt.CompletedAttempt.UnknownReusableCardResult.INSTANCE)) {
            confirmationResponseReceived = new OnlineAuthState.ConfirmationResponseReceived.Failed(OnlineAuthFailureReason.UNKNOWN_NETWORK_FAILURE, authResponse, chargeAttempt);
        } else if (chargeAttempt2 instanceof ChargeAttempt.ExtendedAttempt) {
            confirmationResponseReceived = new OnlineAuthState.ConfirmationResponseReceived.Failed(OnlineAuthFailureReason.SCA_NEEDED, authResponse, chargeAttempt);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return confirmationResponseReceived;
    }

    private final OnlineAuthState.SecondGenAcResponseReceived getSecondGenAcResponseReceived(ChargeAttempt chargeAttempt) {
        OnlineAuthState.SecondGenAcResponseReceived secondGenAcResponseReceived;
        ChargeAttempt chargeAttempt2 = chargeAttempt;
        if ((chargeAttempt2 instanceof ChargeAttempt.CompletedAttempt.DeclinedCharge ? true : chargeAttempt2 instanceof ChargeAttempt.CompletedAttempt.DeclinedRefund) ? true : chargeAttempt2 instanceof ChargeAttempt.CompletedAttempt.AlreadyRefunded) {
            secondGenAcResponseReceived = new OnlineAuthState.SecondGenAcResponseReceived.Failed(OnlineAuthFailureReason.DECLINED, chargeAttempt);
        } else if (((chargeAttempt2 instanceof ChargeAttempt.CompletedAttempt.SuccessfulCharge ? true : chargeAttempt2 instanceof ChargeAttempt.CompletedAttempt.SuccessfulRefund) ? true : Intrinsics.areEqual((Object)chargeAttempt2, (Object)ChargeAttempt.CompletedAttempt.SuccessfulReusableCard.INSTANCE)) ? true : Intrinsics.areEqual((Object)chargeAttempt2, (Object)ChargeAttempt.CompletedAttempt.SuccessfulSetupIntent.INSTANCE)) {
            secondGenAcResponseReceived = new OnlineAuthState.SecondGenAcResponseReceived.Success(chargeAttempt);
        } else if ((Intrinsics.areEqual((Object)chargeAttempt2, (Object)ChargeAttempt.CompletedAttempt.UnknownChargeResult.INSTANCE) ? true : Intrinsics.areEqual((Object)chargeAttempt2, (Object)ChargeAttempt.CompletedAttempt.UnknownRefundResult.INSTANCE)) ? true : Intrinsics.areEqual((Object)chargeAttempt2, (Object)ChargeAttempt.CompletedAttempt.UnknownReusableCardResult.INSTANCE)) {
            secondGenAcResponseReceived = new OnlineAuthState.SecondGenAcResponseReceived.Failed(OnlineAuthFailureReason.UNKNOWN_NETWORK_FAILURE, chargeAttempt);
        } else if (chargeAttempt2 instanceof ChargeAttempt.ExtendedAttempt) {
            secondGenAcResponseReceived = new OnlineAuthState.SecondGenAcResponseReceived.Failed(OnlineAuthFailureReason.SCA_NEEDED, chargeAttempt);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return secondGenAcResponseReceived;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, Location> getReaderLocations(@NotNull List<String> deviceSerials) {
        void $this$associateTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(deviceSerials, (String)"deviceSerials");
        Iterable $this$filter$iv = this.apiClient.discoverLocations(deviceSerials, this.connectionTokenRepository.getToken()).getReaders();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DiscoverLocationsResponse.ReaderLocationPair it = (DiscoverLocationsResponse.ReaderLocationPair)element$iv$iv;
            boolean bl = false;
            if (!(it.getLocation() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            DiscoverLocationsResponse.ReaderLocationPair readerLocationPair = (DiscoverLocationsResponse.ReaderLocationPair)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = readerLocationPair.getSerialNumbers();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void serial;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                Location location = readerLocationPair.getLocation();
                if (location == null) {
                    String string2 = "Required value was null.";
                    throw new IllegalArgumentException(string2.toString());
                }
                collection.add(TuplesKt.to((Object)serial, (Object)location));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv3;
            Pair pair = (Pair)element$iv$iv;
            boolean bl = false;
            String serial = (String)pair.component1();
            Location location = (Location)pair.component2();
            pair = TuplesKt.to((Object)serial, (Object)location);
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv3;
    }

    private final RestTimeout getTimeoutForActivate(OfflineConfigHelper $this$getTimeoutForActivate, String serialId) {
        Boolean bl;
        String string = serialId;
        if (string != null) {
            String p0 = string;
            boolean bl2 = false;
            bl = $this$getTimeoutForActivate.isOfflineEnabledForReader(p0);
        } else {
            bl = null;
        }
        return Intrinsics.areEqual(bl, (Object)true) ? (RestTimeout)new RestTimeout.Specified($this$getTimeoutForActivate.getHttpLowTimeoutMs()) : (RestTimeout)RestTimeout.DEFAULT.INSTANCE;
    }

    private final RestTimeout getTimeoutForPayments(OfflineConfigHelper $this$getTimeoutForPayments, boolean preferOnline) {
        return !$this$getTimeoutForPayments.isOfflineModeEnabled() ? (RestTimeout)RestTimeout.DEFAULT.INSTANCE : (preferOnline ? (RestTimeout)new RestTimeout.Specified($this$getTimeoutForPayments.getHttpHighTimeoutMs()) : (RestTimeout)new RestTimeout.Specified($this$getTimeoutForPayments.getHttpLowTimeoutMs()));
    }

    public static final /* synthetic */ ApiClient access$getApiClient$p(OnlineDirectResourceRepository $this) {
        return $this.apiClient;
    }

    static {
        Object[] objectArray = new String[]{"processing_error", "card_declined", "expired_card"};
        serverProcessingErrors = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/stripeterminal/internal/common/resourcerepository/OnlineDirectResourceRepository$Companion;", "", "()V", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "serverProcessingErrors", "", "", "resourcerepository_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StatusCode.values().length];
            try {
                nArray[StatusCode.HTTP_ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StatusCode.HTTP_ERROR_UNKNOWN_STATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StatusCode.SERVER_ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

