/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.resourcerepository;

import com.stripe.jvmcore.hardware.emv.TransactionResult;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.paymentcollection.OnlineAuthStateListener;
import com.stripe.jvmcore.terminal.api.ActivateReaderResponse;
import com.stripe.jvmcore.transaction.CollectiblePayment;
import com.stripe.jvmcore.transaction.ExtendedActionConstants;
import com.stripe.jvmcore.transaction.payment.Payment;
import com.stripe.jvmcore.transaction.payment.RemotePayment;
import com.stripe.proto.api.sdk.ActivateTerminalResponse;
import com.stripe.proto.model.merchant.ApiLocationPb;
import com.stripe.proto.model.sdk.PaymentMethod;
import com.stripe.stripeterminal.external.api.ApiError;
import com.stripe.stripeterminal.external.models.ConnectionConfiguration;
import com.stripe.stripeterminal.external.models.CreateConfiguration;
import com.stripe.stripeterminal.external.models.Location;
import com.stripe.stripeterminal.external.models.PaymentIntent;
import com.stripe.stripeterminal.external.models.PaymentIntentParameters;
import com.stripe.stripeterminal.external.models.ReadReusableCardParameters;
import com.stripe.stripeterminal.external.models.Reader;
import com.stripe.stripeterminal.external.models.Refund;
import com.stripe.stripeterminal.external.models.RefundParameters;
import com.stripe.stripeterminal.external.models.SetupIntent;
import com.stripe.stripeterminal.external.models.SetupIntentCancellationParameters;
import com.stripe.stripeterminal.external.models.SetupIntentParameters;
import com.stripe.stripeterminal.external.models.TerminalException;
import com.stripe.stripeterminal.internal.common.remotereadercontrollers.ProxyRemoteReaderController;
import com.stripe.stripeterminal.internal.common.resourcerepository.ResourceRepository;
import com.stripe.stripeterminal.internal.common.tokenrepositories.ConnectionTokenRepository;
import com.stripe.stripeterminal.internal.models.PaymentMethodData;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 =2\u00020\u0001:\u0001=B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016JD\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020'H\u0016J\"\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020*0)2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00190,H\u0016JX\u0010-\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u000e2\u000e\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u0016002\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u00182\f\u00101\u001a\b\u0012\u0004\u0012\u000202002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J<\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u000202H\u0016J\u0010\u0010<\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/stripe/stripeterminal/internal/common/resourcerepository/RemoteReaderResourceRepository;", "Lcom/stripe/stripeterminal/internal/common/resourcerepository/ResourceRepository;", "proxyReaderController", "Lcom/stripe/stripeterminal/internal/common/remotereadercontrollers/ProxyRemoteReaderController;", "connectionTokenRepository", "Lcom/stripe/stripeterminal/internal/common/tokenrepositories/ConnectionTokenRepository;", "(Lcom/stripe/stripeterminal/internal/common/remotereadercontrollers/ProxyRemoteReaderController;Lcom/stripe/stripeterminal/internal/common/tokenrepositories/ConnectionTokenRepository;)V", "activateReader", "Lcom/stripe/jvmcore/terminal/api/ActivateReaderResponse;", "reader", "Lcom/stripe/stripeterminal/external/models/Reader;", "connectionConfiguration", "Lcom/stripe/stripeterminal/external/models/ConnectionConfiguration;", "cancelPaymentIntent", "Lcom/stripe/stripeterminal/external/models/PaymentIntent;", "intent", "cancelSetupIntent", "Lcom/stripe/stripeterminal/external/models/SetupIntent;", "params", "Lcom/stripe/stripeterminal/external/models/SetupIntentCancellationParameters;", "confirmSetupIntent", "collectiblePayment", "Lcom/stripe/jvmcore/transaction/CollectiblePayment;", "handleAuthResponse", "Lkotlin/Function1;", "", "Lkotlinx/coroutines/Deferred;", "Lcom/stripe/jvmcore/hardware/emv/TransactionResult;", "immediateRecollectForSca", "", "authStateListener", "Lcom/stripe/jvmcore/paymentcollection/OnlineAuthStateListener;", "createPaymentIntent", "paymentIntentParameters", "Lcom/stripe/stripeterminal/external/models/PaymentIntentParameters;", "createConfiguration", "Lcom/stripe/stripeterminal/external/models/CreateConfiguration;", "createSetupIntent", "setupIntentParameters", "Lcom/stripe/stripeterminal/external/models/SetupIntentParameters;", "getReaderLocations", "", "Lcom/stripe/stripeterminal/external/models/Location;", "deviceSerials", "", "processPayment", "paymentIntent", "getCollectiblePayment", "Lkotlin/Function0;", "collectScaPaymentMethodData", "Lcom/stripe/stripeterminal/internal/models/PaymentMethodData;", "processRefund", "Lcom/stripe/stripeterminal/external/models/Refund;", "refundParams", "Lcom/stripe/stripeterminal/external/models/RefundParameters;", "readReusableCard", "Lcom/stripe/stripeterminal/external/models/PaymentMethod;", "readReusableCardParams", "Lcom/stripe/stripeterminal/external/models/ReadReusableCardParameters;", "paymentMethodData", "updatePaymentIntent", "Companion", "resourcerepository_release"})
public final class RemoteReaderResourceRepository
implements ResourceRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProxyRemoteReaderController proxyReaderController;
    @NotNull
    private final ConnectionTokenRepository connectionTokenRepository;
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(RemoteReaderResourceRepository.class);

    @Inject
    public RemoteReaderResourceRepository(@NotNull ProxyRemoteReaderController proxyReaderController, @NotNull ConnectionTokenRepository connectionTokenRepository) {
        Intrinsics.checkNotNullParameter((Object)proxyReaderController, (String)"proxyReaderController");
        Intrinsics.checkNotNullParameter((Object)connectionTokenRepository, (String)"connectionTokenRepository");
        this.proxyReaderController = proxyReaderController;
        this.connectionTokenRepository = connectionTokenRepository;
    }

    @Override
    @NotNull
    public ActivateReaderResponse activateReader(@NotNull Reader reader, @NotNull ConnectionConfiguration connectionConfiguration) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)connectionConfiguration, (String)"connectionConfiguration");
        LOGGER.d("activateReader", new Pair[0]);
        String connectionToken = this.connectionTokenRepository.getTokenAndRefresh();
        ActivateTerminalResponse activateTerminalResponse = this.proxyReaderController.activateReader(reader, connectionToken, connectionConfiguration);
        String string = activateTerminalResponse.account_id;
        boolean bl = activateTerminalResponse.livemode;
        String string2 = activateTerminalResponse.sdk_rpc_session;
        long l2 = activateTerminalResponse.canonical_reader_version;
        ApiLocationPb apiLocationPb = activateTerminalResponse.location;
        return new ActivateReaderResponse(string, bl, "", null, null, string2, null, l2, apiLocationPb);
    }

    @Override
    @NotNull
    public PaymentIntent createPaymentIntent(@NotNull PaymentIntentParameters paymentIntentParameters, @NotNull CreateConfiguration createConfiguration) {
        Intrinsics.checkNotNullParameter((Object)paymentIntentParameters, (String)"paymentIntentParameters");
        Intrinsics.checkNotNullParameter((Object)createConfiguration, (String)"createConfiguration");
        LOGGER.d("createPaymentIntent", new Pair[0]);
        return this.proxyReaderController.createPaymentIntent(paymentIntentParameters, createConfiguration);
    }

    @Override
    @NotNull
    public SetupIntent createSetupIntent(@NotNull SetupIntentParameters setupIntentParameters) {
        Intrinsics.checkNotNullParameter((Object)setupIntentParameters, (String)"setupIntentParameters");
        LOGGER.d("createSetupIntent", new Pair[0]);
        return this.proxyReaderController.createSetupIntent(setupIntentParameters);
    }

    @Override
    @NotNull
    public Refund processRefund(@NotNull RefundParameters refundParams, @Nullable CollectiblePayment collectiblePayment, @NotNull Function1<? super String, ? extends Deferred<TransactionResult>> handleAuthResponse, @NotNull OnlineAuthStateListener authStateListener) {
        Intrinsics.checkNotNullParameter((Object)refundParams, (String)"refundParams");
        Intrinsics.checkNotNullParameter(handleAuthResponse, (String)"handleAuthResponse");
        Intrinsics.checkNotNullParameter((Object)authStateListener, (String)"authStateListener");
        LOGGER.d("processRefund", new Pair[0]);
        CollectiblePayment collectiblePayment2 = collectiblePayment;
        Payment payment = collectiblePayment2 != null ? collectiblePayment2.getPayment() : null;
        Object object = payment instanceof RemotePayment ? (RemotePayment)payment : null;
        if (object == null || (object = object.getSdkSource()) == null) {
            throw new TerminalException(TerminalException.TerminalErrorCode.MISSING_REQUIRED_PARAMETER, "Processing a refund requires a collected refund payment method", null, null, 12, null);
        }
        Object paymentMethod = object;
        return this.proxyReaderController.confirmInteracRefund(refundParams, (PaymentMethod)((Object)paymentMethod), this.getDefaultRefundReason());
    }

    @Override
    @NotNull
    public PaymentIntent updatePaymentIntent(@NotNull PaymentIntent paymentIntent2) {
        Intrinsics.checkNotNullParameter((Object)paymentIntent2, (String)"paymentIntent");
        return paymentIntent2;
    }

    @Override
    @NotNull
    public PaymentIntent processPayment(@NotNull PaymentIntent paymentIntent2, @NotNull Function0<CollectiblePayment> getCollectiblePayment, @NotNull Function1<? super String, ? extends Deferred<TransactionResult>> handleAuthResponse, @NotNull Function0<PaymentMethodData> collectScaPaymentMethodData, boolean immediateRecollectForSca, @NotNull OnlineAuthStateListener authStateListener) {
        PaymentIntent paymentIntent3;
        Intrinsics.checkNotNullParameter((Object)paymentIntent2, (String)"paymentIntent");
        Intrinsics.checkNotNullParameter(getCollectiblePayment, (String)"getCollectiblePayment");
        Intrinsics.checkNotNullParameter(handleAuthResponse, (String)"handleAuthResponse");
        Intrinsics.checkNotNullParameter(collectScaPaymentMethodData, (String)"collectScaPaymentMethodData");
        Intrinsics.checkNotNullParameter((Object)authStateListener, (String)"authStateListener");
        LOGGER.d("processPayment", new Pair[0]);
        try {
            PaymentIntent it = paymentIntent3 = this.proxyReaderController.confirmPayment(paymentIntent2);
            boolean bl = false;
            this.proxyReaderController.finishConfirmPayment();
        }
        catch (TerminalException e2) {
            ApiError apiError = e2.getApiError();
            if (!ExtendedActionConstants.INSTANCE.isExtendedActionError(apiError != null ? apiError.getCode() : null) || !immediateRecollectForSca) {
                this.proxyReaderController.finishConfirmPayment();
                throw e2;
            }
            paymentIntent2.setPaymentMethodData((PaymentMethodData)collectScaPaymentMethodData.invoke());
            paymentIntent3 = this.processPayment(paymentIntent2, getCollectiblePayment, handleAuthResponse, collectScaPaymentMethodData, immediateRecollectForSca, authStateListener);
        }
        return paymentIntent3;
    }

    @Override
    @NotNull
    public SetupIntent confirmSetupIntent(@NotNull SetupIntent intent, @Nullable CollectiblePayment collectiblePayment, @NotNull Function1<? super String, ? extends Deferred<TransactionResult>> handleAuthResponse, boolean immediateRecollectForSca, @NotNull OnlineAuthStateListener authStateListener) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter(handleAuthResponse, (String)"handleAuthResponse");
        Intrinsics.checkNotNullParameter((Object)authStateListener, (String)"authStateListener");
        LOGGER.d("confirmSetupIntent", new Pair[0]);
        return this.proxyReaderController.confirmSetupIntent(intent);
    }

    @Override
    @NotNull
    public PaymentIntent cancelPaymentIntent(@NotNull PaymentIntent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        LOGGER.d("cancelPaymentIntent", new Pair[0]);
        return this.proxyReaderController.cancelPaymentIntent(intent);
    }

    @Override
    @NotNull
    public SetupIntent cancelSetupIntent(@NotNull SetupIntent intent, @NotNull SetupIntentCancellationParameters params) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        LOGGER.d("cancelSetupIntent", new Pair[0]);
        return this.proxyReaderController.cancelSetupIntent(intent, params);
    }

    @Override
    @NotNull
    public com.stripe.stripeterminal.external.models.PaymentMethod readReusableCard(@NotNull ReadReusableCardParameters readReusableCardParams, @NotNull PaymentMethodData paymentMethodData) {
        Intrinsics.checkNotNullParameter((Object)readReusableCardParams, (String)"readReusableCardParams");
        Intrinsics.checkNotNullParameter((Object)paymentMethodData, (String)"paymentMethodData");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public Map<String, Location> getReaderLocations(@NotNull List<String> deviceSerials) {
        Intrinsics.checkNotNullParameter(deviceSerials, (String)"deviceSerials");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/stripeterminal/internal/common/resourcerepository/RemoteReaderResourceRepository$Companion;", "", "()V", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "resourcerepository_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

