/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.terminalsession;

import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.terminal.tokenrepositories.SessionTokenRepository;
import com.stripe.stripeterminal.external.models.ConnectionConfiguration;
import com.stripe.stripeterminal.external.models.PaymentStatus;
import com.stripe.stripeterminal.external.models.Reader;
import com.stripe.stripeterminal.external.models.TerminalException;
import com.stripe.stripeterminal.internal.common.TerminalStatusManager;
import com.stripe.stripeterminal.internal.common.terminalsession.BackgroundActivationResult;
import com.stripe.stripeterminal.internal.common.terminalsession.TerminalSession;
import dagger.Lazy;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/stripe/stripeterminal/internal/common/terminalsession/BackgroundReaderActivator;", "", "statusManager", "Lcom/stripe/stripeterminal/internal/common/TerminalStatusManager;", "sessionTokenRepository", "Lcom/stripe/jvmcore/terminal/tokenrepositories/SessionTokenRepository;", "lazyTerminalSession", "Ldagger/Lazy;", "Lcom/stripe/stripeterminal/internal/common/terminalsession/TerminalSession;", "(Lcom/stripe/stripeterminal/internal/common/TerminalStatusManager;Lcom/stripe/jvmcore/terminal/tokenrepositories/SessionTokenRepository;Ldagger/Lazy;)V", "activateInBackground", "Lcom/stripe/stripeterminal/internal/common/terminalsession/BackgroundActivationResult;", "reader", "Lcom/stripe/stripeterminal/external/models/Reader;", "config", "Lcom/stripe/stripeterminal/external/models/ConnectionConfiguration;", "Companion", "terminalsession_release"})
@SourceDebugExtension(value={"SMAP\nBackgroundReaderActivator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackgroundReaderActivator.kt\ncom/stripe/stripeterminal/internal/common/terminalsession/BackgroundReaderActivator\n+ 2 Log.kt\ncom/stripe/jvmcore/logging/terminal/log/Log$Companion\n*L\n1#1,67:1\n193#2:68\n*S KotlinDebug\n*F\n+ 1 BackgroundReaderActivator.kt\ncom/stripe/stripeterminal/internal/common/terminalsession/BackgroundReaderActivator\n*L\n54#1:68\n*E\n"})
public final class BackgroundReaderActivator {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalStatusManager statusManager;
    @NotNull
    private final SessionTokenRepository sessionTokenRepository;
    @NotNull
    private final Lazy<TerminalSession> lazyTerminalSession;
    @NotNull
    private static final Log LOGGER;

    @Inject
    public BackgroundReaderActivator(@NotNull TerminalStatusManager statusManager, @NotNull SessionTokenRepository sessionTokenRepository, @NotNull Lazy<TerminalSession> lazyTerminalSession) {
        Intrinsics.checkNotNullParameter((Object)statusManager, (String)"statusManager");
        Intrinsics.checkNotNullParameter((Object)sessionTokenRepository, (String)"sessionTokenRepository");
        Intrinsics.checkNotNullParameter(lazyTerminalSession, (String)"lazyTerminalSession");
        this.statusManager = statusManager;
        this.sessionTokenRepository = sessionTokenRepository;
        this.lazyTerminalSession = lazyTerminalSession;
    }

    @NotNull
    public final BackgroundActivationResult activateInBackground(@NotNull Reader reader, @NotNull ConnectionConfiguration config) {
        BackgroundActivationResult backgroundActivationResult;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Reader reader2 = this.statusManager.getConnectedReader();
        if (!Intrinsics.areEqual((Object)(reader2 != null ? reader2.getSerialNumber() : null), (Object)reader.getSerialNumber())) {
            LOGGER.i("Reader no longer connected", new Pair[0]);
            backgroundActivationResult = BackgroundActivationResult.ActivationCanceled.INSTANCE;
        } else if (this.statusManager.getPaymentStatus() != PaymentStatus.READY) {
            LOGGER.i("Reader busy", new Pair[0]);
            backgroundActivationResult = BackgroundActivationResult.CannotBeAttempted.INSTANCE;
        } else {
            try {
                BackgroundActivationResult backgroundActivationResult2;
                ((TerminalSession)this.lazyTerminalSession.get()).activateReader$terminalsession_release(reader, config);
                CharSequence charSequence = this.sessionTokenRepository.getStripeSessionToken();
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    LOGGER.i("Reader remains unactivated", new Pair[0]);
                    backgroundActivationResult2 = BackgroundActivationResult.CannotBeAttempted.INSTANCE;
                } else {
                    LOGGER.i("Reader activated in background", new Pair[0]);
                    backgroundActivationResult2 = BackgroundActivationResult.ActivationCompleted.INSTANCE;
                }
                return backgroundActivationResult2;
            }
            catch (TerminalException e2) {
                LOGGER.e("Reader could not be activated in background", e2, new Pair[0]);
                backgroundActivationResult = new BackgroundActivationResult.ActivationFailed(e2);
            }
        }
        return backgroundActivationResult;
    }

    static {
        Log.Companion this_$iv = Log.Companion;
        boolean $i$f$getLogger = false;
        LOGGER = this_$iv.getLogger(BackgroundReaderActivator.class);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/stripeterminal/internal/common/terminalsession/BackgroundReaderActivator$Companion;", "", "()V", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "terminalsession_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

