/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.terminalsession;

import com.squareup.wire.Message;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.restclient.RestInterceptor;
import com.stripe.jvmcore.restclient.RestResponse;
import com.stripe.jvmcore.terminal.api.ActivateReaderResponse;
import com.stripe.jvmcore.terminal.tokenrepositories.SessionTokenRepository;
import com.stripe.proto.model.rest.ErrorWrapper;
import com.stripe.stripeterminal.external.models.ConnectionConfiguration;
import com.stripe.stripeterminal.external.models.Reader;
import com.stripe.stripeterminal.external.models.TerminalException;
import com.stripe.stripeterminal.internal.common.proto.ProtoConverter;
import com.stripe.stripeterminal.internal.common.resourcerepository.ReaderActivationListener;
import com.stripe.stripeterminal.internal.common.terminalsession.BackgroundActivationResult;
import com.stripe.stripeterminal.internal.common.terminalsession.BackgroundReaderActivator;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Credentials;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0002\"#B\u0017\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0088\u0001\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u0002H\u00110\u000f\"\u001c\b\u0000\u0010\u0012*\u0016\u0012\u0004\u0012\u0002H\u0012\u0012\u0002\b\u00030\u0013j\b\u0012\u0004\u0012\u0002H\u0012`\u0014\"\u001c\b\u0001\u0010\u0010*\u0016\u0012\u0004\u0012\u0002H\u0010\u0012\u0002\b\u00030\u0013j\b\u0012\u0004\u0012\u0002H\u0010`\u0014\"\u001c\b\u0002\u0010\u0011*\u0016\u0012\u0004\u0012\u0002H\u0011\u0012\u0002\b\u00030\u0013j\b\u0012\u0004\u0012\u0002H\u0011`\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u0002H\u00110\u0016H\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0018H\u0016J\u008e\u0001\u0010 \u001a\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u0002H\u00110\u000f\"\u001c\b\u0000\u0010\u0012*\u0016\u0012\u0004\u0012\u0002H\u0012\u0012\u0002\b\u00030\u0013j\b\u0012\u0004\u0012\u0002H\u0012`\u0014\"\u001c\b\u0001\u0010\u0010*\u0016\u0012\u0004\u0012\u0002H\u0010\u0012\u0002\b\u00030\u0013j\b\u0012\u0004\u0012\u0002H\u0010`\u0014\"\u001c\b\u0002\u0010\u0011*\u0016\u0012\u0004\u0012\u0002H\u0011\u0012\u0002\b\u00030\u0013j\b\u0012\u0004\u0012\u0002H\u0011`\u0014*\u0014\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u0002H\u00110\u00162\b\u0010!\u001a\u0004\u0018\u00010\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/stripe/stripeterminal/internal/common/terminalsession/SessionTokenInterceptor;", "Lcom/stripe/jvmcore/restclient/RestInterceptor;", "Lcom/stripe/stripeterminal/internal/common/resourcerepository/ReaderActivationListener;", "backgroundActivator", "Lcom/stripe/stripeterminal/internal/common/terminalsession/BackgroundReaderActivator;", "sessionTokenRepository", "Lcom/stripe/jvmcore/terminal/tokenrepositories/SessionTokenRepository;", "(Lcom/stripe/stripeterminal/internal/common/terminalsession/BackgroundReaderActivator;Lcom/stripe/jvmcore/terminal/tokenrepositories/SessionTokenRepository;)V", "name", "", "getName", "()Ljava/lang/String;", "sessionInfo", "Lcom/stripe/stripeterminal/internal/common/terminalsession/SessionTokenInterceptor$ReaderSessionInfo;", "intercept", "Lcom/stripe/jvmcore/restclient/RestResponse;", "Rsp", "Err", "Rq", "Lcom/squareup/wire/Message;", "Lcom/stripe/jvmcore/restclient/Proto;", "chain", "Lcom/stripe/jvmcore/restclient/RestInterceptor$Chain;", "onReaderActivated", "", "config", "Lcom/stripe/stripeterminal/external/models/ConnectionConfiguration;", "reader", "Lcom/stripe/stripeterminal/external/models/Reader;", "response", "Lcom/stripe/jvmcore/terminal/api/ActivateReaderResponse;", "onReaderDisconnected", "proceedWithSessionToken", "sessionToken", "Companion", "ReaderSessionInfo", "terminalsession_release"})
@SourceDebugExtension(value={"SMAP\nSessionTokenInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionTokenInterceptor.kt\ncom/stripe/stripeterminal/internal/common/terminalsession/SessionTokenInterceptor\n+ 2 Log.kt\ncom/stripe/jvmcore/logging/terminal/log/Log$Companion\n*L\n1#1,116:1\n193#2:117\n*S KotlinDebug\n*F\n+ 1 SessionTokenInterceptor.kt\ncom/stripe/stripeterminal/internal/common/terminalsession/SessionTokenInterceptor\n*L\n113#1:117\n*E\n"})
public final class SessionTokenInterceptor
extends RestInterceptor
implements ReaderActivationListener {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final BackgroundReaderActivator backgroundActivator;
    @NotNull
    private final SessionTokenRepository sessionTokenRepository;
    @Nullable
    private ReaderSessionInfo sessionInfo;
    @NotNull
    private final String name;
    @NotNull
    private static final Log LOGGER;

    @Inject
    public SessionTokenInterceptor(@NotNull BackgroundReaderActivator backgroundActivator, @NotNull SessionTokenRepository sessionTokenRepository) {
        Intrinsics.checkNotNullParameter((Object)backgroundActivator, (String)"backgroundActivator");
        Intrinsics.checkNotNullParameter((Object)sessionTokenRepository, (String)"sessionTokenRepository");
        this.backgroundActivator = backgroundActivator;
        this.sessionTokenRepository = sessionTokenRepository;
        this.name = "SessionTokenInterceptor";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public <Rq extends Message<Rq, ?>, Rsp extends Message<Rsp, ?>, Err extends Message<Err, ?>> RestResponse<Rsp, Err> intercept(@NotNull RestInterceptor.Chain<Rq, Rsp, Err> chain) {
        RestResponse<Rsp, Err> restResponse;
        RestResponse<Rsp, Err> firstResponse;
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        String firstSessionToken = this.sessionTokenRepository.getStripeSessionToken();
        RestResponse<Rsp, Err> restResponse2 = firstResponse = this.proceedWithSessionToken(chain, firstSessionToken);
        if (restResponse2 instanceof RestResponse.ServerError) {
            Object errorBody = ((RestResponse.ServerError)firstResponse).getResponse();
            ReaderSessionInfo oldSessionInfo = this.sessionInfo;
            if (oldSessionInfo != null && errorBody instanceof ErrorWrapper && ProtoConverter.INSTANCE.toTerminalException(((ErrorWrapper)((Object)errorBody)).error).getErrorCode() == TerminalException.TerminalErrorCode.SESSION_EXPIRED) {
                BackgroundActivationResult result2 = this.backgroundActivator.activateInBackground(oldSessionInfo.getReader(), oldSessionInfo.getConfig());
                String newSessionToken = this.sessionTokenRepository.getStripeSessionToken();
                if (result2 instanceof BackgroundActivationResult.ActivationCompleted && !Intrinsics.areEqual((Object)newSessionToken, (Object)firstSessionToken)) {
                    LOGGER.i("Retrying request with new session token", new Pair[0]);
                    restResponse = this.proceedWithSessionToken(chain, newSessionToken);
                } else {
                    restResponse = firstResponse;
                }
            } else {
                restResponse = firstResponse;
            }
        } else if (restResponse2 instanceof RestResponse.ParseError) {
            restResponse = firstResponse;
        } else if (restResponse2 instanceof RestResponse.Success) {
            restResponse = firstResponse;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return restResponse;
    }

    @Override
    public void onReaderActivated(@NotNull ConnectionConfiguration config, @NotNull Reader reader, @NotNull ActivateReaderResponse response) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.sessionInfo = new ReaderSessionInfo(config, reader);
        this.sessionTokenRepository.setStripeSessionToken(response.getStripeSessionToken());
        this.sessionTokenRepository.setRpcSessionToken(response.getRpcSessionToken());
    }

    @Override
    public void onReaderDisconnected() {
        this.sessionInfo = null;
    }

    private final <Rq extends Message<Rq, ?>, Rsp extends Message<Rsp, ?>, Err extends Message<Err, ?>> RestResponse<Rsp, Err> proceedWithSessionToken(RestInterceptor.Chain<Rq, Rsp, Err> $this$proceedWithSessionToken, String sessionToken) {
        Request.Builder builder;
        Request originalRequest = $this$proceedWithSessionToken.request();
        Request.Builder $this$proceedWithSessionToken_u24lambda_u240 = builder = originalRequest.newBuilder();
        boolean bl = false;
        CharSequence charSequence = sessionToken;
        if (!(charSequence == null || charSequence.length() == 0) && originalRequest.header("Authorization") == null) {
            $this$proceedWithSessionToken_u24lambda_u240.header("Authorization", Credentials.basic$default((String)sessionToken, (String)"", null, (int)4, null));
        }
        Request request = builder.build();
        return $this$proceedWithSessionToken.proceed(request);
    }

    static {
        Log.Companion this_$iv = Log.Companion;
        boolean $i$f$getLogger = false;
        LOGGER = this_$iv.getLogger(SessionTokenInterceptor.class);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/stripeterminal/internal/common/terminalsession/SessionTokenInterceptor$Companion;", "", "()V", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "terminalsession_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/stripe/stripeterminal/internal/common/terminalsession/SessionTokenInterceptor$ReaderSessionInfo;", "", "config", "Lcom/stripe/stripeterminal/external/models/ConnectionConfiguration;", "reader", "Lcom/stripe/stripeterminal/external/models/Reader;", "(Lcom/stripe/stripeterminal/external/models/ConnectionConfiguration;Lcom/stripe/stripeterminal/external/models/Reader;)V", "getConfig", "()Lcom/stripe/stripeterminal/external/models/ConnectionConfiguration;", "getReader", "()Lcom/stripe/stripeterminal/external/models/Reader;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "terminalsession_release"})
    private static final class ReaderSessionInfo {
        @NotNull
        private final ConnectionConfiguration config;
        @NotNull
        private final Reader reader;

        public ReaderSessionInfo(@NotNull ConnectionConfiguration config, @NotNull Reader reader) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            this.config = config;
            this.reader = reader;
        }

        @NotNull
        public final ConnectionConfiguration getConfig() {
            return this.config;
        }

        @NotNull
        public final Reader getReader() {
            return this.reader;
        }

        @NotNull
        public final ConnectionConfiguration component1() {
            return this.config;
        }

        @NotNull
        public final Reader component2() {
            return this.reader;
        }

        @NotNull
        public final ReaderSessionInfo copy(@NotNull ConnectionConfiguration config, @NotNull Reader reader) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            return new ReaderSessionInfo(config, reader);
        }

        public static /* synthetic */ ReaderSessionInfo copy$default(ReaderSessionInfo readerSessionInfo, ConnectionConfiguration connectionConfiguration, Reader reader, int n2, Object object) {
            if ((n2 & 1) != 0) {
                connectionConfiguration = readerSessionInfo.config;
            }
            if ((n2 & 2) != 0) {
                reader = readerSessionInfo.reader;
            }
            return readerSessionInfo.copy(connectionConfiguration, reader);
        }

        @NotNull
        public String toString() {
            return "ReaderSessionInfo(config=" + this.config + ", reader=" + this.reader + ')';
        }

        public int hashCode() {
            int result2 = this.config.hashCode();
            result2 = result2 * 31 + this.reader.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReaderSessionInfo)) {
                return false;
            }
            ReaderSessionInfo readerSessionInfo = (ReaderSessionInfo)other;
            if (!Intrinsics.areEqual((Object)this.config, (Object)readerSessionInfo.config)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.reader, (Object)readerSessionInfo.reader);
        }
    }
}

