/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.tokenrepositories;

import com.google.common.util.concurrent.SettableFuture;
import com.stripe.jvmcore.dagger.ConnectionTokenManagement;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.stripeterminal.external.callable.ConnectionTokenCallback;
import com.stripe.stripeterminal.external.callable.ConnectionTokenProvider;
import com.stripe.stripeterminal.external.models.ConnectionTokenException;
import com.stripe.stripeterminal.external.models.TerminalException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0001\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u000bJ\u0006\u0010\u0016\u001a\u00020\u000bJ\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0014H\u0002J\b\u0010\u001a\u001a\u00020\u0014H\u0002R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0018\u00010\u000fj\u0004\u0018\u0001`\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/stripe/stripeterminal/internal/common/tokenrepositories/ConnectionTokenRepository;", "", "tokenProvider", "Lcom/stripe/stripeterminal/external/callable/ConnectionTokenProvider;", "epochProvider", "Lkotlin/Function0;", "", "executor", "Ljava/util/concurrent/ExecutorService;", "(Lcom/stripe/stripeterminal/external/callable/ConnectionTokenProvider;Lkotlin/jvm/functions/Function0;Ljava/util/concurrent/ExecutorService;)V", "cachedToken", "", "cachedTokenExpiration", "Ljava/lang/Long;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "future", "Ljava/util/concurrent/Future;", "clearToken", "", "getToken", "getTokenAndRefresh", "isCachedTokenExpired", "", "refreshToken", "waitForToken", "Companion", "common_publish"})
@SourceDebugExtension(value={"SMAP\nConnectionTokenRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectionTokenRepository.kt\ncom/stripe/stripeterminal/internal/common/tokenrepositories/ConnectionTokenRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n1#2:164\n*E\n"})
public final class ConnectionTokenRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConnectionTokenProvider tokenProvider;
    @NotNull
    private final Function0<Long> epochProvider;
    @NotNull
    private final ExecutorService executor;
    @Nullable
    private String cachedToken;
    @Nullable
    private Long cachedTokenExpiration;
    @Nullable
    private Exception exception;
    @Nullable
    private Future<?> future;
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(ConnectionTokenRepository.class);
    private static final long TIMEOUT_SECONDS = 60L;
    private static final int TOKEN_LIFETIME_MS = 1800000;

    @Inject
    public ConnectionTokenRepository(@NotNull ConnectionTokenProvider tokenProvider, @ConnectionTokenManagement @NotNull Function0<Long> epochProvider, @ConnectionTokenManagement @NotNull ExecutorService executor) {
        Intrinsics.checkNotNullParameter((Object)tokenProvider, (String)"tokenProvider");
        Intrinsics.checkNotNullParameter(epochProvider, (String)"epochProvider");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.tokenProvider = tokenProvider;
        this.epochProvider = epochProvider;
        this.executor = executor;
        this.refreshToken();
    }

    @NotNull
    public final String getTokenAndRefresh() throws TerminalException {
        this.getToken();
        String string = this.cachedToken;
        Intrinsics.checkNotNull((Object)string);
        String returnToken = string;
        this.cachedToken = null;
        this.cachedTokenExpiration = null;
        this.refreshToken();
        return returnToken;
    }

    @NotNull
    public final String getToken() throws TerminalException {
        block2: {
            block4: {
                block3: {
                    if (this.cachedToken != null && !this.isCachedTokenExpired()) break block2;
                    this.exception = null;
                    if (this.future == null) break block3;
                    Future<?> future = this.future;
                    Intrinsics.checkNotNull(future);
                    if (!future.isDone()) break block4;
                }
                this.refreshToken();
            }
            this.waitForToken();
        }
        String string = this.cachedToken;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    public final void clearToken() {
        this.cachedToken = null;
        this.cachedTokenExpiration = null;
        this.exception = null;
    }

    private final boolean isCachedTokenExpired() {
        boolean bl;
        Long l2 = this.cachedTokenExpiration;
        if (l2 != null) {
            long it = ((Number)l2).longValue();
            boolean bl2 = false;
            bl = it <= ((Number)this.epochProvider.invoke()).longValue();
        } else {
            bl = true;
        }
        return bl;
    }

    private final void refreshToken() {
        LOGGER.d("refreshToken", new Pair[0]);
        this.future = this.executor.submit(() -> ConnectionTokenRepository.refreshToken$lambda$1(this));
    }

    private final void waitForToken() throws TerminalException {
        try {
            Future<?> future = this.future;
            Intrinsics.checkNotNull(future);
            future.get(60L, TimeUnit.SECONDS);
            Exception exception = this.exception;
            if (exception != null) {
                throw new TerminalException(TerminalException.TerminalErrorCode.CONNECTION_TOKEN_PROVIDER_ERROR, "Error retrieving connection token", (Throwable)exception, null, 8, null);
            }
        }
        catch (ExecutionException e2) {
            throw new TerminalException(TerminalException.TerminalErrorCode.CONNECTION_TOKEN_PROVIDER_ERROR, "Execution error while retrieving connection token", (Throwable)e2, null, 8, null);
        }
        catch (InterruptedException e3) {
            throw new TerminalException(TerminalException.TerminalErrorCode.CONNECTION_TOKEN_PROVIDER_ERROR, "Interruption while waiting for connection token", (Throwable)e3, null, 8, null);
        }
        catch (TimeoutException e4) {
            throw new TerminalException(TerminalException.TerminalErrorCode.CONNECTION_TOKEN_PROVIDER_ERROR, "Timed out waiting for connection token", (Throwable)e4, null, 8, null);
        }
    }

    private static final void refreshToken$lambda$1(ConnectionTokenRepository this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SettableFuture tokenResult = SettableFuture.create();
        this$0.tokenProvider.fetchConnectionToken(new ConnectionTokenCallback((SettableFuture<String>)tokenResult){
            final /* synthetic */ SettableFuture<String> $tokenResult;
            {
                this.$tokenResult = $tokenResult;
            }

            public void onSuccess(@NotNull String token) {
                Intrinsics.checkNotNullParameter((Object)token, (String)"token");
                ConnectionTokenRepository.access$getLOGGER$cp().d("fetchConnectionToken.onSuccess", new Pair[0]);
                this.$tokenResult.set((Object)token);
            }

            public void onFailure(@NotNull ConnectionTokenException e2) {
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                ConnectionTokenRepository.access$getLOGGER$cp().e("Error in external token provider", (Throwable)e2, new Pair[0]);
                this.$tokenResult.setException((Throwable)e2);
            }
        });
        try {
            this$0.cachedToken = (String)tokenResult.get();
            this$0.cachedTokenExpiration = ((Number)this$0.epochProvider.invoke()).longValue() + (long)1800000;
        }
        catch (InterruptedException e2) {
            this$0.exception = e2;
        }
        catch (ExecutionException e3) {
            this$0.exception = e3;
        }
    }

    public static final /* synthetic */ Log access$getLOGGER$cp() {
        return LOGGER;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/stripe/stripeterminal/internal/common/tokenrepositories/ConnectionTokenRepository$Companion;", "", "()V", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "TIMEOUT_SECONDS", "", "TOKEN_LIFETIME_MS", "", "common_publish"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

