/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.transaction;

import com.stripe.core.hardware.DiscoveryController;
import com.stripe.core.hardware.ReaderController;
import com.stripe.core.readerupdate.UpdateInstaller;
import com.stripe.stripeterminal.internal.common.transaction.ApplicationData;
import com.stripe.stripeterminal.internal.common.transaction.TransactionState;
import com.stripe.stripeterminal.internal.common.transaction.TransactionStateHandler;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stripe/stripeterminal/internal/common/transaction/CancelledHandler;", "Lcom/stripe/stripeterminal/internal/common/transaction/TransactionStateHandler;", "discoveryController", "Lcom/stripe/core/hardware/DiscoveryController;", "readerController", "Lcom/stripe/core/hardware/ReaderController;", "updateInstaller", "Lcom/stripe/core/readerupdate/UpdateInstaller;", "(Lcom/stripe/core/hardware/DiscoveryController;Lcom/stripe/core/hardware/ReaderController;Lcom/stripe/core/readerupdate/UpdateInstaller;)V", "onEnter", "", "current", "Lcom/stripe/stripeterminal/internal/common/transaction/ApplicationData;", "from", "Lcom/stripe/stripeterminal/internal/common/transaction/TransactionState;", "common_publish"})
public final class CancelledHandler
extends TransactionStateHandler {
    @NotNull
    private final DiscoveryController discoveryController;
    @NotNull
    private final ReaderController readerController;
    @NotNull
    private final UpdateInstaller updateInstaller;

    @Inject
    public CancelledHandler(@NotNull DiscoveryController discoveryController, @NotNull ReaderController readerController, @NotNull UpdateInstaller updateInstaller) {
        Intrinsics.checkNotNullParameter((Object)discoveryController, (String)"discoveryController");
        Intrinsics.checkNotNullParameter((Object)readerController, (String)"readerController");
        Intrinsics.checkNotNullParameter((Object)updateInstaller, (String)"updateInstaller");
        super(TransactionState.CANCELLED);
        this.discoveryController = discoveryController;
        this.readerController = readerController;
        this.updateInstaller = updateInstaller;
    }

    @Override
    public void onEnter(@Nullable ApplicationData current, @Nullable TransactionState from) {
        TransactionState[] transactionStateArray = from;
        if (transactionStateArray == TransactionState.TIPPING_SELECTION) {
            this.readerController.stopTippingSelection();
        } else {
            TransactionState[] transactionStateArray2 = new TransactionState[]{TransactionState.REMOVE, TransactionState.DISCOVER, TransactionState.CONNECT, TransactionState.DISCONNECT, TransactionState.READER_INFO, TransactionState.CHECK_FOR_UPDATE, TransactionState.INSTALL_UPDATES, TransactionState.START_SESSION};
            if (!CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])transactionStateArray2), (Object)transactionStateArray)) {
                this.readerController.cancel();
            } else if (transactionStateArray == TransactionState.INSTALL_UPDATES) {
                this.updateInstaller.cancel();
            }
        }
        transactionStateArray = new TransactionState[]{TransactionState.DISCOVER, TransactionState.CONNECT, TransactionState.DISCONNECT, TransactionState.READER_INFO};
        if (CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])transactionStateArray), (Object)from)) {
            this.discoveryController.stopDiscover();
        }
        this.transitionTo(TransactionState.EMPTY, "Transaction cancelled");
    }
}

