/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.transaction;

import com.stripe.core.hardware.ReaderController;
import com.stripe.core.transaction.Summary;
import com.stripe.jvmcore.transaction.ChargeAttempt;
import com.stripe.stripeterminal.internal.common.transaction.ApplicationData;
import com.stripe.stripeterminal.internal.common.transaction.TransactionState;
import com.stripe.stripeterminal.internal.common.transaction.TransactionStateHandler;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016J\u001c\u0010\n\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/stripeterminal/internal/common/transaction/CollectPaymentPresentHandler;", "Lcom/stripe/stripeterminal/internal/common/transaction/TransactionStateHandler;", "readerController", "Lcom/stripe/core/hardware/ReaderController;", "(Lcom/stripe/core/hardware/ReaderController;)V", "onApplicationDataUpdate", "", "new", "Lcom/stripe/stripeterminal/internal/common/transaction/ApplicationData;", "old", "onEnter", "current", "from", "Lcom/stripe/stripeterminal/internal/common/transaction/TransactionState;", "common_publish"})
public final class CollectPaymentPresentHandler
extends TransactionStateHandler {
    @NotNull
    private final ReaderController readerController;

    @Inject
    public CollectPaymentPresentHandler(@NotNull ReaderController readerController) {
        Intrinsics.checkNotNullParameter((Object)readerController, (String)"readerController");
        super(TransactionState.COLLECT_PAYMENT_PRESENT);
        this.readerController = readerController;
    }

    @Override
    public void onEnter(@Nullable ApplicationData current, @Nullable TransactionState from) {
        if (from != TransactionState.PAYMENT_COMPLETE) {
            this.readerController.disable();
        }
    }

    @Override
    public void onApplicationDataUpdate(@NotNull ApplicationData applicationData, @Nullable ApplicationData old) {
        Intrinsics.checkNotNullParameter((Object)applicationData, (String)"new");
        Summary summary = applicationData.getSummary();
        if ((summary != null ? summary.getChargeAttempt() : null) instanceof ChargeAttempt.CompletedAttempt) {
            this.transitionTo(TransactionState.CHARGE_ATTEMPT_SUMMARY, "Showing charge attempt summary");
        } else {
            Summary summary2 = applicationData.getSummary();
            if ((summary2 != null ? summary2.getChargeAttempt() : null) instanceof ChargeAttempt.ExtendedAttempt) {
                this.transitionTo(TransactionState.COLLECT, "Re-attempting collect");
            }
        }
    }
}

