/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.transaction;

import com.stripe.core.readerconnection.ConnectionState;
import com.stripe.core.readerconnection.ConnectionSummary;
import com.stripe.core.readerupdate.UpdateState;
import com.stripe.core.readerupdate.UpdateSummary;
import com.stripe.core.transaction.Summary;
import com.stripe.core.transaction.Transaction;
import com.stripe.core.transaction.TransactionRepository;
import com.stripe.jvmcore.hardware.emv.CardStatus;
import com.stripe.stripeterminal.internal.common.transaction.ApplicationData;
import com.stripe.stripeterminal.internal.common.transaction.TransactionState;
import com.stripe.stripeterminal.internal.common.transaction.TransactionStateHandler;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/stripeterminal/internal/common/transaction/EmptyHandler;", "Lcom/stripe/stripeterminal/internal/common/transaction/TransactionStateHandler;", "transactionRepository", "Lcom/stripe/core/transaction/TransactionRepository;", "(Lcom/stripe/core/transaction/TransactionRepository;)V", "onApplicationDataUpdate", "", "new", "Lcom/stripe/stripeterminal/internal/common/transaction/ApplicationData;", "old", "common_publish"})
public final class EmptyHandler
extends TransactionStateHandler {
    @NotNull
    private final TransactionRepository transactionRepository;

    @Inject
    public EmptyHandler(@NotNull TransactionRepository transactionRepository) {
        Intrinsics.checkNotNullParameter((Object)transactionRepository, (String)"transactionRepository");
        super(TransactionState.EMPTY);
        this.transactionRepository = transactionRepository;
    }

    @Override
    public void onApplicationDataUpdate(@NotNull ApplicationData applicationData, @Nullable ApplicationData old) {
        Intrinsics.checkNotNullParameter((Object)applicationData, (String)"new");
        this.transactionRepository.resetContext();
        UpdateSummary updateSummary = applicationData.getUpdateSummary();
        UpdateState updateState = updateSummary != null ? updateSummary.getState() : null;
        switch (updateState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[updateState.ordinal()]) {
            case 1: {
                this.transitionTo(TransactionState.CHECK_FOR_UPDATE, "Check for update requested");
                break;
            }
            case 2: {
                this.transitionTo(TransactionState.INSTALL_UPDATES, "Installing updates");
            }
        }
        ConnectionSummary connectionSummary = applicationData.getConnectionSummary();
        ConnectionState connectionState = connectionSummary != null ? connectionSummary.getState() : null;
        switch (connectionState == null ? -1 : WhenMappings.$EnumSwitchMapping$1[connectionState.ordinal()]) {
            case 1: {
                this.transitionTo(TransactionState.DISCOVER, "Discovery requested");
                break;
            }
            case 2: {
                this.transitionTo(TransactionState.CONNECT, "Connect requested");
                break;
            }
            case 3: {
                this.transitionTo(TransactionState.START_SESSION, "Start session requested");
                break;
            }
            case 4: {
                this.transitionTo(TransactionState.DISCONNECT, "Disconnect requested");
            }
        }
        Summary summary = applicationData.getSummary();
        Transaction.Type type = summary != null ? summary.getType() : null;
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$2[type.ordinal()]) {
            case 1: {
                this.transitionTo(TransactionState.COLLECT, "Payment method requested");
                break;
            }
            case 2: {
                this.transitionTo(TransactionState.COLLECT, "Reusable card requested");
                break;
            }
            case 3: {
                this.transitionTo(TransactionState.COLLECT, "Interac refund requested");
                break;
            }
            case 4: {
                this.transitionTo(TransactionState.COLLECT, "Payment method for SetupIntent requested");
                break;
            }
            case 5: {
                this.transitionTo(TransactionState.TIPPING_SELECTION, "Tipping selection requested");
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$3[applicationData.getCardStatus().ordinal()]) {
            case 1: {
                this.transitionTo(TransactionState.REMOVE, "Remove requested");
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[UpdateState.values().length];
            try {
                nArray[UpdateState.CHECKING_FOR_UPDATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UpdateState.INSTALLING_UPDATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UpdateState.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ConnectionState.values().length];
            try {
                nArray[ConnectionState.DISCOVERING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConnectionState.CONNECTING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConnectionState.STARTING_SESSION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConnectionState.DISCONNECTING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConnectionState.NONE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConnectionState.FETCHING_INFO.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[Transaction.Type.values().length];
            try {
                nArray[Transaction.Type.PAYMENT_METHOD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Transaction.Type.REUSABLE_CARD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Transaction.Type.INTERAC_REFUND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Transaction.Type.SETUP_INTENT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Transaction.Type.TIPPING_SELECTION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Transaction.Type.DISPLAY_CART.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[CardStatus.values().length];
            try {
                nArray[CardStatus.CARD_IDLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardStatus.NO_CARD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardStatus.CARD_PROCESSING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardStatus.CARD_NOT_WORKING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

