/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.transaction;

import com.stripe.core.hardware.status.ReaderStatusListener;
import com.stripe.core.transaction.Summary;
import com.stripe.core.transaction.Transaction;
import com.stripe.jvmcore.hardware.status.CancellationType;
import com.stripe.stripeterminal.internal.common.transaction.ApplicationData;
import com.stripe.stripeterminal.internal.common.transaction.TransactionState;
import com.stripe.stripeterminal.internal.common.transaction.TransactionStateHandler;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/stripe/stripeterminal/internal/common/transaction/PaymentCompleteHandler;", "Lcom/stripe/stripeterminal/internal/common/transaction/TransactionStateHandler;", "statusListener", "Lcom/stripe/core/hardware/status/ReaderStatusListener;", "(Lcom/stripe/core/hardware/status/ReaderStatusListener;)V", "onEnter", "", "current", "Lcom/stripe/stripeterminal/internal/common/transaction/ApplicationData;", "from", "Lcom/stripe/stripeterminal/internal/common/transaction/TransactionState;", "common_publish"})
public final class PaymentCompleteHandler
extends TransactionStateHandler {
    @NotNull
    private final ReaderStatusListener statusListener;

    @Inject
    public PaymentCompleteHandler(@NotNull ReaderStatusListener statusListener) {
        Intrinsics.checkNotNullParameter((Object)statusListener, (String)"statusListener");
        super(TransactionState.PAYMENT_COMPLETE);
        this.statusListener = statusListener;
    }

    @Override
    public void onEnter(@Nullable ApplicationData current, @Nullable TransactionState from) {
        Summary summary;
        ApplicationData applicationData = current;
        Summary summary2 = summary = applicationData != null ? applicationData.getSummary() : null;
        boolean bl = summary2 != null ? summary2.getHasPayment() : false;
        if (bl) {
            this.transitionTo(TransactionState.COLLECT_PAYMENT_PRESENT, "Collect completed");
        } else {
            Summary summary3 = summary;
            if ((summary3 != null ? summary3.getError() : null) == Transaction.Error.TERMINATED) {
                this.statusListener.handleCancellation(CancellationType.CANCEL_DURING_OPERATION);
                this.transitionTo(TransactionState.EMPTY, "Transaction cancelled");
            } else {
                this.transitionTo(TransactionState.COLLECT, "Collect failed");
            }
        }
    }
}

