/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.transaction;

import com.stripe.core.transaction.Summary;
import com.stripe.core.transaction.Transaction;
import com.stripe.jvmcore.hardware.emv.CardStatus;
import com.stripe.jvmcore.hardware.emv.Confirmation;
import com.stripe.stripeterminal.internal.common.transaction.ApplicationData;
import com.stripe.stripeterminal.internal.common.transaction.TransactionState;
import com.stripe.stripeterminal.internal.common.transaction.TransactionStateHandler;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016J\u001c\u0010\b\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/stripe/stripeterminal/internal/common/transaction/PaymentProcessingHandler;", "Lcom/stripe/stripeterminal/internal/common/transaction/TransactionStateHandler;", "()V", "onApplicationDataUpdate", "", "new", "Lcom/stripe/stripeterminal/internal/common/transaction/ApplicationData;", "old", "onEnter", "current", "from", "Lcom/stripe/stripeterminal/internal/common/transaction/TransactionState;", "common_publish"})
public final class PaymentProcessingHandler
extends TransactionStateHandler {
    @Inject
    public PaymentProcessingHandler() {
        super(TransactionState.PAYMENT_PROCESSING);
    }

    @Override
    public void onEnter(@Nullable ApplicationData current, @Nullable TransactionState from) {
        block0: {
            ApplicationData applicationData = current;
            if (applicationData == null) break block0;
            ApplicationData it = applicationData;
            boolean bl = false;
            this.onApplicationDataUpdate(it, it);
        }
    }

    @Override
    public void onApplicationDataUpdate(@NotNull ApplicationData applicationData, @Nullable ApplicationData old) {
        Intrinsics.checkNotNullParameter((Object)applicationData, (String)"new");
        Summary summary = applicationData.getSummary();
        Confirmation confirmation = summary != null ? summary.getConfirmation() : null;
        boolean needsConfirmation = confirmation != null;
        boolean isCardProcessing = applicationData.getCardStatus() == CardStatus.CARD_PROCESSING;
        boolean isCardRemoved = applicationData.getCardStatus() == CardStatus.NO_CARD;
        Summary summary2 = applicationData.getSummary();
        boolean isPaymentPresent = summary2 != null ? summary2.getHasPayment() : false;
        Summary summary3 = applicationData.getSummary();
        Transaction.Error error = summary3 != null ? summary3.getError() : null;
        boolean hasError = error != null;
        if (needsConfirmation) {
            Confirmation confirmation2 = confirmation;
            if (confirmation2 instanceof Confirmation.ApplicationSelection) {
                this.transitionTo(TransactionState.APPLICATION_SELECTION, "Application selection confirmation requested");
            } else if (confirmation2 instanceof Confirmation.AccountSelection) {
                this.transitionTo(TransactionState.ACCOUNT_SELECTION, "Account selection confirmation requested");
            } else if (confirmation2 instanceof Confirmation.LanguageSelection) {
                this.transitionTo(TransactionState.LANGUAGE_SELECTION, "Language selection confirmation requested");
            } else if (confirmation2 instanceof Confirmation.Pin ? true : confirmation2 == null) {
                // empty if block
            }
        } else if (isCardProcessing) {
            TransactionStateHandler.Companion.getLOGGER$common_publish().d("Waiting for card to finish processing", new Pair[0]);
        } else if (isPaymentPresent) {
            this.transitionTo(TransactionState.PAYMENT_COMPLETE, "Collected successfully");
        } else if (hasError) {
            this.transitionTo(TransactionState.PAYMENT_COMPLETE, "Failed to collect: " + (Object)((Object)error));
        } else if (isCardRemoved) {
            this.transitionTo(TransactionState.PAYMENT_COMPLETE, "Card removed too soon");
        }
    }
}

