/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.transaction;

import com.stripe.core.hardware.ReaderController;
import com.stripe.core.readerconnection.ConnectionState;
import com.stripe.core.readerconnection.ConnectionSummary;
import com.stripe.core.statemachine.StateMachine;
import com.stripe.jvmcore.hardware.emv.CardStatus;
import com.stripe.stripeterminal.internal.common.transaction.ApplicationData;
import com.stripe.stripeterminal.internal.common.transaction.TransactionState;
import com.stripe.stripeterminal.internal.common.transaction.TransactionStateHandler;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/stripeterminal/internal/common/transaction/RemoveHandler;", "Lcom/stripe/stripeterminal/internal/common/transaction/TransactionStateHandler;", "readerController", "Lcom/stripe/core/hardware/ReaderController;", "(Lcom/stripe/core/hardware/ReaderController;)V", "onApplicationDataUpdate", "", "new", "Lcom/stripe/stripeterminal/internal/common/transaction/ApplicationData;", "old", "common_publish"})
public final class RemoveHandler
extends TransactionStateHandler {
    @NotNull
    private final ReaderController readerController;

    @Inject
    public RemoveHandler(@NotNull ReaderController readerController) {
        Intrinsics.checkNotNullParameter((Object)readerController, (String)"readerController");
        super(TransactionState.REMOVE);
        this.readerController = readerController;
    }

    @Override
    public void onApplicationDataUpdate(@NotNull ApplicationData applicationData, @Nullable ApplicationData old) {
        Intrinsics.checkNotNullParameter((Object)applicationData, (String)"new");
        boolean isCardRemoved = applicationData.getCardStatus() == CardStatus.NO_CARD;
        ConnectionSummary connectionSummary = applicationData.getConnectionSummary();
        if ((connectionSummary != null ? connectionSummary.getState() : null) == ConnectionState.DISCONNECTING) {
            StateMachine.StateHandler.transitionTo$default(this, (Object)TransactionState.DISCONNECT, null, 2, null);
        } else if (isCardRemoved) {
            this.transitionTo(TransactionState.EMPTY, "Card removed, transaction already cancelled");
        }
    }
}

