/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.transaction;

import com.neovisionaries.i18n.CurrencyCode;
import com.stripe.core.hardware.ReaderController;
import com.stripe.core.hardware.tipping.InvalidTipConfig;
import com.stripe.core.hardware.tipping.LegacyNoTipSelected;
import com.stripe.core.hardware.tipping.LegacyTipSelected;
import com.stripe.core.hardware.tipping.LegacyTipSelectionFailure;
import com.stripe.core.hardware.tipping.TipConfigValidationResult;
import com.stripe.core.hardware.tipping.TipConfigValidationResultKt;
import com.stripe.core.transaction.SettingsRepository;
import com.stripe.core.transaction.Summary;
import com.stripe.core.transaction.TransactionRepository;
import com.stripe.jvmcore.currency.Amount;
import com.stripe.jvmcore.hardware.ReaderConfiguration;
import com.stripe.proto.terminal.terminal.pub.message.config.TippingConfigPb;
import com.stripe.stripeterminal.internal.common.transaction.ApplicationData;
import com.stripe.stripeterminal.internal.common.transaction.TransactionState;
import com.stripe.stripeterminal.internal.common.transaction.TransactionStateHandler;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0016J\u001c\u0010\u000e\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/stripe/stripeterminal/internal/common/transaction/TippingSelectionHandler;", "Lcom/stripe/stripeterminal/internal/common/transaction/TransactionStateHandler;", "readerController", "Lcom/stripe/core/hardware/ReaderController;", "transactionRepository", "Lcom/stripe/core/transaction/TransactionRepository;", "settingsRepository", "Lcom/stripe/core/transaction/SettingsRepository;", "(Lcom/stripe/core/hardware/ReaderController;Lcom/stripe/core/transaction/TransactionRepository;Lcom/stripe/core/transaction/SettingsRepository;)V", "onApplicationDataUpdate", "", "new", "Lcom/stripe/stripeterminal/internal/common/transaction/ApplicationData;", "old", "onEnter", "current", "from", "Lcom/stripe/stripeterminal/internal/common/transaction/TransactionState;", "common_publish"})
public final class TippingSelectionHandler
extends TransactionStateHandler {
    @NotNull
    private final ReaderController readerController;
    @NotNull
    private final TransactionRepository transactionRepository;
    @NotNull
    private final SettingsRepository settingsRepository;

    @Inject
    public TippingSelectionHandler(@NotNull ReaderController readerController, @NotNull TransactionRepository transactionRepository, @NotNull SettingsRepository settingsRepository) {
        Intrinsics.checkNotNullParameter((Object)readerController, (String)"readerController");
        Intrinsics.checkNotNullParameter((Object)transactionRepository, (String)"transactionRepository");
        Intrinsics.checkNotNullParameter((Object)settingsRepository, (String)"settingsRepository");
        super(TransactionState.TIPPING_SELECTION);
        this.readerController = readerController;
        this.transactionRepository = transactionRepository;
        this.settingsRepository = settingsRepository;
    }

    @Override
    public void onEnter(@Nullable ApplicationData current, @Nullable TransactionState from) {
        Amount amount;
        Object object = current;
        ReaderConfiguration readerConfiguration = object != null && (object = ((ApplicationData)object).getSummary()) != null ? ((Summary)object).getReaderConfiguration() : null;
        Object object2 = current;
        Amount amount2 = object2 != null && (object2 = ((ApplicationData)object2).getSummary()) != null ? ((Summary)object2).getAmount() : (amount = null);
        if (amount == null) {
            this.transitionTo(TransactionState.COLLECT, "Unexpected null amount");
            return;
        }
        CurrencyCode currency = amount.getCurrency();
        if (currency == null) {
            this.transitionTo(TransactionState.COLLECT, "Unexpected null currency");
            return;
        }
        if (readerConfiguration == null) {
            this.transitionTo(TransactionState.COLLECT, "Unexpected null readerConfiguration");
            return;
        }
        TippingConfigPb.LocalizedTippingConfig localizedTippingConfig = this.settingsRepository.getTippingConfig().localized_tipping_config.get(amount.getCurrencyCode());
        if (localizedTippingConfig == null) {
            this.transitionTo(TransactionState.COLLECT, "localizedTippingConfig = null. no tipping config for this locale");
            return;
        }
        if (localizedTippingConfig.fixed_percentage != null) {
            TransactionStateHandler.Companion.getLOGGER$common_publish().i("Processing fixed percentage tip", new Pair[0]);
        } else if (localizedTippingConfig.fixed_amount != null) {
            TransactionStateHandler.Companion.getLOGGER$common_publish().i("Processing fixed amount tip", new Pair[0]);
        } else if (localizedTippingConfig.smart_tip != null) {
            TransactionStateHandler.Companion.getLOGGER$common_publish().i("Processing smart tip", new Pair[0]);
        }
        TipConfigValidationResult tipConfigValidationResult = TipConfigValidationResultKt.generateValidatedConfig(localizedTippingConfig, amount);
        TransactionStateHandler.Companion.getLOGGER$common_publish().i("Tip config result: " + tipConfigValidationResult, new Pair[0]);
        if (tipConfigValidationResult instanceof InvalidTipConfig) {
            this.transitionTo(TransactionState.COLLECT, "Invalid tip config. Reason: " + (Object)((Object)((InvalidTipConfig)tipConfigValidationResult).getReason()));
        } else {
            this.readerController.startTippingSelection(readerConfiguration, tipConfigValidationResult);
        }
    }

    @Override
    public void onApplicationDataUpdate(@NotNull ApplicationData applicationData, @Nullable ApplicationData old) {
        Intrinsics.checkNotNullParameter((Object)applicationData, (String)"new");
        Object object = applicationData.getSummary();
        if (object == null || (object = ((Summary)object).getTipSelectionResult()) == null) {
            return;
        }
        Object tipSelectionResult = object;
        Amount amount = applicationData.getSummary().getAmount();
        CurrencyCode currencyCode = amount != null ? amount.getCurrency() : null;
        Object object2 = tipSelectionResult;
        if (object2 instanceof LegacyTipSelected) {
            if (currencyCode == null) {
                this.transitionTo(TransactionState.COLLECT, "Unexpected null currencyCode");
                return;
            }
            Amount tipAmount = new Amount(((LegacyTipSelected)tipSelectionResult).getTipsAmount(), currencyCode);
            this.transactionRepository.setAmountTip(tipAmount);
            this.transitionTo(TransactionState.COLLECT, "Tip selected by customer");
        } else if (object2 instanceof LegacyNoTipSelected) {
            if (currencyCode == null) {
                this.transitionTo(TransactionState.COLLECT, "Unexpected null currencyCode");
                return;
            }
            Amount tipAmount = new Amount(0L, currencyCode);
            this.transactionRepository.setAmountTip(tipAmount);
            this.transitionTo(TransactionState.COLLECT, "No tip selected by customer");
        } else if (object2 instanceof LegacyTipSelectionFailure) {
            this.transitionTo(TransactionState.COLLECT, "Error while selecting a tip - " + (Object)((Object)((LegacyTipSelectionFailure)tipSelectionResult).getTippingSelectionFailureReason()));
        }
    }
}

