/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.usb;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import com.stripe.core.device.BuildValues;
import com.stripe.jvmcore.dagger.ForApplication;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B!\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\f0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012J\u0006\u0010\u0013\u001a\u00020\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/stripe/stripeterminal/internal/common/usb/UsbPermissionReceiverManager;", "", "context", "Landroid/content/Context;", "usbManager", "Landroid/hardware/usb/UsbManager;", "buildValues", "Lcom/stripe/core/device/BuildValues;", "(Landroid/content/Context;Landroid/hardware/usb/UsbManager;Lcom/stripe/core/device/BuildValues;)V", "receiver", "Lcom/stripe/stripeterminal/internal/common/usb/UsbPermissionReceiverManager$UsbPermissionReceiver;", "startListening", "", "usbDevice", "Landroid/hardware/usb/UsbDevice;", "onGranted", "Lkotlin/Function1;", "onDenied", "Lkotlin/Function0;", "stopListening", "Companion", "UsbPermissionReceiver", "common_publish"})
public final class UsbPermissionReceiverManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final UsbManager usbManager;
    @NotNull
    private final BuildValues buildValues;
    @Nullable
    private UsbPermissionReceiver receiver;
    @NotNull
    public static final String ACTION_USB_PERMISSION = "com.stripe.terminal.USB_PERMISSION";

    @Inject
    public UsbPermissionReceiverManager(@ForApplication @NotNull Context context, @NotNull UsbManager usbManager, @NotNull BuildValues buildValues) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)usbManager, (String)"usbManager");
        Intrinsics.checkNotNullParameter((Object)buildValues, (String)"buildValues");
        this.context = context;
        this.usbManager = usbManager;
        this.buildValues = buildValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startListening(@NotNull UsbDevice usbDevice, @NotNull Function1<? super UsbDevice, Unit> onGranted, @NotNull Function0<Unit> onDenied) {
        Intrinsics.checkNotNullParameter((Object)usbDevice, (String)"usbDevice");
        Intrinsics.checkNotNullParameter(onGranted, (String)"onGranted");
        Intrinsics.checkNotNullParameter(onDenied, (String)"onDenied");
        UsbPermissionReceiverManager usbPermissionReceiverManager = this;
        synchronized (usbPermissionReceiverManager) {
            boolean bl = false;
            if (this.receiver != null) {
                this.stopListening();
            }
            if (this.usbManager.hasPermission(usbDevice)) {
                onGranted.invoke((Object)usbDevice);
            } else {
                int pendingIntentFlags = this.buildValues.isAtLeast(31) ? 0xA000000 : 0x8000000;
                PendingIntent intent = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION).setPackage(this.context.getPackageName()), (int)pendingIntentFlags);
                int receiverFlags = this.buildValues.isAtLeast(34) ? 2 : 0;
                this.receiver = new UsbPermissionReceiver(usbDevice, onGranted, onDenied);
                if (this.buildValues.isAtLeast(26)) {
                    this.context.registerReceiver((BroadcastReceiver)this.receiver, new IntentFilter(ACTION_USB_PERMISSION), receiverFlags);
                } else {
                    this.context.registerReceiver((BroadcastReceiver)this.receiver, new IntentFilter(ACTION_USB_PERMISSION));
                }
                this.usbManager.requestPermission(usbDevice, intent);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopListening() {
        UsbPermissionReceiverManager usbPermissionReceiverManager = this;
        synchronized (usbPermissionReceiverManager) {
            Unit unit;
            boolean bl = false;
            UsbPermissionReceiver usbPermissionReceiver = this.receiver;
            if (usbPermissionReceiver != null) {
                UsbPermissionReceiver it = usbPermissionReceiver;
                boolean bl2 = false;
                this.context.unregisterReceiver((BroadcastReceiver)it);
                this.receiver = null;
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/stripeterminal/internal/common/usb/UsbPermissionReceiverManager$Companion;", "", "()V", "ACTION_USB_PERMISSION", "", "common_publish"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stripe/stripeterminal/internal/common/usb/UsbPermissionReceiverManager$UsbPermissionReceiver;", "Landroid/content/BroadcastReceiver;", "usbDevice", "Landroid/hardware/usb/UsbDevice;", "onGranted", "Lkotlin/Function1;", "", "onDenied", "Lkotlin/Function0;", "(Landroid/hardware/usb/UsbDevice;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "onReceive", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "common_publish"})
    public static final class UsbPermissionReceiver
    extends BroadcastReceiver {
        @NotNull
        private final UsbDevice usbDevice;
        @NotNull
        private final Function1<UsbDevice, Unit> onGranted;
        @NotNull
        private final Function0<Unit> onDenied;

        public UsbPermissionReceiver(@NotNull UsbDevice usbDevice, @NotNull Function1<? super UsbDevice, Unit> onGranted, @NotNull Function0<Unit> onDenied) {
            Intrinsics.checkNotNullParameter((Object)usbDevice, (String)"usbDevice");
            Intrinsics.checkNotNullParameter(onGranted, (String)"onGranted");
            Intrinsics.checkNotNullParameter(onDenied, (String)"onDenied");
            this.usbDevice = usbDevice;
            this.onGranted = onGranted;
            this.onDenied = onDenied;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(@NotNull Context context, @NotNull Intent intent) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            if (Intrinsics.areEqual((Object)UsbPermissionReceiverManager.ACTION_USB_PERMISSION, (Object)intent.getAction())) {
                UsbPermissionReceiver usbPermissionReceiver = this;
                synchronized (usbPermissionReceiver) {
                    boolean bl = false;
                    if (intent.getBooleanExtra("permission", false)) {
                        this.onGranted.invoke((Object)this.usbDevice);
                    } else {
                        this.onDenied.invoke();
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        }
    }
}

