/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.validators;

import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.stripeterminal.external.models.TerminalException;
import com.stripe.stripeterminal.internal.common.validators.TipEligibleValidator;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/stripe/stripeterminal/internal/common/validators/DefaultTipEligibleValidator;", "Lcom/stripe/stripeterminal/internal/common/validators/TipEligibleValidator;", "()V", "validateTipEligibleAmount", "", "tipEligibleAmount", "", "skipTipping", "", "currencyCode", "", "(Ljava/lang/Long;ZLjava/lang/String;)V", "Companion", "common_publish"})
public final class DefaultTipEligibleValidator
implements TipEligibleValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(DefaultTipEligibleValidator.class);
    private static final long CHARGE_MAX = 99999999L;

    @Inject
    public DefaultTipEligibleValidator() {
    }

    @Override
    public void validateTipEligibleAmount(@Nullable Long tipEligibleAmount, boolean skipTipping, @NotNull String currencyCode) {
        Intrinsics.checkNotNullParameter((Object)currencyCode, (String)"currencyCode");
        Long l2 = tipEligibleAmount;
        if (l2 != null) {
            long $this$validateTipEligibleAmount_u24lambda_u243 = ((Number)l2).longValue();
            boolean bl = false;
            if ($this$validateTipEligibleAmount_u24lambda_u243 < 0L) {
                TerminalException terminalException;
                TerminalException it = terminalException = new TerminalException(TerminalException.TerminalErrorCode.INVALID_TIP_PARAMETER, "Invalid tip eligible amount. Tip eligible amount must be greater than or equal to 0 in " + currencyCode + '.', null, null, 12, null);
                boolean bl2 = false;
                LOGGER.e("tipEligibleAmount less than 0: " + $this$validateTipEligibleAmount_u24lambda_u243, it, new Pair[0]);
                throw (Throwable)terminalException;
            }
            if ($this$validateTipEligibleAmount_u24lambda_u243 > 0L && skipTipping) {
                TerminalException terminalException;
                TerminalException it = terminalException = new TerminalException(TerminalException.TerminalErrorCode.INVALID_TIP_PARAMETER, "Invalid combination of skip_tipping and eligible_amount. If eligible_amount is greater than 0, skip_tipping cannot be set to true.", null, null, 12, null);
                boolean bl3 = false;
                LOGGER.e("tipEligibleAmount > 0 and skipTipping == true: " + $this$validateTipEligibleAmount_u24lambda_u243, it, new Pair[0]);
                throw (Throwable)terminalException;
            }
            if ($this$validateTipEligibleAmount_u24lambda_u243 > 99999999L) {
                TerminalException terminalException;
                TerminalException it = terminalException = new TerminalException(TerminalException.TerminalErrorCode.INVALID_TIP_PARAMETER, "Invalid tip eligible amount. Tip eligible amount must be less than 99999999 in " + currencyCode + '.', null, null, 12, null);
                boolean bl4 = false;
                LOGGER.e("tipEligibleAmount > max value: " + $this$validateTipEligibleAmount_u24lambda_u243, it, new Pair[0]);
                throw (Throwable)terminalException;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/stripeterminal/internal/common/validators/DefaultTipEligibleValidator$Companion;", "", "()V", "CHARGE_MAX", "", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "common_publish"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

