/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.internal.common.validators;

import android.content.Context;
import android.os.Build;
import android.os.Process;
import androidx.annotation.RequiresApi;
import com.stripe.stripeterminal.external.models.TerminalException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\nH\u0003J\b\u0010\f\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/stripe/stripeterminal/internal/common/validators/PermissionsValidator;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "isGranted", "", "permission", "", "validatePermissions", "", "validatePermissions31", "validatePermissionsPre31", "common_publish"})
public final class PermissionsValidator {
    @NotNull
    private final Context context;

    public PermissionsValidator(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    public final void validatePermissions() {
        this.validatePermissionsPre31();
        if (Build.VERSION.SDK_INT >= 31) {
            this.validatePermissions31();
        }
    }

    private final boolean isGranted(String permission) {
        return this.context.checkPermission(permission, Process.myPid(), Process.myUid()) == 0;
    }

    private final void validatePermissionsPre31() {
        boolean hasGpsModule = this.context.getPackageManager().hasSystemFeature("android.hardware.location.gps");
        boolean coarseLocationGranted = this.isGranted("android.permission.ACCESS_COARSE_LOCATION");
        boolean fineLocationGranted = this.isGranted("android.permission.ACCESS_FINE_LOCATION");
        if (!coarseLocationGranted || hasGpsModule && !fineLocationGranted) {
            throw new TerminalException(TerminalException.TerminalErrorCode.LOCATION_SERVICES_DISABLED, "You must request location permissions before initializing the Terminal", null, null, 12, null);
        }
    }

    @RequiresApi(value=31)
    private final void validatePermissions31() {
        boolean bluetoothConnectGranted = this.isGranted("android.permission.BLUETOOTH_CONNECT");
        boolean bluetoothScanGranted = this.isGranted("android.permission.BLUETOOTH_SCAN");
        if (!bluetoothConnectGranted || !bluetoothScanGranted) {
            throw new TerminalException(TerminalException.TerminalErrorCode.BLUETOOTH_PERMISSION_DENIED, "You must request bluetooth permissions before initializing the Terminal", null, null, 12, null);
        }
    }
}

